import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { useImperativeHandle, useState } from "react";
import JobsManagement from "./components/JobsManagement/JobsManagement";
import JobsManagementEnvelopeViewDriver from "./JobsManagementEnvelopeViewDriver";
import "@patternfly/patternfly/patternfly.css";
export const JobsManagementEnvelopeView = React.forwardRef((props, forwardedRef) => {
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    useImperativeHandle(forwardedRef, () => ({
        initialize: () => {
            setEnvelopeConnectedToChannel(true);
        },
    }), []);
    return (_jsx(React.Fragment, { children: _jsx(JobsManagement, { isEnvelopeConnectedToChannel: isEnvelopeConnectedToChannel, driver: new JobsManagementEnvelopeViewDriver(props.channelApi) }) }));
});
export default JobsManagementEnvelopeView;
//# sourceMappingURL=JobsManagementEnvelopeView.js.map