import { JSONSchema } from "vscode-json-languageservice";
import { TextDocument } from "vscode-languageserver-textdocument";
import { CodeLens, CompletionItem, CompletionItemKind, Diagnostic, Position, Range } from "vscode-languageserver-types";
import { ELsCodeCompletionStrategy, ELsNode, ELsShouldCreateCodelensArgs, IEditorLanguageService, ShouldCompleteArgs, TranslateArgs } from "./types";
export declare class EditorJsonLanguageService implements IEditorLanguageService {
    protected readonly ls: IEditorLanguageService;
    protected readonly codeCompletionStrategy: ELsCodeCompletionStrategy;
    constructor(args: {
        ls: IEditorLanguageService;
        codeCompletionStrategy: ELsCodeCompletionStrategy;
    });
    getCompletionItems(args: {
        content: string;
        uri: string;
        cursorPosition: Position;
        cursorWordRange: Range;
    }): Promise<CompletionItem[]>;
    getCodeLenses(args: {
        content: string;
        uri: string;
    }): Promise<CodeLens[]>;
    getDiagnostics(args: {
        content: string;
        uriPath: string;
        getSchemaDiagnostics(args: {
            textDocument: TextDocument;
            fileMatch: string[];
            jsonSchema: JSONSchema;
        }): Promise<Diagnostic[]>;
    }): Promise<Diagnostic[]>;
    getSchemaDiagnostics(args: {
        textDocument: TextDocument;
        fileMatch: string[];
        jsonSchema: JSONSchema;
    }): Promise<Diagnostic[]>;
    dispose(): void;
}
export declare class EditorJsonCodeCompletionStrategy implements ELsCodeCompletionStrategy {
    translate(args: TranslateArgs): string;
    formatLabel(label: string, completionItemKind: CompletionItemKind): string;
    getStartNodeValuePosition(document: TextDocument, node: ELsNode): Position | undefined;
    shouldComplete(args: ShouldCompleteArgs): boolean;
    shouldCreateCodelens(_args: ELsShouldCreateCodelensArgs): boolean;
}
export declare function parseJsonContent(content: string): ELsNode | undefined;
export declare function hasNodeComma(content: string, cursorOffset: number): boolean;
export declare function isOffsetAtLastChild(content: string, cursorOffset: number): boolean;
//# sourceMappingURL=EditorJsonLanguageService.d.ts.map