import { SCHEMA_VERSION } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
import Ajv from "ajv";
import addFormats from "ajv-formats";
export function lookupValidator(schema) {
    if (schema.$schema === SCHEMA_VERSION.DRAFT_7) {
        return new Draft7FormValidator(schema);
    }
    if (schema.$schema === SCHEMA_VERSION.DRAFT_2019_09) {
        return new Draft2019_09Validator();
    }
    console.warn(`Cannot load validator for schema version '${schema.$schema}'.`);
    return {
        validate(model) {
        },
    };
}
export class Draft7FormValidator {
    constructor(schema) {
        this.schema = schema;
        this.ajv = new Ajv({ strict: false, allErrors: true, useDefaults: true });
        addFormats(this.ajv);
        this.validator = this.ajv.compile(schema);
    }
    validate(model) {
        this.validator(model);
        if (this.validator.errors && this.validator.errors.length) {
            return { details: this.validator.errors };
        }
    }
}
export class Draft2019_09Validator {
    validate(model) {
    }
}
//# sourceMappingURL=FormValidator.js.map