import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { YardEditor } from "./YardEditor";
import { validationPromise } from "@kie-tools/yard-validator/dist/";
export class YardEditorView {
    constructor(envelopeContext, initArgs) {
        this.envelopeContext = envelopeContext;
        this.af_isReact = true;
        this.editorRef = React.createRef();
        this.initArgs = initArgs;
    }
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot, content) {
        this.path = normalizedPosixPathRelativeToTheWorkspaceRoot;
        return this.editorRef.current.setContent(normalizedPosixPathRelativeToTheWorkspaceRoot, content);
    }
    getContent() {
        return this.editorRef.current.getContent();
    }
    getPreview() {
        return this.editorRef.current.getPreview();
    }
    af_componentRoot() {
        return (_jsx(YardEditor, { ref: this.editorRef, channelType: this.initArgs.channel, onStateControlCommandUpdate: this.envelopeContext.channelApi.notifications.kogitoEditor_stateControlCommandUpdate.send, onNewEdit: this.envelopeContext.channelApi.notifications.kogitoWorkspace_newEdit.send, setNotifications: this.envelopeContext.channelApi.notifications.kogitoNotifications_setNotifications.send, isReadOnly: this.initArgs.isReadOnly }));
    }
    async undo() {
        return this.editorRef.current.undo();
    }
    async redo() {
        return this.editorRef.current.redo();
    }
    async validate() {
        let result = [];
        return this.editorRef
            .current.getContent()
            .then((value) => {
            return validationPromise(value);
        })
            .then((value) => {
            result = result.concat(value);
            return this.editorRef.current.validate();
        })
            .then((value) => {
            result = result.concat(value);
            return new Promise((resolve) => {
                resolve(result);
            });
        });
    }
    async setTheme(theme) {
        return this.editorRef.current.setTheme(theme);
    }
    moveCursorToPosition(position) {
        this.editorRef.current.moveCursorToPosition(position);
    }
}
//# sourceMappingURL=YardEditorView.js.map