import { WorkspaceDescriptor } from "../worker/api/WorkspaceDescriptor";
import { StorageService } from "./StorageService";
import { WorkspaceOrigin } from "../worker/api/WorkspaceOrigin";
import { KieSandboxWorkspacesFs } from "./KieSandboxWorkspaceFs";
import { WorkspaceDescriptorFsService } from "./WorkspaceDescriptorFsService";
import { FsSchema } from "./FsCache";
export declare class WorkspaceDescriptorService {
    private readonly descriptorFsService;
    private readonly storageService;
    constructor(descriptorFsService: WorkspaceDescriptorFsService, storageService: StorageService);
    listAll(fs: KieSandboxWorkspacesFs, schema: FsSchema): Promise<WorkspaceDescriptor[]>;
    bumpLastUpdatedDate(fs: KieSandboxWorkspacesFs, workspaceId: string): Promise<void>;
    get(fs: KieSandboxWorkspacesFs, workspaceId: string): Promise<WorkspaceDescriptor>;
    create(args: {
        fs: KieSandboxWorkspacesFs;
        origin: WorkspaceOrigin;
        preferredName?: string;
        gitAuthSessionId: string | undefined;
        gitInsecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<WorkspaceDescriptor>;
    delete(fs: KieSandboxWorkspacesFs, workspaceId: string): Promise<void>;
    rename(fs: KieSandboxWorkspacesFs, workspaceId: string, newName: string): Promise<void>;
    turnIntoGist(fs: KieSandboxWorkspacesFs, workspaceId: string, gistUrl: URL, branch: string, insecurelyDisableTlsCertificateValidation?: boolean): Promise<void>;
    turnIntoSnippet(fs: KieSandboxWorkspacesFs, workspaceId: string, snippetUrl: URL, branch: string, insecurelyDisableTlsCertificateValidation?: boolean): Promise<void>;
    turnIntoGit(fs: KieSandboxWorkspacesFs, workspaceId: string, url: URL, branch?: string, insecurelyDisableTlsCertificateValidation?: boolean): Promise<void>;
    changeGitAuthSessionId(fs: KieSandboxWorkspacesFs, workspaceId: string, gitAuthSessionId: string | undefined, insecurelyDisableTlsCertificateValidation?: boolean): Promise<void>;
    turnIntoLocal(fs: KieSandboxWorkspacesFs, workspaceId: string): Promise<void>;
    private getAbsolutePath;
    private toStorageFile;
    newWorkspaceId(): string;
}
//# sourceMappingURL=WorkspaceDescriptorService.d.ts.map