import { buildXmlQName } from "@kie-tools/xml-parser-ts/dist/qNames";
import { parseXmlHref } from "./xmlHrefs";
import { getXmlNamespaceDeclarationName } from "./xmlNamespaceDeclarations";
export function xmlHrefToQName(hrefString, rootElement) {
    const href = parseXmlHref(hrefString);
    const qNamePrefix = href.namespace
        ? getXmlNamespaceDeclarationName({ rootElement, namespace: href.namespace })
        : undefined;
    if (href.namespace && !qNamePrefix) {
        throw new Error(`Can't find namespace declaration for namespace '${href.namespace}'`);
    }
    return buildXmlQName({
        type: "xml-qname",
        localPart: href.id,
        prefix: qNamePrefix,
    });
}
//# sourceMappingURL=xmlHrefToQName.js.map