import { BoxedExpression } from "../api";
import { BeeTableRef } from "../table/BeeTable";
import { NestedExpressionContainerContextType } from "./NestedExpressionContainerContext";
import { ResizingWidth } from "./ResizingWidthsContext";
export declare function useNestedExpressionResizingWidthValue(isPivoting: boolean, nestedExpressions: BoxedExpression[], fixedColumnActualWidth: number, fixedColumnResizingWidth: ResizingWidth, fixedColumnMinWidth: number, nestedExpressionMinWidth: number, extraWidth: number, widthsById: Map<string, number[]>, nestedExpressionsExtraWidths?: Map<string, number>): number;
export declare function useNestedExpressionMinWidth(nestedExpressions: BoxedExpression[], fixedColumnResizingWidth: ResizingWidth, nestedExpressionMinWidth: number, extraWidth: number): number;
export declare function useNestedExpressionActualWidth(nestedExpressions: BoxedExpression[], fixedColumnActualWidth: number, extraWidth: number, widthsById: Map<string, number[]>): number;
export declare function useNestedExpressionContainerWithNestedExpressions({ nestedExpressions, fixedColumnActualWidth, fixedColumnResizingWidth, fixedColumnMinWidth, nestedExpressionMinWidth, extraWidth, expression, flexibleColumnIndex, widthsById, nestedExpressionsExtraWidths, }: {
    nestedExpressions: BoxedExpression[];
    fixedColumnActualWidth: number;
    fixedColumnResizingWidth: ResizingWidth;
    fixedColumnMinWidth: number;
    nestedExpressionMinWidth: number;
    extraWidth: number;
    expression: BoxedExpression;
    flexibleColumnIndex: number;
    widthsById: Map<string, number[]>;
    nestedExpressionsExtraWidths?: Map<string, number>;
}): {
    nestedExpressionContainerValue: NestedExpressionContainerContextType;
    onColumnResizingWidthChange: (args: Map<number, ResizingWidth | undefined>) => void;
    isPivoting: boolean;
};
export declare function useApportionedColumnWidthsIfNestedTable(beeTableRef: React.RefObject<BeeTableRef>, isPivoting: boolean, isNested: boolean, extraWidth: number, columns: Array<{
    minWidth: number;
    width: number | undefined;
    isFrozen?: boolean;
}>, columnResizingWidths: Map<number, ResizingWidth>, rows: any[]): void;
export declare function apportionColumnWidths(nextTotalWidth: number, columns: {
    currentWidth: number;
    minWidth: number;
    isFrozen: boolean;
}[]): number[];
export declare function useNestedTableLastColumnMinWidth(columnResizingWidths: Map<number, ResizingWidth>): number | undefined;
//# sourceMappingURL=Hooks.d.ts.map