import { jsx as _jsx } from "react/jsx-runtime";
import Moment from "react-moment";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
export const getFormTypeLabel = (value) => {
    switch (value) {
        case "HTML":
            return _jsx(Label, { variant: "outline", children: "HTML" });
        case "TSX":
            return _jsx(Label, { variant: "outline", children: "REACT" });
        default:
            return value;
    }
};
export const getFormNameColumn = (selectForm) => {
    return {
        label: "Name",
        path: "name",
        bodyCellTransformer: (cellValue, rowForm) => {
            return (_jsx("a", { onClick: () => selectForm(rowForm), children: _jsx("strong", { children: cellValue }) }));
        },
        isSortable: true,
    };
};
export const getDateColumn = (columnPath, columnLabel) => {
    return {
        label: columnLabel,
        path: columnPath,
        bodyCellTransformer: (value) => _jsx(Moment, { fromNow: true, children: new Date(`${value}`) }),
        isSortable: true,
    };
};
export const getFormTypeColumn = () => {
    return {
        label: "Type",
        path: "type",
        bodyCellTransformer: (cellValue) => getFormTypeLabel(cellValue),
        isSortable: true,
    };
};
//# sourceMappingURL=FormsListUtils.js.map