import { CompoundPredicate, False, SimplePredicate, SimpleSetPredicate, True, } from "@kie-tools/pmml-editor-marshaller";
import { ValidationEntry } from "./ValidationRegistry";
import { ValidationLevel } from "./ValidationLevel";
import { Builder } from "../paths";
export const validateAttribute = (modelIndex, scorecardProperties, characteristicIndex, characteristic, isPartialScoreRequired, attributeIndex, attribute, miningFields, validationRegistry) => {
    if (scorecardProperties.useReasonCodes !== false &&
        characteristic.reasonCode === undefined &&
        attribute.reasonCode === undefined) {
        validationRegistry.set(Builder()
            .forModel(modelIndex)
            .forCharacteristics()
            .forCharacteristic(characteristicIndex)
            .forAttribute(attributeIndex)
            .forReasonCode()
            .build(), new ValidationEntry(ValidationLevel.WARNING, `"${characteristic.name} attribute: Reason code is required.`));
    }
    if (isPartialScoreRequired && attribute.partialScore === undefined) {
        validationRegistry.set(Builder()
            .forModel(modelIndex)
            .forCharacteristics()
            .forCharacteristic(characteristicIndex)
            .forAttribute(attributeIndex)
            .forPartialScore()
            .build(), new ValidationEntry(ValidationLevel.WARNING, `"${characteristic.name} attribute: Partial score is required.`));
    }
    const fieldNames = miningFields.map((miningField) => miningField.name);
    validatePredicate(Builder()
        .forModel(modelIndex)
        .forCharacteristics()
        .forCharacteristic(characteristicIndex)
        .forAttribute(attributeIndex)
        .forPredicate(), attribute.predicate, fieldNames, validationRegistry);
};
export const validateAttributes = (modelIndex, scorecardProperties, characteristicIndex, characteristic, miningFields, validationRegistry) => {
    const isPartialScoreRequired = characteristic.Attribute.filter((attribute) => attribute.partialScore !== undefined).length > 0;
    characteristic.Attribute.forEach((attribute, attributeIndex) => validateAttribute(modelIndex, scorecardProperties, characteristicIndex, characteristic, isPartialScoreRequired, attributeIndex, attribute, miningFields, validationRegistry));
};
const validatePredicate = (pathBuilder, predicate, fieldNames, validationRegistry) => {
    var _a;
    if (predicate === undefined) {
        validationRegistry.set(pathBuilder.build(), new ValidationEntry(ValidationLevel.WARNING, `No predicate defined.`));
        return;
    }
    else if (predicate instanceof True) {
        return;
    }
    else if (predicate instanceof False) {
        return;
    }
    else if (predicate instanceof SimpleSetPredicate) {
        if (fieldNames.filter((fieldName) => fieldName === predicate.field).length === 0) {
            validationRegistry.set(pathBuilder.forFieldName().build(), new ValidationEntry(ValidationLevel.WARNING, `"${predicate.field}" cannot be found in the Mining Schema.`));
        }
    }
    else if (predicate instanceof SimplePredicate) {
        if (fieldNames.filter((fieldName) => fieldName === predicate.field).length === 0) {
            validationRegistry.set(pathBuilder.forFieldName().build(), new ValidationEntry(ValidationLevel.WARNING, `"${predicate.field}" cannot be found in the Mining Schema.`));
        }
    }
    else if (predicate instanceof CompoundPredicate) {
        (_a = predicate.predicates) === null || _a === void 0 ? void 0 : _a.forEach((p, i) => validatePredicate(pathBuilder.forPredicate(i), p, fieldNames, validationRegistry));
    }
};
export const areAttributesReasonCodesMissing = (attributes) => {
    if (attributes.length === 0) {
        return true;
    }
    return !attributes.every((attribute) => attribute.reasonCode !== undefined);
};
//# sourceMappingURL=Attributes.js.map