import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useState } from "react";
import { v4 as uuid } from "uuid";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { Select, SelectOption, SelectVariant, } from "@patternfly/react-core/dist/js/components/Select";
const MiningSchemaAddFields = ({ options, onAdd, isDisabled }) => {
    const [isOpen, setIsOpen] = useState(false);
    const [selectOptions, setSelectOptions] = useState([]);
    const [selected, setSelected] = useState([]);
    const [selectKey, setSelectKey] = useState(uuid());
    const onToggle = (openStatus) => {
        setIsOpen(openStatus);
    };
    const onSelect = (event, selection) => {
        if (selected.includes(selection.toString())) {
            const newSelections = selected.filter((item) => item !== selection);
            setSelected(newSelections);
        }
        else {
            setSelected([...selected, selection.toString()]);
        }
    };
    const handleAdd = () => {
        onAdd(selected);
        clearSelection();
    };
    const addAllFields = () => {
        const availableOptions = selectOptions.filter((item) => !item.disabled);
        if (availableOptions.length) {
            onAdd(availableOptions.map((item) => item.value));
        }
    };
    const clearSelection = () => {
        setSelected([]);
        setIsOpen(false);
    };
    useEffect(() => {
        setSelectOptions(options.map((option) => ({
            value: option.name,
            disabled: option.isSelected,
        })));
        setSelectKey(uuid());
    }, [options]);
    return (_jsx("section", { "data-ouia-component-id": "mining-toolbar", children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { isFilled: true, children: _jsx(Select, { variant: SelectVariant.typeaheadMulti, typeAheadAriaLabel: "Select fields", onToggle: onToggle, toggleId: "select-mining-field", onSelect: onSelect, onClear: clearSelection, selections: selected, isOpen: isOpen, "aria-labelledby": "Select fields to add", placeholderText: "Select fields", isDisabled: isDisabled, ouiaId: "select-mining-field", children: selectOptions.map((option, index) => (_jsx(SelectOption, { isDisabled: option.disabled, value: option.value, "data-ouia-component-id": option.value, "data-ouia-component-type": "select-option" }, index))) }, selectKey) }), _jsx(SplitItem, { children: _jsx(Button, { variant: "primary", onClick: handleAdd, isDisabled: isDisabled, ouiaId: "add-mining-field", children: "Add Field(s)" }) }), _jsx(SplitItem, { children: _jsx(Button, { variant: "secondary", onClick: addAllFields, isDisabled: isDisabled, ouiaId: "add-all-fields", children: "Add All Fields" }) })] }) }));
};
export default MiningSchemaAddFields;
//# sourceMappingURL=MiningSchemaAddFields.js.map