import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useCallback, useEffect, useMemo, useState } from "react";
import { Stack, StackItem } from "@patternfly/react-core/dist/js/layouts/Stack";
import { Operation } from "../Operation";
import { CharacteristicsTable } from "./CharacteristicsTable";
import "./CharacteristicsContainer.scss";
import { CSSTransition, SwitchTransition } from "react-transition-group";
import { Actions } from "../../../reducers";
import { AttributeEditor, AttributeToolbar, CharacteristicsToolbar, EmptyStateNoCharacteristics, EmptyStateNoMatchingCharacteristics, } from "../molecules";
import { isEqual } from "lodash";
import { findIncrementalName } from "../../../PMMLModelHelper";
import { useBatchDispatch, useHistoryService } from "../../../history";
import { useOperation } from "../OperationContext";
import { fromText } from "./PredicateConverter";
var set = Reflect.set;
var get = Reflect.get;
export const CharacteristicsContainer = (props) => {
    const { modelIndex, areReasonCodesUsed, scorecardBaselineScore, characteristics } = props;
    const { setActiveOperation } = useOperation();
    const { service, getCurrentState } = useHistoryService();
    const dispatch = useBatchDispatch(service, getCurrentState);
    const [filter, setFilter] = useState("");
    const [filteredCharacteristics, setFilteredCharacteristics] = useState([]);
    const [selectedCharacteristicIndex, setSelectedCharacteristicIndex] = useState(undefined);
    const [selectedAttributeIndex, setSelectedAttributeIndex] = useState(undefined);
    const [viewSection, setViewSection] = useState("overview");
    useEffect(() => applyFilter(), [modelIndex, characteristics]);
    const setLowercaseTrimmedFilter = (_filter) => {
        setFilter(_filter.toLowerCase().trim());
    };
    const applyFilter = () => {
        const _filteredCharacteristics = characteristics === null || characteristics === void 0 ? void 0 : characteristics.map((_characteristic, index) => ({ index: index, characteristic: _characteristic })).filter((ic) => {
            const _characteristicName = ic.characteristic.name;
            return _characteristicName === null || _characteristicName === void 0 ? void 0 : _characteristicName.toLowerCase().includes(filter);
        });
        setFilteredCharacteristics(_filteredCharacteristics !== null && _filteredCharacteristics !== void 0 ? _filteredCharacteristics : []);
    };
    const getTransition = (_viewSection) => {
        if (_viewSection === "overview") {
            return "characteristics-container__overview";
        }
        else {
            return "characteristics-container__attribute";
        }
    };
    const onViewOverviewView = () => {
        setActiveOperation(Operation.UPDATE_CHARACTERISTIC);
        setViewSection("overview");
    };
    const onViewAttribute = (index) => {
        if (index === undefined) {
            return;
        }
        setSelectedAttributeIndex(index);
        setViewSection("attribute");
    };
    const validateCharacteristicName = useCallback((editIndex, name) => {
        if (name === undefined || name.trim() === "") {
            return false;
        }
        const matching = characteristics.filter((c, index) => editIndex !== index && c.name === name);
        return matching.length === 0;
    }, [characteristics]);
    const onAddCharacteristic = useCallback(() => {
        const numberOfCharacteristics = characteristics === null || characteristics === void 0 ? void 0 : characteristics.length;
        if (numberOfCharacteristics !== undefined) {
            setSelectedCharacteristicIndex(numberOfCharacteristics);
            const existingNames = characteristics.map((c) => { var _a; return (_a = c.name) !== null && _a !== void 0 ? _a : ""; });
            const newCharacteristicName = findIncrementalName("New characteristic", existingNames, 1);
            dispatch({
                type: Actions.Scorecard_AddCharacteristic,
                payload: {
                    modelIndex: modelIndex,
                    name: newCharacteristicName,
                    baselineScore: undefined,
                    reasonCode: undefined,
                    Attribute: [],
                },
            });
            setActiveOperation(Operation.UPDATE_CHARACTERISTIC);
            setLowercaseTrimmedFilter("");
        }
    }, [characteristics]);
    const deleteCharacteristic = useCallback((characteristicIndex) => {
        dispatch({
            type: Actions.Scorecard_DeleteCharacteristic,
            payload: {
                modelIndex: modelIndex,
                characteristicIndex: characteristicIndex,
            },
        });
    }, [characteristics]);
    const onAddAttribute = useCallback(() => {
        if (selectedCharacteristicIndex === undefined) {
            return;
        }
        const numberOfAttributes = characteristics[selectedCharacteristicIndex].Attribute.length;
        setSelectedAttributeIndex(numberOfAttributes);
        dispatch({
            type: Actions.Scorecard_AddAttribute,
            payload: {
                modelIndex: modelIndex,
                characteristicIndex: selectedCharacteristicIndex,
                predicate: fromText("True"),
                partialScore: undefined,
                reasonCode: undefined,
            },
        });
        setActiveOperation(Operation.UPDATE_ATTRIBUTE);
        setViewSection("attribute");
    }, [characteristics, selectedCharacteristicIndex]);
    const onCommitAndClose = () => {
        onCommit({});
        onCancel();
    };
    const onCommit = useCallback((partial) => {
        if (selectedCharacteristicIndex === undefined) {
            return;
        }
        const characteristic = characteristics[selectedCharacteristicIndex];
        const existingPartial = {};
        Object.keys(partial).forEach((key) => set(existingPartial, key, get(characteristic, key)));
        if (!isEqual(partial, existingPartial)) {
            dispatch({
                type: Actions.Scorecard_UpdateCharacteristic,
                payload: {
                    modelIndex: modelIndex,
                    characteristicIndex: selectedCharacteristicIndex,
                    ...characteristic,
                    ...partial,
                },
            });
        }
    }, [characteristics, selectedCharacteristicIndex]);
    const onCancel = () => {
        setSelectedCharacteristicIndex(undefined);
        setActiveOperation(Operation.NONE);
    };
    const onUpdateAttribute = useCallback((_index, _content) => {
        if (_index === undefined) {
            dispatch({
                type: Actions.Scorecard_AddAttribute,
                payload: {
                    modelIndex: modelIndex,
                    characteristicIndex: selectedCharacteristicIndex,
                    predicate: _content.predicate,
                    partialScore: _content.partialScore,
                    reasonCode: _content.reasonCode,
                },
            });
        }
        else {
            dispatch({
                type: Actions.Scorecard_UpdateAttribute,
                payload: {
                    modelIndex: modelIndex,
                    characteristicIndex: selectedCharacteristicIndex,
                    attributeIndex: selectedAttributeIndex,
                    predicate: _content.predicate,
                    partialScore: _content.partialScore,
                    reasonCode: _content.reasonCode,
                },
            });
        }
    }, [modelIndex, selectedCharacteristicIndex, selectedAttributeIndex]);
    const emptyStateProvider = useMemo(() => {
        if (characteristics.length === 0) {
            return _jsx(EmptyStateNoCharacteristics, { addCharacteristic: onAddCharacteristic });
        }
        else {
            return (_jsx(Stack, { hasGutter: true, children: _jsxs(StackItem, { children: [_jsx(CharacteristicsToolbar, { filter: filter, setFilter: setLowercaseTrimmedFilter, onFilter: applyFilter, onAddCharacteristic: onAddCharacteristic }), _jsx(EmptyStateNoMatchingCharacteristics, {})] }) }));
        }
    }, [filter, characteristics]);
    return (_jsxs("div", { className: "characteristics-container", "data-ouia-component-id": "characteristics", children: [filteredCharacteristics.length === 0 && emptyStateProvider, filteredCharacteristics.length > 0 && (_jsx(SwitchTransition, { mode: "out-in", children: _jsx(CSSTransition, { timeout: {
                        enter: 230,
                        exit: 100,
                    }, classNames: getTransition(viewSection), children: _jsxs(_Fragment, { children: [viewSection === "overview" && (_jsxs(Stack, { children: [_jsx(StackItem, { children: _jsx(CharacteristicsToolbar, { filter: filter, setFilter: setLowercaseTrimmedFilter, onFilter: applyFilter, onAddCharacteristic: onAddCharacteristic }) }), _jsx(StackItem, { className: "characteristics-container__overview", children: _jsx(CharacteristicsTable, { modelIndex: modelIndex, areReasonCodesUsed: areReasonCodesUsed, scorecardBaselineScore: scorecardBaselineScore, characteristics: filteredCharacteristics, characteristicsUnfilteredLength: characteristics.length, selectedCharacteristicIndex: selectedCharacteristicIndex, setSelectedCharacteristicIndex: setSelectedCharacteristicIndex, validateCharacteristicName: validateCharacteristicName, viewAttribute: onViewAttribute, deleteCharacteristic: deleteCharacteristic, onAddAttribute: onAddAttribute, onCommitAndClose: onCommitAndClose, onCommit: onCommit, onCancel: onCancel }) })] })), viewSection === "attribute" && (_jsxs(Stack, { hasGutter: true, children: [_jsx(StackItem, { children: _jsx(AttributeToolbar, { viewOverview: onViewOverviewView }) }), _jsx(StackItem, { className: "characteristics-container__attribute", children: _jsx(AttributeEditor, { modelIndex: modelIndex, characteristicIndex: selectedCharacteristicIndex, attributeIndex: selectedAttributeIndex, areReasonCodesUsed: areReasonCodesUsed, onCancel: onViewOverviewView, onCommit: onUpdateAttribute }) })] }))] }) }, viewSection) }))] }));
};
//# sourceMappingURL=CharacteristicsContainer.js.map