import { ScopeImpl } from "./ScopeImpl";
import { ReservedWords } from "../ReservedWords";
import { FunctionSymbol } from "./FunctionSymbol";
export class Scopes {
    constructor() {
        this.builtInScope = new ScopeImpl("<builtin>");
        this.globalScope = new ScopeImpl("<global>", this.builtInScope);
        ReservedWords.FeelFunctions.forEach((word) => {
            this.globalScope.define(new FunctionSymbol(word));
        });
    }
    getBuiltInScope() {
        return this.builtInScope;
    }
    getGlobalScope() {
        return this.builtInScope.getChildScopes().get("<global>");
    }
}
//# sourceMappingURL=Scopes.js.map