import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { isEmpty } from "lodash";
import Moment from "react-moment";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Text, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { TaskState } from "./TaskState";
export const TaskDetails = ({ userTask, ouiaId, ouiaSafe }) => {
    if (!userTask) {
        return (_jsx(KogitoSpinner, { ...componentOuiaProps(ouiaId, "task-details-component-loading", ouiaSafe), spinnerText: "Loading Task details" }));
    }
    const resolveTaskPriority = (priority) => {
        switch (priority) {
            case "0":
                return "0 - High";
            case "5":
                return "5 - Medium";
            case "10":
                return "10 - Low";
        }
        return priority || "-";
    };
    return (_jsxs(Form, { ...componentOuiaProps(ouiaId, "task-details-component", ouiaSafe), children: [_jsx(FormGroup, { label: "Name", fieldId: "name", children: _jsx(Text, { component: TextVariants.p, children: userTask.referenceName }) }), userTask.description && (_jsx(FormGroup, { label: "Description", fieldId: "description", children: _jsx(Text, { component: TextVariants.p, children: userTask.description }) })), _jsx(FormGroup, { label: "ID", fieldId: "id", children: _jsx(Text, { component: TextVariants.p, children: userTask.id }) }), _jsx(FormGroup, { label: "State", fieldId: "state", children: _jsx(TaskState, { task: userTask }) }), _jsx(FormGroup, { label: "Priority", fieldId: "priority", children: _jsx(Text, { component: TextVariants.p, children: resolveTaskPriority(userTask.priority) }) }), _jsx(FormGroup, { label: "Owner", fieldId: "owner", children: _jsx(Text, { component: TextVariants.p, children: userTask.actualOwner || "-" }) }), !isEmpty(userTask.potentialUsers) && (_jsx(FormGroup, { label: "Potential users", fieldId: "potential_users", children: _jsx(Text, { component: TextVariants.p, children: userTask.potentialUsers.join(", ") }) })), !isEmpty(userTask.potentialGroups) && (_jsx(FormGroup, { label: "Potential groups", fieldId: "potential_groups", children: _jsx(Text, { component: TextVariants.p, children: userTask.potentialGroups.join(", ") }) })), _jsx(FormGroup, { label: "Started", fieldId: "started", children: userTask.started ? (_jsx(Text, { component: TextVariants.p, children: _jsx(Moment, { fromNow: true, children: new Date(`${userTask.started}`) }) })) : ("-") }), userTask.completed ? (_jsx(FormGroup, { label: "Completed", fieldId: "completed", children: _jsx(Text, { component: TextVariants.p, children: _jsx(Moment, { fromNow: true, children: new Date(`${userTask.completed}`) }) }) })) : (_jsx(FormGroup, { label: "Last Update", fieldId: "lastUpdate", children: _jsx(Text, { component: TextVariants.p, children: _jsx(Moment, { fromNow: true, children: new Date(`${userTask.lastUpdate}`) }) }) })), _jsx(FormGroup, { label: "Process", fieldId: "process", children: _jsx(Text, { component: TextVariants.p, children: userTask.processId }) }), _jsx(FormGroup, { label: "Process Instance ID", fieldId: "processInstance", children: _jsx(Text, { component: TextVariants.p, children: userTask.processInstanceId }) })] }));
};
export default TaskDetails;
//# sourceMappingURL=TaskDetails.js.map