import { By } from "selenium-webdriver";
import Page from "../Page";
class GitHubRepoPage extends Page {
    async waitUntilLoaded() {
        return await this.tools.by(GitHubRepoPage.TOKEN_ICON).wait(1000).untilPresent();
    }
    async addToken(token) {
        const tokenIcon = await this.tools.by(GitHubRepoPage.TOKEN_ICON).getElement();
        await tokenIcon.click();
        await this.tools.by(GitHubRepoPage.RESET_BUTTON).wait(1000).untilPresent();
        await this.tools.by(GitHubRepoPage.TOKEN_INPUT).wait(1000).untilPresent();
        const resetButton = await this.tools.by(GitHubRepoPage.RESET_BUTTON).getElement();
        await resetButton.click();
        const tokenInput = await this.tools.by(GitHubRepoPage.TOKEN_INPUT).getElement();
        await tokenInput.click();
        await this.tools.clipboard().setContent(token);
        await tokenInput.sendKeys(this.tools.clipboard().getCtrvKeys());
        await this.tools.by(GitHubRepoPage.TOKEN_INPUT).wait(5000).untilAbsent();
    }
}
GitHubRepoPage.TOKEN_ICON = By.className("kogito-menu-icon");
GitHubRepoPage.TOKEN_INPUT = By.className("kogito-github-token-input");
GitHubRepoPage.RESET_BUTTON = By.xpath("//button[text()='Reset']");
export default GitHubRepoPage;
//# sourceMappingURL=GitHubRepoPage.js.map