import { By } from "selenium-webdriver";
import PageFragment from "../../PageFragment";
import { assert } from "chai";
class DmnExpressionEditor extends PageFragment {
    async waitUntilLoaded() {
        return await this.tools.by(DmnExpressionEditor.RETURN_TO_GRAPH_LOCATOR).wait(1000).untilPresent();
    }
    async activateBetaVersion() {
        const activateBetaButton = await this.tools
            .by(DmnExpressionEditor.BETA_VERSION_ACTIVATOR_LOCATOR)
            .getElement();
        await activateBetaButton.click();
        return await this.tools.by(DmnExpressionEditor.BETA_VERSION_INDICATOR_LOCATOR).wait(1000).untilPresent();
    }
    async assertExpressionIsPresent(expectedTitle, expectedType) {
        await this.tools
            .by(By.xpath(`//div[@data-ouia-component-type='expression-column-header-cell-info']/p[text()='${expectedTitle}']`))
            .wait(1000)
            .untilPresent();
        const type = await this.tools
            .by(By.xpath(`//div[@data-ouia-component-type='expression-column-header-cell-info']/p[contains(@class, 'data-type')]`))
            .getElement();
        assert.equal("(" + expectedType + ")", await type.getText());
        return;
    }
}
DmnExpressionEditor.RETURN_TO_GRAPH_LOCATOR = By.className("kie-dmn-return-to-link");
DmnExpressionEditor.BETA_VERSION_ACTIVATOR_LOCATOR = By.xpath("//a[@data-field='try-it']");
DmnExpressionEditor.BETA_VERSION_INDICATOR_LOCATOR = By.className("beta-badge");
export default DmnExpressionEditor;
//# sourceMappingURL=DmnExpressionEditor.js.map