"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isValidK8sResource = isValidK8sResource;
exports.consoleDebugMessage = consoleDebugMessage;
function isValidK8sResource(content) {
    return ("apiVersion" in content &&
        typeof content.apiVersion == "string" &&
        "kind" in content &&
        typeof content.kind == "string" &&
        (!("metadata" in content) || ("metadata" in content && typeof content === "object")));
}
function consoleDebugMessage(message) {
    console.debug("K8S YAML TO APISERVER:", message);
}
//# sourceMappingURL=common.js.map