/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.server.scheduler;

import com.google.common.collect.Iterables;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.client.KVRangeSetting;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.store.proto.KVRangeROReply;
import org.apache.bifromq.basekv.store.proto.KVRangeRORequest;
import org.apache.bifromq.basekv.store.proto.ROCoProcInput;
import org.apache.bifromq.basekv.store.proto.ReplyCode;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.basescheduler.IBatchCall;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.dist.rpc.proto.BatchDistRequest;
import org.apache.bifromq.dist.rpc.proto.DistPack;
import org.apache.bifromq.dist.rpc.proto.DistServiceROCoProcInput;
import org.apache.bifromq.dist.rpc.proto.TopicFanout;
import org.apache.bifromq.dist.server.scheduler.DistServerCallBatcherKey;
import org.apache.bifromq.dist.server.scheduler.TenantPubRequest;
import org.apache.bifromq.dist.server.scheduler.TenantRangeLookupCache;
import org.apache.bifromq.type.ClientInfo;
import org.apache.bifromq.type.Message;
import org.apache.bifromq.type.PublisherMessagePack;
import org.apache.bifromq.type.TopicMessagePack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchDistServerCall
implements IBatchCall<TenantPubRequest, Map<String, Integer>, DistServerCallBatcherKey> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchDistServerCall.class);
    private final IBaseKVStoreClient distWorkerClient;
    private final DistServerCallBatcherKey batcherKey;
    private final String orderKey;
    private final TenantRangeLookupCache lookupCache;
    private Queue<ICallTask<TenantPubRequest, Map<String, Integer>, DistServerCallBatcherKey>> tasks = new ArrayDeque<ICallTask<TenantPubRequest, Map<String, Integer>, DistServerCallBatcherKey>>();
    private Map<String, Map<ClientInfo, Iterable<Message>>> batch = new HashMap<String, Map<ClientInfo, Iterable<Message>>>(128);

    BatchDistServerCall(IBaseKVStoreClient distWorkerClient, DistServerCallBatcherKey batcherKey, TenantRangeLookupCache lookupCache) {
        this.distWorkerClient = distWorkerClient;
        this.batcherKey = batcherKey;
        this.orderKey = batcherKey.tenantId() + batcherKey.batcherId();
        this.lookupCache = lookupCache;
    }

    public void add(ICallTask<TenantPubRequest, Map<String, Integer>, DistServerCallBatcherKey> callTask) {
        this.tasks.add(callTask);
        ((TenantPubRequest)callTask.call()).publisherMessagePacks().forEach(publisherMsgPack -> publisherMsgPack.getMessagePackList().forEach(topicMsgs -> this.batch.computeIfAbsent(topicMsgs.getTopic(), k -> new HashMap()).compute(publisherMsgPack.getPublisher(), (k, v) -> {
            v = v == null ? topicMsgs.getMessageList() : Iterables.concat((Iterable)v, (Iterable)topicMsgs.getMessageList());
            return v;
        })));
    }

    public void reset(boolean abort) {
        if (abort) {
            this.tasks = new ArrayDeque<ICallTask<TenantPubRequest, Map<String, Integer>, DistServerCallBatcherKey>>();
            this.batch = new HashMap<String, Map<ClientInfo, Iterable<Message>>>(128);
        } else {
            this.batch.clear();
        }
    }

    public CompletableFuture<Void> execute() {
        return this.execute(this.tasks, this.batch);
    }

    private CompletableFuture<Void> execute(Queue<ICallTask<TenantPubRequest, Map<String, Integer>, DistServerCallBatcherKey>> tasks, Map<String, Map<ClientInfo, Iterable<Message>>> batch) {
        Map<KVRangeSetting, Set<String>> topicsByRange = this.rangeLookup(batch);
        if (topicsByRange.isEmpty()) {
            ICallTask<TenantPubRequest, Map<String, Integer>, DistServerCallBatcherKey> task;
            while ((task = tasks.poll()) != null) {
                HashMap fanOutResult = new HashMap();
                ((TenantPubRequest)task.call()).publisherMessagePacks().forEach(clientMessagePack -> clientMessagePack.getMessagePackList().forEach(topicMessagePack -> fanOutResult.put(topicMessagePack.getTopic(), 0)));
                task.resultPromise().complete(fanOutResult);
            }
            return CompletableFuture.completedFuture(null);
        }
        return this.parallelDist(topicsByRange, tasks, batch);
    }

    private CompletableFuture<Void> parallelDist(Map<KVRangeSetting, Set<String>> topicsByRange, Queue<ICallTask<TenantPubRequest, Map<String, Integer>, DistServerCallBatcherKey>> tasks, Map<String, Map<ClientInfo, Iterable<Message>>> batch) {
        long reqId = System.nanoTime();
        Collection<ReplicaBatch> replicaBatches = this.replicaSelect(topicsByRange, batch);
        Map<CompletableFuture, ReplicaBatch> rangeQueryReplies = replicaBatches.stream().collect(Collectors.toMap(entry -> {
            KVRangeReplica rangeReplica = entry.replica;
            Map<String, Map<ClientInfo, Iterable<Message>>> replicaBatch = entry.msgBatch;
            BatchDistRequest.Builder batchDistBuilder = BatchDistRequest.newBuilder().setReqId(reqId).setOrderKey(this.orderKey);
            replicaBatch.forEach((topic, publisherMsgs) -> {
                String tenantId = this.batcherKey.tenantId();
                DistPack.Builder distPackBuilder = DistPack.newBuilder().setTenantId(tenantId);
                TopicMessagePack.Builder topicMsgPackBuilder = TopicMessagePack.newBuilder().setTopic(topic);
                publisherMsgs.forEach((publisher, msgs) -> {
                    TopicMessagePack.PublisherPack.Builder packBuilder = TopicMessagePack.PublisherPack.newBuilder().setPublisher(publisher);
                    msgs.forEach(arg_0 -> ((TopicMessagePack.PublisherPack.Builder)packBuilder).addMessage(arg_0));
                    topicMsgPackBuilder.addMessage(packBuilder.build());
                });
                distPackBuilder.addMsgPack(topicMsgPackBuilder.build());
                batchDistBuilder.addDistPack(distPackBuilder.build());
            });
            if (rangeReplica.storeId == null) {
                return CompletableFuture.completedFuture(KVRangeROReply.newBuilder().setReqId(reqId).setCode(ReplyCode.TryLater).build());
            }
            return this.distWorkerClient.query(rangeReplica.storeId, KVRangeRORequest.newBuilder().setReqId(reqId).setVer(rangeReplica.ver).setKvRangeId(rangeReplica.id).setRoCoProc(ROCoProcInput.newBuilder().setDistService(DistServiceROCoProcInput.newBuilder().setBatchDist(batchDistBuilder.build()).build()).build()).build(), this.orderKey).exceptionally(CompletableFutureUtil.unwrap(e -> {
                if (e instanceof ServerNotFoundException) {
                    return KVRangeROReply.newBuilder().setReqId(reqId).setCode(ReplyCode.TryLater).build();
                }
                log.debug("Failed to query range: {}", (Object)rangeReplica, e);
                return KVRangeROReply.newBuilder().setReqId(reqId).setCode(ReplyCode.InternalError).build();
            }));
        }, replicaBatch -> replicaBatch));
        return CompletableFuture.allOf(rangeQueryReplies.keySet().toArray(new CompletableFuture[0])).thenAccept(v -> {
            ICallTask task;
            HashMap<String, Integer> allFanOutByTopic = new HashMap<String, Integer>();
            block4: for (CompletableFuture replyFuture : rangeQueryReplies.keySet()) {
                ReplicaBatch replicaBatch = (ReplicaBatch)rangeQueryReplies.get(replyFuture);
                KVRangeROReply reply = (KVRangeROReply)replyFuture.join();
                switch (reply.getCode()) {
                    case Ok: {
                        Map topicFanoutByTenant = reply.getRoCoProcResult().getDistService().getBatchDist().getResultMap();
                        for (String tenantId : topicFanoutByTenant.keySet()) {
                            assert (tenantId.equals(this.batcherKey.tenantId()));
                            Map topicFanOut = ((TopicFanout)topicFanoutByTenant.get(tenantId)).getFanoutMap();
                            topicFanOut.forEach((topic, fanOut) -> allFanOutByTopic.compute((String)topic, (k, val) -> {
                                if (val == null) {
                                    val = 0;
                                }
                                if (val < 0) {
                                    return val;
                                }
                                val = val + fanOut;
                                return val;
                            }));
                        }
                        continue block4;
                    }
                    case BadVersion: 
                    case TryLater: {
                        for (String topic2 : replicaBatch.msgBatch.keySet()) {
                            allFanOutByTopic.put(topic2, -1);
                        }
                        continue block4;
                    }
                    default: {
                        for (String topic2 : replicaBatch.msgBatch.keySet()) {
                            allFanOutByTopic.put(topic2, -2);
                        }
                        continue block4;
                    }
                }
            }
            while ((task = (ICallTask)tasks.poll()) != null) {
                HashMap<String, Integer> fanOutResult = new HashMap<String, Integer>();
                for (PublisherMessagePack clientMsgPack : ((TenantPubRequest)task.call()).publisherMessagePacks()) {
                    for (PublisherMessagePack.TopicPack topicMsgPack : clientMsgPack.getMessagePackList()) {
                        int fanOut2 = allFanOutByTopic.getOrDefault(topicMsgPack.getTopic(), 0);
                        fanOutResult.put(topicMsgPack.getTopic(), fanOut2);
                    }
                }
                task.resultPromise().complete(fanOutResult);
            }
        });
    }

    private Map<KVRangeSetting, Set<String>> rangeLookup(Map<String, Map<ClientInfo, Iterable<Message>>> batch) {
        NavigableMap effectiveRouter = this.distWorkerClient.latestEffectiveRouter();
        HashMap<KVRangeSetting, Set<String>> topicsByRange = new HashMap<KVRangeSetting, Set<String>>();
        for (String topic : batch.keySet()) {
            Collection<KVRangeSetting> candidates = this.lookupCache.lookup(topic, effectiveRouter);
            for (KVRangeSetting candidate : candidates) {
                topicsByRange.computeIfAbsent(candidate, k -> new HashSet()).add(topic);
            }
        }
        return topicsByRange;
    }

    private Collection<ReplicaBatch> replicaSelect(Map<KVRangeSetting, Set<String>> topicsByRange, Map<String, Map<ClientInfo, Iterable<Message>>> batch) {
        LinkedHashMap<KVRangeReplica, ReplicaBatch> batchByReplica = new LinkedHashMap<KVRangeReplica, ReplicaBatch>();
        for (KVRangeSetting rangeSetting : topicsByRange.keySet()) {
            HashMap<String, Map<ClientInfo, Iterable<Message>>> rangeBatch = new HashMap<String, Map<ClientInfo, Iterable<Message>>>();
            for (String topic : topicsByRange.get(rangeSetting)) {
                rangeBatch.put(topic, batch.get(topic));
            }
            Optional inProcReplica = rangeSetting.inProcQueryReadyReplica();
            if (inProcReplica.isPresent()) {
                KVRangeReplica replica = new KVRangeReplica(rangeSetting.id(), rangeSetting.ver(), (String)inProcReplica.get());
                batchByReplica.put(replica, new ReplicaBatch(replica, rangeBatch));
                continue;
            }
            for (String topic : rangeBatch.keySet()) {
                int replicaSeq = Math.abs(Objects.hash(this.batcherKey.tenantId(), topic));
                Optional replicaStore = rangeSetting.getQueryReadyReplica(replicaSeq);
                KVRangeReplica replica = new KVRangeReplica(rangeSetting.id(), rangeSetting.ver(), replicaStore.orElse(null));
                batchByReplica.computeIfAbsent(replica, (Function<KVRangeReplica, ReplicaBatch>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$replicaSelect$15(org.apache.bifromq.dist.server.scheduler.BatchDistServerCall$KVRangeReplica org.apache.bifromq.dist.server.scheduler.BatchDistServerCall$KVRangeReplica ), (Lorg/apache/bifromq/dist/server/scheduler/BatchDistServerCall$KVRangeReplica;)Lorg/apache/bifromq/dist/server/scheduler/BatchDistServerCall$ReplicaBatch;)((KVRangeReplica)replica)).msgBatch.put(topic, (Map)rangeBatch.get(topic));
            }
        }
        return batchByReplica.values();
    }

    private static /* synthetic */ ReplicaBatch lambda$replicaSelect$15(KVRangeReplica replica, KVRangeReplica k) {
        return new ReplicaBatch(replica, new HashMap<String, Map<ClientInfo, Iterable<Message>>>());
    }

    private record KVRangeReplica(KVRangeId id, long ver, String storeId) {
    }

    private record ReplicaBatch(KVRangeReplica replica, Map<String, Map<ClientInfo, Iterable<Message>>> msgBatch) {
    }
}

