/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.trie;

import com.google.common.collect.Lists;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.bifromq.dist.trie.MTopicFilterTrieNode;
import org.apache.bifromq.dist.trie.NTopicFilterTrieNode;
import org.apache.bifromq.dist.trie.STopicFilterTrieNode;
import org.apache.bifromq.dist.trie.TopicTrieNode;

abstract class TopicFilterTrieNode<V> {
    static final Duration EXPIRE_AFTER = Duration.ofMinutes(1L);
    protected TopicFilterTrieNode<V> parent;

    protected TopicFilterTrieNode() {
    }

    static <V> TopicFilterTrieNode<V> from(TopicTrieNode<V> root) {
        return NTopicFilterTrieNode.borrow(null, root.levelName(), Set.of(root));
    }

    static void release(TopicFilterTrieNode<?> node) {
        if (node instanceof MTopicFilterTrieNode) {
            MTopicFilterTrieNode mNode = (MTopicFilterTrieNode)node;
            MTopicFilterTrieNode.release(mNode);
        } else if (node instanceof STopicFilterTrieNode) {
            STopicFilterTrieNode sNode = (STopicFilterTrieNode)node;
            STopicFilterTrieNode.release(sNode);
        } else if (node instanceof NTopicFilterTrieNode) {
            NTopicFilterTrieNode nNode = (NTopicFilterTrieNode)node;
            NTopicFilterTrieNode.release(nNode);
        }
    }

    abstract String levelName();

    final List<String> topicFilterPrefix() {
        if (this.parent == null) {
            return List.of();
        }
        LinkedList topicFilterPrefix = Lists.newLinkedList(this.parent.topicFilterPrefix());
        if (!this.parent.levelName().equals("\u0000")) {
            topicFilterPrefix.add(this.parent.levelName());
        }
        return topicFilterPrefix;
    }

    abstract Set<TopicTrieNode<V>> backingTopics();

    abstract void seekChild(String var1);

    abstract void seekPrevChild(String var1);

    abstract void seekToFirstChild();

    abstract void seekToLastChild();

    abstract boolean atValidChild();

    abstract void nextChild();

    abstract void prevChild();

    abstract TopicFilterTrieNode<V> childNode();
}

