/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.CloudEventDataFormat;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.JsonSerializerProviders;
import com.azure.core.util.serializer.TypeReference;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public final class CloudEvent {
    private static final String SPEC_VERSION = "1.0";
    private static final JsonSerializer SERIALIZER = JsonSerializerProviders.createInstance(true);
    private static final ObjectMapper BINARY_DATA_OBJECT_MAPPER = new ObjectMapper();
    private static final Map<String, Object> EMPTY_ATTRIBUTES_MAP = Collections.emptyMap();
    private static final TypeReference<List<CloudEvent>> DESERIALIZER_TYPE_REFERENCE = new TypeReference<List<CloudEvent>>(){};
    private static final ClientLogger LOGGER = new ClientLogger(CloudEvent.class);
    private static final Set<String> RESERVED_ATTRIBUTE_NAMES = new HashSet<String>(){
        {
            this.add("specversion");
            this.add("id");
            this.add("source");
            this.add("type");
            this.add("datacontenttype");
            this.add("dataschema");
            this.add("subject");
            this.add("time");
            this.add("data");
            this.add("data_base64");
        }
    };
    @JsonProperty(value="id", required=true)
    private String id;
    @JsonProperty(value="source", required=true)
    private String source;
    @JsonProperty(value="data")
    private JsonNode data;
    @JsonProperty(value="data_base64")
    private String dataBase64;
    @JsonProperty(value="type", required=true)
    private String type;
    @JsonProperty(value="time")
    private OffsetDateTime time;
    @JsonProperty(value="specversion", required=true)
    private String specVersion;
    @JsonProperty(value="dataschema")
    private String dataSchema;
    @JsonProperty(value="datacontenttype")
    private String dataContentType;
    @JsonProperty(value="subject")
    private String subject;
    @JsonIgnore
    private Map<String, Object> extensionAttributes;
    @JsonIgnore
    private BinaryData binaryData;

    public CloudEvent(String source, String type, BinaryData data, CloudEventDataFormat format, String dataContentType) {
        Objects.requireNonNull(source, "'source' cannot be null.");
        Objects.requireNonNull(type, "'type' cannot be null.");
        this.source = source;
        this.type = type;
        if (data != null) {
            Objects.requireNonNull(format, "'format' cannot be null when 'data' isn't null.");
            if (CloudEventDataFormat.BYTES == format) {
                this.dataBase64 = Base64.getEncoder().encodeToString(data.toBytes());
            } else {
                try {
                    this.data = BINARY_DATA_OBJECT_MAPPER.readTree(data.toBytes());
                }
                catch (IOException e) {
                    throw LOGGER.logExceptionAsError(new IllegalArgumentException("'data' isn't in valid Json format", e));
                }
            }
        }
        this.dataContentType = dataContentType;
        this.id = UUID.randomUUID().toString();
        this.specVersion = SPEC_VERSION;
        this.binaryData = data;
    }

    private CloudEvent() {
    }

    public static List<CloudEvent> fromString(String cloudEventsJson) {
        return CloudEvent.fromString(cloudEventsJson, false);
    }

    public static List<CloudEvent> fromString(String cloudEventsJson, boolean skipValidation) {
        Objects.requireNonNull(cloudEventsJson, "'cloudEventsJson' cannot be null");
        try {
            List<CloudEvent> events = SERIALIZER.deserialize(new ByteArrayInputStream(cloudEventsJson.getBytes(StandardCharsets.UTF_8)), DESERIALIZER_TYPE_REFERENCE);
            if (skipValidation) {
                return events;
            }
            for (int i = 0; i < events.size(); ++i) {
                CloudEvent event = events.get(i);
                if (event.getId() != null && event.getSource() != null && event.getType() != null) continue;
                ArrayList<String> nullAttributes = new ArrayList<String>();
                if (event.getId() == null) {
                    nullAttributes.add("'id'");
                }
                if (event.getSource() == null) {
                    nullAttributes.add("'source'");
                }
                if (event.getType() == null) {
                    nullAttributes.add("'type'");
                }
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("'id', 'source' and 'type' are mandatory attributes for a CloudEvent according to the spec. This Json string doesn't have " + String.join((CharSequence)",", nullAttributes) + " for the object at index " + i + ". Please make sure the input Json string has the required attributes or use CloudEvent.fromString(cloudEventsJson, true) to skip the null check."));
            }
            return events;
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("The input parameter isn't a JSON string.", uncheckedIOException.getCause()));
        }
    }

    public String getId() {
        return this.id;
    }

    public CloudEvent setId(String id) {
        Objects.requireNonNull(id, "'id' cannot be null");
        if (id.isEmpty()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'id' cannot be empty"));
        }
        this.id = id;
        return this;
    }

    public String getSource() {
        return this.source;
    }

    public BinaryData getData() {
        if (this.binaryData == null) {
            if (this.data != null) {
                this.binaryData = BinaryData.fromObject(this.data, SERIALIZER);
            } else if (this.dataBase64 != null) {
                this.binaryData = BinaryData.fromBytes(Base64.getDecoder().decode(this.dataBase64));
            }
        }
        return this.binaryData;
    }

    public String getType() {
        return this.type;
    }

    public OffsetDateTime getTime() {
        return this.time;
    }

    public CloudEvent setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    public String getDataContentType() {
        return this.dataContentType;
    }

    public String getDataSchema() {
        return this.dataSchema;
    }

    public CloudEvent setDataSchema(String dataSchema) {
        this.dataSchema = dataSchema;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public CloudEvent setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getExtensionAttributes() {
        return this.extensionAttributes == null ? EMPTY_ATTRIBUTES_MAP : Collections.unmodifiableMap(this.extensionAttributes);
    }

    @JsonAnySetter
    public CloudEvent addExtensionAttribute(String name, Object value) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        Objects.requireNonNull(value, "'value' cannot be null.");
        if (!CloudEvent.validateAttributeName(name)) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Extension attribute 'name' must have only lower-case alphanumeric characters and not be one of the CloudEvent reserved attribute names: " + String.join((CharSequence)",", RESERVED_ATTRIBUTE_NAMES)));
        }
        if (this.extensionAttributes == null) {
            this.extensionAttributes = new HashMap<String, Object>();
        }
        this.extensionAttributes.put(name, value);
        return this;
    }

    String getSpecVersion() {
        return this.specVersion;
    }

    CloudEvent setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
        return this;
    }

    private static boolean validateAttributeName(String name) {
        if (RESERVED_ATTRIBUTE_NAMES.contains(name)) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }
}

