/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.util.CoreUtils;
import java.time.OffsetDateTime;

public class BlockBlobItem {
    private final String eTag;
    private final OffsetDateTime lastModified;
    private final byte[] contentMd5;
    private final Boolean isServerEncrypted;
    private final String encryptionKeySha256;
    private final String encryptionScope;
    private final String versionId;

    public BlockBlobItem(String eTag, OffsetDateTime lastModified, byte[] contentMd5, boolean isServerEncrypted, String encryptionKeySha256) {
        this(eTag, lastModified, contentMd5, isServerEncrypted, encryptionKeySha256, null);
    }

    public BlockBlobItem(String eTag, OffsetDateTime lastModified, byte[] contentMd5, boolean isServerEncrypted, String encryptionKeySha256, String encryptionScope) {
        this(eTag, lastModified, contentMd5, isServerEncrypted, encryptionKeySha256, encryptionScope, null);
    }

    public BlockBlobItem(String eTag, OffsetDateTime lastModified, byte[] contentMd5, boolean isServerEncrypted, String encryptionKeySha256, String encryptionScope, String versionId) {
        this.eTag = eTag;
        this.lastModified = lastModified;
        this.contentMd5 = CoreUtils.clone((byte[])contentMd5);
        this.isServerEncrypted = isServerEncrypted;
        this.encryptionKeySha256 = encryptionKeySha256;
        this.encryptionScope = encryptionScope;
        this.versionId = versionId;
    }

    public String getETag() {
        return this.eTag;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public String getEncryptionKeySha256() {
        return this.encryptionKeySha256;
    }

    public String getEncryptionScope() {
        return this.encryptionScope;
    }

    public byte[] getContentMd5() {
        return CoreUtils.clone((byte[])this.contentMd5);
    }

    public String getVersionId() {
        return this.versionId;
    }
}

