/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHeaderIterator;
import org.apache.hc.core5.http.message.BasicTokenIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestBasicTokenIterator {
    TestBasicTokenIterator() {
    }

    @Test
    void testSingleHeader() {
        Header[] headers = new Header[]{new BasicHeader("Name", (Object)"token0,token1, token2 , token3")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        BasicTokenIterator ti = new BasicTokenIterator((Iterator)hit);
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token0", ti.next());
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token1", ti.next());
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token2", ti.next());
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token3", ti.next());
        Assertions.assertFalse((boolean)ti.hasNext());
        headers = new Header[]{new BasicHeader("Name", (Object)"token0")};
        hit = new BasicHeaderIterator(headers, null);
        ti = new BasicTokenIterator((Iterator)hit);
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token0", ti.next());
        Assertions.assertFalse((boolean)ti.hasNext());
    }

    @Test
    void testMultiHeader() {
        Header[] headers = new Header[]{new BasicHeader("Name", (Object)"token0,token1"), new BasicHeader("Name", (Object)""), new BasicHeader("Name", (Object)"token2"), new BasicHeader("Name", (Object)" "), new BasicHeader("Name", (Object)"token3 "), new BasicHeader("Name", (Object)","), new BasicHeader("Name", (Object)"token4")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        BasicTokenIterator ti = new BasicTokenIterator((Iterator)hit);
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token0", ti.next());
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token1", ti.next());
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token2", ti.next());
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token3", ti.next());
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token4", ti.next());
        Assertions.assertFalse((boolean)ti.hasNext());
    }

    @Test
    void testEmpty() {
        Header[] headers = new Header[]{new BasicHeader("Name", (Object)" "), new BasicHeader("Name", (Object)""), new BasicHeader("Name", (Object)","), new BasicHeader("Name", (Object)" ,, ")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        BasicTokenIterator ti = new BasicTokenIterator((Iterator)hit);
        Assertions.assertFalse((boolean)ti.hasNext());
        hit = new BasicHeaderIterator(headers, "empty");
        ti = new BasicTokenIterator((Iterator)hit);
        Assertions.assertFalse((boolean)ti.hasNext());
    }

    @Test
    void testValueStart() {
        Header[] headers = new Header[]{new BasicHeader("Name", (Object)"token0"), new BasicHeader("Name", (Object)" token1"), new BasicHeader("Name", (Object)",token2"), new BasicHeader("Name", (Object)" ,token3"), new BasicHeader("Name", (Object)", token4"), new BasicHeader("Name", (Object)" , token5")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        BasicTokenIterator ti = new BasicTokenIterator((Iterator)hit);
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token0", ti.next());
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token1", ti.next());
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token2", ti.next());
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token3", ti.next());
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token4", ti.next());
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token5", ti.next());
        Assertions.assertFalse((boolean)ti.hasNext());
    }

    @Test
    void testValueEnd() {
        Header[] headers = new Header[]{new BasicHeader("Name", (Object)"token0"), new BasicHeader("Name", (Object)"token1 "), new BasicHeader("Name", (Object)"token2,"), new BasicHeader("Name", (Object)"token3 ,"), new BasicHeader("Name", (Object)"token4, "), new BasicHeader("Name", (Object)"token5 , ")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        BasicTokenIterator ti = new BasicTokenIterator((Iterator)hit);
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token0", ti.next());
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token1", ti.next());
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token2", ti.next());
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token3", ti.next());
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token4", ti.next());
        Assertions.assertTrue((boolean)ti.hasNext());
        Assertions.assertEquals((Object)"token5", ti.next());
        Assertions.assertFalse((boolean)ti.hasNext());
    }

    @Test
    void testWrongPublic() {
        Assertions.assertThrows(NullPointerException.class, () -> new BasicTokenIterator(null));
        Header[] headers = new Header[]{new BasicHeader("Name", (Object)" "), new BasicHeader("Name", (Object)""), new BasicHeader("Name", (Object)","), new BasicHeader("Name", (Object)" ,, ")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        BasicTokenIterator ti = new BasicTokenIterator((Iterator)hit);
        Assertions.assertThrows(NoSuchElementException.class, () -> TestBasicTokenIterator.lambda$testWrongPublic$1((Iterator)ti));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> TestBasicTokenIterator.lambda$testWrongPublic$2((Iterator)ti));
    }

    private static /* synthetic */ void lambda$testWrongPublic$2(Iterator ti) throws Throwable {
        ti.remove();
    }

    private static /* synthetic */ void lambda$testWrongPublic$1(Iterator ti) throws Throwable {
        String cfr_ignored_0 = (String)ti.next();
    }
}

