/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.resolution;

import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.model.SymbolReference;

public interface TypeSolver {
    public static final String JAVA_LANG_OBJECT = Object.class.getCanonicalName();
    public static final String JAVA_LANG_RECORD = "java.lang.Record";

    default public TypeSolver getRoot() {
        if (this.getParent() == null) {
            return this;
        }
        return this.getParent().getRoot();
    }

    public TypeSolver getParent();

    public void setParent(TypeSolver var1);

    public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveType(String var1);

    default public ResolvedReferenceTypeDeclaration solveType(String name) throws UnsolvedSymbolException {
        SymbolReference<ResolvedReferenceTypeDeclaration> ref = this.tryToSolveType(name);
        if (ref.isSolved()) {
            return ref.getCorrespondingDeclaration();
        }
        throw new UnsolvedSymbolException(name, this.toString());
    }

    public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveTypeInModule(String var1, String var2);

    default public ResolvedReferenceTypeDeclaration solveTypeInModule(String qualifiedModuleName, String simpleTypeName) {
        SymbolReference<ResolvedReferenceTypeDeclaration> ref = this.tryToSolveTypeInModule(qualifiedModuleName, simpleTypeName);
        if (ref.isSolved()) {
            return ref.getCorrespondingDeclaration();
        }
        throw new UnsolvedSymbolException(simpleTypeName, "module=" + qualifiedModuleName + " in " + this);
    }

    default public ResolvedReferenceTypeDeclaration getSolvedJavaLangObject() throws UnsolvedSymbolException {
        return this.solveType(JAVA_LANG_OBJECT);
    }

    default public ResolvedReferenceTypeDeclaration getSolvedJavaLangRecord() throws UnsolvedSymbolException {
        return this.solveType(JAVA_LANG_RECORD);
    }

    default public boolean hasType(String name) {
        return this.tryToSolveType(name).isSolved();
    }
}

