/*
 * Decompiled with CFR 0.152.
 */
package org.grails.gsp;

import grails.io.IOUtils;
import groovy.text.Template;
import groovy.text.TemplateEngine;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.runtime.DefaultGroovyMethodsSupport;
import org.grails.buffer.StreamByteBuffer;
import org.springframework.core.io.Resource;

public abstract class ResourceAwareTemplateEngine
extends TemplateEngine {
    public static final String BEAN_ID = "groovyPagesTemplateEngine";
    private static final String GROOVY_SOURCE_CHAR_ENCODING = "UTF-8";

    public Template createTemplate(Resource resource) throws IOException, ClassNotFoundException {
        return this.createTemplateAndCloseInput(resource.getInputStream());
    }

    public abstract Template createTemplate(Resource var1, boolean var2);

    @Override
    public final Template createTemplate(Reader reader) throws IOException {
        StreamByteBuffer buf = new StreamByteBuffer();
        IOUtils.copy(reader, (Writer)new OutputStreamWriter(buf.getOutputStream(), GROOVY_SOURCE_CHAR_ENCODING));
        return this.createTemplate(buf.getInputStream());
    }

    public abstract Template createTemplate(InputStream var1) throws IOException;

    @Override
    public Template createTemplate(String templateText) throws CompilationFailedException, ClassNotFoundException, IOException {
        return this.createTemplate(new ByteArrayInputStream(templateText.getBytes(GROOVY_SOURCE_CHAR_ENCODING)));
    }

    @Override
    public Template createTemplate(File file) throws CompilationFailedException, ClassNotFoundException, IOException {
        return this.createTemplateAndCloseInput(new FileInputStream(file));
    }

    @Override
    public Template createTemplate(URL url) throws CompilationFailedException, ClassNotFoundException, IOException {
        return this.createTemplateAndCloseInput(url.openStream());
    }

    private Template createTemplateAndCloseInput(InputStream input) throws FileNotFoundException, IOException {
        try {
            Template template = this.createTemplate(input);
            return template;
        }
        finally {
            DefaultGroovyMethodsSupport.closeWithWarning(input);
        }
    }

    public abstract Template createTemplateForUri(String[] var1);

    public abstract int mapStackLineNumber(String var1, int var2);
}

