/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.bind.binders;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.bind.binders.BodyArgumentBinder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class DefaultBodyAnnotationBinder<T>
implements BodyArgumentBinder<T> {
    protected final ConversionService<?> conversionService;

    public DefaultBodyAnnotationBinder(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Class<Body> getAnnotationType() {
        return Body.class;
    }

    @Override
    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, HttpRequest<?> source) {
        Optional<String> bodyComponent = context.getAnnotationMetadata().stringValue(Body.class);
        if (bodyComponent.isPresent()) {
            Optional<ConvertibleValues> body2 = source.getBody(ConvertibleValues.class);
            if (body2.isPresent()) {
                String component;
                ConvertibleValues values = body2.get();
                if (!values.contains(component = bodyComponent.get())) {
                    component = NameUtils.hyphenate(component);
                }
                Optional<Object> value = values.get(component, context);
                return this.newResult(value.orElse(null), context);
            }
            return ArgumentBinder.BindingResult.EMPTY;
        }
        Optional body3 = source.getBody();
        if (!body3.isPresent()) {
            return ArgumentBinder.BindingResult.EMPTY;
        }
        Object o = body3.get();
        Optional<Object> converted = this.conversionService.convert(o, context);
        return this.newResult(converted.orElse(null), context);
    }

    private ArgumentBinder.BindingResult<T> newResult(T converted, ArgumentConversionContext<T> context) {
        final Optional<ConversionError> lastError = context.getLastError();
        if (lastError.isPresent()) {
            return new ArgumentBinder.BindingResult<T>(){

                @Override
                public Optional<T> getValue() {
                    return Optional.empty();
                }

                @Override
                public List<ConversionError> getConversionErrors() {
                    return Collections.singletonList((ConversionError)lastError.get());
                }
            };
        }
        return () -> Optional.ofNullable(converted);
    }
}

