/*
 * Decompiled with CFR 0.152.
 */
package grails.web.servlet.context.support;

import grails.core.GrailsApplication;
import grails.util.Environment;
import java.util.Set;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.StandardServletEnvironment;

public class GrailsEnvironment
extends StandardServletEnvironment {
    GrailsApplication grailsApplication;

    public GrailsEnvironment(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
        this.getPropertySources().addFirst(new GrailsConfigPropertySource());
        this.getPropertySources().addFirst(new PropertiesPropertySource("systemProperties", System.getProperties()));
    }

    @Override
    protected Set<String> doGetActiveProfiles() {
        Set<String> activeProfiles = super.doGetActiveProfiles();
        activeProfiles.add(Environment.getCurrent().getName());
        return activeProfiles;
    }

    private class GrailsConfigPropertySource
    extends PropertySource<GrailsApplication> {
        public GrailsConfigPropertySource() {
            super(StringUtils.hasText(GrailsEnvironment.this.grailsApplication.getMetadata().getApplicationName()) ? GrailsEnvironment.this.grailsApplication.getMetadata().getApplicationName() : "grailsApplication", GrailsEnvironment.this.grailsApplication);
        }

        @Override
        public Object getProperty(String key) {
            return GrailsEnvironment.this.grailsApplication.getConfig().getProperty(key, Object.class);
        }
    }
}

