/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.UUID;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.util.Config;

@XmlRootElement(name="fortRoleConstraint")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="roleConstraint", propOrder={"id", "key", "value", "type"})
public class RoleConstraint
extends FortEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String RC_TYPE_NAME = "type";
    private String id;
    private RCType type;
    private String value;
    private String key;
    @XmlTransient
    private String typeName;

    public RoleConstraint() {
    }

    public RoleConstraint(String id, String value, RCType type, String key) {
        this.id = id;
        this.type = type;
        this.value = value;
        this.key = key;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void genId() {
        UUID uuid = UUID.randomUUID();
        this.id = uuid.toString();
    }

    public RCType getType() {
        return this.type;
    }

    public void setType(RCType type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getRawData(UserRole uRole) {
        StringBuilder sb = new StringBuilder();
        String delimeter = Config.getInstance().getDelimiter();
        sb.append(uRole.getName().toLowerCase());
        sb.append(delimeter);
        sb.append(RC_TYPE_NAME);
        sb.append(delimeter);
        sb.append((Object)this.type);
        sb.append(delimeter);
        sb.append(this.key);
        sb.append(delimeter);
        sb.append(this.value);
        sb.append(delimeter);
        if (this.getType() != RCType.USER) {
            sb.append(this.id);
        }
        return sb.toString();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
        if (typeName != null && typeName.equalsIgnoreCase("FILTER")) {
            this.setType(RCType.FILTER);
        } else if (typeName != null && typeName.equalsIgnoreCase("USER")) {
            this.setType(RCType.USER);
        } else {
            this.setType(RCType.OTHER);
        }
    }

    public String toString() {
        return "RoleConstraint{type=" + this.type + ", key='" + this.key + "', value='" + this.value + "', id='" + this.id + "'}";
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + this.key.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleConstraint that = (RoleConstraint)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (!this.key.equals(that.key)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return this.value.equals(that.value);
    }

    @XmlType(name="rctype")
    @XmlEnum
    public static enum RCType {
        FILTER,
        USER,
        OTHER;

    }
}

