/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.filters;

import java.io.IOException;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.rs.security.oauth2.common.OAuthContext;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.filters.ConfidentialClient;
import org.apache.cxf.rs.security.oauth2.filters.Scopes;
import org.apache.cxf.rs.security.oauth2.utils.OAuthContextUtils;

@Priority(value=1001)
public class OAuthScopesFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LogUtils.getL7dLogger(OAuthScopesFilter.class);
    private static final Set<String> SKIP_METHODS = new HashSet<String>(Arrays.asList("wait", "notify", "notifyAll", "equals", "toString", "hashCode"));
    @Context
    private MessageContext mc;
    private Map<String, List<String>> scopesMap = new HashMap<String, List<String>>();
    private Map<String, Boolean> scopesMatchAllMap = new HashMap<String, Boolean>();
    private Set<String> confidentialClientMethods = new HashSet<String>();

    public void setSecuredObject(Object object) {
        Class cls = ClassHelper.getRealClass((Object)object);
        this.checkSecureClass(cls);
        if (this.scopesMap.isEmpty()) {
            LOG.warning("The scopes map is empty");
        } else if (LOG.isLoggable(Level.FINE)) {
            for (Map.Entry<String, List<String>> entry : this.scopesMap.entrySet()) {
                LOG.fine("Method: " + entry.getKey() + ", scopes: " + String.valueOf(entry.getValue()));
            }
        }
    }

    protected void checkSecureClass(Class<?> cls) {
        if (cls == null || cls == Object.class) {
            return;
        }
        Scopes classScopes = cls.getAnnotation(Scopes.class);
        ConfidentialClient classConfClient = cls.getAnnotation(ConfidentialClient.class);
        for (Method method : cls.getMethods()) {
            Scopes theScopes;
            if (SKIP_METHODS.contains(method.getName())) continue;
            Scopes methodScopes = method.getAnnotation(Scopes.class);
            Scopes scopes = theScopes = methodScopes == null ? classScopes : methodScopes;
            if (theScopes != null) {
                this.scopesMap.put(method.getName(), Arrays.asList(theScopes.value()));
                this.scopesMatchAllMap.put(method.getName(), theScopes.matchAll());
            }
            ConfidentialClient mConfClient = method.getAnnotation(ConfidentialClient.class);
            if (classConfClient == null && mConfClient == null) continue;
            this.confidentialClientMethods.add(method.getName());
        }
        this.checkSecureClass(cls.getSuperclass());
        for (GenericDeclaration genericDeclaration : cls.getInterfaces()) {
            this.checkSecureClass((Class<?>)genericDeclaration);
        }
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Method m = this.getTargetMethod();
        this.checkClient(m);
        this.checkScopes(m);
    }

    protected void checkClient(Method m) {
        OAuthContext context;
        if (this.confidentialClientMethods.contains(m.getName()) && !(context = OAuthContextUtils.getContext(this.mc)).isClientConfidential()) {
            LOG.warning("Non confidential client " + context.getClientId() + " has attempted to invoke " + m.getName());
            throw ExceptionUtils.toForbiddenException(null, null);
        }
    }

    protected void checkScopes(Method m) {
        List<String> methodScopes = this.scopesMap.get(m.getName());
        if (methodScopes == null) {
            return;
        }
        boolean matchAll = this.scopesMatchAllMap.get(m.getName());
        OAuthContext context = OAuthContextUtils.getContext(this.mc);
        LinkedList<String> requestScopes = new LinkedList<String>();
        for (OAuthPermission perm : context.getPermissions()) {
            if (matchAll) {
                requestScopes.add(perm.getPermission());
                continue;
            }
            if (!methodScopes.contains(perm.getPermission())) continue;
            return;
        }
        if (!requestScopes.containsAll(methodScopes)) {
            LOG.warning("Scopes do not match");
            throw ExceptionUtils.toForbiddenException(null, null);
        }
    }

    protected Method getTargetMethod() {
        Method method = (Method)this.mc.get((Object)"org.apache.cxf.resource.method");
        if (method != null) {
            return method;
        }
        throw ExceptionUtils.toForbiddenException(null, null);
    }

    public void setScopesMap(Map<String, List<String>> scopesMap) {
        this.scopesMap = scopesMap;
    }

    public void setScopesStringMap(Map<String, String> scopesStringMap) {
        for (Map.Entry<String, String> entry : scopesStringMap.entrySet()) {
            this.scopesMap.put(entry.getKey(), Arrays.asList(entry.getValue().split(" ")));
        }
    }

    public void setScopesMatchAllMap(Map<String, Boolean> scopesMatchAllMap) {
        this.scopesMatchAllMap = scopesMatchAllMap;
    }

    public void setConfidentialClientMethods(Set<String> confidentialClientMethods) {
        this.confidentialClientMethods = confidentialClientMethods;
    }
}

