/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.examples.nntp;

import java.io.IOException;
import java.net.SocketException;
import org.apache.commons.net.examples.PrintCommandListeners;
import org.apache.commons.net.nntp.Article;
import org.apache.commons.net.nntp.NNTPClient;
import org.apache.commons.net.nntp.NewsgroupInfo;
import org.apache.commons.net.nntp.Threader;

public class MessageThreading {
    public static void main(String[] args) throws SocketException, IOException {
        String[] fmt;
        String[] password;
        String user;
        if (args.length != 2 && args.length != 4) {
            System.out.println("Usage: MessageThreading <hostname> <groupname> [<user> <password>]");
            return;
        }
        String hostname = args[0];
        String newsgroup = args[1];
        NNTPClient client = new NNTPClient();
        client.addProtocolCommandListener(PrintCommandListeners.sysOutPrintCommandListener());
        client.connect(hostname);
        if (args.length == 4 && !client.authenticate(user = args[2], (String)(password = args[3]))) {
            System.out.println("Authentication failed for user " + user + "!");
            System.exit(1);
        }
        if ((fmt = client.listOverviewFmt()) != null) {
            System.out.println("LIST OVERVIEW.FMT:");
            for (String s : fmt) {
                System.out.println(s);
            }
        } else {
            System.out.println("Failed to get OVERVIEW.FMT");
        }
        NewsgroupInfo group = new NewsgroupInfo();
        client.selectNewsgroup(newsgroup, group);
        long lowArticleNumber = group.getFirstArticleLong();
        long highArticleNumber = lowArticleNumber + 5000L;
        System.out.println("Retrieving articles between [" + lowArticleNumber + "] and [" + highArticleNumber + "]");
        Iterable<Article> articles = client.iterateArticleInfo(lowArticleNumber, highArticleNumber);
        System.out.println("Building message thread tree...");
        Threader threader = new Threader();
        Article root = (Article)threader.thread(articles);
        Article.printThread(root, 0);
    }
}

