/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl3.parser.JexlNode;
import org.apache.commons.jexl3.parser.JexlParser;
import org.apache.commons.jexl3.parser.ParseException;
import org.apache.commons.jexl3.parser.ParserVisitor;

public class ASTSwitchStatement
extends JexlNode {
    protected boolean isStatement = true;
    protected Map<Object, Integer> cases = Collections.emptyMap();

    public ASTSwitchStatement(int id) {
        super(id);
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public List<Object>[] getCasesList() {
        List[] list = new List[this.jjtGetNumChildren() - 1];
        for (Map.Entry<Object, Integer> entry : this.cases.entrySet()) {
            int index = entry.getValue();
            if (index < 0 || index >= list.length) {
                throw new IndexOutOfBoundsException("switch index out of bounds: " + index);
            }
            ArrayList<Integer> values = list[index];
            if (values == null) {
                list[index] = values = new ArrayList<Integer>();
            }
            values.add(entry.getValue());
        }
        return list;
    }

    public boolean isStatement() {
        return this.isStatement;
    }

    public int switchIndex(Object value) {
        Object code = JexlParser.switchCode(value);
        Integer index = this.cases.get(code);
        if (index == null) {
            index = this.cases.get(JexlParser.DFLT);
        }
        if (index != null && index >= 1 && index < this.jjtGetNumChildren()) {
            return index;
        }
        return -1;
    }

    public static class Helper {
        private int switchIndex = 1;
        private boolean defaultDefined;
        private final Map<Object, Integer> dispatch = new LinkedHashMap<Object, Integer>();

        void defineCase(JexlParser.SwitchSet switchSet) throws ParseException {
            if (switchSet.isEmpty()) {
                if (this.defaultDefined) {
                    throw new ParseException("default clause is already defined");
                }
                this.defaultDefined = true;
                this.dispatch.put(JexlParser.DFLT, this.switchIndex);
            } else {
                for (Object constant : switchSet) {
                    if (this.dispatch.put(constant, this.switchIndex) == null) continue;
                    throw new ParseException("duplicate case in switch statement for value: " + constant);
                }
                switchSet.clear();
            }
            ++this.switchIndex;
        }

        void defineSwitch(ASTSwitchStatement statement) {
            statement.cases = this.dispatch;
        }
    }
}

