/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.iptc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;
import org.apache.commons.imaging.formats.jpeg.JpegImagingParameters;
import org.apache.commons.imaging.formats.jpeg.JpegPhotoshopMetadata;
import org.apache.commons.imaging.formats.jpeg.iptc.AbstractIptcTest;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcRecord;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcType;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcTypes;
import org.apache.commons.imaging.formats.jpeg.iptc.JpegIptcRewriter;
import org.apache.commons.imaging.formats.jpeg.iptc.PhotoshopApp13Data;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class IptcUpdateTest
extends AbstractIptcTest {
    public static Stream<File> data() throws Exception {
        return IptcUpdateTest.getImagesWithIptcData().stream();
    }

    public byte[] removeIptc(ByteSource byteSource, File imageFile) throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            new JpegIptcRewriter().removeIptc(byteSource, (OutputStream)os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testInsert(File imageFile) throws Exception {
        byte[] updated;
        ByteSource byteSource = ByteSource.file((File)imageFile);
        JpegImagingParameters params = new JpegImagingParameters();
        JpegPhotoshopMetadata metadata = new JpegImageParser().getPhotoshopMetadata(byteSource, params);
        Assertions.assertNotNull((Object)metadata);
        byte[] noIptcFile = this.removeIptc(byteSource, imageFile);
        ArrayList newBlocks = new ArrayList();
        ArrayList<IptcRecord> newRecords = new ArrayList<IptcRecord>();
        newRecords.add(new IptcRecord((IptcType)IptcTypes.CITY, "Albany, NY"));
        newRecords.add(new IptcRecord((IptcType)IptcTypes.CREDIT, "William Sorensen"));
        PhotoshopApp13Data newData = new PhotoshopApp13Data(newRecords, newBlocks);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            new JpegIptcRewriter().writeIptc(ByteSource.array((byte[])noIptcFile, (String)"test.jpg"), (OutputStream)os, newData);
            updated = os.toByteArray();
        }
        ByteSource updateByteSource = ByteSource.array((byte[])updated, (String)"test.jpg");
        JpegPhotoshopMetadata outMetadata = new JpegImageParser().getPhotoshopMetadata(updateByteSource, params);
        Assertions.assertNotNull((Object)outMetadata);
        Assertions.assertEquals((int)2, (int)outMetadata.getItems().size());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testNoChangeUpdate(File imageFile) throws Exception {
        ByteSource byteSource = ByteSource.file((File)imageFile);
        JpegImagingParameters params = new JpegImagingParameters();
        JpegPhotoshopMetadata metadata = new JpegImageParser().getPhotoshopMetadata(byteSource, params);
        Assertions.assertNotNull((Object)metadata);
        List newBlocks = metadata.photoshopApp13Data.getNonIptcBlocks();
        List oldRecords = metadata.photoshopApp13Data.getRecords();
        ArrayList<IptcRecord> newRecords = new ArrayList<IptcRecord>();
        for (IptcRecord record : oldRecords) {
            if (record.iptcType == IptcTypes.CITY || record.iptcType == IptcTypes.CREDIT) continue;
            newRecords.add(record);
        }
        newRecords.add(new IptcRecord((IptcType)IptcTypes.CITY, "Albany, NY"));
        newRecords.add(new IptcRecord((IptcType)IptcTypes.CREDIT, "William Sorensen"));
        PhotoshopApp13Data newData = new PhotoshopApp13Data(newRecords, newBlocks);
        byte[] updated = this.writeIptc(byteSource, newData, imageFile);
        ByteSource updateByteSource = ByteSource.array((byte[])updated, (String)"test.jpg");
        JpegPhotoshopMetadata outMetadata = new JpegImageParser().getPhotoshopMetadata(updateByteSource, params);
        Assertions.assertNotNull((Object)outMetadata);
        Assertions.assertEquals((int)outMetadata.getItems().size(), (int)newRecords.size());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testRemove(File imageFile) throws Exception {
        ByteSource byteSource = ByteSource.file((File)imageFile);
        JpegImagingParameters params = new JpegImagingParameters();
        JpegPhotoshopMetadata metadata = new JpegImageParser().getPhotoshopMetadata(byteSource, params);
        Assertions.assertNotNull((Object)metadata);
        byte[] noIptcFile = this.removeIptc(byteSource, imageFile);
        JpegPhotoshopMetadata outMetadata = new JpegImageParser().getPhotoshopMetadata(ByteSource.array((byte[])noIptcFile, (String)"test.jpg"), params);
        Assertions.assertTrue((outMetadata == null || outMetadata.getItems().isEmpty() ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testUpdate(File imageFile) throws Exception {
        ByteSource byteSource = ByteSource.file((File)imageFile);
        JpegImagingParameters params = new JpegImagingParameters();
        JpegPhotoshopMetadata metadata = new JpegImageParser().getPhotoshopMetadata(byteSource, params);
        Assertions.assertNotNull((Object)metadata);
        List newBlocks = metadata.photoshopApp13Data.getNonIptcBlocks();
        ArrayList<IptcRecord> newRecords = new ArrayList<IptcRecord>();
        newRecords.add(new IptcRecord((IptcType)IptcTypes.CITY, "Albany, NY"));
        newRecords.add(new IptcRecord((IptcType)IptcTypes.CREDIT, "William Sorensen"));
        PhotoshopApp13Data newData = new PhotoshopApp13Data(newRecords, newBlocks);
        byte[] updated = this.writeIptc(byteSource, newData, imageFile);
        ByteSource updateByteSource = ByteSource.array((byte[])updated, (String)"test.jpg");
        JpegPhotoshopMetadata outMetadata = new JpegImageParser().getPhotoshopMetadata(updateByteSource, params);
        Assertions.assertNotNull((Object)outMetadata);
        Assertions.assertEquals((int)2, (int)outMetadata.getItems().size());
    }

    public byte[] writeIptc(ByteSource byteSource, PhotoshopApp13Data newData, File imageFile) throws IOException, ImagingException, ImagingException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            new JpegIptcRewriter().writeIptc(byteSource, (OutputStream)os, newData);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }
}

