/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.jvm;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.CharBuffer;
import java.nio.file.ClosedFileSystemException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openjdk.javax.lang.model.element.Modifier;
import org.openjdk.javax.lang.model.element.NestingKind;
import org.openjdk.javax.tools.JavaFileManager;
import org.openjdk.javax.tools.JavaFileObject;
import org.openjdk.tools.javac.code.AnnoConstruct;
import org.openjdk.tools.javac.code.Attribute;
import org.openjdk.tools.javac.code.BoundKind;
import org.openjdk.tools.javac.code.ClassFinder;
import org.openjdk.tools.javac.code.Directive;
import org.openjdk.tools.javac.code.Kinds;
import org.openjdk.tools.javac.code.Lint;
import org.openjdk.tools.javac.code.Scope;
import org.openjdk.tools.javac.code.Source;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Symtab;
import org.openjdk.tools.javac.code.TargetType;
import org.openjdk.tools.javac.code.Type;
import org.openjdk.tools.javac.code.TypeAnnotationPosition;
import org.openjdk.tools.javac.code.TypeMetadata;
import org.openjdk.tools.javac.code.TypeTag;
import org.openjdk.tools.javac.code.Types;
import org.openjdk.tools.javac.comp.Annotate;
import org.openjdk.tools.javac.file.BaseFileManager;
import org.openjdk.tools.javac.file.PathFileObject;
import org.openjdk.tools.javac.jvm.ClassFile;
import org.openjdk.tools.javac.jvm.Code;
import org.openjdk.tools.javac.jvm.Pool;
import org.openjdk.tools.javac.jvm.Profile;
import org.openjdk.tools.javac.main.Option;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.Convert;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javac.util.ListBuffer;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Name;
import org.openjdk.tools.javac.util.Names;
import org.openjdk.tools.javac.util.Options;
import org.openjdk.tools.javac.util.Pair;

public class ClassReader {
    protected static final Context.Key<ClassReader> classReaderKey = new Context.Key();
    public static final int INITIAL_BUFFER_SIZE = 65520;
    private final Annotate annotate;
    boolean verbose;
    public boolean readAllOfClassFile = false;
    boolean allowSimplifiedVarargs;
    boolean allowModules;
    boolean lintClassfile;
    public boolean saveParameterNames;
    public final Profile profile;
    final Log log;
    Symtab syms;
    Types types;
    final Names names;
    private final JavaFileManager fileManager;
    JCDiagnostic.Factory diagFactory;
    protected Scope.WriteableScope typevars;
    private List<InterimUsesDirective> interimUses = List.nil();
    private List<InterimProvidesDirective> interimProvides = List.nil();
    protected JavaFileObject currentClassFile = null;
    protected Symbol currentOwner = null;
    protected Symbol.ModuleSymbol currentModule = null;
    byte[] buf = new byte[65520];
    protected int bp;
    Object[] poolObj;
    int[] poolIdx;
    int majorVersion;
    int minorVersion;
    int[] parameterNameIndices;
    ParameterAnnotations[] parameterAnnotations;
    boolean haveParameterNameIndices;
    boolean sawMethodParameters;
    Set<Name> warnedAttrs = new HashSet<Name>();
    CompoundAnnotationProxy target;
    CompoundAnnotationProxy repeatable;
    byte[] signature;
    int sigp;
    int siglimit;
    boolean sigEnterPhase = false;
    byte[] signatureBuffer = new byte[0];
    int sbp = 0;
    protected Set<AttributeKind> CLASS_ATTRIBUTE = EnumSet.of(AttributeKind.CLASS);
    protected Set<AttributeKind> MEMBER_ATTRIBUTE = EnumSet.of(AttributeKind.MEMBER);
    protected Set<AttributeKind> CLASS_OR_MEMBER_ATTRIBUTE = EnumSet.of(AttributeKind.CLASS, AttributeKind.MEMBER);
    protected Map<Name, AttributeReader> attributeReaders = new HashMap<Name, AttributeReader>();
    private boolean readingClassAttr = false;
    private List<Type> missingTypeVariables = List.nil();
    private List<Type> foundTypeVariables = List.nil();
    public boolean filling = false;

    public static ClassReader instance(Context context) {
        ClassReader classReader = context.get(classReaderKey);
        if (classReader == null) {
            classReader = new ClassReader(context);
        }
        return classReader;
    }

    protected ClassReader(Context context) {
        context.put(classReaderKey, this);
        this.annotate = Annotate.instance(context);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        if (this.fileManager == null) {
            throw new AssertionError((Object)"FileManager initialization error");
        }
        this.diagFactory = JCDiagnostic.Factory.instance(context);
        this.log = Log.instance(context);
        Options options = Options.instance(context);
        this.verbose = options.isSet(Option.VERBOSE);
        Source source = Source.instance(context);
        this.allowSimplifiedVarargs = source.allowSimplifiedVarargs();
        this.allowModules = source.allowModules();
        this.saveParameterNames = options.isSet(Option.PARAMETERS);
        this.profile = Profile.instance(context);
        this.typevars = Scope.WriteableScope.create(this.syms.noSymbol);
        this.lintClassfile = Lint.instance(context).isEnabled(Lint.LintCategory.CLASSFILE);
        this.initAttributeReaders();
    }

    private void enterMember(Symbol.ClassSymbol classSymbol, Symbol symbol) {
        if ((symbol.flags_field & 0x80001000L) != 4096L || symbol.name.startsWith(this.names.lambda)) {
            classSymbol.members_field.enter(symbol);
        }
    }

    public ClassFinder.BadClassFile badClassFile(String string, Object ... objectArray) {
        return new ClassFinder.BadClassFile(this.currentOwner.enclClass(), this.currentClassFile, this.diagFactory.fragment(string, objectArray), this.diagFactory);
    }

    public ClassFinder.BadEnclosingMethodAttr badEnclosingMethod(Object ... objectArray) {
        return new ClassFinder.BadEnclosingMethodAttr(this.currentOwner.enclClass(), this.currentClassFile, this.diagFactory.fragment("bad.enclosing.method", objectArray), this.diagFactory);
    }

    char nextChar() {
        return (char)(((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF));
    }

    int nextByte() {
        return this.buf[this.bp++] & 0xFF;
    }

    int nextInt() {
        return ((this.buf[this.bp++] & 0xFF) << 24) + ((this.buf[this.bp++] & 0xFF) << 16) + ((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF);
    }

    char getChar(int n) {
        return (char)(((this.buf[n] & 0xFF) << 8) + (this.buf[n + 1] & 0xFF));
    }

    int getInt(int n) {
        return ((this.buf[n] & 0xFF) << 24) + ((this.buf[n + 1] & 0xFF) << 16) + ((this.buf[n + 2] & 0xFF) << 8) + (this.buf[n + 3] & 0xFF);
    }

    long getLong(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 8));
        try {
            return dataInputStream.readLong();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    float getFloat(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 4));
        try {
            return dataInputStream.readFloat();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    double getDouble(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 8));
        try {
            return dataInputStream.readDouble();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    void indexPool() {
        this.poolIdx = new int[this.nextChar()];
        this.poolObj = new Object[this.poolIdx.length];
        int n = 1;
        block7: while (n < this.poolIdx.length) {
            this.poolIdx[n++] = this.bp;
            byte by = this.buf[this.bp++];
            switch (by) {
                case 1: 
                case 2: {
                    char c = this.nextChar();
                    this.bp += c;
                    continue block7;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    this.bp += 2;
                    continue block7;
                }
                case 15: {
                    this.bp += 3;
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    this.bp += 4;
                    continue block7;
                }
                case 5: 
                case 6: {
                    this.bp += 8;
                    ++n;
                    continue block7;
                }
            }
            throw this.badClassFile("bad.const.pool.tag.at", Byte.toString(by), Integer.toString(this.bp - 1));
        }
    }

    Object readPool(int n) {
        Object object = this.poolObj[n];
        if (object != null) {
            return object;
        }
        int n2 = this.poolIdx[n];
        if (n2 == 0) {
            return null;
        }
        byte by = this.buf[n2];
        switch (by) {
            case 1: {
                this.poolObj[n] = this.names.fromUtf(this.buf, n2 + 3, this.getChar(n2 + 1));
                break;
            }
            case 2: {
                throw this.badClassFile("unicode.str.not.supported", new Object[0]);
            }
            case 7: {
                this.poolObj[n] = this.readClassOrType(this.getChar(n2 + 1));
                break;
            }
            case 8: {
                this.poolObj[n] = this.readName(this.getChar(n2 + 1)).toString();
                break;
            }
            case 9: {
                Symbol.ClassSymbol classSymbol = this.readClassSymbol(this.getChar(n2 + 1));
                ClassFile.NameAndType nameAndType = this.readNameAndType(this.getChar(n2 + 3));
                this.poolObj[n] = new Symbol.VarSymbol(0L, nameAndType.name, nameAndType.uniqueType.type, classSymbol);
                break;
            }
            case 10: 
            case 11: {
                Symbol.ClassSymbol classSymbol = this.readClassSymbol(this.getChar(n2 + 1));
                ClassFile.NameAndType nameAndType = this.readNameAndType(this.getChar(n2 + 3));
                this.poolObj[n] = new Symbol.MethodSymbol(0L, nameAndType.name, nameAndType.uniqueType.type, classSymbol);
                break;
            }
            case 12: {
                this.poolObj[n] = new ClassFile.NameAndType(this.readName(this.getChar(n2 + 1)), this.readType(this.getChar(n2 + 3)), this.types);
                break;
            }
            case 3: {
                this.poolObj[n] = this.getInt(n2 + 1);
                break;
            }
            case 4: {
                this.poolObj[n] = Float.valueOf(this.getFloat(n2 + 1));
                break;
            }
            case 5: {
                this.poolObj[n] = this.getLong(n2 + 1);
                break;
            }
            case 6: {
                this.poolObj[n] = this.getDouble(n2 + 1);
                break;
            }
            case 15: {
                this.skipBytes(4);
                break;
            }
            case 16: {
                this.skipBytes(3);
                break;
            }
            case 18: {
                this.skipBytes(5);
                break;
            }
            case 19: 
            case 20: {
                this.poolObj[n] = this.readName(this.getChar(n2 + 1));
                break;
            }
            default: {
                throw this.badClassFile("bad.const.pool.tag", Byte.toString(by));
            }
        }
        return this.poolObj[n];
    }

    Type readType(int n) {
        int n2 = this.poolIdx[n];
        return this.sigToType(this.buf, n2 + 3, this.getChar(n2 + 1));
    }

    Object readClassOrType(int n) {
        int n2 = this.poolIdx[n];
        char c = this.getChar(n2 + 1);
        int n3 = n2 + 3;
        Assert.check(this.buf[n3] == 91 || this.buf[n3 + c - 1] != 59);
        return this.buf[n3] == 91 || this.buf[n3 + c - 1] == 59 ? this.sigToType(this.buf, n3, c) : this.enterClass(this.names.fromUtf(ClassFile.internalize(this.buf, n3, c)));
    }

    List<Type> readTypeParams(int n) {
        int n2 = this.poolIdx[n];
        return this.sigToTypeParams(this.buf, n2 + 3, this.getChar(n2 + 1));
    }

    Symbol.ClassSymbol readClassSymbol(int n) {
        Object object = this.readPool(n);
        if (object != null && !(object instanceof Symbol.ClassSymbol)) {
            throw this.badClassFile("bad.const.pool.entry", this.currentClassFile.toString(), "CONSTANT_Class_info", n);
        }
        return (Symbol.ClassSymbol)object;
    }

    Name readClassName(int n) {
        int n2 = this.poolIdx[n];
        if (n2 == 0) {
            return null;
        }
        byte by = this.buf[n2];
        if (by != 7) {
            throw this.badClassFile("bad.const.pool.entry", this.currentClassFile.toString(), "CONSTANT_Class_info", n);
        }
        int n3 = this.poolIdx[this.getChar(n2 + 1)];
        char c = this.getChar(n3 + 1);
        int n4 = n3 + 3;
        if (this.buf[n4] == 91 || this.buf[n4 + c - 1] == 59) {
            throw this.badClassFile("wrong class name", new Object[0]);
        }
        return this.names.fromUtf(ClassFile.internalize(this.buf, n4, c));
    }

    Name readName(int n) {
        Object object = this.readPool(n);
        if (object != null && !(object instanceof Name)) {
            throw this.badClassFile("bad.const.pool.entry", this.currentClassFile.toString(), "CONSTANT_Utf8_info or CONSTANT_String_info", n);
        }
        return (Name)object;
    }

    ClassFile.NameAndType readNameAndType(int n) {
        Object object = this.readPool(n);
        if (object != null && !(object instanceof ClassFile.NameAndType)) {
            throw this.badClassFile("bad.const.pool.entry", this.currentClassFile.toString(), "CONSTANT_NameAndType_info", n);
        }
        return (ClassFile.NameAndType)object;
    }

    Name readModuleName(int n) {
        return this.readName(n);
    }

    Set<Symbol.ModuleFlags> readModuleFlags(int n) {
        EnumSet<Symbol.ModuleFlags> enumSet = EnumSet.noneOf(Symbol.ModuleFlags.class);
        for (Symbol.ModuleFlags moduleFlags : Symbol.ModuleFlags.values()) {
            if ((n & moduleFlags.value) == 0) continue;
            enumSet.add(moduleFlags);
        }
        return enumSet;
    }

    Set<Symbol.ModuleResolutionFlags> readModuleResolutionFlags(int n) {
        EnumSet<Symbol.ModuleResolutionFlags> enumSet = EnumSet.noneOf(Symbol.ModuleResolutionFlags.class);
        for (Symbol.ModuleResolutionFlags moduleResolutionFlags : Symbol.ModuleResolutionFlags.values()) {
            if ((n & moduleResolutionFlags.value) == 0) continue;
            enumSet.add(moduleResolutionFlags);
        }
        return enumSet;
    }

    Set<Directive.ExportsFlag> readExportsFlags(int n) {
        EnumSet<Directive.ExportsFlag> enumSet = EnumSet.noneOf(Directive.ExportsFlag.class);
        for (Directive.ExportsFlag exportsFlag : Directive.ExportsFlag.values()) {
            if ((n & exportsFlag.value) == 0) continue;
            enumSet.add(exportsFlag);
        }
        return enumSet;
    }

    Set<Directive.OpensFlag> readOpensFlags(int n) {
        EnumSet<Directive.OpensFlag> enumSet = EnumSet.noneOf(Directive.OpensFlag.class);
        for (Directive.OpensFlag opensFlag : Directive.OpensFlag.values()) {
            if ((n & opensFlag.value) == 0) continue;
            enumSet.add(opensFlag);
        }
        return enumSet;
    }

    Set<Directive.RequiresFlag> readRequiresFlags(int n) {
        EnumSet<Directive.RequiresFlag> enumSet = EnumSet.noneOf(Directive.RequiresFlag.class);
        for (Directive.RequiresFlag requiresFlag : Directive.RequiresFlag.values()) {
            if ((n & requiresFlag.value) == 0) continue;
            enumSet.add(requiresFlag);
        }
        return enumSet;
    }

    Type sigToType(byte[] byArray, int n, int n2) {
        this.signature = byArray;
        this.sigp = n;
        this.siglimit = n + n2;
        return this.sigToType();
    }

    Type sigToType() {
        switch ((char)this.signature[this.sigp]) {
            case 'T': {
                ++this.sigp;
                int n = this.sigp;
                while (this.signature[this.sigp] != 59) {
                    ++this.sigp;
                }
                ++this.sigp;
                return this.sigEnterPhase ? Type.noType : this.findTypeVar(this.names.fromUtf(this.signature, n, this.sigp - 1 - n));
            }
            case '+': {
                ++this.sigp;
                Type type = this.sigToType();
                return new Type.WildcardType(type, BoundKind.EXTENDS, this.syms.boundClass);
            }
            case '*': {
                ++this.sigp;
                return new Type.WildcardType(this.syms.objectType, BoundKind.UNBOUND, this.syms.boundClass);
            }
            case '-': {
                ++this.sigp;
                Type type = this.sigToType();
                return new Type.WildcardType(type, BoundKind.SUPER, this.syms.boundClass);
            }
            case 'B': {
                ++this.sigp;
                return this.syms.byteType;
            }
            case 'C': {
                ++this.sigp;
                return this.syms.charType;
            }
            case 'D': {
                ++this.sigp;
                return this.syms.doubleType;
            }
            case 'F': {
                ++this.sigp;
                return this.syms.floatType;
            }
            case 'I': {
                ++this.sigp;
                return this.syms.intType;
            }
            case 'J': {
                ++this.sigp;
                return this.syms.longType;
            }
            case 'L': {
                Type type = this.classSigToType();
                if (this.sigp < this.siglimit && this.signature[this.sigp] == 46) {
                    throw this.badClassFile("deprecated inner class signature syntax (please recompile from source)", new Object[0]);
                }
                return type;
            }
            case 'S': {
                ++this.sigp;
                return this.syms.shortType;
            }
            case 'V': {
                ++this.sigp;
                return this.syms.voidType;
            }
            case 'Z': {
                ++this.sigp;
                return this.syms.booleanType;
            }
            case '[': {
                ++this.sigp;
                return new Type.ArrayType(this.sigToType(), this.syms.arrayClass);
            }
            case '(': {
                ++this.sigp;
                List<Type> list = this.sigToTypes(')');
                Type type = this.sigToType();
                List<Type> list2 = List.nil();
                while (this.signature[this.sigp] == 94) {
                    ++this.sigp;
                    list2 = list2.prepend(this.sigToType());
                }
                List<Type> list3 = list2;
                while (list3.nonEmpty()) {
                    if (((Type)list3.head).hasTag(TypeTag.TYPEVAR)) {
                        ((Type)list3.head).tsym.flags_field |= 0x800000000000L;
                    }
                    list3 = list3.tail;
                }
                return new Type.MethodType(list, type, list2.reverse(), this.syms.methodClass);
            }
            case '<': {
                this.typevars = this.typevars.dup(this.currentOwner);
                Type.ForAll forAll = new Type.ForAll(this.sigToTypeParams(), this.sigToType());
                this.typevars = this.typevars.leave();
                return forAll;
            }
        }
        throw this.badClassFile("bad.signature", Convert.utf2string(this.signature, this.sigp, 10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type classSigToType() {
        if (this.signature[this.sigp] != 76) {
            throw this.badClassFile("bad.class.signature", Convert.utf2string(this.signature, this.sigp, 10));
        }
        ++this.sigp;
        Type type = Type.noType;
        int n = this.sbp;
        block13: while (true) {
            byte by = this.signature[this.sigp++];
            switch (by) {
                case 59: {
                    Symbol.ClassSymbol classSymbol = this.enterClass(this.names.fromUtf(this.signatureBuffer, n, this.sbp - n));
                    try {
                        Type type2 = type == Type.noType ? classSymbol.erasure(this.types) : new Type.ClassType(type, List.nil(), classSymbol);
                        return type2;
                    }
                    finally {
                        this.sbp = n;
                    }
                }
                case 60: {
                    Symbol.ClassSymbol classSymbol = this.enterClass(this.names.fromUtf(this.signatureBuffer, n, this.sbp - n));
                    type = new Type.ClassType(type, this.sigToTypes('>'), classSymbol){
                        boolean completed;
                        {
                            this.completed = false;
                        }

                        @Override
                        public Type getEnclosingType() {
                            if (!this.completed) {
                                this.completed = true;
                                this.tsym.complete();
                                Type type = this.tsym.type.getEnclosingType();
                                if (type != Type.noType) {
                                    List<Type> list = super.getEnclosingType().allparams();
                                    List<Type> list2 = type.allparams();
                                    if (list2.length() != list.length()) {
                                        super.setEnclosingType(ClassReader.this.types.erasure(type));
                                    } else {
                                        super.setEnclosingType(ClassReader.this.types.subst(type, list2, list));
                                    }
                                } else {
                                    super.setEnclosingType(Type.noType);
                                }
                            }
                            return super.getEnclosingType();
                        }

                        @Override
                        public void setEnclosingType(Type type) {
                            throw new UnsupportedOperationException();
                        }
                    };
                    switch (this.signature[this.sigp++]) {
                        case 59: {
                            if (this.sigp < this.signature.length && this.signature[this.sigp] == 46) {
                                this.sigp += this.sbp - n + 3;
                                this.signatureBuffer[this.sbp++] = 36;
                                continue block13;
                            }
                            this.sbp = n;
                            return type;
                        }
                        case 46: {
                            this.signatureBuffer[this.sbp++] = 36;
                            continue block13;
                        }
                    }
                    throw new AssertionError(this.signature[this.sigp - 1]);
                }
                case 46: {
                    Symbol.ClassSymbol classSymbol;
                    if (type != Type.noType) {
                        classSymbol = this.enterClass(this.names.fromUtf(this.signatureBuffer, n, this.sbp - n));
                        type = new Type.ClassType(type, List.nil(), classSymbol);
                    }
                    this.signatureBuffer[this.sbp++] = 36;
                    continue block13;
                }
                case 47: {
                    this.signatureBuffer[this.sbp++] = 46;
                    continue block13;
                }
            }
            this.signatureBuffer[this.sbp++] = by;
        }
    }

    List<Type> sigToTypes(char c) {
        List<Object> list;
        List<Object> list2 = list = List.of(null);
        while (this.signature[this.sigp] != c) {
            list2 = list2.setTail(List.of(this.sigToType()));
        }
        ++this.sigp;
        return list.tail;
    }

    List<Type> sigToTypeParams(byte[] byArray, int n, int n2) {
        this.signature = byArray;
        this.sigp = n;
        this.siglimit = n + n2;
        return this.sigToTypeParams();
    }

    List<Type> sigToTypeParams() {
        List<Type> list = List.nil();
        if (this.signature[this.sigp] == 60) {
            ++this.sigp;
            int n = this.sigp;
            this.sigEnterPhase = true;
            while (this.signature[this.sigp] != 62) {
                list = list.prepend(this.sigToTypeParam());
            }
            this.sigEnterPhase = false;
            this.sigp = n;
            while (this.signature[this.sigp] != 62) {
                this.sigToTypeParam();
            }
            ++this.sigp;
        }
        return list.reverse();
    }

    Type sigToTypeParam() {
        Type.TypeVar typeVar;
        int n = this.sigp;
        while (this.signature[this.sigp] != 58) {
            ++this.sigp;
        }
        Name name = this.names.fromUtf(this.signature, n, this.sigp - n);
        if (this.sigEnterPhase) {
            typeVar = new Type.TypeVar(name, this.currentOwner, this.syms.botType);
            this.typevars.enter(typeVar.tsym);
        } else {
            typeVar = (Type.TypeVar)this.findTypeVar(name);
        }
        List<Type> list = List.nil();
        boolean bl = false;
        if (this.signature[this.sigp] == 58 && this.signature[this.sigp + 1] == 58) {
            ++this.sigp;
            bl = true;
        }
        while (this.signature[this.sigp] == 58) {
            ++this.sigp;
            list = list.prepend(this.sigToType());
        }
        if (!this.sigEnterPhase) {
            this.types.setBounds(typeVar, list.reverse(), bl);
        }
        return typeVar;
    }

    Type findTypeVar(Name name) {
        Symbol symbol = this.typevars.findFirst(name);
        if (symbol != null) {
            return symbol.type;
        }
        if (this.readingClassAttr) {
            Type.TypeVar typeVar = new Type.TypeVar(name, this.currentOwner, this.syms.botType);
            this.missingTypeVariables = this.missingTypeVariables.prepend(typeVar);
            return typeVar;
        }
        throw this.badClassFile("undecl.type.var", name);
    }

    private void initAttributeReaders() {
        AttributeReader[] attributeReaderArray;
        for (AttributeReader attributeReader : attributeReaderArray = new AttributeReader[]{new AttributeReader(this.names.Code, ClassFile.Version.V45_3, (Set)this.MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                if (ClassReader.this.readAllOfClassFile || ClassReader.this.saveParameterNames) {
                    ((Symbol.MethodSymbol)symbol).code = ClassReader.this.readCode(symbol);
                } else {
                    ClassReader.this.bp += n;
                }
            }
        }, new AttributeReader(this.names.ConstantValue, ClassFile.Version.V45_3, (Set)this.MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                Object object = ClassReader.this.readPool(ClassReader.this.nextChar());
                if ((symbol.flags() & 0x10L) == 0L) {
                    return;
                }
                Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
                switch (varSymbol.type.getTag()) {
                    case BOOLEAN: 
                    case BYTE: 
                    case CHAR: 
                    case SHORT: 
                    case INT: {
                        this.checkType(varSymbol, Integer.class, object);
                        break;
                    }
                    case LONG: {
                        this.checkType(varSymbol, Long.class, object);
                        break;
                    }
                    case FLOAT: {
                        this.checkType(varSymbol, Float.class, object);
                        break;
                    }
                    case DOUBLE: {
                        this.checkType(varSymbol, Double.class, object);
                        break;
                    }
                    case CLASS: {
                        Assert.check(varSymbol.type.tsym == ClassReader.this.syms.stringType.tsym);
                        this.checkType(varSymbol, String.class, object);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (object instanceof Integer && !varSymbol.type.getTag().checkRange((Integer)object)) {
                    throw ClassReader.this.badClassFile("bad.constant.range", object, varSymbol, varSymbol.type);
                }
                varSymbol.setData(object);
            }

            void checkType(Symbol symbol, Class<?> clazz, Object object) {
                if (!clazz.isInstance(object)) {
                    throw ClassReader.this.badClassFile("bad.constant.value", object, symbol, clazz.getSimpleName());
                }
            }
        }, new AttributeReader(this.names.Deprecated, ClassFile.Version.V45_3, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                Symbol symbol2 = symbol.owner.kind == Kinds.Kind.MDL ? symbol.owner : symbol;
                symbol2.flags_field |= 0x20000L;
            }
        }, new AttributeReader(this.names.Exceptions, ClassFile.Version.V45_3, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                int n2 = ClassReader.this.nextChar();
                List<Type> list = List.nil();
                for (int i = 0; i < n2; ++i) {
                    list = list.prepend(ClassReader.this.readClassSymbol((int)ClassReader.this.nextChar()).type);
                }
                if (symbol.type.getThrownTypes().isEmpty()) {
                    symbol.type.asMethodType().thrown = list.reverse();
                }
            }
        }, new AttributeReader(this.names.InnerClasses, ClassFile.Version.V45_3, (Set)this.CLASS_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
                if (ClassReader.this.currentModule.module_info == classSymbol) {
                    ClassReader.this.skipInnerClasses();
                } else {
                    ClassReader.this.readInnerClasses(classSymbol);
                }
            }
        }, new AttributeReader(this.names.LocalVariableTable, ClassFile.Version.V45_3, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                int n2 = ClassReader.this.bp + n;
                if (ClassReader.this.saveParameterNames && !ClassReader.this.sawMethodParameters) {
                    int n3 = ClassReader.this.nextChar();
                    for (int i = 0; i < n3; ++i) {
                        char c = ClassReader.this.nextChar();
                        char c2 = ClassReader.this.nextChar();
                        char c3 = ClassReader.this.nextChar();
                        char c4 = ClassReader.this.nextChar();
                        char c5 = ClassReader.this.nextChar();
                        if (c != '\u0000') continue;
                        if (c5 >= ClassReader.this.parameterNameIndices.length) {
                            int n4 = Math.max(c5 + '\u0001', ClassReader.this.parameterNameIndices.length + 8);
                            ClassReader.this.parameterNameIndices = Arrays.copyOf(ClassReader.this.parameterNameIndices, n4);
                        }
                        ClassReader.this.parameterNameIndices[c5] = c3;
                        ClassReader.this.haveParameterNameIndices = true;
                    }
                }
                ClassReader.this.bp = n2;
            }
        }, new AttributeReader(this.names.SourceFile, ClassFile.Version.V45_3, (Set)this.CLASS_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
                Name name = ClassReader.this.readName(ClassReader.this.nextChar());
                classSymbol.sourcefile = new SourceFileObject(name, classSymbol.flatname);
                String string = name.toString();
                if (classSymbol.owner.kind == Kinds.Kind.PCK && string.endsWith(".java") && !string.equals(classSymbol.name.toString() + ".java")) {
                    classSymbol.flags_field |= 0x100000000000L;
                }
            }
        }, new AttributeReader(this.names.Synthetic, ClassFile.Version.V45_3, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                symbol.flags_field |= 0x1000L;
            }
        }, new AttributeReader(this.names.EnclosingMethod, ClassFile.Version.V49, (Set)this.CLASS_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                int n2 = ClassReader.this.bp + n;
                ClassReader.this.readEnclosingMethodAttr(symbol);
                ClassReader.this.bp = n2;
            }
        }, new AttributeReader(this.names.Signature, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void read(Symbol symbol, int n) {
                if (symbol.kind == Kinds.Kind.TYP) {
                    Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
                    ClassReader.this.readingClassAttr = true;
                    try {
                        Type.ClassType classType = (Type.ClassType)classSymbol.type;
                        Assert.check(classSymbol == ClassReader.this.currentOwner);
                        classType.typarams_field = ClassReader.this.readTypeParams(ClassReader.this.nextChar());
                        classType.supertype_field = ClassReader.this.sigToType();
                        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
                        while (ClassReader.this.sigp != ClassReader.this.siglimit) {
                            listBuffer.append(ClassReader.this.sigToType());
                        }
                        classType.interfaces_field = listBuffer.toList();
                    }
                    finally {
                        ClassReader.this.readingClassAttr = false;
                    }
                } else {
                    List<Type> list = symbol.type.getThrownTypes();
                    symbol.type = ClassReader.this.readType(ClassReader.this.nextChar());
                    if (symbol.kind == Kinds.Kind.MTH && symbol.type.getThrownTypes().isEmpty()) {
                        symbol.type.asMethodType().thrown = list;
                    }
                }
            }
        }, new AttributeReader(this.names.AnnotationDefault, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                ClassReader.this.attachAnnotationDefault(symbol);
            }
        }, new AttributeReader(this.names.RuntimeInvisibleAnnotations, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                ClassReader.this.attachAnnotations(symbol);
            }
        }, new AttributeReader(this.names.RuntimeInvisibleParameterAnnotations, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                ClassReader.this.readParameterAnnotations(symbol);
            }
        }, new AttributeReader(this.names.RuntimeVisibleAnnotations, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                ClassReader.this.attachAnnotations(symbol);
            }
        }, new AttributeReader(this.names.RuntimeVisibleParameterAnnotations, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                ClassReader.this.readParameterAnnotations(symbol);
            }
        }, new AttributeReader(this.names.Annotation, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                symbol.flags_field |= 0x2000L;
            }
        }, new AttributeReader(this.names.Bridge, ClassFile.Version.V49, (Set)this.MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                symbol.flags_field |= 0x80000000L;
            }
        }, new AttributeReader(this.names.Enum, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                symbol.flags_field |= 0x4000L;
            }
        }, new AttributeReader(this.names.Varargs, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                symbol.flags_field |= 0x400000000L;
            }
        }, new AttributeReader(this.names.RuntimeVisibleTypeAnnotations, ClassFile.Version.V52, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                ClassReader.this.attachTypeAnnotations(symbol);
            }
        }, new AttributeReader(this.names.RuntimeInvisibleTypeAnnotations, ClassFile.Version.V52, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                ClassReader.this.attachTypeAnnotations(symbol);
            }
        }, new AttributeReader(this.names.MethodParameters, ClassFile.Version.V52, (Set)this.MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                int n2 = ClassReader.this.bp + n;
                if (ClassReader.this.saveParameterNames) {
                    ClassReader.this.sawMethodParameters = true;
                    int n3 = ClassReader.this.nextByte();
                    ClassReader.this.parameterNameIndices = new int[n3];
                    ClassReader.this.haveParameterNameIndices = true;
                    int n4 = 0;
                    for (int i = 0; i < n3; ++i) {
                        char c = ClassReader.this.nextChar();
                        char c2 = ClassReader.this.nextChar();
                        if ((c2 & 0x9000) != 0) continue;
                        ClassReader.this.parameterNameIndices[n4++] = c;
                    }
                }
                ClassReader.this.bp = n2;
            }
        }, new AttributeReader(this.names.Module, ClassFile.Version.V53, (Set)this.CLASS_ATTRIBUTE){

            @Override
            protected boolean accepts(AttributeKind attributeKind) {
                return super.accepts(attributeKind) && ClassReader.this.allowModules;
            }

            @Override
            protected void read(Symbol symbol, int n) {
                if (symbol.kind == Kinds.Kind.TYP && symbol.owner.kind == Kinds.Kind.MDL) {
                    Object object;
                    Object object2;
                    Symbol.ModuleSymbol moduleSymbol = (Symbol.ModuleSymbol)symbol.owner;
                    ListBuffer<Directive> listBuffer = new ListBuffer<Directive>();
                    Name name = ClassReader.this.readModuleName(ClassReader.this.nextChar());
                    if (ClassReader.this.currentModule.name != name) {
                        throw ClassReader.this.badClassFile("module.name.mismatch", name, ClassReader.this.currentModule.name);
                    }
                    moduleSymbol.flags.addAll(ClassReader.this.readModuleFlags(ClassReader.this.nextChar()));
                    moduleSymbol.version = ClassReader.this.readName(ClassReader.this.nextChar());
                    ListBuffer<Directive.RequiresDirective> listBuffer2 = new ListBuffer<Directive.RequiresDirective>();
                    int n2 = ClassReader.this.nextChar();
                    for (int i = 0; i < n2; ++i) {
                        Symbol.ModuleSymbol moduleSymbol2 = ClassReader.this.syms.enterModule(ClassReader.this.readModuleName(ClassReader.this.nextChar()));
                        Set<Directive.RequiresFlag> set = ClassReader.this.readRequiresFlags(ClassReader.this.nextChar());
                        ClassReader.this.nextChar();
                        listBuffer2.add(new Directive.RequiresDirective(moduleSymbol2, set));
                    }
                    moduleSymbol.requires = listBuffer2.toList();
                    listBuffer.addAll((Collection<Directive>)moduleSymbol.requires);
                    ListBuffer<Directive.ExportsDirective> listBuffer3 = new ListBuffer<Directive.ExportsDirective>();
                    int n3 = ClassReader.this.nextChar();
                    for (int i = 0; i < n3; ++i) {
                        Name name2 = ClassReader.this.readName(ClassReader.this.nextChar());
                        Symbol.PackageSymbol packageSymbol = ClassReader.this.syms.enterPackage(ClassReader.this.currentModule, ClassReader.this.names.fromUtf(ClassFile.internalize(name2)));
                        object2 = ClassReader.this.readExportsFlags(ClassReader.this.nextChar());
                        int n4 = ClassReader.this.nextChar();
                        if (n4 == 0) {
                            object = null;
                        } else {
                            ListBuffer<Symbol.ModuleSymbol> listBuffer4 = new ListBuffer<Symbol.ModuleSymbol>();
                            for (int j = 0; j < n4; ++j) {
                                listBuffer4.append(ClassReader.this.syms.enterModule(ClassReader.this.readModuleName(ClassReader.this.nextChar())));
                            }
                            object = listBuffer4.toList();
                        }
                        listBuffer3.add(new Directive.ExportsDirective(packageSymbol, (List<Symbol.ModuleSymbol>)object, (Set<Directive.ExportsFlag>)object2));
                    }
                    moduleSymbol.exports = listBuffer3.toList();
                    listBuffer.addAll((Collection<Directive>)moduleSymbol.exports);
                    ListBuffer<Directive.OpensDirective> listBuffer5 = new ListBuffer<Directive.OpensDirective>();
                    int n5 = ClassReader.this.nextChar();
                    if (n5 != 0 && moduleSymbol.flags.contains((Object)Symbol.ModuleFlags.OPEN)) {
                        throw ClassReader.this.badClassFile("module.non.zero.opens", ClassReader.this.currentModule.name);
                    }
                    for (int i = 0; i < n5; ++i) {
                        List list;
                        object2 = ClassReader.this.readName(ClassReader.this.nextChar());
                        Symbol.PackageSymbol packageSymbol = ClassReader.this.syms.enterPackage(ClassReader.this.currentModule, ClassReader.this.names.fromUtf(ClassFile.internalize((Name)object2)));
                        object = ClassReader.this.readOpensFlags(ClassReader.this.nextChar());
                        int n6 = ClassReader.this.nextChar();
                        if (n6 == 0) {
                            list = null;
                        } else {
                            ListBuffer<Symbol.ModuleSymbol> listBuffer6 = new ListBuffer<Symbol.ModuleSymbol>();
                            for (int j = 0; j < n6; ++j) {
                                listBuffer6.append(ClassReader.this.syms.enterModule(ClassReader.this.readModuleName(ClassReader.this.nextChar())));
                            }
                            list = listBuffer6.toList();
                        }
                        listBuffer5.add(new Directive.OpensDirective(packageSymbol, list, (Set<Directive.OpensFlag>)object));
                    }
                    moduleSymbol.opens = listBuffer5.toList();
                    listBuffer.addAll((Collection<Directive>)moduleSymbol.opens);
                    moduleSymbol.directives = listBuffer.toList();
                    ListBuffer<InterimUsesDirective> listBuffer7 = new ListBuffer<InterimUsesDirective>();
                    int n7 = ClassReader.this.nextChar();
                    for (int i = 0; i < n7; ++i) {
                        object = ClassReader.this.readClassName(ClassReader.this.nextChar());
                        listBuffer7.add(new InterimUsesDirective((Name)object));
                    }
                    ClassReader.this.interimUses = listBuffer7.toList();
                    ListBuffer<InterimProvidesDirective> listBuffer8 = new ListBuffer<InterimProvidesDirective>();
                    int n8 = ClassReader.this.nextChar();
                    for (int i = 0; i < n8; ++i) {
                        Name name3 = ClassReader.this.readClassName(ClassReader.this.nextChar());
                        int n9 = ClassReader.this.nextChar();
                        ListBuffer<Name> listBuffer9 = new ListBuffer<Name>();
                        for (int j = 0; j < n9; ++j) {
                            listBuffer9.append(ClassReader.this.readClassName(ClassReader.this.nextChar()));
                            listBuffer8.add(new InterimProvidesDirective(name3, listBuffer9.toList()));
                        }
                    }
                    ClassReader.this.interimProvides = listBuffer8.toList();
                }
            }
        }, new AttributeReader(this.names.ModuleResolution, ClassFile.Version.V53, (Set)this.CLASS_ATTRIBUTE){

            @Override
            protected boolean accepts(AttributeKind attributeKind) {
                return super.accepts(attributeKind) && ClassReader.this.allowModules;
            }

            @Override
            protected void read(Symbol symbol, int n) {
                if (symbol.kind == Kinds.Kind.TYP && symbol.owner.kind == Kinds.Kind.MDL) {
                    Symbol.ModuleSymbol moduleSymbol = (Symbol.ModuleSymbol)symbol.owner;
                    moduleSymbol.resolutionFlags.addAll(ClassReader.this.readModuleResolutionFlags(ClassReader.this.nextChar()));
                }
            }
        }}) {
            this.attributeReaders.put(attributeReader.name, attributeReader);
        }
    }

    protected void readEnclosingMethodAttr(Symbol symbol) {
        symbol.owner.members().remove(symbol);
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
        Symbol.ClassSymbol classSymbol2 = this.readClassSymbol(this.nextChar());
        ClassFile.NameAndType nameAndType = this.readNameAndType(this.nextChar());
        if (classSymbol2.members_field == null) {
            throw this.badClassFile("bad.enclosing.class", classSymbol, classSymbol2);
        }
        Symbol.MethodSymbol methodSymbol = this.findMethod(nameAndType, classSymbol2.members_field, classSymbol.flags());
        if (nameAndType != null && methodSymbol == null) {
            throw this.badEnclosingMethod(classSymbol);
        }
        classSymbol.name = this.simpleBinaryName(classSymbol.flatname, classSymbol2.flatname);
        classSymbol.owner = methodSymbol != null ? methodSymbol : classSymbol2;
        classSymbol.fullname = classSymbol.name.isEmpty() ? this.names.empty : Symbol.ClassSymbol.formFullName(classSymbol.name, classSymbol.owner);
        if (methodSymbol != null) {
            ((Type.ClassType)symbol.type).setEnclosingType(methodSymbol.type);
        } else if ((classSymbol.flags_field & 8L) == 0L) {
            ((Type.ClassType)symbol.type).setEnclosingType(classSymbol2.type);
        } else {
            ((Type.ClassType)symbol.type).setEnclosingType(Type.noType);
        }
        this.enterTypevars(classSymbol, classSymbol.type);
        if (!this.missingTypeVariables.isEmpty()) {
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            for (Type type : this.missingTypeVariables) {
                listBuffer.append(this.findTypeVar(type.tsym.name));
            }
            this.foundTypeVariables = listBuffer.toList();
        } else {
            this.foundTypeVariables = List.nil();
        }
    }

    private Name simpleBinaryName(Name name, Name name2) {
        int n;
        String string = name.toString().substring(name2.toString().length());
        if (string.length() < 1 || string.charAt(0) != '$') {
            throw this.badClassFile("bad.enclosing.method", name);
        }
        for (n = 1; n < string.length() && ClassReader.isAsciiDigit(string.charAt(n)); ++n) {
        }
        return this.names.fromString(string.substring(n));
    }

    private Symbol.MethodSymbol findMethod(ClassFile.NameAndType nameAndType, Scope scope, long l) {
        if (nameAndType == null) {
            return null;
        }
        Type.MethodType methodType = nameAndType.uniqueType.type.asMethodType();
        for (Symbol symbol : scope.getSymbolsByName(nameAndType.name)) {
            if (symbol.kind != Kinds.Kind.MTH || !this.isSameBinaryType(symbol.type.asMethodType(), methodType)) continue;
            return (Symbol.MethodSymbol)symbol;
        }
        if (nameAndType.name != this.names.init) {
            return null;
        }
        if ((l & 0x200L) != 0L) {
            return null;
        }
        if (nameAndType.uniqueType.type.getParameterTypes().isEmpty()) {
            return null;
        }
        nameAndType.setType(new Type.MethodType(nameAndType.uniqueType.type.getParameterTypes().tail, nameAndType.uniqueType.type.getReturnType(), nameAndType.uniqueType.type.getThrownTypes(), this.syms.methodClass));
        return this.findMethod(nameAndType, scope, l);
    }

    private boolean isSameBinaryType(Type.MethodType methodType, Type.MethodType methodType2) {
        List<Type> list = this.types.erasure((List<Type>)methodType.getParameterTypes()).prepend(this.types.erasure(methodType.getReturnType()));
        List<Type> list2 = ((List)methodType2.getParameterTypes()).prepend(methodType2.getReturnType());
        while (!list.isEmpty() && !list2.isEmpty()) {
            if (((Type)list.head).tsym != ((Type)list2.head).tsym) {
                return false;
            }
            list = list.tail;
            list2 = list2.tail;
        }
        return list.isEmpty() && list2.isEmpty();
    }

    private static boolean isAsciiDigit(char c) {
        return '0' <= c && c <= '9';
    }

    void readMemberAttrs(Symbol symbol) {
        this.readAttrs(symbol, AttributeKind.MEMBER);
    }

    void readAttrs(Symbol symbol, AttributeKind attributeKind) {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            Name name = this.readName(this.nextChar());
            int n2 = this.nextInt();
            AttributeReader attributeReader = this.attributeReaders.get(name);
            if (attributeReader != null && attributeReader.accepts(attributeKind)) {
                attributeReader.read(symbol, n2);
                continue;
            }
            this.bp += n2;
        }
    }

    void readClassAttrs(Symbol.ClassSymbol classSymbol) {
        this.readAttrs(classSymbol, AttributeKind.CLASS);
    }

    Code readCode(Symbol symbol) {
        this.nextChar();
        this.nextChar();
        int n = this.nextInt();
        this.bp += n;
        char c = this.nextChar();
        this.bp += c * 8;
        this.readMemberAttrs(symbol);
        return null;
    }

    List<CompoundAnnotationProxy> readAnnotations() {
        int n = this.nextChar();
        ListBuffer<CompoundAnnotationProxy> listBuffer = new ListBuffer<CompoundAnnotationProxy>();
        for (int i = 0; i < n; ++i) {
            listBuffer.append(this.readCompoundAnnotation());
        }
        return listBuffer.toList();
    }

    void attachAnnotations(Symbol symbol) {
        this.attachAnnotations(symbol, this.readAnnotations());
    }

    void attachAnnotations(Symbol symbol, List<CompoundAnnotationProxy> list) {
        if (list.isEmpty()) {
            return;
        }
        ListBuffer<CompoundAnnotationProxy> listBuffer = new ListBuffer<CompoundAnnotationProxy>();
        for (CompoundAnnotationProxy compoundAnnotationProxy : list) {
            Attribute.Constant constant;
            if (compoundAnnotationProxy.type.tsym == this.syms.proprietaryType.tsym) {
                symbol.flags_field |= 0x4000000000L;
                continue;
            }
            if (compoundAnnotationProxy.type.tsym == this.syms.profileType.tsym) {
                if (this.profile == Profile.DEFAULT) continue;
                for (Pair<Name, Attribute> pair : compoundAnnotationProxy.values) {
                    if (pair.fst != this.names.value || !(pair.snd instanceof Attribute.Constant)) continue;
                    constant = (Attribute.Constant)pair.snd;
                    if (constant.type != this.syms.intType || (Integer)constant.value <= this.profile.value) continue;
                    symbol.flags_field |= 0x200000000000L;
                }
                continue;
            }
            if (compoundAnnotationProxy.type.tsym == this.syms.annotationTargetType.tsym) {
                this.target = compoundAnnotationProxy;
            } else if (compoundAnnotationProxy.type.tsym == this.syms.repeatableType.tsym) {
                this.repeatable = compoundAnnotationProxy;
            } else if (compoundAnnotationProxy.type.tsym == this.syms.deprecatedType.tsym) {
                symbol.flags_field |= 0x40000000020000L;
                for (Pair<Name, Attribute> pair : compoundAnnotationProxy.values) {
                    if (pair.fst != this.names.forRemoval || !(pair.snd instanceof Attribute.Constant)) continue;
                    constant = (Attribute.Constant)pair.snd;
                    if (constant.type != this.syms.booleanType || (Integer)constant.value == 0) continue;
                    symbol.flags_field |= 0x80000000000000L;
                }
            }
            listBuffer.append(compoundAnnotationProxy);
        }
        this.annotate.normal(new AnnotationCompleter(symbol, listBuffer.toList()));
    }

    void readParameterAnnotations(Symbol symbol) {
        int n = this.buf[this.bp++] & 0xFF;
        if (this.parameterAnnotations == null) {
            this.parameterAnnotations = new ParameterAnnotations[n];
        } else if (this.parameterAnnotations.length != n) {
            throw this.badClassFile("bad.runtime.invisible.param.annotations", symbol);
        }
        for (int i = 0; i < n; ++i) {
            if (this.parameterAnnotations[i] == null) {
                this.parameterAnnotations[i] = new ParameterAnnotations();
            }
            this.parameterAnnotations[i].add(this.readAnnotations());
        }
    }

    void attachTypeAnnotations(Symbol symbol) {
        int n = this.nextChar();
        if (n != 0) {
            ListBuffer<TypeAnnotationProxy> listBuffer = new ListBuffer<TypeAnnotationProxy>();
            for (int i = 0; i < n; ++i) {
                listBuffer.append(this.readTypeAnnotation());
            }
            this.annotate.normal(new TypeAnnotationCompleter(symbol, listBuffer.toList()));
        }
    }

    void attachAnnotationDefault(Symbol symbol) {
        Attribute attribute;
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
        methodSymbol.defaultValue = attribute = this.readAttributeValue();
        this.annotate.normal(new AnnotationDefaultCompleter(methodSymbol, attribute));
    }

    Type readTypeOrClassSymbol(int n) {
        if (this.buf[this.poolIdx[n]] == 7) {
            return this.readClassSymbol((int)n).type;
        }
        return this.readTypeToProxy(n);
    }

    Type readEnumType(int n) {
        int n2 = this.poolIdx[n];
        char c = this.getChar(n2 + 1);
        if (this.buf[n2 + c + 2] != 59) {
            return this.enterClass((Name)this.readName((int)n)).type;
        }
        return this.readTypeToProxy(n);
    }

    Type readTypeToProxy(int n) {
        if (this.currentModule.module_info == this.currentOwner) {
            int n2 = this.poolIdx[n];
            return new ProxyType(Arrays.copyOfRange(this.buf, n2 + 3, n2 + 3 + this.getChar(n2 + 1)));
        }
        return this.readType(n);
    }

    CompoundAnnotationProxy readCompoundAnnotation() {
        Type type;
        int n;
        if (this.currentModule.module_info == this.currentOwner) {
            n = this.poolIdx[this.nextChar()];
            type = new ProxyType(Arrays.copyOfRange(this.buf, n + 3, n + 3 + this.getChar(n + 1)));
        } else {
            type = this.readTypeOrClassSymbol(this.nextChar());
        }
        n = this.nextChar();
        ListBuffer<Pair<Name, Attribute>> listBuffer = new ListBuffer<Pair<Name, Attribute>>();
        for (int i = 0; i < n; ++i) {
            Name name = this.readName(this.nextChar());
            Attribute attribute = this.readAttributeValue();
            listBuffer.append(new Pair<Name, Attribute>(name, attribute));
        }
        return new CompoundAnnotationProxy(type, listBuffer.toList());
    }

    TypeAnnotationProxy readTypeAnnotation() {
        TypeAnnotationPosition typeAnnotationPosition = this.readPosition();
        CompoundAnnotationProxy compoundAnnotationProxy = this.readCompoundAnnotation();
        return new TypeAnnotationProxy(compoundAnnotationProxy, typeAnnotationPosition);
    }

    TypeAnnotationPosition readPosition() {
        int n = this.nextByte();
        if (!TargetType.isValidTargetTypeValue(n)) {
            throw this.badClassFile("bad.type.annotation.value", String.format("0x%02X", n));
        }
        TargetType targetType = TargetType.fromTargetTypeValue(n);
        switch (targetType) {
            case INSTANCEOF: {
                char c = this.nextChar();
                TypeAnnotationPosition typeAnnotationPosition = TypeAnnotationPosition.instanceOf(this.readTypePath());
                typeAnnotationPosition.offset = c;
                return typeAnnotationPosition;
            }
            case NEW: {
                char c = this.nextChar();
                TypeAnnotationPosition typeAnnotationPosition = TypeAnnotationPosition.newObj(this.readTypePath());
                typeAnnotationPosition.offset = c;
                return typeAnnotationPosition;
            }
            case CONSTRUCTOR_REFERENCE: {
                char c = this.nextChar();
                TypeAnnotationPosition typeAnnotationPosition = TypeAnnotationPosition.constructorRef(this.readTypePath());
                typeAnnotationPosition.offset = c;
                return typeAnnotationPosition;
            }
            case METHOD_REFERENCE: {
                char c = this.nextChar();
                TypeAnnotationPosition typeAnnotationPosition = TypeAnnotationPosition.methodRef(this.readTypePath());
                typeAnnotationPosition.offset = c;
                return typeAnnotationPosition;
            }
            case LOCAL_VARIABLE: {
                int n2 = this.nextChar();
                int[] nArray = new int[n2];
                int[] nArray2 = new int[n2];
                int[] nArray3 = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = this.nextChar();
                    nArray2[i] = this.nextChar();
                    nArray3[i] = this.nextChar();
                }
                TypeAnnotationPosition typeAnnotationPosition = TypeAnnotationPosition.localVariable(this.readTypePath());
                typeAnnotationPosition.lvarOffset = nArray;
                typeAnnotationPosition.lvarLength = nArray2;
                typeAnnotationPosition.lvarIndex = nArray3;
                return typeAnnotationPosition;
            }
            case RESOURCE_VARIABLE: {
                int n3 = this.nextChar();
                int[] nArray = new int[n3];
                int[] nArray4 = new int[n3];
                int[] nArray5 = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = this.nextChar();
                    nArray4[i] = this.nextChar();
                    nArray5[i] = this.nextChar();
                }
                TypeAnnotationPosition typeAnnotationPosition = TypeAnnotationPosition.resourceVariable(this.readTypePath());
                typeAnnotationPosition.lvarOffset = nArray;
                typeAnnotationPosition.lvarLength = nArray4;
                typeAnnotationPosition.lvarIndex = nArray5;
                return typeAnnotationPosition;
            }
            case EXCEPTION_PARAMETER: {
                char c = this.nextChar();
                TypeAnnotationPosition typeAnnotationPosition = TypeAnnotationPosition.exceptionParameter(this.readTypePath());
                typeAnnotationPosition.setExceptionIndex(c);
                return typeAnnotationPosition;
            }
            case METHOD_RECEIVER: {
                return TypeAnnotationPosition.methodReceiver(this.readTypePath());
            }
            case CLASS_TYPE_PARAMETER: {
                int n4 = this.nextByte();
                return TypeAnnotationPosition.typeParameter(this.readTypePath(), n4);
            }
            case METHOD_TYPE_PARAMETER: {
                int n5 = this.nextByte();
                return TypeAnnotationPosition.methodTypeParameter(this.readTypePath(), n5);
            }
            case CLASS_TYPE_PARAMETER_BOUND: {
                int n6 = this.nextByte();
                int n7 = this.nextByte();
                return TypeAnnotationPosition.typeParameterBound(this.readTypePath(), n6, n7);
            }
            case METHOD_TYPE_PARAMETER_BOUND: {
                int n8 = this.nextByte();
                int n9 = this.nextByte();
                return TypeAnnotationPosition.methodTypeParameterBound(this.readTypePath(), n8, n9);
            }
            case CLASS_EXTENDS: {
                char c = this.nextChar();
                return TypeAnnotationPosition.classExtends(this.readTypePath(), (int)c);
            }
            case THROWS: {
                char c = this.nextChar();
                return TypeAnnotationPosition.methodThrows(this.readTypePath(), c);
            }
            case METHOD_FORMAL_PARAMETER: {
                int n10 = this.nextByte();
                return TypeAnnotationPosition.methodParameter(this.readTypePath(), n10);
            }
            case CAST: {
                char c = this.nextChar();
                int n11 = this.nextByte();
                TypeAnnotationPosition typeAnnotationPosition = TypeAnnotationPosition.typeCast(this.readTypePath(), n11);
                typeAnnotationPosition.offset = c;
                return typeAnnotationPosition;
            }
            case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: {
                char c = this.nextChar();
                int n12 = this.nextByte();
                TypeAnnotationPosition typeAnnotationPosition = TypeAnnotationPosition.constructorInvocationTypeArg(this.readTypePath(), n12);
                typeAnnotationPosition.offset = c;
                return typeAnnotationPosition;
            }
            case METHOD_INVOCATION_TYPE_ARGUMENT: {
                char c = this.nextChar();
                int n13 = this.nextByte();
                TypeAnnotationPosition typeAnnotationPosition = TypeAnnotationPosition.methodInvocationTypeArg(this.readTypePath(), n13);
                typeAnnotationPosition.offset = c;
                return typeAnnotationPosition;
            }
            case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: {
                char c = this.nextChar();
                int n14 = this.nextByte();
                TypeAnnotationPosition typeAnnotationPosition = TypeAnnotationPosition.constructorRefTypeArg(this.readTypePath(), n14);
                typeAnnotationPosition.offset = c;
                return typeAnnotationPosition;
            }
            case METHOD_REFERENCE_TYPE_ARGUMENT: {
                char c = this.nextChar();
                int n15 = this.nextByte();
                TypeAnnotationPosition typeAnnotationPosition = TypeAnnotationPosition.methodRefTypeArg(this.readTypePath(), n15);
                typeAnnotationPosition.offset = c;
                return typeAnnotationPosition;
            }
            case METHOD_RETURN: {
                return TypeAnnotationPosition.methodReturn(this.readTypePath());
            }
            case FIELD: {
                return TypeAnnotationPosition.field(this.readTypePath());
            }
            case UNKNOWN: {
                throw new AssertionError((Object)"jvm.ClassReader: UNKNOWN target type should never occur!");
            }
        }
        throw new AssertionError((Object)("jvm.ClassReader: Unknown target type for position: " + (Object)((Object)targetType)));
    }

    List<TypeAnnotationPosition.TypePathEntry> readTypePath() {
        int n = this.nextByte();
        ListBuffer<Integer> listBuffer = new ListBuffer<Integer>();
        for (int i = 0; i < n * 2; ++i) {
            listBuffer = listBuffer.append(this.nextByte());
        }
        return TypeAnnotationPosition.getTypePathFromBinary(listBuffer.toList());
    }

    Attribute readAttributeValue() {
        char c = (char)this.buf[this.bp++];
        switch (c) {
            case 'B': {
                return new Attribute.Constant(this.syms.byteType, this.readPool(this.nextChar()));
            }
            case 'C': {
                return new Attribute.Constant(this.syms.charType, this.readPool(this.nextChar()));
            }
            case 'D': {
                return new Attribute.Constant(this.syms.doubleType, this.readPool(this.nextChar()));
            }
            case 'F': {
                return new Attribute.Constant(this.syms.floatType, this.readPool(this.nextChar()));
            }
            case 'I': {
                return new Attribute.Constant(this.syms.intType, this.readPool(this.nextChar()));
            }
            case 'J': {
                return new Attribute.Constant(this.syms.longType, this.readPool(this.nextChar()));
            }
            case 'S': {
                return new Attribute.Constant(this.syms.shortType, this.readPool(this.nextChar()));
            }
            case 'Z': {
                return new Attribute.Constant(this.syms.booleanType, this.readPool(this.nextChar()));
            }
            case 's': {
                return new Attribute.Constant(this.syms.stringType, this.readPool(this.nextChar()).toString());
            }
            case 'e': {
                return new EnumAttributeProxy(this.readEnumType(this.nextChar()), this.readName(this.nextChar()));
            }
            case 'c': {
                return new ClassAttributeProxy(this.readTypeOrClassSymbol(this.nextChar()));
            }
            case '[': {
                int n = this.nextChar();
                ListBuffer<Attribute> listBuffer = new ListBuffer<Attribute>();
                for (int i = 0; i < n; ++i) {
                    listBuffer.append(this.readAttributeValue());
                }
                return new ArrayAttributeProxy(listBuffer.toList());
            }
            case '@': {
                return this.readCompoundAnnotation();
            }
        }
        throw new AssertionError((Object)("unknown annotation tag '" + c + "'"));
    }

    Symbol.VarSymbol readField() {
        long l = this.adjustFieldFlags(this.nextChar());
        Name name = this.readName(this.nextChar());
        Type type = this.readType(this.nextChar());
        Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(l, name, type, this.currentOwner);
        this.readMemberAttrs(varSymbol);
        return varSymbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Symbol.MethodSymbol readMethod() {
        Type type;
        Symbol.MethodSymbol methodSymbol;
        long l = this.adjustMethodFlags(this.nextChar());
        Name name = this.readName(this.nextChar());
        Type type2 = this.readType(this.nextChar());
        if (this.currentOwner.isInterface() && (l & 0x400L) == 0L && !name.equals(this.names.clinit)) {
            if (this.majorVersion > ClassFile.Version.V52.major || this.majorVersion == ClassFile.Version.V52.major && this.minorVersion >= ClassFile.Version.V52.minor) {
                if ((l & 0xAL) == 0L) {
                    this.currentOwner.flags_field |= 0x80000000000L;
                    l |= 0x80000000400L;
                }
            } else {
                throw this.badClassFile((l & 8L) == 0L ? "invalid.default.interface" : "invalid.static.interface", Integer.toString(this.majorVersion), Integer.toString(this.minorVersion));
            }
        }
        if (name == this.names.init && this.currentOwner.hasOuterInstance()) {
            boolean bl;
            boolean bl2 = bl = !this.currentOwner.owner.members().includes(this.currentOwner, Scope.LookupKind.NON_RECURSIVE);
            if (!this.currentOwner.name.isEmpty() && !bl) {
                type2 = new Type.MethodType(this.adjustMethodParams(l, type2.getParameterTypes()), type2.getReturnType(), type2.getThrownTypes(), this.syms.methodClass);
            }
        }
        if (this.types.isSignaturePolymorphic(methodSymbol = new Symbol.MethodSymbol(l, name, type2, this.currentOwner))) {
            methodSymbol.flags_field |= 0x400000000000L;
        }
        if (this.saveParameterNames) {
            this.initParameterNames(methodSymbol);
        }
        Symbol symbol = this.currentOwner;
        this.currentOwner = methodSymbol;
        try {
            this.readMemberAttrs(methodSymbol);
        }
        finally {
            this.currentOwner = symbol;
        }
        this.setParameters(methodSymbol, type2);
        if (!((l & 0x400000000L) == 0L || (type = type2.getParameterTypes().last()) != null && type.hasTag(TypeTag.ARRAY))) {
            methodSymbol.flags_field &= 0xFFFFFFFBFFFFFFFFL;
            throw this.badClassFile("malformed.vararg.method", methodSymbol);
        }
        return methodSymbol;
    }

    private List<Type> adjustMethodParams(long l, List<Type> list) {
        boolean bl;
        boolean bl2 = bl = (l & 0x400000000L) != 0L;
        if (bl) {
            Type type = list.last();
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            for (Type type2 : list) {
                listBuffer.append(type2 != type ? type2 : ((Type.ArrayType)type2).makeVarargs());
            }
            list = listBuffer.toList();
        }
        return list.tail;
    }

    void initParameterNames(Symbol.MethodSymbol methodSymbol) {
        int n = Code.width(methodSymbol.type.getParameterTypes()) + 4;
        if (this.parameterNameIndices == null || this.parameterNameIndices.length < n) {
            this.parameterNameIndices = new int[n];
        } else {
            Arrays.fill(this.parameterNameIndices, 0);
        }
        this.haveParameterNameIndices = false;
        this.sawMethodParameters = false;
    }

    void setParameters(Symbol.MethodSymbol methodSymbol, Type type) {
        int n = 0;
        if (!this.sawMethodParameters) {
            int n2 = n = (methodSymbol.flags() & 8L) == 0L ? 1 : 0;
            if (methodSymbol.name == this.names.init && this.currentOwner.hasOuterInstance() && !this.currentOwner.name.isEmpty()) {
                ++n;
            }
            if (methodSymbol.type != type) {
                int n3 = Code.width(type.getParameterTypes()) - Code.width(methodSymbol.type.getParameterTypes());
                n += n3;
            }
        }
        List<Name> list = List.nil();
        ListBuffer<Symbol.VarSymbol> listBuffer = new ListBuffer<Symbol.VarSymbol>();
        int n4 = n;
        int n5 = 0;
        for (Type type2 : methodSymbol.type.getParameterTypes()) {
            ParameterAnnotations parameterAnnotations;
            Name name = this.parameterName(n4, list);
            list = list.prepend(name);
            Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(0x200000000L, name, type2, methodSymbol);
            listBuffer.append(varSymbol);
            if (this.parameterAnnotations != null && (parameterAnnotations = this.parameterAnnotations[n5]) != null && parameterAnnotations.proxies != null && !parameterAnnotations.proxies.isEmpty()) {
                this.annotate.normal(new AnnotationCompleter(varSymbol, parameterAnnotations.proxies));
            }
            n4 += this.sawMethodParameters ? 1 : Code.width(type2);
            ++n5;
        }
        if (this.parameterAnnotations != null && this.parameterAnnotations.length != n5) {
            throw this.badClassFile("bad.runtime.invisible.param.annotations", methodSymbol);
        }
        Assert.checkNull(methodSymbol.params);
        methodSymbol.params = listBuffer.toList();
        this.parameterAnnotations = null;
        this.parameterNameIndices = null;
    }

    private Name parameterName(int n, List<Name> list) {
        if (this.parameterNameIndices != null && n < this.parameterNameIndices.length && this.parameterNameIndices[n] != 0) {
            return this.readName(this.parameterNameIndices[n]);
        }
        String string = "arg";
        Name name;
        while (list.contains(name = this.names.fromString(string + list.size()))) {
            string = string + "$";
        }
        return name;
    }

    void skipBytes(int n) {
        this.bp += n;
    }

    void skipMember() {
        this.bp += 6;
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            this.bp += 2;
            int n2 = this.nextInt();
            this.bp += n2;
        }
    }

    void skipInnerClasses() {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            this.nextChar();
            this.nextChar();
            this.nextChar();
            this.nextChar();
        }
    }

    protected void enterTypevars(Symbol symbol, Type type) {
        if (type.getEnclosingType() != null) {
            if (!type.getEnclosingType().hasTag(TypeTag.NONE)) {
                this.enterTypevars(symbol.owner, type.getEnclosingType());
            }
        } else if (symbol.kind == Kinds.Kind.MTH && !symbol.isStatic()) {
            this.enterTypevars(symbol.owner, symbol.owner.type);
        }
        List<Type> list = type.getTypeArguments();
        while (list.nonEmpty()) {
            this.typevars.enter(((Type)list.head).tsym);
            list = list.tail;
        }
    }

    protected Symbol.ClassSymbol enterClass(Name name) {
        return this.syms.enterClass(this.currentModule, name);
    }

    protected Symbol.ClassSymbol enterClass(Name name, Symbol.TypeSymbol typeSymbol) {
        return this.syms.enterClass(this.currentModule, name, typeSymbol);
    }

    void readClass(Symbol.ClassSymbol classSymbol) {
        int n;
        int n2;
        int n3;
        long l;
        long l2;
        Type.ClassType classType = (Type.ClassType)classSymbol.type;
        classSymbol.members_field = Scope.WriteableScope.create(classSymbol);
        this.typevars = this.typevars.dup(this.currentOwner);
        if (classType.getEnclosingType().hasTag(TypeTag.CLASS)) {
            this.enterTypevars(classSymbol.owner, classType.getEnclosingType());
        }
        if (((l2 = this.adjustClassFlags(l = (long)this.nextChar())) & 0x8000000000000L) == 0L) {
            if (classSymbol.owner.kind == Kinds.Kind.PCK) {
                classSymbol.flags_field = l2;
            }
            this.currentModule = classSymbol.packge().modle;
            Symbol.ClassSymbol classSymbol2 = this.readClassSymbol(this.nextChar());
            if (classSymbol != classSymbol2) {
                throw this.badClassFile("class.file.wrong.class", classSymbol2.flatname);
            }
        } else {
            if (this.majorVersion < ClassFile.Version.V53.major) {
                throw this.badClassFile("anachronistic.module.info", Integer.toString(this.majorVersion), Integer.toString(this.minorVersion));
            }
            classSymbol.flags_field = l2;
            this.currentModule = (Symbol.ModuleSymbol)classSymbol.owner;
            char c = this.nextChar();
        }
        int n4 = this.bp;
        this.nextChar();
        char c = this.nextChar();
        this.bp += c * 2;
        int n5 = this.nextChar();
        for (n3 = 0; n3 < n5; ++n3) {
            this.skipMember();
        }
        n3 = this.nextChar();
        for (n2 = 0; n2 < n3; ++n2) {
            this.skipMember();
        }
        this.readClassAttrs(classSymbol);
        if (this.readAllOfClassFile) {
            for (n2 = 1; n2 < this.poolObj.length; ++n2) {
                this.readPool(n2);
            }
            classSymbol.pool = new Pool(this.poolObj.length, this.poolObj, this.types);
        }
        this.bp = n4;
        n2 = this.nextChar();
        if ((l2 & 0x8000000000000L) != 0L && n2 > 0) {
            throw this.badClassFile("module.info.invalid.super.class", new Object[0]);
        }
        if (classType.supertype_field == null) {
            classType.supertype_field = n2 == 0 ? Type.noType : this.readClassSymbol(n2).erasure(this.types);
        }
        n2 = this.nextChar();
        List<Type> list = List.nil();
        for (n = 0; n < n2; ++n) {
            Type type = this.readClassSymbol(this.nextChar()).erasure(this.types);
            list = list.prepend(type);
        }
        if (classType.interfaces_field == null) {
            classType.interfaces_field = list.reverse();
        }
        Assert.check(n5 == this.nextChar());
        for (n = 0; n < n5; ++n) {
            this.enterMember(classSymbol, this.readField());
        }
        Assert.check(n3 == this.nextChar());
        for (n = 0; n < n3; ++n) {
            this.enterMember(classSymbol, this.readMethod());
        }
        this.typevars = this.typevars.leave();
    }

    void readInnerClasses(Symbol.ClassSymbol classSymbol) {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            this.nextChar();
            Symbol.ClassSymbol classSymbol2 = this.readClassSymbol(this.nextChar());
            Name name = this.readName(this.nextChar());
            if (name == null) {
                name = this.names.empty;
            }
            long l = this.adjustClassFlags(this.nextChar());
            if (classSymbol2 == null) continue;
            if (name == this.names.empty) {
                name = this.names.one;
            }
            Symbol.ClassSymbol classSymbol3 = this.enterClass(name, classSymbol2);
            if ((l & 8L) == 0L) {
                ((Type.ClassType)classSymbol3.type).setEnclosingType(classSymbol2.type);
                if (classSymbol3.erasure_field != null) {
                    ((Type.ClassType)classSymbol3.erasure_field).setEnclosingType(this.types.erasure(classSymbol2.type));
                }
            }
            if (classSymbol != classSymbol2) continue;
            classSymbol3.flags_field = l;
            this.enterMember(classSymbol, classSymbol3);
        }
    }

    private void readClassBuffer(Symbol.ClassSymbol classSymbol) throws IOException {
        int n = this.nextInt();
        if (n != -889275714) {
            throw this.badClassFile("illegal.start.of.class.file", new Object[0]);
        }
        this.minorVersion = this.nextChar();
        this.majorVersion = this.nextChar();
        int n2 = 53;
        int n3 = ClassFile.Version.MAX().minor;
        if (this.majorVersion > n2 || this.majorVersion * 1000 + this.minorVersion < ClassFile.Version.MIN().major * 1000 + ClassFile.Version.MIN().minor) {
            if (this.majorVersion == n2 + 1) {
                this.log.warning("big.major.version", this.currentClassFile, this.majorVersion, n2);
            } else {
                throw this.badClassFile("wrong.version", Integer.toString(this.majorVersion), Integer.toString(this.minorVersion), Integer.toString(n2), Integer.toString(n3));
            }
        }
        this.indexPool();
        if (this.signatureBuffer.length < this.bp) {
            int n4 = Integer.highestOneBit(this.bp) << 1;
            this.signatureBuffer = new byte[n4];
        }
        this.readClass(classSymbol);
    }

    public void readClassFile(Symbol.ClassSymbol classSymbol) {
        this.currentOwner = classSymbol;
        this.currentClassFile = classSymbol.classfile;
        this.warnedAttrs.clear();
        this.filling = true;
        this.target = null;
        this.repeatable = null;
        try {
            this.bp = 0;
            this.buf = ClassReader.readInputStream(this.buf, classSymbol.classfile.openInputStream());
            this.readClassBuffer(classSymbol);
            if (!this.missingTypeVariables.isEmpty() && !this.foundTypeVariables.isEmpty()) {
                List<Type> list = this.missingTypeVariables;
                List<Type> list2 = this.foundTypeVariables;
                this.missingTypeVariables = List.nil();
                this.foundTypeVariables = List.nil();
                this.interimUses = List.nil();
                this.interimProvides = List.nil();
                this.filling = false;
                Type.ClassType classType = (Type.ClassType)this.currentOwner.type;
                classType.supertype_field = this.types.subst(classType.supertype_field, list, list2);
                classType.interfaces_field = this.types.subst(classType.interfaces_field, list, list2);
                List<Type> list3 = classType.typarams_field = this.types.substBounds(classType.typarams_field, list, list2);
                while (list3.nonEmpty()) {
                    ((Type)list3.head).tsym.type = (Type)list3.head;
                    list3 = list3.tail;
                }
            } else if (this.missingTypeVariables.isEmpty() != this.foundTypeVariables.isEmpty()) {
                Name name = ((Type)this.missingTypeVariables.head).tsym.name;
                throw this.badClassFile("undecl.type.var", name);
            }
            if ((classSymbol.flags_field & 0x2000L) != 0L) {
                classSymbol.setAnnotationTypeMetadata(new Annotate.AnnotationTypeMetadata(classSymbol, new CompleterDeproxy(classSymbol, this.target, this.repeatable)));
            } else {
                classSymbol.setAnnotationTypeMetadata(Annotate.AnnotationTypeMetadata.notAnAnnotationType());
            }
            if (classSymbol == this.currentModule.module_info) {
                if (this.interimUses.nonEmpty() || this.interimProvides.nonEmpty()) {
                    Assert.check(this.currentModule.isCompleted());
                    this.currentModule.usesProvidesCompleter = new UsesProvidesCompleter(this.currentModule, this.interimUses, this.interimProvides);
                } else {
                    this.currentModule.uses = List.nil();
                    this.currentModule.provides = List.nil();
                }
            }
        }
        catch (IOException | ClosedFileSystemException exception) {
            throw this.badClassFile("unable.to.access.file", exception.toString());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.badClassFile("bad.class.file", classSymbol.flatname);
        }
        finally {
            this.interimUses = List.nil();
            this.interimProvides = List.nil();
            this.missingTypeVariables = List.nil();
            this.foundTypeVariables = List.nil();
            this.filling = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readInputStream(byte[] byArray, InputStream inputStream) throws IOException {
        try {
            byArray = ClassReader.ensureCapacity(byArray, inputStream.available());
            int n = inputStream.read(byArray);
            int n2 = 0;
            while (n != -1) {
                byArray = ClassReader.ensureCapacity(byArray, n2 += n);
                n = inputStream.read(byArray, n2, byArray.length - n2);
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static byte[] ensureCapacity(byte[] byArray, int n) {
        if (byArray.length <= n) {
            byte[] byArray2 = byArray;
            byArray = new byte[Integer.highestOneBit(n) << 1];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        }
        return byArray;
    }

    long adjustFieldFlags(long l) {
        return l;
    }

    long adjustMethodFlags(long l) {
        if ((l & 0x40L) != 0L) {
            l &= 0xFFFFFFFFFFFFFFBFL;
            l |= 0x80000000L;
        }
        if ((l & 0x80L) != 0L) {
            l &= 0xFFFFFFFFFFFFFF7FL;
            l |= 0x400000000L;
        }
        return l;
    }

    long adjustClassFlags(long l) {
        if ((l & 0x8000L) != 0L) {
            l &= 0xFFFFFFFFFFFF7FFFL;
            l |= 0x8000000000000L;
        }
        return l & 0xFFFFFFFFFFFFFFDFL;
    }

    private final class UsesProvidesCompleter
    implements Symbol.Completer {
        private final Symbol.ModuleSymbol currentModule;
        private final List<InterimUsesDirective> interimUsesCopy;
        private final List<InterimProvidesDirective> interimProvidesCopy;

        public UsesProvidesCompleter(Symbol.ModuleSymbol moduleSymbol, List<InterimUsesDirective> list, List<InterimProvidesDirective> list2) {
            this.currentModule = moduleSymbol;
            this.interimUsesCopy = list;
            this.interimProvidesCopy = list2;
        }

        @Override
        public void complete(Symbol symbol) throws Symbol.CompletionFailure {
            ListBuffer<Object> listBuffer = new ListBuffer<Object>();
            listBuffer.addAll((Collection<Object>)this.currentModule.directives);
            ListBuffer<Directive.UsesDirective> listBuffer2 = new ListBuffer<Directive.UsesDirective>();
            for (InterimUsesDirective object : this.interimUsesCopy) {
                Directive.UsesDirective usesDirective = new Directive.UsesDirective(ClassReader.this.syms.enterClass(this.currentModule, object.service));
                listBuffer2.add(usesDirective);
                listBuffer.add(usesDirective);
            }
            this.currentModule.uses = listBuffer2.toList();
            ListBuffer listBuffer3 = new ListBuffer();
            for (InterimProvidesDirective interimProvidesDirective : this.interimProvidesCopy) {
                ListBuffer<Symbol.ClassSymbol> listBuffer4 = new ListBuffer<Symbol.ClassSymbol>();
                for (Name name : interimProvidesDirective.impls) {
                    listBuffer4.append(ClassReader.this.syms.enterClass(this.currentModule, name));
                }
                Directive.ProvidesDirective providesDirective = new Directive.ProvidesDirective(ClassReader.this.syms.enterClass(this.currentModule, interimProvidesDirective.service), listBuffer4.toList());
                listBuffer3.add(providesDirective);
                listBuffer.add(providesDirective);
            }
            this.currentModule.provides = listBuffer3.toList();
            this.currentModule.directives = listBuffer.toList();
        }
    }

    private static final class InterimProvidesDirective {
        public final Name service;
        public final List<Name> impls;

        public InterimProvidesDirective(Name name, List<Name> list) {
            this.service = name;
            this.impls = list;
        }
    }

    private static final class InterimUsesDirective {
        public final Name service;

        public InterimUsesDirective(Name name) {
            this.service = name;
        }
    }

    private class ProxyType
    extends Type {
        private final byte[] content;

        public ProxyType(byte[] byArray) {
            super(ClassReader.this.syms.noSymbol, TypeMetadata.EMPTY);
            this.content = byArray;
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.NONE;
        }

        @Override
        public Type cloneWithMetadata(TypeMetadata typeMetadata) {
            throw new UnsupportedOperationException();
        }

        public Type resolve() {
            return ClassReader.this.sigToType(this.content, 0, this.content.length);
        }

        @Override
        public String toString() {
            return "<ProxyType>";
        }
    }

    private class CompleterDeproxy
    implements Annotate.AnnotationTypeCompleter {
        Symbol.ClassSymbol proxyOn;
        CompoundAnnotationProxy target;
        CompoundAnnotationProxy repeatable;

        public CompleterDeproxy(Symbol.ClassSymbol classSymbol, CompoundAnnotationProxy compoundAnnotationProxy, CompoundAnnotationProxy compoundAnnotationProxy2) {
            this.proxyOn = classSymbol;
            this.target = compoundAnnotationProxy;
            this.repeatable = compoundAnnotationProxy2;
        }

        @Override
        public void complete(Symbol.ClassSymbol classSymbol) {
            Assert.check(this.proxyOn == classSymbol);
            Attribute.Compound compound = null;
            Attribute.Compound compound2 = null;
            try {
                AnnotationDeproxy annotationDeproxy;
                if (this.target != null) {
                    annotationDeproxy = new AnnotationDeproxy(this.proxyOn);
                    compound = annotationDeproxy.deproxyCompound(this.target);
                }
                if (this.repeatable != null) {
                    annotationDeproxy = new AnnotationDeproxy(this.proxyOn);
                    compound2 = annotationDeproxy.deproxyCompound(this.repeatable);
                }
            }
            catch (Exception exception) {
                throw new Symbol.CompletionFailure((Symbol)classSymbol, exception.getMessage());
            }
            classSymbol.getAnnotationTypeMetadata().setTarget(compound);
            classSymbol.getAnnotationTypeMetadata().setRepeatable(compound2);
        }
    }

    private static class SourceFileObject
    implements JavaFileObject {
        private final Name name;
        private final Name flatname;

        public SourceFileObject(Name name, Name name2) {
            this.name = name;
            this.flatname = name2;
        }

        @Override
        public URI toUri() {
            try {
                return new URI(null, this.name.toString(), null);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new PathFileObject.CannotCreateUriError(this.name.toString(), uRISyntaxException);
            }
        }

        @Override
        public String getName() {
            return this.name.toString();
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return BaseFileManager.getKind(this.getName());
        }

        @Override
        public InputStream openInputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OutputStream openOutputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharBuffer getCharContent(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reader openReader(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Writer openWriter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLastModified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean delete() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
            return true;
        }

        @Override
        public NestingKind getNestingKind() {
            return null;
        }

        @Override
        public Modifier getAccessLevel() {
            return null;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof SourceFileObject)) {
                return false;
            }
            SourceFileObject sourceFileObject = (SourceFileObject)object;
            return this.name.equals(sourceFileObject.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    class TypeAnnotationCompleter
    extends AnnotationCompleter {
        List<TypeAnnotationProxy> proxies;

        TypeAnnotationCompleter(Symbol symbol, List<TypeAnnotationProxy> list) {
            super(symbol, List.nil());
            this.proxies = list;
        }

        List<Attribute.TypeCompound> deproxyTypeCompoundList(List<TypeAnnotationProxy> list) {
            ListBuffer<Attribute.TypeCompound> listBuffer = new ListBuffer<Attribute.TypeCompound>();
            for (TypeAnnotationProxy typeAnnotationProxy : list) {
                Attribute.Compound compound = this.deproxyCompound(typeAnnotationProxy.compound);
                Attribute.TypeCompound typeCompound = new Attribute.TypeCompound(compound, typeAnnotationProxy.position);
                listBuffer.add(typeCompound);
            }
            return listBuffer.toList();
        }

        @Override
        public void run() {
            JavaFileObject javaFileObject = ClassReader.this.currentClassFile;
            try {
                ClassReader.this.currentClassFile = this.classFile;
                List<Attribute.TypeCompound> list = this.deproxyTypeCompoundList(this.proxies);
                this.sym.setTypeAttributes(list.prependList(this.sym.getRawTypeAttributes()));
            }
            finally {
                ClassReader.this.currentClassFile = javaFileObject;
            }
        }
    }

    class AnnotationCompleter
    extends AnnotationDeproxy
    implements Runnable {
        final Symbol sym;
        final List<CompoundAnnotationProxy> l;
        final JavaFileObject classFile;

        AnnotationCompleter(Symbol symbol, List<CompoundAnnotationProxy> list) {
            super(ClassReader.this.currentOwner.kind == Kinds.Kind.MTH ? ClassReader.this.currentOwner.enclClass() : (Symbol.ClassSymbol)ClassReader.this.currentOwner);
            this.sym = symbol.kind == Kinds.Kind.TYP && symbol.owner.kind == Kinds.Kind.MDL ? symbol.owner : symbol;
            this.l = list;
            this.classFile = ClassReader.this.currentClassFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JavaFileObject javaFileObject = ClassReader.this.currentClassFile;
            try {
                ClassReader.this.currentClassFile = this.classFile;
                List<Attribute.Compound> list = this.deproxyCompoundList(this.l);
                for (Attribute.Compound compound : list) {
                    if (compound.type.tsym != ClassReader.this.syms.deprecatedType.tsym) continue;
                    this.sym.flags_field |= 0x40000000020000L;
                    Attribute attribute = compound.member(ClassReader.this.names.forRemoval);
                    if (!(attribute instanceof Attribute.Constant)) continue;
                    Attribute.Constant constant = (Attribute.Constant)attribute;
                    if (constant.type != ClassReader.this.syms.booleanType || (Integer)constant.value == 0) continue;
                    this.sym.flags_field |= 0x80000000000000L;
                }
                if (this.sym.annotationsPendingCompletion()) {
                    this.sym.setDeclarationAttributes(list);
                } else {
                    this.sym.appendAttributes(list);
                }
            }
            finally {
                ClassReader.this.currentClassFile = javaFileObject;
            }
        }

        public String toString() {
            return " ClassReader annotate " + this.sym.owner + "." + this.sym + " with " + this.l;
        }
    }

    class AnnotationDefaultCompleter
    extends AnnotationDeproxy
    implements Runnable {
        final Symbol.MethodSymbol sym;
        final Attribute value;
        final JavaFileObject classFile;

        AnnotationDefaultCompleter(Symbol.MethodSymbol methodSymbol, Attribute attribute) {
            super(ClassReader.this.currentOwner.kind == Kinds.Kind.MTH ? ClassReader.this.currentOwner.enclClass() : (Symbol.ClassSymbol)ClassReader.this.currentOwner);
            this.classFile = ClassReader.this.currentClassFile;
            this.sym = methodSymbol;
            this.value = attribute;
        }

        @Override
        public void run() {
            JavaFileObject javaFileObject = ClassReader.this.currentClassFile;
            try {
                this.sym.defaultValue = null;
                ClassReader.this.currentClassFile = this.classFile;
                this.sym.defaultValue = this.deproxy(this.sym.type.getReturnType(), this.value);
            }
            finally {
                ClassReader.this.currentClassFile = javaFileObject;
            }
        }

        public String toString() {
            return " ClassReader store default for " + this.sym.owner + "." + this.sym + " is " + this.value;
        }
    }

    class AnnotationDeproxy
    implements ProxyVisitor {
        private Symbol.ClassSymbol requestingOwner;
        Attribute result;
        Type type;

        AnnotationDeproxy(Symbol.ClassSymbol classSymbol) {
            this.requestingOwner = classSymbol;
        }

        List<Attribute.Compound> deproxyCompoundList(List<CompoundAnnotationProxy> list) {
            ListBuffer<Attribute.Compound> listBuffer = new ListBuffer<Attribute.Compound>();
            List<CompoundAnnotationProxy> list2 = list;
            while (list2.nonEmpty()) {
                listBuffer.append(this.deproxyCompound((CompoundAnnotationProxy)list2.head));
                list2 = list2.tail;
            }
            return listBuffer.toList();
        }

        Attribute.Compound deproxyCompound(CompoundAnnotationProxy compoundAnnotationProxy) {
            Type type = this.resolvePossibleProxyType(compoundAnnotationProxy.type);
            ListBuffer<Pair<Symbol.MethodSymbol, Attribute>> listBuffer = new ListBuffer<Pair<Symbol.MethodSymbol, Attribute>>();
            List<Pair<Name, Attribute>> list = compoundAnnotationProxy.values;
            while (list.nonEmpty()) {
                Symbol.MethodSymbol methodSymbol = this.findAccessMethod(type, (Name)((Pair)list.head).fst);
                listBuffer.append(new Pair<Symbol.MethodSymbol, Attribute>(methodSymbol, this.deproxy(methodSymbol.type.getReturnType(), (Attribute)((Pair)list.head).snd)));
                list = list.tail;
            }
            return new Attribute.Compound(type, listBuffer.toList());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Symbol.MethodSymbol findAccessMethod(Type type, Name name) {
            AnnoConstruct annoConstruct2;
            Symbol.CompletionFailure completionFailure = null;
            try {
                for (AnnoConstruct annoConstruct2 : type.tsym.members().getSymbolsByName(name)) {
                    if (annoConstruct2.kind != Kinds.Kind.MTH || annoConstruct2.type.getParameterTypes().length() != 0) continue;
                    return (Symbol.MethodSymbol)annoConstruct2;
                }
            }
            catch (Symbol.CompletionFailure completionFailure2) {
                completionFailure = completionFailure2;
            }
            JavaFileObject javaFileObject = ClassReader.this.log.useSource(this.requestingOwner.classfile);
            try {
                if (ClassReader.this.lintClassfile) {
                    if (completionFailure == null) {
                        ClassReader.this.log.warning("annotation.method.not.found", type, name);
                    } else {
                        ClassReader.this.log.warning("annotation.method.not.found.reason", type, name, completionFailure.getDetailValue());
                    }
                }
            }
            finally {
                ClassReader.this.log.useSource(javaFileObject);
            }
            annoConstruct2 = new Type.MethodType(List.nil(), ClassReader.this.syms.botType, List.nil(), ClassReader.this.syms.methodClass);
            return new Symbol.MethodSymbol(1025L, name, (Type)annoConstruct2, type.tsym);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Attribute deproxy(Type type, Attribute attribute) {
            Type type2 = this.type;
            try {
                this.type = type;
                attribute.accept(this);
                Attribute attribute2 = this.result;
                return attribute2;
            }
            finally {
                this.type = type2;
            }
        }

        @Override
        public void visitConstant(Attribute.Constant constant) {
            this.result = constant;
        }

        @Override
        public void visitClass(Attribute.Class clazz) {
            this.result = clazz;
        }

        @Override
        public void visitEnum(Attribute.Enum enum_) {
            throw new AssertionError();
        }

        @Override
        public void visitCompound(Attribute.Compound compound) {
            throw new AssertionError();
        }

        @Override
        public void visitArray(Attribute.Array array) {
            throw new AssertionError();
        }

        @Override
        public void visitError(Attribute.Error error) {
            throw new AssertionError();
        }

        @Override
        public void visitEnumAttributeProxy(EnumAttributeProxy enumAttributeProxy) {
            Type type = this.resolvePossibleProxyType(enumAttributeProxy.enumType);
            Symbol.TypeSymbol typeSymbol = type.tsym;
            Symbol.VarSymbol varSymbol = null;
            Symbol.CompletionFailure completionFailure = null;
            try {
                for (Symbol symbol : typeSymbol.members().getSymbolsByName(enumAttributeProxy.enumerator)) {
                    if (symbol.kind != Kinds.Kind.VAR) continue;
                    varSymbol = (Symbol.VarSymbol)symbol;
                    break;
                }
            }
            catch (Symbol.CompletionFailure completionFailure2) {
                completionFailure = completionFailure2;
            }
            if (varSymbol == null) {
                if (completionFailure != null) {
                    ClassReader.this.log.warning("unknown.enum.constant.reason", ClassReader.this.currentClassFile, typeSymbol, enumAttributeProxy.enumerator, completionFailure.getDiagnostic());
                } else {
                    ClassReader.this.log.warning("unknown.enum.constant", ClassReader.this.currentClassFile, typeSymbol, enumAttributeProxy.enumerator);
                }
                this.result = new Attribute.Enum(typeSymbol.type, new Symbol.VarSymbol(0L, enumAttributeProxy.enumerator, ClassReader.this.syms.botType, typeSymbol));
            } else {
                this.result = new Attribute.Enum(typeSymbol.type, varSymbol);
            }
        }

        @Override
        public void visitClassAttributeProxy(ClassAttributeProxy classAttributeProxy) {
            Type type = this.resolvePossibleProxyType(classAttributeProxy.classType);
            this.result = new Attribute.Class(ClassReader.this.types, type);
        }

        @Override
        public void visitArrayAttributeProxy(ArrayAttributeProxy arrayAttributeProxy) {
            int n = arrayAttributeProxy.values.length();
            Attribute[] attributeArray = new Attribute[n];
            Type type = ClassReader.this.types.elemtype(this.type);
            int n2 = 0;
            List<Attribute> list = arrayAttributeProxy.values;
            while (list.nonEmpty()) {
                attributeArray[n2++] = this.deproxy(type, (Attribute)list.head);
                list = list.tail;
            }
            this.result = new Attribute.Array(this.type, attributeArray);
        }

        @Override
        public void visitCompoundAnnotationProxy(CompoundAnnotationProxy compoundAnnotationProxy) {
            this.result = this.deproxyCompound(compoundAnnotationProxy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Type resolvePossibleProxyType(Type type) {
            if (type instanceof ProxyType) {
                Assert.check(this.requestingOwner.owner.kind == Kinds.Kind.MDL);
                Symbol.ModuleSymbol moduleSymbol = ClassReader.this.currentModule;
                ClassReader.this.currentModule = (Symbol.ModuleSymbol)this.requestingOwner.owner;
                try {
                    Type type2 = ((ProxyType)type).resolve();
                    return type2;
                }
                finally {
                    ClassReader.this.currentModule = moduleSymbol;
                }
            }
            return type;
        }
    }

    static class TypeAnnotationProxy {
        final CompoundAnnotationProxy compound;
        final TypeAnnotationPosition position;

        public TypeAnnotationProxy(CompoundAnnotationProxy compoundAnnotationProxy, TypeAnnotationPosition typeAnnotationPosition) {
            this.compound = compoundAnnotationProxy;
            this.position = typeAnnotationPosition;
        }
    }

    static class CompoundAnnotationProxy
    extends Attribute {
        final List<Pair<Name, Attribute>> values;

        public CompoundAnnotationProxy(Type type, List<Pair<Name, Attribute>> list) {
            super(type);
            this.values = list;
        }

        @Override
        public void accept(Attribute.Visitor visitor) {
            ((ProxyVisitor)visitor).visitCompoundAnnotationProxy(this);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("@");
            stringBuilder.append(this.type.tsym.getQualifiedName());
            stringBuilder.append("/*proxy*/{");
            boolean bl = true;
            List<Pair<Name, Attribute>> list = this.values;
            while (list.nonEmpty()) {
                Pair pair = (Pair)list.head;
                if (!bl) {
                    stringBuilder.append(",");
                }
                bl = false;
                stringBuilder.append((CharSequence)pair.fst);
                stringBuilder.append("=");
                stringBuilder.append(pair.snd);
                list = list.tail;
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }

    static class ArrayAttributeProxy
    extends Attribute {
        List<Attribute> values;

        ArrayAttributeProxy(List<Attribute> list) {
            super(null);
            this.values = list;
        }

        @Override
        public void accept(Attribute.Visitor visitor) {
            ((ProxyVisitor)visitor).visitArrayAttributeProxy(this);
        }

        @Override
        public String toString() {
            return "{" + this.values + "}";
        }
    }

    static class ClassAttributeProxy
    extends Attribute {
        Type classType;

        public ClassAttributeProxy(Type type) {
            super(null);
            this.classType = type;
        }

        @Override
        public void accept(Attribute.Visitor visitor) {
            ((ProxyVisitor)visitor).visitClassAttributeProxy(this);
        }

        @Override
        public String toString() {
            return "/*proxy class*/" + this.classType + ".class";
        }
    }

    static class EnumAttributeProxy
    extends Attribute {
        Type enumType;
        Name enumerator;

        public EnumAttributeProxy(Type type, Name name) {
            super(null);
            this.enumType = type;
            this.enumerator = name;
        }

        @Override
        public void accept(Attribute.Visitor visitor) {
            ((ProxyVisitor)visitor).visitEnumAttributeProxy(this);
        }

        @Override
        public String toString() {
            return "/*proxy enum*/" + this.enumType + "." + this.enumerator;
        }
    }

    static interface ProxyVisitor
    extends Attribute.Visitor {
        public void visitEnumAttributeProxy(EnumAttributeProxy var1);

        public void visitClassAttributeProxy(ClassAttributeProxy var1);

        public void visitArrayAttributeProxy(ArrayAttributeProxy var1);

        public void visitCompoundAnnotationProxy(CompoundAnnotationProxy var1);
    }

    protected abstract class AttributeReader {
        protected final Name name;
        protected final ClassFile.Version version;
        protected final Set<AttributeKind> kinds;

        protected AttributeReader(Name name, ClassFile.Version version, Set<AttributeKind> set) {
            this.name = name;
            this.version = version;
            this.kinds = set;
        }

        protected boolean accepts(AttributeKind attributeKind) {
            if (this.kinds.contains((Object)attributeKind)) {
                if (ClassReader.this.majorVersion > this.version.major || ClassReader.this.majorVersion == this.version.major && ClassReader.this.minorVersion >= this.version.minor) {
                    return true;
                }
                if (ClassReader.this.lintClassfile && !ClassReader.this.warnedAttrs.contains(this.name)) {
                    JavaFileObject javaFileObject = ClassReader.this.log.useSource(ClassReader.this.currentClassFile);
                    try {
                        ClassReader.this.log.warning(Lint.LintCategory.CLASSFILE, (JCDiagnostic.DiagnosticPosition)null, "future.attr", this.name, this.version.major, this.version.minor, ClassReader.this.majorVersion, ClassReader.this.minorVersion);
                    }
                    finally {
                        ClassReader.this.log.useSource(javaFileObject);
                    }
                    ClassReader.this.warnedAttrs.add(this.name);
                }
            }
            return false;
        }

        protected abstract void read(Symbol var1, int var2);
    }

    protected static enum AttributeKind {
        CLASS,
        MEMBER;

    }

    static class ParameterAnnotations {
        List<CompoundAnnotationProxy> proxies;

        ParameterAnnotations() {
        }

        void add(List<CompoundAnnotationProxy> list) {
            this.proxies = this.proxies == null ? list : this.proxies.prependList(list);
        }
    }
}

