/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server.internal;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.Trailers;
import org.eclipse.jetty.http2.CloseState;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Channel;
import org.eclipse.jetty.http2.HTTP2Stream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.server.internal.HTTP2ServerConnection;
import org.eclipse.jetty.http2.server.internal.ServerHTTP2StreamEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.TunnelSupport;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpStreamOverHTTP2
implements HttpStream,
HTTP2Channel.Server {
    private static final Logger LOG = LoggerFactory.getLogger(HttpStreamOverHTTP2.class);
    private final AutoLock lock = new AutoLock();
    private final HTTP2ServerConnection _connection;
    private final HttpChannel _httpChannel;
    private final HTTP2Stream _stream;
    private MetaData.Request _requestMetaData;
    private MetaData.Response _responseMetaData;
    private TunnelSupport tunnelSupport;
    private Content.Chunk _chunk;
    private Content.Chunk _trailer;
    private boolean committed;
    private boolean _demand;

    public HttpStreamOverHTTP2(HTTP2ServerConnection connection, HttpChannel httpChannel, HTTP2Stream stream) {
        this._connection = connection;
        this._httpChannel = httpChannel;
        this._stream = stream;
    }

    public String getId() {
        return String.valueOf(this._stream.getId());
    }

    public Runnable onRequest(HeadersFrame frame) {
        try {
            HttpField expectField;
            this._requestMetaData = (MetaData.Request)frame.getMetaData();
            ComplianceViolation.Listener listener = this._httpChannel.getComplianceViolationListener();
            Runnable handler = this._httpChannel.onRequest(this._requestMetaData);
            Request request = this._httpChannel.getRequest();
            listener.onRequestBegin((Attributes)request);
            HttpCompliance httpCompliance = this._httpChannel.getConnectionMetaData().getHttpConfiguration().getHttpCompliance();
            HttpCompliance.checkHttpCompliance((MetaData.Request)this._requestMetaData, (HttpCompliance)httpCompliance, (ComplianceViolation.Listener)listener);
            if (frame.isEndStream()) {
                try (AutoLock ignored = this.lock.lock();){
                    this._chunk = Content.Chunk.EOF;
                }
            }
            HttpFields fields = this._requestMetaData.getHttpFields();
            if (this._requestMetaData instanceof MetaData.ConnectRequest) {
                this.tunnelSupport = new TunnelSupportOverHTTP2(this._requestMetaData.getProtocol());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 request #{}/{}, {} {} {}{}{}", new Object[]{this._stream.getId(), Integer.toHexString(this._stream.getSession().hashCode()), this._requestMetaData.getMethod(), this._requestMetaData.getHttpURI(), this._requestMetaData.getHttpVersion(), System.lineSeparator(), fields});
            }
            if ((expectField = fields.getField(HttpHeader.EXPECT)) != null && !HttpHeaderValue.CONTINUE.is(expectField.getValue())) {
                throw new BadMessageException(417);
            }
            Invocable.InvocationType invocationType = Invocable.getInvocationType((Object)handler);
            return new Invocable.ReadyTask(invocationType, handler){

                public void run() {
                    if (HttpStreamOverHTTP2.this._stream.isClosed()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("HTTP2 request #{}/{} skipped handling, stream already closed {}", new Object[]{HttpStreamOverHTTP2.this._stream.getId(), Integer.toHexString(HttpStreamOverHTTP2.this._stream.getSession().hashCode()), HttpStreamOverHTTP2.this._stream});
                        }
                    } else {
                        super.run();
                    }
                }
            };
        }
        catch (Throwable x) {
            HttpException.RuntimeException runtimeException;
            if (x instanceof HttpException) {
                HttpException http = (HttpException)x;
                runtimeException = http;
            } else {
                runtimeException = new HttpException.RuntimeException(500, x);
            }
            HttpException.RuntimeException httpException = runtimeException;
            return this.onBadMessage((HttpException)httpException);
        }
    }

    private Runnable onBadMessage(HttpException x) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("badMessage {} {}", (Object)this, (Object)x);
        }
        Throwable failure = (Throwable)x;
        return this._httpChannel.onFailure(failure);
    }

    public Content.Chunk read() {
        Content.Chunk chunk;
        if (this.tunnelSupport != null) {
            return null;
        }
        try (AutoLock ignored = this.lock.lock();){
            chunk = this._chunk;
            this._chunk = Content.Chunk.next((Content.Chunk)chunk);
        }
        if (chunk != null) {
            return chunk;
        }
        Stream.Data data = this._stream.readData();
        if (data == null) {
            return null;
        }
        if (data.frame().isEndStream()) {
            try (AutoLock ignored = this.lock.lock();){
                Content.Chunk trailer = this._trailer;
                if (trailer != null) {
                    data.release();
                    this._chunk = Content.Chunk.next((Content.Chunk)trailer);
                    Content.Chunk chunk2 = trailer;
                    return chunk2;
                }
            }
        }
        chunk = this.createChunk(data);
        try (AutoLock ignored = this.lock.lock();){
            this._chunk = Content.Chunk.next((Content.Chunk)chunk);
        }
        return chunk;
    }

    public void demand() {
        boolean notify = false;
        boolean demand = false;
        try (AutoLock ignored = this.lock.lock();){
            if (this._chunk != null || this._trailer != null) {
                notify = true;
            } else if (!this._demand) {
                this._demand = true;
                demand = true;
            }
        }
        if (notify) {
            Runnable task = this._httpChannel.onContentAvailable();
            if (task != null) {
                this._connection.offerTask(task, true);
            }
        } else if (demand) {
            this._stream.demand();
        }
    }

    public Runnable onDataAvailable() {
        try (AutoLock ignored = this.lock.lock();){
            this._demand = false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Request #{}/{}: data available", (Object)this._stream.getId(), (Object)Integer.toHexString(this._stream.getSession().hashCode()));
        }
        return this._httpChannel.onContentAvailable();
    }

    public Runnable onTrailer(HeadersFrame frame) {
        HttpFields trailers = frame.getMetaData().getHttpFields().asImmutable();
        try (AutoLock ignored = this.lock.lock();){
            this._trailer = new Trailers(trailers);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Request #{}/{}, trailer:{}{}", new Object[]{this._stream.getId(), Integer.toHexString(this._stream.getSession().hashCode()), System.lineSeparator(), trailers});
        }
        return this._httpChannel.onContentAvailable();
    }

    private Content.Chunk createChunk(Stream.Data data) {
        DataFrame frame = data.frame();
        if (frame.isEndStream() && frame.remaining() == 0) {
            data.release();
            return Content.Chunk.EOF;
        }
        return Content.Chunk.asChunk((ByteBuffer)frame.getByteBuffer(), (boolean)frame.isEndStream(), (Retainable)data);
    }

    public void prepareResponse(HttpFields.Mutable headers) {
    }

    public void send(MetaData.Request request, MetaData.Response response, boolean last, ByteBuffer byteBuffer, Callback callback) {
        ByteBuffer content;
        ByteBuffer byteBuffer2 = content = byteBuffer != null ? byteBuffer : BufferUtil.EMPTY_BUFFER;
        if (response != null) {
            this.sendHeaders(request, response, content, last, callback);
        } else {
            this.sendContent(request, content, last, callback);
        }
    }

    private void sendHeaders(MetaData.Request request, MetaData.Response response, ByteBuffer content, boolean last, Callback callback) {
        HeadersFrame headersFrame;
        this._responseMetaData = response;
        DataFrame dataFrame = null;
        HeadersFrame trailersFrame = null;
        boolean isHeadRequest = HttpMethod.HEAD.is(request.getMethod());
        boolean hasContent = BufferUtil.hasContent((ByteBuffer)content) && !isHeadRequest;
        int streamId = this._stream.getId();
        if (HttpStatus.isInterim((int)response.getStatus())) {
            if (hasContent) {
                callback.failed((Throwable)new IllegalStateException("Interim response cannot have content"));
                return;
            }
            headersFrame = new HeadersFrame(streamId, (MetaData)response, null, false);
        } else {
            this.committed = true;
            if (last) {
                long realContentLength = BufferUtil.length((ByteBuffer)content);
                long contentLength = response.getContentLength();
                if (contentLength < 0L) {
                    this._responseMetaData = new MetaData.Response(response.getStatus(), response.getReason(), response.getHttpVersion(), response.getHttpFields(), realContentLength, response.getTrailersSupplier());
                } else if (hasContent && contentLength != realContentLength) {
                    callback.failed((Throwable)new HttpException.RuntimeException(500, String.format("Incorrect Content-Length %d!=%d", contentLength, realContentLength)));
                    return;
                }
            }
            if (hasContent) {
                headersFrame = new HeadersFrame(streamId, (MetaData)response, null, false);
                if (last) {
                    HttpFields trailers = this.retrieveTrailers();
                    if (trailers == null) {
                        dataFrame = new DataFrame(streamId, content, true);
                    } else {
                        dataFrame = new DataFrame(streamId, content, false);
                        trailersFrame = new HeadersFrame(streamId, new MetaData(HttpVersion.HTTP_2, trailers), null, true);
                    }
                } else {
                    dataFrame = new DataFrame(streamId, content, false);
                }
            } else if (last) {
                if (this.isTunnel(request, response)) {
                    headersFrame = new HeadersFrame(streamId, (MetaData)response, null, false);
                } else {
                    HttpFields trailers = this.retrieveTrailers();
                    if (trailers == null) {
                        headersFrame = new HeadersFrame(streamId, (MetaData)response, null, true);
                    } else {
                        headersFrame = new HeadersFrame(streamId, (MetaData)response, null, false);
                        trailersFrame = new HeadersFrame(streamId, new MetaData(HttpVersion.HTTP_2, trailers), null, true);
                    }
                }
            } else {
                headersFrame = new HeadersFrame(streamId, (MetaData)response, null, false);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{}:{}{} {}{}{}", new Object[]{this._stream.getId(), Integer.toHexString(this._stream.getSession().hashCode()), System.lineSeparator(), HttpVersion.HTTP_2, response.getStatus(), System.lineSeparator(), response.getHttpFields()});
        }
        this._stream.send(new HTTP2Stream.FrameList(headersFrame, dataFrame, trailersFrame), callback);
    }

    private void sendContent(MetaData.Request request, ByteBuffer content, boolean last, Callback callback) {
        boolean hasContent;
        boolean isHeadRequest = HttpMethod.HEAD.is(request.getMethod());
        boolean bl = hasContent = BufferUtil.hasContent((ByteBuffer)content) && !isHeadRequest;
        if (hasContent || last && !this.isTunnel(request, this._responseMetaData)) {
            if (!hasContent) {
                content = BufferUtil.EMPTY_BUFFER;
            }
            if (last) {
                HttpFields trailers = this.retrieveTrailers();
                if (trailers == null) {
                    this.sendDataFrame(content, true, true, callback);
                } else if (hasContent) {
                    SendTrailers sendTrailers = new SendTrailers(callback, trailers);
                    this.sendDataFrame(content, true, false, (Callback)sendTrailers);
                } else {
                    this.sendTrailersFrame(new MetaData(HttpVersion.HTTP_2, trailers), callback);
                }
            } else {
                this.sendDataFrame(content, false, false, callback);
            }
        } else {
            callback.succeeded();
        }
    }

    public Runnable cancelSend(Throwable cause, Callback appCallback) {
        return () -> {
            this._stream.reset(new ResetFrame(this._stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
            this._stream.getSession().flush(Callback.from(() -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("cancelSend reset and flushed");
                }
                appCallback.failed(cause);
            }));
        };
    }

    private HttpFields retrieveTrailers() {
        Supplier supplier = this._responseMetaData.getTrailersSupplier();
        if (supplier == null) {
            return null;
        }
        HttpFields trailers = (HttpFields)supplier.get();
        if (trailers == null) {
            return null;
        }
        return trailers.size() == 0 ? null : trailers;
    }

    private boolean isTunnel(MetaData.Request request, MetaData.Response response) {
        return MetaData.isTunnel((String)request.getMethod(), (int)response.getStatus());
    }

    public long getIdleTimeout() {
        return this._stream.getIdleTimeout();
    }

    public void setIdleTimeout(long idleTimeoutMs) {
        this._stream.setIdleTimeout(idleTimeoutMs);
    }

    public void push(final MetaData.Request resource) {
        if (!this._stream.getSession().isPushEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP/2 push disabled for {}", (Object)resource);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP/2 push {}", (Object)resource);
        }
        this._stream.push(new PushPromiseFrame(this._stream.getId(), resource), (Promise)new Promise<Stream>(this){
            final /* synthetic */ HttpStreamOverHTTP2 this$0;
            {
                this.this$0 = this$0;
            }

            public void succeeded(Stream pushStream) {
                this.this$0._connection.push((HTTP2Stream)pushStream, resource);
            }

            public void failed(Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not HTTP/2 push {}", (Object)resource, (Object)x);
                }
            }
        }, null);
    }

    public Runnable onPushRequest(MetaData.Request request) {
        try {
            this._requestMetaData = request;
            Runnable task = this._httpChannel.onRequest(request);
            this._httpChannel.getRequest().setAttribute("org.eclipse.jetty.pushed", (Object)Boolean.TRUE);
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP/2 push request #{}/{}:{}{} {} {}{}{}", new Object[]{this._stream.getId(), Integer.toHexString(this._stream.getSession().hashCode()), System.lineSeparator(), request.getMethod(), request.getHttpURI(), request.getHttpVersion(), System.lineSeparator(), request.getHttpFields()});
            }
            return task;
        }
        catch (Throwable x) {
            HttpException.RuntimeException runtimeException;
            if (x instanceof HttpException) {
                HttpException http = (HttpException)x;
                runtimeException = http;
            } else {
                runtimeException = new HttpException.RuntimeException(500, x);
            }
            HttpException.RuntimeException httpException = runtimeException;
            return () -> this.lambda$onPushRequest$2((HttpException)httpException);
        }
    }

    private void sendDataFrame(ByteBuffer content, boolean lastContent, boolean endStream, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{}: {} content bytes{}", new Object[]{this._stream.getId(), Integer.toHexString(this._stream.getSession().hashCode()), content.remaining(), lastContent ? " (last chunk)" : ""});
        }
        DataFrame frame = new DataFrame(this._stream.getId(), content, endStream);
        this._stream.data(frame, callback);
    }

    private void sendTrailersFrame(MetaData metaData, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{}: trailers", (Object)this._stream.getId(), (Object)Integer.toHexString(this._stream.getSession().hashCode()));
        }
        HeadersFrame frame = new HeadersFrame(this._stream.getId(), metaData, null, true);
        this._stream.headers(frame, callback);
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean isIdle() {
        return false;
    }

    public TunnelSupport getTunnelSupport() {
        return this.tunnelSupport;
    }

    public Throwable consumeAvailable() {
        if (this.tunnelSupport != null) {
            return null;
        }
        Throwable result = HttpStream.consumeAvailable((HttpStream)this, (HttpConfiguration)this._httpChannel.getConnectionMetaData().getHttpConfiguration());
        if (result != null) {
            this._trailer = null;
            if (this._chunk != null) {
                this._chunk.release();
            }
            this._chunk = Content.Chunk.from((Throwable)result, (boolean)true);
        }
        return result;
    }

    public void onTimeout(TimeoutException timeout, BiConsumer<Runnable, Boolean> consumer) {
        HttpChannel.IdleTimeoutTask task = this._httpChannel.onIdleTimeout(timeout);
        consumer.accept(task.action(), !task.handlingRequest());
    }

    public Runnable onFailure(Throwable failure, Callback callback) {
        boolean remote = failure instanceof EOFException;
        Runnable task = remote ? this._httpChannel.onRemoteFailure((Throwable)new EofException(failure)) : this._httpChannel.onFailure(failure);
        return new FailureTask(task, callback);
    }

    public void succeeded() {
        if (!this._stream.isClosed()) {
            if (this.isTunnel(this._requestMetaData, this._responseMetaData)) {
                Connection connection = (Connection)this._httpChannel.getRequest().getAttribute(HttpStream.UPGRADE_CONNECTION_ATTRIBUTE);
                if (connection == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("HTTP2 response #{}/{}: no upgrade connection, resetting stream", (Object)this._stream.getId(), (Object)Integer.toHexString(this._stream.getSession().hashCode()));
                    }
                    this._stream.reset(new ResetFrame(this._stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
                } else {
                    EndPoint endPoint = this.tunnelSupport.getEndPoint();
                    this._stream.setAttachment((Object)endPoint);
                    endPoint.upgrade(connection);
                }
            } else if (HttpMethod.CONNECT.is(this._requestMetaData.getMethod())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("HTTP2 response #{}/{}: tunnel failed with {} response", new Object[]{this._stream.getId(), Integer.toHexString(this._stream.getSession().hashCode()), this._responseMetaData.getStatus()});
                }
                if (this._stream.updateClose(true, CloseState.Event.RECEIVED)) {
                    this._stream.getSession().removeStream((Stream)this._stream);
                } else {
                    this._stream.reset(new ResetFrame(this._stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("HTTP2 response #{}/{}: unconsumed request content, resetting stream", (Object)this._stream.getId(), (Object)Integer.toHexString(this._stream.getSession().hashCode()));
                }
                this._stream.reset(new ResetFrame(this._stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
            }
        }
        this._httpChannel.recycle();
        this._connection.offerHttpChannel(this._httpChannel);
    }

    public void failed(Throwable x) {
        if (HttpMethod.CONNECT.is(this._requestMetaData.getMethod())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 response #{}/{}: tunnel failed", new Object[]{this._stream.getId(), Integer.toHexString(this._stream.getSession().hashCode()), x});
            }
            if (this._stream.updateClose(true, CloseState.Event.RECEIVED)) {
                this._stream.getSession().removeStream((Stream)this._stream);
            } else {
                this._stream.reset(new ResetFrame(this._stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
            }
        } else {
            ErrorCode errorCode;
            ErrorCode errorCode2 = errorCode = x == HttpStream.CONTENT_NOT_CONSUMED ? ErrorCode.NO_ERROR : ErrorCode.CANCEL_STREAM_ERROR;
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 response #{}/{}: failed {}", new Object[]{this._stream.getId(), Integer.toHexString(this._stream.getSession().hashCode()), errorCode, x});
            }
            this._stream.reset(new ResetFrame(this._stream.getId(), errorCode.code), Callback.NOOP);
        }
    }

    private /* synthetic */ void lambda$onPushRequest$2(HttpException httpException) {
        this.onBadMessage(httpException);
    }

    private class TunnelSupportOverHTTP2
    implements TunnelSupport {
        private final String protocol;
        private final EndPoint endPoint;

        private TunnelSupportOverHTTP2(String protocol) {
            this.endPoint = new ServerHTTP2StreamEndPoint(HttpStreamOverHTTP2.this._stream);
            this.protocol = protocol;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public EndPoint getEndPoint() {
            return this.endPoint;
        }
    }

    private class SendTrailers
    extends Callback.Nested {
        private final HttpFields trailers;

        private SendTrailers(Callback callback, HttpFields trailers) {
            super(callback);
            this.trailers = trailers;
        }

        public void succeeded() {
            HttpStreamOverHTTP2.this.sendTrailersFrame(new MetaData(HttpVersion.HTTP_2, this.trailers), this.getCallback());
        }
    }

    private static class FailureTask
    implements Runnable {
        private final Runnable task;
        private final Callback callback;

        private FailureTask(Runnable task, Callback callback) {
            this.task = task;
            this.callback = Objects.requireNonNull(callback);
        }

        @Override
        public void run() {
            try {
                if (this.task != null) {
                    this.task.run();
                }
                this.callback.succeeded();
            }
            catch (Throwable x) {
                this.callback.failed(x);
            }
        }

        public String toString() {
            return "%s[%s]".formatted(TypeUtil.toShortName(this.getClass()), this.task);
        }
    }
}

