/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonObject;

public class NodeInfo {
    private final String id;
    private final String primary;
    private final String backup;

    public String getId() {
        return this.id;
    }

    public String getPrimary() {
        return this.primary;
    }

    public String getBackup() {
        return this.backup;
    }

    public static NodeInfo[] from(String jsonString) throws Exception {
        JsonArray array = JsonUtil.readJsonArray(jsonString);
        NodeInfo[] nodes = new NodeInfo[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            NodeInfo role;
            JsonObject nodeObject = array.getJsonObject(i);
            nodes[i] = role = new NodeInfo(nodeObject.getString("nodeID"), nodeObject.getString("primary", null), nodeObject.getString("backup", null));
        }
        return nodes;
    }

    public NodeInfo(String id, String primary, String backup) {
        this.id = id;
        this.primary = primary;
        this.backup = backup;
    }
}

