# Generated by tools/asdl_py.py
from pypy.interpreter.baseobjspace import W_Root
from pypy.interpreter import typedef
from pypy.interpreter.gateway import interp2app
from pypy.interpreter.error import OperationError, operationerrfmt
from rpython.rlib.unroll import unrolling_iterable
from rpython.tool.pairtype import extendabletype
from rpython.tool.sourcetools import func_with_new_name


def check_string(space, w_obj):
    if not (space.isinstance_w(w_obj, space.w_str) or
            space.isinstance_w(w_obj, space.w_unicode)):
        raise OperationError(space.w_TypeError, space.wrap(
                'AST string must be of type str or unicode'))
    return w_obj


class AST(W_Root):

    w_dict = None

    __metaclass__ = extendabletype

    def walkabout(self, visitor):
        raise AssertionError("walkabout() implementation not provided")

    def mutate_over(self, visitor):
        raise AssertionError("mutate_over() implementation not provided")

    def sync_app_attrs(self, space):
        raise NotImplementedError

    def getdict(self, space):
        if self.w_dict is None:
            self.w_dict = space.newdict(instance=True)
        return self.w_dict

    def reduce_w(self, space):
        w_dict = self.w_dict
        if w_dict is None:
            w_dict = space.newdict()
        w_type = space.type(self)
        w_fields = w_type.getdictvalue(space, "_fields")
        for w_name in space.fixedview(w_fields):
            space.setitem(w_dict, w_name,
                          space.getattr(self, w_name))
        w_attrs = space.findattr(w_type, space.wrap("_attributes"))
        if w_attrs:
            for w_name in space.fixedview(w_attrs):
                space.setitem(w_dict, w_name,
                              space.getattr(self, w_name))
        return space.newtuple([space.type(self),
                               space.newtuple([]),
                               w_dict])

    def setstate_w(self, space, w_state):
        for w_name in space.unpackiterable(w_state):
            space.setattr(self, w_name,
                          space.getitem(w_state, w_name))

    def missing_field(self, space, required, host):
        "Find which required field is missing."
        state = self.initialization_state
        for i in range(len(required)):
            if (state >> i) & 1:
                continue  # field is present
            missing = required[i]
            if missing is None:
                continue  # field is optional
            w_obj = self.getdictvalue(space, missing)
            if w_obj is None:
                err = "required field \"%s\" missing from %s"
                raise operationerrfmt(space.w_TypeError, err, missing, host)
            else:
                err = "incorrect type for field \"%s\" in %s"
                raise operationerrfmt(space.w_TypeError, err, missing, host)
        raise AssertionError("should not reach here")


class NodeVisitorNotImplemented(Exception):
    pass


class _FieldsWrapper(W_Root):
    "Hack around the fact we can't store tuples on a TypeDef."

    def __init__(self, fields):
        self.fields = fields

    def __spacebind__(self, space):
        return space.newtuple([space.wrap(field) for field in self.fields])


def get_AST_new(node_class):
    def generic_AST_new(space, w_type, __args__):
        node = space.allocate_instance(node_class, w_type)
        node.initialization_state = 0
        return space.wrap(node)
    return func_with_new_name(generic_AST_new, "new_%s" % node_class.__name__)

def AST_init(space, w_self, __args__):
    args_w, kwargs_w = __args__.unpack()
    if args_w and len(args_w) != 0:
        w_err = space.wrap("_ast.AST constructor takes 0 positional arguments")
        raise OperationError(space.w_TypeError, w_err)
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

AST.typedef = typedef.TypeDef("AST",
    _fields=_FieldsWrapper([]),
    _attributes=_FieldsWrapper([]),
    __module__='_ast',
    __reduce__=interp2app(AST.reduce_w),
    __setstate__=interp2app(AST.setstate_w),
    __dict__ = typedef.GetSetProperty(typedef.descr_get_dict,
                                      typedef.descr_set_dict, cls=AST),
    __new__=interp2app(get_AST_new(AST)),
    __init__=interp2app(AST_init),
)




class mod(AST):
    pass

class Module(mod):

    def __init__(self, body):
        self.body = body
        self.w_body = None
        self.initialization_state = 1

    def walkabout(self, visitor):
        visitor.visit_Module(self)

    def mutate_over(self, visitor):
        if self.body:
            visitor._mutate_sequence(self.body)
        return visitor.visit_Module(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 1:
            self.missing_field(space, ['body'], 'Module')
        else:
            pass
        w_list = self.w_body
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.body = [space.interp_w(stmt, w_obj) for w_obj in list_w]
            else:
                self.body = None
        if self.body is not None:
            for node in self.body:
                node.sync_app_attrs(space)


class Interactive(mod):

    def __init__(self, body):
        self.body = body
        self.w_body = None
        self.initialization_state = 1

    def walkabout(self, visitor):
        visitor.visit_Interactive(self)

    def mutate_over(self, visitor):
        if self.body:
            visitor._mutate_sequence(self.body)
        return visitor.visit_Interactive(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 1:
            self.missing_field(space, ['body'], 'Interactive')
        else:
            pass
        w_list = self.w_body
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.body = [space.interp_w(stmt, w_obj) for w_obj in list_w]
            else:
                self.body = None
        if self.body is not None:
            for node in self.body:
                node.sync_app_attrs(space)


class Expression(mod):

    def __init__(self, body):
        self.body = body
        self.initialization_state = 1

    def walkabout(self, visitor):
        visitor.visit_Expression(self)

    def mutate_over(self, visitor):
        self.body = self.body.mutate_over(visitor)
        return visitor.visit_Expression(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 1:
            self.missing_field(space, ['body'], 'Expression')
        else:
            pass
        self.body.sync_app_attrs(space)


class Suite(mod):

    def __init__(self, body):
        self.body = body
        self.w_body = None
        self.initialization_state = 1

    def walkabout(self, visitor):
        visitor.visit_Suite(self)

    def mutate_over(self, visitor):
        if self.body:
            visitor._mutate_sequence(self.body)
        return visitor.visit_Suite(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 1:
            self.missing_field(space, ['body'], 'Suite')
        else:
            pass
        w_list = self.w_body
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.body = [space.interp_w(stmt, w_obj) for w_obj in list_w]
            else:
                self.body = None
        if self.body is not None:
            for node in self.body:
                node.sync_app_attrs(space)


class stmt(AST):

    def __init__(self, lineno, col_offset):
        self.lineno = lineno
        self.col_offset = col_offset

class FunctionDef(stmt):

    def __init__(self, name, args, body, decorator_list, lineno, col_offset):
        self.name = name
        self.args = args
        self.body = body
        self.w_body = None
        self.decorator_list = decorator_list
        self.w_decorator_list = None
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 63

    def walkabout(self, visitor):
        visitor.visit_FunctionDef(self)

    def mutate_over(self, visitor):
        self.args = self.args.mutate_over(visitor)
        if self.body:
            visitor._mutate_sequence(self.body)
        if self.decorator_list:
            visitor._mutate_sequence(self.decorator_list)
        return visitor.visit_FunctionDef(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 63:
            self.missing_field(space, ['lineno', 'col_offset', 'name', 'args', 'body', 'decorator_list'], 'FunctionDef')
        else:
            pass
        self.args.sync_app_attrs(space)
        w_list = self.w_body
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.body = [space.interp_w(stmt, w_obj) for w_obj in list_w]
            else:
                self.body = None
        if self.body is not None:
            for node in self.body:
                node.sync_app_attrs(space)
        w_list = self.w_decorator_list
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.decorator_list = [space.interp_w(expr, w_obj) for w_obj in list_w]
            else:
                self.decorator_list = None
        if self.decorator_list is not None:
            for node in self.decorator_list:
                node.sync_app_attrs(space)


class ClassDef(stmt):

    def __init__(self, name, bases, body, decorator_list, lineno, col_offset):
        self.name = name
        self.bases = bases
        self.w_bases = None
        self.body = body
        self.w_body = None
        self.decorator_list = decorator_list
        self.w_decorator_list = None
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 63

    def walkabout(self, visitor):
        visitor.visit_ClassDef(self)

    def mutate_over(self, visitor):
        if self.bases:
            visitor._mutate_sequence(self.bases)
        if self.body:
            visitor._mutate_sequence(self.body)
        if self.decorator_list:
            visitor._mutate_sequence(self.decorator_list)
        return visitor.visit_ClassDef(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 63:
            self.missing_field(space, ['lineno', 'col_offset', 'name', 'bases', 'body', 'decorator_list'], 'ClassDef')
        else:
            pass
        w_list = self.w_bases
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.bases = [space.interp_w(expr, w_obj) for w_obj in list_w]
            else:
                self.bases = None
        if self.bases is not None:
            for node in self.bases:
                node.sync_app_attrs(space)
        w_list = self.w_body
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.body = [space.interp_w(stmt, w_obj) for w_obj in list_w]
            else:
                self.body = None
        if self.body is not None:
            for node in self.body:
                node.sync_app_attrs(space)
        w_list = self.w_decorator_list
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.decorator_list = [space.interp_w(expr, w_obj) for w_obj in list_w]
            else:
                self.decorator_list = None
        if self.decorator_list is not None:
            for node in self.decorator_list:
                node.sync_app_attrs(space)


class Return(stmt):

    def __init__(self, value, lineno, col_offset):
        self.value = value
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 7

    def walkabout(self, visitor):
        visitor.visit_Return(self)

    def mutate_over(self, visitor):
        if self.value:
            self.value = self.value.mutate_over(visitor)
        return visitor.visit_Return(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~4) ^ 3:
            self.missing_field(space, ['lineno', 'col_offset', None], 'Return')
        else:
            if not self.initialization_state & 4:
                self.value = None
        if self.value:
            self.value.sync_app_attrs(space)


class Delete(stmt):

    def __init__(self, targets, lineno, col_offset):
        self.targets = targets
        self.w_targets = None
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 7

    def walkabout(self, visitor):
        visitor.visit_Delete(self)

    def mutate_over(self, visitor):
        if self.targets:
            visitor._mutate_sequence(self.targets)
        return visitor.visit_Delete(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 7:
            self.missing_field(space, ['lineno', 'col_offset', 'targets'], 'Delete')
        else:
            pass
        w_list = self.w_targets
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.targets = [space.interp_w(expr, w_obj) for w_obj in list_w]
            else:
                self.targets = None
        if self.targets is not None:
            for node in self.targets:
                node.sync_app_attrs(space)


class Assign(stmt):

    def __init__(self, targets, value, lineno, col_offset):
        self.targets = targets
        self.w_targets = None
        self.value = value
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 15

    def walkabout(self, visitor):
        visitor.visit_Assign(self)

    def mutate_over(self, visitor):
        if self.targets:
            visitor._mutate_sequence(self.targets)
        self.value = self.value.mutate_over(visitor)
        return visitor.visit_Assign(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 15:
            self.missing_field(space, ['lineno', 'col_offset', 'targets', 'value'], 'Assign')
        else:
            pass
        w_list = self.w_targets
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.targets = [space.interp_w(expr, w_obj) for w_obj in list_w]
            else:
                self.targets = None
        if self.targets is not None:
            for node in self.targets:
                node.sync_app_attrs(space)
        self.value.sync_app_attrs(space)


class AugAssign(stmt):

    def __init__(self, target, op, value, lineno, col_offset):
        self.target = target
        self.op = op
        self.value = value
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 31

    def walkabout(self, visitor):
        visitor.visit_AugAssign(self)

    def mutate_over(self, visitor):
        self.target = self.target.mutate_over(visitor)
        self.value = self.value.mutate_over(visitor)
        return visitor.visit_AugAssign(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 31:
            self.missing_field(space, ['lineno', 'col_offset', 'target', 'op', 'value'], 'AugAssign')
        else:
            pass
        self.target.sync_app_attrs(space)
        self.value.sync_app_attrs(space)


class Print(stmt):

    def __init__(self, dest, values, nl, lineno, col_offset):
        self.dest = dest
        self.values = values
        self.w_values = None
        self.nl = nl
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 31

    def walkabout(self, visitor):
        visitor.visit_Print(self)

    def mutate_over(self, visitor):
        if self.dest:
            self.dest = self.dest.mutate_over(visitor)
        if self.values:
            visitor._mutate_sequence(self.values)
        return visitor.visit_Print(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~4) ^ 27:
            self.missing_field(space, ['lineno', 'col_offset', None, 'values', 'nl'], 'Print')
        else:
            if not self.initialization_state & 4:
                self.dest = None
        if self.dest:
            self.dest.sync_app_attrs(space)
        w_list = self.w_values
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.values = [space.interp_w(expr, w_obj) for w_obj in list_w]
            else:
                self.values = None
        if self.values is not None:
            for node in self.values:
                node.sync_app_attrs(space)


class For(stmt):

    def __init__(self, target, iter, body, orelse, lineno, col_offset):
        self.target = target
        self.iter = iter
        self.body = body
        self.w_body = None
        self.orelse = orelse
        self.w_orelse = None
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 63

    def walkabout(self, visitor):
        visitor.visit_For(self)

    def mutate_over(self, visitor):
        self.target = self.target.mutate_over(visitor)
        self.iter = self.iter.mutate_over(visitor)
        if self.body:
            visitor._mutate_sequence(self.body)
        if self.orelse:
            visitor._mutate_sequence(self.orelse)
        return visitor.visit_For(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 63:
            self.missing_field(space, ['lineno', 'col_offset', 'target', 'iter', 'body', 'orelse'], 'For')
        else:
            pass
        self.target.sync_app_attrs(space)
        self.iter.sync_app_attrs(space)
        w_list = self.w_body
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.body = [space.interp_w(stmt, w_obj) for w_obj in list_w]
            else:
                self.body = None
        if self.body is not None:
            for node in self.body:
                node.sync_app_attrs(space)
        w_list = self.w_orelse
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.orelse = [space.interp_w(stmt, w_obj) for w_obj in list_w]
            else:
                self.orelse = None
        if self.orelse is not None:
            for node in self.orelse:
                node.sync_app_attrs(space)


class While(stmt):

    def __init__(self, test, body, orelse, lineno, col_offset):
        self.test = test
        self.body = body
        self.w_body = None
        self.orelse = orelse
        self.w_orelse = None
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 31

    def walkabout(self, visitor):
        visitor.visit_While(self)

    def mutate_over(self, visitor):
        self.test = self.test.mutate_over(visitor)
        if self.body:
            visitor._mutate_sequence(self.body)
        if self.orelse:
            visitor._mutate_sequence(self.orelse)
        return visitor.visit_While(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 31:
            self.missing_field(space, ['lineno', 'col_offset', 'test', 'body', 'orelse'], 'While')
        else:
            pass
        self.test.sync_app_attrs(space)
        w_list = self.w_body
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.body = [space.interp_w(stmt, w_obj) for w_obj in list_w]
            else:
                self.body = None
        if self.body is not None:
            for node in self.body:
                node.sync_app_attrs(space)
        w_list = self.w_orelse
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.orelse = [space.interp_w(stmt, w_obj) for w_obj in list_w]
            else:
                self.orelse = None
        if self.orelse is not None:
            for node in self.orelse:
                node.sync_app_attrs(space)


class If(stmt):

    def __init__(self, test, body, orelse, lineno, col_offset):
        self.test = test
        self.body = body
        self.w_body = None
        self.orelse = orelse
        self.w_orelse = None
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 31

    def walkabout(self, visitor):
        visitor.visit_If(self)

    def mutate_over(self, visitor):
        self.test = self.test.mutate_over(visitor)
        if self.body:
            visitor._mutate_sequence(self.body)
        if self.orelse:
            visitor._mutate_sequence(self.orelse)
        return visitor.visit_If(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 31:
            self.missing_field(space, ['lineno', 'col_offset', 'test', 'body', 'orelse'], 'If')
        else:
            pass
        self.test.sync_app_attrs(space)
        w_list = self.w_body
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.body = [space.interp_w(stmt, w_obj) for w_obj in list_w]
            else:
                self.body = None
        if self.body is not None:
            for node in self.body:
                node.sync_app_attrs(space)
        w_list = self.w_orelse
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.orelse = [space.interp_w(stmt, w_obj) for w_obj in list_w]
            else:
                self.orelse = None
        if self.orelse is not None:
            for node in self.orelse:
                node.sync_app_attrs(space)


class With(stmt):

    def __init__(self, context_expr, optional_vars, body, lineno, col_offset):
        self.context_expr = context_expr
        self.optional_vars = optional_vars
        self.body = body
        self.w_body = None
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 31

    def walkabout(self, visitor):
        visitor.visit_With(self)

    def mutate_over(self, visitor):
        self.context_expr = self.context_expr.mutate_over(visitor)
        if self.optional_vars:
            self.optional_vars = self.optional_vars.mutate_over(visitor)
        if self.body:
            visitor._mutate_sequence(self.body)
        return visitor.visit_With(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~8) ^ 23:
            self.missing_field(space, ['lineno', 'col_offset', 'context_expr', None, 'body'], 'With')
        else:
            if not self.initialization_state & 8:
                self.optional_vars = None
        self.context_expr.sync_app_attrs(space)
        if self.optional_vars:
            self.optional_vars.sync_app_attrs(space)
        w_list = self.w_body
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.body = [space.interp_w(stmt, w_obj) for w_obj in list_w]
            else:
                self.body = None
        if self.body is not None:
            for node in self.body:
                node.sync_app_attrs(space)


class Raise(stmt):

    def __init__(self, type, inst, tback, lineno, col_offset):
        self.type = type
        self.inst = inst
        self.tback = tback
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 31

    def walkabout(self, visitor):
        visitor.visit_Raise(self)

    def mutate_over(self, visitor):
        if self.type:
            self.type = self.type.mutate_over(visitor)
        if self.inst:
            self.inst = self.inst.mutate_over(visitor)
        if self.tback:
            self.tback = self.tback.mutate_over(visitor)
        return visitor.visit_Raise(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~28) ^ 3:
            self.missing_field(space, ['lineno', 'col_offset', None, None, None], 'Raise')
        else:
            if not self.initialization_state & 4:
                self.type = None
            if not self.initialization_state & 8:
                self.inst = None
            if not self.initialization_state & 16:
                self.tback = None
        if self.type:
            self.type.sync_app_attrs(space)
        if self.inst:
            self.inst.sync_app_attrs(space)
        if self.tback:
            self.tback.sync_app_attrs(space)


class TryExcept(stmt):

    def __init__(self, body, handlers, orelse, lineno, col_offset):
        self.body = body
        self.w_body = None
        self.handlers = handlers
        self.w_handlers = None
        self.orelse = orelse
        self.w_orelse = None
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 31

    def walkabout(self, visitor):
        visitor.visit_TryExcept(self)

    def mutate_over(self, visitor):
        if self.body:
            visitor._mutate_sequence(self.body)
        if self.handlers:
            visitor._mutate_sequence(self.handlers)
        if self.orelse:
            visitor._mutate_sequence(self.orelse)
        return visitor.visit_TryExcept(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 31:
            self.missing_field(space, ['lineno', 'col_offset', 'body', 'handlers', 'orelse'], 'TryExcept')
        else:
            pass
        w_list = self.w_body
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.body = [space.interp_w(stmt, w_obj) for w_obj in list_w]
            else:
                self.body = None
        if self.body is not None:
            for node in self.body:
                node.sync_app_attrs(space)
        w_list = self.w_handlers
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.handlers = [space.interp_w(excepthandler, w_obj) for w_obj in list_w]
            else:
                self.handlers = None
        if self.handlers is not None:
            for node in self.handlers:
                node.sync_app_attrs(space)
        w_list = self.w_orelse
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.orelse = [space.interp_w(stmt, w_obj) for w_obj in list_w]
            else:
                self.orelse = None
        if self.orelse is not None:
            for node in self.orelse:
                node.sync_app_attrs(space)


class TryFinally(stmt):

    def __init__(self, body, finalbody, lineno, col_offset):
        self.body = body
        self.w_body = None
        self.finalbody = finalbody
        self.w_finalbody = None
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 15

    def walkabout(self, visitor):
        visitor.visit_TryFinally(self)

    def mutate_over(self, visitor):
        if self.body:
            visitor._mutate_sequence(self.body)
        if self.finalbody:
            visitor._mutate_sequence(self.finalbody)
        return visitor.visit_TryFinally(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 15:
            self.missing_field(space, ['lineno', 'col_offset', 'body', 'finalbody'], 'TryFinally')
        else:
            pass
        w_list = self.w_body
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.body = [space.interp_w(stmt, w_obj) for w_obj in list_w]
            else:
                self.body = None
        if self.body is not None:
            for node in self.body:
                node.sync_app_attrs(space)
        w_list = self.w_finalbody
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.finalbody = [space.interp_w(stmt, w_obj) for w_obj in list_w]
            else:
                self.finalbody = None
        if self.finalbody is not None:
            for node in self.finalbody:
                node.sync_app_attrs(space)


class Assert(stmt):

    def __init__(self, test, msg, lineno, col_offset):
        self.test = test
        self.msg = msg
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 15

    def walkabout(self, visitor):
        visitor.visit_Assert(self)

    def mutate_over(self, visitor):
        self.test = self.test.mutate_over(visitor)
        if self.msg:
            self.msg = self.msg.mutate_over(visitor)
        return visitor.visit_Assert(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~8) ^ 7:
            self.missing_field(space, ['lineno', 'col_offset', 'test', None], 'Assert')
        else:
            if not self.initialization_state & 8:
                self.msg = None
        self.test.sync_app_attrs(space)
        if self.msg:
            self.msg.sync_app_attrs(space)


class Import(stmt):

    def __init__(self, names, lineno, col_offset):
        self.names = names
        self.w_names = None
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 7

    def walkabout(self, visitor):
        visitor.visit_Import(self)

    def mutate_over(self, visitor):
        if self.names:
            visitor._mutate_sequence(self.names)
        return visitor.visit_Import(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 7:
            self.missing_field(space, ['lineno', 'col_offset', 'names'], 'Import')
        else:
            pass
        w_list = self.w_names
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.names = [space.interp_w(alias, w_obj) for w_obj in list_w]
            else:
                self.names = None
        if self.names is not None:
            for node in self.names:
                node.sync_app_attrs(space)


class ImportFrom(stmt):

    def __init__(self, module, names, level, lineno, col_offset):
        self.module = module
        self.names = names
        self.w_names = None
        self.level = level
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 31

    def walkabout(self, visitor):
        visitor.visit_ImportFrom(self)

    def mutate_over(self, visitor):
        if self.names:
            visitor._mutate_sequence(self.names)
        return visitor.visit_ImportFrom(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~20) ^ 11:
            self.missing_field(space, ['lineno', 'col_offset', None, 'names', None], 'ImportFrom')
        else:
            if not self.initialization_state & 4:
                self.module = None
            if not self.initialization_state & 16:
                self.level = 0
        w_list = self.w_names
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.names = [space.interp_w(alias, w_obj) for w_obj in list_w]
            else:
                self.names = None
        if self.names is not None:
            for node in self.names:
                node.sync_app_attrs(space)


class Exec(stmt):

    def __init__(self, body, globals, locals, lineno, col_offset):
        self.body = body
        self.globals = globals
        self.locals = locals
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 31

    def walkabout(self, visitor):
        visitor.visit_Exec(self)

    def mutate_over(self, visitor):
        self.body = self.body.mutate_over(visitor)
        if self.globals:
            self.globals = self.globals.mutate_over(visitor)
        if self.locals:
            self.locals = self.locals.mutate_over(visitor)
        return visitor.visit_Exec(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~24) ^ 7:
            self.missing_field(space, ['lineno', 'col_offset', 'body', None, None], 'Exec')
        else:
            if not self.initialization_state & 8:
                self.globals = None
            if not self.initialization_state & 16:
                self.locals = None
        self.body.sync_app_attrs(space)
        if self.globals:
            self.globals.sync_app_attrs(space)
        if self.locals:
            self.locals.sync_app_attrs(space)


class Global(stmt):

    def __init__(self, names, lineno, col_offset):
        self.names = names
        self.w_names = None
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 7

    def walkabout(self, visitor):
        visitor.visit_Global(self)

    def mutate_over(self, visitor):
        return visitor.visit_Global(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 7:
            self.missing_field(space, ['lineno', 'col_offset', 'names'], 'Global')
        else:
            pass
        w_list = self.w_names
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.names = [space.realstr_w(w_obj) for w_obj in list_w]
            else:
                self.names = None


class Expr(stmt):

    def __init__(self, value, lineno, col_offset):
        self.value = value
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 7

    def walkabout(self, visitor):
        visitor.visit_Expr(self)

    def mutate_over(self, visitor):
        self.value = self.value.mutate_over(visitor)
        return visitor.visit_Expr(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 7:
            self.missing_field(space, ['lineno', 'col_offset', 'value'], 'Expr')
        else:
            pass
        self.value.sync_app_attrs(space)


class Pass(stmt):

    def __init__(self, lineno, col_offset):
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 3

    def walkabout(self, visitor):
        visitor.visit_Pass(self)

    def mutate_over(self, visitor):
        return visitor.visit_Pass(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 3:
            self.missing_field(space, ['lineno', 'col_offset'], 'Pass')
        else:
            pass


class Break(stmt):

    def __init__(self, lineno, col_offset):
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 3

    def walkabout(self, visitor):
        visitor.visit_Break(self)

    def mutate_over(self, visitor):
        return visitor.visit_Break(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 3:
            self.missing_field(space, ['lineno', 'col_offset'], 'Break')
        else:
            pass


class Continue(stmt):

    def __init__(self, lineno, col_offset):
        stmt.__init__(self, lineno, col_offset)
        self.initialization_state = 3

    def walkabout(self, visitor):
        visitor.visit_Continue(self)

    def mutate_over(self, visitor):
        return visitor.visit_Continue(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 3:
            self.missing_field(space, ['lineno', 'col_offset'], 'Continue')
        else:
            pass


class expr(AST):

    def __init__(self, lineno, col_offset):
        self.lineno = lineno
        self.col_offset = col_offset

class BoolOp(expr):

    def __init__(self, op, values, lineno, col_offset):
        self.op = op
        self.values = values
        self.w_values = None
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 15

    def walkabout(self, visitor):
        visitor.visit_BoolOp(self)

    def mutate_over(self, visitor):
        if self.values:
            visitor._mutate_sequence(self.values)
        return visitor.visit_BoolOp(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 15:
            self.missing_field(space, ['lineno', 'col_offset', 'op', 'values'], 'BoolOp')
        else:
            pass
        w_list = self.w_values
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.values = [space.interp_w(expr, w_obj) for w_obj in list_w]
            else:
                self.values = None
        if self.values is not None:
            for node in self.values:
                node.sync_app_attrs(space)


class BinOp(expr):

    def __init__(self, left, op, right, lineno, col_offset):
        self.left = left
        self.op = op
        self.right = right
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 31

    def walkabout(self, visitor):
        visitor.visit_BinOp(self)

    def mutate_over(self, visitor):
        self.left = self.left.mutate_over(visitor)
        self.right = self.right.mutate_over(visitor)
        return visitor.visit_BinOp(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 31:
            self.missing_field(space, ['lineno', 'col_offset', 'left', 'op', 'right'], 'BinOp')
        else:
            pass
        self.left.sync_app_attrs(space)
        self.right.sync_app_attrs(space)


class UnaryOp(expr):

    def __init__(self, op, operand, lineno, col_offset):
        self.op = op
        self.operand = operand
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 15

    def walkabout(self, visitor):
        visitor.visit_UnaryOp(self)

    def mutate_over(self, visitor):
        self.operand = self.operand.mutate_over(visitor)
        return visitor.visit_UnaryOp(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 15:
            self.missing_field(space, ['lineno', 'col_offset', 'op', 'operand'], 'UnaryOp')
        else:
            pass
        self.operand.sync_app_attrs(space)


class Lambda(expr):

    def __init__(self, args, body, lineno, col_offset):
        self.args = args
        self.body = body
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 15

    def walkabout(self, visitor):
        visitor.visit_Lambda(self)

    def mutate_over(self, visitor):
        self.args = self.args.mutate_over(visitor)
        self.body = self.body.mutate_over(visitor)
        return visitor.visit_Lambda(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 15:
            self.missing_field(space, ['lineno', 'col_offset', 'args', 'body'], 'Lambda')
        else:
            pass
        self.args.sync_app_attrs(space)
        self.body.sync_app_attrs(space)


class IfExp(expr):

    def __init__(self, test, body, orelse, lineno, col_offset):
        self.test = test
        self.body = body
        self.orelse = orelse
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 31

    def walkabout(self, visitor):
        visitor.visit_IfExp(self)

    def mutate_over(self, visitor):
        self.test = self.test.mutate_over(visitor)
        self.body = self.body.mutate_over(visitor)
        self.orelse = self.orelse.mutate_over(visitor)
        return visitor.visit_IfExp(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 31:
            self.missing_field(space, ['lineno', 'col_offset', 'test', 'body', 'orelse'], 'IfExp')
        else:
            pass
        self.test.sync_app_attrs(space)
        self.body.sync_app_attrs(space)
        self.orelse.sync_app_attrs(space)


class Dict(expr):

    def __init__(self, keys, values, lineno, col_offset):
        self.keys = keys
        self.w_keys = None
        self.values = values
        self.w_values = None
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 15

    def walkabout(self, visitor):
        visitor.visit_Dict(self)

    def mutate_over(self, visitor):
        if self.keys:
            visitor._mutate_sequence(self.keys)
        if self.values:
            visitor._mutate_sequence(self.values)
        return visitor.visit_Dict(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 15:
            self.missing_field(space, ['lineno', 'col_offset', 'keys', 'values'], 'Dict')
        else:
            pass
        w_list = self.w_keys
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.keys = [space.interp_w(expr, w_obj) for w_obj in list_w]
            else:
                self.keys = None
        if self.keys is not None:
            for node in self.keys:
                node.sync_app_attrs(space)
        w_list = self.w_values
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.values = [space.interp_w(expr, w_obj) for w_obj in list_w]
            else:
                self.values = None
        if self.values is not None:
            for node in self.values:
                node.sync_app_attrs(space)


class Set(expr):

    def __init__(self, elts, lineno, col_offset):
        self.elts = elts
        self.w_elts = None
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 7

    def walkabout(self, visitor):
        visitor.visit_Set(self)

    def mutate_over(self, visitor):
        if self.elts:
            visitor._mutate_sequence(self.elts)
        return visitor.visit_Set(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 7:
            self.missing_field(space, ['lineno', 'col_offset', 'elts'], 'Set')
        else:
            pass
        w_list = self.w_elts
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.elts = [space.interp_w(expr, w_obj) for w_obj in list_w]
            else:
                self.elts = None
        if self.elts is not None:
            for node in self.elts:
                node.sync_app_attrs(space)


class ListComp(expr):

    def __init__(self, elt, generators, lineno, col_offset):
        self.elt = elt
        self.generators = generators
        self.w_generators = None
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 15

    def walkabout(self, visitor):
        visitor.visit_ListComp(self)

    def mutate_over(self, visitor):
        self.elt = self.elt.mutate_over(visitor)
        if self.generators:
            visitor._mutate_sequence(self.generators)
        return visitor.visit_ListComp(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 15:
            self.missing_field(space, ['lineno', 'col_offset', 'elt', 'generators'], 'ListComp')
        else:
            pass
        self.elt.sync_app_attrs(space)
        w_list = self.w_generators
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.generators = [space.interp_w(comprehension, w_obj) for w_obj in list_w]
            else:
                self.generators = None
        if self.generators is not None:
            for node in self.generators:
                node.sync_app_attrs(space)


class SetComp(expr):

    def __init__(self, elt, generators, lineno, col_offset):
        self.elt = elt
        self.generators = generators
        self.w_generators = None
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 15

    def walkabout(self, visitor):
        visitor.visit_SetComp(self)

    def mutate_over(self, visitor):
        self.elt = self.elt.mutate_over(visitor)
        if self.generators:
            visitor._mutate_sequence(self.generators)
        return visitor.visit_SetComp(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 15:
            self.missing_field(space, ['lineno', 'col_offset', 'elt', 'generators'], 'SetComp')
        else:
            pass
        self.elt.sync_app_attrs(space)
        w_list = self.w_generators
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.generators = [space.interp_w(comprehension, w_obj) for w_obj in list_w]
            else:
                self.generators = None
        if self.generators is not None:
            for node in self.generators:
                node.sync_app_attrs(space)


class DictComp(expr):

    def __init__(self, key, value, generators, lineno, col_offset):
        self.key = key
        self.value = value
        self.generators = generators
        self.w_generators = None
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 31

    def walkabout(self, visitor):
        visitor.visit_DictComp(self)

    def mutate_over(self, visitor):
        self.key = self.key.mutate_over(visitor)
        self.value = self.value.mutate_over(visitor)
        if self.generators:
            visitor._mutate_sequence(self.generators)
        return visitor.visit_DictComp(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 31:
            self.missing_field(space, ['lineno', 'col_offset', 'key', 'value', 'generators'], 'DictComp')
        else:
            pass
        self.key.sync_app_attrs(space)
        self.value.sync_app_attrs(space)
        w_list = self.w_generators
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.generators = [space.interp_w(comprehension, w_obj) for w_obj in list_w]
            else:
                self.generators = None
        if self.generators is not None:
            for node in self.generators:
                node.sync_app_attrs(space)


class GeneratorExp(expr):

    def __init__(self, elt, generators, lineno, col_offset):
        self.elt = elt
        self.generators = generators
        self.w_generators = None
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 15

    def walkabout(self, visitor):
        visitor.visit_GeneratorExp(self)

    def mutate_over(self, visitor):
        self.elt = self.elt.mutate_over(visitor)
        if self.generators:
            visitor._mutate_sequence(self.generators)
        return visitor.visit_GeneratorExp(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 15:
            self.missing_field(space, ['lineno', 'col_offset', 'elt', 'generators'], 'GeneratorExp')
        else:
            pass
        self.elt.sync_app_attrs(space)
        w_list = self.w_generators
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.generators = [space.interp_w(comprehension, w_obj) for w_obj in list_w]
            else:
                self.generators = None
        if self.generators is not None:
            for node in self.generators:
                node.sync_app_attrs(space)


class Yield(expr):

    def __init__(self, value, lineno, col_offset):
        self.value = value
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 7

    def walkabout(self, visitor):
        visitor.visit_Yield(self)

    def mutate_over(self, visitor):
        if self.value:
            self.value = self.value.mutate_over(visitor)
        return visitor.visit_Yield(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~4) ^ 3:
            self.missing_field(space, ['lineno', 'col_offset', None], 'Yield')
        else:
            if not self.initialization_state & 4:
                self.value = None
        if self.value:
            self.value.sync_app_attrs(space)


class Compare(expr):

    def __init__(self, left, ops, comparators, lineno, col_offset):
        self.left = left
        self.ops = ops
        self.w_ops = None
        self.comparators = comparators
        self.w_comparators = None
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 31

    def walkabout(self, visitor):
        visitor.visit_Compare(self)

    def mutate_over(self, visitor):
        self.left = self.left.mutate_over(visitor)
        if self.comparators:
            visitor._mutate_sequence(self.comparators)
        return visitor.visit_Compare(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 31:
            self.missing_field(space, ['lineno', 'col_offset', 'left', 'ops', 'comparators'], 'Compare')
        else:
            pass
        self.left.sync_app_attrs(space)
        w_list = self.w_ops
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.ops = [space.interp_w(cmpop, w_obj).to_simple_int(space) for w_obj in list_w]
            else:
                self.ops = None
        w_list = self.w_comparators
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.comparators = [space.interp_w(expr, w_obj) for w_obj in list_w]
            else:
                self.comparators = None
        if self.comparators is not None:
            for node in self.comparators:
                node.sync_app_attrs(space)


class Call(expr):

    def __init__(self, func, args, keywords, starargs, kwargs, lineno, col_offset):
        self.func = func
        self.args = args
        self.w_args = None
        self.keywords = keywords
        self.w_keywords = None
        self.starargs = starargs
        self.kwargs = kwargs
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 127

    def walkabout(self, visitor):
        visitor.visit_Call(self)

    def mutate_over(self, visitor):
        self.func = self.func.mutate_over(visitor)
        if self.args:
            visitor._mutate_sequence(self.args)
        if self.keywords:
            visitor._mutate_sequence(self.keywords)
        if self.starargs:
            self.starargs = self.starargs.mutate_over(visitor)
        if self.kwargs:
            self.kwargs = self.kwargs.mutate_over(visitor)
        return visitor.visit_Call(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~96) ^ 31:
            self.missing_field(space, ['lineno', 'col_offset', 'func', 'args', 'keywords', None, None], 'Call')
        else:
            if not self.initialization_state & 32:
                self.starargs = None
            if not self.initialization_state & 64:
                self.kwargs = None
        self.func.sync_app_attrs(space)
        w_list = self.w_args
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.args = [space.interp_w(expr, w_obj) for w_obj in list_w]
            else:
                self.args = None
        if self.args is not None:
            for node in self.args:
                node.sync_app_attrs(space)
        w_list = self.w_keywords
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.keywords = [space.interp_w(keyword, w_obj) for w_obj in list_w]
            else:
                self.keywords = None
        if self.keywords is not None:
            for node in self.keywords:
                node.sync_app_attrs(space)
        if self.starargs:
            self.starargs.sync_app_attrs(space)
        if self.kwargs:
            self.kwargs.sync_app_attrs(space)


class Repr(expr):

    def __init__(self, value, lineno, col_offset):
        self.value = value
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 7

    def walkabout(self, visitor):
        visitor.visit_Repr(self)

    def mutate_over(self, visitor):
        self.value = self.value.mutate_over(visitor)
        return visitor.visit_Repr(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 7:
            self.missing_field(space, ['lineno', 'col_offset', 'value'], 'Repr')
        else:
            pass
        self.value.sync_app_attrs(space)


class Num(expr):

    def __init__(self, n, lineno, col_offset):
        self.n = n
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 7

    def walkabout(self, visitor):
        visitor.visit_Num(self)

    def mutate_over(self, visitor):
        return visitor.visit_Num(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 7:
            self.missing_field(space, ['lineno', 'col_offset', 'n'], 'Num')
        else:
            pass


class Str(expr):

    def __init__(self, s, lineno, col_offset):
        self.s = s
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 7

    def walkabout(self, visitor):
        visitor.visit_Str(self)

    def mutate_over(self, visitor):
        return visitor.visit_Str(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 7:
            self.missing_field(space, ['lineno', 'col_offset', 's'], 'Str')
        else:
            pass


class Attribute(expr):

    def __init__(self, value, attr, ctx, lineno, col_offset):
        self.value = value
        self.attr = attr
        self.ctx = ctx
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 31

    def walkabout(self, visitor):
        visitor.visit_Attribute(self)

    def mutate_over(self, visitor):
        self.value = self.value.mutate_over(visitor)
        return visitor.visit_Attribute(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 31:
            self.missing_field(space, ['lineno', 'col_offset', 'value', 'attr', 'ctx'], 'Attribute')
        else:
            pass
        self.value.sync_app_attrs(space)


class Subscript(expr):

    def __init__(self, value, slice, ctx, lineno, col_offset):
        self.value = value
        self.slice = slice
        self.ctx = ctx
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 31

    def walkabout(self, visitor):
        visitor.visit_Subscript(self)

    def mutate_over(self, visitor):
        self.value = self.value.mutate_over(visitor)
        self.slice = self.slice.mutate_over(visitor)
        return visitor.visit_Subscript(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 31:
            self.missing_field(space, ['lineno', 'col_offset', 'value', 'slice', 'ctx'], 'Subscript')
        else:
            pass
        self.value.sync_app_attrs(space)
        self.slice.sync_app_attrs(space)


class Name(expr):

    def __init__(self, id, ctx, lineno, col_offset):
        self.id = id
        self.ctx = ctx
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 15

    def walkabout(self, visitor):
        visitor.visit_Name(self)

    def mutate_over(self, visitor):
        return visitor.visit_Name(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 15:
            self.missing_field(space, ['lineno', 'col_offset', 'id', 'ctx'], 'Name')
        else:
            pass


class List(expr):

    def __init__(self, elts, ctx, lineno, col_offset):
        self.elts = elts
        self.w_elts = None
        self.ctx = ctx
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 15

    def walkabout(self, visitor):
        visitor.visit_List(self)

    def mutate_over(self, visitor):
        if self.elts:
            visitor._mutate_sequence(self.elts)
        return visitor.visit_List(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 15:
            self.missing_field(space, ['lineno', 'col_offset', 'elts', 'ctx'], 'List')
        else:
            pass
        w_list = self.w_elts
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.elts = [space.interp_w(expr, w_obj) for w_obj in list_w]
            else:
                self.elts = None
        if self.elts is not None:
            for node in self.elts:
                node.sync_app_attrs(space)


class Tuple(expr):

    def __init__(self, elts, ctx, lineno, col_offset):
        self.elts = elts
        self.w_elts = None
        self.ctx = ctx
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 15

    def walkabout(self, visitor):
        visitor.visit_Tuple(self)

    def mutate_over(self, visitor):
        if self.elts:
            visitor._mutate_sequence(self.elts)
        return visitor.visit_Tuple(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 15:
            self.missing_field(space, ['lineno', 'col_offset', 'elts', 'ctx'], 'Tuple')
        else:
            pass
        w_list = self.w_elts
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.elts = [space.interp_w(expr, w_obj) for w_obj in list_w]
            else:
                self.elts = None
        if self.elts is not None:
            for node in self.elts:
                node.sync_app_attrs(space)


class Const(expr):

    def __init__(self, value, lineno, col_offset):
        self.value = value
        expr.__init__(self, lineno, col_offset)
        self.initialization_state = 7

    def walkabout(self, visitor):
        visitor.visit_Const(self)

    def mutate_over(self, visitor):
        return visitor.visit_Const(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 7:
            self.missing_field(space, ['lineno', 'col_offset', 'value'], 'Const')
        else:
            pass


class expr_context(AST):

    def to_simple_int(self, space):
        w_msg = space.wrap("not a valid expr_context")
        raise OperationError(space.w_TypeError, w_msg)

class _Load(expr_context):

    def to_simple_int(self, space):
        return 1

class _Store(expr_context):

    def to_simple_int(self, space):
        return 2

class _Del(expr_context):

    def to_simple_int(self, space):
        return 3

class _AugLoad(expr_context):

    def to_simple_int(self, space):
        return 4

class _AugStore(expr_context):

    def to_simple_int(self, space):
        return 5

class _Param(expr_context):

    def to_simple_int(self, space):
        return 6

Load = 1
Store = 2
Del = 3
AugLoad = 4
AugStore = 5
Param = 6

expr_context_to_class = [
    _Load,
    _Store,
    _Del,
    _AugLoad,
    _AugStore,
    _Param,
]

class slice(AST):
    pass

class Ellipsis(slice):

    def __init__(self):
        self.initialization_state = 0

    def walkabout(self, visitor):
        visitor.visit_Ellipsis(self)

    def mutate_over(self, visitor):
        return visitor.visit_Ellipsis(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 0:
            self.missing_field(space, [], 'Ellipsis')
        else:
            pass


class Slice(slice):

    def __init__(self, lower, upper, step):
        self.lower = lower
        self.upper = upper
        self.step = step
        self.initialization_state = 7

    def walkabout(self, visitor):
        visitor.visit_Slice(self)

    def mutate_over(self, visitor):
        if self.lower:
            self.lower = self.lower.mutate_over(visitor)
        if self.upper:
            self.upper = self.upper.mutate_over(visitor)
        if self.step:
            self.step = self.step.mutate_over(visitor)
        return visitor.visit_Slice(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~7) ^ 0:
            self.missing_field(space, [None, None, None], 'Slice')
        else:
            if not self.initialization_state & 1:
                self.lower = None
            if not self.initialization_state & 2:
                self.upper = None
            if not self.initialization_state & 4:
                self.step = None
        if self.lower:
            self.lower.sync_app_attrs(space)
        if self.upper:
            self.upper.sync_app_attrs(space)
        if self.step:
            self.step.sync_app_attrs(space)


class ExtSlice(slice):

    def __init__(self, dims):
        self.dims = dims
        self.w_dims = None
        self.initialization_state = 1

    def walkabout(self, visitor):
        visitor.visit_ExtSlice(self)

    def mutate_over(self, visitor):
        if self.dims:
            visitor._mutate_sequence(self.dims)
        return visitor.visit_ExtSlice(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 1:
            self.missing_field(space, ['dims'], 'ExtSlice')
        else:
            pass
        w_list = self.w_dims
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.dims = [space.interp_w(slice, w_obj) for w_obj in list_w]
            else:
                self.dims = None
        if self.dims is not None:
            for node in self.dims:
                node.sync_app_attrs(space)


class Index(slice):

    def __init__(self, value):
        self.value = value
        self.initialization_state = 1

    def walkabout(self, visitor):
        visitor.visit_Index(self)

    def mutate_over(self, visitor):
        self.value = self.value.mutate_over(visitor)
        return visitor.visit_Index(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 1:
            self.missing_field(space, ['value'], 'Index')
        else:
            pass
        self.value.sync_app_attrs(space)


class boolop(AST):

    def to_simple_int(self, space):
        w_msg = space.wrap("not a valid boolop")
        raise OperationError(space.w_TypeError, w_msg)

class _And(boolop):

    def to_simple_int(self, space):
        return 1

class _Or(boolop):

    def to_simple_int(self, space):
        return 2

And = 1
Or = 2

boolop_to_class = [
    _And,
    _Or,
]

class operator(AST):

    def to_simple_int(self, space):
        w_msg = space.wrap("not a valid operator")
        raise OperationError(space.w_TypeError, w_msg)

class _Add(operator):

    def to_simple_int(self, space):
        return 1

class _Sub(operator):

    def to_simple_int(self, space):
        return 2

class _Mult(operator):

    def to_simple_int(self, space):
        return 3

class _Div(operator):

    def to_simple_int(self, space):
        return 4

class _Mod(operator):

    def to_simple_int(self, space):
        return 5

class _Pow(operator):

    def to_simple_int(self, space):
        return 6

class _LShift(operator):

    def to_simple_int(self, space):
        return 7

class _RShift(operator):

    def to_simple_int(self, space):
        return 8

class _BitOr(operator):

    def to_simple_int(self, space):
        return 9

class _BitXor(operator):

    def to_simple_int(self, space):
        return 10

class _BitAnd(operator):

    def to_simple_int(self, space):
        return 11

class _FloorDiv(operator):

    def to_simple_int(self, space):
        return 12

Add = 1
Sub = 2
Mult = 3
Div = 4
Mod = 5
Pow = 6
LShift = 7
RShift = 8
BitOr = 9
BitXor = 10
BitAnd = 11
FloorDiv = 12

operator_to_class = [
    _Add,
    _Sub,
    _Mult,
    _Div,
    _Mod,
    _Pow,
    _LShift,
    _RShift,
    _BitOr,
    _BitXor,
    _BitAnd,
    _FloorDiv,
]

class unaryop(AST):

    def to_simple_int(self, space):
        w_msg = space.wrap("not a valid unaryop")
        raise OperationError(space.w_TypeError, w_msg)

class _Invert(unaryop):

    def to_simple_int(self, space):
        return 1

class _Not(unaryop):

    def to_simple_int(self, space):
        return 2

class _UAdd(unaryop):

    def to_simple_int(self, space):
        return 3

class _USub(unaryop):

    def to_simple_int(self, space):
        return 4

Invert = 1
Not = 2
UAdd = 3
USub = 4

unaryop_to_class = [
    _Invert,
    _Not,
    _UAdd,
    _USub,
]

class cmpop(AST):

    def to_simple_int(self, space):
        w_msg = space.wrap("not a valid cmpop")
        raise OperationError(space.w_TypeError, w_msg)

class _Eq(cmpop):

    def to_simple_int(self, space):
        return 1

class _NotEq(cmpop):

    def to_simple_int(self, space):
        return 2

class _Lt(cmpop):

    def to_simple_int(self, space):
        return 3

class _LtE(cmpop):

    def to_simple_int(self, space):
        return 4

class _Gt(cmpop):

    def to_simple_int(self, space):
        return 5

class _GtE(cmpop):

    def to_simple_int(self, space):
        return 6

class _Is(cmpop):

    def to_simple_int(self, space):
        return 7

class _IsNot(cmpop):

    def to_simple_int(self, space):
        return 8

class _In(cmpop):

    def to_simple_int(self, space):
        return 9

class _NotIn(cmpop):

    def to_simple_int(self, space):
        return 10

Eq = 1
NotEq = 2
Lt = 3
LtE = 4
Gt = 5
GtE = 6
Is = 7
IsNot = 8
In = 9
NotIn = 10

cmpop_to_class = [
    _Eq,
    _NotEq,
    _Lt,
    _LtE,
    _Gt,
    _GtE,
    _Is,
    _IsNot,
    _In,
    _NotIn,
]

class comprehension(AST):

    def __init__(self, target, iter, ifs):
        self.target = target
        self.iter = iter
        self.ifs = ifs
        self.w_ifs = None
        self.initialization_state = 7

    def mutate_over(self, visitor):
        self.target = self.target.mutate_over(visitor)
        self.iter = self.iter.mutate_over(visitor)
        if self.ifs:
            visitor._mutate_sequence(self.ifs)
        return visitor.visit_comprehension(self)

    def walkabout(self, visitor):
        visitor.visit_comprehension(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 7:
            self.missing_field(space, ['target', 'iter', 'ifs'], 'comprehension')
        else:
            pass
        self.target.sync_app_attrs(space)
        self.iter.sync_app_attrs(space)
        w_list = self.w_ifs
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.ifs = [space.interp_w(expr, w_obj) for w_obj in list_w]
            else:
                self.ifs = None
        if self.ifs is not None:
            for node in self.ifs:
                node.sync_app_attrs(space)

class excepthandler(AST):

    def __init__(self, lineno, col_offset):
        self.lineno = lineno
        self.col_offset = col_offset

class ExceptHandler(excepthandler):

    def __init__(self, type, name, body, lineno, col_offset):
        self.type = type
        self.name = name
        self.body = body
        self.w_body = None
        excepthandler.__init__(self, lineno, col_offset)
        self.initialization_state = 31

    def walkabout(self, visitor):
        visitor.visit_ExceptHandler(self)

    def mutate_over(self, visitor):
        if self.type:
            self.type = self.type.mutate_over(visitor)
        if self.name:
            self.name = self.name.mutate_over(visitor)
        if self.body:
            visitor._mutate_sequence(self.body)
        return visitor.visit_ExceptHandler(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~12) ^ 19:
            self.missing_field(space, ['lineno', 'col_offset', None, None, 'body'], 'ExceptHandler')
        else:
            if not self.initialization_state & 4:
                self.type = None
            if not self.initialization_state & 8:
                self.name = None
        if self.type:
            self.type.sync_app_attrs(space)
        if self.name:
            self.name.sync_app_attrs(space)
        w_list = self.w_body
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.body = [space.interp_w(stmt, w_obj) for w_obj in list_w]
            else:
                self.body = None
        if self.body is not None:
            for node in self.body:
                node.sync_app_attrs(space)


class arguments(AST):

    def __init__(self, args, vararg, kwarg, defaults):
        self.args = args
        self.w_args = None
        self.vararg = vararg
        self.kwarg = kwarg
        self.defaults = defaults
        self.w_defaults = None
        self.initialization_state = 15

    def mutate_over(self, visitor):
        if self.args:
            visitor._mutate_sequence(self.args)
        if self.defaults:
            visitor._mutate_sequence(self.defaults)
        return visitor.visit_arguments(self)

    def walkabout(self, visitor):
        visitor.visit_arguments(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~6) ^ 9:
            self.missing_field(space, ['args', None, None, 'defaults'], 'arguments')
        else:
            if not self.initialization_state & 2:
                self.vararg = None
            if not self.initialization_state & 4:
                self.kwarg = None
        w_list = self.w_args
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.args = [space.interp_w(expr, w_obj) for w_obj in list_w]
            else:
                self.args = None
        if self.args is not None:
            for node in self.args:
                node.sync_app_attrs(space)
        w_list = self.w_defaults
        if w_list is not None:
            list_w = space.listview(w_list)
            if list_w:
                self.defaults = [space.interp_w(expr, w_obj) for w_obj in list_w]
            else:
                self.defaults = None
        if self.defaults is not None:
            for node in self.defaults:
                node.sync_app_attrs(space)

class keyword(AST):

    def __init__(self, arg, value):
        self.arg = arg
        self.value = value
        self.initialization_state = 3

    def mutate_over(self, visitor):
        self.value = self.value.mutate_over(visitor)
        return visitor.visit_keyword(self)

    def walkabout(self, visitor):
        visitor.visit_keyword(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~0) ^ 3:
            self.missing_field(space, ['arg', 'value'], 'keyword')
        else:
            pass
        self.value.sync_app_attrs(space)

class alias(AST):

    def __init__(self, name, asname):
        self.name = name
        self.asname = asname
        self.initialization_state = 3

    def mutate_over(self, visitor):
        return visitor.visit_alias(self)

    def walkabout(self, visitor):
        visitor.visit_alias(self)

    def sync_app_attrs(self, space):
        if (self.initialization_state & ~2) ^ 1:
            self.missing_field(space, ['name', None], 'alias')
        else:
            if not self.initialization_state & 2:
                self.asname = None

class ASTVisitor(object):

    def visit_sequence(self, seq):
        if seq is not None:
            for node in seq:
                node.walkabout(self)

    def default_visitor(self, node):
        raise NodeVisitorNotImplemented

    def _mutate_sequence(self, seq):
        for i in range(len(seq)):
            seq[i] = seq[i].mutate_over(self)

    def visit_Module(self, node):
        return self.default_visitor(node)
    def visit_Interactive(self, node):
        return self.default_visitor(node)
    def visit_Expression(self, node):
        return self.default_visitor(node)
    def visit_Suite(self, node):
        return self.default_visitor(node)
    def visit_FunctionDef(self, node):
        return self.default_visitor(node)
    def visit_ClassDef(self, node):
        return self.default_visitor(node)
    def visit_Return(self, node):
        return self.default_visitor(node)
    def visit_Delete(self, node):
        return self.default_visitor(node)
    def visit_Assign(self, node):
        return self.default_visitor(node)
    def visit_AugAssign(self, node):
        return self.default_visitor(node)
    def visit_Print(self, node):
        return self.default_visitor(node)
    def visit_For(self, node):
        return self.default_visitor(node)
    def visit_While(self, node):
        return self.default_visitor(node)
    def visit_If(self, node):
        return self.default_visitor(node)
    def visit_With(self, node):
        return self.default_visitor(node)
    def visit_Raise(self, node):
        return self.default_visitor(node)
    def visit_TryExcept(self, node):
        return self.default_visitor(node)
    def visit_TryFinally(self, node):
        return self.default_visitor(node)
    def visit_Assert(self, node):
        return self.default_visitor(node)
    def visit_Import(self, node):
        return self.default_visitor(node)
    def visit_ImportFrom(self, node):
        return self.default_visitor(node)
    def visit_Exec(self, node):
        return self.default_visitor(node)
    def visit_Global(self, node):
        return self.default_visitor(node)
    def visit_Expr(self, node):
        return self.default_visitor(node)
    def visit_Pass(self, node):
        return self.default_visitor(node)
    def visit_Break(self, node):
        return self.default_visitor(node)
    def visit_Continue(self, node):
        return self.default_visitor(node)
    def visit_BoolOp(self, node):
        return self.default_visitor(node)
    def visit_BinOp(self, node):
        return self.default_visitor(node)
    def visit_UnaryOp(self, node):
        return self.default_visitor(node)
    def visit_Lambda(self, node):
        return self.default_visitor(node)
    def visit_IfExp(self, node):
        return self.default_visitor(node)
    def visit_Dict(self, node):
        return self.default_visitor(node)
    def visit_Set(self, node):
        return self.default_visitor(node)
    def visit_ListComp(self, node):
        return self.default_visitor(node)
    def visit_SetComp(self, node):
        return self.default_visitor(node)
    def visit_DictComp(self, node):
        return self.default_visitor(node)
    def visit_GeneratorExp(self, node):
        return self.default_visitor(node)
    def visit_Yield(self, node):
        return self.default_visitor(node)
    def visit_Compare(self, node):
        return self.default_visitor(node)
    def visit_Call(self, node):
        return self.default_visitor(node)
    def visit_Repr(self, node):
        return self.default_visitor(node)
    def visit_Num(self, node):
        return self.default_visitor(node)
    def visit_Str(self, node):
        return self.default_visitor(node)
    def visit_Attribute(self, node):
        return self.default_visitor(node)
    def visit_Subscript(self, node):
        return self.default_visitor(node)
    def visit_Name(self, node):
        return self.default_visitor(node)
    def visit_List(self, node):
        return self.default_visitor(node)
    def visit_Tuple(self, node):
        return self.default_visitor(node)
    def visit_Const(self, node):
        return self.default_visitor(node)
    def visit_Ellipsis(self, node):
        return self.default_visitor(node)
    def visit_Slice(self, node):
        return self.default_visitor(node)
    def visit_ExtSlice(self, node):
        return self.default_visitor(node)
    def visit_Index(self, node):
        return self.default_visitor(node)
    def visit_comprehension(self, node):
        return self.default_visitor(node)
    def visit_ExceptHandler(self, node):
        return self.default_visitor(node)
    def visit_arguments(self, node):
        return self.default_visitor(node)
    def visit_keyword(self, node):
        return self.default_visitor(node)
    def visit_alias(self, node):
        return self.default_visitor(node)

class GenericASTVisitor(ASTVisitor):

    def visit_Module(self, node):
        self.visit_sequence(node.body)

    def visit_Interactive(self, node):
        self.visit_sequence(node.body)

    def visit_Expression(self, node):
        node.body.walkabout(self)

    def visit_Suite(self, node):
        self.visit_sequence(node.body)

    def visit_FunctionDef(self, node):
        node.args.walkabout(self)
        self.visit_sequence(node.body)
        self.visit_sequence(node.decorator_list)

    def visit_ClassDef(self, node):
        self.visit_sequence(node.bases)
        self.visit_sequence(node.body)
        self.visit_sequence(node.decorator_list)

    def visit_Return(self, node):
        if node.value:
            node.value.walkabout(self)

    def visit_Delete(self, node):
        self.visit_sequence(node.targets)

    def visit_Assign(self, node):
        self.visit_sequence(node.targets)
        node.value.walkabout(self)

    def visit_AugAssign(self, node):
        node.target.walkabout(self)
        node.value.walkabout(self)

    def visit_Print(self, node):
        if node.dest:
            node.dest.walkabout(self)
        self.visit_sequence(node.values)

    def visit_For(self, node):
        node.target.walkabout(self)
        node.iter.walkabout(self)
        self.visit_sequence(node.body)
        self.visit_sequence(node.orelse)

    def visit_While(self, node):
        node.test.walkabout(self)
        self.visit_sequence(node.body)
        self.visit_sequence(node.orelse)

    def visit_If(self, node):
        node.test.walkabout(self)
        self.visit_sequence(node.body)
        self.visit_sequence(node.orelse)

    def visit_With(self, node):
        node.context_expr.walkabout(self)
        if node.optional_vars:
            node.optional_vars.walkabout(self)
        self.visit_sequence(node.body)

    def visit_Raise(self, node):
        if node.type:
            node.type.walkabout(self)
        if node.inst:
            node.inst.walkabout(self)
        if node.tback:
            node.tback.walkabout(self)

    def visit_TryExcept(self, node):
        self.visit_sequence(node.body)
        self.visit_sequence(node.handlers)
        self.visit_sequence(node.orelse)

    def visit_TryFinally(self, node):
        self.visit_sequence(node.body)
        self.visit_sequence(node.finalbody)

    def visit_Assert(self, node):
        node.test.walkabout(self)
        if node.msg:
            node.msg.walkabout(self)

    def visit_Import(self, node):
        self.visit_sequence(node.names)

    def visit_ImportFrom(self, node):
        self.visit_sequence(node.names)

    def visit_Exec(self, node):
        node.body.walkabout(self)
        if node.globals:
            node.globals.walkabout(self)
        if node.locals:
            node.locals.walkabout(self)

    def visit_Global(self, node):
        pass

    def visit_Expr(self, node):
        node.value.walkabout(self)

    def visit_Pass(self, node):
        pass

    def visit_Break(self, node):
        pass

    def visit_Continue(self, node):
        pass

    def visit_BoolOp(self, node):
        self.visit_sequence(node.values)

    def visit_BinOp(self, node):
        node.left.walkabout(self)
        node.right.walkabout(self)

    def visit_UnaryOp(self, node):
        node.operand.walkabout(self)

    def visit_Lambda(self, node):
        node.args.walkabout(self)
        node.body.walkabout(self)

    def visit_IfExp(self, node):
        node.test.walkabout(self)
        node.body.walkabout(self)
        node.orelse.walkabout(self)

    def visit_Dict(self, node):
        self.visit_sequence(node.keys)
        self.visit_sequence(node.values)

    def visit_Set(self, node):
        self.visit_sequence(node.elts)

    def visit_ListComp(self, node):
        node.elt.walkabout(self)
        self.visit_sequence(node.generators)

    def visit_SetComp(self, node):
        node.elt.walkabout(self)
        self.visit_sequence(node.generators)

    def visit_DictComp(self, node):
        node.key.walkabout(self)
        node.value.walkabout(self)
        self.visit_sequence(node.generators)

    def visit_GeneratorExp(self, node):
        node.elt.walkabout(self)
        self.visit_sequence(node.generators)

    def visit_Yield(self, node):
        if node.value:
            node.value.walkabout(self)

    def visit_Compare(self, node):
        node.left.walkabout(self)
        self.visit_sequence(node.comparators)

    def visit_Call(self, node):
        node.func.walkabout(self)
        self.visit_sequence(node.args)
        self.visit_sequence(node.keywords)
        if node.starargs:
            node.starargs.walkabout(self)
        if node.kwargs:
            node.kwargs.walkabout(self)

    def visit_Repr(self, node):
        node.value.walkabout(self)

    def visit_Num(self, node):
        pass

    def visit_Str(self, node):
        pass

    def visit_Attribute(self, node):
        node.value.walkabout(self)

    def visit_Subscript(self, node):
        node.value.walkabout(self)
        node.slice.walkabout(self)

    def visit_Name(self, node):
        pass

    def visit_List(self, node):
        self.visit_sequence(node.elts)

    def visit_Tuple(self, node):
        self.visit_sequence(node.elts)

    def visit_Const(self, node):
        pass

    def visit_Ellipsis(self, node):
        pass

    def visit_Slice(self, node):
        if node.lower:
            node.lower.walkabout(self)
        if node.upper:
            node.upper.walkabout(self)
        if node.step:
            node.step.walkabout(self)

    def visit_ExtSlice(self, node):
        self.visit_sequence(node.dims)

    def visit_Index(self, node):
        node.value.walkabout(self)

    def visit_comprehension(self, node):
        node.target.walkabout(self)
        node.iter.walkabout(self)
        self.visit_sequence(node.ifs)

    def visit_ExceptHandler(self, node):
        if node.type:
            node.type.walkabout(self)
        if node.name:
            node.name.walkabout(self)
        self.visit_sequence(node.body)

    def visit_arguments(self, node):
        self.visit_sequence(node.args)
        self.visit_sequence(node.defaults)

    def visit_keyword(self, node):
        node.value.walkabout(self)

    def visit_alias(self, node):
        pass


mod.typedef = typedef.TypeDef("mod",
    AST.typedef,
    __module__='_ast',
    _attributes=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(mod)),
)

def Module_get_body(space, w_self):
    if not w_self.initialization_state & 1:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'body')
    if w_self.w_body is None:
        if w_self.body is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.body]
        w_list = space.newlist(list_w)
        w_self.w_body = w_list
    return w_self.w_body

def Module_set_body(space, w_self, w_new_value):
    w_self.w_body = w_new_value
    w_self.initialization_state |= 1

_Module_field_unroller = unrolling_iterable(['body'])
def Module_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Module, w_self)
    w_self.w_body = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 1:
            w_err = space.wrap("Module constructor takes either 0 or 1 positional argument")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Module_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Module.typedef = typedef.TypeDef("Module",
    mod.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['body']),
    body=typedef.GetSetProperty(Module_get_body, Module_set_body, cls=Module),
    __new__=interp2app(get_AST_new(Module)),
    __init__=interp2app(Module_init),
)

def Interactive_get_body(space, w_self):
    if not w_self.initialization_state & 1:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'body')
    if w_self.w_body is None:
        if w_self.body is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.body]
        w_list = space.newlist(list_w)
        w_self.w_body = w_list
    return w_self.w_body

def Interactive_set_body(space, w_self, w_new_value):
    w_self.w_body = w_new_value
    w_self.initialization_state |= 1

_Interactive_field_unroller = unrolling_iterable(['body'])
def Interactive_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Interactive, w_self)
    w_self.w_body = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 1:
            w_err = space.wrap("Interactive constructor takes either 0 or 1 positional argument")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Interactive_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Interactive.typedef = typedef.TypeDef("Interactive",
    mod.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['body']),
    body=typedef.GetSetProperty(Interactive_get_body, Interactive_set_body, cls=Interactive),
    __new__=interp2app(get_AST_new(Interactive)),
    __init__=interp2app(Interactive_init),
)

def Expression_get_body(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'body')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 1:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'body')
    return space.wrap(w_self.body)

def Expression_set_body(space, w_self, w_new_value):
    try:
        w_self.body = space.interp_w(expr, w_new_value, False)
        if type(w_self.body) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'body', w_new_value)
        w_self.initialization_state &= ~1
        return
    w_self.deldictvalue(space, 'body')
    w_self.initialization_state |= 1

_Expression_field_unroller = unrolling_iterable(['body'])
def Expression_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Expression, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 1:
            w_err = space.wrap("Expression constructor takes either 0 or 1 positional argument")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Expression_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Expression.typedef = typedef.TypeDef("Expression",
    mod.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['body']),
    body=typedef.GetSetProperty(Expression_get_body, Expression_set_body, cls=Expression),
    __new__=interp2app(get_AST_new(Expression)),
    __init__=interp2app(Expression_init),
)

def Suite_get_body(space, w_self):
    if not w_self.initialization_state & 1:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'body')
    if w_self.w_body is None:
        if w_self.body is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.body]
        w_list = space.newlist(list_w)
        w_self.w_body = w_list
    return w_self.w_body

def Suite_set_body(space, w_self, w_new_value):
    w_self.w_body = w_new_value
    w_self.initialization_state |= 1

_Suite_field_unroller = unrolling_iterable(['body'])
def Suite_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Suite, w_self)
    w_self.w_body = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 1:
            w_err = space.wrap("Suite constructor takes either 0 or 1 positional argument")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Suite_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Suite.typedef = typedef.TypeDef("Suite",
    mod.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['body']),
    body=typedef.GetSetProperty(Suite_get_body, Suite_set_body, cls=Suite),
    __new__=interp2app(get_AST_new(Suite)),
    __init__=interp2app(Suite_init),
)

def stmt_get_lineno(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'lineno')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 1:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'lineno')
    return space.wrap(w_self.lineno)

def stmt_set_lineno(space, w_self, w_new_value):
    try:
        w_self.lineno = space.int_w(w_new_value)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'lineno', w_new_value)
        w_self.initialization_state &= ~1
        return
    w_self.deldictvalue(space, 'lineno')
    w_self.initialization_state |= 1

def stmt_get_col_offset(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'col_offset')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 2:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'col_offset')
    return space.wrap(w_self.col_offset)

def stmt_set_col_offset(space, w_self, w_new_value):
    try:
        w_self.col_offset = space.int_w(w_new_value)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'col_offset', w_new_value)
        w_self.initialization_state &= ~2
        return
    w_self.deldictvalue(space, 'col_offset')
    w_self.initialization_state |= 2

stmt.typedef = typedef.TypeDef("stmt",
    AST.typedef,
    __module__='_ast',
    _attributes=_FieldsWrapper(['lineno', 'col_offset']),
    lineno=typedef.GetSetProperty(stmt_get_lineno, stmt_set_lineno, cls=stmt),
    col_offset=typedef.GetSetProperty(stmt_get_col_offset, stmt_set_col_offset, cls=stmt),
    __new__=interp2app(get_AST_new(stmt)),
)

def FunctionDef_get_name(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'name')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'name')
    return space.wrap(w_self.name)

def FunctionDef_set_name(space, w_self, w_new_value):
    try:
        w_self.name = space.realstr_w(w_new_value)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'name', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'name')
    w_self.initialization_state |= 4

def FunctionDef_get_args(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'args')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'args')
    return space.wrap(w_self.args)

def FunctionDef_set_args(space, w_self, w_new_value):
    try:
        w_self.args = space.interp_w(arguments, w_new_value, False)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'args', w_new_value)
        w_self.initialization_state &= ~8
        return
    w_self.deldictvalue(space, 'args')
    w_self.initialization_state |= 8

def FunctionDef_get_body(space, w_self):
    if not w_self.initialization_state & 16:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'body')
    if w_self.w_body is None:
        if w_self.body is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.body]
        w_list = space.newlist(list_w)
        w_self.w_body = w_list
    return w_self.w_body

def FunctionDef_set_body(space, w_self, w_new_value):
    w_self.w_body = w_new_value
    w_self.initialization_state |= 16

def FunctionDef_get_decorator_list(space, w_self):
    if not w_self.initialization_state & 32:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'decorator_list')
    if w_self.w_decorator_list is None:
        if w_self.decorator_list is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.decorator_list]
        w_list = space.newlist(list_w)
        w_self.w_decorator_list = w_list
    return w_self.w_decorator_list

def FunctionDef_set_decorator_list(space, w_self, w_new_value):
    w_self.w_decorator_list = w_new_value
    w_self.initialization_state |= 32

_FunctionDef_field_unroller = unrolling_iterable(['name', 'args', 'body', 'decorator_list'])
def FunctionDef_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(FunctionDef, w_self)
    w_self.w_body = None
    w_self.w_decorator_list = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 4:
            w_err = space.wrap("FunctionDef constructor takes either 0 or 4 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _FunctionDef_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

FunctionDef.typedef = typedef.TypeDef("FunctionDef",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['name', 'args', 'body', 'decorator_list']),
    name=typedef.GetSetProperty(FunctionDef_get_name, FunctionDef_set_name, cls=FunctionDef),
    args=typedef.GetSetProperty(FunctionDef_get_args, FunctionDef_set_args, cls=FunctionDef),
    body=typedef.GetSetProperty(FunctionDef_get_body, FunctionDef_set_body, cls=FunctionDef),
    decorator_list=typedef.GetSetProperty(FunctionDef_get_decorator_list, FunctionDef_set_decorator_list, cls=FunctionDef),
    __new__=interp2app(get_AST_new(FunctionDef)),
    __init__=interp2app(FunctionDef_init),
)

def ClassDef_get_name(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'name')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'name')
    return space.wrap(w_self.name)

def ClassDef_set_name(space, w_self, w_new_value):
    try:
        w_self.name = space.realstr_w(w_new_value)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'name', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'name')
    w_self.initialization_state |= 4

def ClassDef_get_bases(space, w_self):
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'bases')
    if w_self.w_bases is None:
        if w_self.bases is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.bases]
        w_list = space.newlist(list_w)
        w_self.w_bases = w_list
    return w_self.w_bases

def ClassDef_set_bases(space, w_self, w_new_value):
    w_self.w_bases = w_new_value
    w_self.initialization_state |= 8

def ClassDef_get_body(space, w_self):
    if not w_self.initialization_state & 16:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'body')
    if w_self.w_body is None:
        if w_self.body is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.body]
        w_list = space.newlist(list_w)
        w_self.w_body = w_list
    return w_self.w_body

def ClassDef_set_body(space, w_self, w_new_value):
    w_self.w_body = w_new_value
    w_self.initialization_state |= 16

def ClassDef_get_decorator_list(space, w_self):
    if not w_self.initialization_state & 32:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'decorator_list')
    if w_self.w_decorator_list is None:
        if w_self.decorator_list is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.decorator_list]
        w_list = space.newlist(list_w)
        w_self.w_decorator_list = w_list
    return w_self.w_decorator_list

def ClassDef_set_decorator_list(space, w_self, w_new_value):
    w_self.w_decorator_list = w_new_value
    w_self.initialization_state |= 32

_ClassDef_field_unroller = unrolling_iterable(['name', 'bases', 'body', 'decorator_list'])
def ClassDef_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(ClassDef, w_self)
    w_self.w_bases = None
    w_self.w_body = None
    w_self.w_decorator_list = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 4:
            w_err = space.wrap("ClassDef constructor takes either 0 or 4 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _ClassDef_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

ClassDef.typedef = typedef.TypeDef("ClassDef",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['name', 'bases', 'body', 'decorator_list']),
    name=typedef.GetSetProperty(ClassDef_get_name, ClassDef_set_name, cls=ClassDef),
    bases=typedef.GetSetProperty(ClassDef_get_bases, ClassDef_set_bases, cls=ClassDef),
    body=typedef.GetSetProperty(ClassDef_get_body, ClassDef_set_body, cls=ClassDef),
    decorator_list=typedef.GetSetProperty(ClassDef_get_decorator_list, ClassDef_set_decorator_list, cls=ClassDef),
    __new__=interp2app(get_AST_new(ClassDef)),
    __init__=interp2app(ClassDef_init),
)

def Return_get_value(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'value')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'value')
    return space.wrap(w_self.value)

def Return_set_value(space, w_self, w_new_value):
    try:
        w_self.value = space.interp_w(expr, w_new_value, True)
        if type(w_self.value) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'value', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'value')
    w_self.initialization_state |= 4

_Return_field_unroller = unrolling_iterable(['value'])
def Return_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Return, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 1:
            w_err = space.wrap("Return constructor takes either 0 or 1 positional argument")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Return_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Return.typedef = typedef.TypeDef("Return",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['value']),
    value=typedef.GetSetProperty(Return_get_value, Return_set_value, cls=Return),
    __new__=interp2app(get_AST_new(Return)),
    __init__=interp2app(Return_init),
)

def Delete_get_targets(space, w_self):
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'targets')
    if w_self.w_targets is None:
        if w_self.targets is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.targets]
        w_list = space.newlist(list_w)
        w_self.w_targets = w_list
    return w_self.w_targets

def Delete_set_targets(space, w_self, w_new_value):
    w_self.w_targets = w_new_value
    w_self.initialization_state |= 4

_Delete_field_unroller = unrolling_iterable(['targets'])
def Delete_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Delete, w_self)
    w_self.w_targets = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 1:
            w_err = space.wrap("Delete constructor takes either 0 or 1 positional argument")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Delete_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Delete.typedef = typedef.TypeDef("Delete",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['targets']),
    targets=typedef.GetSetProperty(Delete_get_targets, Delete_set_targets, cls=Delete),
    __new__=interp2app(get_AST_new(Delete)),
    __init__=interp2app(Delete_init),
)

def Assign_get_targets(space, w_self):
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'targets')
    if w_self.w_targets is None:
        if w_self.targets is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.targets]
        w_list = space.newlist(list_w)
        w_self.w_targets = w_list
    return w_self.w_targets

def Assign_set_targets(space, w_self, w_new_value):
    w_self.w_targets = w_new_value
    w_self.initialization_state |= 4

def Assign_get_value(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'value')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'value')
    return space.wrap(w_self.value)

def Assign_set_value(space, w_self, w_new_value):
    try:
        w_self.value = space.interp_w(expr, w_new_value, False)
        if type(w_self.value) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'value', w_new_value)
        w_self.initialization_state &= ~8
        return
    w_self.deldictvalue(space, 'value')
    w_self.initialization_state |= 8

_Assign_field_unroller = unrolling_iterable(['targets', 'value'])
def Assign_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Assign, w_self)
    w_self.w_targets = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 2:
            w_err = space.wrap("Assign constructor takes either 0 or 2 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Assign_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Assign.typedef = typedef.TypeDef("Assign",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['targets', 'value']),
    targets=typedef.GetSetProperty(Assign_get_targets, Assign_set_targets, cls=Assign),
    value=typedef.GetSetProperty(Assign_get_value, Assign_set_value, cls=Assign),
    __new__=interp2app(get_AST_new(Assign)),
    __init__=interp2app(Assign_init),
)

def AugAssign_get_target(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'target')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'target')
    return space.wrap(w_self.target)

def AugAssign_set_target(space, w_self, w_new_value):
    try:
        w_self.target = space.interp_w(expr, w_new_value, False)
        if type(w_self.target) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'target', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'target')
    w_self.initialization_state |= 4

def AugAssign_get_op(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'op')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'op')
    return operator_to_class[w_self.op - 1]()

def AugAssign_set_op(space, w_self, w_new_value):
    try:
        obj = space.interp_w(operator, w_new_value)
        w_self.op = obj.to_simple_int(space)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'op', w_new_value)
        w_self.initialization_state &= ~8
        return
    # need to save the original object too
    w_self.setdictvalue(space, 'op', w_new_value)
    w_self.initialization_state |= 8

def AugAssign_get_value(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'value')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 16:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'value')
    return space.wrap(w_self.value)

def AugAssign_set_value(space, w_self, w_new_value):
    try:
        w_self.value = space.interp_w(expr, w_new_value, False)
        if type(w_self.value) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'value', w_new_value)
        w_self.initialization_state &= ~16
        return
    w_self.deldictvalue(space, 'value')
    w_self.initialization_state |= 16

_AugAssign_field_unroller = unrolling_iterable(['target', 'op', 'value'])
def AugAssign_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(AugAssign, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 3:
            w_err = space.wrap("AugAssign constructor takes either 0 or 3 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _AugAssign_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

AugAssign.typedef = typedef.TypeDef("AugAssign",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['target', 'op', 'value']),
    target=typedef.GetSetProperty(AugAssign_get_target, AugAssign_set_target, cls=AugAssign),
    op=typedef.GetSetProperty(AugAssign_get_op, AugAssign_set_op, cls=AugAssign),
    value=typedef.GetSetProperty(AugAssign_get_value, AugAssign_set_value, cls=AugAssign),
    __new__=interp2app(get_AST_new(AugAssign)),
    __init__=interp2app(AugAssign_init),
)

def Print_get_dest(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'dest')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'dest')
    return space.wrap(w_self.dest)

def Print_set_dest(space, w_self, w_new_value):
    try:
        w_self.dest = space.interp_w(expr, w_new_value, True)
        if type(w_self.dest) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'dest', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'dest')
    w_self.initialization_state |= 4

def Print_get_values(space, w_self):
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'values')
    if w_self.w_values is None:
        if w_self.values is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.values]
        w_list = space.newlist(list_w)
        w_self.w_values = w_list
    return w_self.w_values

def Print_set_values(space, w_self, w_new_value):
    w_self.w_values = w_new_value
    w_self.initialization_state |= 8

def Print_get_nl(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'nl')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 16:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'nl')
    return space.wrap(w_self.nl)

def Print_set_nl(space, w_self, w_new_value):
    try:
        w_self.nl = space.bool_w(w_new_value)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'nl', w_new_value)
        w_self.initialization_state &= ~16
        return
    w_self.deldictvalue(space, 'nl')
    w_self.initialization_state |= 16

_Print_field_unroller = unrolling_iterable(['dest', 'values', 'nl'])
def Print_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Print, w_self)
    w_self.w_values = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 3:
            w_err = space.wrap("Print constructor takes either 0 or 3 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Print_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Print.typedef = typedef.TypeDef("Print",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['dest', 'values', 'nl']),
    dest=typedef.GetSetProperty(Print_get_dest, Print_set_dest, cls=Print),
    values=typedef.GetSetProperty(Print_get_values, Print_set_values, cls=Print),
    nl=typedef.GetSetProperty(Print_get_nl, Print_set_nl, cls=Print),
    __new__=interp2app(get_AST_new(Print)),
    __init__=interp2app(Print_init),
)

def For_get_target(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'target')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'target')
    return space.wrap(w_self.target)

def For_set_target(space, w_self, w_new_value):
    try:
        w_self.target = space.interp_w(expr, w_new_value, False)
        if type(w_self.target) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'target', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'target')
    w_self.initialization_state |= 4

def For_get_iter(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'iter')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'iter')
    return space.wrap(w_self.iter)

def For_set_iter(space, w_self, w_new_value):
    try:
        w_self.iter = space.interp_w(expr, w_new_value, False)
        if type(w_self.iter) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'iter', w_new_value)
        w_self.initialization_state &= ~8
        return
    w_self.deldictvalue(space, 'iter')
    w_self.initialization_state |= 8

def For_get_body(space, w_self):
    if not w_self.initialization_state & 16:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'body')
    if w_self.w_body is None:
        if w_self.body is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.body]
        w_list = space.newlist(list_w)
        w_self.w_body = w_list
    return w_self.w_body

def For_set_body(space, w_self, w_new_value):
    w_self.w_body = w_new_value
    w_self.initialization_state |= 16

def For_get_orelse(space, w_self):
    if not w_self.initialization_state & 32:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'orelse')
    if w_self.w_orelse is None:
        if w_self.orelse is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.orelse]
        w_list = space.newlist(list_w)
        w_self.w_orelse = w_list
    return w_self.w_orelse

def For_set_orelse(space, w_self, w_new_value):
    w_self.w_orelse = w_new_value
    w_self.initialization_state |= 32

_For_field_unroller = unrolling_iterable(['target', 'iter', 'body', 'orelse'])
def For_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(For, w_self)
    w_self.w_body = None
    w_self.w_orelse = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 4:
            w_err = space.wrap("For constructor takes either 0 or 4 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _For_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

For.typedef = typedef.TypeDef("For",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['target', 'iter', 'body', 'orelse']),
    target=typedef.GetSetProperty(For_get_target, For_set_target, cls=For),
    iter=typedef.GetSetProperty(For_get_iter, For_set_iter, cls=For),
    body=typedef.GetSetProperty(For_get_body, For_set_body, cls=For),
    orelse=typedef.GetSetProperty(For_get_orelse, For_set_orelse, cls=For),
    __new__=interp2app(get_AST_new(For)),
    __init__=interp2app(For_init),
)

def While_get_test(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'test')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'test')
    return space.wrap(w_self.test)

def While_set_test(space, w_self, w_new_value):
    try:
        w_self.test = space.interp_w(expr, w_new_value, False)
        if type(w_self.test) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'test', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'test')
    w_self.initialization_state |= 4

def While_get_body(space, w_self):
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'body')
    if w_self.w_body is None:
        if w_self.body is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.body]
        w_list = space.newlist(list_w)
        w_self.w_body = w_list
    return w_self.w_body

def While_set_body(space, w_self, w_new_value):
    w_self.w_body = w_new_value
    w_self.initialization_state |= 8

def While_get_orelse(space, w_self):
    if not w_self.initialization_state & 16:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'orelse')
    if w_self.w_orelse is None:
        if w_self.orelse is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.orelse]
        w_list = space.newlist(list_w)
        w_self.w_orelse = w_list
    return w_self.w_orelse

def While_set_orelse(space, w_self, w_new_value):
    w_self.w_orelse = w_new_value
    w_self.initialization_state |= 16

_While_field_unroller = unrolling_iterable(['test', 'body', 'orelse'])
def While_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(While, w_self)
    w_self.w_body = None
    w_self.w_orelse = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 3:
            w_err = space.wrap("While constructor takes either 0 or 3 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _While_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

While.typedef = typedef.TypeDef("While",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['test', 'body', 'orelse']),
    test=typedef.GetSetProperty(While_get_test, While_set_test, cls=While),
    body=typedef.GetSetProperty(While_get_body, While_set_body, cls=While),
    orelse=typedef.GetSetProperty(While_get_orelse, While_set_orelse, cls=While),
    __new__=interp2app(get_AST_new(While)),
    __init__=interp2app(While_init),
)

def If_get_test(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'test')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'test')
    return space.wrap(w_self.test)

def If_set_test(space, w_self, w_new_value):
    try:
        w_self.test = space.interp_w(expr, w_new_value, False)
        if type(w_self.test) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'test', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'test')
    w_self.initialization_state |= 4

def If_get_body(space, w_self):
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'body')
    if w_self.w_body is None:
        if w_self.body is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.body]
        w_list = space.newlist(list_w)
        w_self.w_body = w_list
    return w_self.w_body

def If_set_body(space, w_self, w_new_value):
    w_self.w_body = w_new_value
    w_self.initialization_state |= 8

def If_get_orelse(space, w_self):
    if not w_self.initialization_state & 16:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'orelse')
    if w_self.w_orelse is None:
        if w_self.orelse is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.orelse]
        w_list = space.newlist(list_w)
        w_self.w_orelse = w_list
    return w_self.w_orelse

def If_set_orelse(space, w_self, w_new_value):
    w_self.w_orelse = w_new_value
    w_self.initialization_state |= 16

_If_field_unroller = unrolling_iterable(['test', 'body', 'orelse'])
def If_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(If, w_self)
    w_self.w_body = None
    w_self.w_orelse = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 3:
            w_err = space.wrap("If constructor takes either 0 or 3 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _If_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

If.typedef = typedef.TypeDef("If",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['test', 'body', 'orelse']),
    test=typedef.GetSetProperty(If_get_test, If_set_test, cls=If),
    body=typedef.GetSetProperty(If_get_body, If_set_body, cls=If),
    orelse=typedef.GetSetProperty(If_get_orelse, If_set_orelse, cls=If),
    __new__=interp2app(get_AST_new(If)),
    __init__=interp2app(If_init),
)

def With_get_context_expr(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'context_expr')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'context_expr')
    return space.wrap(w_self.context_expr)

def With_set_context_expr(space, w_self, w_new_value):
    try:
        w_self.context_expr = space.interp_w(expr, w_new_value, False)
        if type(w_self.context_expr) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'context_expr', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'context_expr')
    w_self.initialization_state |= 4

def With_get_optional_vars(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'optional_vars')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'optional_vars')
    return space.wrap(w_self.optional_vars)

def With_set_optional_vars(space, w_self, w_new_value):
    try:
        w_self.optional_vars = space.interp_w(expr, w_new_value, True)
        if type(w_self.optional_vars) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'optional_vars', w_new_value)
        w_self.initialization_state &= ~8
        return
    w_self.deldictvalue(space, 'optional_vars')
    w_self.initialization_state |= 8

def With_get_body(space, w_self):
    if not w_self.initialization_state & 16:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'body')
    if w_self.w_body is None:
        if w_self.body is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.body]
        w_list = space.newlist(list_w)
        w_self.w_body = w_list
    return w_self.w_body

def With_set_body(space, w_self, w_new_value):
    w_self.w_body = w_new_value
    w_self.initialization_state |= 16

_With_field_unroller = unrolling_iterable(['context_expr', 'optional_vars', 'body'])
def With_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(With, w_self)
    w_self.w_body = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 3:
            w_err = space.wrap("With constructor takes either 0 or 3 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _With_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

With.typedef = typedef.TypeDef("With",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['context_expr', 'optional_vars', 'body']),
    context_expr=typedef.GetSetProperty(With_get_context_expr, With_set_context_expr, cls=With),
    optional_vars=typedef.GetSetProperty(With_get_optional_vars, With_set_optional_vars, cls=With),
    body=typedef.GetSetProperty(With_get_body, With_set_body, cls=With),
    __new__=interp2app(get_AST_new(With)),
    __init__=interp2app(With_init),
)

def Raise_get_type(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'type')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'type')
    return space.wrap(w_self.type)

def Raise_set_type(space, w_self, w_new_value):
    try:
        w_self.type = space.interp_w(expr, w_new_value, True)
        if type(w_self.type) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'type', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'type')
    w_self.initialization_state |= 4

def Raise_get_inst(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'inst')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'inst')
    return space.wrap(w_self.inst)

def Raise_set_inst(space, w_self, w_new_value):
    try:
        w_self.inst = space.interp_w(expr, w_new_value, True)
        if type(w_self.inst) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'inst', w_new_value)
        w_self.initialization_state &= ~8
        return
    w_self.deldictvalue(space, 'inst')
    w_self.initialization_state |= 8

def Raise_get_tback(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'tback')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 16:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'tback')
    return space.wrap(w_self.tback)

def Raise_set_tback(space, w_self, w_new_value):
    try:
        w_self.tback = space.interp_w(expr, w_new_value, True)
        if type(w_self.tback) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'tback', w_new_value)
        w_self.initialization_state &= ~16
        return
    w_self.deldictvalue(space, 'tback')
    w_self.initialization_state |= 16

_Raise_field_unroller = unrolling_iterable(['type', 'inst', 'tback'])
def Raise_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Raise, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 3:
            w_err = space.wrap("Raise constructor takes either 0 or 3 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Raise_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Raise.typedef = typedef.TypeDef("Raise",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['type', 'inst', 'tback']),
    type=typedef.GetSetProperty(Raise_get_type, Raise_set_type, cls=Raise),
    inst=typedef.GetSetProperty(Raise_get_inst, Raise_set_inst, cls=Raise),
    tback=typedef.GetSetProperty(Raise_get_tback, Raise_set_tback, cls=Raise),
    __new__=interp2app(get_AST_new(Raise)),
    __init__=interp2app(Raise_init),
)

def TryExcept_get_body(space, w_self):
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'body')
    if w_self.w_body is None:
        if w_self.body is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.body]
        w_list = space.newlist(list_w)
        w_self.w_body = w_list
    return w_self.w_body

def TryExcept_set_body(space, w_self, w_new_value):
    w_self.w_body = w_new_value
    w_self.initialization_state |= 4

def TryExcept_get_handlers(space, w_self):
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'handlers')
    if w_self.w_handlers is None:
        if w_self.handlers is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.handlers]
        w_list = space.newlist(list_w)
        w_self.w_handlers = w_list
    return w_self.w_handlers

def TryExcept_set_handlers(space, w_self, w_new_value):
    w_self.w_handlers = w_new_value
    w_self.initialization_state |= 8

def TryExcept_get_orelse(space, w_self):
    if not w_self.initialization_state & 16:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'orelse')
    if w_self.w_orelse is None:
        if w_self.orelse is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.orelse]
        w_list = space.newlist(list_w)
        w_self.w_orelse = w_list
    return w_self.w_orelse

def TryExcept_set_orelse(space, w_self, w_new_value):
    w_self.w_orelse = w_new_value
    w_self.initialization_state |= 16

_TryExcept_field_unroller = unrolling_iterable(['body', 'handlers', 'orelse'])
def TryExcept_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(TryExcept, w_self)
    w_self.w_body = None
    w_self.w_handlers = None
    w_self.w_orelse = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 3:
            w_err = space.wrap("TryExcept constructor takes either 0 or 3 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _TryExcept_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

TryExcept.typedef = typedef.TypeDef("TryExcept",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['body', 'handlers', 'orelse']),
    body=typedef.GetSetProperty(TryExcept_get_body, TryExcept_set_body, cls=TryExcept),
    handlers=typedef.GetSetProperty(TryExcept_get_handlers, TryExcept_set_handlers, cls=TryExcept),
    orelse=typedef.GetSetProperty(TryExcept_get_orelse, TryExcept_set_orelse, cls=TryExcept),
    __new__=interp2app(get_AST_new(TryExcept)),
    __init__=interp2app(TryExcept_init),
)

def TryFinally_get_body(space, w_self):
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'body')
    if w_self.w_body is None:
        if w_self.body is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.body]
        w_list = space.newlist(list_w)
        w_self.w_body = w_list
    return w_self.w_body

def TryFinally_set_body(space, w_self, w_new_value):
    w_self.w_body = w_new_value
    w_self.initialization_state |= 4

def TryFinally_get_finalbody(space, w_self):
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'finalbody')
    if w_self.w_finalbody is None:
        if w_self.finalbody is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.finalbody]
        w_list = space.newlist(list_w)
        w_self.w_finalbody = w_list
    return w_self.w_finalbody

def TryFinally_set_finalbody(space, w_self, w_new_value):
    w_self.w_finalbody = w_new_value
    w_self.initialization_state |= 8

_TryFinally_field_unroller = unrolling_iterable(['body', 'finalbody'])
def TryFinally_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(TryFinally, w_self)
    w_self.w_body = None
    w_self.w_finalbody = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 2:
            w_err = space.wrap("TryFinally constructor takes either 0 or 2 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _TryFinally_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

TryFinally.typedef = typedef.TypeDef("TryFinally",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['body', 'finalbody']),
    body=typedef.GetSetProperty(TryFinally_get_body, TryFinally_set_body, cls=TryFinally),
    finalbody=typedef.GetSetProperty(TryFinally_get_finalbody, TryFinally_set_finalbody, cls=TryFinally),
    __new__=interp2app(get_AST_new(TryFinally)),
    __init__=interp2app(TryFinally_init),
)

def Assert_get_test(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'test')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'test')
    return space.wrap(w_self.test)

def Assert_set_test(space, w_self, w_new_value):
    try:
        w_self.test = space.interp_w(expr, w_new_value, False)
        if type(w_self.test) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'test', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'test')
    w_self.initialization_state |= 4

def Assert_get_msg(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'msg')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'msg')
    return space.wrap(w_self.msg)

def Assert_set_msg(space, w_self, w_new_value):
    try:
        w_self.msg = space.interp_w(expr, w_new_value, True)
        if type(w_self.msg) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'msg', w_new_value)
        w_self.initialization_state &= ~8
        return
    w_self.deldictvalue(space, 'msg')
    w_self.initialization_state |= 8

_Assert_field_unroller = unrolling_iterable(['test', 'msg'])
def Assert_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Assert, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 2:
            w_err = space.wrap("Assert constructor takes either 0 or 2 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Assert_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Assert.typedef = typedef.TypeDef("Assert",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['test', 'msg']),
    test=typedef.GetSetProperty(Assert_get_test, Assert_set_test, cls=Assert),
    msg=typedef.GetSetProperty(Assert_get_msg, Assert_set_msg, cls=Assert),
    __new__=interp2app(get_AST_new(Assert)),
    __init__=interp2app(Assert_init),
)

def Import_get_names(space, w_self):
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'names')
    if w_self.w_names is None:
        if w_self.names is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.names]
        w_list = space.newlist(list_w)
        w_self.w_names = w_list
    return w_self.w_names

def Import_set_names(space, w_self, w_new_value):
    w_self.w_names = w_new_value
    w_self.initialization_state |= 4

_Import_field_unroller = unrolling_iterable(['names'])
def Import_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Import, w_self)
    w_self.w_names = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 1:
            w_err = space.wrap("Import constructor takes either 0 or 1 positional argument")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Import_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Import.typedef = typedef.TypeDef("Import",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['names']),
    names=typedef.GetSetProperty(Import_get_names, Import_set_names, cls=Import),
    __new__=interp2app(get_AST_new(Import)),
    __init__=interp2app(Import_init),
)

def ImportFrom_get_module(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'module')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'module')
    return space.wrap(w_self.module)

def ImportFrom_set_module(space, w_self, w_new_value):
    try:
        if space.is_w(w_new_value, space.w_None):
            w_self.module = None
        else:
            w_self.module = space.realstr_w(w_new_value)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'module', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'module')
    w_self.initialization_state |= 4

def ImportFrom_get_names(space, w_self):
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'names')
    if w_self.w_names is None:
        if w_self.names is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.names]
        w_list = space.newlist(list_w)
        w_self.w_names = w_list
    return w_self.w_names

def ImportFrom_set_names(space, w_self, w_new_value):
    w_self.w_names = w_new_value
    w_self.initialization_state |= 8

def ImportFrom_get_level(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'level')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 16:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'level')
    return space.wrap(w_self.level)

def ImportFrom_set_level(space, w_self, w_new_value):
    try:
        w_self.level = space.int_w(w_new_value)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'level', w_new_value)
        w_self.initialization_state &= ~16
        return
    w_self.deldictvalue(space, 'level')
    w_self.initialization_state |= 16

_ImportFrom_field_unroller = unrolling_iterable(['module', 'names', 'level'])
def ImportFrom_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(ImportFrom, w_self)
    w_self.w_names = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 3:
            w_err = space.wrap("ImportFrom constructor takes either 0 or 3 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _ImportFrom_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

ImportFrom.typedef = typedef.TypeDef("ImportFrom",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['module', 'names', 'level']),
    module=typedef.GetSetProperty(ImportFrom_get_module, ImportFrom_set_module, cls=ImportFrom),
    names=typedef.GetSetProperty(ImportFrom_get_names, ImportFrom_set_names, cls=ImportFrom),
    level=typedef.GetSetProperty(ImportFrom_get_level, ImportFrom_set_level, cls=ImportFrom),
    __new__=interp2app(get_AST_new(ImportFrom)),
    __init__=interp2app(ImportFrom_init),
)

def Exec_get_body(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'body')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'body')
    return space.wrap(w_self.body)

def Exec_set_body(space, w_self, w_new_value):
    try:
        w_self.body = space.interp_w(expr, w_new_value, False)
        if type(w_self.body) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'body', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'body')
    w_self.initialization_state |= 4

def Exec_get_globals(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'globals')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'globals')
    return space.wrap(w_self.globals)

def Exec_set_globals(space, w_self, w_new_value):
    try:
        w_self.globals = space.interp_w(expr, w_new_value, True)
        if type(w_self.globals) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'globals', w_new_value)
        w_self.initialization_state &= ~8
        return
    w_self.deldictvalue(space, 'globals')
    w_self.initialization_state |= 8

def Exec_get_locals(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'locals')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 16:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'locals')
    return space.wrap(w_self.locals)

def Exec_set_locals(space, w_self, w_new_value):
    try:
        w_self.locals = space.interp_w(expr, w_new_value, True)
        if type(w_self.locals) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'locals', w_new_value)
        w_self.initialization_state &= ~16
        return
    w_self.deldictvalue(space, 'locals')
    w_self.initialization_state |= 16

_Exec_field_unroller = unrolling_iterable(['body', 'globals', 'locals'])
def Exec_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Exec, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 3:
            w_err = space.wrap("Exec constructor takes either 0 or 3 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Exec_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Exec.typedef = typedef.TypeDef("Exec",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['body', 'globals', 'locals']),
    body=typedef.GetSetProperty(Exec_get_body, Exec_set_body, cls=Exec),
    globals=typedef.GetSetProperty(Exec_get_globals, Exec_set_globals, cls=Exec),
    locals=typedef.GetSetProperty(Exec_get_locals, Exec_set_locals, cls=Exec),
    __new__=interp2app(get_AST_new(Exec)),
    __init__=interp2app(Exec_init),
)

def Global_get_names(space, w_self):
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'names')
    if w_self.w_names is None:
        if w_self.names is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.names]
        w_list = space.newlist(list_w)
        w_self.w_names = w_list
    return w_self.w_names

def Global_set_names(space, w_self, w_new_value):
    w_self.w_names = w_new_value
    w_self.initialization_state |= 4

_Global_field_unroller = unrolling_iterable(['names'])
def Global_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Global, w_self)
    w_self.w_names = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 1:
            w_err = space.wrap("Global constructor takes either 0 or 1 positional argument")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Global_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Global.typedef = typedef.TypeDef("Global",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['names']),
    names=typedef.GetSetProperty(Global_get_names, Global_set_names, cls=Global),
    __new__=interp2app(get_AST_new(Global)),
    __init__=interp2app(Global_init),
)

def Expr_get_value(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'value')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'value')
    return space.wrap(w_self.value)

def Expr_set_value(space, w_self, w_new_value):
    try:
        w_self.value = space.interp_w(expr, w_new_value, False)
        if type(w_self.value) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'value', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'value')
    w_self.initialization_state |= 4

_Expr_field_unroller = unrolling_iterable(['value'])
def Expr_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Expr, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 1:
            w_err = space.wrap("Expr constructor takes either 0 or 1 positional argument")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Expr_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Expr.typedef = typedef.TypeDef("Expr",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['value']),
    value=typedef.GetSetProperty(Expr_get_value, Expr_set_value, cls=Expr),
    __new__=interp2app(get_AST_new(Expr)),
    __init__=interp2app(Expr_init),
)

def Pass_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Pass, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        w_err = space.wrap("Pass constructor takes no arguments")
        raise OperationError(space.w_TypeError, w_err)
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Pass.typedef = typedef.TypeDef("Pass",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(Pass)),
    __init__=interp2app(Pass_init),
)

def Break_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Break, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        w_err = space.wrap("Break constructor takes no arguments")
        raise OperationError(space.w_TypeError, w_err)
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Break.typedef = typedef.TypeDef("Break",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(Break)),
    __init__=interp2app(Break_init),
)

def Continue_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Continue, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        w_err = space.wrap("Continue constructor takes no arguments")
        raise OperationError(space.w_TypeError, w_err)
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Continue.typedef = typedef.TypeDef("Continue",
    stmt.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(Continue)),
    __init__=interp2app(Continue_init),
)

def expr_get_lineno(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'lineno')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 1:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'lineno')
    return space.wrap(w_self.lineno)

def expr_set_lineno(space, w_self, w_new_value):
    try:
        w_self.lineno = space.int_w(w_new_value)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'lineno', w_new_value)
        w_self.initialization_state &= ~1
        return
    w_self.deldictvalue(space, 'lineno')
    w_self.initialization_state |= 1

def expr_get_col_offset(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'col_offset')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 2:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'col_offset')
    return space.wrap(w_self.col_offset)

def expr_set_col_offset(space, w_self, w_new_value):
    try:
        w_self.col_offset = space.int_w(w_new_value)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'col_offset', w_new_value)
        w_self.initialization_state &= ~2
        return
    w_self.deldictvalue(space, 'col_offset')
    w_self.initialization_state |= 2

expr.typedef = typedef.TypeDef("expr",
    AST.typedef,
    __module__='_ast',
    _attributes=_FieldsWrapper(['lineno', 'col_offset']),
    lineno=typedef.GetSetProperty(expr_get_lineno, expr_set_lineno, cls=expr),
    col_offset=typedef.GetSetProperty(expr_get_col_offset, expr_set_col_offset, cls=expr),
    __new__=interp2app(get_AST_new(expr)),
)

def BoolOp_get_op(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'op')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'op')
    return boolop_to_class[w_self.op - 1]()

def BoolOp_set_op(space, w_self, w_new_value):
    try:
        obj = space.interp_w(boolop, w_new_value)
        w_self.op = obj.to_simple_int(space)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'op', w_new_value)
        w_self.initialization_state &= ~4
        return
    # need to save the original object too
    w_self.setdictvalue(space, 'op', w_new_value)
    w_self.initialization_state |= 4

def BoolOp_get_values(space, w_self):
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'values')
    if w_self.w_values is None:
        if w_self.values is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.values]
        w_list = space.newlist(list_w)
        w_self.w_values = w_list
    return w_self.w_values

def BoolOp_set_values(space, w_self, w_new_value):
    w_self.w_values = w_new_value
    w_self.initialization_state |= 8

_BoolOp_field_unroller = unrolling_iterable(['op', 'values'])
def BoolOp_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(BoolOp, w_self)
    w_self.w_values = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 2:
            w_err = space.wrap("BoolOp constructor takes either 0 or 2 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _BoolOp_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

BoolOp.typedef = typedef.TypeDef("BoolOp",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['op', 'values']),
    op=typedef.GetSetProperty(BoolOp_get_op, BoolOp_set_op, cls=BoolOp),
    values=typedef.GetSetProperty(BoolOp_get_values, BoolOp_set_values, cls=BoolOp),
    __new__=interp2app(get_AST_new(BoolOp)),
    __init__=interp2app(BoolOp_init),
)

def BinOp_get_left(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'left')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'left')
    return space.wrap(w_self.left)

def BinOp_set_left(space, w_self, w_new_value):
    try:
        w_self.left = space.interp_w(expr, w_new_value, False)
        if type(w_self.left) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'left', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'left')
    w_self.initialization_state |= 4

def BinOp_get_op(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'op')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'op')
    return operator_to_class[w_self.op - 1]()

def BinOp_set_op(space, w_self, w_new_value):
    try:
        obj = space.interp_w(operator, w_new_value)
        w_self.op = obj.to_simple_int(space)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'op', w_new_value)
        w_self.initialization_state &= ~8
        return
    # need to save the original object too
    w_self.setdictvalue(space, 'op', w_new_value)
    w_self.initialization_state |= 8

def BinOp_get_right(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'right')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 16:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'right')
    return space.wrap(w_self.right)

def BinOp_set_right(space, w_self, w_new_value):
    try:
        w_self.right = space.interp_w(expr, w_new_value, False)
        if type(w_self.right) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'right', w_new_value)
        w_self.initialization_state &= ~16
        return
    w_self.deldictvalue(space, 'right')
    w_self.initialization_state |= 16

_BinOp_field_unroller = unrolling_iterable(['left', 'op', 'right'])
def BinOp_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(BinOp, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 3:
            w_err = space.wrap("BinOp constructor takes either 0 or 3 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _BinOp_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

BinOp.typedef = typedef.TypeDef("BinOp",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['left', 'op', 'right']),
    left=typedef.GetSetProperty(BinOp_get_left, BinOp_set_left, cls=BinOp),
    op=typedef.GetSetProperty(BinOp_get_op, BinOp_set_op, cls=BinOp),
    right=typedef.GetSetProperty(BinOp_get_right, BinOp_set_right, cls=BinOp),
    __new__=interp2app(get_AST_new(BinOp)),
    __init__=interp2app(BinOp_init),
)

def UnaryOp_get_op(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'op')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'op')
    return unaryop_to_class[w_self.op - 1]()

def UnaryOp_set_op(space, w_self, w_new_value):
    try:
        obj = space.interp_w(unaryop, w_new_value)
        w_self.op = obj.to_simple_int(space)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'op', w_new_value)
        w_self.initialization_state &= ~4
        return
    # need to save the original object too
    w_self.setdictvalue(space, 'op', w_new_value)
    w_self.initialization_state |= 4

def UnaryOp_get_operand(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'operand')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'operand')
    return space.wrap(w_self.operand)

def UnaryOp_set_operand(space, w_self, w_new_value):
    try:
        w_self.operand = space.interp_w(expr, w_new_value, False)
        if type(w_self.operand) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'operand', w_new_value)
        w_self.initialization_state &= ~8
        return
    w_self.deldictvalue(space, 'operand')
    w_self.initialization_state |= 8

_UnaryOp_field_unroller = unrolling_iterable(['op', 'operand'])
def UnaryOp_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(UnaryOp, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 2:
            w_err = space.wrap("UnaryOp constructor takes either 0 or 2 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _UnaryOp_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

UnaryOp.typedef = typedef.TypeDef("UnaryOp",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['op', 'operand']),
    op=typedef.GetSetProperty(UnaryOp_get_op, UnaryOp_set_op, cls=UnaryOp),
    operand=typedef.GetSetProperty(UnaryOp_get_operand, UnaryOp_set_operand, cls=UnaryOp),
    __new__=interp2app(get_AST_new(UnaryOp)),
    __init__=interp2app(UnaryOp_init),
)

def Lambda_get_args(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'args')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'args')
    return space.wrap(w_self.args)

def Lambda_set_args(space, w_self, w_new_value):
    try:
        w_self.args = space.interp_w(arguments, w_new_value, False)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'args', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'args')
    w_self.initialization_state |= 4

def Lambda_get_body(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'body')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'body')
    return space.wrap(w_self.body)

def Lambda_set_body(space, w_self, w_new_value):
    try:
        w_self.body = space.interp_w(expr, w_new_value, False)
        if type(w_self.body) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'body', w_new_value)
        w_self.initialization_state &= ~8
        return
    w_self.deldictvalue(space, 'body')
    w_self.initialization_state |= 8

_Lambda_field_unroller = unrolling_iterable(['args', 'body'])
def Lambda_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Lambda, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 2:
            w_err = space.wrap("Lambda constructor takes either 0 or 2 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Lambda_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Lambda.typedef = typedef.TypeDef("Lambda",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['args', 'body']),
    args=typedef.GetSetProperty(Lambda_get_args, Lambda_set_args, cls=Lambda),
    body=typedef.GetSetProperty(Lambda_get_body, Lambda_set_body, cls=Lambda),
    __new__=interp2app(get_AST_new(Lambda)),
    __init__=interp2app(Lambda_init),
)

def IfExp_get_test(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'test')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'test')
    return space.wrap(w_self.test)

def IfExp_set_test(space, w_self, w_new_value):
    try:
        w_self.test = space.interp_w(expr, w_new_value, False)
        if type(w_self.test) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'test', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'test')
    w_self.initialization_state |= 4

def IfExp_get_body(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'body')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'body')
    return space.wrap(w_self.body)

def IfExp_set_body(space, w_self, w_new_value):
    try:
        w_self.body = space.interp_w(expr, w_new_value, False)
        if type(w_self.body) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'body', w_new_value)
        w_self.initialization_state &= ~8
        return
    w_self.deldictvalue(space, 'body')
    w_self.initialization_state |= 8

def IfExp_get_orelse(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'orelse')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 16:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'orelse')
    return space.wrap(w_self.orelse)

def IfExp_set_orelse(space, w_self, w_new_value):
    try:
        w_self.orelse = space.interp_w(expr, w_new_value, False)
        if type(w_self.orelse) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'orelse', w_new_value)
        w_self.initialization_state &= ~16
        return
    w_self.deldictvalue(space, 'orelse')
    w_self.initialization_state |= 16

_IfExp_field_unroller = unrolling_iterable(['test', 'body', 'orelse'])
def IfExp_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(IfExp, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 3:
            w_err = space.wrap("IfExp constructor takes either 0 or 3 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _IfExp_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

IfExp.typedef = typedef.TypeDef("IfExp",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['test', 'body', 'orelse']),
    test=typedef.GetSetProperty(IfExp_get_test, IfExp_set_test, cls=IfExp),
    body=typedef.GetSetProperty(IfExp_get_body, IfExp_set_body, cls=IfExp),
    orelse=typedef.GetSetProperty(IfExp_get_orelse, IfExp_set_orelse, cls=IfExp),
    __new__=interp2app(get_AST_new(IfExp)),
    __init__=interp2app(IfExp_init),
)

def Dict_get_keys(space, w_self):
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'keys')
    if w_self.w_keys is None:
        if w_self.keys is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.keys]
        w_list = space.newlist(list_w)
        w_self.w_keys = w_list
    return w_self.w_keys

def Dict_set_keys(space, w_self, w_new_value):
    w_self.w_keys = w_new_value
    w_self.initialization_state |= 4

def Dict_get_values(space, w_self):
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'values')
    if w_self.w_values is None:
        if w_self.values is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.values]
        w_list = space.newlist(list_w)
        w_self.w_values = w_list
    return w_self.w_values

def Dict_set_values(space, w_self, w_new_value):
    w_self.w_values = w_new_value
    w_self.initialization_state |= 8

_Dict_field_unroller = unrolling_iterable(['keys', 'values'])
def Dict_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Dict, w_self)
    w_self.w_keys = None
    w_self.w_values = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 2:
            w_err = space.wrap("Dict constructor takes either 0 or 2 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Dict_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Dict.typedef = typedef.TypeDef("Dict",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['keys', 'values']),
    keys=typedef.GetSetProperty(Dict_get_keys, Dict_set_keys, cls=Dict),
    values=typedef.GetSetProperty(Dict_get_values, Dict_set_values, cls=Dict),
    __new__=interp2app(get_AST_new(Dict)),
    __init__=interp2app(Dict_init),
)

def Set_get_elts(space, w_self):
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'elts')
    if w_self.w_elts is None:
        if w_self.elts is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.elts]
        w_list = space.newlist(list_w)
        w_self.w_elts = w_list
    return w_self.w_elts

def Set_set_elts(space, w_self, w_new_value):
    w_self.w_elts = w_new_value
    w_self.initialization_state |= 4

_Set_field_unroller = unrolling_iterable(['elts'])
def Set_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Set, w_self)
    w_self.w_elts = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 1:
            w_err = space.wrap("Set constructor takes either 0 or 1 positional argument")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Set_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Set.typedef = typedef.TypeDef("Set",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['elts']),
    elts=typedef.GetSetProperty(Set_get_elts, Set_set_elts, cls=Set),
    __new__=interp2app(get_AST_new(Set)),
    __init__=interp2app(Set_init),
)

def ListComp_get_elt(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'elt')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'elt')
    return space.wrap(w_self.elt)

def ListComp_set_elt(space, w_self, w_new_value):
    try:
        w_self.elt = space.interp_w(expr, w_new_value, False)
        if type(w_self.elt) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'elt', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'elt')
    w_self.initialization_state |= 4

def ListComp_get_generators(space, w_self):
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'generators')
    if w_self.w_generators is None:
        if w_self.generators is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.generators]
        w_list = space.newlist(list_w)
        w_self.w_generators = w_list
    return w_self.w_generators

def ListComp_set_generators(space, w_self, w_new_value):
    w_self.w_generators = w_new_value
    w_self.initialization_state |= 8

_ListComp_field_unroller = unrolling_iterable(['elt', 'generators'])
def ListComp_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(ListComp, w_self)
    w_self.w_generators = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 2:
            w_err = space.wrap("ListComp constructor takes either 0 or 2 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _ListComp_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

ListComp.typedef = typedef.TypeDef("ListComp",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['elt', 'generators']),
    elt=typedef.GetSetProperty(ListComp_get_elt, ListComp_set_elt, cls=ListComp),
    generators=typedef.GetSetProperty(ListComp_get_generators, ListComp_set_generators, cls=ListComp),
    __new__=interp2app(get_AST_new(ListComp)),
    __init__=interp2app(ListComp_init),
)

def SetComp_get_elt(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'elt')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'elt')
    return space.wrap(w_self.elt)

def SetComp_set_elt(space, w_self, w_new_value):
    try:
        w_self.elt = space.interp_w(expr, w_new_value, False)
        if type(w_self.elt) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'elt', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'elt')
    w_self.initialization_state |= 4

def SetComp_get_generators(space, w_self):
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'generators')
    if w_self.w_generators is None:
        if w_self.generators is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.generators]
        w_list = space.newlist(list_w)
        w_self.w_generators = w_list
    return w_self.w_generators

def SetComp_set_generators(space, w_self, w_new_value):
    w_self.w_generators = w_new_value
    w_self.initialization_state |= 8

_SetComp_field_unroller = unrolling_iterable(['elt', 'generators'])
def SetComp_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(SetComp, w_self)
    w_self.w_generators = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 2:
            w_err = space.wrap("SetComp constructor takes either 0 or 2 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _SetComp_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

SetComp.typedef = typedef.TypeDef("SetComp",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['elt', 'generators']),
    elt=typedef.GetSetProperty(SetComp_get_elt, SetComp_set_elt, cls=SetComp),
    generators=typedef.GetSetProperty(SetComp_get_generators, SetComp_set_generators, cls=SetComp),
    __new__=interp2app(get_AST_new(SetComp)),
    __init__=interp2app(SetComp_init),
)

def DictComp_get_key(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'key')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'key')
    return space.wrap(w_self.key)

def DictComp_set_key(space, w_self, w_new_value):
    try:
        w_self.key = space.interp_w(expr, w_new_value, False)
        if type(w_self.key) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'key', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'key')
    w_self.initialization_state |= 4

def DictComp_get_value(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'value')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'value')
    return space.wrap(w_self.value)

def DictComp_set_value(space, w_self, w_new_value):
    try:
        w_self.value = space.interp_w(expr, w_new_value, False)
        if type(w_self.value) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'value', w_new_value)
        w_self.initialization_state &= ~8
        return
    w_self.deldictvalue(space, 'value')
    w_self.initialization_state |= 8

def DictComp_get_generators(space, w_self):
    if not w_self.initialization_state & 16:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'generators')
    if w_self.w_generators is None:
        if w_self.generators is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.generators]
        w_list = space.newlist(list_w)
        w_self.w_generators = w_list
    return w_self.w_generators

def DictComp_set_generators(space, w_self, w_new_value):
    w_self.w_generators = w_new_value
    w_self.initialization_state |= 16

_DictComp_field_unroller = unrolling_iterable(['key', 'value', 'generators'])
def DictComp_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(DictComp, w_self)
    w_self.w_generators = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 3:
            w_err = space.wrap("DictComp constructor takes either 0 or 3 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _DictComp_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

DictComp.typedef = typedef.TypeDef("DictComp",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['key', 'value', 'generators']),
    key=typedef.GetSetProperty(DictComp_get_key, DictComp_set_key, cls=DictComp),
    value=typedef.GetSetProperty(DictComp_get_value, DictComp_set_value, cls=DictComp),
    generators=typedef.GetSetProperty(DictComp_get_generators, DictComp_set_generators, cls=DictComp),
    __new__=interp2app(get_AST_new(DictComp)),
    __init__=interp2app(DictComp_init),
)

def GeneratorExp_get_elt(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'elt')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'elt')
    return space.wrap(w_self.elt)

def GeneratorExp_set_elt(space, w_self, w_new_value):
    try:
        w_self.elt = space.interp_w(expr, w_new_value, False)
        if type(w_self.elt) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'elt', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'elt')
    w_self.initialization_state |= 4

def GeneratorExp_get_generators(space, w_self):
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'generators')
    if w_self.w_generators is None:
        if w_self.generators is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.generators]
        w_list = space.newlist(list_w)
        w_self.w_generators = w_list
    return w_self.w_generators

def GeneratorExp_set_generators(space, w_self, w_new_value):
    w_self.w_generators = w_new_value
    w_self.initialization_state |= 8

_GeneratorExp_field_unroller = unrolling_iterable(['elt', 'generators'])
def GeneratorExp_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(GeneratorExp, w_self)
    w_self.w_generators = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 2:
            w_err = space.wrap("GeneratorExp constructor takes either 0 or 2 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _GeneratorExp_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

GeneratorExp.typedef = typedef.TypeDef("GeneratorExp",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['elt', 'generators']),
    elt=typedef.GetSetProperty(GeneratorExp_get_elt, GeneratorExp_set_elt, cls=GeneratorExp),
    generators=typedef.GetSetProperty(GeneratorExp_get_generators, GeneratorExp_set_generators, cls=GeneratorExp),
    __new__=interp2app(get_AST_new(GeneratorExp)),
    __init__=interp2app(GeneratorExp_init),
)

def Yield_get_value(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'value')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'value')
    return space.wrap(w_self.value)

def Yield_set_value(space, w_self, w_new_value):
    try:
        w_self.value = space.interp_w(expr, w_new_value, True)
        if type(w_self.value) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'value', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'value')
    w_self.initialization_state |= 4

_Yield_field_unroller = unrolling_iterable(['value'])
def Yield_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Yield, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 1:
            w_err = space.wrap("Yield constructor takes either 0 or 1 positional argument")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Yield_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Yield.typedef = typedef.TypeDef("Yield",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['value']),
    value=typedef.GetSetProperty(Yield_get_value, Yield_set_value, cls=Yield),
    __new__=interp2app(get_AST_new(Yield)),
    __init__=interp2app(Yield_init),
)

def Compare_get_left(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'left')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'left')
    return space.wrap(w_self.left)

def Compare_set_left(space, w_self, w_new_value):
    try:
        w_self.left = space.interp_w(expr, w_new_value, False)
        if type(w_self.left) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'left', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'left')
    w_self.initialization_state |= 4

def Compare_get_ops(space, w_self):
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'ops')
    if w_self.w_ops is None:
        if w_self.ops is None:
            list_w = []
        else:
            list_w = [cmpop_to_class[node - 1]() for node in w_self.ops]
        w_list = space.newlist(list_w)
        w_self.w_ops = w_list
    return w_self.w_ops

def Compare_set_ops(space, w_self, w_new_value):
    w_self.w_ops = w_new_value
    w_self.initialization_state |= 8

def Compare_get_comparators(space, w_self):
    if not w_self.initialization_state & 16:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'comparators')
    if w_self.w_comparators is None:
        if w_self.comparators is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.comparators]
        w_list = space.newlist(list_w)
        w_self.w_comparators = w_list
    return w_self.w_comparators

def Compare_set_comparators(space, w_self, w_new_value):
    w_self.w_comparators = w_new_value
    w_self.initialization_state |= 16

_Compare_field_unroller = unrolling_iterable(['left', 'ops', 'comparators'])
def Compare_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Compare, w_self)
    w_self.w_ops = None
    w_self.w_comparators = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 3:
            w_err = space.wrap("Compare constructor takes either 0 or 3 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Compare_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Compare.typedef = typedef.TypeDef("Compare",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['left', 'ops', 'comparators']),
    left=typedef.GetSetProperty(Compare_get_left, Compare_set_left, cls=Compare),
    ops=typedef.GetSetProperty(Compare_get_ops, Compare_set_ops, cls=Compare),
    comparators=typedef.GetSetProperty(Compare_get_comparators, Compare_set_comparators, cls=Compare),
    __new__=interp2app(get_AST_new(Compare)),
    __init__=interp2app(Compare_init),
)

def Call_get_func(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'func')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'func')
    return space.wrap(w_self.func)

def Call_set_func(space, w_self, w_new_value):
    try:
        w_self.func = space.interp_w(expr, w_new_value, False)
        if type(w_self.func) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'func', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'func')
    w_self.initialization_state |= 4

def Call_get_args(space, w_self):
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'args')
    if w_self.w_args is None:
        if w_self.args is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.args]
        w_list = space.newlist(list_w)
        w_self.w_args = w_list
    return w_self.w_args

def Call_set_args(space, w_self, w_new_value):
    w_self.w_args = w_new_value
    w_self.initialization_state |= 8

def Call_get_keywords(space, w_self):
    if not w_self.initialization_state & 16:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'keywords')
    if w_self.w_keywords is None:
        if w_self.keywords is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.keywords]
        w_list = space.newlist(list_w)
        w_self.w_keywords = w_list
    return w_self.w_keywords

def Call_set_keywords(space, w_self, w_new_value):
    w_self.w_keywords = w_new_value
    w_self.initialization_state |= 16

def Call_get_starargs(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'starargs')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 32:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'starargs')
    return space.wrap(w_self.starargs)

def Call_set_starargs(space, w_self, w_new_value):
    try:
        w_self.starargs = space.interp_w(expr, w_new_value, True)
        if type(w_self.starargs) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'starargs', w_new_value)
        w_self.initialization_state &= ~32
        return
    w_self.deldictvalue(space, 'starargs')
    w_self.initialization_state |= 32

def Call_get_kwargs(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'kwargs')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 64:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'kwargs')
    return space.wrap(w_self.kwargs)

def Call_set_kwargs(space, w_self, w_new_value):
    try:
        w_self.kwargs = space.interp_w(expr, w_new_value, True)
        if type(w_self.kwargs) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'kwargs', w_new_value)
        w_self.initialization_state &= ~64
        return
    w_self.deldictvalue(space, 'kwargs')
    w_self.initialization_state |= 64

_Call_field_unroller = unrolling_iterable(['func', 'args', 'keywords', 'starargs', 'kwargs'])
def Call_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Call, w_self)
    w_self.w_args = None
    w_self.w_keywords = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 5:
            w_err = space.wrap("Call constructor takes either 0 or 5 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Call_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Call.typedef = typedef.TypeDef("Call",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['func', 'args', 'keywords', 'starargs', 'kwargs']),
    func=typedef.GetSetProperty(Call_get_func, Call_set_func, cls=Call),
    args=typedef.GetSetProperty(Call_get_args, Call_set_args, cls=Call),
    keywords=typedef.GetSetProperty(Call_get_keywords, Call_set_keywords, cls=Call),
    starargs=typedef.GetSetProperty(Call_get_starargs, Call_set_starargs, cls=Call),
    kwargs=typedef.GetSetProperty(Call_get_kwargs, Call_set_kwargs, cls=Call),
    __new__=interp2app(get_AST_new(Call)),
    __init__=interp2app(Call_init),
)

def Repr_get_value(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'value')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'value')
    return space.wrap(w_self.value)

def Repr_set_value(space, w_self, w_new_value):
    try:
        w_self.value = space.interp_w(expr, w_new_value, False)
        if type(w_self.value) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'value', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'value')
    w_self.initialization_state |= 4

_Repr_field_unroller = unrolling_iterable(['value'])
def Repr_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Repr, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 1:
            w_err = space.wrap("Repr constructor takes either 0 or 1 positional argument")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Repr_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Repr.typedef = typedef.TypeDef("Repr",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['value']),
    value=typedef.GetSetProperty(Repr_get_value, Repr_set_value, cls=Repr),
    __new__=interp2app(get_AST_new(Repr)),
    __init__=interp2app(Repr_init),
)

def Num_get_n(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'n')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'n')
    return w_self.n

def Num_set_n(space, w_self, w_new_value):
    try:
        w_self.n = w_new_value
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'n', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'n')
    w_self.initialization_state |= 4

_Num_field_unroller = unrolling_iterable(['n'])
def Num_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Num, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 1:
            w_err = space.wrap("Num constructor takes either 0 or 1 positional argument")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Num_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Num.typedef = typedef.TypeDef("Num",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['n']),
    n=typedef.GetSetProperty(Num_get_n, Num_set_n, cls=Num),
    __new__=interp2app(get_AST_new(Num)),
    __init__=interp2app(Num_init),
)

def Str_get_s(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 's')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 's')
    return w_self.s

def Str_set_s(space, w_self, w_new_value):
    try:
        w_self.s = check_string(space, w_new_value)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 's', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 's')
    w_self.initialization_state |= 4

_Str_field_unroller = unrolling_iterable(['s'])
def Str_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Str, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 1:
            w_err = space.wrap("Str constructor takes either 0 or 1 positional argument")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Str_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Str.typedef = typedef.TypeDef("Str",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['s']),
    s=typedef.GetSetProperty(Str_get_s, Str_set_s, cls=Str),
    __new__=interp2app(get_AST_new(Str)),
    __init__=interp2app(Str_init),
)

def Attribute_get_value(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'value')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'value')
    return space.wrap(w_self.value)

def Attribute_set_value(space, w_self, w_new_value):
    try:
        w_self.value = space.interp_w(expr, w_new_value, False)
        if type(w_self.value) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'value', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'value')
    w_self.initialization_state |= 4

def Attribute_get_attr(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'attr')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'attr')
    return space.wrap(w_self.attr)

def Attribute_set_attr(space, w_self, w_new_value):
    try:
        w_self.attr = space.realstr_w(w_new_value)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'attr', w_new_value)
        w_self.initialization_state &= ~8
        return
    w_self.deldictvalue(space, 'attr')
    w_self.initialization_state |= 8

def Attribute_get_ctx(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'ctx')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 16:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'ctx')
    return expr_context_to_class[w_self.ctx - 1]()

def Attribute_set_ctx(space, w_self, w_new_value):
    try:
        obj = space.interp_w(expr_context, w_new_value)
        w_self.ctx = obj.to_simple_int(space)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'ctx', w_new_value)
        w_self.initialization_state &= ~16
        return
    # need to save the original object too
    w_self.setdictvalue(space, 'ctx', w_new_value)
    w_self.initialization_state |= 16

_Attribute_field_unroller = unrolling_iterable(['value', 'attr', 'ctx'])
def Attribute_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Attribute, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 3:
            w_err = space.wrap("Attribute constructor takes either 0 or 3 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Attribute_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Attribute.typedef = typedef.TypeDef("Attribute",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['value', 'attr', 'ctx']),
    value=typedef.GetSetProperty(Attribute_get_value, Attribute_set_value, cls=Attribute),
    attr=typedef.GetSetProperty(Attribute_get_attr, Attribute_set_attr, cls=Attribute),
    ctx=typedef.GetSetProperty(Attribute_get_ctx, Attribute_set_ctx, cls=Attribute),
    __new__=interp2app(get_AST_new(Attribute)),
    __init__=interp2app(Attribute_init),
)

def Subscript_get_value(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'value')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'value')
    return space.wrap(w_self.value)

def Subscript_set_value(space, w_self, w_new_value):
    try:
        w_self.value = space.interp_w(expr, w_new_value, False)
        if type(w_self.value) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'value', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'value')
    w_self.initialization_state |= 4

def Subscript_get_slice(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'slice')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'slice')
    return space.wrap(w_self.slice)

def Subscript_set_slice(space, w_self, w_new_value):
    try:
        w_self.slice = space.interp_w(slice, w_new_value, False)
        if type(w_self.slice) is slice:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'slice', w_new_value)
        w_self.initialization_state &= ~8
        return
    w_self.deldictvalue(space, 'slice')
    w_self.initialization_state |= 8

def Subscript_get_ctx(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'ctx')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 16:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'ctx')
    return expr_context_to_class[w_self.ctx - 1]()

def Subscript_set_ctx(space, w_self, w_new_value):
    try:
        obj = space.interp_w(expr_context, w_new_value)
        w_self.ctx = obj.to_simple_int(space)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'ctx', w_new_value)
        w_self.initialization_state &= ~16
        return
    # need to save the original object too
    w_self.setdictvalue(space, 'ctx', w_new_value)
    w_self.initialization_state |= 16

_Subscript_field_unroller = unrolling_iterable(['value', 'slice', 'ctx'])
def Subscript_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Subscript, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 3:
            w_err = space.wrap("Subscript constructor takes either 0 or 3 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Subscript_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Subscript.typedef = typedef.TypeDef("Subscript",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['value', 'slice', 'ctx']),
    value=typedef.GetSetProperty(Subscript_get_value, Subscript_set_value, cls=Subscript),
    slice=typedef.GetSetProperty(Subscript_get_slice, Subscript_set_slice, cls=Subscript),
    ctx=typedef.GetSetProperty(Subscript_get_ctx, Subscript_set_ctx, cls=Subscript),
    __new__=interp2app(get_AST_new(Subscript)),
    __init__=interp2app(Subscript_init),
)

def Name_get_id(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'id')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'id')
    return space.wrap(w_self.id)

def Name_set_id(space, w_self, w_new_value):
    try:
        w_self.id = space.realstr_w(w_new_value)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'id', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'id')
    w_self.initialization_state |= 4

def Name_get_ctx(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'ctx')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'ctx')
    return expr_context_to_class[w_self.ctx - 1]()

def Name_set_ctx(space, w_self, w_new_value):
    try:
        obj = space.interp_w(expr_context, w_new_value)
        w_self.ctx = obj.to_simple_int(space)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'ctx', w_new_value)
        w_self.initialization_state &= ~8
        return
    # need to save the original object too
    w_self.setdictvalue(space, 'ctx', w_new_value)
    w_self.initialization_state |= 8

_Name_field_unroller = unrolling_iterable(['id', 'ctx'])
def Name_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Name, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 2:
            w_err = space.wrap("Name constructor takes either 0 or 2 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Name_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Name.typedef = typedef.TypeDef("Name",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['id', 'ctx']),
    id=typedef.GetSetProperty(Name_get_id, Name_set_id, cls=Name),
    ctx=typedef.GetSetProperty(Name_get_ctx, Name_set_ctx, cls=Name),
    __new__=interp2app(get_AST_new(Name)),
    __init__=interp2app(Name_init),
)

def List_get_elts(space, w_self):
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'elts')
    if w_self.w_elts is None:
        if w_self.elts is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.elts]
        w_list = space.newlist(list_w)
        w_self.w_elts = w_list
    return w_self.w_elts

def List_set_elts(space, w_self, w_new_value):
    w_self.w_elts = w_new_value
    w_self.initialization_state |= 4

def List_get_ctx(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'ctx')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'ctx')
    return expr_context_to_class[w_self.ctx - 1]()

def List_set_ctx(space, w_self, w_new_value):
    try:
        obj = space.interp_w(expr_context, w_new_value)
        w_self.ctx = obj.to_simple_int(space)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'ctx', w_new_value)
        w_self.initialization_state &= ~8
        return
    # need to save the original object too
    w_self.setdictvalue(space, 'ctx', w_new_value)
    w_self.initialization_state |= 8

_List_field_unroller = unrolling_iterable(['elts', 'ctx'])
def List_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(List, w_self)
    w_self.w_elts = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 2:
            w_err = space.wrap("List constructor takes either 0 or 2 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _List_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

List.typedef = typedef.TypeDef("List",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['elts', 'ctx']),
    elts=typedef.GetSetProperty(List_get_elts, List_set_elts, cls=List),
    ctx=typedef.GetSetProperty(List_get_ctx, List_set_ctx, cls=List),
    __new__=interp2app(get_AST_new(List)),
    __init__=interp2app(List_init),
)

def Tuple_get_elts(space, w_self):
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'elts')
    if w_self.w_elts is None:
        if w_self.elts is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.elts]
        w_list = space.newlist(list_w)
        w_self.w_elts = w_list
    return w_self.w_elts

def Tuple_set_elts(space, w_self, w_new_value):
    w_self.w_elts = w_new_value
    w_self.initialization_state |= 4

def Tuple_get_ctx(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'ctx')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'ctx')
    return expr_context_to_class[w_self.ctx - 1]()

def Tuple_set_ctx(space, w_self, w_new_value):
    try:
        obj = space.interp_w(expr_context, w_new_value)
        w_self.ctx = obj.to_simple_int(space)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'ctx', w_new_value)
        w_self.initialization_state &= ~8
        return
    # need to save the original object too
    w_self.setdictvalue(space, 'ctx', w_new_value)
    w_self.initialization_state |= 8

_Tuple_field_unroller = unrolling_iterable(['elts', 'ctx'])
def Tuple_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Tuple, w_self)
    w_self.w_elts = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 2:
            w_err = space.wrap("Tuple constructor takes either 0 or 2 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Tuple_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Tuple.typedef = typedef.TypeDef("Tuple",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['elts', 'ctx']),
    elts=typedef.GetSetProperty(Tuple_get_elts, Tuple_set_elts, cls=Tuple),
    ctx=typedef.GetSetProperty(Tuple_get_ctx, Tuple_set_ctx, cls=Tuple),
    __new__=interp2app(get_AST_new(Tuple)),
    __init__=interp2app(Tuple_init),
)

def Const_get_value(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'value')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'value')
    return w_self.value

def Const_set_value(space, w_self, w_new_value):
    try:
        w_self.value = w_new_value
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'value', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'value')
    w_self.initialization_state |= 4

_Const_field_unroller = unrolling_iterable(['value'])
def Const_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Const, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 1:
            w_err = space.wrap("Const constructor takes either 0 or 1 positional argument")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Const_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Const.typedef = typedef.TypeDef("Const",
    expr.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['value']),
    value=typedef.GetSetProperty(Const_get_value, Const_set_value, cls=Const),
    __new__=interp2app(get_AST_new(Const)),
    __init__=interp2app(Const_init),
)

expr_context.typedef = typedef.TypeDef("expr_context",
    AST.typedef,
    __module__='_ast',
    _attributes=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(expr_context)),
)

_Load.typedef = typedef.TypeDef("Load",
    expr_context.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_Load)),
)

_Store.typedef = typedef.TypeDef("Store",
    expr_context.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_Store)),
)

_Del.typedef = typedef.TypeDef("Del",
    expr_context.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_Del)),
)

_AugLoad.typedef = typedef.TypeDef("AugLoad",
    expr_context.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_AugLoad)),
)

_AugStore.typedef = typedef.TypeDef("AugStore",
    expr_context.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_AugStore)),
)

_Param.typedef = typedef.TypeDef("Param",
    expr_context.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_Param)),
)

slice.typedef = typedef.TypeDef("slice",
    AST.typedef,
    __module__='_ast',
    _attributes=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(slice)),
)

def Ellipsis_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Ellipsis, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        w_err = space.wrap("Ellipsis constructor takes no arguments")
        raise OperationError(space.w_TypeError, w_err)
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Ellipsis.typedef = typedef.TypeDef("Ellipsis",
    slice.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(Ellipsis)),
    __init__=interp2app(Ellipsis_init),
)

def Slice_get_lower(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'lower')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 1:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'lower')
    return space.wrap(w_self.lower)

def Slice_set_lower(space, w_self, w_new_value):
    try:
        w_self.lower = space.interp_w(expr, w_new_value, True)
        if type(w_self.lower) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'lower', w_new_value)
        w_self.initialization_state &= ~1
        return
    w_self.deldictvalue(space, 'lower')
    w_self.initialization_state |= 1

def Slice_get_upper(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'upper')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 2:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'upper')
    return space.wrap(w_self.upper)

def Slice_set_upper(space, w_self, w_new_value):
    try:
        w_self.upper = space.interp_w(expr, w_new_value, True)
        if type(w_self.upper) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'upper', w_new_value)
        w_self.initialization_state &= ~2
        return
    w_self.deldictvalue(space, 'upper')
    w_self.initialization_state |= 2

def Slice_get_step(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'step')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'step')
    return space.wrap(w_self.step)

def Slice_set_step(space, w_self, w_new_value):
    try:
        w_self.step = space.interp_w(expr, w_new_value, True)
        if type(w_self.step) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'step', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'step')
    w_self.initialization_state |= 4

_Slice_field_unroller = unrolling_iterable(['lower', 'upper', 'step'])
def Slice_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Slice, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 3:
            w_err = space.wrap("Slice constructor takes either 0 or 3 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Slice_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Slice.typedef = typedef.TypeDef("Slice",
    slice.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['lower', 'upper', 'step']),
    lower=typedef.GetSetProperty(Slice_get_lower, Slice_set_lower, cls=Slice),
    upper=typedef.GetSetProperty(Slice_get_upper, Slice_set_upper, cls=Slice),
    step=typedef.GetSetProperty(Slice_get_step, Slice_set_step, cls=Slice),
    __new__=interp2app(get_AST_new(Slice)),
    __init__=interp2app(Slice_init),
)

def ExtSlice_get_dims(space, w_self):
    if not w_self.initialization_state & 1:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'dims')
    if w_self.w_dims is None:
        if w_self.dims is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.dims]
        w_list = space.newlist(list_w)
        w_self.w_dims = w_list
    return w_self.w_dims

def ExtSlice_set_dims(space, w_self, w_new_value):
    w_self.w_dims = w_new_value
    w_self.initialization_state |= 1

_ExtSlice_field_unroller = unrolling_iterable(['dims'])
def ExtSlice_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(ExtSlice, w_self)
    w_self.w_dims = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 1:
            w_err = space.wrap("ExtSlice constructor takes either 0 or 1 positional argument")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _ExtSlice_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

ExtSlice.typedef = typedef.TypeDef("ExtSlice",
    slice.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['dims']),
    dims=typedef.GetSetProperty(ExtSlice_get_dims, ExtSlice_set_dims, cls=ExtSlice),
    __new__=interp2app(get_AST_new(ExtSlice)),
    __init__=interp2app(ExtSlice_init),
)

def Index_get_value(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'value')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 1:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'value')
    return space.wrap(w_self.value)

def Index_set_value(space, w_self, w_new_value):
    try:
        w_self.value = space.interp_w(expr, w_new_value, False)
        if type(w_self.value) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'value', w_new_value)
        w_self.initialization_state &= ~1
        return
    w_self.deldictvalue(space, 'value')
    w_self.initialization_state |= 1

_Index_field_unroller = unrolling_iterable(['value'])
def Index_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(Index, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 1:
            w_err = space.wrap("Index constructor takes either 0 or 1 positional argument")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _Index_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

Index.typedef = typedef.TypeDef("Index",
    slice.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['value']),
    value=typedef.GetSetProperty(Index_get_value, Index_set_value, cls=Index),
    __new__=interp2app(get_AST_new(Index)),
    __init__=interp2app(Index_init),
)

boolop.typedef = typedef.TypeDef("boolop",
    AST.typedef,
    __module__='_ast',
    _attributes=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(boolop)),
)

_And.typedef = typedef.TypeDef("And",
    boolop.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_And)),
)

_Or.typedef = typedef.TypeDef("Or",
    boolop.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_Or)),
)

operator.typedef = typedef.TypeDef("operator",
    AST.typedef,
    __module__='_ast',
    _attributes=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(operator)),
)

_Add.typedef = typedef.TypeDef("Add",
    operator.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_Add)),
)

_Sub.typedef = typedef.TypeDef("Sub",
    operator.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_Sub)),
)

_Mult.typedef = typedef.TypeDef("Mult",
    operator.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_Mult)),
)

_Div.typedef = typedef.TypeDef("Div",
    operator.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_Div)),
)

_Mod.typedef = typedef.TypeDef("Mod",
    operator.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_Mod)),
)

_Pow.typedef = typedef.TypeDef("Pow",
    operator.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_Pow)),
)

_LShift.typedef = typedef.TypeDef("LShift",
    operator.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_LShift)),
)

_RShift.typedef = typedef.TypeDef("RShift",
    operator.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_RShift)),
)

_BitOr.typedef = typedef.TypeDef("BitOr",
    operator.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_BitOr)),
)

_BitXor.typedef = typedef.TypeDef("BitXor",
    operator.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_BitXor)),
)

_BitAnd.typedef = typedef.TypeDef("BitAnd",
    operator.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_BitAnd)),
)

_FloorDiv.typedef = typedef.TypeDef("FloorDiv",
    operator.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_FloorDiv)),
)

unaryop.typedef = typedef.TypeDef("unaryop",
    AST.typedef,
    __module__='_ast',
    _attributes=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(unaryop)),
)

_Invert.typedef = typedef.TypeDef("Invert",
    unaryop.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_Invert)),
)

_Not.typedef = typedef.TypeDef("Not",
    unaryop.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_Not)),
)

_UAdd.typedef = typedef.TypeDef("UAdd",
    unaryop.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_UAdd)),
)

_USub.typedef = typedef.TypeDef("USub",
    unaryop.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_USub)),
)

cmpop.typedef = typedef.TypeDef("cmpop",
    AST.typedef,
    __module__='_ast',
    _attributes=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(cmpop)),
)

_Eq.typedef = typedef.TypeDef("Eq",
    cmpop.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_Eq)),
)

_NotEq.typedef = typedef.TypeDef("NotEq",
    cmpop.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_NotEq)),
)

_Lt.typedef = typedef.TypeDef("Lt",
    cmpop.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_Lt)),
)

_LtE.typedef = typedef.TypeDef("LtE",
    cmpop.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_LtE)),
)

_Gt.typedef = typedef.TypeDef("Gt",
    cmpop.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_Gt)),
)

_GtE.typedef = typedef.TypeDef("GtE",
    cmpop.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_GtE)),
)

_Is.typedef = typedef.TypeDef("Is",
    cmpop.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_Is)),
)

_IsNot.typedef = typedef.TypeDef("IsNot",
    cmpop.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_IsNot)),
)

_In.typedef = typedef.TypeDef("In",
    cmpop.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_In)),
)

_NotIn.typedef = typedef.TypeDef("NotIn",
    cmpop.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper([]),
    __new__=interp2app(get_AST_new(_NotIn)),
)

def comprehension_get_target(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'target')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 1:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'target')
    return space.wrap(w_self.target)

def comprehension_set_target(space, w_self, w_new_value):
    try:
        w_self.target = space.interp_w(expr, w_new_value, False)
        if type(w_self.target) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'target', w_new_value)
        w_self.initialization_state &= ~1
        return
    w_self.deldictvalue(space, 'target')
    w_self.initialization_state |= 1

def comprehension_get_iter(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'iter')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 2:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'iter')
    return space.wrap(w_self.iter)

def comprehension_set_iter(space, w_self, w_new_value):
    try:
        w_self.iter = space.interp_w(expr, w_new_value, False)
        if type(w_self.iter) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'iter', w_new_value)
        w_self.initialization_state &= ~2
        return
    w_self.deldictvalue(space, 'iter')
    w_self.initialization_state |= 2

def comprehension_get_ifs(space, w_self):
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'ifs')
    if w_self.w_ifs is None:
        if w_self.ifs is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.ifs]
        w_list = space.newlist(list_w)
        w_self.w_ifs = w_list
    return w_self.w_ifs

def comprehension_set_ifs(space, w_self, w_new_value):
    w_self.w_ifs = w_new_value
    w_self.initialization_state |= 4

_comprehension_field_unroller = unrolling_iterable(['target', 'iter', 'ifs'])
def comprehension_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(comprehension, w_self)
    w_self.w_ifs = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 3:
            w_err = space.wrap("comprehension constructor takes either 0 or 3 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _comprehension_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

comprehension.typedef = typedef.TypeDef("comprehension",
    AST.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['target', 'iter', 'ifs']),
    target=typedef.GetSetProperty(comprehension_get_target, comprehension_set_target, cls=comprehension),
    iter=typedef.GetSetProperty(comprehension_get_iter, comprehension_set_iter, cls=comprehension),
    ifs=typedef.GetSetProperty(comprehension_get_ifs, comprehension_set_ifs, cls=comprehension),
    __new__=interp2app(get_AST_new(comprehension)),
    __init__=interp2app(comprehension_init),
)

def excepthandler_get_lineno(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'lineno')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 1:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'lineno')
    return space.wrap(w_self.lineno)

def excepthandler_set_lineno(space, w_self, w_new_value):
    try:
        w_self.lineno = space.int_w(w_new_value)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'lineno', w_new_value)
        w_self.initialization_state &= ~1
        return
    w_self.deldictvalue(space, 'lineno')
    w_self.initialization_state |= 1

def excepthandler_get_col_offset(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'col_offset')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 2:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'col_offset')
    return space.wrap(w_self.col_offset)

def excepthandler_set_col_offset(space, w_self, w_new_value):
    try:
        w_self.col_offset = space.int_w(w_new_value)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'col_offset', w_new_value)
        w_self.initialization_state &= ~2
        return
    w_self.deldictvalue(space, 'col_offset')
    w_self.initialization_state |= 2

excepthandler.typedef = typedef.TypeDef("excepthandler",
    AST.typedef,
    __module__='_ast',
    _attributes=_FieldsWrapper(['lineno', 'col_offset']),
    lineno=typedef.GetSetProperty(excepthandler_get_lineno, excepthandler_set_lineno, cls=excepthandler),
    col_offset=typedef.GetSetProperty(excepthandler_get_col_offset, excepthandler_set_col_offset, cls=excepthandler),
    __new__=interp2app(get_AST_new(excepthandler)),
)

def ExceptHandler_get_type(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'type')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'type')
    return space.wrap(w_self.type)

def ExceptHandler_set_type(space, w_self, w_new_value):
    try:
        w_self.type = space.interp_w(expr, w_new_value, True)
        if type(w_self.type) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'type', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'type')
    w_self.initialization_state |= 4

def ExceptHandler_get_name(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'name')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'name')
    return space.wrap(w_self.name)

def ExceptHandler_set_name(space, w_self, w_new_value):
    try:
        w_self.name = space.interp_w(expr, w_new_value, True)
        if type(w_self.name) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'name', w_new_value)
        w_self.initialization_state &= ~8
        return
    w_self.deldictvalue(space, 'name')
    w_self.initialization_state |= 8

def ExceptHandler_get_body(space, w_self):
    if not w_self.initialization_state & 16:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'body')
    if w_self.w_body is None:
        if w_self.body is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.body]
        w_list = space.newlist(list_w)
        w_self.w_body = w_list
    return w_self.w_body

def ExceptHandler_set_body(space, w_self, w_new_value):
    w_self.w_body = w_new_value
    w_self.initialization_state |= 16

_ExceptHandler_field_unroller = unrolling_iterable(['type', 'name', 'body'])
def ExceptHandler_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(ExceptHandler, w_self)
    w_self.w_body = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 3:
            w_err = space.wrap("ExceptHandler constructor takes either 0 or 3 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _ExceptHandler_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

ExceptHandler.typedef = typedef.TypeDef("ExceptHandler",
    excepthandler.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['type', 'name', 'body']),
    type=typedef.GetSetProperty(ExceptHandler_get_type, ExceptHandler_set_type, cls=ExceptHandler),
    name=typedef.GetSetProperty(ExceptHandler_get_name, ExceptHandler_set_name, cls=ExceptHandler),
    body=typedef.GetSetProperty(ExceptHandler_get_body, ExceptHandler_set_body, cls=ExceptHandler),
    __new__=interp2app(get_AST_new(ExceptHandler)),
    __init__=interp2app(ExceptHandler_init),
)

def arguments_get_args(space, w_self):
    if not w_self.initialization_state & 1:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'args')
    if w_self.w_args is None:
        if w_self.args is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.args]
        w_list = space.newlist(list_w)
        w_self.w_args = w_list
    return w_self.w_args

def arguments_set_args(space, w_self, w_new_value):
    w_self.w_args = w_new_value
    w_self.initialization_state |= 1

def arguments_get_vararg(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'vararg')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 2:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'vararg')
    return space.wrap(w_self.vararg)

def arguments_set_vararg(space, w_self, w_new_value):
    try:
        if space.is_w(w_new_value, space.w_None):
            w_self.vararg = None
        else:
            w_self.vararg = space.realstr_w(w_new_value)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'vararg', w_new_value)
        w_self.initialization_state &= ~2
        return
    w_self.deldictvalue(space, 'vararg')
    w_self.initialization_state |= 2

def arguments_get_kwarg(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'kwarg')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 4:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'kwarg')
    return space.wrap(w_self.kwarg)

def arguments_set_kwarg(space, w_self, w_new_value):
    try:
        if space.is_w(w_new_value, space.w_None):
            w_self.kwarg = None
        else:
            w_self.kwarg = space.realstr_w(w_new_value)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'kwarg', w_new_value)
        w_self.initialization_state &= ~4
        return
    w_self.deldictvalue(space, 'kwarg')
    w_self.initialization_state |= 4

def arguments_get_defaults(space, w_self):
    if not w_self.initialization_state & 8:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'defaults')
    if w_self.w_defaults is None:
        if w_self.defaults is None:
            list_w = []
        else:
            list_w = [space.wrap(node) for node in w_self.defaults]
        w_list = space.newlist(list_w)
        w_self.w_defaults = w_list
    return w_self.w_defaults

def arguments_set_defaults(space, w_self, w_new_value):
    w_self.w_defaults = w_new_value
    w_self.initialization_state |= 8

_arguments_field_unroller = unrolling_iterable(['args', 'vararg', 'kwarg', 'defaults'])
def arguments_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(arguments, w_self)
    w_self.w_args = None
    w_self.w_defaults = None
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 4:
            w_err = space.wrap("arguments constructor takes either 0 or 4 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _arguments_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

arguments.typedef = typedef.TypeDef("arguments",
    AST.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['args', 'vararg', 'kwarg', 'defaults']),
    args=typedef.GetSetProperty(arguments_get_args, arguments_set_args, cls=arguments),
    vararg=typedef.GetSetProperty(arguments_get_vararg, arguments_set_vararg, cls=arguments),
    kwarg=typedef.GetSetProperty(arguments_get_kwarg, arguments_set_kwarg, cls=arguments),
    defaults=typedef.GetSetProperty(arguments_get_defaults, arguments_set_defaults, cls=arguments),
    __new__=interp2app(get_AST_new(arguments)),
    __init__=interp2app(arguments_init),
)

def keyword_get_arg(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'arg')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 1:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'arg')
    return space.wrap(w_self.arg)

def keyword_set_arg(space, w_self, w_new_value):
    try:
        w_self.arg = space.realstr_w(w_new_value)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'arg', w_new_value)
        w_self.initialization_state &= ~1
        return
    w_self.deldictvalue(space, 'arg')
    w_self.initialization_state |= 1

def keyword_get_value(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'value')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 2:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'value')
    return space.wrap(w_self.value)

def keyword_set_value(space, w_self, w_new_value):
    try:
        w_self.value = space.interp_w(expr, w_new_value, False)
        if type(w_self.value) is expr:
            raise OperationError(space.w_TypeError, space.w_None)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'value', w_new_value)
        w_self.initialization_state &= ~2
        return
    w_self.deldictvalue(space, 'value')
    w_self.initialization_state |= 2

_keyword_field_unroller = unrolling_iterable(['arg', 'value'])
def keyword_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(keyword, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 2:
            w_err = space.wrap("keyword constructor takes either 0 or 2 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _keyword_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

keyword.typedef = typedef.TypeDef("keyword",
    AST.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['arg', 'value']),
    arg=typedef.GetSetProperty(keyword_get_arg, keyword_set_arg, cls=keyword),
    value=typedef.GetSetProperty(keyword_get_value, keyword_set_value, cls=keyword),
    __new__=interp2app(get_AST_new(keyword)),
    __init__=interp2app(keyword_init),
)

def alias_get_name(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'name')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 1:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'name')
    return space.wrap(w_self.name)

def alias_set_name(space, w_self, w_new_value):
    try:
        w_self.name = space.realstr_w(w_new_value)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'name', w_new_value)
        w_self.initialization_state &= ~1
        return
    w_self.deldictvalue(space, 'name')
    w_self.initialization_state |= 1

def alias_get_asname(space, w_self):
    if w_self.w_dict is not None:
        w_obj = w_self.getdictvalue(space, 'asname')
        if w_obj is not None:
            return w_obj
    if not w_self.initialization_state & 2:
        raise operationerrfmt(space.w_AttributeError, "'%T' object has no attribute '%s'", w_self, 'asname')
    return space.wrap(w_self.asname)

def alias_set_asname(space, w_self, w_new_value):
    try:
        if space.is_w(w_new_value, space.w_None):
            w_self.asname = None
        else:
            w_self.asname = space.realstr_w(w_new_value)
    except OperationError, e:
        if not e.match(space, space.w_TypeError):
            raise
        w_self.setdictvalue(space, 'asname', w_new_value)
        w_self.initialization_state &= ~2
        return
    w_self.deldictvalue(space, 'asname')
    w_self.initialization_state |= 2

_alias_field_unroller = unrolling_iterable(['name', 'asname'])
def alias_init(space, w_self, __args__):
    w_self = space.descr_self_interp_w(alias, w_self)
    args_w, kwargs_w = __args__.unpack()
    if args_w:
        if len(args_w) != 2:
            w_err = space.wrap("alias constructor takes either 0 or 2 positional arguments")
            raise OperationError(space.w_TypeError, w_err)
        i = 0
        for field in _alias_field_unroller:
            space.setattr(w_self, space.wrap(field), args_w[i])
            i += 1
    for field, w_value in kwargs_w.iteritems():
        space.setattr(w_self, space.wrap(field), w_value)

alias.typedef = typedef.TypeDef("alias",
    AST.typedef,
    __module__='_ast',
    _fields=_FieldsWrapper(['name', 'asname']),
    name=typedef.GetSetProperty(alias_get_name, alias_set_name, cls=alias),
    asname=typedef.GetSetProperty(alias_get_asname, alias_set_asname, cls=alias),
    __new__=interp2app(get_AST_new(alias)),
    __init__=interp2app(alias_init),
)

