/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.gui.Messages;

public class HierarchyPropertyParser
implements Serializable {
    private static final long serialVersionUID = -4151103338506077544L;
    private TreeNode m_Root = new TreeNode();
    private TreeNode m_Current;
    private String m_Seperator = ".";
    private int m_Depth = 0;

    public HierarchyPropertyParser() {
        this.m_Root.parent = null;
        this.m_Root.children = new Vector();
        this.goToRoot();
    }

    public HierarchyPropertyParser(String p, String delim) throws Exception {
        this();
        this.build(p, delim);
    }

    public void setSeperator(String s) {
        this.m_Seperator = s;
    }

    public String getSeperator() {
        return this.m_Seperator;
    }

    public void build(String p, String delim) throws Exception {
        StringTokenizer st = new StringTokenizer(p, delim);
        while (st.hasMoreTokens()) {
            String property = st.nextToken().trim();
            if (!this.isHierachic(property)) {
                Messages.getInstance();
                throw new Exception(Messages.getString("HierarchyPropertyParser_Build_Exception_Text"));
            }
            this.add(property);
        }
        this.goToRoot();
    }

    public synchronized void add(String property) {
        String[] values = this.tokenize(property);
        if (this.m_Root.value == null) {
            this.m_Root.value = values[0];
        }
        this.buildBranch(this.m_Root, values, 1);
    }

    private void buildBranch(TreeNode parent, String[] values, int lvl) {
        Vector kids;
        int index;
        if (lvl == values.length) {
            parent.children = null;
            return;
        }
        if (lvl > this.m_Depth - 1) {
            this.m_Depth = lvl + 1;
        }
        if ((index = this.search(kids = parent.children, values[lvl])) != -1) {
            TreeNode newParent = (TreeNode)kids.elementAt(index);
            if (newParent.children == null) {
                newParent.children = new Vector();
            }
            this.buildBranch(newParent, values, lvl + 1);
        } else {
            TreeNode added = new TreeNode();
            added.parent = parent;
            added.value = values[lvl];
            added.children = new Vector();
            added.level = lvl;
            added.context = parent != this.m_Root ? parent.context + this.m_Seperator + parent.value : parent.value;
            kids.addElement(added);
            this.buildBranch(added, values, lvl + 1);
        }
    }

    public String[] tokenize(String rawString) {
        Vector<String> result = new Vector<String>();
        StringTokenizer tk = new StringTokenizer(rawString, this.m_Seperator);
        while (tk.hasMoreTokens()) {
            result.addElement(tk.nextToken());
        }
        String[] newStrings = new String[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            newStrings[i] = (String)result.elementAt(i);
        }
        return newStrings;
    }

    public boolean contains(String string) {
        String[] item = this.tokenize(string);
        if (!item[0].equals(this.m_Root.value)) {
            return false;
        }
        return this.isContained(this.m_Root, item, 1);
    }

    private boolean isContained(TreeNode parent, String[] values, int lvl) {
        if (lvl == values.length) {
            return true;
        }
        if (lvl > values.length) {
            return false;
        }
        Vector kids = parent.children;
        int index = this.search(kids, values[lvl]);
        if (index != -1) {
            TreeNode newParent = (TreeNode)kids.elementAt(index);
            return this.isContained(newParent, values, lvl + 1);
        }
        return false;
    }

    public boolean isHierachic(String string) {
        int index = string.indexOf(this.m_Seperator);
        return index != string.length() - 1 && index != -1;
    }

    public int search(Vector vct, String target) {
        if (vct == null) {
            return -1;
        }
        for (int i = 0; i < vct.size(); ++i) {
            if (!target.equals(((TreeNode)vct.elementAt((int)i)).value)) continue;
            return i;
        }
        return -1;
    }

    public synchronized boolean goTo(String path) {
        if (!this.isHierachic(path)) {
            if (this.m_Root.value.equals(path)) {
                this.goToRoot();
                return true;
            }
            return false;
        }
        TreeNode old = this.m_Current;
        this.m_Current = new TreeNode();
        this.goToRoot();
        String[] nodes = this.tokenize(path);
        if (!this.m_Current.value.equals(nodes[0])) {
            return false;
        }
        for (int i = 1; i < nodes.length; ++i) {
            int pos = this.search(this.m_Current.children, nodes[i]);
            if (pos == -1) {
                this.m_Current = old;
                return false;
            }
            this.m_Current = (TreeNode)this.m_Current.children.elementAt(pos);
        }
        return true;
    }

    public synchronized boolean goDown(String path) {
        if (!this.isHierachic(path)) {
            return this.goToChild(path);
        }
        TreeNode old = this.m_Current;
        this.m_Current = new TreeNode();
        String[] nodes = this.tokenize(path);
        int pos = this.search(old.children, nodes[0]);
        if (pos == -1) {
            this.m_Current = old;
            return false;
        }
        this.m_Current = (TreeNode)old.children.elementAt(pos);
        for (int i = 1; i < nodes.length; ++i) {
            pos = this.search(this.m_Current.children, nodes[i]);
            if (pos == -1) {
                this.m_Current = old;
                return false;
            }
            this.m_Current = (TreeNode)this.m_Current.children.elementAt(pos);
        }
        return true;
    }

    public synchronized void goToRoot() {
        this.m_Current = this.m_Root;
    }

    public synchronized void goToParent() {
        if (this.m_Current.parent != null) {
            this.m_Current = this.m_Current.parent;
        }
    }

    public synchronized boolean goToChild(String value) {
        if (this.m_Current.children == null) {
            return false;
        }
        int pos = this.search(this.m_Current.children, value);
        if (pos == -1) {
            return false;
        }
        this.m_Current = (TreeNode)this.m_Current.children.elementAt(pos);
        return true;
    }

    public synchronized void goToChild(int pos) throws Exception {
        if (this.m_Current.children == null || pos < 0 || pos >= this.m_Current.children.size()) {
            Messages.getInstance();
            throw new Exception(Messages.getString("HierarchyPropertyParser_GoToChild_Exception_Text"));
        }
        this.m_Current = (TreeNode)this.m_Current.children.elementAt(pos);
    }

    public synchronized int numChildren() {
        if (this.m_Current.children == null) {
            return 0;
        }
        return this.m_Current.children.size();
    }

    public synchronized String[] childrenValues() {
        if (this.m_Current.children == null) {
            return null;
        }
        Vector kids = this.m_Current.children;
        String[] values = new String[kids.size()];
        for (int i = 0; i < kids.size(); ++i) {
            values[i] = ((TreeNode)kids.elementAt((int)i)).value;
        }
        return values;
    }

    public synchronized String parentValue() {
        if (this.m_Current.parent != null) {
            return this.m_Current.parent.value;
        }
        return null;
    }

    public synchronized boolean isLeafReached() {
        return this.m_Current.children == null;
    }

    public synchronized boolean isRootReached() {
        return this.m_Current.parent == null;
    }

    public synchronized String getValue() {
        return this.m_Current.value;
    }

    public synchronized int getLevel() {
        return this.m_Current.level;
    }

    public int depth() {
        return this.m_Depth;
    }

    public synchronized String context() {
        return this.m_Current.context;
    }

    public synchronized String fullValue() {
        if (this.m_Current == this.m_Root) {
            return this.m_Root.value;
        }
        return this.m_Current.context + this.m_Seperator + this.m_Current.value;
    }

    public String showTree() {
        return this.showNode(this.m_Root, null);
    }

    private String showNode(TreeNode node, boolean[] hasBar) {
        int i;
        StringBuffer text = new StringBuffer();
        for (i = 0; i < node.level - 1; ++i) {
            if (hasBar[i]) {
                text.append("  |       ");
                continue;
            }
            text.append("          ");
        }
        if (node.level != 0) {
            text.append("  |------ ");
        }
        text.append(node.value + "(" + node.level + ")" + "[" + node.context + "]\n");
        if (node.children != null) {
            for (i = 0; i < node.children.size(); ++i) {
                boolean[] newBar = new boolean[node.level + 1];
                int lvl = node.level;
                if (hasBar != null) {
                    for (int j = 0; j < lvl; ++j) {
                        newBar[j] = hasBar[j];
                    }
                }
                newBar[lvl] = i != node.children.size() - 1;
                text.append(this.showNode((TreeNode)node.children.elementAt(i), newBar));
            }
        }
        return text.toString();
    }

    public static void main(String[] args) {
        StringBuffer sb = new StringBuffer();
        sb.append("node1.node1_1.node1_1_1.node1_1_1_1, ");
        sb.append("node1.node1_1.node1_1_1.node1_1_1_2, ");
        sb.append("node1.node1_1.node1_1_1.node1_1_1_3, ");
        sb.append("node1.node1_1.node1_1_2.node1_1_2_1, ");
        sb.append("node1.node1_1.node1_1_3.node1_1_3_1, ");
        sb.append("node1.node1_2.node1_2_1.node1_2_1_1, ");
        sb.append("node1.node1_2.node1_2_3.node1_2_3_1, ");
        sb.append("node1.node1_3.node1_3_3.node1_3_3_1, ");
        sb.append("node1.node1_3.node1_3_3.node1_3_3_2, ");
        String p = sb.toString();
        try {
            HierarchyPropertyParser hpp = new HierarchyPropertyParser(p, ", ");
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            System.out.println(stringBuilder.append(Messages.getString("HierarchyPropertyParser_Main_Text_First")).append(hpp.getSeperator()).toString());
            StringBuilder stringBuilder2 = new StringBuilder();
            Messages.getInstance();
            System.out.println(stringBuilder2.append(Messages.getString("HierarchyPropertyParser_Main_Text_Second")).append(hpp.depth()).toString());
            StringBuilder stringBuilder3 = new StringBuilder();
            Messages.getInstance();
            System.out.println(stringBuilder3.append(Messages.getString("HierarchyPropertyParser_Main_Text_Third")).append(hpp.showTree()).toString());
            hpp.goToRoot();
            StringBuilder stringBuilder4 = new StringBuilder();
            Messages.getInstance();
            StringBuilder stringBuilder5 = stringBuilder4.append(Messages.getString("HierarchyPropertyParser_Main_Text_Fourth")).append(hpp.goTo("node1.node1_2.node1_2_1")).append(": ").append(hpp.getValue()).append(" | ").append(hpp.fullValue());
            Messages.getInstance();
            System.out.println(stringBuilder5.append(Messages.getString("HierarchyPropertyParser_Main_Text_Fifth")).append(hpp.isLeafReached()).toString());
            StringBuilder stringBuilder6 = new StringBuilder();
            Messages.getInstance();
            System.out.println(stringBuilder6.append(Messages.getString("HierarchyPropertyParser_Main_Text_Sixth")).append(hpp.goDown("node1")).toString());
            StringBuilder stringBuilder7 = new StringBuilder();
            Messages.getInstance();
            System.out.println(stringBuilder7.append(Messages.getString("HierarchyPropertyParser_Main_Text_Seventh")).append(hpp.getValue()).toString());
            StringBuilder stringBuilder8 = new StringBuilder();
            Messages.getInstance();
            StringBuilder stringBuilder9 = stringBuilder8.append(Messages.getString("HierarchyPropertyParser_Main_Text_Eighth")).append(hpp.goToChild("node1_2_1_1")).append(": ").append(hpp.getValue()).append(" | ").append(hpp.fullValue());
            Messages.getInstance();
            StringBuilder stringBuilder10 = stringBuilder9.append(Messages.getString("HierarchyPropertyParser_Main_Text_Nineth")).append(hpp.isLeafReached());
            Messages.getInstance();
            System.out.println(stringBuilder10.append(Messages.getString("HierarchyPropertyParser_Main_Text_Tenth")).append(hpp.isRootReached()).toString());
            StringBuilder stringBuilder11 = new StringBuilder();
            Messages.getInstance();
            System.out.println(stringBuilder11.append(Messages.getString("HierarchyPropertyParser_Main_Text_Eleventh")).append(hpp.parentValue()).toString());
            StringBuilder stringBuilder12 = new StringBuilder();
            Messages.getInstance();
            System.out.println(stringBuilder12.append(Messages.getString("HierarchyPropertyParser_Main_Text_Twelveth")).append(hpp.getLevel()).toString());
            StringBuilder stringBuilder13 = new StringBuilder();
            Messages.getInstance();
            System.out.println(stringBuilder13.append(Messages.getString("HierarchyPropertyParser_Main_Text_Thirteenth")).append(hpp.context()).toString());
            hpp.goToRoot();
            StringBuilder stringBuilder14 = new StringBuilder();
            Messages.getInstance();
            StringBuilder stringBuilder15 = stringBuilder14.append(Messages.getString("HierarchyPropertyParser_Main_Text_Fourteenth")).append(hpp.isLeafReached());
            Messages.getInstance();
            System.out.println(stringBuilder15.append(Messages.getString("HierarchyPropertyParser_Main_Text_Fifteenth")).append(hpp.isRootReached()).toString());
            StringBuilder stringBuilder16 = new StringBuilder();
            Messages.getInstance();
            StringBuilder stringBuilder17 = stringBuilder16.append(Messages.getString("HierarchyPropertyParser_Main_Text_Sixteenth")).append(hpp.goDown("node1_1.node1_1_1"));
            Messages.getInstance();
            StringBuilder stringBuilder18 = stringBuilder17.append(Messages.getString("HierarchyPropertyParser_Main_Text_Seventeenth")).append(hpp.getValue()).append(" | ").append(hpp.fullValue());
            Messages.getInstance();
            StringBuilder stringBuilder19 = stringBuilder18.append(Messages.getString("HierarchyPropertyParser_Main_Text_Eighteenth")).append(hpp.getLevel());
            Messages.getInstance();
            StringBuilder stringBuilder20 = stringBuilder19.append(Messages.getString("HierarchyPropertyParser_Main_Text_Nineteenth")).append(hpp.isLeafReached());
            Messages.getInstance();
            System.out.println(stringBuilder20.append(Messages.getString("HierarchyPropertyParser_Main_Text_Twenty")).append(hpp.isRootReached()).toString());
            hpp.goToParent();
            StringBuilder stringBuilder21 = new StringBuilder();
            Messages.getInstance();
            System.out.println(stringBuilder21.append(Messages.getString("HierarchyPropertyParser_Main_Text_TwentyFirst")).append(hpp.getValue()).append(" | ").append(hpp.fullValue()).toString());
            StringBuilder stringBuilder22 = new StringBuilder();
            Messages.getInstance();
            System.out.println(stringBuilder22.append(Messages.getString("HierarchyPropertyParser_Main_Text_TwentySecond")).append(hpp.getLevel()).toString());
            String[] chd = hpp.childrenValues();
            for (int i = 0; i < chd.length; ++i) {
                StringBuilder stringBuilder23 = new StringBuilder();
                Messages.getInstance();
                System.out.print(stringBuilder23.append(Messages.getString("HierarchyPropertyParser_Main_Text_TwentyThird")).append(i).append(": ").append(chd[i]).toString());
                hpp.goDown(chd[i]);
                StringBuilder stringBuilder24 = new StringBuilder();
                Messages.getInstance();
                StringBuilder stringBuilder25 = stringBuilder24.append(Messages.getString("HierarchyPropertyParser_Main_Text_TwentyFourth")).append(hpp.getValue()).append(" | ").append(hpp.fullValue());
                Messages.getInstance();
                StringBuilder stringBuilder26 = stringBuilder25.append(Messages.getString("HierarchyPropertyParser_Main_Text_TwentyFifth")).append(hpp.getLevel());
                Messages.getInstance();
                System.out.println(stringBuilder26.append(Messages.getString("HierarchyPropertyParser_Main_Text_TwentySixth")).toString());
                hpp.goToParent();
            }
            StringBuilder stringBuilder27 = new StringBuilder();
            Messages.getInstance();
            System.out.println(stringBuilder27.append(Messages.getString("HierarchyPropertyParser_Main_Text_TwentySeventh")).append(hpp.goTo("node1")).append(": ").append(hpp.getValue()).append(" | ").append(hpp.fullValue()).toString());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private class TreeNode {
        public TreeNode parent = null;
        public String value = null;
        public Vector children = null;
        public int level = 0;
        public String context = null;

        private TreeNode() {
        }
    }
}

