/* This machine-generated file includes source code from GNU Jitter.

   Copyright (C) 2016-2021 Luca Saiu
   Written by Luca Saiu

   GNU Jitter is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published
   by the Free Software Foundation, either version 3 of the License,
   or (at your option) any later version.

   GNU Jitter is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Jitter.  If not, see <https://www.gnu.org/licenses/>.


  Copyright (C) 2016, 2017, 2019, 2020, 2021, 2022 Luca Saiu
  Written by Luca Saiu

  This file is part of GNU Jitter.

  GNU Jitter is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  GNU Jitter is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GNU Jitter.  If not, see <https://www.gnu.org/licenses/>.

*/

/* User-specified code, initial vm1 part: beginning. */

/* User-specified code, initial vm1 part: end */

/* VM library: main VM C file template.

   Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021 Luca Saiu
   Written by Luca Saiu

   This file is part of GNU Jitter.

   GNU Jitter is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNU Jitter is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Jitter.  If not, see <https://www.gnu.org/licenses/>. */


/* Generated file warning.
 * ************************************************************************** */

/* Unless this file is named exactly "vm1.c" , without any prefix, you are
   looking at a machine-generated derived file.  The original source is the vm.c
   template from Jitter, with added code implementing the uninspired VM. */




#include <jitter/jitter-early-header.h>

/* When we are using Gnulib the standard header files included below will in
   fact be Gnulib replacements; make sure that the Gnulib macros are
   recognised.
   It is in fact possible that  HAVE_CONFIG_H  is defined even in other
   contexts; it should be harmless to include config.h anyway. */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif // #ifdef HAVE_CONFIG_H

#include <assert.h>
#include <string.h>

#include <jitter/jitter.h>

#if defined (UNINSPIRED_PROFILE_SAMPLE)
#include <sys/time.h>
#endif // #if defined (UNINSPIRED_PROFILE_SAMPLE)

#include <jitter/jitter-hash.h>
#include <jitter/jitter-instruction.h>
#include <jitter/jitter-mmap.h>
#include <jitter/jitter-mutable-routine.h>
#include <jitter/jitter-print.h>
#include <jitter/jitter-rewrite.h>
#include <jitter/jitter-routine.h>
#include <jitter/jitter-routine-parser.h>
#include <jitter/jitter-specialize.h>
#include <jitter/jitter-defect.h>
#include <jitter/jitter-patch-in.h>

/* I don't need to include <jitter/jitter-executor.h> here, nor to define
   JITTER_THIS_CAN_INCLUDE_JITTER_EXECUTOR_H ; doing so carelessly might
   lead to subtle bugs, that it is better to prevent.
   Of course I can reconsider this decision in the future. */

#include <jitter/jitter-data-locations.h>

#include "uninspired-vm.h"
//#include "uninspired-specialized-instructions.h"
//#include "uninspired-meta-instructions.h"
#include <jitter/jitter-fatal.h>




/* Check requirements for particular features.
 * ************************************************************************** */

/* VM sample-profiling is only supported with GCC.  Do not bother activating it
   with other compilers, when the numbers would turn out to be unreliable in the
   end. */
#if  defined (UNINSPIRED_PROFILE_SAMPLE)        \
     && ! defined (JITTER_HAVE_ACTUAL_GCC)
# error "Sample-profiling is only supported with GCC: it requires (machine-independent)"
# error "GNU C extended asm.  It is not worth supporting other compilers if"
# error "the numbers turn out to be unreliable in the end."
#endif

/* Warn about the unreliability of sample-profiling with simple dispatches
   unless one of the complex dispatches is in use. */
#if  defined (UNINSPIRED_PROFILE_SAMPLE)                 \
     && ! defined (JITTER_DISPATCH_MINIMAL_THREADING)  \
     && ! defined (JITTER_DISPATCH_NO_THREADING)
# warning "Sample-profiling is unreliable with simple dispatches: the sample"
# warning "incrementation code can be executed at any point in the VM"
# warning "instruction, not necessarily at the same point (the beginning) for"
# warning "every VM instruction."
#endif




/* Machine-generated data structures.
 * ************************************************************************** */

/* Machine-generated data structures defining this VM.  Initializing a static
   struct is problematic, as it requires constant expressions for each field --
   and const pointers don't qualify.  This is why we initialize the struct
   fields below in uninspired_initialize. */
static struct jitter_vm
the_uninspired_vm;

struct jitter_vm * const
uninspired_vm = & the_uninspired_vm;

struct jitter_list_header * const
uninspired_states = & the_uninspired_vm.states;

/* It is convenient to have this initialised at start up, even before calling
   any initialisation function.  This makes it reliable to read this when, for
   example, handling --version . */
static const struct jitter_vm_configuration
uninspired_vm_the_configuration
  = {
      UNINSPIRED_LOWER_CASE_PREFIX /* lower_case_prefix */,
      UNINSPIRED_UPPER_CASE_PREFIX /* upper_case_prefix */,
      UNINSPIRED_HASH_PREFIX /* hash_prefix */,
      UNINSPIRED_MAX_FAST_REGISTER_NO_PER_CLASS
        /* max_fast_register_no_per_class */,
      UNINSPIRED_MAX_NONRESIDUAL_LITERAL_NO /* max_nonresidual_literal_no */,
      UNINSPIRED_DISPATCH_HUMAN_READABLE /* dispatch_human_readable */,
      /* The instrumentation field can be seen as a bit map.  See the comment
         in jitter/jitter-vm.h . */
      (jitter_vm_instrumentation_none
#if defined (UNINSPIRED_PROFILE_COUNT)
       | jitter_vm_instrumentation_count
#endif
#if defined (UNINSPIRED_PROFILE_SAMPLE)
       | jitter_vm_instrumentation_sample
#endif
       ) /* instrumentation */
    };

const struct jitter_vm_configuration * const
uninspired_vm_configuration
  = & uninspired_vm_the_configuration;




/* Initialization and finalization: internal functions, not for the user.
 * ************************************************************************** */

/* Initialize threads.  This only needs to be called once at initialization, and
   the user doesn't need to bother with it.  Defined along with the executor. */
void
uninspired_initialize_threads (void);

/* Check that the encodings in enum jitter_specialized_instruction_opcode (as
   used in the specializer) are coherent with machine-generated code.  Making a
   mistake here would introduce subtle bugs, so it's better to be defensive. */
static void
uninspired_check_specialized_instruction_opcode_once (void)
{
  static bool already_checked = false;
  if (already_checked)
    return;

  assert (((enum jitter_specialized_instruction_opcode)
           uninspired_specialized_instruction_opcode__eINVALID)
          == jitter_specialized_instruction_opcode_INVALID);
  assert (((enum jitter_specialized_instruction_opcode)
           uninspired_specialized_instruction_opcode__eBEGINBASICBLOCK)
          == jitter_specialized_instruction_opcode_BEGINBASICBLOCK);
  assert (((enum jitter_specialized_instruction_opcode)
           uninspired_specialized_instruction_opcode__eEXITVM)
          == jitter_specialized_instruction_opcode_EXITVM);
  assert (((enum jitter_specialized_instruction_opcode)
           uninspired_specialized_instruction_opcode__eDATALOCATIONS)
          == jitter_specialized_instruction_opcode_DATALOCATIONS);
  assert (((enum jitter_specialized_instruction_opcode)
           uninspired_specialized_instruction_opcode__eNOP)
          == jitter_specialized_instruction_opcode_NOP);
  assert (((enum jitter_specialized_instruction_opcode)
           uninspired_specialized_instruction_opcode__eUNREACHABLE0)
          == jitter_specialized_instruction_opcode_UNREACHABLE0);
  assert (((enum jitter_specialized_instruction_opcode)
           uninspired_specialized_instruction_opcode__eUNREACHABLE1)
          == jitter_specialized_instruction_opcode_UNREACHABLE1);
  assert (((enum jitter_specialized_instruction_opcode)
           uninspired_specialized_instruction_opcode__ePRETENDTOJUMPANYWHERE)
          == jitter_specialized_instruction_opcode_PRETENDTOJUMPANYWHERE);

  already_checked = true;
}

/* A prototype for a machine-generated function not needing a public
   declaration, only called thru a pointer within struct jitter_vm . */
int
uninspired_specialize_instruction (struct jitter_mutable_routine *p,
                                 const struct jitter_instruction *ins);

/* Initialize the pointed special-purpose data structure. */
static void
uninspired_initialize_special_purpose_data
   (volatile struct jitter_special_purpose_state_data *d)
{
  d->pending_notifications = 0;
  jitter_initialize_pending_signal_notifications
     (& d->pending_signal_notifications);

  /* Initialise profiling fields. */
  jitter_profile_runtime_initialize (uninspired_vm,
                                     (struct jitter_profile_runtime *)
                                     & d->profile_runtime);
}

/* Finalize the pointed special-purpose data structure. */
static void
uninspired_finalize_special_purpose_data
   (volatile struct jitter_special_purpose_state_data *d)
{
  jitter_finalize_pending_signal_notifications
     (d->pending_signal_notifications);

  jitter_profile_runtime_finalize (uninspired_vm,
                                   (struct jitter_profile_runtime *)
                                   & d->profile_runtime);
}




/* Check that we link with the correct Jitter library.
 * ************************************************************************** */

/* It is possible to make a mistake at link time, and link a VM compiled with
   some dispatch with the Jitter runtime for a different dispatch.  That
   would cause crashes that is better to prevent.  This is a way to detect such
   mistakes very early, by causing a link-time failure in case of mismatch. */
extern volatile const bool
JITTER_DISPATCH_DEPENDENT_GLOBAL_NAME;




/* Low-level debugging features relying on assembly: data locations.
 * ************************************************************************** */

#if defined (JITTER_HAVE_KNOWN_BINARY_FORMAT) && ! defined (JITTER_DISPATCH_SWITCH)
/* A declaration for data locations, as visible from C.  The global is defined in
   assembly in its own separate section thru the machinery in
   jitter/jitter-sections.h . */
extern const char
JITTER_DATA_LOCATION_NAME(uninspired) [];
#endif // #if ...

void
uninspired_dump_data_locations (jitter_print_context output)
{
#ifndef JITTER_DISPATCH_SWITCH
  jitter_dump_data_locations (output, & the_uninspired_vm);
#else
  jitter_print_char_star (output,
                          "VM data location information unavailable\n");
#endif // #ifndef JITTER_DISPATCH_SWITCH
}




/* Initialization and finalization.
 * ************************************************************************** */

#if defined (JITTER_HAVE_DEFECT_REPLACEMENT)
JITTER_DEFECT_DESCRIPTOR_DECLARATIONS_(uninspired)

/* This global is defined from C: there is no particular need of doing it in
   assembly.  It is initialised in uninspired_execute_or_initialize , where C
   labels are visible. */ // FIXME: unless it turns out to be simpler in assembly ...
jitter_int
uninspired_defect_descriptors_correct_displacement;
#endif // #if defined (JITTER_HAVE_DEFECT_REPLACEMENT)
#if defined (JITTER_HAVE_PATCH_IN)
JITTER_PATCH_IN_DESCRIPTOR_DECLARATIONS_(uninspired)
#endif // #if defined (JITTER_HAVE_PATCH_IN)

#ifndef JITTER_DISPATCH_SWITCH
/* True iff thread sizes are all non-negative and non-huge.  We refuse to
   disassemble otherwise, and when replication is enabled we refuse to run
   altogether.  See the comment right below. */
static bool
uninspired_threads_validated = false;
#endif // #ifndef JITTER_DISPATCH_SWITCH

/* Omit uninspired_validate_thread_sizes_once for switch-dispatching, as threads
   don't exist at all in that case.*/
#ifndef JITTER_DISPATCH_SWITCH
/* Check that VM instruction sizes are all non-negative, and that no thread
   starts before the end of the previous one.  Even one violation of such
   conditions is a symptom that the code has not been compiled with
   -fno-reorder-blocks , which would have disastrous effects with replication.
   It's better to validate threads at startup and fail immediately than to crash
   at run time.

   If even one thread appears to be wrong then refuse to disassemble when
   replication is disabled, and refuse to run altogether if replication is
   enabled. */
static void
uninspired_validate_threads_once (void)
{
  /* Return if this is not the first time we got here. */
  static bool already_validated = false;
  if (already_validated)
    return;

#ifdef JITTER_REPLICATE
# define JITTER_FAIL(error_text)                                             \
    do                                                                       \
      {                                                                      \
        fprintf (stderr,                                                     \
                 "About specialized instruction %i (%s) at %p, size %liB\n", \
                 i, uninspired_specialized_instruction_names [i],              \
                 uninspired_threads [i],                                       \
                 uninspired_thread_sizes [i]);                                 \
        jitter_fatal ("%s: you are not compiling with -fno-reorder-blocks",  \
                      error_text);                                           \
      }                                                                      \
    while (false)
#else
# define JITTER_FAIL(ignored_error_text)  \
    do                                    \
      {                                   \
        everything_valid = false;         \
        goto out;                         \
      }                                   \
    while (false)
#endif // #ifdef JITTER_REPLICATE

  /* The minimum address the next instruction code has to start at.

     This relies on NULL being zero, or in general lower in magnitude than any
     valid pointer.  It is not worth the trouble to be pedantic, as this will be
     true on every architecture where I can afford low-level tricks. */
  jitter_thread lower_bound = NULL;

  /* Check every thread.  We rely on the order here, following specialized
     instruction opcodes. */
  int i;
  bool everything_valid = true;
  for (i = 0; i < UNINSPIRED_SPECIALIZED_INSTRUCTION_NO; i ++)
    {
      jitter_thread thread = uninspired_threads [i];
      long size = uninspired_thread_sizes [i];

      /* Check that the current thread has non-negative non-huge size and
         doesn't start before the end of the previous one.  If this is true for
         all threads we can conclude that they are non-overlapping as well. */
      if (__builtin_expect (size < 0, false))
        JITTER_FAIL("a specialized instruction has negative code size");
      if (__builtin_expect (size > (1 << 24), false))
        JITTER_FAIL("a specialized instruction has huge code size");
      if (__builtin_expect (lower_bound > thread, false))
        JITTER_FAIL("non-sequential thread");

      /* The next thread cannot start before the end of the current one. */
      lower_bound = ((char*) thread) + size;
    }

#undef JITTER_FAIL

#ifndef JITTER_REPLICATE
 out:
#endif // #ifndef JITTER_REPLICATE

  /* If we have validated every thread size then disassembling appears safe. */
  if (everything_valid)
    uninspired_threads_validated = true;

  /* We have checked the thread sizes, once and for all.  If this function gets
     called again, thru a second uninspired initialization, it will immediately
     return. */
  already_validated = true;
}
#endif // #ifndef JITTER_DISPATCH_SWITCH

#if defined (JITTER_HAVE_DEFECT_REPLACEMENT)
/* The actual replacement table.  We only need it when defect replacement is in
   use. */
jitter_uint
uninspired_replacement_table [UNINSPIRED_SPECIALIZED_INSTRUCTION_NO];

/* The defective-instruction array for this VM.  The first
   defective_specialized_instruction_no elements of the array contain the
   specialized_instruction_ids of defective instructions; the remaining elements
   are set to -1.  This is initialised by jitter_fill_replacement_table . */
jitter_int
uninspired_defective_specialized_instructions [UNINSPIRED_SPECIALIZED_INSTRUCTION_NO];
#endif // #if defined (JITTER_HAVE_DEFECT_REPLACEMENT)

void
uninspired_initialize (void)
{
  /* Check that the Jitter library we linked is the right one.  This check
     actually only useful to force the global to be used.  I prefer not to use
     an assert, because assertions can be disabled. */
  if (! JITTER_DISPATCH_DEPENDENT_GLOBAL_NAME)
    jitter_fatal ("impossible to reach: the thing should fail at link time");

#ifdef JITTER_REPLICATE
  /* Initialize the executable-memory subsystem. */
  jitter_initialize_executable ();
#endif // #ifdef JITTER_REPLICATE

  /* Initialise the print-context machinery. */
  jitter_print_initialize ();

  /* Perform some sanity checks which only need to be run once. */
  uninspired_check_specialized_instruction_opcode_once ();

  /* We have to initialize threads before uninspired_threads , since the struct
     needs threads. */
  uninspired_initialize_threads ();

#ifndef JITTER_DISPATCH_SWITCH
  /* Validate threads, to make sure the generated code was not compiled with
     incorrect options.  This only needs to be done once. */
  uninspired_validate_threads_once ();
#endif // ifndef JITTER_DISPATCH_SWITCH

  /* Initialize the object pointed by uninspired_vm (see the comment above as to
     why we do it here).  Before actually setting the fields to valid data, fill
     the whole struct with a -- hopefully -- invalid pattern, just to catch
     bugs. */
  static bool vm_struct_initialized = false;
  if (! vm_struct_initialized)
    {
      memset (& the_uninspired_vm, 0xff, sizeof (struct jitter_vm));

      /* Make the configuration struct reachable from the VM struct. */
      the_uninspired_vm.configuration = uninspired_vm_configuration;
      //uninspired_print_vm_configuration (stdout, & the_uninspired_vm.configuration);

      /* Initialize meta-instruction pointers for implicit instructions.
         VM-independent program specialization relies on those, so they have to
         be accessible to the Jitter library, out of generated code.  Since
         meta-instructions are sorted alphabetically in the array, the index
         is not fixed. */
      the_uninspired_vm.exitvm_meta_instruction
        = (uninspired_meta_instructions + uninspired_meta_instruction_id_exitvm);
      the_uninspired_vm.unreachable_meta_instruction
        = (uninspired_meta_instructions
           + uninspired_meta_instruction_id_unreachable);

      /* Threads or pointers to native code blocks of course don't exist with
         switch-dispatching. */
#ifndef JITTER_DISPATCH_SWITCH
      the_uninspired_vm.threads = (jitter_thread *)uninspired_threads;
      the_uninspired_vm.thread_sizes = (long *) uninspired_thread_sizes;
      the_uninspired_vm.threads_validated = uninspired_threads_validated;
#if defined (JITTER_HAVE_KNOWN_BINARY_FORMAT)
      the_uninspired_vm.data_locations = JITTER_DATA_LOCATION_NAME(uninspired);
#else
      the_uninspired_vm.data_locations = NULL;
#endif // #if defined (JITTER_HAVE_KNOWN_BINARY_FORMAT)
#endif // #ifndef JITTER_DISPATCH_SWITCH

      the_uninspired_vm.specialized_instruction_residual_arities
        = uninspired_specialized_instruction_residual_arities;
      the_uninspired_vm.specialized_instruction_label_bitmasks
        = uninspired_specialized_instruction_label_bitmasks;

      /* FIXME: I might want to conditionalize this. */
      the_uninspired_vm.specialized_instruction_relocatables
        = uninspired_specialized_instruction_relocatables;

      the_uninspired_vm.specialized_instruction_callers
        = uninspired_specialized_instruction_callers;
      the_uninspired_vm.specialized_instruction_callees
        = uninspired_specialized_instruction_callees;

      the_uninspired_vm.specialized_instruction_names
        = uninspired_specialized_instruction_names;
      the_uninspired_vm.specialized_instruction_no
        = UNINSPIRED_SPECIALIZED_INSTRUCTION_NO;

      the_uninspired_vm.meta_instruction_string_hash
        = & uninspired_meta_instruction_hash;
      the_uninspired_vm.meta_instructions
        = (struct jitter_meta_instruction *) uninspired_meta_instructions;
      the_uninspired_vm.meta_instruction_no = UNINSPIRED_META_INSTRUCTION_NO;
      the_uninspired_vm.max_meta_instruction_name_length
        = UNINSPIRED_MAX_META_INSTRUCTION_NAME_LENGTH;
      the_uninspired_vm.specialized_instruction_to_unspecialized_instruction
        = uninspired_specialized_instruction_to_unspecialized_instruction;
      the_uninspired_vm.register_class_character_to_register_class
        = uninspired_register_class_character_to_register_class;
      the_uninspired_vm.specialize_instruction = uninspired_specialize_instruction;
      the_uninspired_vm.rewrite = uninspired_rewrite;

#if defined (JITTER_HAVE_DEFECT_REPLACEMENT)
      /* Fill the replacement table.  Since the array in question is a global
         with a fixed size, this needs to be done only once. */
      jitter_fill_replacement_table
         (uninspired_replacement_table,
          uninspired_defective_specialized_instructions,
          & the_uninspired_vm,
          uninspired_worst_case_replacement_table,
          uninspired_call_related_specialized_instruction_ids,
          uninspired_call_related_specialized_instruction_id_no,
          uninspired_specialized_instruction_call_relateds,
          JITTER_DEFECT_DESCRIPTORS_NAME (uninspired),
          (JITTER_DEFECT_DESCRIPTORS_SIZE_IN_BYTES_NAME (uninspired)
           / sizeof (struct jitter_defect_descriptor)),
          JITTER_DEFECT_CORRECT_DISPLACEMENT_NAME (uninspired));
      the_uninspired_vm.replacement_table = uninspired_replacement_table;
      the_uninspired_vm.defective_specialized_instructions
        = uninspired_defective_specialized_instructions;
      the_uninspired_vm.specialized_instruction_call_relateds
        = uninspired_specialized_instruction_call_relateds;
#else /* no defect replacement */
      /* In this configuration it is impossible to have defects: set every
         defect count to zero. */
      the_uninspired_vm.defect_no = 0;
      the_uninspired_vm.defective_specialized_instruction_no = 0;
      the_uninspired_vm.defective_call_related_specialized_instruction_no = 0;
      the_uninspired_vm.replacement_specialized_instruction_no = 0;
      the_uninspired_vm.replacement_table = NULL;
      the_uninspired_vm.defective_specialized_instructions = NULL;
      the_uninspired_vm.specialized_instruction_call_relateds = NULL;
#endif // #if defined (JITTER_HAVE_DEFECT_REPLACEMENT)

      /* Initialize the empty list of states. */
      JITTER_LIST_INITIALIZE_HEADER (& the_uninspired_vm.states);

      vm_struct_initialized = true;
    }

#ifdef JITTER_HAVE_PATCH_IN
    /* Since the patch-in table is destroyed at finalisation time we have to
       rebuild it at every initialisation, out of the previous conditional. */
    the_uninspired_vm.specialized_instruction_fast_label_bitmasks
      = uninspired_specialized_instruction_fast_label_bitmasks;
    the_uninspired_vm.patch_in_descriptors =
      JITTER_PATCH_IN_DESCRIPTORS_NAME(uninspired);
    const size_t patch_in_descriptor_size
      = sizeof (struct jitter_patch_in_descriptor);
    the_uninspired_vm.patch_in_descriptor_no
      = (JITTER_PATCH_IN_DESCRIPTORS_SIZE_IN_BYTES_NAME(uninspired)
         / patch_in_descriptor_size);
    /* Cheap sanity check: if the size in bytes is not a multiple of
       the element size, we are doing something very wrong. */
    if (JITTER_PATCH_IN_DESCRIPTORS_SIZE_IN_BYTES_NAME(uninspired)
        % patch_in_descriptor_size != 0)
      jitter_fatal ("patch-in descriptors total size %li not a multiple "
                    "of the element size %li",
                    (long) (JITTER_PATCH_IN_DESCRIPTORS_SIZE_IN_BYTES_NAME
                            (uninspired)),
                    (long) patch_in_descriptor_size);
    /* Initialize the patch-in table for this VM. */
    the_uninspired_vm.patch_in_table
      = jitter_make_patch_in_table (the_uninspired_vm.patch_in_descriptors,
                                    the_uninspired_vm.patch_in_descriptor_no,
                                    UNINSPIRED_SPECIALIZED_INSTRUCTION_NO);
#else
    the_uninspired_vm.specialized_instruction_fast_label_bitmasks = NULL;
#endif // #ifdef JITTER_HAVE_PATCH_IN

  jitter_initialize_meta_instructions (& uninspired_meta_instruction_hash,
                                         uninspired_meta_instructions,
                                         UNINSPIRED_META_INSTRUCTION_NO);

#if defined (JITTER_HAVE_DEFECT_REPLACEMENT)
# if 0
  jitter_dump_replacement_table (stderr, uninspired_replacement_table,
                                 & the_uninspired_vm);
  jitter_dump_defects (stderr, uninspired_defective_specialized_instructions,
                       & the_uninspired_vm,
                       uninspired_specialized_instruction_call_relateds);
# endif
#endif // #if defined (JITTER_HAVE_DEFECT_REPLACEMENT)
#if defined (JITTER_HAVE_PATCH_IN)
  //printf ("======================= Patch-in descriptors: BEGIN\n");
  //JITTER_DUMP_PATCH_IN_DESCRIPTORS(uninspired);
  //printf ("======================= Patch-in descriptors: END\n");
#endif // #if defined (JITTER_HAVE_PATCH_IN)
}

void
uninspired_finalize (void)
{
  /* There's no need to touch the_uninspired_vm ; we can keep it as it is, as it
     contains no dynamically-allocated fields. */
  /* Threads need no finalization. */
  jitter_finalize_meta_instructions (& uninspired_meta_instruction_hash);

#ifdef JITTER_HAVE_PATCH_IN
  /* Destroy the patch-in table for this VM. */
  jitter_destroy_patch_in_table (the_uninspired_vm.patch_in_table,
                                 UNINSPIRED_SPECIALIZED_INSTRUCTION_NO);
#endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
  /* Finalize the executable-memory subsystem. */
  jitter_finalize_executable ();
#endif // #ifdef JITTER_REPLICATE

  /* Finalize the state list.  If it is not empty then something has gone
     wrong earlier. */
  if (the_uninspired_vm.states.first != NULL
      || the_uninspired_vm.states.last != NULL)
    jitter_fatal ("not every state structure was destroyed before UNINSPIRED "
                  "finalisation.");
}




/* VM-dependant mutable routine initialization.
 * ************************************************************************** */

struct jitter_mutable_routine*
uninspired_make_mutable_routine (void)
{
  return jitter_make_mutable_routine (uninspired_vm);
}




/* Sample profiling: internal API.
 * ************************************************************************** */

#if defined (UNINSPIRED_PROFILE_SAMPLE)

/* Sample profiling depends on some system features: fail immediately if they
   are not available */
#if ! defined (JITTER_HAVE_SIGACTION) || ! defined (JITTER_HAVE_SETITIMER)
# jitter_fatal "sample-profiling depends on sigaction and setitimer"
#endif

static struct itimerval
uninspired_timer_interval;

static struct itimerval
uninspired_timer_disabled_interval;

/* The sampling data, currently global.  The current implementation does not
   play well with threads, but it can be changed later keeping the same user
   API. */
struct uninspired_sample_profile_state
{
  /* The state currently sample-profiling.  Since such a state can be only one
     right now this field is useful for printing error messages in case the user
     sets up sample-profiling from two states at the same time by mistake.
     This field is also useful for temporarily suspending and then reenabling
     sampling, when The Array is being resized: if the signal handler sees that
     this field is NULL it will not touch the fields. */
  struct uninspired_state *state_p;

  /* A pointer to the counts field within the sample_profile_runtime struct. */
  uint32_t *counts;

  /* A pointer to the current specialised instruction opcode within the
     sample_profile_runtime struct. */
  volatile jitter_int * specialized_opcode_p;

  /* A pointer to the field counting the number of samples, again within the
     sample_profile_runtime struct. */
  unsigned int *sample_no_p;
};

/* The (currently) one and only global state for sample-profiling. */
static struct uninspired_sample_profile_state
uninspired_sample_profile_state;

static void
uninspired_sigprof_handler (int signal)
{
#if 0
  assert (uninspired_sample_profile_state.state_p != NULL);
#endif

  jitter_int specialized_opcode
    = * uninspired_sample_profile_state.specialized_opcode_p;
  if (__builtin_expect ((specialized_opcode >= 0
                         && (specialized_opcode
                             < UNINSPIRED_SPECIALIZED_INSTRUCTION_NO)),
                        true))
    uninspired_sample_profile_state.counts [specialized_opcode] ++;

  (* uninspired_sample_profile_state.sample_no_p) ++;
}

void
uninspired_profile_sample_initialize (void)
{
  /* Perform a sanity check over the sampling period. */
  if (JITTER_PROFILE_SAMPLE_PERIOD_IN_MILLISECONDS <= 0 ||
      JITTER_PROFILE_SAMPLE_PERIOD_IN_MILLISECONDS >= 1000)
    jitter_fatal ("invalid JITTER_PROFILE_SAMPLE_PERIOD_IN_MILLISECONDS: %f",
                  (double) JITTER_PROFILE_SAMPLE_PERIOD_IN_MILLISECONDS);
  struct sigaction action;
  sigaction (SIGPROF, NULL, & action);
  action.sa_handler = uninspired_sigprof_handler;
  sigaction (SIGPROF, & action, NULL);

  long microseconds
    = (long) (JITTER_PROFILE_SAMPLE_PERIOD_IN_MILLISECONDS * 1000);
  uninspired_timer_interval.it_interval.tv_sec = 0;
  uninspired_timer_interval.it_interval.tv_usec = microseconds;
  uninspired_timer_interval.it_value = uninspired_timer_interval.it_interval;

  uninspired_sample_profile_state.state_p = NULL;
  uninspired_timer_disabled_interval.it_interval.tv_sec = 0;
  uninspired_timer_disabled_interval.it_interval.tv_usec = 0;
  uninspired_timer_disabled_interval.it_value
    = uninspired_timer_disabled_interval.it_interval;
}

void
uninspired_profile_sample_start (struct uninspired_state *state_p)
{
  struct jitter_sample_profile_runtime *spr
    = ((struct jitter_sample_profile_runtime *)
       & UNINSPIRED_STATE_TO_SPECIAL_PURPOSE_STATE_DATA (state_p)
           ->profile_runtime.sample_profile_runtime);

  if (uninspired_sample_profile_state.state_p != NULL)
    {
      if (state_p != uninspired_sample_profile_state.state_p)
        jitter_fatal ("currently it is only possible to sample-profile from "
                      "one state at the time: trying to sample-profile from "
                      "the state %p when already sample-profiling from the "
                      "state %p",
                      state_p, uninspired_sample_profile_state.state_p);
      else
        {
          /* This situation is a symptom of a bug, but does not need to lead
             to a fatal error. */
          printf ("WARNING: starting profile on the state %p when profiling "
                  "was already active in the same state.\n"
                  "Did you call longjmp from VM code?", state_p);
          fflush (stdout);
        }
    }
  uninspired_sample_profile_state.state_p = state_p;
  uninspired_sample_profile_state.sample_no_p = & spr->sample_no;
  uninspired_sample_profile_state.counts = spr->counts;
  uninspired_sample_profile_state.specialized_opcode_p
    = & spr->current_specialized_instruction_opcode;
  //fprintf (stderr, "SAMPLE START\n"); fflush (NULL);
  if (setitimer (ITIMER_PROF, & uninspired_timer_interval, NULL) != 0)
    jitter_fatal ("setitimer failed when establishing a timer");
}

void
uninspired_profile_sample_stop (void)
{
  if (setitimer (ITIMER_PROF, & uninspired_timer_disabled_interval, NULL) != 0)
    jitter_fatal ("setitimer failed when disabling a timer");

  uninspired_sample_profile_state.state_p = NULL;

  /* The rest is just for defenisveness' sake. */
  * uninspired_sample_profile_state.specialized_opcode_p = -1;
  uninspired_sample_profile_state.sample_no_p = NULL;
  uninspired_sample_profile_state.counts = NULL;
  uninspired_sample_profile_state.specialized_opcode_p = NULL;
}
#endif // #if defined (UNINSPIRED_PROFILE_SAMPLE)




/* Slow register initialisation.
 * ************************************************************************** */

/* Initialise slow registers (for register classes defining an initial value) in
   a given Array, starting from a given rank up to another given rank.  The
   argument old_slow_register_no_per_class indicates the number of already
   initialised ranks, which this functions does not touch;
   new_slow_register_no_per_class indicates the new number of ranks.  Every rank
   from old_slow_register_no_per_class + 1 to new_slow_register_no_per_class,
   both included, will be initialised. */
static void
uninspired_initialize_slow_registers (char *initial_array_pointer,
                                    jitter_int old_slow_register_no_per_class,
                                    jitter_int new_slow_register_no_per_class)
{
  /* Compute the address of the first slow registers, which is the beginning
     of the first rank. */
  union uninspired_any_register *first_slow_register
    = ((union uninspired_any_register *)
       ((char *) initial_array_pointer
        + UNINSPIRED_FIRST_SLOW_REGISTER_UNBIASED_OFFSET));

  /* Initialise every *new* rank, without touching the old ones. */
  jitter_int i;
  for (i = old_slow_register_no_per_class;
       i < new_slow_register_no_per_class;
       i ++)
    {
      /* A pointer to the i-th rank of slow registers.  Every register
         in the rank is new and in general (according to its class) may
         need initialisation. */
      union uninspired_any_register *rank
        = first_slow_register + (i * UNINSPIRED_REGISTER_CLASS_NO);
      UNINSPIRED_INITIALIZE_SLOW_REGISTER_RANK (rank);
    }
#if 0
      fprintf (stderr, "initialised %li (up from %li) slow registers per class, array at %p\n",
               (long) new_slow_register_no_per_class,
               (long) old_slow_register_no_per_class,
               initial_array_pointer);
#endif
}




/* Array re-allocation.
 * ************************************************************************** */

char *
uninspired_make_place_for_slow_registers (struct uninspired_state *s,
                                        jitter_int new_slow_register_no_per_class)
{
  if (new_slow_register_no_per_class < 0)
    jitter_fatal ("uninspired_make_place_for_slow_registers: negative slow "
                  "register number");
  jitter_int old_slow_register_no_per_class
    = s->uninspired_state_backing.jitter_slow_register_no_per_class;
  /* Change nothing if we already have enough space for the required number of
     slow registers.  The no-change case will be the most common one, and
     this function might be worth optimizing. */
  if (__builtin_expect (new_slow_register_no_per_class
                        > old_slow_register_no_per_class,
                        false))
    {
#if defined (UNINSPIRED_PROFILE_SAMPLE)
      /* If sample-profiling is currently in progress on this state suspend it
         temporarily. */
      bool suspending_sample_profiling
        = (uninspired_sample_profile_state.state_p == s);
      if (suspending_sample_profiling)
        uninspired_profile_sample_stop ();
#endif // #if defined (UNINSPIRED_PROFILE_SAMPLE)

#if 0
      printf ("Increasing slow register-no (per class) from %li to %li\n", (long) old_slow_register_no_per_class, (long)new_slow_register_no_per_class);
      printf ("Array size %li -> %li\n", (long) UNINSPIRED_ARRAY_SIZE(old_slow_register_no_per_class), (long) UNINSPIRED_ARRAY_SIZE(new_slow_register_no_per_class));
#endif
      /* Save the new value for new_slow_register_no_per_class in the state
         structure; reallocate The Array. */
      s->uninspired_state_backing.jitter_slow_register_no_per_class
        = new_slow_register_no_per_class;
      s->uninspired_state_backing.jitter_array
        = jitter_xrealloc ((void *) s->uninspired_state_backing.jitter_array,
                           UNINSPIRED_ARRAY_SIZE(new_slow_register_no_per_class));

     /* Initialise the slow registers we have just added, for every class. */
     uninspired_initialize_slow_registers (s->uninspired_state_backing.jitter_array,
                                         old_slow_register_no_per_class,
                                         new_slow_register_no_per_class);

#if defined (UNINSPIRED_PROFILE_SAMPLE)
      /* Now we can resume sample-profiling on this state if we suspended it. */
      if (suspending_sample_profiling)
        uninspired_profile_sample_start (s);
#endif // #if defined (UNINSPIRED_PROFILE_SAMPLE)
#if 0
      fprintf (stderr, "slow registers are now %li per class, Array at %p (biased %p)\n",
               ((long)
                s->uninspired_state_backing.jitter_slow_register_no_per_class),
               s->uninspired_state_backing.jitter_array,
               s->uninspired_state_backing.jitter_array + JITTER_ARRAY_BIAS);
#endif
    }

  /* Return the new (or unchanged) base, by simply adding the bias to the
     Array as it is now. */
  return s->uninspired_state_backing.jitter_array + JITTER_ARRAY_BIAS;
}

void
uninspired_ensure_enough_slow_registers_for_executable_routine
   (const struct jitter_executable_routine *er, struct uninspired_state *s)
{
  uninspired_make_place_for_slow_registers (s, er->slow_register_per_class_no);
}




/* Program text frontend.
 * ************************************************************************** */

struct uninspired_routine_parse_error *
uninspired_parse_mutable_routine_from_file_star (FILE *input_file,
                                               struct jitter_mutable_routine *p)
{
  return jitter_parse_mutable_routine_from_file_star (input_file, p,
                                                      uninspired_vm);
}

struct uninspired_routine_parse_error *
uninspired_parse_mutable_routine_from_file (const char *input_file_name,
                                          struct jitter_mutable_routine *p)
{
  return jitter_parse_mutable_routine_from_file (input_file_name, p,
                                                 uninspired_vm);
}

struct uninspired_routine_parse_error *
uninspired_parse_mutable_routine_from_string (const char *string,
                                            struct jitter_mutable_routine *p)
{
  return jitter_parse_mutable_routine_from_string (string, p, uninspired_vm);
}




/* State making and destroying.
 * ************************************************************************** */

/* State initialisation (with a given number of slow registers), reset and
   finalisation are machine-generated. */

void
uninspired_state_initialize (struct uninspired_state *sp)
{
  uninspired_state_initialize_with_slow_registers (sp, 0);
}

struct uninspired_state *
uninspired_state_make_with_slow_registers (jitter_uint slow_register_no_per_class)
{
  struct uninspired_state *res = jitter_xmalloc (sizeof (struct uninspired_state));
  uninspired_state_initialize_with_slow_registers (res,
                                                 slow_register_no_per_class);
  return res;
}

struct uninspired_state *
uninspired_state_make (void)
{
  return uninspired_state_make_with_slow_registers (0);
}

void
uninspired_state_destroy (struct uninspired_state *state)
{
  uninspired_state_finalize (state);
  free (state);
}




/* Executing code: unified routine API.
 * ************************************************************************** */

void
uninspired_ensure_enough_slow_registers_for_routine
   (jitter_routine r, struct uninspired_state *s)
{
  struct jitter_executable_routine *e
    = jitter_routine_make_executable_if_needed (r);
  uninspired_ensure_enough_slow_registers_for_executable_routine (e, s);
}

enum uninspired_exit_status
uninspired_execute_routine (jitter_routine r,
                          struct uninspired_state *s)
{
  struct jitter_executable_routine *e
    = jitter_routine_make_executable_if_needed (r);
  return uninspired_execute_executable_routine (e, s);
}





/* Defects and replacements: user API.
 * ************************************************************************** */

/* These functions are all trivial wrappers around the functionality declared
   in jitter/jitter-defect.h, hiding the VM pointer. */

void
uninspired_defect_print_summary (jitter_print_context cx)
{
  jitter_defect_print_summary (cx, uninspired_vm);
}

void
uninspired_defect_print (jitter_print_context cx,
                       unsigned indentation_column_no)
{
  jitter_defect_print (cx, uninspired_vm, indentation_column_no);
}

void
uninspired_defect_print_replacement_table (jitter_print_context cx,
                                         unsigned indentation_column_no)
{
  jitter_defect_print_replacement_table (cx, uninspired_vm, indentation_column_no);
}




/* Profiling: user API.
 * ************************************************************************** */

/* These functions are all trivial wrappers around the functionality declared
   in jitter/jitter-profile.h, hiding the VM pointer. */

struct uninspired_profile_runtime *
uninspired_state_profile_runtime (struct uninspired_state *s)
{
  volatile struct jitter_special_purpose_state_data *spd
    = UNINSPIRED_ARRAY_TO_SPECIAL_PURPOSE_STATE_DATA
        (s->uninspired_state_backing.jitter_array);
  return (struct uninspired_profile_runtime *) & spd->profile_runtime;
}

struct uninspired_profile_runtime *
uninspired_profile_runtime_make (void)
{
  return jitter_profile_runtime_make (uninspired_vm);
}

void
uninspired_profile_runtime_destroy (struct uninspired_profile_runtime *p)
{
  jitter_profile_runtime_destroy (uninspired_vm, p);
}

void
uninspired_profile_runtime_clear (struct uninspired_profile_runtime * p)
{
  jitter_profile_runtime_clear (uninspired_vm, p);
}

void
uninspired_profile_runtime_merge_from (struct uninspired_profile_runtime *to,
                                     const struct uninspired_profile_runtime *from)
{
  jitter_profile_runtime_merge_from (uninspired_vm, to, from);
}

void
uninspired_profile_runtime_merge_from_state (struct uninspired_profile_runtime *to,
                                           const struct uninspired_state *from_state)
{
  const struct uninspired_profile_runtime* from
    = uninspired_state_profile_runtime ((struct uninspired_state *) from_state);
  jitter_profile_runtime_merge_from (uninspired_vm, to, from);
}

void
uninspired_profile_runtime_print_unspecialized
   (jitter_print_context ct,
    const struct uninspired_profile_runtime *p)
{
  jitter_profile_runtime_print_unspecialized (ct, uninspired_vm, p);
}

void
uninspired_profile_runtime_print_specialized (jitter_print_context ct,
                                            const struct uninspired_profile_runtime
                                            *p)
{
  jitter_profile_runtime_print_specialized (ct, uninspired_vm, p);
}

struct uninspired_profile *
uninspired_profile_unspecialized_from_runtime
   (const struct uninspired_profile_runtime *p)
{
  return jitter_profile_unspecialized_from_runtime (uninspired_vm, p);
}

struct uninspired_profile *
uninspired_profile_specialized_from_runtime (const struct uninspired_profile_runtime
                                           *p)
{
  return jitter_profile_specialized_from_runtime (uninspired_vm, p);
}




/* Evrything following this point is machine-generated.
 * ************************************************************************** */

/* What follows could be conceptually split into several generated C files, but
   having too many of them would be inconvenient for the user to compile and
   link.  For this reason we currently generate just three files: one is this,
   which also contains the specializer, another is for the executor, and then a
   header -- a main module is optional.  The executor will be potentially very
   large, so it is best compiled separately.  The specializer might be large as
   well at this stage, even if its compilation is usually much less
   expensive. */
/* These two macros are convenient for making VM-specific identifiers
   using VM-independent macros from a public header, without polluting
   the global namespace. */
#define JITTER_VM_PREFIX_LOWER_CASE uninspired
#define JITTER_VM_PREFIX_UPPER_CASE UNINSPIRED

/* User-specified code, printer part: beginning. */

/* User-specified code, printer part: end */

//#include <stdbool.h>

//#include <jitter/jitter.h>
//#include <jitter/jitter-instruction.h>

//#include "uninspired-meta-instructions.h"

// FIXME: comment.
struct jitter_hash_table
uninspired_meta_instruction_hash;


static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_add_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_addo_meta_instruction_parameter_types [4] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_b_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_band_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_beq_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_bge_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_bgeu_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_bgt_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_bgtu_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_ble_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_bleu_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_blt_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_bltu_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_bne_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_bneg_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_bnneg_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_bnotand_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_bnpos_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_bnz_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_bpos_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_br_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_bulge_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_bz_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_div_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_divo_meta_instruction_parameter_types [4] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_exit_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_fadd_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_f, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_f, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_f, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_fdiv_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_f, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_f, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_f, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_fincr_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_f, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_fmul_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_f, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_f, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_f, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_fprint_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_f, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_fset_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_f, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_fsub_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_f, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_f, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_f, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_loadwithbyteoffset_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_loadwithwordoffset_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_mallocwords_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_mod_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_modo_meta_instruction_parameter_types [4] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_mov_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum_or_literal_label, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_mroll_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_mul_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_mulo_meta_instruction_parameter_types [4] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_print_mtopmost_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_printfixnum_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_printufixnum_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_procedurecall_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_procedurecallr_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_label, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_push_mdepths_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_push_mhandler_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_push_mincreasing_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_raise_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_random_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_reverse_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_roll_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_safe_mpoint_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_slide_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_stackif_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_stacknondroppingif_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_stackpeek_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_stackplusr_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_stackpop_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_stackpush_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum_or_literal_label, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_stackset_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum_or_literal_label, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_stackswaptop_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_storewithbyteoffset_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_storewithwordoffset_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_sub_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_subo_meta_instruction_parameter_types [4] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_register, & uninspired_register_class_r, jitter_default_literal_parameter_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type uninspired_whirl_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, jitter_default_literal_parameter_printer } };


const struct jitter_meta_instruction
uninspired_meta_instructions [UNINSPIRED_META_INSTRUCTION_NO]
  = {
      { 0, "add", 3, false, false, false, true /* this ignores replacements */, uninspired_add_meta_instruction_parameter_types },
      { 1, "addo", 4, true, false, false, true /* this ignores replacements */, uninspired_addo_meta_instruction_parameter_types },
      { 2, "b", 1, true, false, false, true /* this ignores replacements */, uninspired_b_meta_instruction_parameter_types },
      { 3, "band", 3, true, false, false, true /* this ignores replacements */, uninspired_band_meta_instruction_parameter_types },
      { 4, "beq", 3, true, false, false, true /* this ignores replacements */, uninspired_beq_meta_instruction_parameter_types },
      { 5, "bge", 3, true, false, false, true /* this ignores replacements */, uninspired_bge_meta_instruction_parameter_types },
      { 6, "bgeu", 3, true, false, false, true /* this ignores replacements */, uninspired_bgeu_meta_instruction_parameter_types },
      { 7, "bgt", 3, true, false, false, true /* this ignores replacements */, uninspired_bgt_meta_instruction_parameter_types },
      { 8, "bgtu", 3, true, false, false, true /* this ignores replacements */, uninspired_bgtu_meta_instruction_parameter_types },
      { 9, "ble", 3, true, false, false, true /* this ignores replacements */, uninspired_ble_meta_instruction_parameter_types },
      { 10, "bleu", 3, true, false, false, true /* this ignores replacements */, uninspired_bleu_meta_instruction_parameter_types },
      { 11, "blt", 3, true, false, false, true /* this ignores replacements */, uninspired_blt_meta_instruction_parameter_types },
      { 12, "bltu", 3, true, false, false, true /* this ignores replacements */, uninspired_bltu_meta_instruction_parameter_types },
      { 13, "bne", 3, true, false, false, true /* this ignores replacements */, uninspired_bne_meta_instruction_parameter_types },
      { 14, "bneg", 2, true, false, false, true /* this ignores replacements */, uninspired_bneg_meta_instruction_parameter_types },
      { 15, "bnneg", 2, true, false, false, true /* this ignores replacements */, uninspired_bnneg_meta_instruction_parameter_types },
      { 16, "bnotand", 3, true, false, false, true /* this ignores replacements */, uninspired_bnotand_meta_instruction_parameter_types },
      { 17, "bnpos", 2, true, false, false, true /* this ignores replacements */, uninspired_bnpos_meta_instruction_parameter_types },
      { 18, "bnz", 2, true, false, false, true /* this ignores replacements */, uninspired_bnz_meta_instruction_parameter_types },
      { 19, "bpos", 2, true, false, false, true /* this ignores replacements */, uninspired_bpos_meta_instruction_parameter_types },
      { 20, "br", 1, true, false, false, true /* this ignores replacements */, uninspired_br_meta_instruction_parameter_types },
      { 21, "bulge", 1, false, false, false, true /* this ignores replacements */, uninspired_bulge_meta_instruction_parameter_types },
      { 22, "bulgeforth", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 23, "bz", 2, true, false, false, true /* this ignores replacements */, uninspired_bz_meta_instruction_parameter_types },
      { 24, "clear-pending", 0, false, false, false, false /* this ignores replacements */, NULL },
      { 25, "div", 3, false, false, false, false /* this ignores replacements */, uninspired_div_meta_instruction_parameter_types },
      { 26, "divo", 4, true, false, false, true /* this ignores replacements */, uninspired_divo_meta_instruction_parameter_types },
      { 27, "drop-handler", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 28, "endvm", 0, true, false, false, true /* this ignores replacements */, NULL },
      { 29, "exit", 1, false, false, false, false /* this ignores replacements */, uninspired_exit_meta_instruction_parameter_types },
      { 30, "exitvm", 0, true, false, false, true /* this ignores replacements */, NULL },
      { 31, "fadd", 3, false, false, false, true /* this ignores replacements */, uninspired_fadd_meta_instruction_parameter_types },
      { 32, "fdiv", 3, false, false, false, true /* this ignores replacements */, uninspired_fdiv_meta_instruction_parameter_types },
      { 33, "fincr", 1, false, false, false, true /* this ignores replacements */, uninspired_fincr_meta_instruction_parameter_types },
      { 34, "fmul", 3, false, false, false, true /* this ignores replacements */, uninspired_fmul_meta_instruction_parameter_types },
      { 35, "fprint", 1, false, false, false, true /* this ignores replacements */, uninspired_fprint_meta_instruction_parameter_types },
      { 36, "fset", 2, false, false, false, true /* this ignores replacements */, uninspired_fset_meta_instruction_parameter_types },
      { 37, "fsub", 3, false, false, false, true /* this ignores replacements */, uninspired_fsub_meta_instruction_parameter_types },
      { 38, "hcf", 0, false, false, false, false /* this ignores replacements */, NULL },
      { 39, "install-signal-handler", 0, false, false, false, false /* this ignores replacements */, NULL },
      { 40, "loadwithbyteoffset", 3, false, false, false, true /* this ignores replacements */, uninspired_loadwithbyteoffset_meta_instruction_parameter_types },
      { 41, "loadwithwordoffset", 3, false, false, false, true /* this ignores replacements */, uninspired_loadwithwordoffset_meta_instruction_parameter_types },
      { 42, "mallocwords", 2, false, false, false, false /* this ignores replacements */, uninspired_mallocwords_meta_instruction_parameter_types },
      { 43, "mod", 3, false, false, false, false /* this ignores replacements */, uninspired_mod_meta_instruction_parameter_types },
      { 44, "modo", 4, true, false, false, true /* this ignores replacements */, uninspired_modo_meta_instruction_parameter_types },
      { 45, "mov", 2, false, false, false, true /* this ignores replacements */, uninspired_mov_meta_instruction_parameter_types },
      { 46, "mroll", 1, false, false, false, true /* this ignores replacements */, uninspired_mroll_meta_instruction_parameter_types },
      { 47, "mrollforth", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 48, "mrot", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 49, "mul", 3, false, false, false, true /* this ignores replacements */, uninspired_mul_meta_instruction_parameter_types },
      { 50, "mulo", 4, true, false, false, true /* this ignores replacements */, uninspired_mulo_meta_instruction_parameter_types },
      { 51, "nop", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 52, "print-pending-signals", 0, false, false, false, false /* this ignores replacements */, NULL },
      { 53, "print-topmost", 1, false, false, false, false /* this ignores replacements */, uninspired_print_mtopmost_meta_instruction_parameter_types },
      { 54, "printfixnum", 1, false, false, false, false /* this ignores replacements */, uninspired_printfixnum_meta_instruction_parameter_types },
      { 55, "printufixnum", 1, false, false, false, false /* this ignores replacements */, uninspired_printufixnum_meta_instruction_parameter_types },
      { 56, "procedurecall", 1, true, true, false, true /* this ignores replacements */, uninspired_procedurecall_meta_instruction_parameter_types },
      { 57, "procedurecallr", 1, true, true, false, true /* this ignores replacements */, uninspired_procedurecallr_meta_instruction_parameter_types },
      { 58, "procedureprolog", 0, true, false, true, true /* this ignores replacements */, NULL },
      { 59, "procedurereturn", 0, true, false, false, true /* this ignores replacements */, NULL },
      { 60, "push-depths", 1, false, false, false, false /* this ignores replacements */, uninspired_push_mdepths_meta_instruction_parameter_types },
      { 61, "push-handler", 2, false, false, false, true /* this ignores replacements */, uninspired_push_mhandler_meta_instruction_parameter_types },
      { 62, "push-increasing", 1, false, false, false, false /* this ignores replacements */, uninspired_push_mincreasing_meta_instruction_parameter_types },
      { 63, "quake", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 64, "raise", 1, true, false, false, true /* this ignores replacements */, uninspired_raise_meta_instruction_parameter_types },
      { 65, "random", 1, false, false, false, false /* this ignores replacements */, uninspired_random_meta_instruction_parameter_types },
      { 66, "reverse", 1, false, false, false, true /* this ignores replacements */, uninspired_reverse_meta_instruction_parameter_types },
      { 67, "roll", 1, false, false, false, true /* this ignores replacements */, uninspired_roll_meta_instruction_parameter_types },
      { 68, "rollforth", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 69, "rot", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 70, "safe-point", 1, true, false, false, true /* this ignores replacements */, uninspired_safe_mpoint_meta_instruction_parameter_types },
      { 71, "set-pending", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 72, "slide", 2, false, false, false, true /* this ignores replacements */, uninspired_slide_meta_instruction_parameter_types },
      { 73, "slideforth", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 74, "stackdrop", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 75, "stackdup", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 76, "stackif", 1, true, false, false, true /* this ignores replacements */, uninspired_stackif_meta_instruction_parameter_types },
      { 77, "stacknip", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 78, "stacknondroppingif", 1, true, false, false, true /* this ignores replacements */, uninspired_stacknondroppingif_meta_instruction_parameter_types },
      { 79, "stacknot", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 80, "stackoneminus", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 81, "stackoneplus", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 82, "stackover", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 83, "stackpeek", 1, false, false, false, true /* this ignores replacements */, uninspired_stackpeek_meta_instruction_parameter_types },
      { 84, "stackplus", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 85, "stackplusr", 1, false, false, false, true /* this ignores replacements */, uninspired_stackplusr_meta_instruction_parameter_types },
      { 86, "stackpop", 1, false, false, false, true /* this ignores replacements */, uninspired_stackpop_meta_instruction_parameter_types },
      { 87, "stackprint", 0, false, false, false, false /* this ignores replacements */, NULL },
      { 88, "stackpush", 1, false, false, false, true /* this ignores replacements */, uninspired_stackpush_meta_instruction_parameter_types },
      { 89, "stackpushunspecified", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 90, "stackset", 1, false, false, false, true /* this ignores replacements */, uninspired_stackset_meta_instruction_parameter_types },
      { 91, "stackswap", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 92, "stackswaptop", 1, false, false, false, true /* this ignores replacements */, uninspired_stackswaptop_meta_instruction_parameter_types },
      { 93, "stacktimes", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 94, "storewithbyteoffset", 3, false, false, false, true /* this ignores replacements */, uninspired_storewithbyteoffset_meta_instruction_parameter_types },
      { 95, "storewithwordoffset", 3, false, false, false, true /* this ignores replacements */, uninspired_storewithwordoffset_meta_instruction_parameter_types },
      { 96, "sub", 3, false, false, false, true /* this ignores replacements */, uninspired_sub_meta_instruction_parameter_types },
      { 97, "subo", 4, true, false, false, true /* this ignores replacements */, uninspired_subo_meta_instruction_parameter_types },
      { 98, "tuck", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 99, "unreachable", 0, true, false, false, true /* this ignores replacements */, NULL },
      { 100, "whirl", 1, false, false, false, true /* this ignores replacements */, uninspired_whirl_meta_instruction_parameter_types },
      { 101, "whirlforth", 0, false, false, false, true /* this ignores replacements */, NULL }
    };

/* The register class descriptor for r registers. */
const struct jitter_register_class
uninspired_register_class_r
  = {
      uninspired_register_class_id_r,
      'r',
      "general_registers",
      "GENERAL_REGISTERS",
      UNINSPIRED_REGISTER_r_FAST_REGISTER_NO,
      1 /* Use slow registers */
    };

/* The register class descriptor for f registers. */
const struct jitter_register_class
uninspired_register_class_f
  = {
      uninspired_register_class_id_f,
      'f',
      "register_class_f",
      "REGISTER_CLASS_F",
      UNINSPIRED_REGISTER_f_FAST_REGISTER_NO,
      1 /* Use slow registers */
    };

/* The register class descriptor for v registers. */
const struct jitter_register_class
uninspired_register_class_v
  = {
      uninspired_register_class_id_v,
      'v',
      "register_class_v",
      "REGISTER_CLASS_V",
      UNINSPIRED_REGISTER_v_FAST_REGISTER_NO,
      1 /* Use slow registers */
    };

/* The register class descriptor for c registers. */
const struct jitter_register_class
uninspired_register_class_c
  = {
      uninspired_register_class_id_c,
      'c',
      "register_class_c",
      "REGISTER_CLASS_C",
      UNINSPIRED_REGISTER_c_FAST_REGISTER_NO,
      1 /* Use slow registers */
    };


/* A pointer to every existing register class descriptor. */
const struct jitter_register_class * const
uninspired_regiter_classes []
  = {
      & uninspired_register_class_r,
      & uninspired_register_class_f,
      & uninspired_register_class_v,
      & uninspired_register_class_c
    };

const struct jitter_register_class *
uninspired_register_class_character_to_register_class (char c)
{
  switch (c)
    {
    case 'r': return & uninspired_register_class_r;
    case 'f': return & uninspired_register_class_f;
    case 'v': return & uninspired_register_class_v;
    case 'c': return & uninspired_register_class_c;
    default:  return NULL;
    }
}

//#include "uninspired-specialized-instructions.h"

const char * const
uninspired_specialized_instruction_names [UNINSPIRED_SPECIALIZED_INSTRUCTION_NO]
  = {
      "!INVALID",
      "!BEGINBASICBLOCK",
      "!EXITVM",
      "!DATALOCATIONS",
      "!NOP",
      "!UNREACHABLE0",
      "!UNREACHABLE1",
      "!PRETENDTOJUMPANYWHERE",
      "add/%rR/%rR/%rR",
      "add/%rR/n1/%rR",
      "add/%rR/n-1/%rR",
      "add/%rR/nR/%rR",
      "add/n1/%rR/%rR",
      "add/n1/n1/%rR",
      "add/n1/n-1/%rR",
      "add/n1/nR/%rR",
      "add/n-1/%rR/%rR",
      "add/n-1/n1/%rR",
      "add/n-1/n-1/%rR",
      "add/n-1/nR/%rR",
      "add/nR/%rR/%rR",
      "add/nR/n1/%rR",
      "add/nR/n-1/%rR",
      "add/nR/nR/%rR",
      "addo/%rR/%rR/%rR/fR",
      "addo/%rR/n1/%rR/fR",
      "addo/%rR/n-1/%rR/fR",
      "addo/%rR/nR/%rR/fR",
      "addo/nR/%rR/%rR/fR",
      "addo/nR/n1/%rR/fR",
      "addo/nR/n-1/%rR/fR",
      "addo/nR/nR/%rR/fR",
      "b/fR",
      "band/%rR/%rR/fR",
      "band/%rR/n3/fR",
      "band/%rR/n7/fR",
      "band/%rR/nR/fR",
      "band/nR/%rR/fR",
      "band/nR/n3/fR",
      "band/nR/n7/fR",
      "band/nR/nR/fR",
      "beq/%rR/%rR/fR",
      "beq/%rR/nR/fR",
      "beq/nR/%rR/fR",
      "beq/nR/nR/fR",
      "bge/%rR/%rR/fR",
      "bge/%rR/n0/fR",
      "bge/%rR/n1/fR",
      "bge/%rR/nR/fR",
      "bge/n0/%rR/fR",
      "bge/n0/n0/fR",
      "bge/n0/n1/fR",
      "bge/n0/nR/fR",
      "bge/n1/%rR/fR",
      "bge/n1/n0/fR",
      "bge/n1/n1/fR",
      "bge/n1/nR/fR",
      "bge/nR/%rR/fR",
      "bge/nR/n0/fR",
      "bge/nR/n1/fR",
      "bge/nR/nR/fR",
      "bgeu/%rR/%rR/fR",
      "bgeu/%rR/n0/fR",
      "bgeu/%rR/n1/fR",
      "bgeu/%rR/nR/fR",
      "bgeu/n0/%rR/fR",
      "bgeu/n0/n0/fR",
      "bgeu/n0/n1/fR",
      "bgeu/n0/nR/fR",
      "bgeu/n1/%rR/fR",
      "bgeu/n1/n0/fR",
      "bgeu/n1/n1/fR",
      "bgeu/n1/nR/fR",
      "bgeu/nR/%rR/fR",
      "bgeu/nR/n0/fR",
      "bgeu/nR/n1/fR",
      "bgeu/nR/nR/fR",
      "bgt/%rR/%rR/fR",
      "bgt/%rR/n0/fR",
      "bgt/%rR/n1/fR",
      "bgt/%rR/nR/fR",
      "bgt/n0/%rR/fR",
      "bgt/n0/n0/fR",
      "bgt/n0/n1/fR",
      "bgt/n0/nR/fR",
      "bgt/n1/%rR/fR",
      "bgt/n1/n0/fR",
      "bgt/n1/n1/fR",
      "bgt/n1/nR/fR",
      "bgt/nR/%rR/fR",
      "bgt/nR/n0/fR",
      "bgt/nR/n1/fR",
      "bgt/nR/nR/fR",
      "bgtu/%rR/%rR/fR",
      "bgtu/%rR/n0/fR",
      "bgtu/%rR/n1/fR",
      "bgtu/%rR/nR/fR",
      "bgtu/n0/%rR/fR",
      "bgtu/n0/n0/fR",
      "bgtu/n0/n1/fR",
      "bgtu/n0/nR/fR",
      "bgtu/n1/%rR/fR",
      "bgtu/n1/n0/fR",
      "bgtu/n1/n1/fR",
      "bgtu/n1/nR/fR",
      "bgtu/nR/%rR/fR",
      "bgtu/nR/n0/fR",
      "bgtu/nR/n1/fR",
      "bgtu/nR/nR/fR",
      "ble/%rR/%rR/fR",
      "ble/%rR/n0/fR",
      "ble/%rR/n1/fR",
      "ble/%rR/nR/fR",
      "ble/n0/%rR/fR",
      "ble/n0/n0/fR",
      "ble/n0/n1/fR",
      "ble/n0/nR/fR",
      "ble/n1/%rR/fR",
      "ble/n1/n0/fR",
      "ble/n1/n1/fR",
      "ble/n1/nR/fR",
      "ble/nR/%rR/fR",
      "ble/nR/n0/fR",
      "ble/nR/n1/fR",
      "ble/nR/nR/fR",
      "bleu/%rR/%rR/fR",
      "bleu/%rR/n0/fR",
      "bleu/%rR/n1/fR",
      "bleu/%rR/nR/fR",
      "bleu/n0/%rR/fR",
      "bleu/n0/n0/fR",
      "bleu/n0/n1/fR",
      "bleu/n0/nR/fR",
      "bleu/n1/%rR/fR",
      "bleu/n1/n0/fR",
      "bleu/n1/n1/fR",
      "bleu/n1/nR/fR",
      "bleu/nR/%rR/fR",
      "bleu/nR/n0/fR",
      "bleu/nR/n1/fR",
      "bleu/nR/nR/fR",
      "blt/%rR/%rR/fR",
      "blt/%rR/n0/fR",
      "blt/%rR/n1/fR",
      "blt/%rR/nR/fR",
      "blt/n0/%rR/fR",
      "blt/n0/n0/fR",
      "blt/n0/n1/fR",
      "blt/n0/nR/fR",
      "blt/n1/%rR/fR",
      "blt/n1/n0/fR",
      "blt/n1/n1/fR",
      "blt/n1/nR/fR",
      "blt/nR/%rR/fR",
      "blt/nR/n0/fR",
      "blt/nR/n1/fR",
      "blt/nR/nR/fR",
      "bltu/%rR/%rR/fR",
      "bltu/%rR/n0/fR",
      "bltu/%rR/n1/fR",
      "bltu/%rR/nR/fR",
      "bltu/n0/%rR/fR",
      "bltu/n0/n0/fR",
      "bltu/n0/n1/fR",
      "bltu/n0/nR/fR",
      "bltu/n1/%rR/fR",
      "bltu/n1/n0/fR",
      "bltu/n1/n1/fR",
      "bltu/n1/nR/fR",
      "bltu/nR/%rR/fR",
      "bltu/nR/n0/fR",
      "bltu/nR/n1/fR",
      "bltu/nR/nR/fR",
      "bne/%rR/%rR/fR",
      "bne/%rR/n0/fR",
      "bne/%rR/nR/fR",
      "bne/n0/%rR/fR",
      "bne/n0/n0/fR",
      "bne/n0/nR/fR",
      "bne/nR/%rR/fR",
      "bne/nR/n0/fR",
      "bne/nR/nR/fR",
      "bneg/%rR/fR",
      "bneg/nR/fR",
      "bnneg/%rR/fR",
      "bnneg/nR/fR",
      "bnotand/%rR/%rR/fR",
      "bnotand/%rR/n3/fR",
      "bnotand/%rR/n7/fR",
      "bnotand/%rR/nR/fR",
      "bnotand/nR/%rR/fR",
      "bnotand/nR/n3/fR",
      "bnotand/nR/n7/fR",
      "bnotand/nR/nR/fR",
      "bnpos/%rR/fR",
      "bnpos/nR/fR",
      "bnz/%rR/fR",
      "bnz/nR/fR",
      "bpos/%rR/fR",
      "bpos/nR/fR",
      "br/%rR",
      "bulge/n0",
      "bulge/n1",
      "bulge/n2",
      "bulge/n3",
      "bulge/nR",
      "bulgeforth",
      "bz/%rR/fR",
      "bz/nR/fR",
      "clear-pending/retR",
      "div/%rR/%rR/%rR/retR",
      "div/%rR/n2/%rR/retR",
      "div/%rR/nR/%rR/retR",
      "div/nR/%rR/%rR/retR",
      "div/nR/n2/%rR/retR",
      "div/nR/nR/%rR/retR",
      "divo/%rR/%rR/%rR/fR",
      "divo/%rR/n2/%rR/fR",
      "divo/%rR/nR/%rR/fR",
      "divo/nR/%rR/%rR/fR",
      "divo/nR/n2/%rR/fR",
      "divo/nR/nR/%rR/fR",
      "drop-handler",
      "endvm",
      "exit/%rR/retR",
      "exit/nR/retR",
      "exitvm",
      "fadd/%fR/%fR/%fR",
      "fdiv/%fR/%fR/%fR",
      "fincr/%fR",
      "fmul/%fR/%fR/%fR",
      "fprint/%fR",
      "fset/%rR/%fR",
      "fset/nR/%fR",
      "fsub/%fR/%fR/%fR",
      "hcf/retR",
      "install-signal-handler/retR",
      "loadwithbyteoffset/%rR/%rR/%rR",
      "loadwithbyteoffset/%rR/n0/%rR",
      "loadwithbyteoffset/%rR/n8/%rR",
      "loadwithbyteoffset/%rR/nR/%rR",
      "loadwithwordoffset/%rR/%rR/%rR",
      "loadwithwordoffset/%rR/n0/%rR",
      "loadwithwordoffset/%rR/n1/%rR",
      "loadwithwordoffset/%rR/n2/%rR",
      "loadwithwordoffset/%rR/nR/%rR",
      "mallocwords/%rR/%rR/retR",
      "mallocwords/nR/%rR/retR",
      "mod/%rR/%rR/%rR/retR",
      "mod/%rR/n2/%rR/retR",
      "mod/%rR/nR/%rR/retR",
      "mod/nR/%rR/%rR/retR",
      "mod/nR/n2/%rR/retR",
      "mod/nR/nR/%rR/retR",
      "modo/%rR/%rR/%rR/fR",
      "modo/%rR/n2/%rR/fR",
      "modo/%rR/nR/%rR/fR",
      "modo/nR/%rR/%rR/fR",
      "modo/nR/n2/%rR/fR",
      "modo/nR/nR/%rR/fR",
      "mov/%rR/%rR",
      "mov/n0/%rR",
      "mov/n1/%rR",
      "mov/nR/%rR",
      "mov/lR/%rR",
      "mroll/n0",
      "mroll/n1",
      "mroll/n2",
      "mroll/n3",
      "mroll/n4",
      "mroll/n5",
      "mroll/n6",
      "mroll/n7",
      "mroll/n8",
      "mroll/n9",
      "mroll/n10",
      "mroll/n11",
      "mroll/n12",
      "mroll/n13",
      "mroll/n14",
      "mroll/n15",
      "mroll/n16",
      "mroll/n17",
      "mroll/n18",
      "mroll/n19",
      "mroll/n20",
      "mroll/n21",
      "mroll/n22",
      "mroll/n23",
      "mroll/n24",
      "mroll/n25",
      "mroll/n26",
      "mroll/n27",
      "mroll/n28",
      "mroll/n29",
      "mroll/n30",
      "mroll/n31",
      "mroll/n32",
      "mroll/n33",
      "mroll/n34",
      "mroll/n35",
      "mroll/n36",
      "mroll/n37",
      "mroll/n38",
      "mroll/n39",
      "mroll/n40",
      "mroll/n41",
      "mroll/n42",
      "mroll/n43",
      "mroll/n44",
      "mroll/n45",
      "mroll/n46",
      "mroll/n47",
      "mroll/n48",
      "mroll/n49",
      "mroll/n50",
      "mroll/n51",
      "mroll/n52",
      "mroll/n53",
      "mroll/n54",
      "mroll/n55",
      "mroll/n56",
      "mroll/n57",
      "mroll/n58",
      "mroll/n59",
      "mroll/n60",
      "mroll/n61",
      "mroll/n62",
      "mroll/n63",
      "mroll/n64",
      "mroll/n65",
      "mroll/n66",
      "mroll/n67",
      "mroll/n68",
      "mroll/n69",
      "mroll/n70",
      "mroll/nR",
      "mrollforth",
      "mrot",
      "mul/%rR/%rR/%rR",
      "mul/%rR/n2/%rR",
      "mul/%rR/nR/%rR",
      "mul/n2/%rR/%rR",
      "mul/n2/n2/%rR",
      "mul/n2/nR/%rR",
      "mul/nR/%rR/%rR",
      "mul/nR/n2/%rR",
      "mul/nR/nR/%rR",
      "mulo/%rR/%rR/%rR/fR",
      "mulo/%rR/n2/%rR/fR",
      "mulo/%rR/nR/%rR/fR",
      "mulo/nR/%rR/%rR/fR",
      "mulo/nR/n2/%rR/fR",
      "mulo/nR/nR/%rR/fR",
      "nop",
      "print-pending-signals/retR",
      "print-topmost/nR/retR",
      "printfixnum/%rR/retR",
      "printfixnum/nR/retR",
      "printufixnum/%rR/retR",
      "printufixnum/nR/retR",
      "procedurecall/fR/retR",
      "procedurecallr/%rR/retR",
      "procedurecallr/lR/retR",
      "procedureprolog",
      "procedurereturn",
      "push-depths/nR/retR",
      "push-handler/n0/lR",
      "push-handler/n1/lR",
      "push-handler/n2/lR",
      "push-handler/n3/lR",
      "push-handler/n4/lR",
      "push-handler/n5/lR",
      "push-handler/n6/lR",
      "push-handler/n7/lR",
      "push-handler/n8/lR",
      "push-handler/n9/lR",
      "push-handler/n10/lR",
      "push-handler/nR/lR",
      "push-increasing/nR/retR",
      "quake",
      "raise/%rR",
      "raise/n0",
      "raise/n1",
      "raise/n2",
      "raise/n3",
      "raise/n4",
      "raise/n5",
      "raise/n6",
      "raise/n7",
      "raise/n8",
      "raise/n9",
      "raise/n10",
      "raise/nR",
      "random/%rR/retR",
      "reverse/n0",
      "reverse/n1",
      "reverse/n2",
      "reverse/n3",
      "reverse/n4",
      "reverse/n5",
      "reverse/n6",
      "reverse/n7",
      "reverse/n8",
      "reverse/n9",
      "reverse/n10",
      "reverse/n11",
      "reverse/n12",
      "reverse/n13",
      "reverse/n14",
      "reverse/n15",
      "reverse/n16",
      "reverse/n17",
      "reverse/n18",
      "reverse/n19",
      "reverse/n20",
      "reverse/n21",
      "reverse/n22",
      "reverse/n23",
      "reverse/n24",
      "reverse/n25",
      "reverse/n26",
      "reverse/n27",
      "reverse/n28",
      "reverse/n29",
      "reverse/n30",
      "reverse/n31",
      "reverse/n32",
      "reverse/n33",
      "reverse/n34",
      "reverse/n35",
      "reverse/n36",
      "reverse/n37",
      "reverse/n38",
      "reverse/n39",
      "reverse/n40",
      "reverse/n41",
      "reverse/n42",
      "reverse/n43",
      "reverse/n44",
      "reverse/n45",
      "reverse/n46",
      "reverse/n47",
      "reverse/n48",
      "reverse/n49",
      "reverse/n50",
      "reverse/n51",
      "reverse/n52",
      "reverse/n53",
      "reverse/n54",
      "reverse/n55",
      "reverse/n56",
      "reverse/n57",
      "reverse/n58",
      "reverse/n59",
      "reverse/n60",
      "reverse/n61",
      "reverse/n62",
      "reverse/n63",
      "reverse/n64",
      "reverse/n65",
      "reverse/n66",
      "reverse/n67",
      "reverse/n68",
      "reverse/n69",
      "reverse/n70",
      "reverse/nR",
      "roll/n0",
      "roll/n1",
      "roll/n2",
      "roll/n3",
      "roll/n4",
      "roll/n5",
      "roll/n6",
      "roll/n7",
      "roll/n8",
      "roll/n9",
      "roll/n10",
      "roll/n11",
      "roll/n12",
      "roll/n13",
      "roll/n14",
      "roll/n15",
      "roll/n16",
      "roll/n17",
      "roll/n18",
      "roll/n19",
      "roll/n20",
      "roll/n21",
      "roll/n22",
      "roll/n23",
      "roll/n24",
      "roll/n25",
      "roll/n26",
      "roll/n27",
      "roll/n28",
      "roll/n29",
      "roll/n30",
      "roll/n31",
      "roll/n32",
      "roll/n33",
      "roll/n34",
      "roll/n35",
      "roll/n36",
      "roll/n37",
      "roll/n38",
      "roll/n39",
      "roll/n40",
      "roll/n41",
      "roll/n42",
      "roll/n43",
      "roll/n44",
      "roll/n45",
      "roll/n46",
      "roll/n47",
      "roll/n48",
      "roll/n49",
      "roll/n50",
      "roll/n51",
      "roll/n52",
      "roll/n53",
      "roll/n54",
      "roll/n55",
      "roll/n56",
      "roll/n57",
      "roll/n58",
      "roll/n59",
      "roll/n60",
      "roll/n61",
      "roll/n62",
      "roll/n63",
      "roll/n64",
      "roll/n65",
      "roll/n66",
      "roll/n67",
      "roll/n68",
      "roll/n69",
      "roll/n70",
      "roll/nR",
      "rollforth",
      "rot",
      "safe-point/fR",
      "set-pending",
      "slide/n1/n1",
      "slide/n1/n2",
      "slide/n1/n3",
      "slide/n1/n4",
      "slide/n1/n5",
      "slide/n1/nR",
      "slide/n2/n1",
      "slide/n2/n2",
      "slide/n2/n3",
      "slide/n2/n4",
      "slide/n2/n5",
      "slide/n2/nR",
      "slide/n3/n1",
      "slide/n3/n2",
      "slide/n3/n3",
      "slide/n3/n4",
      "slide/n3/n5",
      "slide/n3/nR",
      "slide/nR/n1",
      "slide/nR/n2",
      "slide/nR/n3",
      "slide/nR/n4",
      "slide/nR/n5",
      "slide/nR/nR",
      "slideforth",
      "stackdrop",
      "stackdup",
      "stackif/fR",
      "stacknip",
      "stacknondroppingif/fR",
      "stacknot",
      "stackoneminus",
      "stackoneplus",
      "stackover",
      "stackpeek/%rR",
      "stackplus",
      "stackplusr/%rR",
      "stackpop/%rR",
      "stackprint/retR",
      "stackpush/%rR",
      "stackpush/n0",
      "stackpush/n1",
      "stackpush/nR",
      "stackpush/lR",
      "stackpushunspecified",
      "stackset/%rR",
      "stackset/n0",
      "stackset/n1",
      "stackset/nR",
      "stackset/lR",
      "stackswap",
      "stackswaptop/%rR",
      "stacktimes",
      "storewithbyteoffset/%rR/%rR/%rR",
      "storewithbyteoffset/%rR/%rR/n0",
      "storewithbyteoffset/%rR/%rR/n8",
      "storewithbyteoffset/%rR/%rR/nR",
      "storewithbyteoffset/nR/%rR/%rR",
      "storewithbyteoffset/nR/%rR/n0",
      "storewithbyteoffset/nR/%rR/n8",
      "storewithbyteoffset/nR/%rR/nR",
      "storewithwordoffset/%rR/%rR/%rR",
      "storewithwordoffset/%rR/%rR/n0",
      "storewithwordoffset/%rR/%rR/n1",
      "storewithwordoffset/%rR/%rR/n2",
      "storewithwordoffset/%rR/%rR/nR",
      "storewithwordoffset/nR/%rR/%rR",
      "storewithwordoffset/nR/%rR/n0",
      "storewithwordoffset/nR/%rR/n1",
      "storewithwordoffset/nR/%rR/n2",
      "storewithwordoffset/nR/%rR/nR",
      "sub/%rR/%rR/%rR",
      "sub/%rR/n1/%rR",
      "sub/%rR/nR/%rR",
      "sub/n0/%rR/%rR",
      "sub/n0/n1/%rR",
      "sub/n0/nR/%rR",
      "sub/nR/%rR/%rR",
      "sub/nR/n1/%rR",
      "sub/nR/nR/%rR",
      "subo/%rR/%rR/%rR/fR",
      "subo/%rR/n1/%rR/fR",
      "subo/%rR/nR/%rR/fR",
      "subo/nR/%rR/%rR/fR",
      "subo/nR/n1/%rR/fR",
      "subo/nR/nR/%rR/fR",
      "tuck",
      "unreachable",
      "whirl/n0",
      "whirl/n1",
      "whirl/n2",
      "whirl/n3",
      "whirl/nR",
      "whirlforth",
      "!REPLACEMENT-addo/%rR/%rR/%rR/fR/retR",
      "!REPLACEMENT-addo/%rR/n1/%rR/fR/retR",
      "!REPLACEMENT-addo/%rR/n-1/%rR/fR/retR",
      "!REPLACEMENT-addo/%rR/nR/%rR/fR/retR",
      "!REPLACEMENT-addo/nR/%rR/%rR/fR/retR",
      "!REPLACEMENT-addo/nR/n1/%rR/fR/retR",
      "!REPLACEMENT-addo/nR/n-1/%rR/fR/retR",
      "!REPLACEMENT-addo/nR/nR/%rR/fR/retR",
      "!REPLACEMENT-b/fR/retR",
      "!REPLACEMENT-band/%rR/%rR/fR/retR",
      "!REPLACEMENT-band/%rR/n3/fR/retR",
      "!REPLACEMENT-band/%rR/n7/fR/retR",
      "!REPLACEMENT-band/%rR/nR/fR/retR",
      "!REPLACEMENT-band/nR/%rR/fR/retR",
      "!REPLACEMENT-band/nR/n3/fR/retR",
      "!REPLACEMENT-band/nR/n7/fR/retR",
      "!REPLACEMENT-band/nR/nR/fR/retR",
      "!REPLACEMENT-beq/%rR/%rR/fR/retR",
      "!REPLACEMENT-beq/%rR/nR/fR/retR",
      "!REPLACEMENT-beq/nR/%rR/fR/retR",
      "!REPLACEMENT-beq/nR/nR/fR/retR",
      "!REPLACEMENT-bge/%rR/%rR/fR/retR",
      "!REPLACEMENT-bge/%rR/n0/fR/retR",
      "!REPLACEMENT-bge/%rR/n1/fR/retR",
      "!REPLACEMENT-bge/%rR/nR/fR/retR",
      "!REPLACEMENT-bge/n0/%rR/fR/retR",
      "!REPLACEMENT-bge/n0/n0/fR/retR",
      "!REPLACEMENT-bge/n0/n1/fR/retR",
      "!REPLACEMENT-bge/n0/nR/fR/retR",
      "!REPLACEMENT-bge/n1/%rR/fR/retR",
      "!REPLACEMENT-bge/n1/n0/fR/retR",
      "!REPLACEMENT-bge/n1/n1/fR/retR",
      "!REPLACEMENT-bge/n1/nR/fR/retR",
      "!REPLACEMENT-bge/nR/%rR/fR/retR",
      "!REPLACEMENT-bge/nR/n0/fR/retR",
      "!REPLACEMENT-bge/nR/n1/fR/retR",
      "!REPLACEMENT-bge/nR/nR/fR/retR",
      "!REPLACEMENT-bgeu/%rR/%rR/fR/retR",
      "!REPLACEMENT-bgeu/%rR/n0/fR/retR",
      "!REPLACEMENT-bgeu/%rR/n1/fR/retR",
      "!REPLACEMENT-bgeu/%rR/nR/fR/retR",
      "!REPLACEMENT-bgeu/n0/%rR/fR/retR",
      "!REPLACEMENT-bgeu/n0/n0/fR/retR",
      "!REPLACEMENT-bgeu/n0/n1/fR/retR",
      "!REPLACEMENT-bgeu/n0/nR/fR/retR",
      "!REPLACEMENT-bgeu/n1/%rR/fR/retR",
      "!REPLACEMENT-bgeu/n1/n0/fR/retR",
      "!REPLACEMENT-bgeu/n1/n1/fR/retR",
      "!REPLACEMENT-bgeu/n1/nR/fR/retR",
      "!REPLACEMENT-bgeu/nR/%rR/fR/retR",
      "!REPLACEMENT-bgeu/nR/n0/fR/retR",
      "!REPLACEMENT-bgeu/nR/n1/fR/retR",
      "!REPLACEMENT-bgeu/nR/nR/fR/retR",
      "!REPLACEMENT-bgt/%rR/%rR/fR/retR",
      "!REPLACEMENT-bgt/%rR/n0/fR/retR",
      "!REPLACEMENT-bgt/%rR/n1/fR/retR",
      "!REPLACEMENT-bgt/%rR/nR/fR/retR",
      "!REPLACEMENT-bgt/n0/%rR/fR/retR",
      "!REPLACEMENT-bgt/n0/n0/fR/retR",
      "!REPLACEMENT-bgt/n0/n1/fR/retR",
      "!REPLACEMENT-bgt/n0/nR/fR/retR",
      "!REPLACEMENT-bgt/n1/%rR/fR/retR",
      "!REPLACEMENT-bgt/n1/n0/fR/retR",
      "!REPLACEMENT-bgt/n1/n1/fR/retR",
      "!REPLACEMENT-bgt/n1/nR/fR/retR",
      "!REPLACEMENT-bgt/nR/%rR/fR/retR",
      "!REPLACEMENT-bgt/nR/n0/fR/retR",
      "!REPLACEMENT-bgt/nR/n1/fR/retR",
      "!REPLACEMENT-bgt/nR/nR/fR/retR",
      "!REPLACEMENT-bgtu/%rR/%rR/fR/retR",
      "!REPLACEMENT-bgtu/%rR/n0/fR/retR",
      "!REPLACEMENT-bgtu/%rR/n1/fR/retR",
      "!REPLACEMENT-bgtu/%rR/nR/fR/retR",
      "!REPLACEMENT-bgtu/n0/%rR/fR/retR",
      "!REPLACEMENT-bgtu/n0/n0/fR/retR",
      "!REPLACEMENT-bgtu/n0/n1/fR/retR",
      "!REPLACEMENT-bgtu/n0/nR/fR/retR",
      "!REPLACEMENT-bgtu/n1/%rR/fR/retR",
      "!REPLACEMENT-bgtu/n1/n0/fR/retR",
      "!REPLACEMENT-bgtu/n1/n1/fR/retR",
      "!REPLACEMENT-bgtu/n1/nR/fR/retR",
      "!REPLACEMENT-bgtu/nR/%rR/fR/retR",
      "!REPLACEMENT-bgtu/nR/n0/fR/retR",
      "!REPLACEMENT-bgtu/nR/n1/fR/retR",
      "!REPLACEMENT-bgtu/nR/nR/fR/retR",
      "!REPLACEMENT-ble/%rR/%rR/fR/retR",
      "!REPLACEMENT-ble/%rR/n0/fR/retR",
      "!REPLACEMENT-ble/%rR/n1/fR/retR",
      "!REPLACEMENT-ble/%rR/nR/fR/retR",
      "!REPLACEMENT-ble/n0/%rR/fR/retR",
      "!REPLACEMENT-ble/n0/n0/fR/retR",
      "!REPLACEMENT-ble/n0/n1/fR/retR",
      "!REPLACEMENT-ble/n0/nR/fR/retR",
      "!REPLACEMENT-ble/n1/%rR/fR/retR",
      "!REPLACEMENT-ble/n1/n0/fR/retR",
      "!REPLACEMENT-ble/n1/n1/fR/retR",
      "!REPLACEMENT-ble/n1/nR/fR/retR",
      "!REPLACEMENT-ble/nR/%rR/fR/retR",
      "!REPLACEMENT-ble/nR/n0/fR/retR",
      "!REPLACEMENT-ble/nR/n1/fR/retR",
      "!REPLACEMENT-ble/nR/nR/fR/retR",
      "!REPLACEMENT-bleu/%rR/%rR/fR/retR",
      "!REPLACEMENT-bleu/%rR/n0/fR/retR",
      "!REPLACEMENT-bleu/%rR/n1/fR/retR",
      "!REPLACEMENT-bleu/%rR/nR/fR/retR",
      "!REPLACEMENT-bleu/n0/%rR/fR/retR",
      "!REPLACEMENT-bleu/n0/n0/fR/retR",
      "!REPLACEMENT-bleu/n0/n1/fR/retR",
      "!REPLACEMENT-bleu/n0/nR/fR/retR",
      "!REPLACEMENT-bleu/n1/%rR/fR/retR",
      "!REPLACEMENT-bleu/n1/n0/fR/retR",
      "!REPLACEMENT-bleu/n1/n1/fR/retR",
      "!REPLACEMENT-bleu/n1/nR/fR/retR",
      "!REPLACEMENT-bleu/nR/%rR/fR/retR",
      "!REPLACEMENT-bleu/nR/n0/fR/retR",
      "!REPLACEMENT-bleu/nR/n1/fR/retR",
      "!REPLACEMENT-bleu/nR/nR/fR/retR",
      "!REPLACEMENT-blt/%rR/%rR/fR/retR",
      "!REPLACEMENT-blt/%rR/n0/fR/retR",
      "!REPLACEMENT-blt/%rR/n1/fR/retR",
      "!REPLACEMENT-blt/%rR/nR/fR/retR",
      "!REPLACEMENT-blt/n0/%rR/fR/retR",
      "!REPLACEMENT-blt/n0/n0/fR/retR",
      "!REPLACEMENT-blt/n0/n1/fR/retR",
      "!REPLACEMENT-blt/n0/nR/fR/retR",
      "!REPLACEMENT-blt/n1/%rR/fR/retR",
      "!REPLACEMENT-blt/n1/n0/fR/retR",
      "!REPLACEMENT-blt/n1/n1/fR/retR",
      "!REPLACEMENT-blt/n1/nR/fR/retR",
      "!REPLACEMENT-blt/nR/%rR/fR/retR",
      "!REPLACEMENT-blt/nR/n0/fR/retR",
      "!REPLACEMENT-blt/nR/n1/fR/retR",
      "!REPLACEMENT-blt/nR/nR/fR/retR",
      "!REPLACEMENT-bltu/%rR/%rR/fR/retR",
      "!REPLACEMENT-bltu/%rR/n0/fR/retR",
      "!REPLACEMENT-bltu/%rR/n1/fR/retR",
      "!REPLACEMENT-bltu/%rR/nR/fR/retR",
      "!REPLACEMENT-bltu/n0/%rR/fR/retR",
      "!REPLACEMENT-bltu/n0/n0/fR/retR",
      "!REPLACEMENT-bltu/n0/n1/fR/retR",
      "!REPLACEMENT-bltu/n0/nR/fR/retR",
      "!REPLACEMENT-bltu/n1/%rR/fR/retR",
      "!REPLACEMENT-bltu/n1/n0/fR/retR",
      "!REPLACEMENT-bltu/n1/n1/fR/retR",
      "!REPLACEMENT-bltu/n1/nR/fR/retR",
      "!REPLACEMENT-bltu/nR/%rR/fR/retR",
      "!REPLACEMENT-bltu/nR/n0/fR/retR",
      "!REPLACEMENT-bltu/nR/n1/fR/retR",
      "!REPLACEMENT-bltu/nR/nR/fR/retR",
      "!REPLACEMENT-bne/%rR/%rR/fR/retR",
      "!REPLACEMENT-bne/%rR/n0/fR/retR",
      "!REPLACEMENT-bne/%rR/nR/fR/retR",
      "!REPLACEMENT-bne/n0/%rR/fR/retR",
      "!REPLACEMENT-bne/n0/n0/fR/retR",
      "!REPLACEMENT-bne/n0/nR/fR/retR",
      "!REPLACEMENT-bne/nR/%rR/fR/retR",
      "!REPLACEMENT-bne/nR/n0/fR/retR",
      "!REPLACEMENT-bne/nR/nR/fR/retR",
      "!REPLACEMENT-bneg/%rR/fR/retR",
      "!REPLACEMENT-bneg/nR/fR/retR",
      "!REPLACEMENT-bnneg/%rR/fR/retR",
      "!REPLACEMENT-bnneg/nR/fR/retR",
      "!REPLACEMENT-bnotand/%rR/%rR/fR/retR",
      "!REPLACEMENT-bnotand/%rR/n3/fR/retR",
      "!REPLACEMENT-bnotand/%rR/n7/fR/retR",
      "!REPLACEMENT-bnotand/%rR/nR/fR/retR",
      "!REPLACEMENT-bnotand/nR/%rR/fR/retR",
      "!REPLACEMENT-bnotand/nR/n3/fR/retR",
      "!REPLACEMENT-bnotand/nR/n7/fR/retR",
      "!REPLACEMENT-bnotand/nR/nR/fR/retR",
      "!REPLACEMENT-bnpos/%rR/fR/retR",
      "!REPLACEMENT-bnpos/nR/fR/retR",
      "!REPLACEMENT-bnz/%rR/fR/retR",
      "!REPLACEMENT-bnz/nR/fR/retR",
      "!REPLACEMENT-bpos/%rR/fR/retR",
      "!REPLACEMENT-bpos/nR/fR/retR",
      "!REPLACEMENT-br/%rR/retR",
      "!REPLACEMENT-bz/%rR/fR/retR",
      "!REPLACEMENT-bz/nR/fR/retR",
      "!REPLACEMENT-divo/%rR/%rR/%rR/fR/retR",
      "!REPLACEMENT-divo/%rR/n2/%rR/fR/retR",
      "!REPLACEMENT-divo/%rR/nR/%rR/fR/retR",
      "!REPLACEMENT-divo/nR/%rR/%rR/fR/retR",
      "!REPLACEMENT-divo/nR/n2/%rR/fR/retR",
      "!REPLACEMENT-divo/nR/nR/%rR/fR/retR",
      "!REPLACEMENT-endvm/retR",
      "!REPLACEMENT-exitvm/retR",
      "!REPLACEMENT-modo/%rR/%rR/%rR/fR/retR",
      "!REPLACEMENT-modo/%rR/n2/%rR/fR/retR",
      "!REPLACEMENT-modo/%rR/nR/%rR/fR/retR",
      "!REPLACEMENT-modo/nR/%rR/%rR/fR/retR",
      "!REPLACEMENT-modo/nR/n2/%rR/fR/retR",
      "!REPLACEMENT-modo/nR/nR/%rR/fR/retR",
      "!REPLACEMENT-mulo/%rR/%rR/%rR/fR/retR",
      "!REPLACEMENT-mulo/%rR/n2/%rR/fR/retR",
      "!REPLACEMENT-mulo/%rR/nR/%rR/fR/retR",
      "!REPLACEMENT-mulo/nR/%rR/%rR/fR/retR",
      "!REPLACEMENT-mulo/nR/n2/%rR/fR/retR",
      "!REPLACEMENT-mulo/nR/nR/%rR/fR/retR",
      "!REPLACEMENT-procedurecall/fR/retR",
      "!REPLACEMENT-procedurecallr/%rR/retR",
      "!REPLACEMENT-procedurecallr/lR/retR",
      "!REPLACEMENT-procedureprolog/retR",
      "!REPLACEMENT-procedurereturn/retR",
      "!REPLACEMENT-raise/%rR/retR",
      "!REPLACEMENT-raise/n0/retR",
      "!REPLACEMENT-raise/n1/retR",
      "!REPLACEMENT-raise/n2/retR",
      "!REPLACEMENT-raise/n3/retR",
      "!REPLACEMENT-raise/n4/retR",
      "!REPLACEMENT-raise/n5/retR",
      "!REPLACEMENT-raise/n6/retR",
      "!REPLACEMENT-raise/n7/retR",
      "!REPLACEMENT-raise/n8/retR",
      "!REPLACEMENT-raise/n9/retR",
      "!REPLACEMENT-raise/n10/retR",
      "!REPLACEMENT-raise/nR/retR",
      "!REPLACEMENT-safe-point/fR/retR",
      "!REPLACEMENT-stackif/fR/retR",
      "!REPLACEMENT-stacknondroppingif/fR/retR",
      "!REPLACEMENT-subo/%rR/%rR/%rR/fR/retR",
      "!REPLACEMENT-subo/%rR/n1/%rR/fR/retR",
      "!REPLACEMENT-subo/%rR/nR/%rR/fR/retR",
      "!REPLACEMENT-subo/nR/%rR/%rR/fR/retR",
      "!REPLACEMENT-subo/nR/n1/%rR/fR/retR",
      "!REPLACEMENT-subo/nR/nR/%rR/fR/retR",
      "!REPLACEMENT-unreachable/retR"
    };
// #include <stdlib.h>

// #include "uninspired-specialized-instructions.h"
const size_t
uninspired_specialized_instruction_residual_arities [UNINSPIRED_SPECIALIZED_INSTRUCTION_NO]
  = {
      0, /* !INVALID */
      1, /* !BEGINBASICBLOCK */
      0, /* !EXITVM */
      0, /* !DATALOCATIONS */
      0, /* !NOP */
      0, /* !UNREACHABLE0 */
      0, /* !UNREACHABLE1 */
      0, /* !PRETENDTOJUMPANYWHERE */
      3, /* add/%rR/%rR/%rR */
      2, /* add/%rR/n1/%rR */
      2, /* add/%rR/n-1/%rR */
      3, /* add/%rR/nR/%rR */
      2, /* add/n1/%rR/%rR */
      1, /* add/n1/n1/%rR */
      1, /* add/n1/n-1/%rR */
      2, /* add/n1/nR/%rR */
      2, /* add/n-1/%rR/%rR */
      1, /* add/n-1/n1/%rR */
      1, /* add/n-1/n-1/%rR */
      2, /* add/n-1/nR/%rR */
      3, /* add/nR/%rR/%rR */
      2, /* add/nR/n1/%rR */
      2, /* add/nR/n-1/%rR */
      3, /* add/nR/nR/%rR */
      4, /* addo/%rR/%rR/%rR/fR */
      3, /* addo/%rR/n1/%rR/fR */
      3, /* addo/%rR/n-1/%rR/fR */
      4, /* addo/%rR/nR/%rR/fR */
      4, /* addo/nR/%rR/%rR/fR */
      3, /* addo/nR/n1/%rR/fR */
      3, /* addo/nR/n-1/%rR/fR */
      4, /* addo/nR/nR/%rR/fR */
      1, /* b/fR */
      3, /* band/%rR/%rR/fR */
      2, /* band/%rR/n3/fR */
      2, /* band/%rR/n7/fR */
      3, /* band/%rR/nR/fR */
      3, /* band/nR/%rR/fR */
      2, /* band/nR/n3/fR */
      2, /* band/nR/n7/fR */
      3, /* band/nR/nR/fR */
      3, /* beq/%rR/%rR/fR */
      3, /* beq/%rR/nR/fR */
      3, /* beq/nR/%rR/fR */
      3, /* beq/nR/nR/fR */
      3, /* bge/%rR/%rR/fR */
      2, /* bge/%rR/n0/fR */
      2, /* bge/%rR/n1/fR */
      3, /* bge/%rR/nR/fR */
      2, /* bge/n0/%rR/fR */
      1, /* bge/n0/n0/fR */
      1, /* bge/n0/n1/fR */
      2, /* bge/n0/nR/fR */
      2, /* bge/n1/%rR/fR */
      1, /* bge/n1/n0/fR */
      1, /* bge/n1/n1/fR */
      2, /* bge/n1/nR/fR */
      3, /* bge/nR/%rR/fR */
      2, /* bge/nR/n0/fR */
      2, /* bge/nR/n1/fR */
      3, /* bge/nR/nR/fR */
      3, /* bgeu/%rR/%rR/fR */
      2, /* bgeu/%rR/n0/fR */
      2, /* bgeu/%rR/n1/fR */
      3, /* bgeu/%rR/nR/fR */
      2, /* bgeu/n0/%rR/fR */
      1, /* bgeu/n0/n0/fR */
      1, /* bgeu/n0/n1/fR */
      2, /* bgeu/n0/nR/fR */
      2, /* bgeu/n1/%rR/fR */
      1, /* bgeu/n1/n0/fR */
      1, /* bgeu/n1/n1/fR */
      2, /* bgeu/n1/nR/fR */
      3, /* bgeu/nR/%rR/fR */
      2, /* bgeu/nR/n0/fR */
      2, /* bgeu/nR/n1/fR */
      3, /* bgeu/nR/nR/fR */
      3, /* bgt/%rR/%rR/fR */
      2, /* bgt/%rR/n0/fR */
      2, /* bgt/%rR/n1/fR */
      3, /* bgt/%rR/nR/fR */
      2, /* bgt/n0/%rR/fR */
      1, /* bgt/n0/n0/fR */
      1, /* bgt/n0/n1/fR */
      2, /* bgt/n0/nR/fR */
      2, /* bgt/n1/%rR/fR */
      1, /* bgt/n1/n0/fR */
      1, /* bgt/n1/n1/fR */
      2, /* bgt/n1/nR/fR */
      3, /* bgt/nR/%rR/fR */
      2, /* bgt/nR/n0/fR */
      2, /* bgt/nR/n1/fR */
      3, /* bgt/nR/nR/fR */
      3, /* bgtu/%rR/%rR/fR */
      2, /* bgtu/%rR/n0/fR */
      2, /* bgtu/%rR/n1/fR */
      3, /* bgtu/%rR/nR/fR */
      2, /* bgtu/n0/%rR/fR */
      1, /* bgtu/n0/n0/fR */
      1, /* bgtu/n0/n1/fR */
      2, /* bgtu/n0/nR/fR */
      2, /* bgtu/n1/%rR/fR */
      1, /* bgtu/n1/n0/fR */
      1, /* bgtu/n1/n1/fR */
      2, /* bgtu/n1/nR/fR */
      3, /* bgtu/nR/%rR/fR */
      2, /* bgtu/nR/n0/fR */
      2, /* bgtu/nR/n1/fR */
      3, /* bgtu/nR/nR/fR */
      3, /* ble/%rR/%rR/fR */
      2, /* ble/%rR/n0/fR */
      2, /* ble/%rR/n1/fR */
      3, /* ble/%rR/nR/fR */
      2, /* ble/n0/%rR/fR */
      1, /* ble/n0/n0/fR */
      1, /* ble/n0/n1/fR */
      2, /* ble/n0/nR/fR */
      2, /* ble/n1/%rR/fR */
      1, /* ble/n1/n0/fR */
      1, /* ble/n1/n1/fR */
      2, /* ble/n1/nR/fR */
      3, /* ble/nR/%rR/fR */
      2, /* ble/nR/n0/fR */
      2, /* ble/nR/n1/fR */
      3, /* ble/nR/nR/fR */
      3, /* bleu/%rR/%rR/fR */
      2, /* bleu/%rR/n0/fR */
      2, /* bleu/%rR/n1/fR */
      3, /* bleu/%rR/nR/fR */
      2, /* bleu/n0/%rR/fR */
      1, /* bleu/n0/n0/fR */
      1, /* bleu/n0/n1/fR */
      2, /* bleu/n0/nR/fR */
      2, /* bleu/n1/%rR/fR */
      1, /* bleu/n1/n0/fR */
      1, /* bleu/n1/n1/fR */
      2, /* bleu/n1/nR/fR */
      3, /* bleu/nR/%rR/fR */
      2, /* bleu/nR/n0/fR */
      2, /* bleu/nR/n1/fR */
      3, /* bleu/nR/nR/fR */
      3, /* blt/%rR/%rR/fR */
      2, /* blt/%rR/n0/fR */
      2, /* blt/%rR/n1/fR */
      3, /* blt/%rR/nR/fR */
      2, /* blt/n0/%rR/fR */
      1, /* blt/n0/n0/fR */
      1, /* blt/n0/n1/fR */
      2, /* blt/n0/nR/fR */
      2, /* blt/n1/%rR/fR */
      1, /* blt/n1/n0/fR */
      1, /* blt/n1/n1/fR */
      2, /* blt/n1/nR/fR */
      3, /* blt/nR/%rR/fR */
      2, /* blt/nR/n0/fR */
      2, /* blt/nR/n1/fR */
      3, /* blt/nR/nR/fR */
      3, /* bltu/%rR/%rR/fR */
      2, /* bltu/%rR/n0/fR */
      2, /* bltu/%rR/n1/fR */
      3, /* bltu/%rR/nR/fR */
      2, /* bltu/n0/%rR/fR */
      1, /* bltu/n0/n0/fR */
      1, /* bltu/n0/n1/fR */
      2, /* bltu/n0/nR/fR */
      2, /* bltu/n1/%rR/fR */
      1, /* bltu/n1/n0/fR */
      1, /* bltu/n1/n1/fR */
      2, /* bltu/n1/nR/fR */
      3, /* bltu/nR/%rR/fR */
      2, /* bltu/nR/n0/fR */
      2, /* bltu/nR/n1/fR */
      3, /* bltu/nR/nR/fR */
      3, /* bne/%rR/%rR/fR */
      2, /* bne/%rR/n0/fR */
      3, /* bne/%rR/nR/fR */
      2, /* bne/n0/%rR/fR */
      1, /* bne/n0/n0/fR */
      2, /* bne/n0/nR/fR */
      3, /* bne/nR/%rR/fR */
      2, /* bne/nR/n0/fR */
      3, /* bne/nR/nR/fR */
      2, /* bneg/%rR/fR */
      2, /* bneg/nR/fR */
      2, /* bnneg/%rR/fR */
      2, /* bnneg/nR/fR */
      3, /* bnotand/%rR/%rR/fR */
      2, /* bnotand/%rR/n3/fR */
      2, /* bnotand/%rR/n7/fR */
      3, /* bnotand/%rR/nR/fR */
      3, /* bnotand/nR/%rR/fR */
      2, /* bnotand/nR/n3/fR */
      2, /* bnotand/nR/n7/fR */
      3, /* bnotand/nR/nR/fR */
      2, /* bnpos/%rR/fR */
      2, /* bnpos/nR/fR */
      2, /* bnz/%rR/fR */
      2, /* bnz/nR/fR */
      2, /* bpos/%rR/fR */
      2, /* bpos/nR/fR */
      1, /* br/%rR */
      0, /* bulge/n0 */
      0, /* bulge/n1 */
      0, /* bulge/n2 */
      0, /* bulge/n3 */
      1, /* bulge/nR */
      0, /* bulgeforth */
      2, /* bz/%rR/fR */
      2, /* bz/nR/fR */
      1, /* clear-pending/retR */
      4, /* div/%rR/%rR/%rR/retR */
      3, /* div/%rR/n2/%rR/retR */
      4, /* div/%rR/nR/%rR/retR */
      4, /* div/nR/%rR/%rR/retR */
      3, /* div/nR/n2/%rR/retR */
      4, /* div/nR/nR/%rR/retR */
      4, /* divo/%rR/%rR/%rR/fR */
      3, /* divo/%rR/n2/%rR/fR */
      4, /* divo/%rR/nR/%rR/fR */
      4, /* divo/nR/%rR/%rR/fR */
      3, /* divo/nR/n2/%rR/fR */
      4, /* divo/nR/nR/%rR/fR */
      0, /* drop-handler */
      0, /* endvm */
      2, /* exit/%rR/retR */
      2, /* exit/nR/retR */
      0, /* exitvm */
      3, /* fadd/%fR/%fR/%fR */
      3, /* fdiv/%fR/%fR/%fR */
      1, /* fincr/%fR */
      3, /* fmul/%fR/%fR/%fR */
      1, /* fprint/%fR */
      2, /* fset/%rR/%fR */
      2, /* fset/nR/%fR */
      3, /* fsub/%fR/%fR/%fR */
      1, /* hcf/retR */
      1, /* install-signal-handler/retR */
      3, /* loadwithbyteoffset/%rR/%rR/%rR */
      2, /* loadwithbyteoffset/%rR/n0/%rR */
      2, /* loadwithbyteoffset/%rR/n8/%rR */
      3, /* loadwithbyteoffset/%rR/nR/%rR */
      3, /* loadwithwordoffset/%rR/%rR/%rR */
      2, /* loadwithwordoffset/%rR/n0/%rR */
      2, /* loadwithwordoffset/%rR/n1/%rR */
      2, /* loadwithwordoffset/%rR/n2/%rR */
      3, /* loadwithwordoffset/%rR/nR/%rR */
      3, /* mallocwords/%rR/%rR/retR */
      3, /* mallocwords/nR/%rR/retR */
      4, /* mod/%rR/%rR/%rR/retR */
      3, /* mod/%rR/n2/%rR/retR */
      4, /* mod/%rR/nR/%rR/retR */
      4, /* mod/nR/%rR/%rR/retR */
      3, /* mod/nR/n2/%rR/retR */
      4, /* mod/nR/nR/%rR/retR */
      4, /* modo/%rR/%rR/%rR/fR */
      3, /* modo/%rR/n2/%rR/fR */
      4, /* modo/%rR/nR/%rR/fR */
      4, /* modo/nR/%rR/%rR/fR */
      3, /* modo/nR/n2/%rR/fR */
      4, /* modo/nR/nR/%rR/fR */
      2, /* mov/%rR/%rR */
      1, /* mov/n0/%rR */
      1, /* mov/n1/%rR */
      2, /* mov/nR/%rR */
      2, /* mov/lR/%rR */
      0, /* mroll/n0 */
      0, /* mroll/n1 */
      0, /* mroll/n2 */
      0, /* mroll/n3 */
      0, /* mroll/n4 */
      0, /* mroll/n5 */
      0, /* mroll/n6 */
      0, /* mroll/n7 */
      0, /* mroll/n8 */
      0, /* mroll/n9 */
      0, /* mroll/n10 */
      0, /* mroll/n11 */
      0, /* mroll/n12 */
      0, /* mroll/n13 */
      0, /* mroll/n14 */
      0, /* mroll/n15 */
      0, /* mroll/n16 */
      0, /* mroll/n17 */
      0, /* mroll/n18 */
      0, /* mroll/n19 */
      0, /* mroll/n20 */
      0, /* mroll/n21 */
      0, /* mroll/n22 */
      0, /* mroll/n23 */
      0, /* mroll/n24 */
      0, /* mroll/n25 */
      0, /* mroll/n26 */
      0, /* mroll/n27 */
      0, /* mroll/n28 */
      0, /* mroll/n29 */
      0, /* mroll/n30 */
      0, /* mroll/n31 */
      0, /* mroll/n32 */
      0, /* mroll/n33 */
      0, /* mroll/n34 */
      0, /* mroll/n35 */
      0, /* mroll/n36 */
      0, /* mroll/n37 */
      0, /* mroll/n38 */
      0, /* mroll/n39 */
      0, /* mroll/n40 */
      0, /* mroll/n41 */
      0, /* mroll/n42 */
      0, /* mroll/n43 */
      0, /* mroll/n44 */
      0, /* mroll/n45 */
      0, /* mroll/n46 */
      0, /* mroll/n47 */
      0, /* mroll/n48 */
      0, /* mroll/n49 */
      0, /* mroll/n50 */
      0, /* mroll/n51 */
      0, /* mroll/n52 */
      0, /* mroll/n53 */
      0, /* mroll/n54 */
      0, /* mroll/n55 */
      0, /* mroll/n56 */
      0, /* mroll/n57 */
      0, /* mroll/n58 */
      0, /* mroll/n59 */
      0, /* mroll/n60 */
      0, /* mroll/n61 */
      0, /* mroll/n62 */
      0, /* mroll/n63 */
      0, /* mroll/n64 */
      0, /* mroll/n65 */
      0, /* mroll/n66 */
      0, /* mroll/n67 */
      0, /* mroll/n68 */
      0, /* mroll/n69 */
      0, /* mroll/n70 */
      1, /* mroll/nR */
      0, /* mrollforth */
      0, /* mrot */
      3, /* mul/%rR/%rR/%rR */
      2, /* mul/%rR/n2/%rR */
      3, /* mul/%rR/nR/%rR */
      2, /* mul/n2/%rR/%rR */
      1, /* mul/n2/n2/%rR */
      2, /* mul/n2/nR/%rR */
      3, /* mul/nR/%rR/%rR */
      2, /* mul/nR/n2/%rR */
      3, /* mul/nR/nR/%rR */
      4, /* mulo/%rR/%rR/%rR/fR */
      3, /* mulo/%rR/n2/%rR/fR */
      4, /* mulo/%rR/nR/%rR/fR */
      4, /* mulo/nR/%rR/%rR/fR */
      3, /* mulo/nR/n2/%rR/fR */
      4, /* mulo/nR/nR/%rR/fR */
      0, /* nop */
      1, /* print-pending-signals/retR */
      2, /* print-topmost/nR/retR */
      2, /* printfixnum/%rR/retR */
      2, /* printfixnum/nR/retR */
      2, /* printufixnum/%rR/retR */
      2, /* printufixnum/nR/retR */
      2, /* procedurecall/fR/retR */
      2, /* procedurecallr/%rR/retR */
      2, /* procedurecallr/lR/retR */
      0, /* procedureprolog */
      0, /* procedurereturn */
      2, /* push-depths/nR/retR */
      1, /* push-handler/n0/lR */
      1, /* push-handler/n1/lR */
      1, /* push-handler/n2/lR */
      1, /* push-handler/n3/lR */
      1, /* push-handler/n4/lR */
      1, /* push-handler/n5/lR */
      1, /* push-handler/n6/lR */
      1, /* push-handler/n7/lR */
      1, /* push-handler/n8/lR */
      1, /* push-handler/n9/lR */
      1, /* push-handler/n10/lR */
      2, /* push-handler/nR/lR */
      2, /* push-increasing/nR/retR */
      0, /* quake */
      1, /* raise/%rR */
      0, /* raise/n0 */
      0, /* raise/n1 */
      0, /* raise/n2 */
      0, /* raise/n3 */
      0, /* raise/n4 */
      0, /* raise/n5 */
      0, /* raise/n6 */
      0, /* raise/n7 */
      0, /* raise/n8 */
      0, /* raise/n9 */
      0, /* raise/n10 */
      1, /* raise/nR */
      2, /* random/%rR/retR */
      0, /* reverse/n0 */
      0, /* reverse/n1 */
      0, /* reverse/n2 */
      0, /* reverse/n3 */
      0, /* reverse/n4 */
      0, /* reverse/n5 */
      0, /* reverse/n6 */
      0, /* reverse/n7 */
      0, /* reverse/n8 */
      0, /* reverse/n9 */
      0, /* reverse/n10 */
      0, /* reverse/n11 */
      0, /* reverse/n12 */
      0, /* reverse/n13 */
      0, /* reverse/n14 */
      0, /* reverse/n15 */
      0, /* reverse/n16 */
      0, /* reverse/n17 */
      0, /* reverse/n18 */
      0, /* reverse/n19 */
      0, /* reverse/n20 */
      0, /* reverse/n21 */
      0, /* reverse/n22 */
      0, /* reverse/n23 */
      0, /* reverse/n24 */
      0, /* reverse/n25 */
      0, /* reverse/n26 */
      0, /* reverse/n27 */
      0, /* reverse/n28 */
      0, /* reverse/n29 */
      0, /* reverse/n30 */
      0, /* reverse/n31 */
      0, /* reverse/n32 */
      0, /* reverse/n33 */
      0, /* reverse/n34 */
      0, /* reverse/n35 */
      0, /* reverse/n36 */
      0, /* reverse/n37 */
      0, /* reverse/n38 */
      0, /* reverse/n39 */
      0, /* reverse/n40 */
      0, /* reverse/n41 */
      0, /* reverse/n42 */
      0, /* reverse/n43 */
      0, /* reverse/n44 */
      0, /* reverse/n45 */
      0, /* reverse/n46 */
      0, /* reverse/n47 */
      0, /* reverse/n48 */
      0, /* reverse/n49 */
      0, /* reverse/n50 */
      0, /* reverse/n51 */
      0, /* reverse/n52 */
      0, /* reverse/n53 */
      0, /* reverse/n54 */
      0, /* reverse/n55 */
      0, /* reverse/n56 */
      0, /* reverse/n57 */
      0, /* reverse/n58 */
      0, /* reverse/n59 */
      0, /* reverse/n60 */
      0, /* reverse/n61 */
      0, /* reverse/n62 */
      0, /* reverse/n63 */
      0, /* reverse/n64 */
      0, /* reverse/n65 */
      0, /* reverse/n66 */
      0, /* reverse/n67 */
      0, /* reverse/n68 */
      0, /* reverse/n69 */
      0, /* reverse/n70 */
      1, /* reverse/nR */
      0, /* roll/n0 */
      0, /* roll/n1 */
      0, /* roll/n2 */
      0, /* roll/n3 */
      0, /* roll/n4 */
      0, /* roll/n5 */
      0, /* roll/n6 */
      0, /* roll/n7 */
      0, /* roll/n8 */
      0, /* roll/n9 */
      0, /* roll/n10 */
      0, /* roll/n11 */
      0, /* roll/n12 */
      0, /* roll/n13 */
      0, /* roll/n14 */
      0, /* roll/n15 */
      0, /* roll/n16 */
      0, /* roll/n17 */
      0, /* roll/n18 */
      0, /* roll/n19 */
      0, /* roll/n20 */
      0, /* roll/n21 */
      0, /* roll/n22 */
      0, /* roll/n23 */
      0, /* roll/n24 */
      0, /* roll/n25 */
      0, /* roll/n26 */
      0, /* roll/n27 */
      0, /* roll/n28 */
      0, /* roll/n29 */
      0, /* roll/n30 */
      0, /* roll/n31 */
      0, /* roll/n32 */
      0, /* roll/n33 */
      0, /* roll/n34 */
      0, /* roll/n35 */
      0, /* roll/n36 */
      0, /* roll/n37 */
      0, /* roll/n38 */
      0, /* roll/n39 */
      0, /* roll/n40 */
      0, /* roll/n41 */
      0, /* roll/n42 */
      0, /* roll/n43 */
      0, /* roll/n44 */
      0, /* roll/n45 */
      0, /* roll/n46 */
      0, /* roll/n47 */
      0, /* roll/n48 */
      0, /* roll/n49 */
      0, /* roll/n50 */
      0, /* roll/n51 */
      0, /* roll/n52 */
      0, /* roll/n53 */
      0, /* roll/n54 */
      0, /* roll/n55 */
      0, /* roll/n56 */
      0, /* roll/n57 */
      0, /* roll/n58 */
      0, /* roll/n59 */
      0, /* roll/n60 */
      0, /* roll/n61 */
      0, /* roll/n62 */
      0, /* roll/n63 */
      0, /* roll/n64 */
      0, /* roll/n65 */
      0, /* roll/n66 */
      0, /* roll/n67 */
      0, /* roll/n68 */
      0, /* roll/n69 */
      0, /* roll/n70 */
      1, /* roll/nR */
      0, /* rollforth */
      0, /* rot */
      1, /* safe-point/fR */
      0, /* set-pending */
      0, /* slide/n1/n1 */
      0, /* slide/n1/n2 */
      0, /* slide/n1/n3 */
      0, /* slide/n1/n4 */
      0, /* slide/n1/n5 */
      1, /* slide/n1/nR */
      0, /* slide/n2/n1 */
      0, /* slide/n2/n2 */
      0, /* slide/n2/n3 */
      0, /* slide/n2/n4 */
      0, /* slide/n2/n5 */
      1, /* slide/n2/nR */
      0, /* slide/n3/n1 */
      0, /* slide/n3/n2 */
      0, /* slide/n3/n3 */
      0, /* slide/n3/n4 */
      0, /* slide/n3/n5 */
      1, /* slide/n3/nR */
      1, /* slide/nR/n1 */
      1, /* slide/nR/n2 */
      1, /* slide/nR/n3 */
      1, /* slide/nR/n4 */
      1, /* slide/nR/n5 */
      2, /* slide/nR/nR */
      0, /* slideforth */
      0, /* stackdrop */
      0, /* stackdup */
      1, /* stackif/fR */
      0, /* stacknip */
      1, /* stacknondroppingif/fR */
      0, /* stacknot */
      0, /* stackoneminus */
      0, /* stackoneplus */
      0, /* stackover */
      1, /* stackpeek/%rR */
      0, /* stackplus */
      1, /* stackplusr/%rR */
      1, /* stackpop/%rR */
      1, /* stackprint/retR */
      1, /* stackpush/%rR */
      0, /* stackpush/n0 */
      0, /* stackpush/n1 */
      1, /* stackpush/nR */
      1, /* stackpush/lR */
      0, /* stackpushunspecified */
      1, /* stackset/%rR */
      0, /* stackset/n0 */
      0, /* stackset/n1 */
      1, /* stackset/nR */
      1, /* stackset/lR */
      0, /* stackswap */
      1, /* stackswaptop/%rR */
      0, /* stacktimes */
      3, /* storewithbyteoffset/%rR/%rR/%rR */
      2, /* storewithbyteoffset/%rR/%rR/n0 */
      2, /* storewithbyteoffset/%rR/%rR/n8 */
      3, /* storewithbyteoffset/%rR/%rR/nR */
      3, /* storewithbyteoffset/nR/%rR/%rR */
      2, /* storewithbyteoffset/nR/%rR/n0 */
      2, /* storewithbyteoffset/nR/%rR/n8 */
      3, /* storewithbyteoffset/nR/%rR/nR */
      3, /* storewithwordoffset/%rR/%rR/%rR */
      2, /* storewithwordoffset/%rR/%rR/n0 */
      2, /* storewithwordoffset/%rR/%rR/n1 */
      2, /* storewithwordoffset/%rR/%rR/n2 */
      3, /* storewithwordoffset/%rR/%rR/nR */
      3, /* storewithwordoffset/nR/%rR/%rR */
      2, /* storewithwordoffset/nR/%rR/n0 */
      2, /* storewithwordoffset/nR/%rR/n1 */
      2, /* storewithwordoffset/nR/%rR/n2 */
      3, /* storewithwordoffset/nR/%rR/nR */
      3, /* sub/%rR/%rR/%rR */
      2, /* sub/%rR/n1/%rR */
      3, /* sub/%rR/nR/%rR */
      2, /* sub/n0/%rR/%rR */
      1, /* sub/n0/n1/%rR */
      2, /* sub/n0/nR/%rR */
      3, /* sub/nR/%rR/%rR */
      2, /* sub/nR/n1/%rR */
      3, /* sub/nR/nR/%rR */
      4, /* subo/%rR/%rR/%rR/fR */
      3, /* subo/%rR/n1/%rR/fR */
      4, /* subo/%rR/nR/%rR/fR */
      4, /* subo/nR/%rR/%rR/fR */
      3, /* subo/nR/n1/%rR/fR */
      4, /* subo/nR/nR/%rR/fR */
      0, /* tuck */
      0, /* unreachable */
      0, /* whirl/n0 */
      0, /* whirl/n1 */
      0, /* whirl/n2 */
      0, /* whirl/n3 */
      1, /* whirl/nR */
      0, /* whirlforth */
      5, /* !REPLACEMENT-addo/%rR/%rR/%rR/fR/retR */
      4, /* !REPLACEMENT-addo/%rR/n1/%rR/fR/retR */
      4, /* !REPLACEMENT-addo/%rR/n-1/%rR/fR/retR */
      5, /* !REPLACEMENT-addo/%rR/nR/%rR/fR/retR */
      5, /* !REPLACEMENT-addo/nR/%rR/%rR/fR/retR */
      4, /* !REPLACEMENT-addo/nR/n1/%rR/fR/retR */
      4, /* !REPLACEMENT-addo/nR/n-1/%rR/fR/retR */
      5, /* !REPLACEMENT-addo/nR/nR/%rR/fR/retR */
      2, /* !REPLACEMENT-b/fR/retR */
      4, /* !REPLACEMENT-band/%rR/%rR/fR/retR */
      3, /* !REPLACEMENT-band/%rR/n3/fR/retR */
      3, /* !REPLACEMENT-band/%rR/n7/fR/retR */
      4, /* !REPLACEMENT-band/%rR/nR/fR/retR */
      4, /* !REPLACEMENT-band/nR/%rR/fR/retR */
      3, /* !REPLACEMENT-band/nR/n3/fR/retR */
      3, /* !REPLACEMENT-band/nR/n7/fR/retR */
      4, /* !REPLACEMENT-band/nR/nR/fR/retR */
      4, /* !REPLACEMENT-beq/%rR/%rR/fR/retR */
      4, /* !REPLACEMENT-beq/%rR/nR/fR/retR */
      4, /* !REPLACEMENT-beq/nR/%rR/fR/retR */
      4, /* !REPLACEMENT-beq/nR/nR/fR/retR */
      4, /* !REPLACEMENT-bge/%rR/%rR/fR/retR */
      3, /* !REPLACEMENT-bge/%rR/n0/fR/retR */
      3, /* !REPLACEMENT-bge/%rR/n1/fR/retR */
      4, /* !REPLACEMENT-bge/%rR/nR/fR/retR */
      3, /* !REPLACEMENT-bge/n0/%rR/fR/retR */
      2, /* !REPLACEMENT-bge/n0/n0/fR/retR */
      2, /* !REPLACEMENT-bge/n0/n1/fR/retR */
      3, /* !REPLACEMENT-bge/n0/nR/fR/retR */
      3, /* !REPLACEMENT-bge/n1/%rR/fR/retR */
      2, /* !REPLACEMENT-bge/n1/n0/fR/retR */
      2, /* !REPLACEMENT-bge/n1/n1/fR/retR */
      3, /* !REPLACEMENT-bge/n1/nR/fR/retR */
      4, /* !REPLACEMENT-bge/nR/%rR/fR/retR */
      3, /* !REPLACEMENT-bge/nR/n0/fR/retR */
      3, /* !REPLACEMENT-bge/nR/n1/fR/retR */
      4, /* !REPLACEMENT-bge/nR/nR/fR/retR */
      4, /* !REPLACEMENT-bgeu/%rR/%rR/fR/retR */
      3, /* !REPLACEMENT-bgeu/%rR/n0/fR/retR */
      3, /* !REPLACEMENT-bgeu/%rR/n1/fR/retR */
      4, /* !REPLACEMENT-bgeu/%rR/nR/fR/retR */
      3, /* !REPLACEMENT-bgeu/n0/%rR/fR/retR */
      2, /* !REPLACEMENT-bgeu/n0/n0/fR/retR */
      2, /* !REPLACEMENT-bgeu/n0/n1/fR/retR */
      3, /* !REPLACEMENT-bgeu/n0/nR/fR/retR */
      3, /* !REPLACEMENT-bgeu/n1/%rR/fR/retR */
      2, /* !REPLACEMENT-bgeu/n1/n0/fR/retR */
      2, /* !REPLACEMENT-bgeu/n1/n1/fR/retR */
      3, /* !REPLACEMENT-bgeu/n1/nR/fR/retR */
      4, /* !REPLACEMENT-bgeu/nR/%rR/fR/retR */
      3, /* !REPLACEMENT-bgeu/nR/n0/fR/retR */
      3, /* !REPLACEMENT-bgeu/nR/n1/fR/retR */
      4, /* !REPLACEMENT-bgeu/nR/nR/fR/retR */
      4, /* !REPLACEMENT-bgt/%rR/%rR/fR/retR */
      3, /* !REPLACEMENT-bgt/%rR/n0/fR/retR */
      3, /* !REPLACEMENT-bgt/%rR/n1/fR/retR */
      4, /* !REPLACEMENT-bgt/%rR/nR/fR/retR */
      3, /* !REPLACEMENT-bgt/n0/%rR/fR/retR */
      2, /* !REPLACEMENT-bgt/n0/n0/fR/retR */
      2, /* !REPLACEMENT-bgt/n0/n1/fR/retR */
      3, /* !REPLACEMENT-bgt/n0/nR/fR/retR */
      3, /* !REPLACEMENT-bgt/n1/%rR/fR/retR */
      2, /* !REPLACEMENT-bgt/n1/n0/fR/retR */
      2, /* !REPLACEMENT-bgt/n1/n1/fR/retR */
      3, /* !REPLACEMENT-bgt/n1/nR/fR/retR */
      4, /* !REPLACEMENT-bgt/nR/%rR/fR/retR */
      3, /* !REPLACEMENT-bgt/nR/n0/fR/retR */
      3, /* !REPLACEMENT-bgt/nR/n1/fR/retR */
      4, /* !REPLACEMENT-bgt/nR/nR/fR/retR */
      4, /* !REPLACEMENT-bgtu/%rR/%rR/fR/retR */
      3, /* !REPLACEMENT-bgtu/%rR/n0/fR/retR */
      3, /* !REPLACEMENT-bgtu/%rR/n1/fR/retR */
      4, /* !REPLACEMENT-bgtu/%rR/nR/fR/retR */
      3, /* !REPLACEMENT-bgtu/n0/%rR/fR/retR */
      2, /* !REPLACEMENT-bgtu/n0/n0/fR/retR */
      2, /* !REPLACEMENT-bgtu/n0/n1/fR/retR */
      3, /* !REPLACEMENT-bgtu/n0/nR/fR/retR */
      3, /* !REPLACEMENT-bgtu/n1/%rR/fR/retR */
      2, /* !REPLACEMENT-bgtu/n1/n0/fR/retR */
      2, /* !REPLACEMENT-bgtu/n1/n1/fR/retR */
      3, /* !REPLACEMENT-bgtu/n1/nR/fR/retR */
      4, /* !REPLACEMENT-bgtu/nR/%rR/fR/retR */
      3, /* !REPLACEMENT-bgtu/nR/n0/fR/retR */
      3, /* !REPLACEMENT-bgtu/nR/n1/fR/retR */
      4, /* !REPLACEMENT-bgtu/nR/nR/fR/retR */
      4, /* !REPLACEMENT-ble/%rR/%rR/fR/retR */
      3, /* !REPLACEMENT-ble/%rR/n0/fR/retR */
      3, /* !REPLACEMENT-ble/%rR/n1/fR/retR */
      4, /* !REPLACEMENT-ble/%rR/nR/fR/retR */
      3, /* !REPLACEMENT-ble/n0/%rR/fR/retR */
      2, /* !REPLACEMENT-ble/n0/n0/fR/retR */
      2, /* !REPLACEMENT-ble/n0/n1/fR/retR */
      3, /* !REPLACEMENT-ble/n0/nR/fR/retR */
      3, /* !REPLACEMENT-ble/n1/%rR/fR/retR */
      2, /* !REPLACEMENT-ble/n1/n0/fR/retR */
      2, /* !REPLACEMENT-ble/n1/n1/fR/retR */
      3, /* !REPLACEMENT-ble/n1/nR/fR/retR */
      4, /* !REPLACEMENT-ble/nR/%rR/fR/retR */
      3, /* !REPLACEMENT-ble/nR/n0/fR/retR */
      3, /* !REPLACEMENT-ble/nR/n1/fR/retR */
      4, /* !REPLACEMENT-ble/nR/nR/fR/retR */
      4, /* !REPLACEMENT-bleu/%rR/%rR/fR/retR */
      3, /* !REPLACEMENT-bleu/%rR/n0/fR/retR */
      3, /* !REPLACEMENT-bleu/%rR/n1/fR/retR */
      4, /* !REPLACEMENT-bleu/%rR/nR/fR/retR */
      3, /* !REPLACEMENT-bleu/n0/%rR/fR/retR */
      2, /* !REPLACEMENT-bleu/n0/n0/fR/retR */
      2, /* !REPLACEMENT-bleu/n0/n1/fR/retR */
      3, /* !REPLACEMENT-bleu/n0/nR/fR/retR */
      3, /* !REPLACEMENT-bleu/n1/%rR/fR/retR */
      2, /* !REPLACEMENT-bleu/n1/n0/fR/retR */
      2, /* !REPLACEMENT-bleu/n1/n1/fR/retR */
      3, /* !REPLACEMENT-bleu/n1/nR/fR/retR */
      4, /* !REPLACEMENT-bleu/nR/%rR/fR/retR */
      3, /* !REPLACEMENT-bleu/nR/n0/fR/retR */
      3, /* !REPLACEMENT-bleu/nR/n1/fR/retR */
      4, /* !REPLACEMENT-bleu/nR/nR/fR/retR */
      4, /* !REPLACEMENT-blt/%rR/%rR/fR/retR */
      3, /* !REPLACEMENT-blt/%rR/n0/fR/retR */
      3, /* !REPLACEMENT-blt/%rR/n1/fR/retR */
      4, /* !REPLACEMENT-blt/%rR/nR/fR/retR */
      3, /* !REPLACEMENT-blt/n0/%rR/fR/retR */
      2, /* !REPLACEMENT-blt/n0/n0/fR/retR */
      2, /* !REPLACEMENT-blt/n0/n1/fR/retR */
      3, /* !REPLACEMENT-blt/n0/nR/fR/retR */
      3, /* !REPLACEMENT-blt/n1/%rR/fR/retR */
      2, /* !REPLACEMENT-blt/n1/n0/fR/retR */
      2, /* !REPLACEMENT-blt/n1/n1/fR/retR */
      3, /* !REPLACEMENT-blt/n1/nR/fR/retR */
      4, /* !REPLACEMENT-blt/nR/%rR/fR/retR */
      3, /* !REPLACEMENT-blt/nR/n0/fR/retR */
      3, /* !REPLACEMENT-blt/nR/n1/fR/retR */
      4, /* !REPLACEMENT-blt/nR/nR/fR/retR */
      4, /* !REPLACEMENT-bltu/%rR/%rR/fR/retR */
      3, /* !REPLACEMENT-bltu/%rR/n0/fR/retR */
      3, /* !REPLACEMENT-bltu/%rR/n1/fR/retR */
      4, /* !REPLACEMENT-bltu/%rR/nR/fR/retR */
      3, /* !REPLACEMENT-bltu/n0/%rR/fR/retR */
      2, /* !REPLACEMENT-bltu/n0/n0/fR/retR */
      2, /* !REPLACEMENT-bltu/n0/n1/fR/retR */
      3, /* !REPLACEMENT-bltu/n0/nR/fR/retR */
      3, /* !REPLACEMENT-bltu/n1/%rR/fR/retR */
      2, /* !REPLACEMENT-bltu/n1/n0/fR/retR */
      2, /* !REPLACEMENT-bltu/n1/n1/fR/retR */
      3, /* !REPLACEMENT-bltu/n1/nR/fR/retR */
      4, /* !REPLACEMENT-bltu/nR/%rR/fR/retR */
      3, /* !REPLACEMENT-bltu/nR/n0/fR/retR */
      3, /* !REPLACEMENT-bltu/nR/n1/fR/retR */
      4, /* !REPLACEMENT-bltu/nR/nR/fR/retR */
      4, /* !REPLACEMENT-bne/%rR/%rR/fR/retR */
      3, /* !REPLACEMENT-bne/%rR/n0/fR/retR */
      4, /* !REPLACEMENT-bne/%rR/nR/fR/retR */
      3, /* !REPLACEMENT-bne/n0/%rR/fR/retR */
      2, /* !REPLACEMENT-bne/n0/n0/fR/retR */
      3, /* !REPLACEMENT-bne/n0/nR/fR/retR */
      4, /* !REPLACEMENT-bne/nR/%rR/fR/retR */
      3, /* !REPLACEMENT-bne/nR/n0/fR/retR */
      4, /* !REPLACEMENT-bne/nR/nR/fR/retR */
      3, /* !REPLACEMENT-bneg/%rR/fR/retR */
      3, /* !REPLACEMENT-bneg/nR/fR/retR */
      3, /* !REPLACEMENT-bnneg/%rR/fR/retR */
      3, /* !REPLACEMENT-bnneg/nR/fR/retR */
      4, /* !REPLACEMENT-bnotand/%rR/%rR/fR/retR */
      3, /* !REPLACEMENT-bnotand/%rR/n3/fR/retR */
      3, /* !REPLACEMENT-bnotand/%rR/n7/fR/retR */
      4, /* !REPLACEMENT-bnotand/%rR/nR/fR/retR */
      4, /* !REPLACEMENT-bnotand/nR/%rR/fR/retR */
      3, /* !REPLACEMENT-bnotand/nR/n3/fR/retR */
      3, /* !REPLACEMENT-bnotand/nR/n7/fR/retR */
      4, /* !REPLACEMENT-bnotand/nR/nR/fR/retR */
      3, /* !REPLACEMENT-bnpos/%rR/fR/retR */
      3, /* !REPLACEMENT-bnpos/nR/fR/retR */
      3, /* !REPLACEMENT-bnz/%rR/fR/retR */
      3, /* !REPLACEMENT-bnz/nR/fR/retR */
      3, /* !REPLACEMENT-bpos/%rR/fR/retR */
      3, /* !REPLACEMENT-bpos/nR/fR/retR */
      2, /* !REPLACEMENT-br/%rR/retR */
      3, /* !REPLACEMENT-bz/%rR/fR/retR */
      3, /* !REPLACEMENT-bz/nR/fR/retR */
      5, /* !REPLACEMENT-divo/%rR/%rR/%rR/fR/retR */
      4, /* !REPLACEMENT-divo/%rR/n2/%rR/fR/retR */
      5, /* !REPLACEMENT-divo/%rR/nR/%rR/fR/retR */
      5, /* !REPLACEMENT-divo/nR/%rR/%rR/fR/retR */
      4, /* !REPLACEMENT-divo/nR/n2/%rR/fR/retR */
      5, /* !REPLACEMENT-divo/nR/nR/%rR/fR/retR */
      1, /* !REPLACEMENT-endvm/retR */
      1, /* !REPLACEMENT-exitvm/retR */
      5, /* !REPLACEMENT-modo/%rR/%rR/%rR/fR/retR */
      4, /* !REPLACEMENT-modo/%rR/n2/%rR/fR/retR */
      5, /* !REPLACEMENT-modo/%rR/nR/%rR/fR/retR */
      5, /* !REPLACEMENT-modo/nR/%rR/%rR/fR/retR */
      4, /* !REPLACEMENT-modo/nR/n2/%rR/fR/retR */
      5, /* !REPLACEMENT-modo/nR/nR/%rR/fR/retR */
      5, /* !REPLACEMENT-mulo/%rR/%rR/%rR/fR/retR */
      4, /* !REPLACEMENT-mulo/%rR/n2/%rR/fR/retR */
      5, /* !REPLACEMENT-mulo/%rR/nR/%rR/fR/retR */
      5, /* !REPLACEMENT-mulo/nR/%rR/%rR/fR/retR */
      4, /* !REPLACEMENT-mulo/nR/n2/%rR/fR/retR */
      5, /* !REPLACEMENT-mulo/nR/nR/%rR/fR/retR */
      2, /* !REPLACEMENT-procedurecall/fR/retR */
      2, /* !REPLACEMENT-procedurecallr/%rR/retR */
      2, /* !REPLACEMENT-procedurecallr/lR/retR */
      1, /* !REPLACEMENT-procedureprolog/retR */
      1, /* !REPLACEMENT-procedurereturn/retR */
      2, /* !REPLACEMENT-raise/%rR/retR */
      1, /* !REPLACEMENT-raise/n0/retR */
      1, /* !REPLACEMENT-raise/n1/retR */
      1, /* !REPLACEMENT-raise/n2/retR */
      1, /* !REPLACEMENT-raise/n3/retR */
      1, /* !REPLACEMENT-raise/n4/retR */
      1, /* !REPLACEMENT-raise/n5/retR */
      1, /* !REPLACEMENT-raise/n6/retR */
      1, /* !REPLACEMENT-raise/n7/retR */
      1, /* !REPLACEMENT-raise/n8/retR */
      1, /* !REPLACEMENT-raise/n9/retR */
      1, /* !REPLACEMENT-raise/n10/retR */
      2, /* !REPLACEMENT-raise/nR/retR */
      2, /* !REPLACEMENT-safe-point/fR/retR */
      2, /* !REPLACEMENT-stackif/fR/retR */
      2, /* !REPLACEMENT-stacknondroppingif/fR/retR */
      5, /* !REPLACEMENT-subo/%rR/%rR/%rR/fR/retR */
      4, /* !REPLACEMENT-subo/%rR/n1/%rR/fR/retR */
      5, /* !REPLACEMENT-subo/%rR/nR/%rR/fR/retR */
      5, /* !REPLACEMENT-subo/nR/%rR/%rR/fR/retR */
      4, /* !REPLACEMENT-subo/nR/n1/%rR/fR/retR */
      5, /* !REPLACEMENT-subo/nR/nR/%rR/fR/retR */
      1 /* !REPLACEMENT-unreachable/retR */
    };
const unsigned long // FIXME: shall I use a shorter type when possible?
uninspired_specialized_instruction_label_bitmasks [UNINSPIRED_SPECIALIZED_INSTRUCTION_NO]
  = {
      /* It's important that !BEGINBASICBLOCK has a zero here: it does not need residual patching. */
      0, /* !INVALID */
      0, /* !BEGINBASICBLOCK */
      0, /* !EXITVM */
      0, /* !DATALOCATIONS */
      0, /* !NOP */
      0, /* !UNREACHABLE0 */
      0, /* !UNREACHABLE1 */
      0, /* !PRETENDTOJUMPANYWHERE */
      0, /* add/%rR/%rR/%rR */
      0, /* add/%rR/n1/%rR */
      0, /* add/%rR/n-1/%rR */
      0, /* add/%rR/nR/%rR */
      0, /* add/n1/%rR/%rR */
      0, /* add/n1/n1/%rR */
      0, /* add/n1/n-1/%rR */
      0, /* add/n1/nR/%rR */
      0, /* add/n-1/%rR/%rR */
      0, /* add/n-1/n1/%rR */
      0, /* add/n-1/n-1/%rR */
      0, /* add/n-1/nR/%rR */
      0, /* add/nR/%rR/%rR */
      0, /* add/nR/n1/%rR */
      0, /* add/nR/n-1/%rR */
      0, /* add/nR/nR/%rR */
      0 | (1UL << 3), /* addo/%rR/%rR/%rR/fR */
      0 | (1UL << 2), /* addo/%rR/n1/%rR/fR */
      0 | (1UL << 2), /* addo/%rR/n-1/%rR/fR */
      0 | (1UL << 3), /* addo/%rR/nR/%rR/fR */
      0 | (1UL << 3), /* addo/nR/%rR/%rR/fR */
      0 | (1UL << 2), /* addo/nR/n1/%rR/fR */
      0 | (1UL << 2), /* addo/nR/n-1/%rR/fR */
      0 | (1UL << 3), /* addo/nR/nR/%rR/fR */
      0 | (1UL << 0), /* b/fR */
      0 | (1UL << 2), /* band/%rR/%rR/fR */
      0 | (1UL << 1), /* band/%rR/n3/fR */
      0 | (1UL << 1), /* band/%rR/n7/fR */
      0 | (1UL << 2), /* band/%rR/nR/fR */
      0 | (1UL << 2), /* band/nR/%rR/fR */
      0 | (1UL << 1), /* band/nR/n3/fR */
      0 | (1UL << 1), /* band/nR/n7/fR */
      0 | (1UL << 2), /* band/nR/nR/fR */
      0 | (1UL << 2), /* beq/%rR/%rR/fR */
      0 | (1UL << 2), /* beq/%rR/nR/fR */
      0 | (1UL << 2), /* beq/nR/%rR/fR */
      0 | (1UL << 2), /* beq/nR/nR/fR */
      0 | (1UL << 2), /* bge/%rR/%rR/fR */
      0 | (1UL << 1), /* bge/%rR/n0/fR */
      0 | (1UL << 1), /* bge/%rR/n1/fR */
      0 | (1UL << 2), /* bge/%rR/nR/fR */
      0 | (1UL << 1), /* bge/n0/%rR/fR */
      0 | (1UL << 0), /* bge/n0/n0/fR */
      0 | (1UL << 0), /* bge/n0/n1/fR */
      0 | (1UL << 1), /* bge/n0/nR/fR */
      0 | (1UL << 1), /* bge/n1/%rR/fR */
      0 | (1UL << 0), /* bge/n1/n0/fR */
      0 | (1UL << 0), /* bge/n1/n1/fR */
      0 | (1UL << 1), /* bge/n1/nR/fR */
      0 | (1UL << 2), /* bge/nR/%rR/fR */
      0 | (1UL << 1), /* bge/nR/n0/fR */
      0 | (1UL << 1), /* bge/nR/n1/fR */
      0 | (1UL << 2), /* bge/nR/nR/fR */
      0 | (1UL << 2), /* bgeu/%rR/%rR/fR */
      0 | (1UL << 1), /* bgeu/%rR/n0/fR */
      0 | (1UL << 1), /* bgeu/%rR/n1/fR */
      0 | (1UL << 2), /* bgeu/%rR/nR/fR */
      0 | (1UL << 1), /* bgeu/n0/%rR/fR */
      0 | (1UL << 0), /* bgeu/n0/n0/fR */
      0 | (1UL << 0), /* bgeu/n0/n1/fR */
      0 | (1UL << 1), /* bgeu/n0/nR/fR */
      0 | (1UL << 1), /* bgeu/n1/%rR/fR */
      0 | (1UL << 0), /* bgeu/n1/n0/fR */
      0 | (1UL << 0), /* bgeu/n1/n1/fR */
      0 | (1UL << 1), /* bgeu/n1/nR/fR */
      0 | (1UL << 2), /* bgeu/nR/%rR/fR */
      0 | (1UL << 1), /* bgeu/nR/n0/fR */
      0 | (1UL << 1), /* bgeu/nR/n1/fR */
      0 | (1UL << 2), /* bgeu/nR/nR/fR */
      0 | (1UL << 2), /* bgt/%rR/%rR/fR */
      0 | (1UL << 1), /* bgt/%rR/n0/fR */
      0 | (1UL << 1), /* bgt/%rR/n1/fR */
      0 | (1UL << 2), /* bgt/%rR/nR/fR */
      0 | (1UL << 1), /* bgt/n0/%rR/fR */
      0 | (1UL << 0), /* bgt/n0/n0/fR */
      0 | (1UL << 0), /* bgt/n0/n1/fR */
      0 | (1UL << 1), /* bgt/n0/nR/fR */
      0 | (1UL << 1), /* bgt/n1/%rR/fR */
      0 | (1UL << 0), /* bgt/n1/n0/fR */
      0 | (1UL << 0), /* bgt/n1/n1/fR */
      0 | (1UL << 1), /* bgt/n1/nR/fR */
      0 | (1UL << 2), /* bgt/nR/%rR/fR */
      0 | (1UL << 1), /* bgt/nR/n0/fR */
      0 | (1UL << 1), /* bgt/nR/n1/fR */
      0 | (1UL << 2), /* bgt/nR/nR/fR */
      0 | (1UL << 2), /* bgtu/%rR/%rR/fR */
      0 | (1UL << 1), /* bgtu/%rR/n0/fR */
      0 | (1UL << 1), /* bgtu/%rR/n1/fR */
      0 | (1UL << 2), /* bgtu/%rR/nR/fR */
      0 | (1UL << 1), /* bgtu/n0/%rR/fR */
      0 | (1UL << 0), /* bgtu/n0/n0/fR */
      0 | (1UL << 0), /* bgtu/n0/n1/fR */
      0 | (1UL << 1), /* bgtu/n0/nR/fR */
      0 | (1UL << 1), /* bgtu/n1/%rR/fR */
      0 | (1UL << 0), /* bgtu/n1/n0/fR */
      0 | (1UL << 0), /* bgtu/n1/n1/fR */
      0 | (1UL << 1), /* bgtu/n1/nR/fR */
      0 | (1UL << 2), /* bgtu/nR/%rR/fR */
      0 | (1UL << 1), /* bgtu/nR/n0/fR */
      0 | (1UL << 1), /* bgtu/nR/n1/fR */
      0 | (1UL << 2), /* bgtu/nR/nR/fR */
      0 | (1UL << 2), /* ble/%rR/%rR/fR */
      0 | (1UL << 1), /* ble/%rR/n0/fR */
      0 | (1UL << 1), /* ble/%rR/n1/fR */
      0 | (1UL << 2), /* ble/%rR/nR/fR */
      0 | (1UL << 1), /* ble/n0/%rR/fR */
      0 | (1UL << 0), /* ble/n0/n0/fR */
      0 | (1UL << 0), /* ble/n0/n1/fR */
      0 | (1UL << 1), /* ble/n0/nR/fR */
      0 | (1UL << 1), /* ble/n1/%rR/fR */
      0 | (1UL << 0), /* ble/n1/n0/fR */
      0 | (1UL << 0), /* ble/n1/n1/fR */
      0 | (1UL << 1), /* ble/n1/nR/fR */
      0 | (1UL << 2), /* ble/nR/%rR/fR */
      0 | (1UL << 1), /* ble/nR/n0/fR */
      0 | (1UL << 1), /* ble/nR/n1/fR */
      0 | (1UL << 2), /* ble/nR/nR/fR */
      0 | (1UL << 2), /* bleu/%rR/%rR/fR */
      0 | (1UL << 1), /* bleu/%rR/n0/fR */
      0 | (1UL << 1), /* bleu/%rR/n1/fR */
      0 | (1UL << 2), /* bleu/%rR/nR/fR */
      0 | (1UL << 1), /* bleu/n0/%rR/fR */
      0 | (1UL << 0), /* bleu/n0/n0/fR */
      0 | (1UL << 0), /* bleu/n0/n1/fR */
      0 | (1UL << 1), /* bleu/n0/nR/fR */
      0 | (1UL << 1), /* bleu/n1/%rR/fR */
      0 | (1UL << 0), /* bleu/n1/n0/fR */
      0 | (1UL << 0), /* bleu/n1/n1/fR */
      0 | (1UL << 1), /* bleu/n1/nR/fR */
      0 | (1UL << 2), /* bleu/nR/%rR/fR */
      0 | (1UL << 1), /* bleu/nR/n0/fR */
      0 | (1UL << 1), /* bleu/nR/n1/fR */
      0 | (1UL << 2), /* bleu/nR/nR/fR */
      0 | (1UL << 2), /* blt/%rR/%rR/fR */
      0 | (1UL << 1), /* blt/%rR/n0/fR */
      0 | (1UL << 1), /* blt/%rR/n1/fR */
      0 | (1UL << 2), /* blt/%rR/nR/fR */
      0 | (1UL << 1), /* blt/n0/%rR/fR */
      0 | (1UL << 0), /* blt/n0/n0/fR */
      0 | (1UL << 0), /* blt/n0/n1/fR */
      0 | (1UL << 1), /* blt/n0/nR/fR */
      0 | (1UL << 1), /* blt/n1/%rR/fR */
      0 | (1UL << 0), /* blt/n1/n0/fR */
      0 | (1UL << 0), /* blt/n1/n1/fR */
      0 | (1UL << 1), /* blt/n1/nR/fR */
      0 | (1UL << 2), /* blt/nR/%rR/fR */
      0 | (1UL << 1), /* blt/nR/n0/fR */
      0 | (1UL << 1), /* blt/nR/n1/fR */
      0 | (1UL << 2), /* blt/nR/nR/fR */
      0 | (1UL << 2), /* bltu/%rR/%rR/fR */
      0 | (1UL << 1), /* bltu/%rR/n0/fR */
      0 | (1UL << 1), /* bltu/%rR/n1/fR */
      0 | (1UL << 2), /* bltu/%rR/nR/fR */
      0 | (1UL << 1), /* bltu/n0/%rR/fR */
      0 | (1UL << 0), /* bltu/n0/n0/fR */
      0 | (1UL << 0), /* bltu/n0/n1/fR */
      0 | (1UL << 1), /* bltu/n0/nR/fR */
      0 | (1UL << 1), /* bltu/n1/%rR/fR */
      0 | (1UL << 0), /* bltu/n1/n0/fR */
      0 | (1UL << 0), /* bltu/n1/n1/fR */
      0 | (1UL << 1), /* bltu/n1/nR/fR */
      0 | (1UL << 2), /* bltu/nR/%rR/fR */
      0 | (1UL << 1), /* bltu/nR/n0/fR */
      0 | (1UL << 1), /* bltu/nR/n1/fR */
      0 | (1UL << 2), /* bltu/nR/nR/fR */
      0 | (1UL << 2), /* bne/%rR/%rR/fR */
      0 | (1UL << 1), /* bne/%rR/n0/fR */
      0 | (1UL << 2), /* bne/%rR/nR/fR */
      0 | (1UL << 1), /* bne/n0/%rR/fR */
      0 | (1UL << 0), /* bne/n0/n0/fR */
      0 | (1UL << 1), /* bne/n0/nR/fR */
      0 | (1UL << 2), /* bne/nR/%rR/fR */
      0 | (1UL << 1), /* bne/nR/n0/fR */
      0 | (1UL << 2), /* bne/nR/nR/fR */
      0 | (1UL << 1), /* bneg/%rR/fR */
      0 | (1UL << 1), /* bneg/nR/fR */
      0 | (1UL << 1), /* bnneg/%rR/fR */
      0 | (1UL << 1), /* bnneg/nR/fR */
      0 | (1UL << 2), /* bnotand/%rR/%rR/fR */
      0 | (1UL << 1), /* bnotand/%rR/n3/fR */
      0 | (1UL << 1), /* bnotand/%rR/n7/fR */
      0 | (1UL << 2), /* bnotand/%rR/nR/fR */
      0 | (1UL << 2), /* bnotand/nR/%rR/fR */
      0 | (1UL << 1), /* bnotand/nR/n3/fR */
      0 | (1UL << 1), /* bnotand/nR/n7/fR */
      0 | (1UL << 2), /* bnotand/nR/nR/fR */
      0 | (1UL << 1), /* bnpos/%rR/fR */
      0 | (1UL << 1), /* bnpos/nR/fR */
      0 | (1UL << 1), /* bnz/%rR/fR */
      0 | (1UL << 1), /* bnz/nR/fR */
      0 | (1UL << 1), /* bpos/%rR/fR */
      0 | (1UL << 1), /* bpos/nR/fR */
      0, /* br/%rR */
      0, /* bulge/n0 */
      0, /* bulge/n1 */
      0, /* bulge/n2 */
      0, /* bulge/n3 */
      0, /* bulge/nR */
      0, /* bulgeforth */
      0 | (1UL << 1), /* bz/%rR/fR */
      0 | (1UL << 1), /* bz/nR/fR */
      0, /* clear-pending/retR */
      0, /* div/%rR/%rR/%rR/retR */
      0, /* div/%rR/n2/%rR/retR */
      0, /* div/%rR/nR/%rR/retR */
      0, /* div/nR/%rR/%rR/retR */
      0, /* div/nR/n2/%rR/retR */
      0, /* div/nR/nR/%rR/retR */
      0 | (1UL << 3), /* divo/%rR/%rR/%rR/fR */
      0 | (1UL << 2), /* divo/%rR/n2/%rR/fR */
      0 | (1UL << 3), /* divo/%rR/nR/%rR/fR */
      0 | (1UL << 3), /* divo/nR/%rR/%rR/fR */
      0 | (1UL << 2), /* divo/nR/n2/%rR/fR */
      0 | (1UL << 3), /* divo/nR/nR/%rR/fR */
      0, /* drop-handler */
      0, /* endvm */
      0, /* exit/%rR/retR */
      0, /* exit/nR/retR */
      0, /* exitvm */
      0, /* fadd/%fR/%fR/%fR */
      0, /* fdiv/%fR/%fR/%fR */
      0, /* fincr/%fR */
      0, /* fmul/%fR/%fR/%fR */
      0, /* fprint/%fR */
      0, /* fset/%rR/%fR */
      0, /* fset/nR/%fR */
      0, /* fsub/%fR/%fR/%fR */
      0, /* hcf/retR */
      0, /* install-signal-handler/retR */
      0, /* loadwithbyteoffset/%rR/%rR/%rR */
      0, /* loadwithbyteoffset/%rR/n0/%rR */
      0, /* loadwithbyteoffset/%rR/n8/%rR */
      0, /* loadwithbyteoffset/%rR/nR/%rR */
      0, /* loadwithwordoffset/%rR/%rR/%rR */
      0, /* loadwithwordoffset/%rR/n0/%rR */
      0, /* loadwithwordoffset/%rR/n1/%rR */
      0, /* loadwithwordoffset/%rR/n2/%rR */
      0, /* loadwithwordoffset/%rR/nR/%rR */
      0, /* mallocwords/%rR/%rR/retR */
      0, /* mallocwords/nR/%rR/retR */
      0, /* mod/%rR/%rR/%rR/retR */
      0, /* mod/%rR/n2/%rR/retR */
      0, /* mod/%rR/nR/%rR/retR */
      0, /* mod/nR/%rR/%rR/retR */
      0, /* mod/nR/n2/%rR/retR */
      0, /* mod/nR/nR/%rR/retR */
      0 | (1UL << 3), /* modo/%rR/%rR/%rR/fR */
      0 | (1UL << 2), /* modo/%rR/n2/%rR/fR */
      0 | (1UL << 3), /* modo/%rR/nR/%rR/fR */
      0 | (1UL << 3), /* modo/nR/%rR/%rR/fR */
      0 | (1UL << 2), /* modo/nR/n2/%rR/fR */
      0 | (1UL << 3), /* modo/nR/nR/%rR/fR */
      0, /* mov/%rR/%rR */
      0, /* mov/n0/%rR */
      0, /* mov/n1/%rR */
      0, /* mov/nR/%rR */
      0 | (1UL << 0), /* mov/lR/%rR */
      0, /* mroll/n0 */
      0, /* mroll/n1 */
      0, /* mroll/n2 */
      0, /* mroll/n3 */
      0, /* mroll/n4 */
      0, /* mroll/n5 */
      0, /* mroll/n6 */
      0, /* mroll/n7 */
      0, /* mroll/n8 */
      0, /* mroll/n9 */
      0, /* mroll/n10 */
      0, /* mroll/n11 */
      0, /* mroll/n12 */
      0, /* mroll/n13 */
      0, /* mroll/n14 */
      0, /* mroll/n15 */
      0, /* mroll/n16 */
      0, /* mroll/n17 */
      0, /* mroll/n18 */
      0, /* mroll/n19 */
      0, /* mroll/n20 */
      0, /* mroll/n21 */
      0, /* mroll/n22 */
      0, /* mroll/n23 */
      0, /* mroll/n24 */
      0, /* mroll/n25 */
      0, /* mroll/n26 */
      0, /* mroll/n27 */
      0, /* mroll/n28 */
      0, /* mroll/n29 */
      0, /* mroll/n30 */
      0, /* mroll/n31 */
      0, /* mroll/n32 */
      0, /* mroll/n33 */
      0, /* mroll/n34 */
      0, /* mroll/n35 */
      0, /* mroll/n36 */
      0, /* mroll/n37 */
      0, /* mroll/n38 */
      0, /* mroll/n39 */
      0, /* mroll/n40 */
      0, /* mroll/n41 */
      0, /* mroll/n42 */
      0, /* mroll/n43 */
      0, /* mroll/n44 */
      0, /* mroll/n45 */
      0, /* mroll/n46 */
      0, /* mroll/n47 */
      0, /* mroll/n48 */
      0, /* mroll/n49 */
      0, /* mroll/n50 */
      0, /* mroll/n51 */
      0, /* mroll/n52 */
      0, /* mroll/n53 */
      0, /* mroll/n54 */
      0, /* mroll/n55 */
      0, /* mroll/n56 */
      0, /* mroll/n57 */
      0, /* mroll/n58 */
      0, /* mroll/n59 */
      0, /* mroll/n60 */
      0, /* mroll/n61 */
      0, /* mroll/n62 */
      0, /* mroll/n63 */
      0, /* mroll/n64 */
      0, /* mroll/n65 */
      0, /* mroll/n66 */
      0, /* mroll/n67 */
      0, /* mroll/n68 */
      0, /* mroll/n69 */
      0, /* mroll/n70 */
      0, /* mroll/nR */
      0, /* mrollforth */
      0, /* mrot */
      0, /* mul/%rR/%rR/%rR */
      0, /* mul/%rR/n2/%rR */
      0, /* mul/%rR/nR/%rR */
      0, /* mul/n2/%rR/%rR */
      0, /* mul/n2/n2/%rR */
      0, /* mul/n2/nR/%rR */
      0, /* mul/nR/%rR/%rR */
      0, /* mul/nR/n2/%rR */
      0, /* mul/nR/nR/%rR */
      0 | (1UL << 3), /* mulo/%rR/%rR/%rR/fR */
      0 | (1UL << 2), /* mulo/%rR/n2/%rR/fR */
      0 | (1UL << 3), /* mulo/%rR/nR/%rR/fR */
      0 | (1UL << 3), /* mulo/nR/%rR/%rR/fR */
      0 | (1UL << 2), /* mulo/nR/n2/%rR/fR */
      0 | (1UL << 3), /* mulo/nR/nR/%rR/fR */
      0, /* nop */
      0, /* print-pending-signals/retR */
      0, /* print-topmost/nR/retR */
      0, /* printfixnum/%rR/retR */
      0, /* printfixnum/nR/retR */
      0, /* printufixnum/%rR/retR */
      0, /* printufixnum/nR/retR */
      0 | (1UL << 0), /* procedurecall/fR/retR */
      0, /* procedurecallr/%rR/retR */
      0 | (1UL << 0), /* procedurecallr/lR/retR */
      0, /* procedureprolog */
      0, /* procedurereturn */
      0, /* push-depths/nR/retR */
      0 | (1UL << 0), /* push-handler/n0/lR */
      0 | (1UL << 0), /* push-handler/n1/lR */
      0 | (1UL << 0), /* push-handler/n2/lR */
      0 | (1UL << 0), /* push-handler/n3/lR */
      0 | (1UL << 0), /* push-handler/n4/lR */
      0 | (1UL << 0), /* push-handler/n5/lR */
      0 | (1UL << 0), /* push-handler/n6/lR */
      0 | (1UL << 0), /* push-handler/n7/lR */
      0 | (1UL << 0), /* push-handler/n8/lR */
      0 | (1UL << 0), /* push-handler/n9/lR */
      0 | (1UL << 0), /* push-handler/n10/lR */
      0 | (1UL << 1), /* push-handler/nR/lR */
      0, /* push-increasing/nR/retR */
      0, /* quake */
      0, /* raise/%rR */
      0, /* raise/n0 */
      0, /* raise/n1 */
      0, /* raise/n2 */
      0, /* raise/n3 */
      0, /* raise/n4 */
      0, /* raise/n5 */
      0, /* raise/n6 */
      0, /* raise/n7 */
      0, /* raise/n8 */
      0, /* raise/n9 */
      0, /* raise/n10 */
      0, /* raise/nR */
      0, /* random/%rR/retR */
      0, /* reverse/n0 */
      0, /* reverse/n1 */
      0, /* reverse/n2 */
      0, /* reverse/n3 */
      0, /* reverse/n4 */
      0, /* reverse/n5 */
      0, /* reverse/n6 */
      0, /* reverse/n7 */
      0, /* reverse/n8 */
      0, /* reverse/n9 */
      0, /* reverse/n10 */
      0, /* reverse/n11 */
      0, /* reverse/n12 */
      0, /* reverse/n13 */
      0, /* reverse/n14 */
      0, /* reverse/n15 */
      0, /* reverse/n16 */
      0, /* reverse/n17 */
      0, /* reverse/n18 */
      0, /* reverse/n19 */
      0, /* reverse/n20 */
      0, /* reverse/n21 */
      0, /* reverse/n22 */
      0, /* reverse/n23 */
      0, /* reverse/n24 */
      0, /* reverse/n25 */
      0, /* reverse/n26 */
      0, /* reverse/n27 */
      0, /* reverse/n28 */
      0, /* reverse/n29 */
      0, /* reverse/n30 */
      0, /* reverse/n31 */
      0, /* reverse/n32 */
      0, /* reverse/n33 */
      0, /* reverse/n34 */
      0, /* reverse/n35 */
      0, /* reverse/n36 */
      0, /* reverse/n37 */
      0, /* reverse/n38 */
      0, /* reverse/n39 */
      0, /* reverse/n40 */
      0, /* reverse/n41 */
      0, /* reverse/n42 */
      0, /* reverse/n43 */
      0, /* reverse/n44 */
      0, /* reverse/n45 */
      0, /* reverse/n46 */
      0, /* reverse/n47 */
      0, /* reverse/n48 */
      0, /* reverse/n49 */
      0, /* reverse/n50 */
      0, /* reverse/n51 */
      0, /* reverse/n52 */
      0, /* reverse/n53 */
      0, /* reverse/n54 */
      0, /* reverse/n55 */
      0, /* reverse/n56 */
      0, /* reverse/n57 */
      0, /* reverse/n58 */
      0, /* reverse/n59 */
      0, /* reverse/n60 */
      0, /* reverse/n61 */
      0, /* reverse/n62 */
      0, /* reverse/n63 */
      0, /* reverse/n64 */
      0, /* reverse/n65 */
      0, /* reverse/n66 */
      0, /* reverse/n67 */
      0, /* reverse/n68 */
      0, /* reverse/n69 */
      0, /* reverse/n70 */
      0, /* reverse/nR */
      0, /* roll/n0 */
      0, /* roll/n1 */
      0, /* roll/n2 */
      0, /* roll/n3 */
      0, /* roll/n4 */
      0, /* roll/n5 */
      0, /* roll/n6 */
      0, /* roll/n7 */
      0, /* roll/n8 */
      0, /* roll/n9 */
      0, /* roll/n10 */
      0, /* roll/n11 */
      0, /* roll/n12 */
      0, /* roll/n13 */
      0, /* roll/n14 */
      0, /* roll/n15 */
      0, /* roll/n16 */
      0, /* roll/n17 */
      0, /* roll/n18 */
      0, /* roll/n19 */
      0, /* roll/n20 */
      0, /* roll/n21 */
      0, /* roll/n22 */
      0, /* roll/n23 */
      0, /* roll/n24 */
      0, /* roll/n25 */
      0, /* roll/n26 */
      0, /* roll/n27 */
      0, /* roll/n28 */
      0, /* roll/n29 */
      0, /* roll/n30 */
      0, /* roll/n31 */
      0, /* roll/n32 */
      0, /* roll/n33 */
      0, /* roll/n34 */
      0, /* roll/n35 */
      0, /* roll/n36 */
      0, /* roll/n37 */
      0, /* roll/n38 */
      0, /* roll/n39 */
      0, /* roll/n40 */
      0, /* roll/n41 */
      0, /* roll/n42 */
      0, /* roll/n43 */
      0, /* roll/n44 */
      0, /* roll/n45 */
      0, /* roll/n46 */
      0, /* roll/n47 */
      0, /* roll/n48 */
      0, /* roll/n49 */
      0, /* roll/n50 */
      0, /* roll/n51 */
      0, /* roll/n52 */
      0, /* roll/n53 */
      0, /* roll/n54 */
      0, /* roll/n55 */
      0, /* roll/n56 */
      0, /* roll/n57 */
      0, /* roll/n58 */
      0, /* roll/n59 */
      0, /* roll/n60 */
      0, /* roll/n61 */
      0, /* roll/n62 */
      0, /* roll/n63 */
      0, /* roll/n64 */
      0, /* roll/n65 */
      0, /* roll/n66 */
      0, /* roll/n67 */
      0, /* roll/n68 */
      0, /* roll/n69 */
      0, /* roll/n70 */
      0, /* roll/nR */
      0, /* rollforth */
      0, /* rot */
      0 | (1UL << 0), /* safe-point/fR */
      0, /* set-pending */
      0, /* slide/n1/n1 */
      0, /* slide/n1/n2 */
      0, /* slide/n1/n3 */
      0, /* slide/n1/n4 */
      0, /* slide/n1/n5 */
      0, /* slide/n1/nR */
      0, /* slide/n2/n1 */
      0, /* slide/n2/n2 */
      0, /* slide/n2/n3 */
      0, /* slide/n2/n4 */
      0, /* slide/n2/n5 */
      0, /* slide/n2/nR */
      0, /* slide/n3/n1 */
      0, /* slide/n3/n2 */
      0, /* slide/n3/n3 */
      0, /* slide/n3/n4 */
      0, /* slide/n3/n5 */
      0, /* slide/n3/nR */
      0, /* slide/nR/n1 */
      0, /* slide/nR/n2 */
      0, /* slide/nR/n3 */
      0, /* slide/nR/n4 */
      0, /* slide/nR/n5 */
      0, /* slide/nR/nR */
      0, /* slideforth */
      0, /* stackdrop */
      0, /* stackdup */
      0 | (1UL << 0), /* stackif/fR */
      0, /* stacknip */
      0 | (1UL << 0), /* stacknondroppingif/fR */
      0, /* stacknot */
      0, /* stackoneminus */
      0, /* stackoneplus */
      0, /* stackover */
      0, /* stackpeek/%rR */
      0, /* stackplus */
      0, /* stackplusr/%rR */
      0, /* stackpop/%rR */
      0, /* stackprint/retR */
      0, /* stackpush/%rR */
      0, /* stackpush/n0 */
      0, /* stackpush/n1 */
      0, /* stackpush/nR */
      0 | (1UL << 0), /* stackpush/lR */
      0, /* stackpushunspecified */
      0, /* stackset/%rR */
      0, /* stackset/n0 */
      0, /* stackset/n1 */
      0, /* stackset/nR */
      0 | (1UL << 0), /* stackset/lR */
      0, /* stackswap */
      0, /* stackswaptop/%rR */
      0, /* stacktimes */
      0, /* storewithbyteoffset/%rR/%rR/%rR */
      0, /* storewithbyteoffset/%rR/%rR/n0 */
      0, /* storewithbyteoffset/%rR/%rR/n8 */
      0, /* storewithbyteoffset/%rR/%rR/nR */
      0, /* storewithbyteoffset/nR/%rR/%rR */
      0, /* storewithbyteoffset/nR/%rR/n0 */
      0, /* storewithbyteoffset/nR/%rR/n8 */
      0, /* storewithbyteoffset/nR/%rR/nR */
      0, /* storewithwordoffset/%rR/%rR/%rR */
      0, /* storewithwordoffset/%rR/%rR/n0 */
      0, /* storewithwordoffset/%rR/%rR/n1 */
      0, /* storewithwordoffset/%rR/%rR/n2 */
      0, /* storewithwordoffset/%rR/%rR/nR */
      0, /* storewithwordoffset/nR/%rR/%rR */
      0, /* storewithwordoffset/nR/%rR/n0 */
      0, /* storewithwordoffset/nR/%rR/n1 */
      0, /* storewithwordoffset/nR/%rR/n2 */
      0, /* storewithwordoffset/nR/%rR/nR */
      0, /* sub/%rR/%rR/%rR */
      0, /* sub/%rR/n1/%rR */
      0, /* sub/%rR/nR/%rR */
      0, /* sub/n0/%rR/%rR */
      0, /* sub/n0/n1/%rR */
      0, /* sub/n0/nR/%rR */
      0, /* sub/nR/%rR/%rR */
      0, /* sub/nR/n1/%rR */
      0, /* sub/nR/nR/%rR */
      0 | (1UL << 3), /* subo/%rR/%rR/%rR/fR */
      0 | (1UL << 2), /* subo/%rR/n1/%rR/fR */
      0 | (1UL << 3), /* subo/%rR/nR/%rR/fR */
      0 | (1UL << 3), /* subo/nR/%rR/%rR/fR */
      0 | (1UL << 2), /* subo/nR/n1/%rR/fR */
      0 | (1UL << 3), /* subo/nR/nR/%rR/fR */
      0, /* tuck */
      0, /* unreachable */
      0, /* whirl/n0 */
      0, /* whirl/n1 */
      0, /* whirl/n2 */
      0, /* whirl/n3 */
      0, /* whirl/nR */
      0, /* whirlforth */
      0 | (1UL << 3), /* !REPLACEMENT-addo/%rR/%rR/%rR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-addo/%rR/n1/%rR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-addo/%rR/n-1/%rR/fR/retR */
      0 | (1UL << 3), /* !REPLACEMENT-addo/%rR/nR/%rR/fR/retR */
      0 | (1UL << 3), /* !REPLACEMENT-addo/nR/%rR/%rR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-addo/nR/n1/%rR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-addo/nR/n-1/%rR/fR/retR */
      0 | (1UL << 3), /* !REPLACEMENT-addo/nR/nR/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-b/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-band/%rR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-band/%rR/n3/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-band/%rR/n7/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-band/%rR/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-band/nR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-band/nR/n3/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-band/nR/n7/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-band/nR/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-beq/%rR/%rR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-beq/%rR/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-beq/nR/%rR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-beq/nR/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bge/%rR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bge/%rR/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bge/%rR/n1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bge/%rR/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bge/n0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bge/n0/n0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bge/n0/n1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bge/n0/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bge/n1/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bge/n1/n0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bge/n1/n1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bge/n1/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bge/nR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bge/nR/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bge/nR/n1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bge/nR/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bgeu/%rR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgeu/%rR/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgeu/%rR/n1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bgeu/%rR/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgeu/n0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bgeu/n0/n0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bgeu/n0/n1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgeu/n0/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgeu/n1/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bgeu/n1/n0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bgeu/n1/n1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgeu/n1/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bgeu/nR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgeu/nR/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgeu/nR/n1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bgeu/nR/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bgt/%rR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgt/%rR/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgt/%rR/n1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bgt/%rR/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgt/n0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bgt/n0/n0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bgt/n0/n1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgt/n0/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgt/n1/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bgt/n1/n0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bgt/n1/n1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgt/n1/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bgt/nR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgt/nR/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgt/nR/n1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bgt/nR/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bgtu/%rR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgtu/%rR/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgtu/%rR/n1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bgtu/%rR/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgtu/n0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bgtu/n0/n0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bgtu/n0/n1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgtu/n0/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgtu/n1/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bgtu/n1/n0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bgtu/n1/n1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgtu/n1/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bgtu/nR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgtu/nR/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bgtu/nR/n1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bgtu/nR/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-ble/%rR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-ble/%rR/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-ble/%rR/n1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-ble/%rR/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-ble/n0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-ble/n0/n0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-ble/n0/n1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-ble/n0/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-ble/n1/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-ble/n1/n0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-ble/n1/n1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-ble/n1/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-ble/nR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-ble/nR/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-ble/nR/n1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-ble/nR/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bleu/%rR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bleu/%rR/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bleu/%rR/n1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bleu/%rR/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bleu/n0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bleu/n0/n0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bleu/n0/n1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bleu/n0/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bleu/n1/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bleu/n1/n0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bleu/n1/n1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bleu/n1/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bleu/nR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bleu/nR/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bleu/nR/n1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bleu/nR/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-blt/%rR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-blt/%rR/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-blt/%rR/n1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-blt/%rR/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-blt/n0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-blt/n0/n0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-blt/n0/n1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-blt/n0/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-blt/n1/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-blt/n1/n0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-blt/n1/n1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-blt/n1/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-blt/nR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-blt/nR/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-blt/nR/n1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-blt/nR/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bltu/%rR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bltu/%rR/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bltu/%rR/n1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bltu/%rR/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bltu/n0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bltu/n0/n0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bltu/n0/n1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bltu/n0/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bltu/n1/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bltu/n1/n0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bltu/n1/n1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bltu/n1/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bltu/nR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bltu/nR/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bltu/nR/n1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bltu/nR/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bne/%rR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bne/%rR/n0/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bne/%rR/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bne/n0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bne/n0/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bne/n0/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bne/nR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bne/nR/n0/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bne/nR/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bneg/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bneg/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bnneg/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bnneg/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bnotand/%rR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bnotand/%rR/n3/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bnotand/%rR/n7/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bnotand/%rR/nR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bnotand/nR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bnotand/nR/n3/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bnotand/nR/n7/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bnotand/nR/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bnpos/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bnpos/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bnz/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bnz/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bpos/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bpos/nR/fR/retR */
      0, /* !REPLACEMENT-br/%rR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bz/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bz/nR/fR/retR */
      0 | (1UL << 3), /* !REPLACEMENT-divo/%rR/%rR/%rR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-divo/%rR/n2/%rR/fR/retR */
      0 | (1UL << 3), /* !REPLACEMENT-divo/%rR/nR/%rR/fR/retR */
      0 | (1UL << 3), /* !REPLACEMENT-divo/nR/%rR/%rR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-divo/nR/n2/%rR/fR/retR */
      0 | (1UL << 3), /* !REPLACEMENT-divo/nR/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-endvm/retR */
      0, /* !REPLACEMENT-exitvm/retR */
      0 | (1UL << 3), /* !REPLACEMENT-modo/%rR/%rR/%rR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-modo/%rR/n2/%rR/fR/retR */
      0 | (1UL << 3), /* !REPLACEMENT-modo/%rR/nR/%rR/fR/retR */
      0 | (1UL << 3), /* !REPLACEMENT-modo/nR/%rR/%rR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-modo/nR/n2/%rR/fR/retR */
      0 | (1UL << 3), /* !REPLACEMENT-modo/nR/nR/%rR/fR/retR */
      0 | (1UL << 3), /* !REPLACEMENT-mulo/%rR/%rR/%rR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-mulo/%rR/n2/%rR/fR/retR */
      0 | (1UL << 3), /* !REPLACEMENT-mulo/%rR/nR/%rR/fR/retR */
      0 | (1UL << 3), /* !REPLACEMENT-mulo/nR/%rR/%rR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-mulo/nR/n2/%rR/fR/retR */
      0 | (1UL << 3), /* !REPLACEMENT-mulo/nR/nR/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-procedurecall/fR/retR */
      0, /* !REPLACEMENT-procedurecallr/%rR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-procedurecallr/lR/retR */
      0, /* !REPLACEMENT-procedureprolog/retR */
      0, /* !REPLACEMENT-procedurereturn/retR */
      0, /* !REPLACEMENT-raise/%rR/retR */
      0, /* !REPLACEMENT-raise/n0/retR */
      0, /* !REPLACEMENT-raise/n1/retR */
      0, /* !REPLACEMENT-raise/n2/retR */
      0, /* !REPLACEMENT-raise/n3/retR */
      0, /* !REPLACEMENT-raise/n4/retR */
      0, /* !REPLACEMENT-raise/n5/retR */
      0, /* !REPLACEMENT-raise/n6/retR */
      0, /* !REPLACEMENT-raise/n7/retR */
      0, /* !REPLACEMENT-raise/n8/retR */
      0, /* !REPLACEMENT-raise/n9/retR */
      0, /* !REPLACEMENT-raise/n10/retR */
      0, /* !REPLACEMENT-raise/nR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-safe-point/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-stackif/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-stacknondroppingif/fR/retR */
      0 | (1UL << 3), /* !REPLACEMENT-subo/%rR/%rR/%rR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-subo/%rR/n1/%rR/fR/retR */
      0 | (1UL << 3), /* !REPLACEMENT-subo/%rR/nR/%rR/fR/retR */
      0 | (1UL << 3), /* !REPLACEMENT-subo/nR/%rR/%rR/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-subo/nR/n1/%rR/fR/retR */
      0 | (1UL << 3), /* !REPLACEMENT-subo/nR/nR/%rR/fR/retR */
      0 /* !REPLACEMENT-unreachable/retR */
    };
#ifdef JITTER_HAVE_PATCH_IN
const unsigned long // FIXME: shall I use a shorter type when possible?
uninspired_specialized_instruction_fast_label_bitmasks [UNINSPIRED_SPECIALIZED_INSTRUCTION_NO]
  = {
      /* It's important that !BEGINBASICBLOCK has a zero here: it does not need residual patching. */
      0, /* !INVALID */
      0, /* !BEGINBASICBLOCK */
      0, /* !EXITVM */
      0, /* !DATALOCATIONS */
      0, /* !NOP */
      0, /* !UNREACHABLE0 */
      0, /* !UNREACHABLE1 */
      0, /* !PRETENDTOJUMPANYWHERE */
      0, /* add/%rR/%rR/%rR */
      0, /* add/%rR/n1/%rR */
      0, /* add/%rR/n-1/%rR */
      0, /* add/%rR/nR/%rR */
      0, /* add/n1/%rR/%rR */
      0, /* add/n1/n1/%rR */
      0, /* add/n1/n-1/%rR */
      0, /* add/n1/nR/%rR */
      0, /* add/n-1/%rR/%rR */
      0, /* add/n-1/n1/%rR */
      0, /* add/n-1/n-1/%rR */
      0, /* add/n-1/nR/%rR */
      0, /* add/nR/%rR/%rR */
      0, /* add/nR/n1/%rR */
      0, /* add/nR/n-1/%rR */
      0, /* add/nR/nR/%rR */
      0 | (1UL << 3), /* addo/%rR/%rR/%rR/fR */
      0 | (1UL << 2), /* addo/%rR/n1/%rR/fR */
      0 | (1UL << 2), /* addo/%rR/n-1/%rR/fR */
      0 | (1UL << 3), /* addo/%rR/nR/%rR/fR */
      0 | (1UL << 3), /* addo/nR/%rR/%rR/fR */
      0 | (1UL << 2), /* addo/nR/n1/%rR/fR */
      0 | (1UL << 2), /* addo/nR/n-1/%rR/fR */
      0 | (1UL << 3), /* addo/nR/nR/%rR/fR */
      0 | (1UL << 0), /* b/fR */
      0 | (1UL << 2), /* band/%rR/%rR/fR */
      0 | (1UL << 1), /* band/%rR/n3/fR */
      0 | (1UL << 1), /* band/%rR/n7/fR */
      0 | (1UL << 2), /* band/%rR/nR/fR */
      0 | (1UL << 2), /* band/nR/%rR/fR */
      0 | (1UL << 1), /* band/nR/n3/fR */
      0 | (1UL << 1), /* band/nR/n7/fR */
      0 | (1UL << 2), /* band/nR/nR/fR */
      0 | (1UL << 2), /* beq/%rR/%rR/fR */
      0 | (1UL << 2), /* beq/%rR/nR/fR */
      0 | (1UL << 2), /* beq/nR/%rR/fR */
      0 | (1UL << 2), /* beq/nR/nR/fR */
      0 | (1UL << 2), /* bge/%rR/%rR/fR */
      0 | (1UL << 1), /* bge/%rR/n0/fR */
      0 | (1UL << 1), /* bge/%rR/n1/fR */
      0 | (1UL << 2), /* bge/%rR/nR/fR */
      0 | (1UL << 1), /* bge/n0/%rR/fR */
      0 | (1UL << 0), /* bge/n0/n0/fR */
      0 | (1UL << 0), /* bge/n0/n1/fR */
      0 | (1UL << 1), /* bge/n0/nR/fR */
      0 | (1UL << 1), /* bge/n1/%rR/fR */
      0 | (1UL << 0), /* bge/n1/n0/fR */
      0 | (1UL << 0), /* bge/n1/n1/fR */
      0 | (1UL << 1), /* bge/n1/nR/fR */
      0 | (1UL << 2), /* bge/nR/%rR/fR */
      0 | (1UL << 1), /* bge/nR/n0/fR */
      0 | (1UL << 1), /* bge/nR/n1/fR */
      0 | (1UL << 2), /* bge/nR/nR/fR */
      0 | (1UL << 2), /* bgeu/%rR/%rR/fR */
      0 | (1UL << 1), /* bgeu/%rR/n0/fR */
      0 | (1UL << 1), /* bgeu/%rR/n1/fR */
      0 | (1UL << 2), /* bgeu/%rR/nR/fR */
      0 | (1UL << 1), /* bgeu/n0/%rR/fR */
      0 | (1UL << 0), /* bgeu/n0/n0/fR */
      0 | (1UL << 0), /* bgeu/n0/n1/fR */
      0 | (1UL << 1), /* bgeu/n0/nR/fR */
      0 | (1UL << 1), /* bgeu/n1/%rR/fR */
      0 | (1UL << 0), /* bgeu/n1/n0/fR */
      0 | (1UL << 0), /* bgeu/n1/n1/fR */
      0 | (1UL << 1), /* bgeu/n1/nR/fR */
      0 | (1UL << 2), /* bgeu/nR/%rR/fR */
      0 | (1UL << 1), /* bgeu/nR/n0/fR */
      0 | (1UL << 1), /* bgeu/nR/n1/fR */
      0 | (1UL << 2), /* bgeu/nR/nR/fR */
      0 | (1UL << 2), /* bgt/%rR/%rR/fR */
      0 | (1UL << 1), /* bgt/%rR/n0/fR */
      0 | (1UL << 1), /* bgt/%rR/n1/fR */
      0 | (1UL << 2), /* bgt/%rR/nR/fR */
      0 | (1UL << 1), /* bgt/n0/%rR/fR */
      0 | (1UL << 0), /* bgt/n0/n0/fR */
      0 | (1UL << 0), /* bgt/n0/n1/fR */
      0 | (1UL << 1), /* bgt/n0/nR/fR */
      0 | (1UL << 1), /* bgt/n1/%rR/fR */
      0 | (1UL << 0), /* bgt/n1/n0/fR */
      0 | (1UL << 0), /* bgt/n1/n1/fR */
      0 | (1UL << 1), /* bgt/n1/nR/fR */
      0 | (1UL << 2), /* bgt/nR/%rR/fR */
      0 | (1UL << 1), /* bgt/nR/n0/fR */
      0 | (1UL << 1), /* bgt/nR/n1/fR */
      0 | (1UL << 2), /* bgt/nR/nR/fR */
      0 | (1UL << 2), /* bgtu/%rR/%rR/fR */
      0 | (1UL << 1), /* bgtu/%rR/n0/fR */
      0 | (1UL << 1), /* bgtu/%rR/n1/fR */
      0 | (1UL << 2), /* bgtu/%rR/nR/fR */
      0 | (1UL << 1), /* bgtu/n0/%rR/fR */
      0 | (1UL << 0), /* bgtu/n0/n0/fR */
      0 | (1UL << 0), /* bgtu/n0/n1/fR */
      0 | (1UL << 1), /* bgtu/n0/nR/fR */
      0 | (1UL << 1), /* bgtu/n1/%rR/fR */
      0 | (1UL << 0), /* bgtu/n1/n0/fR */
      0 | (1UL << 0), /* bgtu/n1/n1/fR */
      0 | (1UL << 1), /* bgtu/n1/nR/fR */
      0 | (1UL << 2), /* bgtu/nR/%rR/fR */
      0 | (1UL << 1), /* bgtu/nR/n0/fR */
      0 | (1UL << 1), /* bgtu/nR/n1/fR */
      0 | (1UL << 2), /* bgtu/nR/nR/fR */
      0 | (1UL << 2), /* ble/%rR/%rR/fR */
      0 | (1UL << 1), /* ble/%rR/n0/fR */
      0 | (1UL << 1), /* ble/%rR/n1/fR */
      0 | (1UL << 2), /* ble/%rR/nR/fR */
      0 | (1UL << 1), /* ble/n0/%rR/fR */
      0 | (1UL << 0), /* ble/n0/n0/fR */
      0 | (1UL << 0), /* ble/n0/n1/fR */
      0 | (1UL << 1), /* ble/n0/nR/fR */
      0 | (1UL << 1), /* ble/n1/%rR/fR */
      0 | (1UL << 0), /* ble/n1/n0/fR */
      0 | (1UL << 0), /* ble/n1/n1/fR */
      0 | (1UL << 1), /* ble/n1/nR/fR */
      0 | (1UL << 2), /* ble/nR/%rR/fR */
      0 | (1UL << 1), /* ble/nR/n0/fR */
      0 | (1UL << 1), /* ble/nR/n1/fR */
      0 | (1UL << 2), /* ble/nR/nR/fR */
      0 | (1UL << 2), /* bleu/%rR/%rR/fR */
      0 | (1UL << 1), /* bleu/%rR/n0/fR */
      0 | (1UL << 1), /* bleu/%rR/n1/fR */
      0 | (1UL << 2), /* bleu/%rR/nR/fR */
      0 | (1UL << 1), /* bleu/n0/%rR/fR */
      0 | (1UL << 0), /* bleu/n0/n0/fR */
      0 | (1UL << 0), /* bleu/n0/n1/fR */
      0 | (1UL << 1), /* bleu/n0/nR/fR */
      0 | (1UL << 1), /* bleu/n1/%rR/fR */
      0 | (1UL << 0), /* bleu/n1/n0/fR */
      0 | (1UL << 0), /* bleu/n1/n1/fR */
      0 | (1UL << 1), /* bleu/n1/nR/fR */
      0 | (1UL << 2), /* bleu/nR/%rR/fR */
      0 | (1UL << 1), /* bleu/nR/n0/fR */
      0 | (1UL << 1), /* bleu/nR/n1/fR */
      0 | (1UL << 2), /* bleu/nR/nR/fR */
      0 | (1UL << 2), /* blt/%rR/%rR/fR */
      0 | (1UL << 1), /* blt/%rR/n0/fR */
      0 | (1UL << 1), /* blt/%rR/n1/fR */
      0 | (1UL << 2), /* blt/%rR/nR/fR */
      0 | (1UL << 1), /* blt/n0/%rR/fR */
      0 | (1UL << 0), /* blt/n0/n0/fR */
      0 | (1UL << 0), /* blt/n0/n1/fR */
      0 | (1UL << 1), /* blt/n0/nR/fR */
      0 | (1UL << 1), /* blt/n1/%rR/fR */
      0 | (1UL << 0), /* blt/n1/n0/fR */
      0 | (1UL << 0), /* blt/n1/n1/fR */
      0 | (1UL << 1), /* blt/n1/nR/fR */
      0 | (1UL << 2), /* blt/nR/%rR/fR */
      0 | (1UL << 1), /* blt/nR/n0/fR */
      0 | (1UL << 1), /* blt/nR/n1/fR */
      0 | (1UL << 2), /* blt/nR/nR/fR */
      0 | (1UL << 2), /* bltu/%rR/%rR/fR */
      0 | (1UL << 1), /* bltu/%rR/n0/fR */
      0 | (1UL << 1), /* bltu/%rR/n1/fR */
      0 | (1UL << 2), /* bltu/%rR/nR/fR */
      0 | (1UL << 1), /* bltu/n0/%rR/fR */
      0 | (1UL << 0), /* bltu/n0/n0/fR */
      0 | (1UL << 0), /* bltu/n0/n1/fR */
      0 | (1UL << 1), /* bltu/n0/nR/fR */
      0 | (1UL << 1), /* bltu/n1/%rR/fR */
      0 | (1UL << 0), /* bltu/n1/n0/fR */
      0 | (1UL << 0), /* bltu/n1/n1/fR */
      0 | (1UL << 1), /* bltu/n1/nR/fR */
      0 | (1UL << 2), /* bltu/nR/%rR/fR */
      0 | (1UL << 1), /* bltu/nR/n0/fR */
      0 | (1UL << 1), /* bltu/nR/n1/fR */
      0 | (1UL << 2), /* bltu/nR/nR/fR */
      0 | (1UL << 2), /* bne/%rR/%rR/fR */
      0 | (1UL << 1), /* bne/%rR/n0/fR */
      0 | (1UL << 2), /* bne/%rR/nR/fR */
      0 | (1UL << 1), /* bne/n0/%rR/fR */
      0 | (1UL << 0), /* bne/n0/n0/fR */
      0 | (1UL << 1), /* bne/n0/nR/fR */
      0 | (1UL << 2), /* bne/nR/%rR/fR */
      0 | (1UL << 1), /* bne/nR/n0/fR */
      0 | (1UL << 2), /* bne/nR/nR/fR */
      0 | (1UL << 1), /* bneg/%rR/fR */
      0 | (1UL << 1), /* bneg/nR/fR */
      0 | (1UL << 1), /* bnneg/%rR/fR */
      0 | (1UL << 1), /* bnneg/nR/fR */
      0 | (1UL << 2), /* bnotand/%rR/%rR/fR */
      0 | (1UL << 1), /* bnotand/%rR/n3/fR */
      0 | (1UL << 1), /* bnotand/%rR/n7/fR */
      0 | (1UL << 2), /* bnotand/%rR/nR/fR */
      0 | (1UL << 2), /* bnotand/nR/%rR/fR */
      0 | (1UL << 1), /* bnotand/nR/n3/fR */
      0 | (1UL << 1), /* bnotand/nR/n7/fR */
      0 | (1UL << 2), /* bnotand/nR/nR/fR */
      0 | (1UL << 1), /* bnpos/%rR/fR */
      0 | (1UL << 1), /* bnpos/nR/fR */
      0 | (1UL << 1), /* bnz/%rR/fR */
      0 | (1UL << 1), /* bnz/nR/fR */
      0 | (1UL << 1), /* bpos/%rR/fR */
      0 | (1UL << 1), /* bpos/nR/fR */
      0, /* br/%rR */
      0, /* bulge/n0 */
      0, /* bulge/n1 */
      0, /* bulge/n2 */
      0, /* bulge/n3 */
      0, /* bulge/nR */
      0, /* bulgeforth */
      0 | (1UL << 1), /* bz/%rR/fR */
      0 | (1UL << 1), /* bz/nR/fR */
      0, /* clear-pending/retR */
      0, /* div/%rR/%rR/%rR/retR */
      0, /* div/%rR/n2/%rR/retR */
      0, /* div/%rR/nR/%rR/retR */
      0, /* div/nR/%rR/%rR/retR */
      0, /* div/nR/n2/%rR/retR */
      0, /* div/nR/nR/%rR/retR */
      0 | (1UL << 3), /* divo/%rR/%rR/%rR/fR */
      0 | (1UL << 2), /* divo/%rR/n2/%rR/fR */
      0 | (1UL << 3), /* divo/%rR/nR/%rR/fR */
      0 | (1UL << 3), /* divo/nR/%rR/%rR/fR */
      0 | (1UL << 2), /* divo/nR/n2/%rR/fR */
      0 | (1UL << 3), /* divo/nR/nR/%rR/fR */
      0, /* drop-handler */
      0, /* endvm */
      0, /* exit/%rR/retR */
      0, /* exit/nR/retR */
      0, /* exitvm */
      0, /* fadd/%fR/%fR/%fR */
      0, /* fdiv/%fR/%fR/%fR */
      0, /* fincr/%fR */
      0, /* fmul/%fR/%fR/%fR */
      0, /* fprint/%fR */
      0, /* fset/%rR/%fR */
      0, /* fset/nR/%fR */
      0, /* fsub/%fR/%fR/%fR */
      0, /* hcf/retR */
      0, /* install-signal-handler/retR */
      0, /* loadwithbyteoffset/%rR/%rR/%rR */
      0, /* loadwithbyteoffset/%rR/n0/%rR */
      0, /* loadwithbyteoffset/%rR/n8/%rR */
      0, /* loadwithbyteoffset/%rR/nR/%rR */
      0, /* loadwithwordoffset/%rR/%rR/%rR */
      0, /* loadwithwordoffset/%rR/n0/%rR */
      0, /* loadwithwordoffset/%rR/n1/%rR */
      0, /* loadwithwordoffset/%rR/n2/%rR */
      0, /* loadwithwordoffset/%rR/nR/%rR */
      0, /* mallocwords/%rR/%rR/retR */
      0, /* mallocwords/nR/%rR/retR */
      0, /* mod/%rR/%rR/%rR/retR */
      0, /* mod/%rR/n2/%rR/retR */
      0, /* mod/%rR/nR/%rR/retR */
      0, /* mod/nR/%rR/%rR/retR */
      0, /* mod/nR/n2/%rR/retR */
      0, /* mod/nR/nR/%rR/retR */
      0 | (1UL << 3), /* modo/%rR/%rR/%rR/fR */
      0 | (1UL << 2), /* modo/%rR/n2/%rR/fR */
      0 | (1UL << 3), /* modo/%rR/nR/%rR/fR */
      0 | (1UL << 3), /* modo/nR/%rR/%rR/fR */
      0 | (1UL << 2), /* modo/nR/n2/%rR/fR */
      0 | (1UL << 3), /* modo/nR/nR/%rR/fR */
      0, /* mov/%rR/%rR */
      0, /* mov/n0/%rR */
      0, /* mov/n1/%rR */
      0, /* mov/nR/%rR */
      0, /* mov/lR/%rR */
      0, /* mroll/n0 */
      0, /* mroll/n1 */
      0, /* mroll/n2 */
      0, /* mroll/n3 */
      0, /* mroll/n4 */
      0, /* mroll/n5 */
      0, /* mroll/n6 */
      0, /* mroll/n7 */
      0, /* mroll/n8 */
      0, /* mroll/n9 */
      0, /* mroll/n10 */
      0, /* mroll/n11 */
      0, /* mroll/n12 */
      0, /* mroll/n13 */
      0, /* mroll/n14 */
      0, /* mroll/n15 */
      0, /* mroll/n16 */
      0, /* mroll/n17 */
      0, /* mroll/n18 */
      0, /* mroll/n19 */
      0, /* mroll/n20 */
      0, /* mroll/n21 */
      0, /* mroll/n22 */
      0, /* mroll/n23 */
      0, /* mroll/n24 */
      0, /* mroll/n25 */
      0, /* mroll/n26 */
      0, /* mroll/n27 */
      0, /* mroll/n28 */
      0, /* mroll/n29 */
      0, /* mroll/n30 */
      0, /* mroll/n31 */
      0, /* mroll/n32 */
      0, /* mroll/n33 */
      0, /* mroll/n34 */
      0, /* mroll/n35 */
      0, /* mroll/n36 */
      0, /* mroll/n37 */
      0, /* mroll/n38 */
      0, /* mroll/n39 */
      0, /* mroll/n40 */
      0, /* mroll/n41 */
      0, /* mroll/n42 */
      0, /* mroll/n43 */
      0, /* mroll/n44 */
      0, /* mroll/n45 */
      0, /* mroll/n46 */
      0, /* mroll/n47 */
      0, /* mroll/n48 */
      0, /* mroll/n49 */
      0, /* mroll/n50 */
      0, /* mroll/n51 */
      0, /* mroll/n52 */
      0, /* mroll/n53 */
      0, /* mroll/n54 */
      0, /* mroll/n55 */
      0, /* mroll/n56 */
      0, /* mroll/n57 */
      0, /* mroll/n58 */
      0, /* mroll/n59 */
      0, /* mroll/n60 */
      0, /* mroll/n61 */
      0, /* mroll/n62 */
      0, /* mroll/n63 */
      0, /* mroll/n64 */
      0, /* mroll/n65 */
      0, /* mroll/n66 */
      0, /* mroll/n67 */
      0, /* mroll/n68 */
      0, /* mroll/n69 */
      0, /* mroll/n70 */
      0, /* mroll/nR */
      0, /* mrollforth */
      0, /* mrot */
      0, /* mul/%rR/%rR/%rR */
      0, /* mul/%rR/n2/%rR */
      0, /* mul/%rR/nR/%rR */
      0, /* mul/n2/%rR/%rR */
      0, /* mul/n2/n2/%rR */
      0, /* mul/n2/nR/%rR */
      0, /* mul/nR/%rR/%rR */
      0, /* mul/nR/n2/%rR */
      0, /* mul/nR/nR/%rR */
      0 | (1UL << 3), /* mulo/%rR/%rR/%rR/fR */
      0 | (1UL << 2), /* mulo/%rR/n2/%rR/fR */
      0 | (1UL << 3), /* mulo/%rR/nR/%rR/fR */
      0 | (1UL << 3), /* mulo/nR/%rR/%rR/fR */
      0 | (1UL << 2), /* mulo/nR/n2/%rR/fR */
      0 | (1UL << 3), /* mulo/nR/nR/%rR/fR */
      0, /* nop */
      0, /* print-pending-signals/retR */
      0, /* print-topmost/nR/retR */
      0, /* printfixnum/%rR/retR */
      0, /* printfixnum/nR/retR */
      0, /* printufixnum/%rR/retR */
      0, /* printufixnum/nR/retR */
      0 | (1UL << 0), /* procedurecall/fR/retR */
      0, /* procedurecallr/%rR/retR */
      0, /* procedurecallr/lR/retR */
      0, /* procedureprolog */
      0, /* procedurereturn */
      0, /* push-depths/nR/retR */
      0, /* push-handler/n0/lR */
      0, /* push-handler/n1/lR */
      0, /* push-handler/n2/lR */
      0, /* push-handler/n3/lR */
      0, /* push-handler/n4/lR */
      0, /* push-handler/n5/lR */
      0, /* push-handler/n6/lR */
      0, /* push-handler/n7/lR */
      0, /* push-handler/n8/lR */
      0, /* push-handler/n9/lR */
      0, /* push-handler/n10/lR */
      0, /* push-handler/nR/lR */
      0, /* push-increasing/nR/retR */
      0, /* quake */
      0, /* raise/%rR */
      0, /* raise/n0 */
      0, /* raise/n1 */
      0, /* raise/n2 */
      0, /* raise/n3 */
      0, /* raise/n4 */
      0, /* raise/n5 */
      0, /* raise/n6 */
      0, /* raise/n7 */
      0, /* raise/n8 */
      0, /* raise/n9 */
      0, /* raise/n10 */
      0, /* raise/nR */
      0, /* random/%rR/retR */
      0, /* reverse/n0 */
      0, /* reverse/n1 */
      0, /* reverse/n2 */
      0, /* reverse/n3 */
      0, /* reverse/n4 */
      0, /* reverse/n5 */
      0, /* reverse/n6 */
      0, /* reverse/n7 */
      0, /* reverse/n8 */
      0, /* reverse/n9 */
      0, /* reverse/n10 */
      0, /* reverse/n11 */
      0, /* reverse/n12 */
      0, /* reverse/n13 */
      0, /* reverse/n14 */
      0, /* reverse/n15 */
      0, /* reverse/n16 */
      0, /* reverse/n17 */
      0, /* reverse/n18 */
      0, /* reverse/n19 */
      0, /* reverse/n20 */
      0, /* reverse/n21 */
      0, /* reverse/n22 */
      0, /* reverse/n23 */
      0, /* reverse/n24 */
      0, /* reverse/n25 */
      0, /* reverse/n26 */
      0, /* reverse/n27 */
      0, /* reverse/n28 */
      0, /* reverse/n29 */
      0, /* reverse/n30 */
      0, /* reverse/n31 */
      0, /* reverse/n32 */
      0, /* reverse/n33 */
      0, /* reverse/n34 */
      0, /* reverse/n35 */
      0, /* reverse/n36 */
      0, /* reverse/n37 */
      0, /* reverse/n38 */
      0, /* reverse/n39 */
      0, /* reverse/n40 */
      0, /* reverse/n41 */
      0, /* reverse/n42 */
      0, /* reverse/n43 */
      0, /* reverse/n44 */
      0, /* reverse/n45 */
      0, /* reverse/n46 */
      0, /* reverse/n47 */
      0, /* reverse/n48 */
      0, /* reverse/n49 */
      0, /* reverse/n50 */
      0, /* reverse/n51 */
      0, /* reverse/n52 */
      0, /* reverse/n53 */
      0, /* reverse/n54 */
      0, /* reverse/n55 */
      0, /* reverse/n56 */
      0, /* reverse/n57 */
      0, /* reverse/n58 */
      0, /* reverse/n59 */
      0, /* reverse/n60 */
      0, /* reverse/n61 */
      0, /* reverse/n62 */
      0, /* reverse/n63 */
      0, /* reverse/n64 */
      0, /* reverse/n65 */
      0, /* reverse/n66 */
      0, /* reverse/n67 */
      0, /* reverse/n68 */
      0, /* reverse/n69 */
      0, /* reverse/n70 */
      0, /* reverse/nR */
      0, /* roll/n0 */
      0, /* roll/n1 */
      0, /* roll/n2 */
      0, /* roll/n3 */
      0, /* roll/n4 */
      0, /* roll/n5 */
      0, /* roll/n6 */
      0, /* roll/n7 */
      0, /* roll/n8 */
      0, /* roll/n9 */
      0, /* roll/n10 */
      0, /* roll/n11 */
      0, /* roll/n12 */
      0, /* roll/n13 */
      0, /* roll/n14 */
      0, /* roll/n15 */
      0, /* roll/n16 */
      0, /* roll/n17 */
      0, /* roll/n18 */
      0, /* roll/n19 */
      0, /* roll/n20 */
      0, /* roll/n21 */
      0, /* roll/n22 */
      0, /* roll/n23 */
      0, /* roll/n24 */
      0, /* roll/n25 */
      0, /* roll/n26 */
      0, /* roll/n27 */
      0, /* roll/n28 */
      0, /* roll/n29 */
      0, /* roll/n30 */
      0, /* roll/n31 */
      0, /* roll/n32 */
      0, /* roll/n33 */
      0, /* roll/n34 */
      0, /* roll/n35 */
      0, /* roll/n36 */
      0, /* roll/n37 */
      0, /* roll/n38 */
      0, /* roll/n39 */
      0, /* roll/n40 */
      0, /* roll/n41 */
      0, /* roll/n42 */
      0, /* roll/n43 */
      0, /* roll/n44 */
      0, /* roll/n45 */
      0, /* roll/n46 */
      0, /* roll/n47 */
      0, /* roll/n48 */
      0, /* roll/n49 */
      0, /* roll/n50 */
      0, /* roll/n51 */
      0, /* roll/n52 */
      0, /* roll/n53 */
      0, /* roll/n54 */
      0, /* roll/n55 */
      0, /* roll/n56 */
      0, /* roll/n57 */
      0, /* roll/n58 */
      0, /* roll/n59 */
      0, /* roll/n60 */
      0, /* roll/n61 */
      0, /* roll/n62 */
      0, /* roll/n63 */
      0, /* roll/n64 */
      0, /* roll/n65 */
      0, /* roll/n66 */
      0, /* roll/n67 */
      0, /* roll/n68 */
      0, /* roll/n69 */
      0, /* roll/n70 */
      0, /* roll/nR */
      0, /* rollforth */
      0, /* rot */
      0 | (1UL << 0), /* safe-point/fR */
      0, /* set-pending */
      0, /* slide/n1/n1 */
      0, /* slide/n1/n2 */
      0, /* slide/n1/n3 */
      0, /* slide/n1/n4 */
      0, /* slide/n1/n5 */
      0, /* slide/n1/nR */
      0, /* slide/n2/n1 */
      0, /* slide/n2/n2 */
      0, /* slide/n2/n3 */
      0, /* slide/n2/n4 */
      0, /* slide/n2/n5 */
      0, /* slide/n2/nR */
      0, /* slide/n3/n1 */
      0, /* slide/n3/n2 */
      0, /* slide/n3/n3 */
      0, /* slide/n3/n4 */
      0, /* slide/n3/n5 */
      0, /* slide/n3/nR */
      0, /* slide/nR/n1 */
      0, /* slide/nR/n2 */
      0, /* slide/nR/n3 */
      0, /* slide/nR/n4 */
      0, /* slide/nR/n5 */
      0, /* slide/nR/nR */
      0, /* slideforth */
      0, /* stackdrop */
      0, /* stackdup */
      0 | (1UL << 0), /* stackif/fR */
      0, /* stacknip */
      0 | (1UL << 0), /* stacknondroppingif/fR */
      0, /* stacknot */
      0, /* stackoneminus */
      0, /* stackoneplus */
      0, /* stackover */
      0, /* stackpeek/%rR */
      0, /* stackplus */
      0, /* stackplusr/%rR */
      0, /* stackpop/%rR */
      0, /* stackprint/retR */
      0, /* stackpush/%rR */
      0, /* stackpush/n0 */
      0, /* stackpush/n1 */
      0, /* stackpush/nR */
      0, /* stackpush/lR */
      0, /* stackpushunspecified */
      0, /* stackset/%rR */
      0, /* stackset/n0 */
      0, /* stackset/n1 */
      0, /* stackset/nR */
      0, /* stackset/lR */
      0, /* stackswap */
      0, /* stackswaptop/%rR */
      0, /* stacktimes */
      0, /* storewithbyteoffset/%rR/%rR/%rR */
      0, /* storewithbyteoffset/%rR/%rR/n0 */
      0, /* storewithbyteoffset/%rR/%rR/n8 */
      0, /* storewithbyteoffset/%rR/%rR/nR */
      0, /* storewithbyteoffset/nR/%rR/%rR */
      0, /* storewithbyteoffset/nR/%rR/n0 */
      0, /* storewithbyteoffset/nR/%rR/n8 */
      0, /* storewithbyteoffset/nR/%rR/nR */
      0, /* storewithwordoffset/%rR/%rR/%rR */
      0, /* storewithwordoffset/%rR/%rR/n0 */
      0, /* storewithwordoffset/%rR/%rR/n1 */
      0, /* storewithwordoffset/%rR/%rR/n2 */
      0, /* storewithwordoffset/%rR/%rR/nR */
      0, /* storewithwordoffset/nR/%rR/%rR */
      0, /* storewithwordoffset/nR/%rR/n0 */
      0, /* storewithwordoffset/nR/%rR/n1 */
      0, /* storewithwordoffset/nR/%rR/n2 */
      0, /* storewithwordoffset/nR/%rR/nR */
      0, /* sub/%rR/%rR/%rR */
      0, /* sub/%rR/n1/%rR */
      0, /* sub/%rR/nR/%rR */
      0, /* sub/n0/%rR/%rR */
      0, /* sub/n0/n1/%rR */
      0, /* sub/n0/nR/%rR */
      0, /* sub/nR/%rR/%rR */
      0, /* sub/nR/n1/%rR */
      0, /* sub/nR/nR/%rR */
      0 | (1UL << 3), /* subo/%rR/%rR/%rR/fR */
      0 | (1UL << 2), /* subo/%rR/n1/%rR/fR */
      0 | (1UL << 3), /* subo/%rR/nR/%rR/fR */
      0 | (1UL << 3), /* subo/nR/%rR/%rR/fR */
      0 | (1UL << 2), /* subo/nR/n1/%rR/fR */
      0 | (1UL << 3), /* subo/nR/nR/%rR/fR */
      0, /* tuck */
      0, /* unreachable */
      0, /* whirl/n0 */
      0, /* whirl/n1 */
      0, /* whirl/n2 */
      0, /* whirl/n3 */
      0, /* whirl/nR */
      0, /* whirlforth */
      0, /* !REPLACEMENT-addo/%rR/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-addo/%rR/n1/%rR/fR/retR */
      0, /* !REPLACEMENT-addo/%rR/n-1/%rR/fR/retR */
      0, /* !REPLACEMENT-addo/%rR/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-addo/nR/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-addo/nR/n1/%rR/fR/retR */
      0, /* !REPLACEMENT-addo/nR/n-1/%rR/fR/retR */
      0, /* !REPLACEMENT-addo/nR/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-b/fR/retR */
      0, /* !REPLACEMENT-band/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-band/%rR/n3/fR/retR */
      0, /* !REPLACEMENT-band/%rR/n7/fR/retR */
      0, /* !REPLACEMENT-band/%rR/nR/fR/retR */
      0, /* !REPLACEMENT-band/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-band/nR/n3/fR/retR */
      0, /* !REPLACEMENT-band/nR/n7/fR/retR */
      0, /* !REPLACEMENT-band/nR/nR/fR/retR */
      0, /* !REPLACEMENT-beq/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-beq/%rR/nR/fR/retR */
      0, /* !REPLACEMENT-beq/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-beq/nR/nR/fR/retR */
      0, /* !REPLACEMENT-bge/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-bge/%rR/n0/fR/retR */
      0, /* !REPLACEMENT-bge/%rR/n1/fR/retR */
      0, /* !REPLACEMENT-bge/%rR/nR/fR/retR */
      0, /* !REPLACEMENT-bge/n0/%rR/fR/retR */
      0, /* !REPLACEMENT-bge/n0/n0/fR/retR */
      0, /* !REPLACEMENT-bge/n0/n1/fR/retR */
      0, /* !REPLACEMENT-bge/n0/nR/fR/retR */
      0, /* !REPLACEMENT-bge/n1/%rR/fR/retR */
      0, /* !REPLACEMENT-bge/n1/n0/fR/retR */
      0, /* !REPLACEMENT-bge/n1/n1/fR/retR */
      0, /* !REPLACEMENT-bge/n1/nR/fR/retR */
      0, /* !REPLACEMENT-bge/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-bge/nR/n0/fR/retR */
      0, /* !REPLACEMENT-bge/nR/n1/fR/retR */
      0, /* !REPLACEMENT-bge/nR/nR/fR/retR */
      0, /* !REPLACEMENT-bgeu/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-bgeu/%rR/n0/fR/retR */
      0, /* !REPLACEMENT-bgeu/%rR/n1/fR/retR */
      0, /* !REPLACEMENT-bgeu/%rR/nR/fR/retR */
      0, /* !REPLACEMENT-bgeu/n0/%rR/fR/retR */
      0, /* !REPLACEMENT-bgeu/n0/n0/fR/retR */
      0, /* !REPLACEMENT-bgeu/n0/n1/fR/retR */
      0, /* !REPLACEMENT-bgeu/n0/nR/fR/retR */
      0, /* !REPLACEMENT-bgeu/n1/%rR/fR/retR */
      0, /* !REPLACEMENT-bgeu/n1/n0/fR/retR */
      0, /* !REPLACEMENT-bgeu/n1/n1/fR/retR */
      0, /* !REPLACEMENT-bgeu/n1/nR/fR/retR */
      0, /* !REPLACEMENT-bgeu/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-bgeu/nR/n0/fR/retR */
      0, /* !REPLACEMENT-bgeu/nR/n1/fR/retR */
      0, /* !REPLACEMENT-bgeu/nR/nR/fR/retR */
      0, /* !REPLACEMENT-bgt/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-bgt/%rR/n0/fR/retR */
      0, /* !REPLACEMENT-bgt/%rR/n1/fR/retR */
      0, /* !REPLACEMENT-bgt/%rR/nR/fR/retR */
      0, /* !REPLACEMENT-bgt/n0/%rR/fR/retR */
      0, /* !REPLACEMENT-bgt/n0/n0/fR/retR */
      0, /* !REPLACEMENT-bgt/n0/n1/fR/retR */
      0, /* !REPLACEMENT-bgt/n0/nR/fR/retR */
      0, /* !REPLACEMENT-bgt/n1/%rR/fR/retR */
      0, /* !REPLACEMENT-bgt/n1/n0/fR/retR */
      0, /* !REPLACEMENT-bgt/n1/n1/fR/retR */
      0, /* !REPLACEMENT-bgt/n1/nR/fR/retR */
      0, /* !REPLACEMENT-bgt/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-bgt/nR/n0/fR/retR */
      0, /* !REPLACEMENT-bgt/nR/n1/fR/retR */
      0, /* !REPLACEMENT-bgt/nR/nR/fR/retR */
      0, /* !REPLACEMENT-bgtu/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-bgtu/%rR/n0/fR/retR */
      0, /* !REPLACEMENT-bgtu/%rR/n1/fR/retR */
      0, /* !REPLACEMENT-bgtu/%rR/nR/fR/retR */
      0, /* !REPLACEMENT-bgtu/n0/%rR/fR/retR */
      0, /* !REPLACEMENT-bgtu/n0/n0/fR/retR */
      0, /* !REPLACEMENT-bgtu/n0/n1/fR/retR */
      0, /* !REPLACEMENT-bgtu/n0/nR/fR/retR */
      0, /* !REPLACEMENT-bgtu/n1/%rR/fR/retR */
      0, /* !REPLACEMENT-bgtu/n1/n0/fR/retR */
      0, /* !REPLACEMENT-bgtu/n1/n1/fR/retR */
      0, /* !REPLACEMENT-bgtu/n1/nR/fR/retR */
      0, /* !REPLACEMENT-bgtu/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-bgtu/nR/n0/fR/retR */
      0, /* !REPLACEMENT-bgtu/nR/n1/fR/retR */
      0, /* !REPLACEMENT-bgtu/nR/nR/fR/retR */
      0, /* !REPLACEMENT-ble/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-ble/%rR/n0/fR/retR */
      0, /* !REPLACEMENT-ble/%rR/n1/fR/retR */
      0, /* !REPLACEMENT-ble/%rR/nR/fR/retR */
      0, /* !REPLACEMENT-ble/n0/%rR/fR/retR */
      0, /* !REPLACEMENT-ble/n0/n0/fR/retR */
      0, /* !REPLACEMENT-ble/n0/n1/fR/retR */
      0, /* !REPLACEMENT-ble/n0/nR/fR/retR */
      0, /* !REPLACEMENT-ble/n1/%rR/fR/retR */
      0, /* !REPLACEMENT-ble/n1/n0/fR/retR */
      0, /* !REPLACEMENT-ble/n1/n1/fR/retR */
      0, /* !REPLACEMENT-ble/n1/nR/fR/retR */
      0, /* !REPLACEMENT-ble/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-ble/nR/n0/fR/retR */
      0, /* !REPLACEMENT-ble/nR/n1/fR/retR */
      0, /* !REPLACEMENT-ble/nR/nR/fR/retR */
      0, /* !REPLACEMENT-bleu/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-bleu/%rR/n0/fR/retR */
      0, /* !REPLACEMENT-bleu/%rR/n1/fR/retR */
      0, /* !REPLACEMENT-bleu/%rR/nR/fR/retR */
      0, /* !REPLACEMENT-bleu/n0/%rR/fR/retR */
      0, /* !REPLACEMENT-bleu/n0/n0/fR/retR */
      0, /* !REPLACEMENT-bleu/n0/n1/fR/retR */
      0, /* !REPLACEMENT-bleu/n0/nR/fR/retR */
      0, /* !REPLACEMENT-bleu/n1/%rR/fR/retR */
      0, /* !REPLACEMENT-bleu/n1/n0/fR/retR */
      0, /* !REPLACEMENT-bleu/n1/n1/fR/retR */
      0, /* !REPLACEMENT-bleu/n1/nR/fR/retR */
      0, /* !REPLACEMENT-bleu/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-bleu/nR/n0/fR/retR */
      0, /* !REPLACEMENT-bleu/nR/n1/fR/retR */
      0, /* !REPLACEMENT-bleu/nR/nR/fR/retR */
      0, /* !REPLACEMENT-blt/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-blt/%rR/n0/fR/retR */
      0, /* !REPLACEMENT-blt/%rR/n1/fR/retR */
      0, /* !REPLACEMENT-blt/%rR/nR/fR/retR */
      0, /* !REPLACEMENT-blt/n0/%rR/fR/retR */
      0, /* !REPLACEMENT-blt/n0/n0/fR/retR */
      0, /* !REPLACEMENT-blt/n0/n1/fR/retR */
      0, /* !REPLACEMENT-blt/n0/nR/fR/retR */
      0, /* !REPLACEMENT-blt/n1/%rR/fR/retR */
      0, /* !REPLACEMENT-blt/n1/n0/fR/retR */
      0, /* !REPLACEMENT-blt/n1/n1/fR/retR */
      0, /* !REPLACEMENT-blt/n1/nR/fR/retR */
      0, /* !REPLACEMENT-blt/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-blt/nR/n0/fR/retR */
      0, /* !REPLACEMENT-blt/nR/n1/fR/retR */
      0, /* !REPLACEMENT-blt/nR/nR/fR/retR */
      0, /* !REPLACEMENT-bltu/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-bltu/%rR/n0/fR/retR */
      0, /* !REPLACEMENT-bltu/%rR/n1/fR/retR */
      0, /* !REPLACEMENT-bltu/%rR/nR/fR/retR */
      0, /* !REPLACEMENT-bltu/n0/%rR/fR/retR */
      0, /* !REPLACEMENT-bltu/n0/n0/fR/retR */
      0, /* !REPLACEMENT-bltu/n0/n1/fR/retR */
      0, /* !REPLACEMENT-bltu/n0/nR/fR/retR */
      0, /* !REPLACEMENT-bltu/n1/%rR/fR/retR */
      0, /* !REPLACEMENT-bltu/n1/n0/fR/retR */
      0, /* !REPLACEMENT-bltu/n1/n1/fR/retR */
      0, /* !REPLACEMENT-bltu/n1/nR/fR/retR */
      0, /* !REPLACEMENT-bltu/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-bltu/nR/n0/fR/retR */
      0, /* !REPLACEMENT-bltu/nR/n1/fR/retR */
      0, /* !REPLACEMENT-bltu/nR/nR/fR/retR */
      0, /* !REPLACEMENT-bne/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-bne/%rR/n0/fR/retR */
      0, /* !REPLACEMENT-bne/%rR/nR/fR/retR */
      0, /* !REPLACEMENT-bne/n0/%rR/fR/retR */
      0, /* !REPLACEMENT-bne/n0/n0/fR/retR */
      0, /* !REPLACEMENT-bne/n0/nR/fR/retR */
      0, /* !REPLACEMENT-bne/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-bne/nR/n0/fR/retR */
      0, /* !REPLACEMENT-bne/nR/nR/fR/retR */
      0, /* !REPLACEMENT-bneg/%rR/fR/retR */
      0, /* !REPLACEMENT-bneg/nR/fR/retR */
      0, /* !REPLACEMENT-bnneg/%rR/fR/retR */
      0, /* !REPLACEMENT-bnneg/nR/fR/retR */
      0, /* !REPLACEMENT-bnotand/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-bnotand/%rR/n3/fR/retR */
      0, /* !REPLACEMENT-bnotand/%rR/n7/fR/retR */
      0, /* !REPLACEMENT-bnotand/%rR/nR/fR/retR */
      0, /* !REPLACEMENT-bnotand/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-bnotand/nR/n3/fR/retR */
      0, /* !REPLACEMENT-bnotand/nR/n7/fR/retR */
      0, /* !REPLACEMENT-bnotand/nR/nR/fR/retR */
      0, /* !REPLACEMENT-bnpos/%rR/fR/retR */
      0, /* !REPLACEMENT-bnpos/nR/fR/retR */
      0, /* !REPLACEMENT-bnz/%rR/fR/retR */
      0, /* !REPLACEMENT-bnz/nR/fR/retR */
      0, /* !REPLACEMENT-bpos/%rR/fR/retR */
      0, /* !REPLACEMENT-bpos/nR/fR/retR */
      0, /* !REPLACEMENT-br/%rR/retR */
      0, /* !REPLACEMENT-bz/%rR/fR/retR */
      0, /* !REPLACEMENT-bz/nR/fR/retR */
      0, /* !REPLACEMENT-divo/%rR/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-divo/%rR/n2/%rR/fR/retR */
      0, /* !REPLACEMENT-divo/%rR/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-divo/nR/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-divo/nR/n2/%rR/fR/retR */
      0, /* !REPLACEMENT-divo/nR/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-endvm/retR */
      0, /* !REPLACEMENT-exitvm/retR */
      0, /* !REPLACEMENT-modo/%rR/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-modo/%rR/n2/%rR/fR/retR */
      0, /* !REPLACEMENT-modo/%rR/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-modo/nR/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-modo/nR/n2/%rR/fR/retR */
      0, /* !REPLACEMENT-modo/nR/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-mulo/%rR/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-mulo/%rR/n2/%rR/fR/retR */
      0, /* !REPLACEMENT-mulo/%rR/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-mulo/nR/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-mulo/nR/n2/%rR/fR/retR */
      0, /* !REPLACEMENT-mulo/nR/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-procedurecall/fR/retR */
      0, /* !REPLACEMENT-procedurecallr/%rR/retR */
      0, /* !REPLACEMENT-procedurecallr/lR/retR */
      0, /* !REPLACEMENT-procedureprolog/retR */
      0, /* !REPLACEMENT-procedurereturn/retR */
      0, /* !REPLACEMENT-raise/%rR/retR */
      0, /* !REPLACEMENT-raise/n0/retR */
      0, /* !REPLACEMENT-raise/n1/retR */
      0, /* !REPLACEMENT-raise/n2/retR */
      0, /* !REPLACEMENT-raise/n3/retR */
      0, /* !REPLACEMENT-raise/n4/retR */
      0, /* !REPLACEMENT-raise/n5/retR */
      0, /* !REPLACEMENT-raise/n6/retR */
      0, /* !REPLACEMENT-raise/n7/retR */
      0, /* !REPLACEMENT-raise/n8/retR */
      0, /* !REPLACEMENT-raise/n9/retR */
      0, /* !REPLACEMENT-raise/n10/retR */
      0, /* !REPLACEMENT-raise/nR/retR */
      0, /* !REPLACEMENT-safe-point/fR/retR */
      0, /* !REPLACEMENT-stackif/fR/retR */
      0, /* !REPLACEMENT-stacknondroppingif/fR/retR */
      0, /* !REPLACEMENT-subo/%rR/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-subo/%rR/n1/%rR/fR/retR */
      0, /* !REPLACEMENT-subo/%rR/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-subo/nR/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-subo/nR/n1/%rR/fR/retR */
      0, /* !REPLACEMENT-subo/nR/nR/%rR/fR/retR */
      0 /* !REPLACEMENT-unreachable/retR */
    };
#endif // #ifdef JITTER_HAVE_PATCH_IN

// FIXME: I may want to conditionalize this.
const bool
uninspired_specialized_instruction_relocatables [UNINSPIRED_SPECIALIZED_INSTRUCTION_NO]
  = {
      true, // !INVALID
      true, // !BEGINBASICBLOCK
      true, // !EXITVM
      true, // !DATALOCATIONS
      true, // !NOP
      true, // !UNREACHABLE0
      true, // !UNREACHABLE1
      true, // !PRETENDTOJUMPANYWHERE
      true, // add/%rR/%rR/%rR
      true, // add/%rR/n1/%rR
      true, // add/%rR/n-1/%rR
      true, // add/%rR/nR/%rR
      true, // add/n1/%rR/%rR
      true, // add/n1/n1/%rR
      true, // add/n1/n-1/%rR
      true, // add/n1/nR/%rR
      true, // add/n-1/%rR/%rR
      true, // add/n-1/n1/%rR
      true, // add/n-1/n-1/%rR
      true, // add/n-1/nR/%rR
      true, // add/nR/%rR/%rR
      true, // add/nR/n1/%rR
      true, // add/nR/n-1/%rR
      true, // add/nR/nR/%rR
      true, // addo/%rR/%rR/%rR/fR
      true, // addo/%rR/n1/%rR/fR
      true, // addo/%rR/n-1/%rR/fR
      true, // addo/%rR/nR/%rR/fR
      true, // addo/nR/%rR/%rR/fR
      true, // addo/nR/n1/%rR/fR
      true, // addo/nR/n-1/%rR/fR
      true, // addo/nR/nR/%rR/fR
      true, // b/fR
      true, // band/%rR/%rR/fR
      true, // band/%rR/n3/fR
      true, // band/%rR/n7/fR
      true, // band/%rR/nR/fR
      true, // band/nR/%rR/fR
      true, // band/nR/n3/fR
      true, // band/nR/n7/fR
      true, // band/nR/nR/fR
      true, // beq/%rR/%rR/fR
      true, // beq/%rR/nR/fR
      true, // beq/nR/%rR/fR
      true, // beq/nR/nR/fR
      true, // bge/%rR/%rR/fR
      true, // bge/%rR/n0/fR
      true, // bge/%rR/n1/fR
      true, // bge/%rR/nR/fR
      true, // bge/n0/%rR/fR
      true, // bge/n0/n0/fR
      true, // bge/n0/n1/fR
      true, // bge/n0/nR/fR
      true, // bge/n1/%rR/fR
      true, // bge/n1/n0/fR
      true, // bge/n1/n1/fR
      true, // bge/n1/nR/fR
      true, // bge/nR/%rR/fR
      true, // bge/nR/n0/fR
      true, // bge/nR/n1/fR
      true, // bge/nR/nR/fR
      true, // bgeu/%rR/%rR/fR
      true, // bgeu/%rR/n0/fR
      true, // bgeu/%rR/n1/fR
      true, // bgeu/%rR/nR/fR
      true, // bgeu/n0/%rR/fR
      true, // bgeu/n0/n0/fR
      true, // bgeu/n0/n1/fR
      true, // bgeu/n0/nR/fR
      true, // bgeu/n1/%rR/fR
      true, // bgeu/n1/n0/fR
      true, // bgeu/n1/n1/fR
      true, // bgeu/n1/nR/fR
      true, // bgeu/nR/%rR/fR
      true, // bgeu/nR/n0/fR
      true, // bgeu/nR/n1/fR
      true, // bgeu/nR/nR/fR
      true, // bgt/%rR/%rR/fR
      true, // bgt/%rR/n0/fR
      true, // bgt/%rR/n1/fR
      true, // bgt/%rR/nR/fR
      true, // bgt/n0/%rR/fR
      true, // bgt/n0/n0/fR
      true, // bgt/n0/n1/fR
      true, // bgt/n0/nR/fR
      true, // bgt/n1/%rR/fR
      true, // bgt/n1/n0/fR
      true, // bgt/n1/n1/fR
      true, // bgt/n1/nR/fR
      true, // bgt/nR/%rR/fR
      true, // bgt/nR/n0/fR
      true, // bgt/nR/n1/fR
      true, // bgt/nR/nR/fR
      true, // bgtu/%rR/%rR/fR
      true, // bgtu/%rR/n0/fR
      true, // bgtu/%rR/n1/fR
      true, // bgtu/%rR/nR/fR
      true, // bgtu/n0/%rR/fR
      true, // bgtu/n0/n0/fR
      true, // bgtu/n0/n1/fR
      true, // bgtu/n0/nR/fR
      true, // bgtu/n1/%rR/fR
      true, // bgtu/n1/n0/fR
      true, // bgtu/n1/n1/fR
      true, // bgtu/n1/nR/fR
      true, // bgtu/nR/%rR/fR
      true, // bgtu/nR/n0/fR
      true, // bgtu/nR/n1/fR
      true, // bgtu/nR/nR/fR
      true, // ble/%rR/%rR/fR
      true, // ble/%rR/n0/fR
      true, // ble/%rR/n1/fR
      true, // ble/%rR/nR/fR
      true, // ble/n0/%rR/fR
      true, // ble/n0/n0/fR
      true, // ble/n0/n1/fR
      true, // ble/n0/nR/fR
      true, // ble/n1/%rR/fR
      true, // ble/n1/n0/fR
      true, // ble/n1/n1/fR
      true, // ble/n1/nR/fR
      true, // ble/nR/%rR/fR
      true, // ble/nR/n0/fR
      true, // ble/nR/n1/fR
      true, // ble/nR/nR/fR
      true, // bleu/%rR/%rR/fR
      true, // bleu/%rR/n0/fR
      true, // bleu/%rR/n1/fR
      true, // bleu/%rR/nR/fR
      true, // bleu/n0/%rR/fR
      true, // bleu/n0/n0/fR
      true, // bleu/n0/n1/fR
      true, // bleu/n0/nR/fR
      true, // bleu/n1/%rR/fR
      true, // bleu/n1/n0/fR
      true, // bleu/n1/n1/fR
      true, // bleu/n1/nR/fR
      true, // bleu/nR/%rR/fR
      true, // bleu/nR/n0/fR
      true, // bleu/nR/n1/fR
      true, // bleu/nR/nR/fR
      true, // blt/%rR/%rR/fR
      true, // blt/%rR/n0/fR
      true, // blt/%rR/n1/fR
      true, // blt/%rR/nR/fR
      true, // blt/n0/%rR/fR
      true, // blt/n0/n0/fR
      true, // blt/n0/n1/fR
      true, // blt/n0/nR/fR
      true, // blt/n1/%rR/fR
      true, // blt/n1/n0/fR
      true, // blt/n1/n1/fR
      true, // blt/n1/nR/fR
      true, // blt/nR/%rR/fR
      true, // blt/nR/n0/fR
      true, // blt/nR/n1/fR
      true, // blt/nR/nR/fR
      true, // bltu/%rR/%rR/fR
      true, // bltu/%rR/n0/fR
      true, // bltu/%rR/n1/fR
      true, // bltu/%rR/nR/fR
      true, // bltu/n0/%rR/fR
      true, // bltu/n0/n0/fR
      true, // bltu/n0/n1/fR
      true, // bltu/n0/nR/fR
      true, // bltu/n1/%rR/fR
      true, // bltu/n1/n0/fR
      true, // bltu/n1/n1/fR
      true, // bltu/n1/nR/fR
      true, // bltu/nR/%rR/fR
      true, // bltu/nR/n0/fR
      true, // bltu/nR/n1/fR
      true, // bltu/nR/nR/fR
      true, // bne/%rR/%rR/fR
      true, // bne/%rR/n0/fR
      true, // bne/%rR/nR/fR
      true, // bne/n0/%rR/fR
      true, // bne/n0/n0/fR
      true, // bne/n0/nR/fR
      true, // bne/nR/%rR/fR
      true, // bne/nR/n0/fR
      true, // bne/nR/nR/fR
      true, // bneg/%rR/fR
      true, // bneg/nR/fR
      true, // bnneg/%rR/fR
      true, // bnneg/nR/fR
      true, // bnotand/%rR/%rR/fR
      true, // bnotand/%rR/n3/fR
      true, // bnotand/%rR/n7/fR
      true, // bnotand/%rR/nR/fR
      true, // bnotand/nR/%rR/fR
      true, // bnotand/nR/n3/fR
      true, // bnotand/nR/n7/fR
      true, // bnotand/nR/nR/fR
      true, // bnpos/%rR/fR
      true, // bnpos/nR/fR
      true, // bnz/%rR/fR
      true, // bnz/nR/fR
      true, // bpos/%rR/fR
      true, // bpos/nR/fR
      true, // br/%rR
      true, // bulge/n0
      true, // bulge/n1
      true, // bulge/n2
      true, // bulge/n3
      true, // bulge/nR
      true, // bulgeforth
      true, // bz/%rR/fR
      true, // bz/nR/fR
      false, // clear-pending/retR
      false, // div/%rR/%rR/%rR/retR
      false, // div/%rR/n2/%rR/retR
      false, // div/%rR/nR/%rR/retR
      false, // div/nR/%rR/%rR/retR
      false, // div/nR/n2/%rR/retR
      false, // div/nR/nR/%rR/retR
      true, // divo/%rR/%rR/%rR/fR
      true, // divo/%rR/n2/%rR/fR
      true, // divo/%rR/nR/%rR/fR
      true, // divo/nR/%rR/%rR/fR
      true, // divo/nR/n2/%rR/fR
      true, // divo/nR/nR/%rR/fR
      true, // drop-handler
      true, // endvm
      false, // exit/%rR/retR
      false, // exit/nR/retR
      true, // exitvm
      true, // fadd/%fR/%fR/%fR
      true, // fdiv/%fR/%fR/%fR
      true, // fincr/%fR
      true, // fmul/%fR/%fR/%fR
      true, // fprint/%fR
      true, // fset/%rR/%fR
      true, // fset/nR/%fR
      true, // fsub/%fR/%fR/%fR
      false, // hcf/retR
      false, // install-signal-handler/retR
      true, // loadwithbyteoffset/%rR/%rR/%rR
      true, // loadwithbyteoffset/%rR/n0/%rR
      true, // loadwithbyteoffset/%rR/n8/%rR
      true, // loadwithbyteoffset/%rR/nR/%rR
      true, // loadwithwordoffset/%rR/%rR/%rR
      true, // loadwithwordoffset/%rR/n0/%rR
      true, // loadwithwordoffset/%rR/n1/%rR
      true, // loadwithwordoffset/%rR/n2/%rR
      true, // loadwithwordoffset/%rR/nR/%rR
      false, // mallocwords/%rR/%rR/retR
      false, // mallocwords/nR/%rR/retR
      false, // mod/%rR/%rR/%rR/retR
      false, // mod/%rR/n2/%rR/retR
      false, // mod/%rR/nR/%rR/retR
      false, // mod/nR/%rR/%rR/retR
      false, // mod/nR/n2/%rR/retR
      false, // mod/nR/nR/%rR/retR
      true, // modo/%rR/%rR/%rR/fR
      true, // modo/%rR/n2/%rR/fR
      true, // modo/%rR/nR/%rR/fR
      true, // modo/nR/%rR/%rR/fR
      true, // modo/nR/n2/%rR/fR
      true, // modo/nR/nR/%rR/fR
      true, // mov/%rR/%rR
      true, // mov/n0/%rR
      true, // mov/n1/%rR
      true, // mov/nR/%rR
      true, // mov/lR/%rR
      true, // mroll/n0
      true, // mroll/n1
      true, // mroll/n2
      true, // mroll/n3
      true, // mroll/n4
      true, // mroll/n5
      true, // mroll/n6
      true, // mroll/n7
      true, // mroll/n8
      true, // mroll/n9
      true, // mroll/n10
      true, // mroll/n11
      true, // mroll/n12
      true, // mroll/n13
      true, // mroll/n14
      true, // mroll/n15
      true, // mroll/n16
      true, // mroll/n17
      true, // mroll/n18
      true, // mroll/n19
      true, // mroll/n20
      true, // mroll/n21
      true, // mroll/n22
      true, // mroll/n23
      true, // mroll/n24
      true, // mroll/n25
      true, // mroll/n26
      true, // mroll/n27
      true, // mroll/n28
      true, // mroll/n29
      true, // mroll/n30
      true, // mroll/n31
      true, // mroll/n32
      true, // mroll/n33
      true, // mroll/n34
      true, // mroll/n35
      true, // mroll/n36
      true, // mroll/n37
      true, // mroll/n38
      true, // mroll/n39
      true, // mroll/n40
      true, // mroll/n41
      true, // mroll/n42
      true, // mroll/n43
      true, // mroll/n44
      true, // mroll/n45
      true, // mroll/n46
      true, // mroll/n47
      true, // mroll/n48
      true, // mroll/n49
      true, // mroll/n50
      true, // mroll/n51
      true, // mroll/n52
      true, // mroll/n53
      true, // mroll/n54
      true, // mroll/n55
      true, // mroll/n56
      true, // mroll/n57
      true, // mroll/n58
      true, // mroll/n59
      true, // mroll/n60
      true, // mroll/n61
      true, // mroll/n62
      true, // mroll/n63
      true, // mroll/n64
      true, // mroll/n65
      true, // mroll/n66
      true, // mroll/n67
      true, // mroll/n68
      true, // mroll/n69
      true, // mroll/n70
      true, // mroll/nR
      true, // mrollforth
      true, // mrot
      true, // mul/%rR/%rR/%rR
      true, // mul/%rR/n2/%rR
      true, // mul/%rR/nR/%rR
      true, // mul/n2/%rR/%rR
      true, // mul/n2/n2/%rR
      true, // mul/n2/nR/%rR
      true, // mul/nR/%rR/%rR
      true, // mul/nR/n2/%rR
      true, // mul/nR/nR/%rR
      true, // mulo/%rR/%rR/%rR/fR
      true, // mulo/%rR/n2/%rR/fR
      true, // mulo/%rR/nR/%rR/fR
      true, // mulo/nR/%rR/%rR/fR
      true, // mulo/nR/n2/%rR/fR
      true, // mulo/nR/nR/%rR/fR
      true, // nop
      false, // print-pending-signals/retR
      false, // print-topmost/nR/retR
      false, // printfixnum/%rR/retR
      false, // printfixnum/nR/retR
      false, // printufixnum/%rR/retR
      false, // printufixnum/nR/retR
      true, // procedurecall/fR/retR
      true, // procedurecallr/%rR/retR
      true, // procedurecallr/lR/retR
      true, // procedureprolog
      true, // procedurereturn
      false, // push-depths/nR/retR
      true, // push-handler/n0/lR
      true, // push-handler/n1/lR
      true, // push-handler/n2/lR
      true, // push-handler/n3/lR
      true, // push-handler/n4/lR
      true, // push-handler/n5/lR
      true, // push-handler/n6/lR
      true, // push-handler/n7/lR
      true, // push-handler/n8/lR
      true, // push-handler/n9/lR
      true, // push-handler/n10/lR
      true, // push-handler/nR/lR
      false, // push-increasing/nR/retR
      true, // quake
      true, // raise/%rR
      true, // raise/n0
      true, // raise/n1
      true, // raise/n2
      true, // raise/n3
      true, // raise/n4
      true, // raise/n5
      true, // raise/n6
      true, // raise/n7
      true, // raise/n8
      true, // raise/n9
      true, // raise/n10
      true, // raise/nR
      false, // random/%rR/retR
      true, // reverse/n0
      true, // reverse/n1
      true, // reverse/n2
      true, // reverse/n3
      true, // reverse/n4
      true, // reverse/n5
      true, // reverse/n6
      true, // reverse/n7
      true, // reverse/n8
      true, // reverse/n9
      true, // reverse/n10
      true, // reverse/n11
      true, // reverse/n12
      true, // reverse/n13
      true, // reverse/n14
      true, // reverse/n15
      true, // reverse/n16
      true, // reverse/n17
      true, // reverse/n18
      true, // reverse/n19
      true, // reverse/n20
      true, // reverse/n21
      true, // reverse/n22
      true, // reverse/n23
      true, // reverse/n24
      true, // reverse/n25
      true, // reverse/n26
      true, // reverse/n27
      true, // reverse/n28
      true, // reverse/n29
      true, // reverse/n30
      true, // reverse/n31
      true, // reverse/n32
      true, // reverse/n33
      true, // reverse/n34
      true, // reverse/n35
      true, // reverse/n36
      true, // reverse/n37
      true, // reverse/n38
      true, // reverse/n39
      true, // reverse/n40
      true, // reverse/n41
      true, // reverse/n42
      true, // reverse/n43
      true, // reverse/n44
      true, // reverse/n45
      true, // reverse/n46
      true, // reverse/n47
      true, // reverse/n48
      true, // reverse/n49
      true, // reverse/n50
      true, // reverse/n51
      true, // reverse/n52
      true, // reverse/n53
      true, // reverse/n54
      true, // reverse/n55
      true, // reverse/n56
      true, // reverse/n57
      true, // reverse/n58
      true, // reverse/n59
      true, // reverse/n60
      true, // reverse/n61
      true, // reverse/n62
      true, // reverse/n63
      true, // reverse/n64
      true, // reverse/n65
      true, // reverse/n66
      true, // reverse/n67
      true, // reverse/n68
      true, // reverse/n69
      true, // reverse/n70
      true, // reverse/nR
      true, // roll/n0
      true, // roll/n1
      true, // roll/n2
      true, // roll/n3
      true, // roll/n4
      true, // roll/n5
      true, // roll/n6
      true, // roll/n7
      true, // roll/n8
      true, // roll/n9
      true, // roll/n10
      true, // roll/n11
      true, // roll/n12
      true, // roll/n13
      true, // roll/n14
      true, // roll/n15
      true, // roll/n16
      true, // roll/n17
      true, // roll/n18
      true, // roll/n19
      true, // roll/n20
      true, // roll/n21
      true, // roll/n22
      true, // roll/n23
      true, // roll/n24
      true, // roll/n25
      true, // roll/n26
      true, // roll/n27
      true, // roll/n28
      true, // roll/n29
      true, // roll/n30
      true, // roll/n31
      true, // roll/n32
      true, // roll/n33
      true, // roll/n34
      true, // roll/n35
      true, // roll/n36
      true, // roll/n37
      true, // roll/n38
      true, // roll/n39
      true, // roll/n40
      true, // roll/n41
      true, // roll/n42
      true, // roll/n43
      true, // roll/n44
      true, // roll/n45
      true, // roll/n46
      true, // roll/n47
      true, // roll/n48
      true, // roll/n49
      true, // roll/n50
      true, // roll/n51
      true, // roll/n52
      true, // roll/n53
      true, // roll/n54
      true, // roll/n55
      true, // roll/n56
      true, // roll/n57
      true, // roll/n58
      true, // roll/n59
      true, // roll/n60
      true, // roll/n61
      true, // roll/n62
      true, // roll/n63
      true, // roll/n64
      true, // roll/n65
      true, // roll/n66
      true, // roll/n67
      true, // roll/n68
      true, // roll/n69
      true, // roll/n70
      true, // roll/nR
      true, // rollforth
      true, // rot
      true, // safe-point/fR
      true, // set-pending
      true, // slide/n1/n1
      true, // slide/n1/n2
      true, // slide/n1/n3
      true, // slide/n1/n4
      true, // slide/n1/n5
      true, // slide/n1/nR
      true, // slide/n2/n1
      true, // slide/n2/n2
      true, // slide/n2/n3
      true, // slide/n2/n4
      true, // slide/n2/n5
      true, // slide/n2/nR
      true, // slide/n3/n1
      true, // slide/n3/n2
      true, // slide/n3/n3
      true, // slide/n3/n4
      true, // slide/n3/n5
      true, // slide/n3/nR
      true, // slide/nR/n1
      true, // slide/nR/n2
      true, // slide/nR/n3
      true, // slide/nR/n4
      true, // slide/nR/n5
      true, // slide/nR/nR
      true, // slideforth
      true, // stackdrop
      true, // stackdup
      true, // stackif/fR
      true, // stacknip
      true, // stacknondroppingif/fR
      true, // stacknot
      true, // stackoneminus
      true, // stackoneplus
      true, // stackover
      true, // stackpeek/%rR
      true, // stackplus
      true, // stackplusr/%rR
      true, // stackpop/%rR
      false, // stackprint/retR
      true, // stackpush/%rR
      true, // stackpush/n0
      true, // stackpush/n1
      true, // stackpush/nR
      true, // stackpush/lR
      true, // stackpushunspecified
      true, // stackset/%rR
      true, // stackset/n0
      true, // stackset/n1
      true, // stackset/nR
      true, // stackset/lR
      true, // stackswap
      true, // stackswaptop/%rR
      true, // stacktimes
      true, // storewithbyteoffset/%rR/%rR/%rR
      true, // storewithbyteoffset/%rR/%rR/n0
      true, // storewithbyteoffset/%rR/%rR/n8
      true, // storewithbyteoffset/%rR/%rR/nR
      true, // storewithbyteoffset/nR/%rR/%rR
      true, // storewithbyteoffset/nR/%rR/n0
      true, // storewithbyteoffset/nR/%rR/n8
      true, // storewithbyteoffset/nR/%rR/nR
      true, // storewithwordoffset/%rR/%rR/%rR
      true, // storewithwordoffset/%rR/%rR/n0
      true, // storewithwordoffset/%rR/%rR/n1
      true, // storewithwordoffset/%rR/%rR/n2
      true, // storewithwordoffset/%rR/%rR/nR
      true, // storewithwordoffset/nR/%rR/%rR
      true, // storewithwordoffset/nR/%rR/n0
      true, // storewithwordoffset/nR/%rR/n1
      true, // storewithwordoffset/nR/%rR/n2
      true, // storewithwordoffset/nR/%rR/nR
      true, // sub/%rR/%rR/%rR
      true, // sub/%rR/n1/%rR
      true, // sub/%rR/nR/%rR
      true, // sub/n0/%rR/%rR
      true, // sub/n0/n1/%rR
      true, // sub/n0/nR/%rR
      true, // sub/nR/%rR/%rR
      true, // sub/nR/n1/%rR
      true, // sub/nR/nR/%rR
      true, // subo/%rR/%rR/%rR/fR
      true, // subo/%rR/n1/%rR/fR
      true, // subo/%rR/nR/%rR/fR
      true, // subo/nR/%rR/%rR/fR
      true, // subo/nR/n1/%rR/fR
      true, // subo/nR/nR/%rR/fR
      true, // tuck
      true, // unreachable
      true, // whirl/n0
      true, // whirl/n1
      true, // whirl/n2
      true, // whirl/n3
      true, // whirl/nR
      true, // whirlforth
      false, // !REPLACEMENT-addo/%rR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-addo/%rR/n1/%rR/fR/retR
      false, // !REPLACEMENT-addo/%rR/n-1/%rR/fR/retR
      false, // !REPLACEMENT-addo/%rR/nR/%rR/fR/retR
      false, // !REPLACEMENT-addo/nR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-addo/nR/n1/%rR/fR/retR
      false, // !REPLACEMENT-addo/nR/n-1/%rR/fR/retR
      false, // !REPLACEMENT-addo/nR/nR/%rR/fR/retR
      false, // !REPLACEMENT-b/fR/retR
      false, // !REPLACEMENT-band/%rR/%rR/fR/retR
      false, // !REPLACEMENT-band/%rR/n3/fR/retR
      false, // !REPLACEMENT-band/%rR/n7/fR/retR
      false, // !REPLACEMENT-band/%rR/nR/fR/retR
      false, // !REPLACEMENT-band/nR/%rR/fR/retR
      false, // !REPLACEMENT-band/nR/n3/fR/retR
      false, // !REPLACEMENT-band/nR/n7/fR/retR
      false, // !REPLACEMENT-band/nR/nR/fR/retR
      false, // !REPLACEMENT-beq/%rR/%rR/fR/retR
      false, // !REPLACEMENT-beq/%rR/nR/fR/retR
      false, // !REPLACEMENT-beq/nR/%rR/fR/retR
      false, // !REPLACEMENT-beq/nR/nR/fR/retR
      false, // !REPLACEMENT-bge/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bge/%rR/n0/fR/retR
      false, // !REPLACEMENT-bge/%rR/n1/fR/retR
      false, // !REPLACEMENT-bge/%rR/nR/fR/retR
      false, // !REPLACEMENT-bge/n0/%rR/fR/retR
      false, // !REPLACEMENT-bge/n0/n0/fR/retR
      false, // !REPLACEMENT-bge/n0/n1/fR/retR
      false, // !REPLACEMENT-bge/n0/nR/fR/retR
      false, // !REPLACEMENT-bge/n1/%rR/fR/retR
      false, // !REPLACEMENT-bge/n1/n0/fR/retR
      false, // !REPLACEMENT-bge/n1/n1/fR/retR
      false, // !REPLACEMENT-bge/n1/nR/fR/retR
      false, // !REPLACEMENT-bge/nR/%rR/fR/retR
      false, // !REPLACEMENT-bge/nR/n0/fR/retR
      false, // !REPLACEMENT-bge/nR/n1/fR/retR
      false, // !REPLACEMENT-bge/nR/nR/fR/retR
      false, // !REPLACEMENT-bgeu/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bgeu/%rR/n0/fR/retR
      false, // !REPLACEMENT-bgeu/%rR/n1/fR/retR
      false, // !REPLACEMENT-bgeu/%rR/nR/fR/retR
      false, // !REPLACEMENT-bgeu/n0/%rR/fR/retR
      false, // !REPLACEMENT-bgeu/n0/n0/fR/retR
      false, // !REPLACEMENT-bgeu/n0/n1/fR/retR
      false, // !REPLACEMENT-bgeu/n0/nR/fR/retR
      false, // !REPLACEMENT-bgeu/n1/%rR/fR/retR
      false, // !REPLACEMENT-bgeu/n1/n0/fR/retR
      false, // !REPLACEMENT-bgeu/n1/n1/fR/retR
      false, // !REPLACEMENT-bgeu/n1/nR/fR/retR
      false, // !REPLACEMENT-bgeu/nR/%rR/fR/retR
      false, // !REPLACEMENT-bgeu/nR/n0/fR/retR
      false, // !REPLACEMENT-bgeu/nR/n1/fR/retR
      false, // !REPLACEMENT-bgeu/nR/nR/fR/retR
      false, // !REPLACEMENT-bgt/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bgt/%rR/n0/fR/retR
      false, // !REPLACEMENT-bgt/%rR/n1/fR/retR
      false, // !REPLACEMENT-bgt/%rR/nR/fR/retR
      false, // !REPLACEMENT-bgt/n0/%rR/fR/retR
      false, // !REPLACEMENT-bgt/n0/n0/fR/retR
      false, // !REPLACEMENT-bgt/n0/n1/fR/retR
      false, // !REPLACEMENT-bgt/n0/nR/fR/retR
      false, // !REPLACEMENT-bgt/n1/%rR/fR/retR
      false, // !REPLACEMENT-bgt/n1/n0/fR/retR
      false, // !REPLACEMENT-bgt/n1/n1/fR/retR
      false, // !REPLACEMENT-bgt/n1/nR/fR/retR
      false, // !REPLACEMENT-bgt/nR/%rR/fR/retR
      false, // !REPLACEMENT-bgt/nR/n0/fR/retR
      false, // !REPLACEMENT-bgt/nR/n1/fR/retR
      false, // !REPLACEMENT-bgt/nR/nR/fR/retR
      false, // !REPLACEMENT-bgtu/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bgtu/%rR/n0/fR/retR
      false, // !REPLACEMENT-bgtu/%rR/n1/fR/retR
      false, // !REPLACEMENT-bgtu/%rR/nR/fR/retR
      false, // !REPLACEMENT-bgtu/n0/%rR/fR/retR
      false, // !REPLACEMENT-bgtu/n0/n0/fR/retR
      false, // !REPLACEMENT-bgtu/n0/n1/fR/retR
      false, // !REPLACEMENT-bgtu/n0/nR/fR/retR
      false, // !REPLACEMENT-bgtu/n1/%rR/fR/retR
      false, // !REPLACEMENT-bgtu/n1/n0/fR/retR
      false, // !REPLACEMENT-bgtu/n1/n1/fR/retR
      false, // !REPLACEMENT-bgtu/n1/nR/fR/retR
      false, // !REPLACEMENT-bgtu/nR/%rR/fR/retR
      false, // !REPLACEMENT-bgtu/nR/n0/fR/retR
      false, // !REPLACEMENT-bgtu/nR/n1/fR/retR
      false, // !REPLACEMENT-bgtu/nR/nR/fR/retR
      false, // !REPLACEMENT-ble/%rR/%rR/fR/retR
      false, // !REPLACEMENT-ble/%rR/n0/fR/retR
      false, // !REPLACEMENT-ble/%rR/n1/fR/retR
      false, // !REPLACEMENT-ble/%rR/nR/fR/retR
      false, // !REPLACEMENT-ble/n0/%rR/fR/retR
      false, // !REPLACEMENT-ble/n0/n0/fR/retR
      false, // !REPLACEMENT-ble/n0/n1/fR/retR
      false, // !REPLACEMENT-ble/n0/nR/fR/retR
      false, // !REPLACEMENT-ble/n1/%rR/fR/retR
      false, // !REPLACEMENT-ble/n1/n0/fR/retR
      false, // !REPLACEMENT-ble/n1/n1/fR/retR
      false, // !REPLACEMENT-ble/n1/nR/fR/retR
      false, // !REPLACEMENT-ble/nR/%rR/fR/retR
      false, // !REPLACEMENT-ble/nR/n0/fR/retR
      false, // !REPLACEMENT-ble/nR/n1/fR/retR
      false, // !REPLACEMENT-ble/nR/nR/fR/retR
      false, // !REPLACEMENT-bleu/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bleu/%rR/n0/fR/retR
      false, // !REPLACEMENT-bleu/%rR/n1/fR/retR
      false, // !REPLACEMENT-bleu/%rR/nR/fR/retR
      false, // !REPLACEMENT-bleu/n0/%rR/fR/retR
      false, // !REPLACEMENT-bleu/n0/n0/fR/retR
      false, // !REPLACEMENT-bleu/n0/n1/fR/retR
      false, // !REPLACEMENT-bleu/n0/nR/fR/retR
      false, // !REPLACEMENT-bleu/n1/%rR/fR/retR
      false, // !REPLACEMENT-bleu/n1/n0/fR/retR
      false, // !REPLACEMENT-bleu/n1/n1/fR/retR
      false, // !REPLACEMENT-bleu/n1/nR/fR/retR
      false, // !REPLACEMENT-bleu/nR/%rR/fR/retR
      false, // !REPLACEMENT-bleu/nR/n0/fR/retR
      false, // !REPLACEMENT-bleu/nR/n1/fR/retR
      false, // !REPLACEMENT-bleu/nR/nR/fR/retR
      false, // !REPLACEMENT-blt/%rR/%rR/fR/retR
      false, // !REPLACEMENT-blt/%rR/n0/fR/retR
      false, // !REPLACEMENT-blt/%rR/n1/fR/retR
      false, // !REPLACEMENT-blt/%rR/nR/fR/retR
      false, // !REPLACEMENT-blt/n0/%rR/fR/retR
      false, // !REPLACEMENT-blt/n0/n0/fR/retR
      false, // !REPLACEMENT-blt/n0/n1/fR/retR
      false, // !REPLACEMENT-blt/n0/nR/fR/retR
      false, // !REPLACEMENT-blt/n1/%rR/fR/retR
      false, // !REPLACEMENT-blt/n1/n0/fR/retR
      false, // !REPLACEMENT-blt/n1/n1/fR/retR
      false, // !REPLACEMENT-blt/n1/nR/fR/retR
      false, // !REPLACEMENT-blt/nR/%rR/fR/retR
      false, // !REPLACEMENT-blt/nR/n0/fR/retR
      false, // !REPLACEMENT-blt/nR/n1/fR/retR
      false, // !REPLACEMENT-blt/nR/nR/fR/retR
      false, // !REPLACEMENT-bltu/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bltu/%rR/n0/fR/retR
      false, // !REPLACEMENT-bltu/%rR/n1/fR/retR
      false, // !REPLACEMENT-bltu/%rR/nR/fR/retR
      false, // !REPLACEMENT-bltu/n0/%rR/fR/retR
      false, // !REPLACEMENT-bltu/n0/n0/fR/retR
      false, // !REPLACEMENT-bltu/n0/n1/fR/retR
      false, // !REPLACEMENT-bltu/n0/nR/fR/retR
      false, // !REPLACEMENT-bltu/n1/%rR/fR/retR
      false, // !REPLACEMENT-bltu/n1/n0/fR/retR
      false, // !REPLACEMENT-bltu/n1/n1/fR/retR
      false, // !REPLACEMENT-bltu/n1/nR/fR/retR
      false, // !REPLACEMENT-bltu/nR/%rR/fR/retR
      false, // !REPLACEMENT-bltu/nR/n0/fR/retR
      false, // !REPLACEMENT-bltu/nR/n1/fR/retR
      false, // !REPLACEMENT-bltu/nR/nR/fR/retR
      false, // !REPLACEMENT-bne/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bne/%rR/n0/fR/retR
      false, // !REPLACEMENT-bne/%rR/nR/fR/retR
      false, // !REPLACEMENT-bne/n0/%rR/fR/retR
      false, // !REPLACEMENT-bne/n0/n0/fR/retR
      false, // !REPLACEMENT-bne/n0/nR/fR/retR
      false, // !REPLACEMENT-bne/nR/%rR/fR/retR
      false, // !REPLACEMENT-bne/nR/n0/fR/retR
      false, // !REPLACEMENT-bne/nR/nR/fR/retR
      false, // !REPLACEMENT-bneg/%rR/fR/retR
      false, // !REPLACEMENT-bneg/nR/fR/retR
      false, // !REPLACEMENT-bnneg/%rR/fR/retR
      false, // !REPLACEMENT-bnneg/nR/fR/retR
      false, // !REPLACEMENT-bnotand/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bnotand/%rR/n3/fR/retR
      false, // !REPLACEMENT-bnotand/%rR/n7/fR/retR
      false, // !REPLACEMENT-bnotand/%rR/nR/fR/retR
      false, // !REPLACEMENT-bnotand/nR/%rR/fR/retR
      false, // !REPLACEMENT-bnotand/nR/n3/fR/retR
      false, // !REPLACEMENT-bnotand/nR/n7/fR/retR
      false, // !REPLACEMENT-bnotand/nR/nR/fR/retR
      false, // !REPLACEMENT-bnpos/%rR/fR/retR
      false, // !REPLACEMENT-bnpos/nR/fR/retR
      false, // !REPLACEMENT-bnz/%rR/fR/retR
      false, // !REPLACEMENT-bnz/nR/fR/retR
      false, // !REPLACEMENT-bpos/%rR/fR/retR
      false, // !REPLACEMENT-bpos/nR/fR/retR
      false, // !REPLACEMENT-br/%rR/retR
      false, // !REPLACEMENT-bz/%rR/fR/retR
      false, // !REPLACEMENT-bz/nR/fR/retR
      false, // !REPLACEMENT-divo/%rR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-divo/%rR/n2/%rR/fR/retR
      false, // !REPLACEMENT-divo/%rR/nR/%rR/fR/retR
      false, // !REPLACEMENT-divo/nR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-divo/nR/n2/%rR/fR/retR
      false, // !REPLACEMENT-divo/nR/nR/%rR/fR/retR
      false, // !REPLACEMENT-endvm/retR
      false, // !REPLACEMENT-exitvm/retR
      false, // !REPLACEMENT-modo/%rR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-modo/%rR/n2/%rR/fR/retR
      false, // !REPLACEMENT-modo/%rR/nR/%rR/fR/retR
      false, // !REPLACEMENT-modo/nR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-modo/nR/n2/%rR/fR/retR
      false, // !REPLACEMENT-modo/nR/nR/%rR/fR/retR
      false, // !REPLACEMENT-mulo/%rR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-mulo/%rR/n2/%rR/fR/retR
      false, // !REPLACEMENT-mulo/%rR/nR/%rR/fR/retR
      false, // !REPLACEMENT-mulo/nR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-mulo/nR/n2/%rR/fR/retR
      false, // !REPLACEMENT-mulo/nR/nR/%rR/fR/retR
      false, // !REPLACEMENT-procedurecall/fR/retR
      false, // !REPLACEMENT-procedurecallr/%rR/retR
      false, // !REPLACEMENT-procedurecallr/lR/retR
      false, // !REPLACEMENT-procedureprolog/retR
      false, // !REPLACEMENT-procedurereturn/retR
      false, // !REPLACEMENT-raise/%rR/retR
      false, // !REPLACEMENT-raise/n0/retR
      false, // !REPLACEMENT-raise/n1/retR
      false, // !REPLACEMENT-raise/n2/retR
      false, // !REPLACEMENT-raise/n3/retR
      false, // !REPLACEMENT-raise/n4/retR
      false, // !REPLACEMENT-raise/n5/retR
      false, // !REPLACEMENT-raise/n6/retR
      false, // !REPLACEMENT-raise/n7/retR
      false, // !REPLACEMENT-raise/n8/retR
      false, // !REPLACEMENT-raise/n9/retR
      false, // !REPLACEMENT-raise/n10/retR
      false, // !REPLACEMENT-raise/nR/retR
      false, // !REPLACEMENT-safe-point/fR/retR
      false, // !REPLACEMENT-stackif/fR/retR
      false, // !REPLACEMENT-stacknondroppingif/fR/retR
      false, // !REPLACEMENT-subo/%rR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-subo/%rR/n1/%rR/fR/retR
      false, // !REPLACEMENT-subo/%rR/nR/%rR/fR/retR
      false, // !REPLACEMENT-subo/nR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-subo/nR/n1/%rR/fR/retR
      false, // !REPLACEMENT-subo/nR/nR/%rR/fR/retR
      false // !REPLACEMENT-unreachable/retR
    };

// FIXME: this is not currently accessed, and in fact may be useless.
const bool
uninspired_specialized_instruction_callers [UNINSPIRED_SPECIALIZED_INSTRUCTION_NO]
  = {
      false, // !INVALID
      false, // !BEGINBASICBLOCK
      false, // !EXITVM
      false, // !DATALOCATIONS
      false, // !NOP
      false, // !UNREACHABLE0
      false, // !UNREACHABLE1
      false, // !PRETENDTOJUMPANYWHERE
      false, // add/%rR/%rR/%rR
      false, // add/%rR/n1/%rR
      false, // add/%rR/n-1/%rR
      false, // add/%rR/nR/%rR
      false, // add/n1/%rR/%rR
      false, // add/n1/n1/%rR
      false, // add/n1/n-1/%rR
      false, // add/n1/nR/%rR
      false, // add/n-1/%rR/%rR
      false, // add/n-1/n1/%rR
      false, // add/n-1/n-1/%rR
      false, // add/n-1/nR/%rR
      false, // add/nR/%rR/%rR
      false, // add/nR/n1/%rR
      false, // add/nR/n-1/%rR
      false, // add/nR/nR/%rR
      false, // addo/%rR/%rR/%rR/fR
      false, // addo/%rR/n1/%rR/fR
      false, // addo/%rR/n-1/%rR/fR
      false, // addo/%rR/nR/%rR/fR
      false, // addo/nR/%rR/%rR/fR
      false, // addo/nR/n1/%rR/fR
      false, // addo/nR/n-1/%rR/fR
      false, // addo/nR/nR/%rR/fR
      false, // b/fR
      false, // band/%rR/%rR/fR
      false, // band/%rR/n3/fR
      false, // band/%rR/n7/fR
      false, // band/%rR/nR/fR
      false, // band/nR/%rR/fR
      false, // band/nR/n3/fR
      false, // band/nR/n7/fR
      false, // band/nR/nR/fR
      false, // beq/%rR/%rR/fR
      false, // beq/%rR/nR/fR
      false, // beq/nR/%rR/fR
      false, // beq/nR/nR/fR
      false, // bge/%rR/%rR/fR
      false, // bge/%rR/n0/fR
      false, // bge/%rR/n1/fR
      false, // bge/%rR/nR/fR
      false, // bge/n0/%rR/fR
      false, // bge/n0/n0/fR
      false, // bge/n0/n1/fR
      false, // bge/n0/nR/fR
      false, // bge/n1/%rR/fR
      false, // bge/n1/n0/fR
      false, // bge/n1/n1/fR
      false, // bge/n1/nR/fR
      false, // bge/nR/%rR/fR
      false, // bge/nR/n0/fR
      false, // bge/nR/n1/fR
      false, // bge/nR/nR/fR
      false, // bgeu/%rR/%rR/fR
      false, // bgeu/%rR/n0/fR
      false, // bgeu/%rR/n1/fR
      false, // bgeu/%rR/nR/fR
      false, // bgeu/n0/%rR/fR
      false, // bgeu/n0/n0/fR
      false, // bgeu/n0/n1/fR
      false, // bgeu/n0/nR/fR
      false, // bgeu/n1/%rR/fR
      false, // bgeu/n1/n0/fR
      false, // bgeu/n1/n1/fR
      false, // bgeu/n1/nR/fR
      false, // bgeu/nR/%rR/fR
      false, // bgeu/nR/n0/fR
      false, // bgeu/nR/n1/fR
      false, // bgeu/nR/nR/fR
      false, // bgt/%rR/%rR/fR
      false, // bgt/%rR/n0/fR
      false, // bgt/%rR/n1/fR
      false, // bgt/%rR/nR/fR
      false, // bgt/n0/%rR/fR
      false, // bgt/n0/n0/fR
      false, // bgt/n0/n1/fR
      false, // bgt/n0/nR/fR
      false, // bgt/n1/%rR/fR
      false, // bgt/n1/n0/fR
      false, // bgt/n1/n1/fR
      false, // bgt/n1/nR/fR
      false, // bgt/nR/%rR/fR
      false, // bgt/nR/n0/fR
      false, // bgt/nR/n1/fR
      false, // bgt/nR/nR/fR
      false, // bgtu/%rR/%rR/fR
      false, // bgtu/%rR/n0/fR
      false, // bgtu/%rR/n1/fR
      false, // bgtu/%rR/nR/fR
      false, // bgtu/n0/%rR/fR
      false, // bgtu/n0/n0/fR
      false, // bgtu/n0/n1/fR
      false, // bgtu/n0/nR/fR
      false, // bgtu/n1/%rR/fR
      false, // bgtu/n1/n0/fR
      false, // bgtu/n1/n1/fR
      false, // bgtu/n1/nR/fR
      false, // bgtu/nR/%rR/fR
      false, // bgtu/nR/n0/fR
      false, // bgtu/nR/n1/fR
      false, // bgtu/nR/nR/fR
      false, // ble/%rR/%rR/fR
      false, // ble/%rR/n0/fR
      false, // ble/%rR/n1/fR
      false, // ble/%rR/nR/fR
      false, // ble/n0/%rR/fR
      false, // ble/n0/n0/fR
      false, // ble/n0/n1/fR
      false, // ble/n0/nR/fR
      false, // ble/n1/%rR/fR
      false, // ble/n1/n0/fR
      false, // ble/n1/n1/fR
      false, // ble/n1/nR/fR
      false, // ble/nR/%rR/fR
      false, // ble/nR/n0/fR
      false, // ble/nR/n1/fR
      false, // ble/nR/nR/fR
      false, // bleu/%rR/%rR/fR
      false, // bleu/%rR/n0/fR
      false, // bleu/%rR/n1/fR
      false, // bleu/%rR/nR/fR
      false, // bleu/n0/%rR/fR
      false, // bleu/n0/n0/fR
      false, // bleu/n0/n1/fR
      false, // bleu/n0/nR/fR
      false, // bleu/n1/%rR/fR
      false, // bleu/n1/n0/fR
      false, // bleu/n1/n1/fR
      false, // bleu/n1/nR/fR
      false, // bleu/nR/%rR/fR
      false, // bleu/nR/n0/fR
      false, // bleu/nR/n1/fR
      false, // bleu/nR/nR/fR
      false, // blt/%rR/%rR/fR
      false, // blt/%rR/n0/fR
      false, // blt/%rR/n1/fR
      false, // blt/%rR/nR/fR
      false, // blt/n0/%rR/fR
      false, // blt/n0/n0/fR
      false, // blt/n0/n1/fR
      false, // blt/n0/nR/fR
      false, // blt/n1/%rR/fR
      false, // blt/n1/n0/fR
      false, // blt/n1/n1/fR
      false, // blt/n1/nR/fR
      false, // blt/nR/%rR/fR
      false, // blt/nR/n0/fR
      false, // blt/nR/n1/fR
      false, // blt/nR/nR/fR
      false, // bltu/%rR/%rR/fR
      false, // bltu/%rR/n0/fR
      false, // bltu/%rR/n1/fR
      false, // bltu/%rR/nR/fR
      false, // bltu/n0/%rR/fR
      false, // bltu/n0/n0/fR
      false, // bltu/n0/n1/fR
      false, // bltu/n0/nR/fR
      false, // bltu/n1/%rR/fR
      false, // bltu/n1/n0/fR
      false, // bltu/n1/n1/fR
      false, // bltu/n1/nR/fR
      false, // bltu/nR/%rR/fR
      false, // bltu/nR/n0/fR
      false, // bltu/nR/n1/fR
      false, // bltu/nR/nR/fR
      false, // bne/%rR/%rR/fR
      false, // bne/%rR/n0/fR
      false, // bne/%rR/nR/fR
      false, // bne/n0/%rR/fR
      false, // bne/n0/n0/fR
      false, // bne/n0/nR/fR
      false, // bne/nR/%rR/fR
      false, // bne/nR/n0/fR
      false, // bne/nR/nR/fR
      false, // bneg/%rR/fR
      false, // bneg/nR/fR
      false, // bnneg/%rR/fR
      false, // bnneg/nR/fR
      false, // bnotand/%rR/%rR/fR
      false, // bnotand/%rR/n3/fR
      false, // bnotand/%rR/n7/fR
      false, // bnotand/%rR/nR/fR
      false, // bnotand/nR/%rR/fR
      false, // bnotand/nR/n3/fR
      false, // bnotand/nR/n7/fR
      false, // bnotand/nR/nR/fR
      false, // bnpos/%rR/fR
      false, // bnpos/nR/fR
      false, // bnz/%rR/fR
      false, // bnz/nR/fR
      false, // bpos/%rR/fR
      false, // bpos/nR/fR
      false, // br/%rR
      false, // bulge/n0
      false, // bulge/n1
      false, // bulge/n2
      false, // bulge/n3
      false, // bulge/nR
      false, // bulgeforth
      false, // bz/%rR/fR
      false, // bz/nR/fR
      false, // clear-pending/retR
      false, // div/%rR/%rR/%rR/retR
      false, // div/%rR/n2/%rR/retR
      false, // div/%rR/nR/%rR/retR
      false, // div/nR/%rR/%rR/retR
      false, // div/nR/n2/%rR/retR
      false, // div/nR/nR/%rR/retR
      false, // divo/%rR/%rR/%rR/fR
      false, // divo/%rR/n2/%rR/fR
      false, // divo/%rR/nR/%rR/fR
      false, // divo/nR/%rR/%rR/fR
      false, // divo/nR/n2/%rR/fR
      false, // divo/nR/nR/%rR/fR
      false, // drop-handler
      false, // endvm
      false, // exit/%rR/retR
      false, // exit/nR/retR
      false, // exitvm
      false, // fadd/%fR/%fR/%fR
      false, // fdiv/%fR/%fR/%fR
      false, // fincr/%fR
      false, // fmul/%fR/%fR/%fR
      false, // fprint/%fR
      false, // fset/%rR/%fR
      false, // fset/nR/%fR
      false, // fsub/%fR/%fR/%fR
      false, // hcf/retR
      false, // install-signal-handler/retR
      false, // loadwithbyteoffset/%rR/%rR/%rR
      false, // loadwithbyteoffset/%rR/n0/%rR
      false, // loadwithbyteoffset/%rR/n8/%rR
      false, // loadwithbyteoffset/%rR/nR/%rR
      false, // loadwithwordoffset/%rR/%rR/%rR
      false, // loadwithwordoffset/%rR/n0/%rR
      false, // loadwithwordoffset/%rR/n1/%rR
      false, // loadwithwordoffset/%rR/n2/%rR
      false, // loadwithwordoffset/%rR/nR/%rR
      false, // mallocwords/%rR/%rR/retR
      false, // mallocwords/nR/%rR/retR
      false, // mod/%rR/%rR/%rR/retR
      false, // mod/%rR/n2/%rR/retR
      false, // mod/%rR/nR/%rR/retR
      false, // mod/nR/%rR/%rR/retR
      false, // mod/nR/n2/%rR/retR
      false, // mod/nR/nR/%rR/retR
      false, // modo/%rR/%rR/%rR/fR
      false, // modo/%rR/n2/%rR/fR
      false, // modo/%rR/nR/%rR/fR
      false, // modo/nR/%rR/%rR/fR
      false, // modo/nR/n2/%rR/fR
      false, // modo/nR/nR/%rR/fR
      false, // mov/%rR/%rR
      false, // mov/n0/%rR
      false, // mov/n1/%rR
      false, // mov/nR/%rR
      false, // mov/lR/%rR
      false, // mroll/n0
      false, // mroll/n1
      false, // mroll/n2
      false, // mroll/n3
      false, // mroll/n4
      false, // mroll/n5
      false, // mroll/n6
      false, // mroll/n7
      false, // mroll/n8
      false, // mroll/n9
      false, // mroll/n10
      false, // mroll/n11
      false, // mroll/n12
      false, // mroll/n13
      false, // mroll/n14
      false, // mroll/n15
      false, // mroll/n16
      false, // mroll/n17
      false, // mroll/n18
      false, // mroll/n19
      false, // mroll/n20
      false, // mroll/n21
      false, // mroll/n22
      false, // mroll/n23
      false, // mroll/n24
      false, // mroll/n25
      false, // mroll/n26
      false, // mroll/n27
      false, // mroll/n28
      false, // mroll/n29
      false, // mroll/n30
      false, // mroll/n31
      false, // mroll/n32
      false, // mroll/n33
      false, // mroll/n34
      false, // mroll/n35
      false, // mroll/n36
      false, // mroll/n37
      false, // mroll/n38
      false, // mroll/n39
      false, // mroll/n40
      false, // mroll/n41
      false, // mroll/n42
      false, // mroll/n43
      false, // mroll/n44
      false, // mroll/n45
      false, // mroll/n46
      false, // mroll/n47
      false, // mroll/n48
      false, // mroll/n49
      false, // mroll/n50
      false, // mroll/n51
      false, // mroll/n52
      false, // mroll/n53
      false, // mroll/n54
      false, // mroll/n55
      false, // mroll/n56
      false, // mroll/n57
      false, // mroll/n58
      false, // mroll/n59
      false, // mroll/n60
      false, // mroll/n61
      false, // mroll/n62
      false, // mroll/n63
      false, // mroll/n64
      false, // mroll/n65
      false, // mroll/n66
      false, // mroll/n67
      false, // mroll/n68
      false, // mroll/n69
      false, // mroll/n70
      false, // mroll/nR
      false, // mrollforth
      false, // mrot
      false, // mul/%rR/%rR/%rR
      false, // mul/%rR/n2/%rR
      false, // mul/%rR/nR/%rR
      false, // mul/n2/%rR/%rR
      false, // mul/n2/n2/%rR
      false, // mul/n2/nR/%rR
      false, // mul/nR/%rR/%rR
      false, // mul/nR/n2/%rR
      false, // mul/nR/nR/%rR
      false, // mulo/%rR/%rR/%rR/fR
      false, // mulo/%rR/n2/%rR/fR
      false, // mulo/%rR/nR/%rR/fR
      false, // mulo/nR/%rR/%rR/fR
      false, // mulo/nR/n2/%rR/fR
      false, // mulo/nR/nR/%rR/fR
      false, // nop
      false, // print-pending-signals/retR
      false, // print-topmost/nR/retR
      false, // printfixnum/%rR/retR
      false, // printfixnum/nR/retR
      false, // printufixnum/%rR/retR
      false, // printufixnum/nR/retR
      true, // procedurecall/fR/retR
      true, // procedurecallr/%rR/retR
      true, // procedurecallr/lR/retR
      false, // procedureprolog
      false, // procedurereturn
      false, // push-depths/nR/retR
      false, // push-handler/n0/lR
      false, // push-handler/n1/lR
      false, // push-handler/n2/lR
      false, // push-handler/n3/lR
      false, // push-handler/n4/lR
      false, // push-handler/n5/lR
      false, // push-handler/n6/lR
      false, // push-handler/n7/lR
      false, // push-handler/n8/lR
      false, // push-handler/n9/lR
      false, // push-handler/n10/lR
      false, // push-handler/nR/lR
      false, // push-increasing/nR/retR
      false, // quake
      false, // raise/%rR
      false, // raise/n0
      false, // raise/n1
      false, // raise/n2
      false, // raise/n3
      false, // raise/n4
      false, // raise/n5
      false, // raise/n6
      false, // raise/n7
      false, // raise/n8
      false, // raise/n9
      false, // raise/n10
      false, // raise/nR
      false, // random/%rR/retR
      false, // reverse/n0
      false, // reverse/n1
      false, // reverse/n2
      false, // reverse/n3
      false, // reverse/n4
      false, // reverse/n5
      false, // reverse/n6
      false, // reverse/n7
      false, // reverse/n8
      false, // reverse/n9
      false, // reverse/n10
      false, // reverse/n11
      false, // reverse/n12
      false, // reverse/n13
      false, // reverse/n14
      false, // reverse/n15
      false, // reverse/n16
      false, // reverse/n17
      false, // reverse/n18
      false, // reverse/n19
      false, // reverse/n20
      false, // reverse/n21
      false, // reverse/n22
      false, // reverse/n23
      false, // reverse/n24
      false, // reverse/n25
      false, // reverse/n26
      false, // reverse/n27
      false, // reverse/n28
      false, // reverse/n29
      false, // reverse/n30
      false, // reverse/n31
      false, // reverse/n32
      false, // reverse/n33
      false, // reverse/n34
      false, // reverse/n35
      false, // reverse/n36
      false, // reverse/n37
      false, // reverse/n38
      false, // reverse/n39
      false, // reverse/n40
      false, // reverse/n41
      false, // reverse/n42
      false, // reverse/n43
      false, // reverse/n44
      false, // reverse/n45
      false, // reverse/n46
      false, // reverse/n47
      false, // reverse/n48
      false, // reverse/n49
      false, // reverse/n50
      false, // reverse/n51
      false, // reverse/n52
      false, // reverse/n53
      false, // reverse/n54
      false, // reverse/n55
      false, // reverse/n56
      false, // reverse/n57
      false, // reverse/n58
      false, // reverse/n59
      false, // reverse/n60
      false, // reverse/n61
      false, // reverse/n62
      false, // reverse/n63
      false, // reverse/n64
      false, // reverse/n65
      false, // reverse/n66
      false, // reverse/n67
      false, // reverse/n68
      false, // reverse/n69
      false, // reverse/n70
      false, // reverse/nR
      false, // roll/n0
      false, // roll/n1
      false, // roll/n2
      false, // roll/n3
      false, // roll/n4
      false, // roll/n5
      false, // roll/n6
      false, // roll/n7
      false, // roll/n8
      false, // roll/n9
      false, // roll/n10
      false, // roll/n11
      false, // roll/n12
      false, // roll/n13
      false, // roll/n14
      false, // roll/n15
      false, // roll/n16
      false, // roll/n17
      false, // roll/n18
      false, // roll/n19
      false, // roll/n20
      false, // roll/n21
      false, // roll/n22
      false, // roll/n23
      false, // roll/n24
      false, // roll/n25
      false, // roll/n26
      false, // roll/n27
      false, // roll/n28
      false, // roll/n29
      false, // roll/n30
      false, // roll/n31
      false, // roll/n32
      false, // roll/n33
      false, // roll/n34
      false, // roll/n35
      false, // roll/n36
      false, // roll/n37
      false, // roll/n38
      false, // roll/n39
      false, // roll/n40
      false, // roll/n41
      false, // roll/n42
      false, // roll/n43
      false, // roll/n44
      false, // roll/n45
      false, // roll/n46
      false, // roll/n47
      false, // roll/n48
      false, // roll/n49
      false, // roll/n50
      false, // roll/n51
      false, // roll/n52
      false, // roll/n53
      false, // roll/n54
      false, // roll/n55
      false, // roll/n56
      false, // roll/n57
      false, // roll/n58
      false, // roll/n59
      false, // roll/n60
      false, // roll/n61
      false, // roll/n62
      false, // roll/n63
      false, // roll/n64
      false, // roll/n65
      false, // roll/n66
      false, // roll/n67
      false, // roll/n68
      false, // roll/n69
      false, // roll/n70
      false, // roll/nR
      false, // rollforth
      false, // rot
      false, // safe-point/fR
      false, // set-pending
      false, // slide/n1/n1
      false, // slide/n1/n2
      false, // slide/n1/n3
      false, // slide/n1/n4
      false, // slide/n1/n5
      false, // slide/n1/nR
      false, // slide/n2/n1
      false, // slide/n2/n2
      false, // slide/n2/n3
      false, // slide/n2/n4
      false, // slide/n2/n5
      false, // slide/n2/nR
      false, // slide/n3/n1
      false, // slide/n3/n2
      false, // slide/n3/n3
      false, // slide/n3/n4
      false, // slide/n3/n5
      false, // slide/n3/nR
      false, // slide/nR/n1
      false, // slide/nR/n2
      false, // slide/nR/n3
      false, // slide/nR/n4
      false, // slide/nR/n5
      false, // slide/nR/nR
      false, // slideforth
      false, // stackdrop
      false, // stackdup
      false, // stackif/fR
      false, // stacknip
      false, // stacknondroppingif/fR
      false, // stacknot
      false, // stackoneminus
      false, // stackoneplus
      false, // stackover
      false, // stackpeek/%rR
      false, // stackplus
      false, // stackplusr/%rR
      false, // stackpop/%rR
      false, // stackprint/retR
      false, // stackpush/%rR
      false, // stackpush/n0
      false, // stackpush/n1
      false, // stackpush/nR
      false, // stackpush/lR
      false, // stackpushunspecified
      false, // stackset/%rR
      false, // stackset/n0
      false, // stackset/n1
      false, // stackset/nR
      false, // stackset/lR
      false, // stackswap
      false, // stackswaptop/%rR
      false, // stacktimes
      false, // storewithbyteoffset/%rR/%rR/%rR
      false, // storewithbyteoffset/%rR/%rR/n0
      false, // storewithbyteoffset/%rR/%rR/n8
      false, // storewithbyteoffset/%rR/%rR/nR
      false, // storewithbyteoffset/nR/%rR/%rR
      false, // storewithbyteoffset/nR/%rR/n0
      false, // storewithbyteoffset/nR/%rR/n8
      false, // storewithbyteoffset/nR/%rR/nR
      false, // storewithwordoffset/%rR/%rR/%rR
      false, // storewithwordoffset/%rR/%rR/n0
      false, // storewithwordoffset/%rR/%rR/n1
      false, // storewithwordoffset/%rR/%rR/n2
      false, // storewithwordoffset/%rR/%rR/nR
      false, // storewithwordoffset/nR/%rR/%rR
      false, // storewithwordoffset/nR/%rR/n0
      false, // storewithwordoffset/nR/%rR/n1
      false, // storewithwordoffset/nR/%rR/n2
      false, // storewithwordoffset/nR/%rR/nR
      false, // sub/%rR/%rR/%rR
      false, // sub/%rR/n1/%rR
      false, // sub/%rR/nR/%rR
      false, // sub/n0/%rR/%rR
      false, // sub/n0/n1/%rR
      false, // sub/n0/nR/%rR
      false, // sub/nR/%rR/%rR
      false, // sub/nR/n1/%rR
      false, // sub/nR/nR/%rR
      false, // subo/%rR/%rR/%rR/fR
      false, // subo/%rR/n1/%rR/fR
      false, // subo/%rR/nR/%rR/fR
      false, // subo/nR/%rR/%rR/fR
      false, // subo/nR/n1/%rR/fR
      false, // subo/nR/nR/%rR/fR
      false, // tuck
      false, // unreachable
      false, // whirl/n0
      false, // whirl/n1
      false, // whirl/n2
      false, // whirl/n3
      false, // whirl/nR
      false, // whirlforth
      false, // !REPLACEMENT-addo/%rR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-addo/%rR/n1/%rR/fR/retR
      false, // !REPLACEMENT-addo/%rR/n-1/%rR/fR/retR
      false, // !REPLACEMENT-addo/%rR/nR/%rR/fR/retR
      false, // !REPLACEMENT-addo/nR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-addo/nR/n1/%rR/fR/retR
      false, // !REPLACEMENT-addo/nR/n-1/%rR/fR/retR
      false, // !REPLACEMENT-addo/nR/nR/%rR/fR/retR
      false, // !REPLACEMENT-b/fR/retR
      false, // !REPLACEMENT-band/%rR/%rR/fR/retR
      false, // !REPLACEMENT-band/%rR/n3/fR/retR
      false, // !REPLACEMENT-band/%rR/n7/fR/retR
      false, // !REPLACEMENT-band/%rR/nR/fR/retR
      false, // !REPLACEMENT-band/nR/%rR/fR/retR
      false, // !REPLACEMENT-band/nR/n3/fR/retR
      false, // !REPLACEMENT-band/nR/n7/fR/retR
      false, // !REPLACEMENT-band/nR/nR/fR/retR
      false, // !REPLACEMENT-beq/%rR/%rR/fR/retR
      false, // !REPLACEMENT-beq/%rR/nR/fR/retR
      false, // !REPLACEMENT-beq/nR/%rR/fR/retR
      false, // !REPLACEMENT-beq/nR/nR/fR/retR
      false, // !REPLACEMENT-bge/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bge/%rR/n0/fR/retR
      false, // !REPLACEMENT-bge/%rR/n1/fR/retR
      false, // !REPLACEMENT-bge/%rR/nR/fR/retR
      false, // !REPLACEMENT-bge/n0/%rR/fR/retR
      false, // !REPLACEMENT-bge/n0/n0/fR/retR
      false, // !REPLACEMENT-bge/n0/n1/fR/retR
      false, // !REPLACEMENT-bge/n0/nR/fR/retR
      false, // !REPLACEMENT-bge/n1/%rR/fR/retR
      false, // !REPLACEMENT-bge/n1/n0/fR/retR
      false, // !REPLACEMENT-bge/n1/n1/fR/retR
      false, // !REPLACEMENT-bge/n1/nR/fR/retR
      false, // !REPLACEMENT-bge/nR/%rR/fR/retR
      false, // !REPLACEMENT-bge/nR/n0/fR/retR
      false, // !REPLACEMENT-bge/nR/n1/fR/retR
      false, // !REPLACEMENT-bge/nR/nR/fR/retR
      false, // !REPLACEMENT-bgeu/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bgeu/%rR/n0/fR/retR
      false, // !REPLACEMENT-bgeu/%rR/n1/fR/retR
      false, // !REPLACEMENT-bgeu/%rR/nR/fR/retR
      false, // !REPLACEMENT-bgeu/n0/%rR/fR/retR
      false, // !REPLACEMENT-bgeu/n0/n0/fR/retR
      false, // !REPLACEMENT-bgeu/n0/n1/fR/retR
      false, // !REPLACEMENT-bgeu/n0/nR/fR/retR
      false, // !REPLACEMENT-bgeu/n1/%rR/fR/retR
      false, // !REPLACEMENT-bgeu/n1/n0/fR/retR
      false, // !REPLACEMENT-bgeu/n1/n1/fR/retR
      false, // !REPLACEMENT-bgeu/n1/nR/fR/retR
      false, // !REPLACEMENT-bgeu/nR/%rR/fR/retR
      false, // !REPLACEMENT-bgeu/nR/n0/fR/retR
      false, // !REPLACEMENT-bgeu/nR/n1/fR/retR
      false, // !REPLACEMENT-bgeu/nR/nR/fR/retR
      false, // !REPLACEMENT-bgt/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bgt/%rR/n0/fR/retR
      false, // !REPLACEMENT-bgt/%rR/n1/fR/retR
      false, // !REPLACEMENT-bgt/%rR/nR/fR/retR
      false, // !REPLACEMENT-bgt/n0/%rR/fR/retR
      false, // !REPLACEMENT-bgt/n0/n0/fR/retR
      false, // !REPLACEMENT-bgt/n0/n1/fR/retR
      false, // !REPLACEMENT-bgt/n0/nR/fR/retR
      false, // !REPLACEMENT-bgt/n1/%rR/fR/retR
      false, // !REPLACEMENT-bgt/n1/n0/fR/retR
      false, // !REPLACEMENT-bgt/n1/n1/fR/retR
      false, // !REPLACEMENT-bgt/n1/nR/fR/retR
      false, // !REPLACEMENT-bgt/nR/%rR/fR/retR
      false, // !REPLACEMENT-bgt/nR/n0/fR/retR
      false, // !REPLACEMENT-bgt/nR/n1/fR/retR
      false, // !REPLACEMENT-bgt/nR/nR/fR/retR
      false, // !REPLACEMENT-bgtu/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bgtu/%rR/n0/fR/retR
      false, // !REPLACEMENT-bgtu/%rR/n1/fR/retR
      false, // !REPLACEMENT-bgtu/%rR/nR/fR/retR
      false, // !REPLACEMENT-bgtu/n0/%rR/fR/retR
      false, // !REPLACEMENT-bgtu/n0/n0/fR/retR
      false, // !REPLACEMENT-bgtu/n0/n1/fR/retR
      false, // !REPLACEMENT-bgtu/n0/nR/fR/retR
      false, // !REPLACEMENT-bgtu/n1/%rR/fR/retR
      false, // !REPLACEMENT-bgtu/n1/n0/fR/retR
      false, // !REPLACEMENT-bgtu/n1/n1/fR/retR
      false, // !REPLACEMENT-bgtu/n1/nR/fR/retR
      false, // !REPLACEMENT-bgtu/nR/%rR/fR/retR
      false, // !REPLACEMENT-bgtu/nR/n0/fR/retR
      false, // !REPLACEMENT-bgtu/nR/n1/fR/retR
      false, // !REPLACEMENT-bgtu/nR/nR/fR/retR
      false, // !REPLACEMENT-ble/%rR/%rR/fR/retR
      false, // !REPLACEMENT-ble/%rR/n0/fR/retR
      false, // !REPLACEMENT-ble/%rR/n1/fR/retR
      false, // !REPLACEMENT-ble/%rR/nR/fR/retR
      false, // !REPLACEMENT-ble/n0/%rR/fR/retR
      false, // !REPLACEMENT-ble/n0/n0/fR/retR
      false, // !REPLACEMENT-ble/n0/n1/fR/retR
      false, // !REPLACEMENT-ble/n0/nR/fR/retR
      false, // !REPLACEMENT-ble/n1/%rR/fR/retR
      false, // !REPLACEMENT-ble/n1/n0/fR/retR
      false, // !REPLACEMENT-ble/n1/n1/fR/retR
      false, // !REPLACEMENT-ble/n1/nR/fR/retR
      false, // !REPLACEMENT-ble/nR/%rR/fR/retR
      false, // !REPLACEMENT-ble/nR/n0/fR/retR
      false, // !REPLACEMENT-ble/nR/n1/fR/retR
      false, // !REPLACEMENT-ble/nR/nR/fR/retR
      false, // !REPLACEMENT-bleu/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bleu/%rR/n0/fR/retR
      false, // !REPLACEMENT-bleu/%rR/n1/fR/retR
      false, // !REPLACEMENT-bleu/%rR/nR/fR/retR
      false, // !REPLACEMENT-bleu/n0/%rR/fR/retR
      false, // !REPLACEMENT-bleu/n0/n0/fR/retR
      false, // !REPLACEMENT-bleu/n0/n1/fR/retR
      false, // !REPLACEMENT-bleu/n0/nR/fR/retR
      false, // !REPLACEMENT-bleu/n1/%rR/fR/retR
      false, // !REPLACEMENT-bleu/n1/n0/fR/retR
      false, // !REPLACEMENT-bleu/n1/n1/fR/retR
      false, // !REPLACEMENT-bleu/n1/nR/fR/retR
      false, // !REPLACEMENT-bleu/nR/%rR/fR/retR
      false, // !REPLACEMENT-bleu/nR/n0/fR/retR
      false, // !REPLACEMENT-bleu/nR/n1/fR/retR
      false, // !REPLACEMENT-bleu/nR/nR/fR/retR
      false, // !REPLACEMENT-blt/%rR/%rR/fR/retR
      false, // !REPLACEMENT-blt/%rR/n0/fR/retR
      false, // !REPLACEMENT-blt/%rR/n1/fR/retR
      false, // !REPLACEMENT-blt/%rR/nR/fR/retR
      false, // !REPLACEMENT-blt/n0/%rR/fR/retR
      false, // !REPLACEMENT-blt/n0/n0/fR/retR
      false, // !REPLACEMENT-blt/n0/n1/fR/retR
      false, // !REPLACEMENT-blt/n0/nR/fR/retR
      false, // !REPLACEMENT-blt/n1/%rR/fR/retR
      false, // !REPLACEMENT-blt/n1/n0/fR/retR
      false, // !REPLACEMENT-blt/n1/n1/fR/retR
      false, // !REPLACEMENT-blt/n1/nR/fR/retR
      false, // !REPLACEMENT-blt/nR/%rR/fR/retR
      false, // !REPLACEMENT-blt/nR/n0/fR/retR
      false, // !REPLACEMENT-blt/nR/n1/fR/retR
      false, // !REPLACEMENT-blt/nR/nR/fR/retR
      false, // !REPLACEMENT-bltu/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bltu/%rR/n0/fR/retR
      false, // !REPLACEMENT-bltu/%rR/n1/fR/retR
      false, // !REPLACEMENT-bltu/%rR/nR/fR/retR
      false, // !REPLACEMENT-bltu/n0/%rR/fR/retR
      false, // !REPLACEMENT-bltu/n0/n0/fR/retR
      false, // !REPLACEMENT-bltu/n0/n1/fR/retR
      false, // !REPLACEMENT-bltu/n0/nR/fR/retR
      false, // !REPLACEMENT-bltu/n1/%rR/fR/retR
      false, // !REPLACEMENT-bltu/n1/n0/fR/retR
      false, // !REPLACEMENT-bltu/n1/n1/fR/retR
      false, // !REPLACEMENT-bltu/n1/nR/fR/retR
      false, // !REPLACEMENT-bltu/nR/%rR/fR/retR
      false, // !REPLACEMENT-bltu/nR/n0/fR/retR
      false, // !REPLACEMENT-bltu/nR/n1/fR/retR
      false, // !REPLACEMENT-bltu/nR/nR/fR/retR
      false, // !REPLACEMENT-bne/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bne/%rR/n0/fR/retR
      false, // !REPLACEMENT-bne/%rR/nR/fR/retR
      false, // !REPLACEMENT-bne/n0/%rR/fR/retR
      false, // !REPLACEMENT-bne/n0/n0/fR/retR
      false, // !REPLACEMENT-bne/n0/nR/fR/retR
      false, // !REPLACEMENT-bne/nR/%rR/fR/retR
      false, // !REPLACEMENT-bne/nR/n0/fR/retR
      false, // !REPLACEMENT-bne/nR/nR/fR/retR
      false, // !REPLACEMENT-bneg/%rR/fR/retR
      false, // !REPLACEMENT-bneg/nR/fR/retR
      false, // !REPLACEMENT-bnneg/%rR/fR/retR
      false, // !REPLACEMENT-bnneg/nR/fR/retR
      false, // !REPLACEMENT-bnotand/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bnotand/%rR/n3/fR/retR
      false, // !REPLACEMENT-bnotand/%rR/n7/fR/retR
      false, // !REPLACEMENT-bnotand/%rR/nR/fR/retR
      false, // !REPLACEMENT-bnotand/nR/%rR/fR/retR
      false, // !REPLACEMENT-bnotand/nR/n3/fR/retR
      false, // !REPLACEMENT-bnotand/nR/n7/fR/retR
      false, // !REPLACEMENT-bnotand/nR/nR/fR/retR
      false, // !REPLACEMENT-bnpos/%rR/fR/retR
      false, // !REPLACEMENT-bnpos/nR/fR/retR
      false, // !REPLACEMENT-bnz/%rR/fR/retR
      false, // !REPLACEMENT-bnz/nR/fR/retR
      false, // !REPLACEMENT-bpos/%rR/fR/retR
      false, // !REPLACEMENT-bpos/nR/fR/retR
      false, // !REPLACEMENT-br/%rR/retR
      false, // !REPLACEMENT-bz/%rR/fR/retR
      false, // !REPLACEMENT-bz/nR/fR/retR
      false, // !REPLACEMENT-divo/%rR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-divo/%rR/n2/%rR/fR/retR
      false, // !REPLACEMENT-divo/%rR/nR/%rR/fR/retR
      false, // !REPLACEMENT-divo/nR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-divo/nR/n2/%rR/fR/retR
      false, // !REPLACEMENT-divo/nR/nR/%rR/fR/retR
      false, // !REPLACEMENT-endvm/retR
      false, // !REPLACEMENT-exitvm/retR
      false, // !REPLACEMENT-modo/%rR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-modo/%rR/n2/%rR/fR/retR
      false, // !REPLACEMENT-modo/%rR/nR/%rR/fR/retR
      false, // !REPLACEMENT-modo/nR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-modo/nR/n2/%rR/fR/retR
      false, // !REPLACEMENT-modo/nR/nR/%rR/fR/retR
      false, // !REPLACEMENT-mulo/%rR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-mulo/%rR/n2/%rR/fR/retR
      false, // !REPLACEMENT-mulo/%rR/nR/%rR/fR/retR
      false, // !REPLACEMENT-mulo/nR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-mulo/nR/n2/%rR/fR/retR
      false, // !REPLACEMENT-mulo/nR/nR/%rR/fR/retR
      true, // !REPLACEMENT-procedurecall/fR/retR
      true, // !REPLACEMENT-procedurecallr/%rR/retR
      true, // !REPLACEMENT-procedurecallr/lR/retR
      false, // !REPLACEMENT-procedureprolog/retR
      false, // !REPLACEMENT-procedurereturn/retR
      false, // !REPLACEMENT-raise/%rR/retR
      false, // !REPLACEMENT-raise/n0/retR
      false, // !REPLACEMENT-raise/n1/retR
      false, // !REPLACEMENT-raise/n2/retR
      false, // !REPLACEMENT-raise/n3/retR
      false, // !REPLACEMENT-raise/n4/retR
      false, // !REPLACEMENT-raise/n5/retR
      false, // !REPLACEMENT-raise/n6/retR
      false, // !REPLACEMENT-raise/n7/retR
      false, // !REPLACEMENT-raise/n8/retR
      false, // !REPLACEMENT-raise/n9/retR
      false, // !REPLACEMENT-raise/n10/retR
      false, // !REPLACEMENT-raise/nR/retR
      false, // !REPLACEMENT-safe-point/fR/retR
      false, // !REPLACEMENT-stackif/fR/retR
      false, // !REPLACEMENT-stacknondroppingif/fR/retR
      false, // !REPLACEMENT-subo/%rR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-subo/%rR/n1/%rR/fR/retR
      false, // !REPLACEMENT-subo/%rR/nR/%rR/fR/retR
      false, // !REPLACEMENT-subo/nR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-subo/nR/n1/%rR/fR/retR
      false, // !REPLACEMENT-subo/nR/nR/%rR/fR/retR
      false // !REPLACEMENT-unreachable/retR
    };

// FIXME: this is not currently accessed, and in fact may be useless.
const bool
uninspired_specialized_instruction_callees [UNINSPIRED_SPECIALIZED_INSTRUCTION_NO]
  = {
      false, // !INVALID
      false, // !BEGINBASICBLOCK
      false, // !EXITVM
      false, // !DATALOCATIONS
      false, // !NOP
      false, // !UNREACHABLE0
      false, // !UNREACHABLE1
      false, // !PRETENDTOJUMPANYWHERE
      false, // add/%rR/%rR/%rR
      false, // add/%rR/n1/%rR
      false, // add/%rR/n-1/%rR
      false, // add/%rR/nR/%rR
      false, // add/n1/%rR/%rR
      false, // add/n1/n1/%rR
      false, // add/n1/n-1/%rR
      false, // add/n1/nR/%rR
      false, // add/n-1/%rR/%rR
      false, // add/n-1/n1/%rR
      false, // add/n-1/n-1/%rR
      false, // add/n-1/nR/%rR
      false, // add/nR/%rR/%rR
      false, // add/nR/n1/%rR
      false, // add/nR/n-1/%rR
      false, // add/nR/nR/%rR
      false, // addo/%rR/%rR/%rR/fR
      false, // addo/%rR/n1/%rR/fR
      false, // addo/%rR/n-1/%rR/fR
      false, // addo/%rR/nR/%rR/fR
      false, // addo/nR/%rR/%rR/fR
      false, // addo/nR/n1/%rR/fR
      false, // addo/nR/n-1/%rR/fR
      false, // addo/nR/nR/%rR/fR
      false, // b/fR
      false, // band/%rR/%rR/fR
      false, // band/%rR/n3/fR
      false, // band/%rR/n7/fR
      false, // band/%rR/nR/fR
      false, // band/nR/%rR/fR
      false, // band/nR/n3/fR
      false, // band/nR/n7/fR
      false, // band/nR/nR/fR
      false, // beq/%rR/%rR/fR
      false, // beq/%rR/nR/fR
      false, // beq/nR/%rR/fR
      false, // beq/nR/nR/fR
      false, // bge/%rR/%rR/fR
      false, // bge/%rR/n0/fR
      false, // bge/%rR/n1/fR
      false, // bge/%rR/nR/fR
      false, // bge/n0/%rR/fR
      false, // bge/n0/n0/fR
      false, // bge/n0/n1/fR
      false, // bge/n0/nR/fR
      false, // bge/n1/%rR/fR
      false, // bge/n1/n0/fR
      false, // bge/n1/n1/fR
      false, // bge/n1/nR/fR
      false, // bge/nR/%rR/fR
      false, // bge/nR/n0/fR
      false, // bge/nR/n1/fR
      false, // bge/nR/nR/fR
      false, // bgeu/%rR/%rR/fR
      false, // bgeu/%rR/n0/fR
      false, // bgeu/%rR/n1/fR
      false, // bgeu/%rR/nR/fR
      false, // bgeu/n0/%rR/fR
      false, // bgeu/n0/n0/fR
      false, // bgeu/n0/n1/fR
      false, // bgeu/n0/nR/fR
      false, // bgeu/n1/%rR/fR
      false, // bgeu/n1/n0/fR
      false, // bgeu/n1/n1/fR
      false, // bgeu/n1/nR/fR
      false, // bgeu/nR/%rR/fR
      false, // bgeu/nR/n0/fR
      false, // bgeu/nR/n1/fR
      false, // bgeu/nR/nR/fR
      false, // bgt/%rR/%rR/fR
      false, // bgt/%rR/n0/fR
      false, // bgt/%rR/n1/fR
      false, // bgt/%rR/nR/fR
      false, // bgt/n0/%rR/fR
      false, // bgt/n0/n0/fR
      false, // bgt/n0/n1/fR
      false, // bgt/n0/nR/fR
      false, // bgt/n1/%rR/fR
      false, // bgt/n1/n0/fR
      false, // bgt/n1/n1/fR
      false, // bgt/n1/nR/fR
      false, // bgt/nR/%rR/fR
      false, // bgt/nR/n0/fR
      false, // bgt/nR/n1/fR
      false, // bgt/nR/nR/fR
      false, // bgtu/%rR/%rR/fR
      false, // bgtu/%rR/n0/fR
      false, // bgtu/%rR/n1/fR
      false, // bgtu/%rR/nR/fR
      false, // bgtu/n0/%rR/fR
      false, // bgtu/n0/n0/fR
      false, // bgtu/n0/n1/fR
      false, // bgtu/n0/nR/fR
      false, // bgtu/n1/%rR/fR
      false, // bgtu/n1/n0/fR
      false, // bgtu/n1/n1/fR
      false, // bgtu/n1/nR/fR
      false, // bgtu/nR/%rR/fR
      false, // bgtu/nR/n0/fR
      false, // bgtu/nR/n1/fR
      false, // bgtu/nR/nR/fR
      false, // ble/%rR/%rR/fR
      false, // ble/%rR/n0/fR
      false, // ble/%rR/n1/fR
      false, // ble/%rR/nR/fR
      false, // ble/n0/%rR/fR
      false, // ble/n0/n0/fR
      false, // ble/n0/n1/fR
      false, // ble/n0/nR/fR
      false, // ble/n1/%rR/fR
      false, // ble/n1/n0/fR
      false, // ble/n1/n1/fR
      false, // ble/n1/nR/fR
      false, // ble/nR/%rR/fR
      false, // ble/nR/n0/fR
      false, // ble/nR/n1/fR
      false, // ble/nR/nR/fR
      false, // bleu/%rR/%rR/fR
      false, // bleu/%rR/n0/fR
      false, // bleu/%rR/n1/fR
      false, // bleu/%rR/nR/fR
      false, // bleu/n0/%rR/fR
      false, // bleu/n0/n0/fR
      false, // bleu/n0/n1/fR
      false, // bleu/n0/nR/fR
      false, // bleu/n1/%rR/fR
      false, // bleu/n1/n0/fR
      false, // bleu/n1/n1/fR
      false, // bleu/n1/nR/fR
      false, // bleu/nR/%rR/fR
      false, // bleu/nR/n0/fR
      false, // bleu/nR/n1/fR
      false, // bleu/nR/nR/fR
      false, // blt/%rR/%rR/fR
      false, // blt/%rR/n0/fR
      false, // blt/%rR/n1/fR
      false, // blt/%rR/nR/fR
      false, // blt/n0/%rR/fR
      false, // blt/n0/n0/fR
      false, // blt/n0/n1/fR
      false, // blt/n0/nR/fR
      false, // blt/n1/%rR/fR
      false, // blt/n1/n0/fR
      false, // blt/n1/n1/fR
      false, // blt/n1/nR/fR
      false, // blt/nR/%rR/fR
      false, // blt/nR/n0/fR
      false, // blt/nR/n1/fR
      false, // blt/nR/nR/fR
      false, // bltu/%rR/%rR/fR
      false, // bltu/%rR/n0/fR
      false, // bltu/%rR/n1/fR
      false, // bltu/%rR/nR/fR
      false, // bltu/n0/%rR/fR
      false, // bltu/n0/n0/fR
      false, // bltu/n0/n1/fR
      false, // bltu/n0/nR/fR
      false, // bltu/n1/%rR/fR
      false, // bltu/n1/n0/fR
      false, // bltu/n1/n1/fR
      false, // bltu/n1/nR/fR
      false, // bltu/nR/%rR/fR
      false, // bltu/nR/n0/fR
      false, // bltu/nR/n1/fR
      false, // bltu/nR/nR/fR
      false, // bne/%rR/%rR/fR
      false, // bne/%rR/n0/fR
      false, // bne/%rR/nR/fR
      false, // bne/n0/%rR/fR
      false, // bne/n0/n0/fR
      false, // bne/n0/nR/fR
      false, // bne/nR/%rR/fR
      false, // bne/nR/n0/fR
      false, // bne/nR/nR/fR
      false, // bneg/%rR/fR
      false, // bneg/nR/fR
      false, // bnneg/%rR/fR
      false, // bnneg/nR/fR
      false, // bnotand/%rR/%rR/fR
      false, // bnotand/%rR/n3/fR
      false, // bnotand/%rR/n7/fR
      false, // bnotand/%rR/nR/fR
      false, // bnotand/nR/%rR/fR
      false, // bnotand/nR/n3/fR
      false, // bnotand/nR/n7/fR
      false, // bnotand/nR/nR/fR
      false, // bnpos/%rR/fR
      false, // bnpos/nR/fR
      false, // bnz/%rR/fR
      false, // bnz/nR/fR
      false, // bpos/%rR/fR
      false, // bpos/nR/fR
      false, // br/%rR
      false, // bulge/n0
      false, // bulge/n1
      false, // bulge/n2
      false, // bulge/n3
      false, // bulge/nR
      false, // bulgeforth
      false, // bz/%rR/fR
      false, // bz/nR/fR
      false, // clear-pending/retR
      false, // div/%rR/%rR/%rR/retR
      false, // div/%rR/n2/%rR/retR
      false, // div/%rR/nR/%rR/retR
      false, // div/nR/%rR/%rR/retR
      false, // div/nR/n2/%rR/retR
      false, // div/nR/nR/%rR/retR
      false, // divo/%rR/%rR/%rR/fR
      false, // divo/%rR/n2/%rR/fR
      false, // divo/%rR/nR/%rR/fR
      false, // divo/nR/%rR/%rR/fR
      false, // divo/nR/n2/%rR/fR
      false, // divo/nR/nR/%rR/fR
      false, // drop-handler
      false, // endvm
      false, // exit/%rR/retR
      false, // exit/nR/retR
      false, // exitvm
      false, // fadd/%fR/%fR/%fR
      false, // fdiv/%fR/%fR/%fR
      false, // fincr/%fR
      false, // fmul/%fR/%fR/%fR
      false, // fprint/%fR
      false, // fset/%rR/%fR
      false, // fset/nR/%fR
      false, // fsub/%fR/%fR/%fR
      false, // hcf/retR
      false, // install-signal-handler/retR
      false, // loadwithbyteoffset/%rR/%rR/%rR
      false, // loadwithbyteoffset/%rR/n0/%rR
      false, // loadwithbyteoffset/%rR/n8/%rR
      false, // loadwithbyteoffset/%rR/nR/%rR
      false, // loadwithwordoffset/%rR/%rR/%rR
      false, // loadwithwordoffset/%rR/n0/%rR
      false, // loadwithwordoffset/%rR/n1/%rR
      false, // loadwithwordoffset/%rR/n2/%rR
      false, // loadwithwordoffset/%rR/nR/%rR
      false, // mallocwords/%rR/%rR/retR
      false, // mallocwords/nR/%rR/retR
      false, // mod/%rR/%rR/%rR/retR
      false, // mod/%rR/n2/%rR/retR
      false, // mod/%rR/nR/%rR/retR
      false, // mod/nR/%rR/%rR/retR
      false, // mod/nR/n2/%rR/retR
      false, // mod/nR/nR/%rR/retR
      false, // modo/%rR/%rR/%rR/fR
      false, // modo/%rR/n2/%rR/fR
      false, // modo/%rR/nR/%rR/fR
      false, // modo/nR/%rR/%rR/fR
      false, // modo/nR/n2/%rR/fR
      false, // modo/nR/nR/%rR/fR
      false, // mov/%rR/%rR
      false, // mov/n0/%rR
      false, // mov/n1/%rR
      false, // mov/nR/%rR
      false, // mov/lR/%rR
      false, // mroll/n0
      false, // mroll/n1
      false, // mroll/n2
      false, // mroll/n3
      false, // mroll/n4
      false, // mroll/n5
      false, // mroll/n6
      false, // mroll/n7
      false, // mroll/n8
      false, // mroll/n9
      false, // mroll/n10
      false, // mroll/n11
      false, // mroll/n12
      false, // mroll/n13
      false, // mroll/n14
      false, // mroll/n15
      false, // mroll/n16
      false, // mroll/n17
      false, // mroll/n18
      false, // mroll/n19
      false, // mroll/n20
      false, // mroll/n21
      false, // mroll/n22
      false, // mroll/n23
      false, // mroll/n24
      false, // mroll/n25
      false, // mroll/n26
      false, // mroll/n27
      false, // mroll/n28
      false, // mroll/n29
      false, // mroll/n30
      false, // mroll/n31
      false, // mroll/n32
      false, // mroll/n33
      false, // mroll/n34
      false, // mroll/n35
      false, // mroll/n36
      false, // mroll/n37
      false, // mroll/n38
      false, // mroll/n39
      false, // mroll/n40
      false, // mroll/n41
      false, // mroll/n42
      false, // mroll/n43
      false, // mroll/n44
      false, // mroll/n45
      false, // mroll/n46
      false, // mroll/n47
      false, // mroll/n48
      false, // mroll/n49
      false, // mroll/n50
      false, // mroll/n51
      false, // mroll/n52
      false, // mroll/n53
      false, // mroll/n54
      false, // mroll/n55
      false, // mroll/n56
      false, // mroll/n57
      false, // mroll/n58
      false, // mroll/n59
      false, // mroll/n60
      false, // mroll/n61
      false, // mroll/n62
      false, // mroll/n63
      false, // mroll/n64
      false, // mroll/n65
      false, // mroll/n66
      false, // mroll/n67
      false, // mroll/n68
      false, // mroll/n69
      false, // mroll/n70
      false, // mroll/nR
      false, // mrollforth
      false, // mrot
      false, // mul/%rR/%rR/%rR
      false, // mul/%rR/n2/%rR
      false, // mul/%rR/nR/%rR
      false, // mul/n2/%rR/%rR
      false, // mul/n2/n2/%rR
      false, // mul/n2/nR/%rR
      false, // mul/nR/%rR/%rR
      false, // mul/nR/n2/%rR
      false, // mul/nR/nR/%rR
      false, // mulo/%rR/%rR/%rR/fR
      false, // mulo/%rR/n2/%rR/fR
      false, // mulo/%rR/nR/%rR/fR
      false, // mulo/nR/%rR/%rR/fR
      false, // mulo/nR/n2/%rR/fR
      false, // mulo/nR/nR/%rR/fR
      false, // nop
      false, // print-pending-signals/retR
      false, // print-topmost/nR/retR
      false, // printfixnum/%rR/retR
      false, // printfixnum/nR/retR
      false, // printufixnum/%rR/retR
      false, // printufixnum/nR/retR
      false, // procedurecall/fR/retR
      false, // procedurecallr/%rR/retR
      false, // procedurecallr/lR/retR
      true, // procedureprolog
      false, // procedurereturn
      false, // push-depths/nR/retR
      false, // push-handler/n0/lR
      false, // push-handler/n1/lR
      false, // push-handler/n2/lR
      false, // push-handler/n3/lR
      false, // push-handler/n4/lR
      false, // push-handler/n5/lR
      false, // push-handler/n6/lR
      false, // push-handler/n7/lR
      false, // push-handler/n8/lR
      false, // push-handler/n9/lR
      false, // push-handler/n10/lR
      false, // push-handler/nR/lR
      false, // push-increasing/nR/retR
      false, // quake
      false, // raise/%rR
      false, // raise/n0
      false, // raise/n1
      false, // raise/n2
      false, // raise/n3
      false, // raise/n4
      false, // raise/n5
      false, // raise/n6
      false, // raise/n7
      false, // raise/n8
      false, // raise/n9
      false, // raise/n10
      false, // raise/nR
      false, // random/%rR/retR
      false, // reverse/n0
      false, // reverse/n1
      false, // reverse/n2
      false, // reverse/n3
      false, // reverse/n4
      false, // reverse/n5
      false, // reverse/n6
      false, // reverse/n7
      false, // reverse/n8
      false, // reverse/n9
      false, // reverse/n10
      false, // reverse/n11
      false, // reverse/n12
      false, // reverse/n13
      false, // reverse/n14
      false, // reverse/n15
      false, // reverse/n16
      false, // reverse/n17
      false, // reverse/n18
      false, // reverse/n19
      false, // reverse/n20
      false, // reverse/n21
      false, // reverse/n22
      false, // reverse/n23
      false, // reverse/n24
      false, // reverse/n25
      false, // reverse/n26
      false, // reverse/n27
      false, // reverse/n28
      false, // reverse/n29
      false, // reverse/n30
      false, // reverse/n31
      false, // reverse/n32
      false, // reverse/n33
      false, // reverse/n34
      false, // reverse/n35
      false, // reverse/n36
      false, // reverse/n37
      false, // reverse/n38
      false, // reverse/n39
      false, // reverse/n40
      false, // reverse/n41
      false, // reverse/n42
      false, // reverse/n43
      false, // reverse/n44
      false, // reverse/n45
      false, // reverse/n46
      false, // reverse/n47
      false, // reverse/n48
      false, // reverse/n49
      false, // reverse/n50
      false, // reverse/n51
      false, // reverse/n52
      false, // reverse/n53
      false, // reverse/n54
      false, // reverse/n55
      false, // reverse/n56
      false, // reverse/n57
      false, // reverse/n58
      false, // reverse/n59
      false, // reverse/n60
      false, // reverse/n61
      false, // reverse/n62
      false, // reverse/n63
      false, // reverse/n64
      false, // reverse/n65
      false, // reverse/n66
      false, // reverse/n67
      false, // reverse/n68
      false, // reverse/n69
      false, // reverse/n70
      false, // reverse/nR
      false, // roll/n0
      false, // roll/n1
      false, // roll/n2
      false, // roll/n3
      false, // roll/n4
      false, // roll/n5
      false, // roll/n6
      false, // roll/n7
      false, // roll/n8
      false, // roll/n9
      false, // roll/n10
      false, // roll/n11
      false, // roll/n12
      false, // roll/n13
      false, // roll/n14
      false, // roll/n15
      false, // roll/n16
      false, // roll/n17
      false, // roll/n18
      false, // roll/n19
      false, // roll/n20
      false, // roll/n21
      false, // roll/n22
      false, // roll/n23
      false, // roll/n24
      false, // roll/n25
      false, // roll/n26
      false, // roll/n27
      false, // roll/n28
      false, // roll/n29
      false, // roll/n30
      false, // roll/n31
      false, // roll/n32
      false, // roll/n33
      false, // roll/n34
      false, // roll/n35
      false, // roll/n36
      false, // roll/n37
      false, // roll/n38
      false, // roll/n39
      false, // roll/n40
      false, // roll/n41
      false, // roll/n42
      false, // roll/n43
      false, // roll/n44
      false, // roll/n45
      false, // roll/n46
      false, // roll/n47
      false, // roll/n48
      false, // roll/n49
      false, // roll/n50
      false, // roll/n51
      false, // roll/n52
      false, // roll/n53
      false, // roll/n54
      false, // roll/n55
      false, // roll/n56
      false, // roll/n57
      false, // roll/n58
      false, // roll/n59
      false, // roll/n60
      false, // roll/n61
      false, // roll/n62
      false, // roll/n63
      false, // roll/n64
      false, // roll/n65
      false, // roll/n66
      false, // roll/n67
      false, // roll/n68
      false, // roll/n69
      false, // roll/n70
      false, // roll/nR
      false, // rollforth
      false, // rot
      false, // safe-point/fR
      false, // set-pending
      false, // slide/n1/n1
      false, // slide/n1/n2
      false, // slide/n1/n3
      false, // slide/n1/n4
      false, // slide/n1/n5
      false, // slide/n1/nR
      false, // slide/n2/n1
      false, // slide/n2/n2
      false, // slide/n2/n3
      false, // slide/n2/n4
      false, // slide/n2/n5
      false, // slide/n2/nR
      false, // slide/n3/n1
      false, // slide/n3/n2
      false, // slide/n3/n3
      false, // slide/n3/n4
      false, // slide/n3/n5
      false, // slide/n3/nR
      false, // slide/nR/n1
      false, // slide/nR/n2
      false, // slide/nR/n3
      false, // slide/nR/n4
      false, // slide/nR/n5
      false, // slide/nR/nR
      false, // slideforth
      false, // stackdrop
      false, // stackdup
      false, // stackif/fR
      false, // stacknip
      false, // stacknondroppingif/fR
      false, // stacknot
      false, // stackoneminus
      false, // stackoneplus
      false, // stackover
      false, // stackpeek/%rR
      false, // stackplus
      false, // stackplusr/%rR
      false, // stackpop/%rR
      false, // stackprint/retR
      false, // stackpush/%rR
      false, // stackpush/n0
      false, // stackpush/n1
      false, // stackpush/nR
      false, // stackpush/lR
      false, // stackpushunspecified
      false, // stackset/%rR
      false, // stackset/n0
      false, // stackset/n1
      false, // stackset/nR
      false, // stackset/lR
      false, // stackswap
      false, // stackswaptop/%rR
      false, // stacktimes
      false, // storewithbyteoffset/%rR/%rR/%rR
      false, // storewithbyteoffset/%rR/%rR/n0
      false, // storewithbyteoffset/%rR/%rR/n8
      false, // storewithbyteoffset/%rR/%rR/nR
      false, // storewithbyteoffset/nR/%rR/%rR
      false, // storewithbyteoffset/nR/%rR/n0
      false, // storewithbyteoffset/nR/%rR/n8
      false, // storewithbyteoffset/nR/%rR/nR
      false, // storewithwordoffset/%rR/%rR/%rR
      false, // storewithwordoffset/%rR/%rR/n0
      false, // storewithwordoffset/%rR/%rR/n1
      false, // storewithwordoffset/%rR/%rR/n2
      false, // storewithwordoffset/%rR/%rR/nR
      false, // storewithwordoffset/nR/%rR/%rR
      false, // storewithwordoffset/nR/%rR/n0
      false, // storewithwordoffset/nR/%rR/n1
      false, // storewithwordoffset/nR/%rR/n2
      false, // storewithwordoffset/nR/%rR/nR
      false, // sub/%rR/%rR/%rR
      false, // sub/%rR/n1/%rR
      false, // sub/%rR/nR/%rR
      false, // sub/n0/%rR/%rR
      false, // sub/n0/n1/%rR
      false, // sub/n0/nR/%rR
      false, // sub/nR/%rR/%rR
      false, // sub/nR/n1/%rR
      false, // sub/nR/nR/%rR
      false, // subo/%rR/%rR/%rR/fR
      false, // subo/%rR/n1/%rR/fR
      false, // subo/%rR/nR/%rR/fR
      false, // subo/nR/%rR/%rR/fR
      false, // subo/nR/n1/%rR/fR
      false, // subo/nR/nR/%rR/fR
      false, // tuck
      false, // unreachable
      false, // whirl/n0
      false, // whirl/n1
      false, // whirl/n2
      false, // whirl/n3
      false, // whirl/nR
      false, // whirlforth
      false, // !REPLACEMENT-addo/%rR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-addo/%rR/n1/%rR/fR/retR
      false, // !REPLACEMENT-addo/%rR/n-1/%rR/fR/retR
      false, // !REPLACEMENT-addo/%rR/nR/%rR/fR/retR
      false, // !REPLACEMENT-addo/nR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-addo/nR/n1/%rR/fR/retR
      false, // !REPLACEMENT-addo/nR/n-1/%rR/fR/retR
      false, // !REPLACEMENT-addo/nR/nR/%rR/fR/retR
      false, // !REPLACEMENT-b/fR/retR
      false, // !REPLACEMENT-band/%rR/%rR/fR/retR
      false, // !REPLACEMENT-band/%rR/n3/fR/retR
      false, // !REPLACEMENT-band/%rR/n7/fR/retR
      false, // !REPLACEMENT-band/%rR/nR/fR/retR
      false, // !REPLACEMENT-band/nR/%rR/fR/retR
      false, // !REPLACEMENT-band/nR/n3/fR/retR
      false, // !REPLACEMENT-band/nR/n7/fR/retR
      false, // !REPLACEMENT-band/nR/nR/fR/retR
      false, // !REPLACEMENT-beq/%rR/%rR/fR/retR
      false, // !REPLACEMENT-beq/%rR/nR/fR/retR
      false, // !REPLACEMENT-beq/nR/%rR/fR/retR
      false, // !REPLACEMENT-beq/nR/nR/fR/retR
      false, // !REPLACEMENT-bge/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bge/%rR/n0/fR/retR
      false, // !REPLACEMENT-bge/%rR/n1/fR/retR
      false, // !REPLACEMENT-bge/%rR/nR/fR/retR
      false, // !REPLACEMENT-bge/n0/%rR/fR/retR
      false, // !REPLACEMENT-bge/n0/n0/fR/retR
      false, // !REPLACEMENT-bge/n0/n1/fR/retR
      false, // !REPLACEMENT-bge/n0/nR/fR/retR
      false, // !REPLACEMENT-bge/n1/%rR/fR/retR
      false, // !REPLACEMENT-bge/n1/n0/fR/retR
      false, // !REPLACEMENT-bge/n1/n1/fR/retR
      false, // !REPLACEMENT-bge/n1/nR/fR/retR
      false, // !REPLACEMENT-bge/nR/%rR/fR/retR
      false, // !REPLACEMENT-bge/nR/n0/fR/retR
      false, // !REPLACEMENT-bge/nR/n1/fR/retR
      false, // !REPLACEMENT-bge/nR/nR/fR/retR
      false, // !REPLACEMENT-bgeu/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bgeu/%rR/n0/fR/retR
      false, // !REPLACEMENT-bgeu/%rR/n1/fR/retR
      false, // !REPLACEMENT-bgeu/%rR/nR/fR/retR
      false, // !REPLACEMENT-bgeu/n0/%rR/fR/retR
      false, // !REPLACEMENT-bgeu/n0/n0/fR/retR
      false, // !REPLACEMENT-bgeu/n0/n1/fR/retR
      false, // !REPLACEMENT-bgeu/n0/nR/fR/retR
      false, // !REPLACEMENT-bgeu/n1/%rR/fR/retR
      false, // !REPLACEMENT-bgeu/n1/n0/fR/retR
      false, // !REPLACEMENT-bgeu/n1/n1/fR/retR
      false, // !REPLACEMENT-bgeu/n1/nR/fR/retR
      false, // !REPLACEMENT-bgeu/nR/%rR/fR/retR
      false, // !REPLACEMENT-bgeu/nR/n0/fR/retR
      false, // !REPLACEMENT-bgeu/nR/n1/fR/retR
      false, // !REPLACEMENT-bgeu/nR/nR/fR/retR
      false, // !REPLACEMENT-bgt/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bgt/%rR/n0/fR/retR
      false, // !REPLACEMENT-bgt/%rR/n1/fR/retR
      false, // !REPLACEMENT-bgt/%rR/nR/fR/retR
      false, // !REPLACEMENT-bgt/n0/%rR/fR/retR
      false, // !REPLACEMENT-bgt/n0/n0/fR/retR
      false, // !REPLACEMENT-bgt/n0/n1/fR/retR
      false, // !REPLACEMENT-bgt/n0/nR/fR/retR
      false, // !REPLACEMENT-bgt/n1/%rR/fR/retR
      false, // !REPLACEMENT-bgt/n1/n0/fR/retR
      false, // !REPLACEMENT-bgt/n1/n1/fR/retR
      false, // !REPLACEMENT-bgt/n1/nR/fR/retR
      false, // !REPLACEMENT-bgt/nR/%rR/fR/retR
      false, // !REPLACEMENT-bgt/nR/n0/fR/retR
      false, // !REPLACEMENT-bgt/nR/n1/fR/retR
      false, // !REPLACEMENT-bgt/nR/nR/fR/retR
      false, // !REPLACEMENT-bgtu/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bgtu/%rR/n0/fR/retR
      false, // !REPLACEMENT-bgtu/%rR/n1/fR/retR
      false, // !REPLACEMENT-bgtu/%rR/nR/fR/retR
      false, // !REPLACEMENT-bgtu/n0/%rR/fR/retR
      false, // !REPLACEMENT-bgtu/n0/n0/fR/retR
      false, // !REPLACEMENT-bgtu/n0/n1/fR/retR
      false, // !REPLACEMENT-bgtu/n0/nR/fR/retR
      false, // !REPLACEMENT-bgtu/n1/%rR/fR/retR
      false, // !REPLACEMENT-bgtu/n1/n0/fR/retR
      false, // !REPLACEMENT-bgtu/n1/n1/fR/retR
      false, // !REPLACEMENT-bgtu/n1/nR/fR/retR
      false, // !REPLACEMENT-bgtu/nR/%rR/fR/retR
      false, // !REPLACEMENT-bgtu/nR/n0/fR/retR
      false, // !REPLACEMENT-bgtu/nR/n1/fR/retR
      false, // !REPLACEMENT-bgtu/nR/nR/fR/retR
      false, // !REPLACEMENT-ble/%rR/%rR/fR/retR
      false, // !REPLACEMENT-ble/%rR/n0/fR/retR
      false, // !REPLACEMENT-ble/%rR/n1/fR/retR
      false, // !REPLACEMENT-ble/%rR/nR/fR/retR
      false, // !REPLACEMENT-ble/n0/%rR/fR/retR
      false, // !REPLACEMENT-ble/n0/n0/fR/retR
      false, // !REPLACEMENT-ble/n0/n1/fR/retR
      false, // !REPLACEMENT-ble/n0/nR/fR/retR
      false, // !REPLACEMENT-ble/n1/%rR/fR/retR
      false, // !REPLACEMENT-ble/n1/n0/fR/retR
      false, // !REPLACEMENT-ble/n1/n1/fR/retR
      false, // !REPLACEMENT-ble/n1/nR/fR/retR
      false, // !REPLACEMENT-ble/nR/%rR/fR/retR
      false, // !REPLACEMENT-ble/nR/n0/fR/retR
      false, // !REPLACEMENT-ble/nR/n1/fR/retR
      false, // !REPLACEMENT-ble/nR/nR/fR/retR
      false, // !REPLACEMENT-bleu/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bleu/%rR/n0/fR/retR
      false, // !REPLACEMENT-bleu/%rR/n1/fR/retR
      false, // !REPLACEMENT-bleu/%rR/nR/fR/retR
      false, // !REPLACEMENT-bleu/n0/%rR/fR/retR
      false, // !REPLACEMENT-bleu/n0/n0/fR/retR
      false, // !REPLACEMENT-bleu/n0/n1/fR/retR
      false, // !REPLACEMENT-bleu/n0/nR/fR/retR
      false, // !REPLACEMENT-bleu/n1/%rR/fR/retR
      false, // !REPLACEMENT-bleu/n1/n0/fR/retR
      false, // !REPLACEMENT-bleu/n1/n1/fR/retR
      false, // !REPLACEMENT-bleu/n1/nR/fR/retR
      false, // !REPLACEMENT-bleu/nR/%rR/fR/retR
      false, // !REPLACEMENT-bleu/nR/n0/fR/retR
      false, // !REPLACEMENT-bleu/nR/n1/fR/retR
      false, // !REPLACEMENT-bleu/nR/nR/fR/retR
      false, // !REPLACEMENT-blt/%rR/%rR/fR/retR
      false, // !REPLACEMENT-blt/%rR/n0/fR/retR
      false, // !REPLACEMENT-blt/%rR/n1/fR/retR
      false, // !REPLACEMENT-blt/%rR/nR/fR/retR
      false, // !REPLACEMENT-blt/n0/%rR/fR/retR
      false, // !REPLACEMENT-blt/n0/n0/fR/retR
      false, // !REPLACEMENT-blt/n0/n1/fR/retR
      false, // !REPLACEMENT-blt/n0/nR/fR/retR
      false, // !REPLACEMENT-blt/n1/%rR/fR/retR
      false, // !REPLACEMENT-blt/n1/n0/fR/retR
      false, // !REPLACEMENT-blt/n1/n1/fR/retR
      false, // !REPLACEMENT-blt/n1/nR/fR/retR
      false, // !REPLACEMENT-blt/nR/%rR/fR/retR
      false, // !REPLACEMENT-blt/nR/n0/fR/retR
      false, // !REPLACEMENT-blt/nR/n1/fR/retR
      false, // !REPLACEMENT-blt/nR/nR/fR/retR
      false, // !REPLACEMENT-bltu/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bltu/%rR/n0/fR/retR
      false, // !REPLACEMENT-bltu/%rR/n1/fR/retR
      false, // !REPLACEMENT-bltu/%rR/nR/fR/retR
      false, // !REPLACEMENT-bltu/n0/%rR/fR/retR
      false, // !REPLACEMENT-bltu/n0/n0/fR/retR
      false, // !REPLACEMENT-bltu/n0/n1/fR/retR
      false, // !REPLACEMENT-bltu/n0/nR/fR/retR
      false, // !REPLACEMENT-bltu/n1/%rR/fR/retR
      false, // !REPLACEMENT-bltu/n1/n0/fR/retR
      false, // !REPLACEMENT-bltu/n1/n1/fR/retR
      false, // !REPLACEMENT-bltu/n1/nR/fR/retR
      false, // !REPLACEMENT-bltu/nR/%rR/fR/retR
      false, // !REPLACEMENT-bltu/nR/n0/fR/retR
      false, // !REPLACEMENT-bltu/nR/n1/fR/retR
      false, // !REPLACEMENT-bltu/nR/nR/fR/retR
      false, // !REPLACEMENT-bne/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bne/%rR/n0/fR/retR
      false, // !REPLACEMENT-bne/%rR/nR/fR/retR
      false, // !REPLACEMENT-bne/n0/%rR/fR/retR
      false, // !REPLACEMENT-bne/n0/n0/fR/retR
      false, // !REPLACEMENT-bne/n0/nR/fR/retR
      false, // !REPLACEMENT-bne/nR/%rR/fR/retR
      false, // !REPLACEMENT-bne/nR/n0/fR/retR
      false, // !REPLACEMENT-bne/nR/nR/fR/retR
      false, // !REPLACEMENT-bneg/%rR/fR/retR
      false, // !REPLACEMENT-bneg/nR/fR/retR
      false, // !REPLACEMENT-bnneg/%rR/fR/retR
      false, // !REPLACEMENT-bnneg/nR/fR/retR
      false, // !REPLACEMENT-bnotand/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bnotand/%rR/n3/fR/retR
      false, // !REPLACEMENT-bnotand/%rR/n7/fR/retR
      false, // !REPLACEMENT-bnotand/%rR/nR/fR/retR
      false, // !REPLACEMENT-bnotand/nR/%rR/fR/retR
      false, // !REPLACEMENT-bnotand/nR/n3/fR/retR
      false, // !REPLACEMENT-bnotand/nR/n7/fR/retR
      false, // !REPLACEMENT-bnotand/nR/nR/fR/retR
      false, // !REPLACEMENT-bnpos/%rR/fR/retR
      false, // !REPLACEMENT-bnpos/nR/fR/retR
      false, // !REPLACEMENT-bnz/%rR/fR/retR
      false, // !REPLACEMENT-bnz/nR/fR/retR
      false, // !REPLACEMENT-bpos/%rR/fR/retR
      false, // !REPLACEMENT-bpos/nR/fR/retR
      false, // !REPLACEMENT-br/%rR/retR
      false, // !REPLACEMENT-bz/%rR/fR/retR
      false, // !REPLACEMENT-bz/nR/fR/retR
      false, // !REPLACEMENT-divo/%rR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-divo/%rR/n2/%rR/fR/retR
      false, // !REPLACEMENT-divo/%rR/nR/%rR/fR/retR
      false, // !REPLACEMENT-divo/nR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-divo/nR/n2/%rR/fR/retR
      false, // !REPLACEMENT-divo/nR/nR/%rR/fR/retR
      false, // !REPLACEMENT-endvm/retR
      false, // !REPLACEMENT-exitvm/retR
      false, // !REPLACEMENT-modo/%rR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-modo/%rR/n2/%rR/fR/retR
      false, // !REPLACEMENT-modo/%rR/nR/%rR/fR/retR
      false, // !REPLACEMENT-modo/nR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-modo/nR/n2/%rR/fR/retR
      false, // !REPLACEMENT-modo/nR/nR/%rR/fR/retR
      false, // !REPLACEMENT-mulo/%rR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-mulo/%rR/n2/%rR/fR/retR
      false, // !REPLACEMENT-mulo/%rR/nR/%rR/fR/retR
      false, // !REPLACEMENT-mulo/nR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-mulo/nR/n2/%rR/fR/retR
      false, // !REPLACEMENT-mulo/nR/nR/%rR/fR/retR
      false, // !REPLACEMENT-procedurecall/fR/retR
      false, // !REPLACEMENT-procedurecallr/%rR/retR
      false, // !REPLACEMENT-procedurecallr/lR/retR
      true, // !REPLACEMENT-procedureprolog/retR
      false, // !REPLACEMENT-procedurereturn/retR
      false, // !REPLACEMENT-raise/%rR/retR
      false, // !REPLACEMENT-raise/n0/retR
      false, // !REPLACEMENT-raise/n1/retR
      false, // !REPLACEMENT-raise/n2/retR
      false, // !REPLACEMENT-raise/n3/retR
      false, // !REPLACEMENT-raise/n4/retR
      false, // !REPLACEMENT-raise/n5/retR
      false, // !REPLACEMENT-raise/n6/retR
      false, // !REPLACEMENT-raise/n7/retR
      false, // !REPLACEMENT-raise/n8/retR
      false, // !REPLACEMENT-raise/n9/retR
      false, // !REPLACEMENT-raise/n10/retR
      false, // !REPLACEMENT-raise/nR/retR
      false, // !REPLACEMENT-safe-point/fR/retR
      false, // !REPLACEMENT-stackif/fR/retR
      false, // !REPLACEMENT-stacknondroppingif/fR/retR
      false, // !REPLACEMENT-subo/%rR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-subo/%rR/n1/%rR/fR/retR
      false, // !REPLACEMENT-subo/%rR/nR/%rR/fR/retR
      false, // !REPLACEMENT-subo/nR/%rR/%rR/fR/retR
      false, // !REPLACEMENT-subo/nR/n1/%rR/fR/retR
      false, // !REPLACEMENT-subo/nR/nR/%rR/fR/retR
      false // !REPLACEMENT-unreachable/retR
    };

/* An array whose indices are specialised instruction opcodes, and
   whose elements are the corresponding unspecialised instructions
   opcodes -- or -1 when there is no mapping mapping having */
const int
uninspired_specialized_instruction_to_unspecialized_instruction
   [UNINSPIRED_SPECIALIZED_INSTRUCTION_NO]
  = {
    -1, /* !INVALID */
    -1, /* !BEGINBASICBLOCK */
    -1, /* !EXITVM */
    -1, /* !DATALOCATIONS */
    -1, /* !NOP */
    -1, /* !UNREACHABLE0 */
    -1, /* !UNREACHABLE1 */
    -1, /* !PRETENDTOJUMPANYWHERE */
    uninspired_meta_instruction_id_add, /* add/%rR/%rR/%rR */
    uninspired_meta_instruction_id_add, /* add/%rR/n1/%rR */
    uninspired_meta_instruction_id_add, /* add/%rR/n-1/%rR */
    uninspired_meta_instruction_id_add, /* add/%rR/nR/%rR */
    uninspired_meta_instruction_id_add, /* add/n1/%rR/%rR */
    uninspired_meta_instruction_id_add, /* add/n1/n1/%rR */
    uninspired_meta_instruction_id_add, /* add/n1/n-1/%rR */
    uninspired_meta_instruction_id_add, /* add/n1/nR/%rR */
    uninspired_meta_instruction_id_add, /* add/n-1/%rR/%rR */
    uninspired_meta_instruction_id_add, /* add/n-1/n1/%rR */
    uninspired_meta_instruction_id_add, /* add/n-1/n-1/%rR */
    uninspired_meta_instruction_id_add, /* add/n-1/nR/%rR */
    uninspired_meta_instruction_id_add, /* add/nR/%rR/%rR */
    uninspired_meta_instruction_id_add, /* add/nR/n1/%rR */
    uninspired_meta_instruction_id_add, /* add/nR/n-1/%rR */
    uninspired_meta_instruction_id_add, /* add/nR/nR/%rR */
    uninspired_meta_instruction_id_addo, /* addo/%rR/%rR/%rR/fR */
    uninspired_meta_instruction_id_addo, /* addo/%rR/n1/%rR/fR */
    uninspired_meta_instruction_id_addo, /* addo/%rR/n-1/%rR/fR */
    uninspired_meta_instruction_id_addo, /* addo/%rR/nR/%rR/fR */
    uninspired_meta_instruction_id_addo, /* addo/nR/%rR/%rR/fR */
    uninspired_meta_instruction_id_addo, /* addo/nR/n1/%rR/fR */
    uninspired_meta_instruction_id_addo, /* addo/nR/n-1/%rR/fR */
    uninspired_meta_instruction_id_addo, /* addo/nR/nR/%rR/fR */
    uninspired_meta_instruction_id_b, /* b/fR */
    uninspired_meta_instruction_id_band, /* band/%rR/%rR/fR */
    uninspired_meta_instruction_id_band, /* band/%rR/n3/fR */
    uninspired_meta_instruction_id_band, /* band/%rR/n7/fR */
    uninspired_meta_instruction_id_band, /* band/%rR/nR/fR */
    uninspired_meta_instruction_id_band, /* band/nR/%rR/fR */
    uninspired_meta_instruction_id_band, /* band/nR/n3/fR */
    uninspired_meta_instruction_id_band, /* band/nR/n7/fR */
    uninspired_meta_instruction_id_band, /* band/nR/nR/fR */
    uninspired_meta_instruction_id_beq, /* beq/%rR/%rR/fR */
    uninspired_meta_instruction_id_beq, /* beq/%rR/nR/fR */
    uninspired_meta_instruction_id_beq, /* beq/nR/%rR/fR */
    uninspired_meta_instruction_id_beq, /* beq/nR/nR/fR */
    uninspired_meta_instruction_id_bge, /* bge/%rR/%rR/fR */
    uninspired_meta_instruction_id_bge, /* bge/%rR/n0/fR */
    uninspired_meta_instruction_id_bge, /* bge/%rR/n1/fR */
    uninspired_meta_instruction_id_bge, /* bge/%rR/nR/fR */
    uninspired_meta_instruction_id_bge, /* bge/n0/%rR/fR */
    uninspired_meta_instruction_id_bge, /* bge/n0/n0/fR */
    uninspired_meta_instruction_id_bge, /* bge/n0/n1/fR */
    uninspired_meta_instruction_id_bge, /* bge/n0/nR/fR */
    uninspired_meta_instruction_id_bge, /* bge/n1/%rR/fR */
    uninspired_meta_instruction_id_bge, /* bge/n1/n0/fR */
    uninspired_meta_instruction_id_bge, /* bge/n1/n1/fR */
    uninspired_meta_instruction_id_bge, /* bge/n1/nR/fR */
    uninspired_meta_instruction_id_bge, /* bge/nR/%rR/fR */
    uninspired_meta_instruction_id_bge, /* bge/nR/n0/fR */
    uninspired_meta_instruction_id_bge, /* bge/nR/n1/fR */
    uninspired_meta_instruction_id_bge, /* bge/nR/nR/fR */
    uninspired_meta_instruction_id_bgeu, /* bgeu/%rR/%rR/fR */
    uninspired_meta_instruction_id_bgeu, /* bgeu/%rR/n0/fR */
    uninspired_meta_instruction_id_bgeu, /* bgeu/%rR/n1/fR */
    uninspired_meta_instruction_id_bgeu, /* bgeu/%rR/nR/fR */
    uninspired_meta_instruction_id_bgeu, /* bgeu/n0/%rR/fR */
    uninspired_meta_instruction_id_bgeu, /* bgeu/n0/n0/fR */
    uninspired_meta_instruction_id_bgeu, /* bgeu/n0/n1/fR */
    uninspired_meta_instruction_id_bgeu, /* bgeu/n0/nR/fR */
    uninspired_meta_instruction_id_bgeu, /* bgeu/n1/%rR/fR */
    uninspired_meta_instruction_id_bgeu, /* bgeu/n1/n0/fR */
    uninspired_meta_instruction_id_bgeu, /* bgeu/n1/n1/fR */
    uninspired_meta_instruction_id_bgeu, /* bgeu/n1/nR/fR */
    uninspired_meta_instruction_id_bgeu, /* bgeu/nR/%rR/fR */
    uninspired_meta_instruction_id_bgeu, /* bgeu/nR/n0/fR */
    uninspired_meta_instruction_id_bgeu, /* bgeu/nR/n1/fR */
    uninspired_meta_instruction_id_bgeu, /* bgeu/nR/nR/fR */
    uninspired_meta_instruction_id_bgt, /* bgt/%rR/%rR/fR */
    uninspired_meta_instruction_id_bgt, /* bgt/%rR/n0/fR */
    uninspired_meta_instruction_id_bgt, /* bgt/%rR/n1/fR */
    uninspired_meta_instruction_id_bgt, /* bgt/%rR/nR/fR */
    uninspired_meta_instruction_id_bgt, /* bgt/n0/%rR/fR */
    uninspired_meta_instruction_id_bgt, /* bgt/n0/n0/fR */
    uninspired_meta_instruction_id_bgt, /* bgt/n0/n1/fR */
    uninspired_meta_instruction_id_bgt, /* bgt/n0/nR/fR */
    uninspired_meta_instruction_id_bgt, /* bgt/n1/%rR/fR */
    uninspired_meta_instruction_id_bgt, /* bgt/n1/n0/fR */
    uninspired_meta_instruction_id_bgt, /* bgt/n1/n1/fR */
    uninspired_meta_instruction_id_bgt, /* bgt/n1/nR/fR */
    uninspired_meta_instruction_id_bgt, /* bgt/nR/%rR/fR */
    uninspired_meta_instruction_id_bgt, /* bgt/nR/n0/fR */
    uninspired_meta_instruction_id_bgt, /* bgt/nR/n1/fR */
    uninspired_meta_instruction_id_bgt, /* bgt/nR/nR/fR */
    uninspired_meta_instruction_id_bgtu, /* bgtu/%rR/%rR/fR */
    uninspired_meta_instruction_id_bgtu, /* bgtu/%rR/n0/fR */
    uninspired_meta_instruction_id_bgtu, /* bgtu/%rR/n1/fR */
    uninspired_meta_instruction_id_bgtu, /* bgtu/%rR/nR/fR */
    uninspired_meta_instruction_id_bgtu, /* bgtu/n0/%rR/fR */
    uninspired_meta_instruction_id_bgtu, /* bgtu/n0/n0/fR */
    uninspired_meta_instruction_id_bgtu, /* bgtu/n0/n1/fR */
    uninspired_meta_instruction_id_bgtu, /* bgtu/n0/nR/fR */
    uninspired_meta_instruction_id_bgtu, /* bgtu/n1/%rR/fR */
    uninspired_meta_instruction_id_bgtu, /* bgtu/n1/n0/fR */
    uninspired_meta_instruction_id_bgtu, /* bgtu/n1/n1/fR */
    uninspired_meta_instruction_id_bgtu, /* bgtu/n1/nR/fR */
    uninspired_meta_instruction_id_bgtu, /* bgtu/nR/%rR/fR */
    uninspired_meta_instruction_id_bgtu, /* bgtu/nR/n0/fR */
    uninspired_meta_instruction_id_bgtu, /* bgtu/nR/n1/fR */
    uninspired_meta_instruction_id_bgtu, /* bgtu/nR/nR/fR */
    uninspired_meta_instruction_id_ble, /* ble/%rR/%rR/fR */
    uninspired_meta_instruction_id_ble, /* ble/%rR/n0/fR */
    uninspired_meta_instruction_id_ble, /* ble/%rR/n1/fR */
    uninspired_meta_instruction_id_ble, /* ble/%rR/nR/fR */
    uninspired_meta_instruction_id_ble, /* ble/n0/%rR/fR */
    uninspired_meta_instruction_id_ble, /* ble/n0/n0/fR */
    uninspired_meta_instruction_id_ble, /* ble/n0/n1/fR */
    uninspired_meta_instruction_id_ble, /* ble/n0/nR/fR */
    uninspired_meta_instruction_id_ble, /* ble/n1/%rR/fR */
    uninspired_meta_instruction_id_ble, /* ble/n1/n0/fR */
    uninspired_meta_instruction_id_ble, /* ble/n1/n1/fR */
    uninspired_meta_instruction_id_ble, /* ble/n1/nR/fR */
    uninspired_meta_instruction_id_ble, /* ble/nR/%rR/fR */
    uninspired_meta_instruction_id_ble, /* ble/nR/n0/fR */
    uninspired_meta_instruction_id_ble, /* ble/nR/n1/fR */
    uninspired_meta_instruction_id_ble, /* ble/nR/nR/fR */
    uninspired_meta_instruction_id_bleu, /* bleu/%rR/%rR/fR */
    uninspired_meta_instruction_id_bleu, /* bleu/%rR/n0/fR */
    uninspired_meta_instruction_id_bleu, /* bleu/%rR/n1/fR */
    uninspired_meta_instruction_id_bleu, /* bleu/%rR/nR/fR */
    uninspired_meta_instruction_id_bleu, /* bleu/n0/%rR/fR */
    uninspired_meta_instruction_id_bleu, /* bleu/n0/n0/fR */
    uninspired_meta_instruction_id_bleu, /* bleu/n0/n1/fR */
    uninspired_meta_instruction_id_bleu, /* bleu/n0/nR/fR */
    uninspired_meta_instruction_id_bleu, /* bleu/n1/%rR/fR */
    uninspired_meta_instruction_id_bleu, /* bleu/n1/n0/fR */
    uninspired_meta_instruction_id_bleu, /* bleu/n1/n1/fR */
    uninspired_meta_instruction_id_bleu, /* bleu/n1/nR/fR */
    uninspired_meta_instruction_id_bleu, /* bleu/nR/%rR/fR */
    uninspired_meta_instruction_id_bleu, /* bleu/nR/n0/fR */
    uninspired_meta_instruction_id_bleu, /* bleu/nR/n1/fR */
    uninspired_meta_instruction_id_bleu, /* bleu/nR/nR/fR */
    uninspired_meta_instruction_id_blt, /* blt/%rR/%rR/fR */
    uninspired_meta_instruction_id_blt, /* blt/%rR/n0/fR */
    uninspired_meta_instruction_id_blt, /* blt/%rR/n1/fR */
    uninspired_meta_instruction_id_blt, /* blt/%rR/nR/fR */
    uninspired_meta_instruction_id_blt, /* blt/n0/%rR/fR */
    uninspired_meta_instruction_id_blt, /* blt/n0/n0/fR */
    uninspired_meta_instruction_id_blt, /* blt/n0/n1/fR */
    uninspired_meta_instruction_id_blt, /* blt/n0/nR/fR */
    uninspired_meta_instruction_id_blt, /* blt/n1/%rR/fR */
    uninspired_meta_instruction_id_blt, /* blt/n1/n0/fR */
    uninspired_meta_instruction_id_blt, /* blt/n1/n1/fR */
    uninspired_meta_instruction_id_blt, /* blt/n1/nR/fR */
    uninspired_meta_instruction_id_blt, /* blt/nR/%rR/fR */
    uninspired_meta_instruction_id_blt, /* blt/nR/n0/fR */
    uninspired_meta_instruction_id_blt, /* blt/nR/n1/fR */
    uninspired_meta_instruction_id_blt, /* blt/nR/nR/fR */
    uninspired_meta_instruction_id_bltu, /* bltu/%rR/%rR/fR */
    uninspired_meta_instruction_id_bltu, /* bltu/%rR/n0/fR */
    uninspired_meta_instruction_id_bltu, /* bltu/%rR/n1/fR */
    uninspired_meta_instruction_id_bltu, /* bltu/%rR/nR/fR */
    uninspired_meta_instruction_id_bltu, /* bltu/n0/%rR/fR */
    uninspired_meta_instruction_id_bltu, /* bltu/n0/n0/fR */
    uninspired_meta_instruction_id_bltu, /* bltu/n0/n1/fR */
    uninspired_meta_instruction_id_bltu, /* bltu/n0/nR/fR */
    uninspired_meta_instruction_id_bltu, /* bltu/n1/%rR/fR */
    uninspired_meta_instruction_id_bltu, /* bltu/n1/n0/fR */
    uninspired_meta_instruction_id_bltu, /* bltu/n1/n1/fR */
    uninspired_meta_instruction_id_bltu, /* bltu/n1/nR/fR */
    uninspired_meta_instruction_id_bltu, /* bltu/nR/%rR/fR */
    uninspired_meta_instruction_id_bltu, /* bltu/nR/n0/fR */
    uninspired_meta_instruction_id_bltu, /* bltu/nR/n1/fR */
    uninspired_meta_instruction_id_bltu, /* bltu/nR/nR/fR */
    uninspired_meta_instruction_id_bne, /* bne/%rR/%rR/fR */
    uninspired_meta_instruction_id_bne, /* bne/%rR/n0/fR */
    uninspired_meta_instruction_id_bne, /* bne/%rR/nR/fR */
    uninspired_meta_instruction_id_bne, /* bne/n0/%rR/fR */
    uninspired_meta_instruction_id_bne, /* bne/n0/n0/fR */
    uninspired_meta_instruction_id_bne, /* bne/n0/nR/fR */
    uninspired_meta_instruction_id_bne, /* bne/nR/%rR/fR */
    uninspired_meta_instruction_id_bne, /* bne/nR/n0/fR */
    uninspired_meta_instruction_id_bne, /* bne/nR/nR/fR */
    uninspired_meta_instruction_id_bneg, /* bneg/%rR/fR */
    uninspired_meta_instruction_id_bneg, /* bneg/nR/fR */
    uninspired_meta_instruction_id_bnneg, /* bnneg/%rR/fR */
    uninspired_meta_instruction_id_bnneg, /* bnneg/nR/fR */
    uninspired_meta_instruction_id_bnotand, /* bnotand/%rR/%rR/fR */
    uninspired_meta_instruction_id_bnotand, /* bnotand/%rR/n3/fR */
    uninspired_meta_instruction_id_bnotand, /* bnotand/%rR/n7/fR */
    uninspired_meta_instruction_id_bnotand, /* bnotand/%rR/nR/fR */
    uninspired_meta_instruction_id_bnotand, /* bnotand/nR/%rR/fR */
    uninspired_meta_instruction_id_bnotand, /* bnotand/nR/n3/fR */
    uninspired_meta_instruction_id_bnotand, /* bnotand/nR/n7/fR */
    uninspired_meta_instruction_id_bnotand, /* bnotand/nR/nR/fR */
    uninspired_meta_instruction_id_bnpos, /* bnpos/%rR/fR */
    uninspired_meta_instruction_id_bnpos, /* bnpos/nR/fR */
    uninspired_meta_instruction_id_bnz, /* bnz/%rR/fR */
    uninspired_meta_instruction_id_bnz, /* bnz/nR/fR */
    uninspired_meta_instruction_id_bpos, /* bpos/%rR/fR */
    uninspired_meta_instruction_id_bpos, /* bpos/nR/fR */
    uninspired_meta_instruction_id_br, /* br/%rR */
    uninspired_meta_instruction_id_bulge, /* bulge/n0 */
    uninspired_meta_instruction_id_bulge, /* bulge/n1 */
    uninspired_meta_instruction_id_bulge, /* bulge/n2 */
    uninspired_meta_instruction_id_bulge, /* bulge/n3 */
    uninspired_meta_instruction_id_bulge, /* bulge/nR */
    uninspired_meta_instruction_id_bulgeforth, /* bulgeforth */
    uninspired_meta_instruction_id_bz, /* bz/%rR/fR */
    uninspired_meta_instruction_id_bz, /* bz/nR/fR */
    uninspired_meta_instruction_id_clear_mpending, /* clear-pending/retR */
    uninspired_meta_instruction_id_div, /* div/%rR/%rR/%rR/retR */
    uninspired_meta_instruction_id_div, /* div/%rR/n2/%rR/retR */
    uninspired_meta_instruction_id_div, /* div/%rR/nR/%rR/retR */
    uninspired_meta_instruction_id_div, /* div/nR/%rR/%rR/retR */
    uninspired_meta_instruction_id_div, /* div/nR/n2/%rR/retR */
    uninspired_meta_instruction_id_div, /* div/nR/nR/%rR/retR */
    uninspired_meta_instruction_id_divo, /* divo/%rR/%rR/%rR/fR */
    uninspired_meta_instruction_id_divo, /* divo/%rR/n2/%rR/fR */
    uninspired_meta_instruction_id_divo, /* divo/%rR/nR/%rR/fR */
    uninspired_meta_instruction_id_divo, /* divo/nR/%rR/%rR/fR */
    uninspired_meta_instruction_id_divo, /* divo/nR/n2/%rR/fR */
    uninspired_meta_instruction_id_divo, /* divo/nR/nR/%rR/fR */
    uninspired_meta_instruction_id_drop_mhandler, /* drop-handler */
    uninspired_meta_instruction_id_endvm, /* endvm */
    uninspired_meta_instruction_id_exit, /* exit/%rR/retR */
    uninspired_meta_instruction_id_exit, /* exit/nR/retR */
    uninspired_meta_instruction_id_exitvm, /* exitvm */
    uninspired_meta_instruction_id_fadd, /* fadd/%fR/%fR/%fR */
    uninspired_meta_instruction_id_fdiv, /* fdiv/%fR/%fR/%fR */
    uninspired_meta_instruction_id_fincr, /* fincr/%fR */
    uninspired_meta_instruction_id_fmul, /* fmul/%fR/%fR/%fR */
    uninspired_meta_instruction_id_fprint, /* fprint/%fR */
    uninspired_meta_instruction_id_fset, /* fset/%rR/%fR */
    uninspired_meta_instruction_id_fset, /* fset/nR/%fR */
    uninspired_meta_instruction_id_fsub, /* fsub/%fR/%fR/%fR */
    uninspired_meta_instruction_id_hcf, /* hcf/retR */
    uninspired_meta_instruction_id_install_msignal_mhandler, /* install-signal-handler/retR */
    uninspired_meta_instruction_id_loadwithbyteoffset, /* loadwithbyteoffset/%rR/%rR/%rR */
    uninspired_meta_instruction_id_loadwithbyteoffset, /* loadwithbyteoffset/%rR/n0/%rR */
    uninspired_meta_instruction_id_loadwithbyteoffset, /* loadwithbyteoffset/%rR/n8/%rR */
    uninspired_meta_instruction_id_loadwithbyteoffset, /* loadwithbyteoffset/%rR/nR/%rR */
    uninspired_meta_instruction_id_loadwithwordoffset, /* loadwithwordoffset/%rR/%rR/%rR */
    uninspired_meta_instruction_id_loadwithwordoffset, /* loadwithwordoffset/%rR/n0/%rR */
    uninspired_meta_instruction_id_loadwithwordoffset, /* loadwithwordoffset/%rR/n1/%rR */
    uninspired_meta_instruction_id_loadwithwordoffset, /* loadwithwordoffset/%rR/n2/%rR */
    uninspired_meta_instruction_id_loadwithwordoffset, /* loadwithwordoffset/%rR/nR/%rR */
    uninspired_meta_instruction_id_mallocwords, /* mallocwords/%rR/%rR/retR */
    uninspired_meta_instruction_id_mallocwords, /* mallocwords/nR/%rR/retR */
    uninspired_meta_instruction_id_mod, /* mod/%rR/%rR/%rR/retR */
    uninspired_meta_instruction_id_mod, /* mod/%rR/n2/%rR/retR */
    uninspired_meta_instruction_id_mod, /* mod/%rR/nR/%rR/retR */
    uninspired_meta_instruction_id_mod, /* mod/nR/%rR/%rR/retR */
    uninspired_meta_instruction_id_mod, /* mod/nR/n2/%rR/retR */
    uninspired_meta_instruction_id_mod, /* mod/nR/nR/%rR/retR */
    uninspired_meta_instruction_id_modo, /* modo/%rR/%rR/%rR/fR */
    uninspired_meta_instruction_id_modo, /* modo/%rR/n2/%rR/fR */
    uninspired_meta_instruction_id_modo, /* modo/%rR/nR/%rR/fR */
    uninspired_meta_instruction_id_modo, /* modo/nR/%rR/%rR/fR */
    uninspired_meta_instruction_id_modo, /* modo/nR/n2/%rR/fR */
    uninspired_meta_instruction_id_modo, /* modo/nR/nR/%rR/fR */
    uninspired_meta_instruction_id_mov, /* mov/%rR/%rR */
    uninspired_meta_instruction_id_mov, /* mov/n0/%rR */
    uninspired_meta_instruction_id_mov, /* mov/n1/%rR */
    uninspired_meta_instruction_id_mov, /* mov/nR/%rR */
    uninspired_meta_instruction_id_mov, /* mov/lR/%rR */
    uninspired_meta_instruction_id_mroll, /* mroll/n0 */
    uninspired_meta_instruction_id_mroll, /* mroll/n1 */
    uninspired_meta_instruction_id_mroll, /* mroll/n2 */
    uninspired_meta_instruction_id_mroll, /* mroll/n3 */
    uninspired_meta_instruction_id_mroll, /* mroll/n4 */
    uninspired_meta_instruction_id_mroll, /* mroll/n5 */
    uninspired_meta_instruction_id_mroll, /* mroll/n6 */
    uninspired_meta_instruction_id_mroll, /* mroll/n7 */
    uninspired_meta_instruction_id_mroll, /* mroll/n8 */
    uninspired_meta_instruction_id_mroll, /* mroll/n9 */
    uninspired_meta_instruction_id_mroll, /* mroll/n10 */
    uninspired_meta_instruction_id_mroll, /* mroll/n11 */
    uninspired_meta_instruction_id_mroll, /* mroll/n12 */
    uninspired_meta_instruction_id_mroll, /* mroll/n13 */
    uninspired_meta_instruction_id_mroll, /* mroll/n14 */
    uninspired_meta_instruction_id_mroll, /* mroll/n15 */
    uninspired_meta_instruction_id_mroll, /* mroll/n16 */
    uninspired_meta_instruction_id_mroll, /* mroll/n17 */
    uninspired_meta_instruction_id_mroll, /* mroll/n18 */
    uninspired_meta_instruction_id_mroll, /* mroll/n19 */
    uninspired_meta_instruction_id_mroll, /* mroll/n20 */
    uninspired_meta_instruction_id_mroll, /* mroll/n21 */
    uninspired_meta_instruction_id_mroll, /* mroll/n22 */
    uninspired_meta_instruction_id_mroll, /* mroll/n23 */
    uninspired_meta_instruction_id_mroll, /* mroll/n24 */
    uninspired_meta_instruction_id_mroll, /* mroll/n25 */
    uninspired_meta_instruction_id_mroll, /* mroll/n26 */
    uninspired_meta_instruction_id_mroll, /* mroll/n27 */
    uninspired_meta_instruction_id_mroll, /* mroll/n28 */
    uninspired_meta_instruction_id_mroll, /* mroll/n29 */
    uninspired_meta_instruction_id_mroll, /* mroll/n30 */
    uninspired_meta_instruction_id_mroll, /* mroll/n31 */
    uninspired_meta_instruction_id_mroll, /* mroll/n32 */
    uninspired_meta_instruction_id_mroll, /* mroll/n33 */
    uninspired_meta_instruction_id_mroll, /* mroll/n34 */
    uninspired_meta_instruction_id_mroll, /* mroll/n35 */
    uninspired_meta_instruction_id_mroll, /* mroll/n36 */
    uninspired_meta_instruction_id_mroll, /* mroll/n37 */
    uninspired_meta_instruction_id_mroll, /* mroll/n38 */
    uninspired_meta_instruction_id_mroll, /* mroll/n39 */
    uninspired_meta_instruction_id_mroll, /* mroll/n40 */
    uninspired_meta_instruction_id_mroll, /* mroll/n41 */
    uninspired_meta_instruction_id_mroll, /* mroll/n42 */
    uninspired_meta_instruction_id_mroll, /* mroll/n43 */
    uninspired_meta_instruction_id_mroll, /* mroll/n44 */
    uninspired_meta_instruction_id_mroll, /* mroll/n45 */
    uninspired_meta_instruction_id_mroll, /* mroll/n46 */
    uninspired_meta_instruction_id_mroll, /* mroll/n47 */
    uninspired_meta_instruction_id_mroll, /* mroll/n48 */
    uninspired_meta_instruction_id_mroll, /* mroll/n49 */
    uninspired_meta_instruction_id_mroll, /* mroll/n50 */
    uninspired_meta_instruction_id_mroll, /* mroll/n51 */
    uninspired_meta_instruction_id_mroll, /* mroll/n52 */
    uninspired_meta_instruction_id_mroll, /* mroll/n53 */
    uninspired_meta_instruction_id_mroll, /* mroll/n54 */
    uninspired_meta_instruction_id_mroll, /* mroll/n55 */
    uninspired_meta_instruction_id_mroll, /* mroll/n56 */
    uninspired_meta_instruction_id_mroll, /* mroll/n57 */
    uninspired_meta_instruction_id_mroll, /* mroll/n58 */
    uninspired_meta_instruction_id_mroll, /* mroll/n59 */
    uninspired_meta_instruction_id_mroll, /* mroll/n60 */
    uninspired_meta_instruction_id_mroll, /* mroll/n61 */
    uninspired_meta_instruction_id_mroll, /* mroll/n62 */
    uninspired_meta_instruction_id_mroll, /* mroll/n63 */
    uninspired_meta_instruction_id_mroll, /* mroll/n64 */
    uninspired_meta_instruction_id_mroll, /* mroll/n65 */
    uninspired_meta_instruction_id_mroll, /* mroll/n66 */
    uninspired_meta_instruction_id_mroll, /* mroll/n67 */
    uninspired_meta_instruction_id_mroll, /* mroll/n68 */
    uninspired_meta_instruction_id_mroll, /* mroll/n69 */
    uninspired_meta_instruction_id_mroll, /* mroll/n70 */
    uninspired_meta_instruction_id_mroll, /* mroll/nR */
    uninspired_meta_instruction_id_mrollforth, /* mrollforth */
    uninspired_meta_instruction_id_mrot, /* mrot */
    uninspired_meta_instruction_id_mul, /* mul/%rR/%rR/%rR */
    uninspired_meta_instruction_id_mul, /* mul/%rR/n2/%rR */
    uninspired_meta_instruction_id_mul, /* mul/%rR/nR/%rR */
    uninspired_meta_instruction_id_mul, /* mul/n2/%rR/%rR */
    uninspired_meta_instruction_id_mul, /* mul/n2/n2/%rR */
    uninspired_meta_instruction_id_mul, /* mul/n2/nR/%rR */
    uninspired_meta_instruction_id_mul, /* mul/nR/%rR/%rR */
    uninspired_meta_instruction_id_mul, /* mul/nR/n2/%rR */
    uninspired_meta_instruction_id_mul, /* mul/nR/nR/%rR */
    uninspired_meta_instruction_id_mulo, /* mulo/%rR/%rR/%rR/fR */
    uninspired_meta_instruction_id_mulo, /* mulo/%rR/n2/%rR/fR */
    uninspired_meta_instruction_id_mulo, /* mulo/%rR/nR/%rR/fR */
    uninspired_meta_instruction_id_mulo, /* mulo/nR/%rR/%rR/fR */
    uninspired_meta_instruction_id_mulo, /* mulo/nR/n2/%rR/fR */
    uninspired_meta_instruction_id_mulo, /* mulo/nR/nR/%rR/fR */
    uninspired_meta_instruction_id_nop, /* nop */
    uninspired_meta_instruction_id_print_mpending_msignals, /* print-pending-signals/retR */
    uninspired_meta_instruction_id_print_mtopmost, /* print-topmost/nR/retR */
    uninspired_meta_instruction_id_printfixnum, /* printfixnum/%rR/retR */
    uninspired_meta_instruction_id_printfixnum, /* printfixnum/nR/retR */
    uninspired_meta_instruction_id_printufixnum, /* printufixnum/%rR/retR */
    uninspired_meta_instruction_id_printufixnum, /* printufixnum/nR/retR */
    uninspired_meta_instruction_id_procedurecall, /* procedurecall/fR/retR */
    uninspired_meta_instruction_id_procedurecallr, /* procedurecallr/%rR/retR */
    uninspired_meta_instruction_id_procedurecallr, /* procedurecallr/lR/retR */
    uninspired_meta_instruction_id_procedureprolog, /* procedureprolog */
    uninspired_meta_instruction_id_procedurereturn, /* procedurereturn */
    uninspired_meta_instruction_id_push_mdepths, /* push-depths/nR/retR */
    uninspired_meta_instruction_id_push_mhandler, /* push-handler/n0/lR */
    uninspired_meta_instruction_id_push_mhandler, /* push-handler/n1/lR */
    uninspired_meta_instruction_id_push_mhandler, /* push-handler/n2/lR */
    uninspired_meta_instruction_id_push_mhandler, /* push-handler/n3/lR */
    uninspired_meta_instruction_id_push_mhandler, /* push-handler/n4/lR */
    uninspired_meta_instruction_id_push_mhandler, /* push-handler/n5/lR */
    uninspired_meta_instruction_id_push_mhandler, /* push-handler/n6/lR */
    uninspired_meta_instruction_id_push_mhandler, /* push-handler/n7/lR */
    uninspired_meta_instruction_id_push_mhandler, /* push-handler/n8/lR */
    uninspired_meta_instruction_id_push_mhandler, /* push-handler/n9/lR */
    uninspired_meta_instruction_id_push_mhandler, /* push-handler/n10/lR */
    uninspired_meta_instruction_id_push_mhandler, /* push-handler/nR/lR */
    uninspired_meta_instruction_id_push_mincreasing, /* push-increasing/nR/retR */
    uninspired_meta_instruction_id_quake, /* quake */
    uninspired_meta_instruction_id_raise, /* raise/%rR */
    uninspired_meta_instruction_id_raise, /* raise/n0 */
    uninspired_meta_instruction_id_raise, /* raise/n1 */
    uninspired_meta_instruction_id_raise, /* raise/n2 */
    uninspired_meta_instruction_id_raise, /* raise/n3 */
    uninspired_meta_instruction_id_raise, /* raise/n4 */
    uninspired_meta_instruction_id_raise, /* raise/n5 */
    uninspired_meta_instruction_id_raise, /* raise/n6 */
    uninspired_meta_instruction_id_raise, /* raise/n7 */
    uninspired_meta_instruction_id_raise, /* raise/n8 */
    uninspired_meta_instruction_id_raise, /* raise/n9 */
    uninspired_meta_instruction_id_raise, /* raise/n10 */
    uninspired_meta_instruction_id_raise, /* raise/nR */
    uninspired_meta_instruction_id_random, /* random/%rR/retR */
    uninspired_meta_instruction_id_reverse, /* reverse/n0 */
    uninspired_meta_instruction_id_reverse, /* reverse/n1 */
    uninspired_meta_instruction_id_reverse, /* reverse/n2 */
    uninspired_meta_instruction_id_reverse, /* reverse/n3 */
    uninspired_meta_instruction_id_reverse, /* reverse/n4 */
    uninspired_meta_instruction_id_reverse, /* reverse/n5 */
    uninspired_meta_instruction_id_reverse, /* reverse/n6 */
    uninspired_meta_instruction_id_reverse, /* reverse/n7 */
    uninspired_meta_instruction_id_reverse, /* reverse/n8 */
    uninspired_meta_instruction_id_reverse, /* reverse/n9 */
    uninspired_meta_instruction_id_reverse, /* reverse/n10 */
    uninspired_meta_instruction_id_reverse, /* reverse/n11 */
    uninspired_meta_instruction_id_reverse, /* reverse/n12 */
    uninspired_meta_instruction_id_reverse, /* reverse/n13 */
    uninspired_meta_instruction_id_reverse, /* reverse/n14 */
    uninspired_meta_instruction_id_reverse, /* reverse/n15 */
    uninspired_meta_instruction_id_reverse, /* reverse/n16 */
    uninspired_meta_instruction_id_reverse, /* reverse/n17 */
    uninspired_meta_instruction_id_reverse, /* reverse/n18 */
    uninspired_meta_instruction_id_reverse, /* reverse/n19 */
    uninspired_meta_instruction_id_reverse, /* reverse/n20 */
    uninspired_meta_instruction_id_reverse, /* reverse/n21 */
    uninspired_meta_instruction_id_reverse, /* reverse/n22 */
    uninspired_meta_instruction_id_reverse, /* reverse/n23 */
    uninspired_meta_instruction_id_reverse, /* reverse/n24 */
    uninspired_meta_instruction_id_reverse, /* reverse/n25 */
    uninspired_meta_instruction_id_reverse, /* reverse/n26 */
    uninspired_meta_instruction_id_reverse, /* reverse/n27 */
    uninspired_meta_instruction_id_reverse, /* reverse/n28 */
    uninspired_meta_instruction_id_reverse, /* reverse/n29 */
    uninspired_meta_instruction_id_reverse, /* reverse/n30 */
    uninspired_meta_instruction_id_reverse, /* reverse/n31 */
    uninspired_meta_instruction_id_reverse, /* reverse/n32 */
    uninspired_meta_instruction_id_reverse, /* reverse/n33 */
    uninspired_meta_instruction_id_reverse, /* reverse/n34 */
    uninspired_meta_instruction_id_reverse, /* reverse/n35 */
    uninspired_meta_instruction_id_reverse, /* reverse/n36 */
    uninspired_meta_instruction_id_reverse, /* reverse/n37 */
    uninspired_meta_instruction_id_reverse, /* reverse/n38 */
    uninspired_meta_instruction_id_reverse, /* reverse/n39 */
    uninspired_meta_instruction_id_reverse, /* reverse/n40 */
    uninspired_meta_instruction_id_reverse, /* reverse/n41 */
    uninspired_meta_instruction_id_reverse, /* reverse/n42 */
    uninspired_meta_instruction_id_reverse, /* reverse/n43 */
    uninspired_meta_instruction_id_reverse, /* reverse/n44 */
    uninspired_meta_instruction_id_reverse, /* reverse/n45 */
    uninspired_meta_instruction_id_reverse, /* reverse/n46 */
    uninspired_meta_instruction_id_reverse, /* reverse/n47 */
    uninspired_meta_instruction_id_reverse, /* reverse/n48 */
    uninspired_meta_instruction_id_reverse, /* reverse/n49 */
    uninspired_meta_instruction_id_reverse, /* reverse/n50 */
    uninspired_meta_instruction_id_reverse, /* reverse/n51 */
    uninspired_meta_instruction_id_reverse, /* reverse/n52 */
    uninspired_meta_instruction_id_reverse, /* reverse/n53 */
    uninspired_meta_instruction_id_reverse, /* reverse/n54 */
    uninspired_meta_instruction_id_reverse, /* reverse/n55 */
    uninspired_meta_instruction_id_reverse, /* reverse/n56 */
    uninspired_meta_instruction_id_reverse, /* reverse/n57 */
    uninspired_meta_instruction_id_reverse, /* reverse/n58 */
    uninspired_meta_instruction_id_reverse, /* reverse/n59 */
    uninspired_meta_instruction_id_reverse, /* reverse/n60 */
    uninspired_meta_instruction_id_reverse, /* reverse/n61 */
    uninspired_meta_instruction_id_reverse, /* reverse/n62 */
    uninspired_meta_instruction_id_reverse, /* reverse/n63 */
    uninspired_meta_instruction_id_reverse, /* reverse/n64 */
    uninspired_meta_instruction_id_reverse, /* reverse/n65 */
    uninspired_meta_instruction_id_reverse, /* reverse/n66 */
    uninspired_meta_instruction_id_reverse, /* reverse/n67 */
    uninspired_meta_instruction_id_reverse, /* reverse/n68 */
    uninspired_meta_instruction_id_reverse, /* reverse/n69 */
    uninspired_meta_instruction_id_reverse, /* reverse/n70 */
    uninspired_meta_instruction_id_reverse, /* reverse/nR */
    uninspired_meta_instruction_id_roll, /* roll/n0 */
    uninspired_meta_instruction_id_roll, /* roll/n1 */
    uninspired_meta_instruction_id_roll, /* roll/n2 */
    uninspired_meta_instruction_id_roll, /* roll/n3 */
    uninspired_meta_instruction_id_roll, /* roll/n4 */
    uninspired_meta_instruction_id_roll, /* roll/n5 */
    uninspired_meta_instruction_id_roll, /* roll/n6 */
    uninspired_meta_instruction_id_roll, /* roll/n7 */
    uninspired_meta_instruction_id_roll, /* roll/n8 */
    uninspired_meta_instruction_id_roll, /* roll/n9 */
    uninspired_meta_instruction_id_roll, /* roll/n10 */
    uninspired_meta_instruction_id_roll, /* roll/n11 */
    uninspired_meta_instruction_id_roll, /* roll/n12 */
    uninspired_meta_instruction_id_roll, /* roll/n13 */
    uninspired_meta_instruction_id_roll, /* roll/n14 */
    uninspired_meta_instruction_id_roll, /* roll/n15 */
    uninspired_meta_instruction_id_roll, /* roll/n16 */
    uninspired_meta_instruction_id_roll, /* roll/n17 */
    uninspired_meta_instruction_id_roll, /* roll/n18 */
    uninspired_meta_instruction_id_roll, /* roll/n19 */
    uninspired_meta_instruction_id_roll, /* roll/n20 */
    uninspired_meta_instruction_id_roll, /* roll/n21 */
    uninspired_meta_instruction_id_roll, /* roll/n22 */
    uninspired_meta_instruction_id_roll, /* roll/n23 */
    uninspired_meta_instruction_id_roll, /* roll/n24 */
    uninspired_meta_instruction_id_roll, /* roll/n25 */
    uninspired_meta_instruction_id_roll, /* roll/n26 */
    uninspired_meta_instruction_id_roll, /* roll/n27 */
    uninspired_meta_instruction_id_roll, /* roll/n28 */
    uninspired_meta_instruction_id_roll, /* roll/n29 */
    uninspired_meta_instruction_id_roll, /* roll/n30 */
    uninspired_meta_instruction_id_roll, /* roll/n31 */
    uninspired_meta_instruction_id_roll, /* roll/n32 */
    uninspired_meta_instruction_id_roll, /* roll/n33 */
    uninspired_meta_instruction_id_roll, /* roll/n34 */
    uninspired_meta_instruction_id_roll, /* roll/n35 */
    uninspired_meta_instruction_id_roll, /* roll/n36 */
    uninspired_meta_instruction_id_roll, /* roll/n37 */
    uninspired_meta_instruction_id_roll, /* roll/n38 */
    uninspired_meta_instruction_id_roll, /* roll/n39 */
    uninspired_meta_instruction_id_roll, /* roll/n40 */
    uninspired_meta_instruction_id_roll, /* roll/n41 */
    uninspired_meta_instruction_id_roll, /* roll/n42 */
    uninspired_meta_instruction_id_roll, /* roll/n43 */
    uninspired_meta_instruction_id_roll, /* roll/n44 */
    uninspired_meta_instruction_id_roll, /* roll/n45 */
    uninspired_meta_instruction_id_roll, /* roll/n46 */
    uninspired_meta_instruction_id_roll, /* roll/n47 */
    uninspired_meta_instruction_id_roll, /* roll/n48 */
    uninspired_meta_instruction_id_roll, /* roll/n49 */
    uninspired_meta_instruction_id_roll, /* roll/n50 */
    uninspired_meta_instruction_id_roll, /* roll/n51 */
    uninspired_meta_instruction_id_roll, /* roll/n52 */
    uninspired_meta_instruction_id_roll, /* roll/n53 */
    uninspired_meta_instruction_id_roll, /* roll/n54 */
    uninspired_meta_instruction_id_roll, /* roll/n55 */
    uninspired_meta_instruction_id_roll, /* roll/n56 */
    uninspired_meta_instruction_id_roll, /* roll/n57 */
    uninspired_meta_instruction_id_roll, /* roll/n58 */
    uninspired_meta_instruction_id_roll, /* roll/n59 */
    uninspired_meta_instruction_id_roll, /* roll/n60 */
    uninspired_meta_instruction_id_roll, /* roll/n61 */
    uninspired_meta_instruction_id_roll, /* roll/n62 */
    uninspired_meta_instruction_id_roll, /* roll/n63 */
    uninspired_meta_instruction_id_roll, /* roll/n64 */
    uninspired_meta_instruction_id_roll, /* roll/n65 */
    uninspired_meta_instruction_id_roll, /* roll/n66 */
    uninspired_meta_instruction_id_roll, /* roll/n67 */
    uninspired_meta_instruction_id_roll, /* roll/n68 */
    uninspired_meta_instruction_id_roll, /* roll/n69 */
    uninspired_meta_instruction_id_roll, /* roll/n70 */
    uninspired_meta_instruction_id_roll, /* roll/nR */
    uninspired_meta_instruction_id_rollforth, /* rollforth */
    uninspired_meta_instruction_id_rot, /* rot */
    uninspired_meta_instruction_id_safe_mpoint, /* safe-point/fR */
    uninspired_meta_instruction_id_set_mpending, /* set-pending */
    uninspired_meta_instruction_id_slide, /* slide/n1/n1 */
    uninspired_meta_instruction_id_slide, /* slide/n1/n2 */
    uninspired_meta_instruction_id_slide, /* slide/n1/n3 */
    uninspired_meta_instruction_id_slide, /* slide/n1/n4 */
    uninspired_meta_instruction_id_slide, /* slide/n1/n5 */
    uninspired_meta_instruction_id_slide, /* slide/n1/nR */
    uninspired_meta_instruction_id_slide, /* slide/n2/n1 */
    uninspired_meta_instruction_id_slide, /* slide/n2/n2 */
    uninspired_meta_instruction_id_slide, /* slide/n2/n3 */
    uninspired_meta_instruction_id_slide, /* slide/n2/n4 */
    uninspired_meta_instruction_id_slide, /* slide/n2/n5 */
    uninspired_meta_instruction_id_slide, /* slide/n2/nR */
    uninspired_meta_instruction_id_slide, /* slide/n3/n1 */
    uninspired_meta_instruction_id_slide, /* slide/n3/n2 */
    uninspired_meta_instruction_id_slide, /* slide/n3/n3 */
    uninspired_meta_instruction_id_slide, /* slide/n3/n4 */
    uninspired_meta_instruction_id_slide, /* slide/n3/n5 */
    uninspired_meta_instruction_id_slide, /* slide/n3/nR */
    uninspired_meta_instruction_id_slide, /* slide/nR/n1 */
    uninspired_meta_instruction_id_slide, /* slide/nR/n2 */
    uninspired_meta_instruction_id_slide, /* slide/nR/n3 */
    uninspired_meta_instruction_id_slide, /* slide/nR/n4 */
    uninspired_meta_instruction_id_slide, /* slide/nR/n5 */
    uninspired_meta_instruction_id_slide, /* slide/nR/nR */
    uninspired_meta_instruction_id_slideforth, /* slideforth */
    uninspired_meta_instruction_id_stackdrop, /* stackdrop */
    uninspired_meta_instruction_id_stackdup, /* stackdup */
    uninspired_meta_instruction_id_stackif, /* stackif/fR */
    uninspired_meta_instruction_id_stacknip, /* stacknip */
    uninspired_meta_instruction_id_stacknondroppingif, /* stacknondroppingif/fR */
    uninspired_meta_instruction_id_stacknot, /* stacknot */
    uninspired_meta_instruction_id_stackoneminus, /* stackoneminus */
    uninspired_meta_instruction_id_stackoneplus, /* stackoneplus */
    uninspired_meta_instruction_id_stackover, /* stackover */
    uninspired_meta_instruction_id_stackpeek, /* stackpeek/%rR */
    uninspired_meta_instruction_id_stackplus, /* stackplus */
    uninspired_meta_instruction_id_stackplusr, /* stackplusr/%rR */
    uninspired_meta_instruction_id_stackpop, /* stackpop/%rR */
    uninspired_meta_instruction_id_stackprint, /* stackprint/retR */
    uninspired_meta_instruction_id_stackpush, /* stackpush/%rR */
    uninspired_meta_instruction_id_stackpush, /* stackpush/n0 */
    uninspired_meta_instruction_id_stackpush, /* stackpush/n1 */
    uninspired_meta_instruction_id_stackpush, /* stackpush/nR */
    uninspired_meta_instruction_id_stackpush, /* stackpush/lR */
    uninspired_meta_instruction_id_stackpushunspecified, /* stackpushunspecified */
    uninspired_meta_instruction_id_stackset, /* stackset/%rR */
    uninspired_meta_instruction_id_stackset, /* stackset/n0 */
    uninspired_meta_instruction_id_stackset, /* stackset/n1 */
    uninspired_meta_instruction_id_stackset, /* stackset/nR */
    uninspired_meta_instruction_id_stackset, /* stackset/lR */
    uninspired_meta_instruction_id_stackswap, /* stackswap */
    uninspired_meta_instruction_id_stackswaptop, /* stackswaptop/%rR */
    uninspired_meta_instruction_id_stacktimes, /* stacktimes */
    uninspired_meta_instruction_id_storewithbyteoffset, /* storewithbyteoffset/%rR/%rR/%rR */
    uninspired_meta_instruction_id_storewithbyteoffset, /* storewithbyteoffset/%rR/%rR/n0 */
    uninspired_meta_instruction_id_storewithbyteoffset, /* storewithbyteoffset/%rR/%rR/n8 */
    uninspired_meta_instruction_id_storewithbyteoffset, /* storewithbyteoffset/%rR/%rR/nR */
    uninspired_meta_instruction_id_storewithbyteoffset, /* storewithbyteoffset/nR/%rR/%rR */
    uninspired_meta_instruction_id_storewithbyteoffset, /* storewithbyteoffset/nR/%rR/n0 */
    uninspired_meta_instruction_id_storewithbyteoffset, /* storewithbyteoffset/nR/%rR/n8 */
    uninspired_meta_instruction_id_storewithbyteoffset, /* storewithbyteoffset/nR/%rR/nR */
    uninspired_meta_instruction_id_storewithwordoffset, /* storewithwordoffset/%rR/%rR/%rR */
    uninspired_meta_instruction_id_storewithwordoffset, /* storewithwordoffset/%rR/%rR/n0 */
    uninspired_meta_instruction_id_storewithwordoffset, /* storewithwordoffset/%rR/%rR/n1 */
    uninspired_meta_instruction_id_storewithwordoffset, /* storewithwordoffset/%rR/%rR/n2 */
    uninspired_meta_instruction_id_storewithwordoffset, /* storewithwordoffset/%rR/%rR/nR */
    uninspired_meta_instruction_id_storewithwordoffset, /* storewithwordoffset/nR/%rR/%rR */
    uninspired_meta_instruction_id_storewithwordoffset, /* storewithwordoffset/nR/%rR/n0 */
    uninspired_meta_instruction_id_storewithwordoffset, /* storewithwordoffset/nR/%rR/n1 */
    uninspired_meta_instruction_id_storewithwordoffset, /* storewithwordoffset/nR/%rR/n2 */
    uninspired_meta_instruction_id_storewithwordoffset, /* storewithwordoffset/nR/%rR/nR */
    uninspired_meta_instruction_id_sub, /* sub/%rR/%rR/%rR */
    uninspired_meta_instruction_id_sub, /* sub/%rR/n1/%rR */
    uninspired_meta_instruction_id_sub, /* sub/%rR/nR/%rR */
    uninspired_meta_instruction_id_sub, /* sub/n0/%rR/%rR */
    uninspired_meta_instruction_id_sub, /* sub/n0/n1/%rR */
    uninspired_meta_instruction_id_sub, /* sub/n0/nR/%rR */
    uninspired_meta_instruction_id_sub, /* sub/nR/%rR/%rR */
    uninspired_meta_instruction_id_sub, /* sub/nR/n1/%rR */
    uninspired_meta_instruction_id_sub, /* sub/nR/nR/%rR */
    uninspired_meta_instruction_id_subo, /* subo/%rR/%rR/%rR/fR */
    uninspired_meta_instruction_id_subo, /* subo/%rR/n1/%rR/fR */
    uninspired_meta_instruction_id_subo, /* subo/%rR/nR/%rR/fR */
    uninspired_meta_instruction_id_subo, /* subo/nR/%rR/%rR/fR */
    uninspired_meta_instruction_id_subo, /* subo/nR/n1/%rR/fR */
    uninspired_meta_instruction_id_subo, /* subo/nR/nR/%rR/fR */
    uninspired_meta_instruction_id_tuck, /* tuck */
    uninspired_meta_instruction_id_unreachable, /* unreachable */
    uninspired_meta_instruction_id_whirl, /* whirl/n0 */
    uninspired_meta_instruction_id_whirl, /* whirl/n1 */
    uninspired_meta_instruction_id_whirl, /* whirl/n2 */
    uninspired_meta_instruction_id_whirl, /* whirl/n3 */
    uninspired_meta_instruction_id_whirl, /* whirl/nR */
    uninspired_meta_instruction_id_whirlforth, /* whirlforth */
    uninspired_meta_instruction_id_addo, /* !REPLACEMENT-addo/%rR/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_addo, /* !REPLACEMENT-addo/%rR/n1/%rR/fR/retR */
    uninspired_meta_instruction_id_addo, /* !REPLACEMENT-addo/%rR/n-1/%rR/fR/retR */
    uninspired_meta_instruction_id_addo, /* !REPLACEMENT-addo/%rR/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_addo, /* !REPLACEMENT-addo/nR/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_addo, /* !REPLACEMENT-addo/nR/n1/%rR/fR/retR */
    uninspired_meta_instruction_id_addo, /* !REPLACEMENT-addo/nR/n-1/%rR/fR/retR */
    uninspired_meta_instruction_id_addo, /* !REPLACEMENT-addo/nR/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_b, /* !REPLACEMENT-b/fR/retR */
    uninspired_meta_instruction_id_band, /* !REPLACEMENT-band/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_band, /* !REPLACEMENT-band/%rR/n3/fR/retR */
    uninspired_meta_instruction_id_band, /* !REPLACEMENT-band/%rR/n7/fR/retR */
    uninspired_meta_instruction_id_band, /* !REPLACEMENT-band/%rR/nR/fR/retR */
    uninspired_meta_instruction_id_band, /* !REPLACEMENT-band/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_band, /* !REPLACEMENT-band/nR/n3/fR/retR */
    uninspired_meta_instruction_id_band, /* !REPLACEMENT-band/nR/n7/fR/retR */
    uninspired_meta_instruction_id_band, /* !REPLACEMENT-band/nR/nR/fR/retR */
    uninspired_meta_instruction_id_beq, /* !REPLACEMENT-beq/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_beq, /* !REPLACEMENT-beq/%rR/nR/fR/retR */
    uninspired_meta_instruction_id_beq, /* !REPLACEMENT-beq/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_beq, /* !REPLACEMENT-beq/nR/nR/fR/retR */
    uninspired_meta_instruction_id_bge, /* !REPLACEMENT-bge/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_bge, /* !REPLACEMENT-bge/%rR/n0/fR/retR */
    uninspired_meta_instruction_id_bge, /* !REPLACEMENT-bge/%rR/n1/fR/retR */
    uninspired_meta_instruction_id_bge, /* !REPLACEMENT-bge/%rR/nR/fR/retR */
    uninspired_meta_instruction_id_bge, /* !REPLACEMENT-bge/n0/%rR/fR/retR */
    uninspired_meta_instruction_id_bge, /* !REPLACEMENT-bge/n0/n0/fR/retR */
    uninspired_meta_instruction_id_bge, /* !REPLACEMENT-bge/n0/n1/fR/retR */
    uninspired_meta_instruction_id_bge, /* !REPLACEMENT-bge/n0/nR/fR/retR */
    uninspired_meta_instruction_id_bge, /* !REPLACEMENT-bge/n1/%rR/fR/retR */
    uninspired_meta_instruction_id_bge, /* !REPLACEMENT-bge/n1/n0/fR/retR */
    uninspired_meta_instruction_id_bge, /* !REPLACEMENT-bge/n1/n1/fR/retR */
    uninspired_meta_instruction_id_bge, /* !REPLACEMENT-bge/n1/nR/fR/retR */
    uninspired_meta_instruction_id_bge, /* !REPLACEMENT-bge/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_bge, /* !REPLACEMENT-bge/nR/n0/fR/retR */
    uninspired_meta_instruction_id_bge, /* !REPLACEMENT-bge/nR/n1/fR/retR */
    uninspired_meta_instruction_id_bge, /* !REPLACEMENT-bge/nR/nR/fR/retR */
    uninspired_meta_instruction_id_bgeu, /* !REPLACEMENT-bgeu/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_bgeu, /* !REPLACEMENT-bgeu/%rR/n0/fR/retR */
    uninspired_meta_instruction_id_bgeu, /* !REPLACEMENT-bgeu/%rR/n1/fR/retR */
    uninspired_meta_instruction_id_bgeu, /* !REPLACEMENT-bgeu/%rR/nR/fR/retR */
    uninspired_meta_instruction_id_bgeu, /* !REPLACEMENT-bgeu/n0/%rR/fR/retR */
    uninspired_meta_instruction_id_bgeu, /* !REPLACEMENT-bgeu/n0/n0/fR/retR */
    uninspired_meta_instruction_id_bgeu, /* !REPLACEMENT-bgeu/n0/n1/fR/retR */
    uninspired_meta_instruction_id_bgeu, /* !REPLACEMENT-bgeu/n0/nR/fR/retR */
    uninspired_meta_instruction_id_bgeu, /* !REPLACEMENT-bgeu/n1/%rR/fR/retR */
    uninspired_meta_instruction_id_bgeu, /* !REPLACEMENT-bgeu/n1/n0/fR/retR */
    uninspired_meta_instruction_id_bgeu, /* !REPLACEMENT-bgeu/n1/n1/fR/retR */
    uninspired_meta_instruction_id_bgeu, /* !REPLACEMENT-bgeu/n1/nR/fR/retR */
    uninspired_meta_instruction_id_bgeu, /* !REPLACEMENT-bgeu/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_bgeu, /* !REPLACEMENT-bgeu/nR/n0/fR/retR */
    uninspired_meta_instruction_id_bgeu, /* !REPLACEMENT-bgeu/nR/n1/fR/retR */
    uninspired_meta_instruction_id_bgeu, /* !REPLACEMENT-bgeu/nR/nR/fR/retR */
    uninspired_meta_instruction_id_bgt, /* !REPLACEMENT-bgt/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_bgt, /* !REPLACEMENT-bgt/%rR/n0/fR/retR */
    uninspired_meta_instruction_id_bgt, /* !REPLACEMENT-bgt/%rR/n1/fR/retR */
    uninspired_meta_instruction_id_bgt, /* !REPLACEMENT-bgt/%rR/nR/fR/retR */
    uninspired_meta_instruction_id_bgt, /* !REPLACEMENT-bgt/n0/%rR/fR/retR */
    uninspired_meta_instruction_id_bgt, /* !REPLACEMENT-bgt/n0/n0/fR/retR */
    uninspired_meta_instruction_id_bgt, /* !REPLACEMENT-bgt/n0/n1/fR/retR */
    uninspired_meta_instruction_id_bgt, /* !REPLACEMENT-bgt/n0/nR/fR/retR */
    uninspired_meta_instruction_id_bgt, /* !REPLACEMENT-bgt/n1/%rR/fR/retR */
    uninspired_meta_instruction_id_bgt, /* !REPLACEMENT-bgt/n1/n0/fR/retR */
    uninspired_meta_instruction_id_bgt, /* !REPLACEMENT-bgt/n1/n1/fR/retR */
    uninspired_meta_instruction_id_bgt, /* !REPLACEMENT-bgt/n1/nR/fR/retR */
    uninspired_meta_instruction_id_bgt, /* !REPLACEMENT-bgt/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_bgt, /* !REPLACEMENT-bgt/nR/n0/fR/retR */
    uninspired_meta_instruction_id_bgt, /* !REPLACEMENT-bgt/nR/n1/fR/retR */
    uninspired_meta_instruction_id_bgt, /* !REPLACEMENT-bgt/nR/nR/fR/retR */
    uninspired_meta_instruction_id_bgtu, /* !REPLACEMENT-bgtu/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_bgtu, /* !REPLACEMENT-bgtu/%rR/n0/fR/retR */
    uninspired_meta_instruction_id_bgtu, /* !REPLACEMENT-bgtu/%rR/n1/fR/retR */
    uninspired_meta_instruction_id_bgtu, /* !REPLACEMENT-bgtu/%rR/nR/fR/retR */
    uninspired_meta_instruction_id_bgtu, /* !REPLACEMENT-bgtu/n0/%rR/fR/retR */
    uninspired_meta_instruction_id_bgtu, /* !REPLACEMENT-bgtu/n0/n0/fR/retR */
    uninspired_meta_instruction_id_bgtu, /* !REPLACEMENT-bgtu/n0/n1/fR/retR */
    uninspired_meta_instruction_id_bgtu, /* !REPLACEMENT-bgtu/n0/nR/fR/retR */
    uninspired_meta_instruction_id_bgtu, /* !REPLACEMENT-bgtu/n1/%rR/fR/retR */
    uninspired_meta_instruction_id_bgtu, /* !REPLACEMENT-bgtu/n1/n0/fR/retR */
    uninspired_meta_instruction_id_bgtu, /* !REPLACEMENT-bgtu/n1/n1/fR/retR */
    uninspired_meta_instruction_id_bgtu, /* !REPLACEMENT-bgtu/n1/nR/fR/retR */
    uninspired_meta_instruction_id_bgtu, /* !REPLACEMENT-bgtu/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_bgtu, /* !REPLACEMENT-bgtu/nR/n0/fR/retR */
    uninspired_meta_instruction_id_bgtu, /* !REPLACEMENT-bgtu/nR/n1/fR/retR */
    uninspired_meta_instruction_id_bgtu, /* !REPLACEMENT-bgtu/nR/nR/fR/retR */
    uninspired_meta_instruction_id_ble, /* !REPLACEMENT-ble/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_ble, /* !REPLACEMENT-ble/%rR/n0/fR/retR */
    uninspired_meta_instruction_id_ble, /* !REPLACEMENT-ble/%rR/n1/fR/retR */
    uninspired_meta_instruction_id_ble, /* !REPLACEMENT-ble/%rR/nR/fR/retR */
    uninspired_meta_instruction_id_ble, /* !REPLACEMENT-ble/n0/%rR/fR/retR */
    uninspired_meta_instruction_id_ble, /* !REPLACEMENT-ble/n0/n0/fR/retR */
    uninspired_meta_instruction_id_ble, /* !REPLACEMENT-ble/n0/n1/fR/retR */
    uninspired_meta_instruction_id_ble, /* !REPLACEMENT-ble/n0/nR/fR/retR */
    uninspired_meta_instruction_id_ble, /* !REPLACEMENT-ble/n1/%rR/fR/retR */
    uninspired_meta_instruction_id_ble, /* !REPLACEMENT-ble/n1/n0/fR/retR */
    uninspired_meta_instruction_id_ble, /* !REPLACEMENT-ble/n1/n1/fR/retR */
    uninspired_meta_instruction_id_ble, /* !REPLACEMENT-ble/n1/nR/fR/retR */
    uninspired_meta_instruction_id_ble, /* !REPLACEMENT-ble/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_ble, /* !REPLACEMENT-ble/nR/n0/fR/retR */
    uninspired_meta_instruction_id_ble, /* !REPLACEMENT-ble/nR/n1/fR/retR */
    uninspired_meta_instruction_id_ble, /* !REPLACEMENT-ble/nR/nR/fR/retR */
    uninspired_meta_instruction_id_bleu, /* !REPLACEMENT-bleu/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_bleu, /* !REPLACEMENT-bleu/%rR/n0/fR/retR */
    uninspired_meta_instruction_id_bleu, /* !REPLACEMENT-bleu/%rR/n1/fR/retR */
    uninspired_meta_instruction_id_bleu, /* !REPLACEMENT-bleu/%rR/nR/fR/retR */
    uninspired_meta_instruction_id_bleu, /* !REPLACEMENT-bleu/n0/%rR/fR/retR */
    uninspired_meta_instruction_id_bleu, /* !REPLACEMENT-bleu/n0/n0/fR/retR */
    uninspired_meta_instruction_id_bleu, /* !REPLACEMENT-bleu/n0/n1/fR/retR */
    uninspired_meta_instruction_id_bleu, /* !REPLACEMENT-bleu/n0/nR/fR/retR */
    uninspired_meta_instruction_id_bleu, /* !REPLACEMENT-bleu/n1/%rR/fR/retR */
    uninspired_meta_instruction_id_bleu, /* !REPLACEMENT-bleu/n1/n0/fR/retR */
    uninspired_meta_instruction_id_bleu, /* !REPLACEMENT-bleu/n1/n1/fR/retR */
    uninspired_meta_instruction_id_bleu, /* !REPLACEMENT-bleu/n1/nR/fR/retR */
    uninspired_meta_instruction_id_bleu, /* !REPLACEMENT-bleu/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_bleu, /* !REPLACEMENT-bleu/nR/n0/fR/retR */
    uninspired_meta_instruction_id_bleu, /* !REPLACEMENT-bleu/nR/n1/fR/retR */
    uninspired_meta_instruction_id_bleu, /* !REPLACEMENT-bleu/nR/nR/fR/retR */
    uninspired_meta_instruction_id_blt, /* !REPLACEMENT-blt/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_blt, /* !REPLACEMENT-blt/%rR/n0/fR/retR */
    uninspired_meta_instruction_id_blt, /* !REPLACEMENT-blt/%rR/n1/fR/retR */
    uninspired_meta_instruction_id_blt, /* !REPLACEMENT-blt/%rR/nR/fR/retR */
    uninspired_meta_instruction_id_blt, /* !REPLACEMENT-blt/n0/%rR/fR/retR */
    uninspired_meta_instruction_id_blt, /* !REPLACEMENT-blt/n0/n0/fR/retR */
    uninspired_meta_instruction_id_blt, /* !REPLACEMENT-blt/n0/n1/fR/retR */
    uninspired_meta_instruction_id_blt, /* !REPLACEMENT-blt/n0/nR/fR/retR */
    uninspired_meta_instruction_id_blt, /* !REPLACEMENT-blt/n1/%rR/fR/retR */
    uninspired_meta_instruction_id_blt, /* !REPLACEMENT-blt/n1/n0/fR/retR */
    uninspired_meta_instruction_id_blt, /* !REPLACEMENT-blt/n1/n1/fR/retR */
    uninspired_meta_instruction_id_blt, /* !REPLACEMENT-blt/n1/nR/fR/retR */
    uninspired_meta_instruction_id_blt, /* !REPLACEMENT-blt/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_blt, /* !REPLACEMENT-blt/nR/n0/fR/retR */
    uninspired_meta_instruction_id_blt, /* !REPLACEMENT-blt/nR/n1/fR/retR */
    uninspired_meta_instruction_id_blt, /* !REPLACEMENT-blt/nR/nR/fR/retR */
    uninspired_meta_instruction_id_bltu, /* !REPLACEMENT-bltu/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_bltu, /* !REPLACEMENT-bltu/%rR/n0/fR/retR */
    uninspired_meta_instruction_id_bltu, /* !REPLACEMENT-bltu/%rR/n1/fR/retR */
    uninspired_meta_instruction_id_bltu, /* !REPLACEMENT-bltu/%rR/nR/fR/retR */
    uninspired_meta_instruction_id_bltu, /* !REPLACEMENT-bltu/n0/%rR/fR/retR */
    uninspired_meta_instruction_id_bltu, /* !REPLACEMENT-bltu/n0/n0/fR/retR */
    uninspired_meta_instruction_id_bltu, /* !REPLACEMENT-bltu/n0/n1/fR/retR */
    uninspired_meta_instruction_id_bltu, /* !REPLACEMENT-bltu/n0/nR/fR/retR */
    uninspired_meta_instruction_id_bltu, /* !REPLACEMENT-bltu/n1/%rR/fR/retR */
    uninspired_meta_instruction_id_bltu, /* !REPLACEMENT-bltu/n1/n0/fR/retR */
    uninspired_meta_instruction_id_bltu, /* !REPLACEMENT-bltu/n1/n1/fR/retR */
    uninspired_meta_instruction_id_bltu, /* !REPLACEMENT-bltu/n1/nR/fR/retR */
    uninspired_meta_instruction_id_bltu, /* !REPLACEMENT-bltu/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_bltu, /* !REPLACEMENT-bltu/nR/n0/fR/retR */
    uninspired_meta_instruction_id_bltu, /* !REPLACEMENT-bltu/nR/n1/fR/retR */
    uninspired_meta_instruction_id_bltu, /* !REPLACEMENT-bltu/nR/nR/fR/retR */
    uninspired_meta_instruction_id_bne, /* !REPLACEMENT-bne/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_bne, /* !REPLACEMENT-bne/%rR/n0/fR/retR */
    uninspired_meta_instruction_id_bne, /* !REPLACEMENT-bne/%rR/nR/fR/retR */
    uninspired_meta_instruction_id_bne, /* !REPLACEMENT-bne/n0/%rR/fR/retR */
    uninspired_meta_instruction_id_bne, /* !REPLACEMENT-bne/n0/n0/fR/retR */
    uninspired_meta_instruction_id_bne, /* !REPLACEMENT-bne/n0/nR/fR/retR */
    uninspired_meta_instruction_id_bne, /* !REPLACEMENT-bne/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_bne, /* !REPLACEMENT-bne/nR/n0/fR/retR */
    uninspired_meta_instruction_id_bne, /* !REPLACEMENT-bne/nR/nR/fR/retR */
    uninspired_meta_instruction_id_bneg, /* !REPLACEMENT-bneg/%rR/fR/retR */
    uninspired_meta_instruction_id_bneg, /* !REPLACEMENT-bneg/nR/fR/retR */
    uninspired_meta_instruction_id_bnneg, /* !REPLACEMENT-bnneg/%rR/fR/retR */
    uninspired_meta_instruction_id_bnneg, /* !REPLACEMENT-bnneg/nR/fR/retR */
    uninspired_meta_instruction_id_bnotand, /* !REPLACEMENT-bnotand/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_bnotand, /* !REPLACEMENT-bnotand/%rR/n3/fR/retR */
    uninspired_meta_instruction_id_bnotand, /* !REPLACEMENT-bnotand/%rR/n7/fR/retR */
    uninspired_meta_instruction_id_bnotand, /* !REPLACEMENT-bnotand/%rR/nR/fR/retR */
    uninspired_meta_instruction_id_bnotand, /* !REPLACEMENT-bnotand/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_bnotand, /* !REPLACEMENT-bnotand/nR/n3/fR/retR */
    uninspired_meta_instruction_id_bnotand, /* !REPLACEMENT-bnotand/nR/n7/fR/retR */
    uninspired_meta_instruction_id_bnotand, /* !REPLACEMENT-bnotand/nR/nR/fR/retR */
    uninspired_meta_instruction_id_bnpos, /* !REPLACEMENT-bnpos/%rR/fR/retR */
    uninspired_meta_instruction_id_bnpos, /* !REPLACEMENT-bnpos/nR/fR/retR */
    uninspired_meta_instruction_id_bnz, /* !REPLACEMENT-bnz/%rR/fR/retR */
    uninspired_meta_instruction_id_bnz, /* !REPLACEMENT-bnz/nR/fR/retR */
    uninspired_meta_instruction_id_bpos, /* !REPLACEMENT-bpos/%rR/fR/retR */
    uninspired_meta_instruction_id_bpos, /* !REPLACEMENT-bpos/nR/fR/retR */
    uninspired_meta_instruction_id_br, /* !REPLACEMENT-br/%rR/retR */
    uninspired_meta_instruction_id_bz, /* !REPLACEMENT-bz/%rR/fR/retR */
    uninspired_meta_instruction_id_bz, /* !REPLACEMENT-bz/nR/fR/retR */
    uninspired_meta_instruction_id_divo, /* !REPLACEMENT-divo/%rR/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_divo, /* !REPLACEMENT-divo/%rR/n2/%rR/fR/retR */
    uninspired_meta_instruction_id_divo, /* !REPLACEMENT-divo/%rR/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_divo, /* !REPLACEMENT-divo/nR/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_divo, /* !REPLACEMENT-divo/nR/n2/%rR/fR/retR */
    uninspired_meta_instruction_id_divo, /* !REPLACEMENT-divo/nR/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_endvm, /* !REPLACEMENT-endvm/retR */
    uninspired_meta_instruction_id_exitvm, /* !REPLACEMENT-exitvm/retR */
    uninspired_meta_instruction_id_modo, /* !REPLACEMENT-modo/%rR/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_modo, /* !REPLACEMENT-modo/%rR/n2/%rR/fR/retR */
    uninspired_meta_instruction_id_modo, /* !REPLACEMENT-modo/%rR/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_modo, /* !REPLACEMENT-modo/nR/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_modo, /* !REPLACEMENT-modo/nR/n2/%rR/fR/retR */
    uninspired_meta_instruction_id_modo, /* !REPLACEMENT-modo/nR/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_mulo, /* !REPLACEMENT-mulo/%rR/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_mulo, /* !REPLACEMENT-mulo/%rR/n2/%rR/fR/retR */
    uninspired_meta_instruction_id_mulo, /* !REPLACEMENT-mulo/%rR/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_mulo, /* !REPLACEMENT-mulo/nR/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_mulo, /* !REPLACEMENT-mulo/nR/n2/%rR/fR/retR */
    uninspired_meta_instruction_id_mulo, /* !REPLACEMENT-mulo/nR/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_procedurecall, /* !REPLACEMENT-procedurecall/fR/retR */
    uninspired_meta_instruction_id_procedurecallr, /* !REPLACEMENT-procedurecallr/%rR/retR */
    uninspired_meta_instruction_id_procedurecallr, /* !REPLACEMENT-procedurecallr/lR/retR */
    uninspired_meta_instruction_id_procedureprolog, /* !REPLACEMENT-procedureprolog/retR */
    uninspired_meta_instruction_id_procedurereturn, /* !REPLACEMENT-procedurereturn/retR */
    uninspired_meta_instruction_id_raise, /* !REPLACEMENT-raise/%rR/retR */
    uninspired_meta_instruction_id_raise, /* !REPLACEMENT-raise/n0/retR */
    uninspired_meta_instruction_id_raise, /* !REPLACEMENT-raise/n1/retR */
    uninspired_meta_instruction_id_raise, /* !REPLACEMENT-raise/n2/retR */
    uninspired_meta_instruction_id_raise, /* !REPLACEMENT-raise/n3/retR */
    uninspired_meta_instruction_id_raise, /* !REPLACEMENT-raise/n4/retR */
    uninspired_meta_instruction_id_raise, /* !REPLACEMENT-raise/n5/retR */
    uninspired_meta_instruction_id_raise, /* !REPLACEMENT-raise/n6/retR */
    uninspired_meta_instruction_id_raise, /* !REPLACEMENT-raise/n7/retR */
    uninspired_meta_instruction_id_raise, /* !REPLACEMENT-raise/n8/retR */
    uninspired_meta_instruction_id_raise, /* !REPLACEMENT-raise/n9/retR */
    uninspired_meta_instruction_id_raise, /* !REPLACEMENT-raise/n10/retR */
    uninspired_meta_instruction_id_raise, /* !REPLACEMENT-raise/nR/retR */
    uninspired_meta_instruction_id_safe_mpoint, /* !REPLACEMENT-safe-point/fR/retR */
    uninspired_meta_instruction_id_stackif, /* !REPLACEMENT-stackif/fR/retR */
    uninspired_meta_instruction_id_stacknondroppingif, /* !REPLACEMENT-stacknondroppingif/fR/retR */
    uninspired_meta_instruction_id_subo, /* !REPLACEMENT-subo/%rR/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_subo, /* !REPLACEMENT-subo/%rR/n1/%rR/fR/retR */
    uninspired_meta_instruction_id_subo, /* !REPLACEMENT-subo/%rR/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_subo, /* !REPLACEMENT-subo/nR/%rR/%rR/fR/retR */
    uninspired_meta_instruction_id_subo, /* !REPLACEMENT-subo/nR/n1/%rR/fR/retR */
    uninspired_meta_instruction_id_subo, /* !REPLACEMENT-subo/nR/nR/%rR/fR/retR */
    uninspired_meta_instruction_id_unreachable /* !REPLACEMENT-unreachable/retR */
    };

#ifdef JITTER_HAVE_DEFECT_REPLACEMENT
/* Worst-case replacement table. */
const jitter_uint
uninspired_worst_case_replacement_table [] =
  {
    uninspired_specialized_instruction_opcode__eINVALID, /* !INVALID is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eBEGINBASICBLOCK, /* !BEGINBASICBLOCK is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eEXITVM, /* !EXITVM is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eDATALOCATIONS, /* !DATALOCATIONS is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eNOP, /* !NOP is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eUNREACHABLE0, /* !UNREACHABLE0 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eUNREACHABLE1, /* !UNREACHABLE1 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__ePRETENDTOJUMPANYWHERE, /* !PRETENDTOJUMPANYWHERE is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_add___rrR___rrR___rrR, /* add/%rR/%rR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_add___rrR__n1___rrR, /* add/%rR/n1/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_add___rrR__n_m1___rrR, /* add/%rR/n-1/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_add___rrR__nR___rrR, /* add/%rR/nR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_add__n1___rrR___rrR, /* add/n1/%rR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_add__n1__n1___rrR, /* add/n1/n1/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_add__n1__n_m1___rrR, /* add/n1/n-1/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_add__n1__nR___rrR, /* add/n1/nR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_add__n_m1___rrR___rrR, /* add/n-1/%rR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_add__n_m1__n1___rrR, /* add/n-1/n1/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_add__n_m1__n_m1___rrR, /* add/n-1/n-1/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_add__n_m1__nR___rrR, /* add/n-1/nR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_add__nR___rrR___rrR, /* add/nR/%rR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_add__nR__n1___rrR, /* add/nR/n1/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_add__nR__n_m1___rrR, /* add/nR/n-1/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_add__nR__nR___rrR, /* add/nR/nR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_maddo___rrR___rrR___rrR__fR__retR, /* addo/%rR/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-addo/%rR/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_maddo___rrR__n1___rrR__fR__retR, /* addo/%rR/n1/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-addo/%rR/n1/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_maddo___rrR__n_m1___rrR__fR__retR, /* addo/%rR/n-1/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-addo/%rR/n-1/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_maddo___rrR__nR___rrR__fR__retR, /* addo/%rR/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-addo/%rR/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_maddo__nR___rrR___rrR__fR__retR, /* addo/nR/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-addo/nR/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_maddo__nR__n1___rrR__fR__retR, /* addo/nR/n1/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-addo/nR/n1/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_maddo__nR__n_m1___rrR__fR__retR, /* addo/nR/n-1/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-addo/nR/n-1/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_maddo__nR__nR___rrR__fR__retR, /* addo/nR/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-addo/nR/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mb__fR__retR, /* b/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-b/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mband___rrR___rrR__fR__retR, /* band/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-band/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mband___rrR__n3__fR__retR, /* band/%rR/n3/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-band/%rR/n3/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mband___rrR__n7__fR__retR, /* band/%rR/n7/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-band/%rR/n7/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mband___rrR__nR__fR__retR, /* band/%rR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-band/%rR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mband__nR___rrR__fR__retR, /* band/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-band/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mband__nR__n3__fR__retR, /* band/nR/n3/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-band/nR/n3/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mband__nR__n7__fR__retR, /* band/nR/n7/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-band/nR/n7/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mband__nR__nR__fR__retR, /* band/nR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-band/nR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbeq___rrR___rrR__fR__retR, /* beq/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-beq/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbeq___rrR__nR__fR__retR, /* beq/%rR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-beq/%rR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbeq__nR___rrR__fR__retR, /* beq/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-beq/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbeq__nR__nR__fR__retR, /* beq/nR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-beq/nR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge___rrR___rrR__fR__retR, /* bge/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge___rrR__n0__fR__retR, /* bge/%rR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/%rR/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge___rrR__n1__fR__retR, /* bge/%rR/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/%rR/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge___rrR__nR__fR__retR, /* bge/%rR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/%rR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__n0___rrR__fR__retR, /* bge/n0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/n0/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__n0__n0__fR__retR, /* bge/n0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/n0/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__n0__n1__fR__retR, /* bge/n0/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/n0/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__n0__nR__fR__retR, /* bge/n0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/n0/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__n1___rrR__fR__retR, /* bge/n1/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/n1/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__n1__n0__fR__retR, /* bge/n1/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/n1/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__n1__n1__fR__retR, /* bge/n1/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/n1/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__n1__nR__fR__retR, /* bge/n1/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/n1/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__nR___rrR__fR__retR, /* bge/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__nR__n0__fR__retR, /* bge/nR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/nR/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__nR__n1__fR__retR, /* bge/nR/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/nR/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__nR__nR__fR__retR, /* bge/nR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/nR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu___rrR___rrR__fR__retR, /* bgeu/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgeu/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu___rrR__n0__fR__retR, /* bgeu/%rR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgeu/%rR/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu___rrR__n1__fR__retR, /* bgeu/%rR/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgeu/%rR/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu___rrR__nR__fR__retR, /* bgeu/%rR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgeu/%rR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__n0___rrR__fR__retR, /* bgeu/n0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgeu/n0/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__n0__n0__fR__retR, /* bgeu/n0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgeu/n0/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__n0__n1__fR__retR, /* bgeu/n0/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgeu/n0/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__n0__nR__fR__retR, /* bgeu/n0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgeu/n0/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__n1___rrR__fR__retR, /* bgeu/n1/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgeu/n1/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__n1__n0__fR__retR, /* bgeu/n1/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgeu/n1/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__n1__n1__fR__retR, /* bgeu/n1/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgeu/n1/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__n1__nR__fR__retR, /* bgeu/n1/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgeu/n1/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__nR___rrR__fR__retR, /* bgeu/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgeu/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__nR__n0__fR__retR, /* bgeu/nR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgeu/nR/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__nR__n1__fR__retR, /* bgeu/nR/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgeu/nR/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__nR__nR__fR__retR, /* bgeu/nR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgeu/nR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt___rrR___rrR__fR__retR, /* bgt/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgt/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt___rrR__n0__fR__retR, /* bgt/%rR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgt/%rR/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt___rrR__n1__fR__retR, /* bgt/%rR/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgt/%rR/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt___rrR__nR__fR__retR, /* bgt/%rR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgt/%rR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__n0___rrR__fR__retR, /* bgt/n0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgt/n0/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__n0__n0__fR__retR, /* bgt/n0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgt/n0/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__n0__n1__fR__retR, /* bgt/n0/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgt/n0/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__n0__nR__fR__retR, /* bgt/n0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgt/n0/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__n1___rrR__fR__retR, /* bgt/n1/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgt/n1/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__n1__n0__fR__retR, /* bgt/n1/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgt/n1/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__n1__n1__fR__retR, /* bgt/n1/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgt/n1/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__n1__nR__fR__retR, /* bgt/n1/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgt/n1/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__nR___rrR__fR__retR, /* bgt/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgt/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__nR__n0__fR__retR, /* bgt/nR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgt/nR/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__nR__n1__fR__retR, /* bgt/nR/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgt/nR/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__nR__nR__fR__retR, /* bgt/nR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgt/nR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu___rrR___rrR__fR__retR, /* bgtu/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgtu/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu___rrR__n0__fR__retR, /* bgtu/%rR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgtu/%rR/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu___rrR__n1__fR__retR, /* bgtu/%rR/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgtu/%rR/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu___rrR__nR__fR__retR, /* bgtu/%rR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgtu/%rR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__n0___rrR__fR__retR, /* bgtu/n0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgtu/n0/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__n0__n0__fR__retR, /* bgtu/n0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgtu/n0/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__n0__n1__fR__retR, /* bgtu/n0/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgtu/n0/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__n0__nR__fR__retR, /* bgtu/n0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgtu/n0/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__n1___rrR__fR__retR, /* bgtu/n1/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgtu/n1/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__n1__n0__fR__retR, /* bgtu/n1/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgtu/n1/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__n1__n1__fR__retR, /* bgtu/n1/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgtu/n1/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__n1__nR__fR__retR, /* bgtu/n1/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgtu/n1/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__nR___rrR__fR__retR, /* bgtu/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgtu/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__nR__n0__fR__retR, /* bgtu/nR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgtu/nR/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__nR__n1__fR__retR, /* bgtu/nR/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgtu/nR/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__nR__nR__fR__retR, /* bgtu/nR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bgtu/nR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble___rrR___rrR__fR__retR, /* ble/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble___rrR__n0__fR__retR, /* ble/%rR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/%rR/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble___rrR__n1__fR__retR, /* ble/%rR/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/%rR/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble___rrR__nR__fR__retR, /* ble/%rR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/%rR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__n0___rrR__fR__retR, /* ble/n0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/n0/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__n0__n0__fR__retR, /* ble/n0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/n0/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__n0__n1__fR__retR, /* ble/n0/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/n0/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__n0__nR__fR__retR, /* ble/n0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/n0/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__n1___rrR__fR__retR, /* ble/n1/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/n1/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__n1__n0__fR__retR, /* ble/n1/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/n1/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__n1__n1__fR__retR, /* ble/n1/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/n1/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__n1__nR__fR__retR, /* ble/n1/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/n1/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__nR___rrR__fR__retR, /* ble/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__nR__n0__fR__retR, /* ble/nR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/nR/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__nR__n1__fR__retR, /* ble/nR/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/nR/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__nR__nR__fR__retR, /* ble/nR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/nR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu___rrR___rrR__fR__retR, /* bleu/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bleu/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu___rrR__n0__fR__retR, /* bleu/%rR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bleu/%rR/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu___rrR__n1__fR__retR, /* bleu/%rR/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bleu/%rR/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu___rrR__nR__fR__retR, /* bleu/%rR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bleu/%rR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__n0___rrR__fR__retR, /* bleu/n0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bleu/n0/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__n0__n0__fR__retR, /* bleu/n0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bleu/n0/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__n0__n1__fR__retR, /* bleu/n0/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bleu/n0/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__n0__nR__fR__retR, /* bleu/n0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bleu/n0/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__n1___rrR__fR__retR, /* bleu/n1/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bleu/n1/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__n1__n0__fR__retR, /* bleu/n1/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bleu/n1/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__n1__n1__fR__retR, /* bleu/n1/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bleu/n1/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__n1__nR__fR__retR, /* bleu/n1/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bleu/n1/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__nR___rrR__fR__retR, /* bleu/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bleu/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__nR__n0__fR__retR, /* bleu/nR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bleu/nR/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__nR__n1__fR__retR, /* bleu/nR/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bleu/nR/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__nR__nR__fR__retR, /* bleu/nR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bleu/nR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt___rrR___rrR__fR__retR, /* blt/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-blt/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt___rrR__n0__fR__retR, /* blt/%rR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-blt/%rR/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt___rrR__n1__fR__retR, /* blt/%rR/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-blt/%rR/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt___rrR__nR__fR__retR, /* blt/%rR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-blt/%rR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__n0___rrR__fR__retR, /* blt/n0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-blt/n0/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__n0__n0__fR__retR, /* blt/n0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-blt/n0/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__n0__n1__fR__retR, /* blt/n0/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-blt/n0/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__n0__nR__fR__retR, /* blt/n0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-blt/n0/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__n1___rrR__fR__retR, /* blt/n1/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-blt/n1/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__n1__n0__fR__retR, /* blt/n1/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-blt/n1/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__n1__n1__fR__retR, /* blt/n1/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-blt/n1/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__n1__nR__fR__retR, /* blt/n1/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-blt/n1/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__nR___rrR__fR__retR, /* blt/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-blt/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__nR__n0__fR__retR, /* blt/nR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-blt/nR/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__nR__n1__fR__retR, /* blt/nR/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-blt/nR/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__nR__nR__fR__retR, /* blt/nR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-blt/nR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu___rrR___rrR__fR__retR, /* bltu/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bltu/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu___rrR__n0__fR__retR, /* bltu/%rR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bltu/%rR/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu___rrR__n1__fR__retR, /* bltu/%rR/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bltu/%rR/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu___rrR__nR__fR__retR, /* bltu/%rR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bltu/%rR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__n0___rrR__fR__retR, /* bltu/n0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bltu/n0/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__n0__n0__fR__retR, /* bltu/n0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bltu/n0/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__n0__n1__fR__retR, /* bltu/n0/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bltu/n0/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__n0__nR__fR__retR, /* bltu/n0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bltu/n0/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__n1___rrR__fR__retR, /* bltu/n1/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bltu/n1/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__n1__n0__fR__retR, /* bltu/n1/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bltu/n1/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__n1__n1__fR__retR, /* bltu/n1/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bltu/n1/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__n1__nR__fR__retR, /* bltu/n1/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bltu/n1/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__nR___rrR__fR__retR, /* bltu/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bltu/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__nR__n0__fR__retR, /* bltu/nR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bltu/nR/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__nR__n1__fR__retR, /* bltu/nR/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bltu/nR/n1/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__nR__nR__fR__retR, /* bltu/nR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bltu/nR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbne___rrR___rrR__fR__retR, /* bne/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbne___rrR__n0__fR__retR, /* bne/%rR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/%rR/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbne___rrR__nR__fR__retR, /* bne/%rR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/%rR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbne__n0___rrR__fR__retR, /* bne/n0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/n0/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbne__n0__n0__fR__retR, /* bne/n0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/n0/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbne__n0__nR__fR__retR, /* bne/n0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/n0/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbne__nR___rrR__fR__retR, /* bne/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbne__nR__n0__fR__retR, /* bne/nR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/nR/n0/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbne__nR__nR__fR__retR, /* bne/nR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/nR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbneg___rrR__fR__retR, /* bneg/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bneg/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbneg__nR__fR__retR, /* bneg/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bneg/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnneg___rrR__fR__retR, /* bnneg/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bnneg/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnneg__nR__fR__retR, /* bnneg/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bnneg/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnotand___rrR___rrR__fR__retR, /* bnotand/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bnotand/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnotand___rrR__n3__fR__retR, /* bnotand/%rR/n3/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bnotand/%rR/n3/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnotand___rrR__n7__fR__retR, /* bnotand/%rR/n7/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bnotand/%rR/n7/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnotand___rrR__nR__fR__retR, /* bnotand/%rR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bnotand/%rR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnotand__nR___rrR__fR__retR, /* bnotand/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bnotand/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnotand__nR__n3__fR__retR, /* bnotand/nR/n3/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bnotand/nR/n3/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnotand__nR__n7__fR__retR, /* bnotand/nR/n7/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bnotand/nR/n7/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnotand__nR__nR__fR__retR, /* bnotand/nR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bnotand/nR/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnpos___rrR__fR__retR, /* bnpos/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bnpos/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnpos__nR__fR__retR, /* bnpos/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bnpos/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnz___rrR__fR__retR, /* bnz/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bnz/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnz__nR__fR__retR, /* bnz/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bnz/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbpos___rrR__fR__retR, /* bpos/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bpos/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbpos__nR__fR__retR, /* bpos/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bpos/nR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbr___rrR__retR, /* br/%rR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-br/%rR/retR. */
    uninspired_specialized_instruction_opcode_bulge__n0, /* bulge/n0 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_bulge__n1, /* bulge/n1 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_bulge__n2, /* bulge/n2 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_bulge__n3, /* bulge/n3 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_bulge__nR, /* bulge/nR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_bulgeforth, /* bulgeforth is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbz___rrR__fR__retR, /* bz/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bz/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbz__nR__fR__retR, /* bz/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bz/nR/fR/retR. */
    uninspired_specialized_instruction_opcode_clear_mpending__retR, /* clear-pending/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_div___rrR___rrR___rrR__retR, /* div/%rR/%rR/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_div___rrR__n2___rrR__retR, /* div/%rR/n2/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_div___rrR__nR___rrR__retR, /* div/%rR/nR/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_div__nR___rrR___rrR__retR, /* div/nR/%rR/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_div__nR__n2___rrR__retR, /* div/nR/n2/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_div__nR__nR___rrR__retR, /* div/nR/nR/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mdivo___rrR___rrR___rrR__fR__retR, /* divo/%rR/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-divo/%rR/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mdivo___rrR__n2___rrR__fR__retR, /* divo/%rR/n2/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-divo/%rR/n2/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mdivo___rrR__nR___rrR__fR__retR, /* divo/%rR/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-divo/%rR/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mdivo__nR___rrR___rrR__fR__retR, /* divo/nR/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-divo/nR/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mdivo__nR__n2___rrR__fR__retR, /* divo/nR/n2/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-divo/nR/n2/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mdivo__nR__nR___rrR__fR__retR, /* divo/nR/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-divo/nR/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode_drop_mhandler, /* drop-handler is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mendvm__retR, /* endvm is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-endvm/retR. */
    uninspired_specialized_instruction_opcode_exit___rrR__retR, /* exit/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_exit__nR__retR, /* exit/nR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mexitvm__retR, /* exitvm is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-exitvm/retR. */
    uninspired_specialized_instruction_opcode_fadd___rfR___rfR___rfR, /* fadd/%fR/%fR/%fR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_fdiv___rfR___rfR___rfR, /* fdiv/%fR/%fR/%fR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_fincr___rfR, /* fincr/%fR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_fmul___rfR___rfR___rfR, /* fmul/%fR/%fR/%fR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_fprint___rfR, /* fprint/%fR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_fset___rrR___rfR, /* fset/%rR/%fR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_fset__nR___rfR, /* fset/nR/%fR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_fsub___rfR___rfR___rfR, /* fsub/%fR/%fR/%fR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_hcf__retR, /* hcf/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_install_msignal_mhandler__retR, /* install-signal-handler/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_loadwithbyteoffset___rrR___rrR___rrR, /* loadwithbyteoffset/%rR/%rR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_loadwithbyteoffset___rrR__n0___rrR, /* loadwithbyteoffset/%rR/n0/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_loadwithbyteoffset___rrR__n8___rrR, /* loadwithbyteoffset/%rR/n8/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_loadwithbyteoffset___rrR__nR___rrR, /* loadwithbyteoffset/%rR/nR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_loadwithwordoffset___rrR___rrR___rrR, /* loadwithwordoffset/%rR/%rR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_loadwithwordoffset___rrR__n0___rrR, /* loadwithwordoffset/%rR/n0/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_loadwithwordoffset___rrR__n1___rrR, /* loadwithwordoffset/%rR/n1/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_loadwithwordoffset___rrR__n2___rrR, /* loadwithwordoffset/%rR/n2/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_loadwithwordoffset___rrR__nR___rrR, /* loadwithwordoffset/%rR/nR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mallocwords___rrR___rrR__retR, /* mallocwords/%rR/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mallocwords__nR___rrR__retR, /* mallocwords/nR/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mod___rrR___rrR___rrR__retR, /* mod/%rR/%rR/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mod___rrR__n2___rrR__retR, /* mod/%rR/n2/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mod___rrR__nR___rrR__retR, /* mod/%rR/nR/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mod__nR___rrR___rrR__retR, /* mod/nR/%rR/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mod__nR__n2___rrR__retR, /* mod/nR/n2/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mod__nR__nR___rrR__retR, /* mod/nR/nR/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmodo___rrR___rrR___rrR__fR__retR, /* modo/%rR/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-modo/%rR/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmodo___rrR__n2___rrR__fR__retR, /* modo/%rR/n2/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-modo/%rR/n2/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmodo___rrR__nR___rrR__fR__retR, /* modo/%rR/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-modo/%rR/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmodo__nR___rrR___rrR__fR__retR, /* modo/nR/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-modo/nR/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmodo__nR__n2___rrR__fR__retR, /* modo/nR/n2/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-modo/nR/n2/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmodo__nR__nR___rrR__fR__retR, /* modo/nR/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-modo/nR/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode_mov___rrR___rrR, /* mov/%rR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mov__n0___rrR, /* mov/n0/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mov__n1___rrR, /* mov/n1/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mov__nR___rrR, /* mov/nR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mov__lR___rrR, /* mov/lR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n0, /* mroll/n0 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n1, /* mroll/n1 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n2, /* mroll/n2 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n3, /* mroll/n3 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n4, /* mroll/n4 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n5, /* mroll/n5 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n6, /* mroll/n6 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n7, /* mroll/n7 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n8, /* mroll/n8 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n9, /* mroll/n9 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n10, /* mroll/n10 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n11, /* mroll/n11 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n12, /* mroll/n12 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n13, /* mroll/n13 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n14, /* mroll/n14 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n15, /* mroll/n15 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n16, /* mroll/n16 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n17, /* mroll/n17 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n18, /* mroll/n18 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n19, /* mroll/n19 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n20, /* mroll/n20 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n21, /* mroll/n21 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n22, /* mroll/n22 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n23, /* mroll/n23 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n24, /* mroll/n24 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n25, /* mroll/n25 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n26, /* mroll/n26 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n27, /* mroll/n27 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n28, /* mroll/n28 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n29, /* mroll/n29 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n30, /* mroll/n30 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n31, /* mroll/n31 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n32, /* mroll/n32 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n33, /* mroll/n33 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n34, /* mroll/n34 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n35, /* mroll/n35 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n36, /* mroll/n36 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n37, /* mroll/n37 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n38, /* mroll/n38 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n39, /* mroll/n39 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n40, /* mroll/n40 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n41, /* mroll/n41 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n42, /* mroll/n42 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n43, /* mroll/n43 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n44, /* mroll/n44 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n45, /* mroll/n45 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n46, /* mroll/n46 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n47, /* mroll/n47 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n48, /* mroll/n48 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n49, /* mroll/n49 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n50, /* mroll/n50 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n51, /* mroll/n51 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n52, /* mroll/n52 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n53, /* mroll/n53 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n54, /* mroll/n54 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n55, /* mroll/n55 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n56, /* mroll/n56 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n57, /* mroll/n57 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n58, /* mroll/n58 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n59, /* mroll/n59 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n60, /* mroll/n60 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n61, /* mroll/n61 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n62, /* mroll/n62 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n63, /* mroll/n63 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n64, /* mroll/n64 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n65, /* mroll/n65 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n66, /* mroll/n66 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n67, /* mroll/n67 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n68, /* mroll/n68 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n69, /* mroll/n69 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__n70, /* mroll/n70 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mroll__nR, /* mroll/nR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mrollforth, /* mrollforth is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mrot, /* mrot is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mul___rrR___rrR___rrR, /* mul/%rR/%rR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mul___rrR__n2___rrR, /* mul/%rR/n2/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mul___rrR__nR___rrR, /* mul/%rR/nR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mul__n2___rrR___rrR, /* mul/n2/%rR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mul__n2__n2___rrR, /* mul/n2/n2/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mul__n2__nR___rrR, /* mul/n2/nR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mul__nR___rrR___rrR, /* mul/nR/%rR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mul__nR__n2___rrR, /* mul/nR/n2/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_mul__nR__nR___rrR, /* mul/nR/nR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmulo___rrR___rrR___rrR__fR__retR, /* mulo/%rR/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-mulo/%rR/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmulo___rrR__n2___rrR__fR__retR, /* mulo/%rR/n2/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-mulo/%rR/n2/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmulo___rrR__nR___rrR__fR__retR, /* mulo/%rR/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-mulo/%rR/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmulo__nR___rrR___rrR__fR__retR, /* mulo/nR/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-mulo/nR/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmulo__nR__n2___rrR__fR__retR, /* mulo/nR/n2/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-mulo/nR/n2/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmulo__nR__nR___rrR__fR__retR, /* mulo/nR/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-mulo/nR/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode_nop, /* nop is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_print_mpending_msignals__retR, /* print-pending-signals/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_print_mtopmost__nR__retR, /* print-topmost/nR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_printfixnum___rrR__retR, /* printfixnum/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_printfixnum__nR__retR, /* printfixnum/nR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_printufixnum___rrR__retR, /* printufixnum/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_printufixnum__nR__retR, /* printufixnum/nR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mprocedurecall__fR__retR, /* procedurecall/fR/retR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-procedurecall/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mprocedurecallr___rrR__retR, /* procedurecallr/%rR/retR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-procedurecallr/%rR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mprocedurecallr__lR__retR, /* procedurecallr/lR/retR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-procedurecallr/lR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mprocedureprolog__retR, /* procedureprolog is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-procedureprolog/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mprocedurereturn__retR, /* procedurereturn is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-procedurereturn/retR. */
    uninspired_specialized_instruction_opcode_push_mdepths__nR__retR, /* push-depths/nR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_push_mhandler__n0__lR, /* push-handler/n0/lR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_push_mhandler__n1__lR, /* push-handler/n1/lR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_push_mhandler__n2__lR, /* push-handler/n2/lR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_push_mhandler__n3__lR, /* push-handler/n3/lR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_push_mhandler__n4__lR, /* push-handler/n4/lR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_push_mhandler__n5__lR, /* push-handler/n5/lR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_push_mhandler__n6__lR, /* push-handler/n6/lR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_push_mhandler__n7__lR, /* push-handler/n7/lR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_push_mhandler__n8__lR, /* push-handler/n8/lR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_push_mhandler__n9__lR, /* push-handler/n9/lR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_push_mhandler__n10__lR, /* push-handler/n10/lR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_push_mhandler__nR__lR, /* push-handler/nR/lR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_push_mincreasing__nR__retR, /* push-increasing/nR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_quake, /* quake is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise___rrR__retR, /* raise/%rR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-raise/%rR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n0__retR, /* raise/n0 is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-raise/n0/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n1__retR, /* raise/n1 is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-raise/n1/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n2__retR, /* raise/n2 is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-raise/n2/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n3__retR, /* raise/n3 is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-raise/n3/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n4__retR, /* raise/n4 is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-raise/n4/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n5__retR, /* raise/n5 is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-raise/n5/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n6__retR, /* raise/n6 is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-raise/n6/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n7__retR, /* raise/n7 is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-raise/n7/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n8__retR, /* raise/n8 is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-raise/n8/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n9__retR, /* raise/n9 is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-raise/n9/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n10__retR, /* raise/n10 is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-raise/n10/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__nR__retR, /* raise/nR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-raise/nR/retR. */
    uninspired_specialized_instruction_opcode_random___rrR__retR, /* random/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n0, /* reverse/n0 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n1, /* reverse/n1 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n2, /* reverse/n2 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n3, /* reverse/n3 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n4, /* reverse/n4 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n5, /* reverse/n5 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n6, /* reverse/n6 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n7, /* reverse/n7 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n8, /* reverse/n8 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n9, /* reverse/n9 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n10, /* reverse/n10 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n11, /* reverse/n11 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n12, /* reverse/n12 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n13, /* reverse/n13 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n14, /* reverse/n14 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n15, /* reverse/n15 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n16, /* reverse/n16 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n17, /* reverse/n17 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n18, /* reverse/n18 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n19, /* reverse/n19 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n20, /* reverse/n20 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n21, /* reverse/n21 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n22, /* reverse/n22 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n23, /* reverse/n23 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n24, /* reverse/n24 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n25, /* reverse/n25 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n26, /* reverse/n26 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n27, /* reverse/n27 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n28, /* reverse/n28 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n29, /* reverse/n29 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n30, /* reverse/n30 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n31, /* reverse/n31 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n32, /* reverse/n32 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n33, /* reverse/n33 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n34, /* reverse/n34 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n35, /* reverse/n35 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n36, /* reverse/n36 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n37, /* reverse/n37 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n38, /* reverse/n38 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n39, /* reverse/n39 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n40, /* reverse/n40 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n41, /* reverse/n41 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n42, /* reverse/n42 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n43, /* reverse/n43 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n44, /* reverse/n44 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n45, /* reverse/n45 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n46, /* reverse/n46 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n47, /* reverse/n47 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n48, /* reverse/n48 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n49, /* reverse/n49 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n50, /* reverse/n50 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n51, /* reverse/n51 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n52, /* reverse/n52 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n53, /* reverse/n53 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n54, /* reverse/n54 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n55, /* reverse/n55 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n56, /* reverse/n56 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n57, /* reverse/n57 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n58, /* reverse/n58 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n59, /* reverse/n59 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n60, /* reverse/n60 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n61, /* reverse/n61 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n62, /* reverse/n62 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n63, /* reverse/n63 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n64, /* reverse/n64 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n65, /* reverse/n65 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n66, /* reverse/n66 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n67, /* reverse/n67 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n68, /* reverse/n68 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n69, /* reverse/n69 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__n70, /* reverse/n70 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_reverse__nR, /* reverse/nR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n0, /* roll/n0 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n1, /* roll/n1 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n2, /* roll/n2 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n3, /* roll/n3 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n4, /* roll/n4 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n5, /* roll/n5 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n6, /* roll/n6 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n7, /* roll/n7 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n8, /* roll/n8 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n9, /* roll/n9 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n10, /* roll/n10 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n11, /* roll/n11 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n12, /* roll/n12 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n13, /* roll/n13 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n14, /* roll/n14 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n15, /* roll/n15 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n16, /* roll/n16 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n17, /* roll/n17 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n18, /* roll/n18 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n19, /* roll/n19 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n20, /* roll/n20 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n21, /* roll/n21 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n22, /* roll/n22 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n23, /* roll/n23 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n24, /* roll/n24 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n25, /* roll/n25 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n26, /* roll/n26 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n27, /* roll/n27 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n28, /* roll/n28 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n29, /* roll/n29 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n30, /* roll/n30 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n31, /* roll/n31 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n32, /* roll/n32 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n33, /* roll/n33 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n34, /* roll/n34 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n35, /* roll/n35 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n36, /* roll/n36 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n37, /* roll/n37 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n38, /* roll/n38 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n39, /* roll/n39 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n40, /* roll/n40 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n41, /* roll/n41 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n42, /* roll/n42 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n43, /* roll/n43 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n44, /* roll/n44 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n45, /* roll/n45 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n46, /* roll/n46 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n47, /* roll/n47 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n48, /* roll/n48 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n49, /* roll/n49 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n50, /* roll/n50 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n51, /* roll/n51 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n52, /* roll/n52 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n53, /* roll/n53 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n54, /* roll/n54 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n55, /* roll/n55 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n56, /* roll/n56 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n57, /* roll/n57 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n58, /* roll/n58 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n59, /* roll/n59 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n60, /* roll/n60 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n61, /* roll/n61 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n62, /* roll/n62 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n63, /* roll/n63 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n64, /* roll/n64 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n65, /* roll/n65 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n66, /* roll/n66 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n67, /* roll/n67 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n68, /* roll/n68 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n69, /* roll/n69 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__n70, /* roll/n70 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_roll__nR, /* roll/nR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_rollforth, /* rollforth is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_rot, /* rot is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_msafe_mpoint__fR__retR, /* safe-point/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-safe-point/fR/retR. */
    uninspired_specialized_instruction_opcode_set_mpending, /* set-pending is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__n1__n1, /* slide/n1/n1 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__n1__n2, /* slide/n1/n2 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__n1__n3, /* slide/n1/n3 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__n1__n4, /* slide/n1/n4 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__n1__n5, /* slide/n1/n5 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__n1__nR, /* slide/n1/nR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__n2__n1, /* slide/n2/n1 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__n2__n2, /* slide/n2/n2 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__n2__n3, /* slide/n2/n3 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__n2__n4, /* slide/n2/n4 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__n2__n5, /* slide/n2/n5 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__n2__nR, /* slide/n2/nR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__n3__n1, /* slide/n3/n1 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__n3__n2, /* slide/n3/n2 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__n3__n3, /* slide/n3/n3 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__n3__n4, /* slide/n3/n4 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__n3__n5, /* slide/n3/n5 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__n3__nR, /* slide/n3/nR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__nR__n1, /* slide/nR/n1 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__nR__n2, /* slide/nR/n2 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__nR__n3, /* slide/nR/n3 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__nR__n4, /* slide/nR/n4 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__nR__n5, /* slide/nR/n5 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slide__nR__nR, /* slide/nR/nR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_slideforth, /* slideforth is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackdrop, /* stackdrop is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackdup, /* stackdup is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mstackif__fR__retR, /* stackif/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-stackif/fR/retR. */
    uninspired_specialized_instruction_opcode_stacknip, /* stacknip is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mstacknondroppingif__fR__retR, /* stacknondroppingif/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-stacknondroppingif/fR/retR. */
    uninspired_specialized_instruction_opcode_stacknot, /* stacknot is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackoneminus, /* stackoneminus is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackoneplus, /* stackoneplus is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackover, /* stackover is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackpeek___rrR, /* stackpeek/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackplus, /* stackplus is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackplusr___rrR, /* stackplusr/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackpop___rrR, /* stackpop/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackprint__retR, /* stackprint/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackpush___rrR, /* stackpush/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackpush__n0, /* stackpush/n0 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackpush__n1, /* stackpush/n1 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackpush__nR, /* stackpush/nR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackpush__lR, /* stackpush/lR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackpushunspecified, /* stackpushunspecified is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackset___rrR, /* stackset/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackset__n0, /* stackset/n0 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackset__n1, /* stackset/n1 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackset__nR, /* stackset/nR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackset__lR, /* stackset/lR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackswap, /* stackswap is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stackswaptop___rrR, /* stackswaptop/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_stacktimes, /* stacktimes is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_storewithbyteoffset___rrR___rrR___rrR, /* storewithbyteoffset/%rR/%rR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_storewithbyteoffset___rrR___rrR__n0, /* storewithbyteoffset/%rR/%rR/n0 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_storewithbyteoffset___rrR___rrR__n8, /* storewithbyteoffset/%rR/%rR/n8 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_storewithbyteoffset___rrR___rrR__nR, /* storewithbyteoffset/%rR/%rR/nR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_storewithbyteoffset__nR___rrR___rrR, /* storewithbyteoffset/nR/%rR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_storewithbyteoffset__nR___rrR__n0, /* storewithbyteoffset/nR/%rR/n0 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_storewithbyteoffset__nR___rrR__n8, /* storewithbyteoffset/nR/%rR/n8 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_storewithbyteoffset__nR___rrR__nR, /* storewithbyteoffset/nR/%rR/nR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_storewithwordoffset___rrR___rrR___rrR, /* storewithwordoffset/%rR/%rR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_storewithwordoffset___rrR___rrR__n0, /* storewithwordoffset/%rR/%rR/n0 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_storewithwordoffset___rrR___rrR__n1, /* storewithwordoffset/%rR/%rR/n1 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_storewithwordoffset___rrR___rrR__n2, /* storewithwordoffset/%rR/%rR/n2 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_storewithwordoffset___rrR___rrR__nR, /* storewithwordoffset/%rR/%rR/nR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_storewithwordoffset__nR___rrR___rrR, /* storewithwordoffset/nR/%rR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_storewithwordoffset__nR___rrR__n0, /* storewithwordoffset/nR/%rR/n0 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_storewithwordoffset__nR___rrR__n1, /* storewithwordoffset/nR/%rR/n1 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_storewithwordoffset__nR___rrR__n2, /* storewithwordoffset/nR/%rR/n2 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_storewithwordoffset__nR___rrR__nR, /* storewithwordoffset/nR/%rR/nR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_sub___rrR___rrR___rrR, /* sub/%rR/%rR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_sub___rrR__n1___rrR, /* sub/%rR/n1/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_sub___rrR__nR___rrR, /* sub/%rR/nR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_sub__n0___rrR___rrR, /* sub/n0/%rR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_sub__n0__n1___rrR, /* sub/n0/n1/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_sub__n0__nR___rrR, /* sub/n0/nR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_sub__nR___rrR___rrR, /* sub/nR/%rR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_sub__nR__n1___rrR, /* sub/nR/n1/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_sub__nR__nR___rrR, /* sub/nR/nR/%rR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_msubo___rrR___rrR___rrR__fR__retR, /* subo/%rR/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-subo/%rR/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_msubo___rrR__n1___rrR__fR__retR, /* subo/%rR/n1/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-subo/%rR/n1/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_msubo___rrR__nR___rrR__fR__retR, /* subo/%rR/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-subo/%rR/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_msubo__nR___rrR___rrR__fR__retR, /* subo/nR/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-subo/nR/%rR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_msubo__nR__n1___rrR__fR__retR, /* subo/nR/n1/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-subo/nR/n1/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_msubo__nR__nR___rrR__fR__retR, /* subo/nR/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-subo/nR/nR/%rR/fR/retR. */
    uninspired_specialized_instruction_opcode_tuck, /* tuck is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_munreachable__retR, /* unreachable is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-unreachable/retR. */
    uninspired_specialized_instruction_opcode_whirl__n0, /* whirl/n0 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_whirl__n1, /* whirl/n1 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_whirl__n2, /* whirl/n2 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_whirl__n3, /* whirl/n3 is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_whirl__nR, /* whirl/nR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode_whirlforth, /* whirlforth is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_maddo___rrR___rrR___rrR__fR__retR, /* !REPLACEMENT-addo/%rR/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_maddo___rrR__n1___rrR__fR__retR, /* !REPLACEMENT-addo/%rR/n1/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_maddo___rrR__n_m1___rrR__fR__retR, /* !REPLACEMENT-addo/%rR/n-1/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_maddo___rrR__nR___rrR__fR__retR, /* !REPLACEMENT-addo/%rR/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_maddo__nR___rrR___rrR__fR__retR, /* !REPLACEMENT-addo/nR/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_maddo__nR__n1___rrR__fR__retR, /* !REPLACEMENT-addo/nR/n1/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_maddo__nR__n_m1___rrR__fR__retR, /* !REPLACEMENT-addo/nR/n-1/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_maddo__nR__nR___rrR__fR__retR, /* !REPLACEMENT-addo/nR/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mb__fR__retR, /* !REPLACEMENT-b/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mband___rrR___rrR__fR__retR, /* !REPLACEMENT-band/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mband___rrR__n3__fR__retR, /* !REPLACEMENT-band/%rR/n3/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mband___rrR__n7__fR__retR, /* !REPLACEMENT-band/%rR/n7/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mband___rrR__nR__fR__retR, /* !REPLACEMENT-band/%rR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mband__nR___rrR__fR__retR, /* !REPLACEMENT-band/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mband__nR__n3__fR__retR, /* !REPLACEMENT-band/nR/n3/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mband__nR__n7__fR__retR, /* !REPLACEMENT-band/nR/n7/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mband__nR__nR__fR__retR, /* !REPLACEMENT-band/nR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbeq___rrR___rrR__fR__retR, /* !REPLACEMENT-beq/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbeq___rrR__nR__fR__retR, /* !REPLACEMENT-beq/%rR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbeq__nR___rrR__fR__retR, /* !REPLACEMENT-beq/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbeq__nR__nR__fR__retR, /* !REPLACEMENT-beq/nR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge___rrR___rrR__fR__retR, /* !REPLACEMENT-bge/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge___rrR__n0__fR__retR, /* !REPLACEMENT-bge/%rR/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge___rrR__n1__fR__retR, /* !REPLACEMENT-bge/%rR/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge___rrR__nR__fR__retR, /* !REPLACEMENT-bge/%rR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__n0___rrR__fR__retR, /* !REPLACEMENT-bge/n0/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__n0__n0__fR__retR, /* !REPLACEMENT-bge/n0/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__n0__n1__fR__retR, /* !REPLACEMENT-bge/n0/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__n0__nR__fR__retR, /* !REPLACEMENT-bge/n0/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__n1___rrR__fR__retR, /* !REPLACEMENT-bge/n1/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__n1__n0__fR__retR, /* !REPLACEMENT-bge/n1/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__n1__n1__fR__retR, /* !REPLACEMENT-bge/n1/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__n1__nR__fR__retR, /* !REPLACEMENT-bge/n1/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__nR___rrR__fR__retR, /* !REPLACEMENT-bge/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__nR__n0__fR__retR, /* !REPLACEMENT-bge/nR/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__nR__n1__fR__retR, /* !REPLACEMENT-bge/nR/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbge__nR__nR__fR__retR, /* !REPLACEMENT-bge/nR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu___rrR___rrR__fR__retR, /* !REPLACEMENT-bgeu/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu___rrR__n0__fR__retR, /* !REPLACEMENT-bgeu/%rR/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu___rrR__n1__fR__retR, /* !REPLACEMENT-bgeu/%rR/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu___rrR__nR__fR__retR, /* !REPLACEMENT-bgeu/%rR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__n0___rrR__fR__retR, /* !REPLACEMENT-bgeu/n0/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__n0__n0__fR__retR, /* !REPLACEMENT-bgeu/n0/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__n0__n1__fR__retR, /* !REPLACEMENT-bgeu/n0/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__n0__nR__fR__retR, /* !REPLACEMENT-bgeu/n0/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__n1___rrR__fR__retR, /* !REPLACEMENT-bgeu/n1/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__n1__n0__fR__retR, /* !REPLACEMENT-bgeu/n1/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__n1__n1__fR__retR, /* !REPLACEMENT-bgeu/n1/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__n1__nR__fR__retR, /* !REPLACEMENT-bgeu/n1/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__nR___rrR__fR__retR, /* !REPLACEMENT-bgeu/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__nR__n0__fR__retR, /* !REPLACEMENT-bgeu/nR/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__nR__n1__fR__retR, /* !REPLACEMENT-bgeu/nR/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgeu__nR__nR__fR__retR, /* !REPLACEMENT-bgeu/nR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt___rrR___rrR__fR__retR, /* !REPLACEMENT-bgt/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt___rrR__n0__fR__retR, /* !REPLACEMENT-bgt/%rR/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt___rrR__n1__fR__retR, /* !REPLACEMENT-bgt/%rR/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt___rrR__nR__fR__retR, /* !REPLACEMENT-bgt/%rR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__n0___rrR__fR__retR, /* !REPLACEMENT-bgt/n0/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__n0__n0__fR__retR, /* !REPLACEMENT-bgt/n0/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__n0__n1__fR__retR, /* !REPLACEMENT-bgt/n0/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__n0__nR__fR__retR, /* !REPLACEMENT-bgt/n0/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__n1___rrR__fR__retR, /* !REPLACEMENT-bgt/n1/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__n1__n0__fR__retR, /* !REPLACEMENT-bgt/n1/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__n1__n1__fR__retR, /* !REPLACEMENT-bgt/n1/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__n1__nR__fR__retR, /* !REPLACEMENT-bgt/n1/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__nR___rrR__fR__retR, /* !REPLACEMENT-bgt/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__nR__n0__fR__retR, /* !REPLACEMENT-bgt/nR/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__nR__n1__fR__retR, /* !REPLACEMENT-bgt/nR/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgt__nR__nR__fR__retR, /* !REPLACEMENT-bgt/nR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu___rrR___rrR__fR__retR, /* !REPLACEMENT-bgtu/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu___rrR__n0__fR__retR, /* !REPLACEMENT-bgtu/%rR/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu___rrR__n1__fR__retR, /* !REPLACEMENT-bgtu/%rR/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu___rrR__nR__fR__retR, /* !REPLACEMENT-bgtu/%rR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__n0___rrR__fR__retR, /* !REPLACEMENT-bgtu/n0/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__n0__n0__fR__retR, /* !REPLACEMENT-bgtu/n0/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__n0__n1__fR__retR, /* !REPLACEMENT-bgtu/n0/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__n0__nR__fR__retR, /* !REPLACEMENT-bgtu/n0/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__n1___rrR__fR__retR, /* !REPLACEMENT-bgtu/n1/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__n1__n0__fR__retR, /* !REPLACEMENT-bgtu/n1/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__n1__n1__fR__retR, /* !REPLACEMENT-bgtu/n1/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__n1__nR__fR__retR, /* !REPLACEMENT-bgtu/n1/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__nR___rrR__fR__retR, /* !REPLACEMENT-bgtu/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__nR__n0__fR__retR, /* !REPLACEMENT-bgtu/nR/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__nR__n1__fR__retR, /* !REPLACEMENT-bgtu/nR/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbgtu__nR__nR__fR__retR, /* !REPLACEMENT-bgtu/nR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble___rrR___rrR__fR__retR, /* !REPLACEMENT-ble/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble___rrR__n0__fR__retR, /* !REPLACEMENT-ble/%rR/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble___rrR__n1__fR__retR, /* !REPLACEMENT-ble/%rR/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble___rrR__nR__fR__retR, /* !REPLACEMENT-ble/%rR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__n0___rrR__fR__retR, /* !REPLACEMENT-ble/n0/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__n0__n0__fR__retR, /* !REPLACEMENT-ble/n0/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__n0__n1__fR__retR, /* !REPLACEMENT-ble/n0/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__n0__nR__fR__retR, /* !REPLACEMENT-ble/n0/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__n1___rrR__fR__retR, /* !REPLACEMENT-ble/n1/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__n1__n0__fR__retR, /* !REPLACEMENT-ble/n1/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__n1__n1__fR__retR, /* !REPLACEMENT-ble/n1/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__n1__nR__fR__retR, /* !REPLACEMENT-ble/n1/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__nR___rrR__fR__retR, /* !REPLACEMENT-ble/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__nR__n0__fR__retR, /* !REPLACEMENT-ble/nR/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__nR__n1__fR__retR, /* !REPLACEMENT-ble/nR/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mble__nR__nR__fR__retR, /* !REPLACEMENT-ble/nR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu___rrR___rrR__fR__retR, /* !REPLACEMENT-bleu/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu___rrR__n0__fR__retR, /* !REPLACEMENT-bleu/%rR/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu___rrR__n1__fR__retR, /* !REPLACEMENT-bleu/%rR/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu___rrR__nR__fR__retR, /* !REPLACEMENT-bleu/%rR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__n0___rrR__fR__retR, /* !REPLACEMENT-bleu/n0/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__n0__n0__fR__retR, /* !REPLACEMENT-bleu/n0/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__n0__n1__fR__retR, /* !REPLACEMENT-bleu/n0/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__n0__nR__fR__retR, /* !REPLACEMENT-bleu/n0/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__n1___rrR__fR__retR, /* !REPLACEMENT-bleu/n1/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__n1__n0__fR__retR, /* !REPLACEMENT-bleu/n1/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__n1__n1__fR__retR, /* !REPLACEMENT-bleu/n1/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__n1__nR__fR__retR, /* !REPLACEMENT-bleu/n1/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__nR___rrR__fR__retR, /* !REPLACEMENT-bleu/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__nR__n0__fR__retR, /* !REPLACEMENT-bleu/nR/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__nR__n1__fR__retR, /* !REPLACEMENT-bleu/nR/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbleu__nR__nR__fR__retR, /* !REPLACEMENT-bleu/nR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt___rrR___rrR__fR__retR, /* !REPLACEMENT-blt/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt___rrR__n0__fR__retR, /* !REPLACEMENT-blt/%rR/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt___rrR__n1__fR__retR, /* !REPLACEMENT-blt/%rR/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt___rrR__nR__fR__retR, /* !REPLACEMENT-blt/%rR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__n0___rrR__fR__retR, /* !REPLACEMENT-blt/n0/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__n0__n0__fR__retR, /* !REPLACEMENT-blt/n0/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__n0__n1__fR__retR, /* !REPLACEMENT-blt/n0/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__n0__nR__fR__retR, /* !REPLACEMENT-blt/n0/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__n1___rrR__fR__retR, /* !REPLACEMENT-blt/n1/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__n1__n0__fR__retR, /* !REPLACEMENT-blt/n1/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__n1__n1__fR__retR, /* !REPLACEMENT-blt/n1/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__n1__nR__fR__retR, /* !REPLACEMENT-blt/n1/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__nR___rrR__fR__retR, /* !REPLACEMENT-blt/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__nR__n0__fR__retR, /* !REPLACEMENT-blt/nR/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__nR__n1__fR__retR, /* !REPLACEMENT-blt/nR/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mblt__nR__nR__fR__retR, /* !REPLACEMENT-blt/nR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu___rrR___rrR__fR__retR, /* !REPLACEMENT-bltu/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu___rrR__n0__fR__retR, /* !REPLACEMENT-bltu/%rR/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu___rrR__n1__fR__retR, /* !REPLACEMENT-bltu/%rR/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu___rrR__nR__fR__retR, /* !REPLACEMENT-bltu/%rR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__n0___rrR__fR__retR, /* !REPLACEMENT-bltu/n0/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__n0__n0__fR__retR, /* !REPLACEMENT-bltu/n0/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__n0__n1__fR__retR, /* !REPLACEMENT-bltu/n0/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__n0__nR__fR__retR, /* !REPLACEMENT-bltu/n0/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__n1___rrR__fR__retR, /* !REPLACEMENT-bltu/n1/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__n1__n0__fR__retR, /* !REPLACEMENT-bltu/n1/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__n1__n1__fR__retR, /* !REPLACEMENT-bltu/n1/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__n1__nR__fR__retR, /* !REPLACEMENT-bltu/n1/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__nR___rrR__fR__retR, /* !REPLACEMENT-bltu/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__nR__n0__fR__retR, /* !REPLACEMENT-bltu/nR/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__nR__n1__fR__retR, /* !REPLACEMENT-bltu/nR/n1/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbltu__nR__nR__fR__retR, /* !REPLACEMENT-bltu/nR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbne___rrR___rrR__fR__retR, /* !REPLACEMENT-bne/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbne___rrR__n0__fR__retR, /* !REPLACEMENT-bne/%rR/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbne___rrR__nR__fR__retR, /* !REPLACEMENT-bne/%rR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbne__n0___rrR__fR__retR, /* !REPLACEMENT-bne/n0/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbne__n0__n0__fR__retR, /* !REPLACEMENT-bne/n0/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbne__n0__nR__fR__retR, /* !REPLACEMENT-bne/n0/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbne__nR___rrR__fR__retR, /* !REPLACEMENT-bne/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbne__nR__n0__fR__retR, /* !REPLACEMENT-bne/nR/n0/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbne__nR__nR__fR__retR, /* !REPLACEMENT-bne/nR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbneg___rrR__fR__retR, /* !REPLACEMENT-bneg/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbneg__nR__fR__retR, /* !REPLACEMENT-bneg/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnneg___rrR__fR__retR, /* !REPLACEMENT-bnneg/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnneg__nR__fR__retR, /* !REPLACEMENT-bnneg/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnotand___rrR___rrR__fR__retR, /* !REPLACEMENT-bnotand/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnotand___rrR__n3__fR__retR, /* !REPLACEMENT-bnotand/%rR/n3/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnotand___rrR__n7__fR__retR, /* !REPLACEMENT-bnotand/%rR/n7/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnotand___rrR__nR__fR__retR, /* !REPLACEMENT-bnotand/%rR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnotand__nR___rrR__fR__retR, /* !REPLACEMENT-bnotand/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnotand__nR__n3__fR__retR, /* !REPLACEMENT-bnotand/nR/n3/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnotand__nR__n7__fR__retR, /* !REPLACEMENT-bnotand/nR/n7/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnotand__nR__nR__fR__retR, /* !REPLACEMENT-bnotand/nR/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnpos___rrR__fR__retR, /* !REPLACEMENT-bnpos/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnpos__nR__fR__retR, /* !REPLACEMENT-bnpos/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnz___rrR__fR__retR, /* !REPLACEMENT-bnz/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbnz__nR__fR__retR, /* !REPLACEMENT-bnz/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbpos___rrR__fR__retR, /* !REPLACEMENT-bpos/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbpos__nR__fR__retR, /* !REPLACEMENT-bpos/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbr___rrR__retR, /* !REPLACEMENT-br/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbz___rrR__fR__retR, /* !REPLACEMENT-bz/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mbz__nR__fR__retR, /* !REPLACEMENT-bz/nR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mdivo___rrR___rrR___rrR__fR__retR, /* !REPLACEMENT-divo/%rR/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mdivo___rrR__n2___rrR__fR__retR, /* !REPLACEMENT-divo/%rR/n2/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mdivo___rrR__nR___rrR__fR__retR, /* !REPLACEMENT-divo/%rR/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mdivo__nR___rrR___rrR__fR__retR, /* !REPLACEMENT-divo/nR/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mdivo__nR__n2___rrR__fR__retR, /* !REPLACEMENT-divo/nR/n2/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mdivo__nR__nR___rrR__fR__retR, /* !REPLACEMENT-divo/nR/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mendvm__retR, /* !REPLACEMENT-endvm/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mexitvm__retR, /* !REPLACEMENT-exitvm/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmodo___rrR___rrR___rrR__fR__retR, /* !REPLACEMENT-modo/%rR/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmodo___rrR__n2___rrR__fR__retR, /* !REPLACEMENT-modo/%rR/n2/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmodo___rrR__nR___rrR__fR__retR, /* !REPLACEMENT-modo/%rR/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmodo__nR___rrR___rrR__fR__retR, /* !REPLACEMENT-modo/nR/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmodo__nR__n2___rrR__fR__retR, /* !REPLACEMENT-modo/nR/n2/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmodo__nR__nR___rrR__fR__retR, /* !REPLACEMENT-modo/nR/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmulo___rrR___rrR___rrR__fR__retR, /* !REPLACEMENT-mulo/%rR/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmulo___rrR__n2___rrR__fR__retR, /* !REPLACEMENT-mulo/%rR/n2/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmulo___rrR__nR___rrR__fR__retR, /* !REPLACEMENT-mulo/%rR/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmulo__nR___rrR___rrR__fR__retR, /* !REPLACEMENT-mulo/nR/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmulo__nR__n2___rrR__fR__retR, /* !REPLACEMENT-mulo/nR/n2/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mmulo__nR__nR___rrR__fR__retR, /* !REPLACEMENT-mulo/nR/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mprocedurecall__fR__retR, /* !REPLACEMENT-procedurecall/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mprocedurecallr___rrR__retR, /* !REPLACEMENT-procedurecallr/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mprocedurecallr__lR__retR, /* !REPLACEMENT-procedurecallr/lR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mprocedureprolog__retR, /* !REPLACEMENT-procedureprolog/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mprocedurereturn__retR, /* !REPLACEMENT-procedurereturn/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise___rrR__retR, /* !REPLACEMENT-raise/%rR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n0__retR, /* !REPLACEMENT-raise/n0/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n1__retR, /* !REPLACEMENT-raise/n1/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n2__retR, /* !REPLACEMENT-raise/n2/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n3__retR, /* !REPLACEMENT-raise/n3/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n4__retR, /* !REPLACEMENT-raise/n4/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n5__retR, /* !REPLACEMENT-raise/n5/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n6__retR, /* !REPLACEMENT-raise/n6/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n7__retR, /* !REPLACEMENT-raise/n7/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n8__retR, /* !REPLACEMENT-raise/n8/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n9__retR, /* !REPLACEMENT-raise/n9/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__n10__retR, /* !REPLACEMENT-raise/n10/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mraise__nR__retR, /* !REPLACEMENT-raise/nR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_msafe_mpoint__fR__retR, /* !REPLACEMENT-safe-point/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mstackif__fR__retR, /* !REPLACEMENT-stackif/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_mstacknondroppingif__fR__retR, /* !REPLACEMENT-stacknondroppingif/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_msubo___rrR___rrR___rrR__fR__retR, /* !REPLACEMENT-subo/%rR/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_msubo___rrR__n1___rrR__fR__retR, /* !REPLACEMENT-subo/%rR/n1/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_msubo___rrR__nR___rrR__fR__retR, /* !REPLACEMENT-subo/%rR/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_msubo__nR___rrR___rrR__fR__retR, /* !REPLACEMENT-subo/nR/%rR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_msubo__nR__n1___rrR__fR__retR, /* !REPLACEMENT-subo/nR/n1/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_msubo__nR__nR___rrR__fR__retR, /* !REPLACEMENT-subo/nR/nR/%rR/fR/retR is NOT potentially defective. */
    uninspired_specialized_instruction_opcode__eREPLACEMENT_munreachable__retR /* !REPLACEMENT-unreachable/retR is NOT potentially defective. */
  };
#endif // #ifdef JITTER_HAVE_DEFECT_REPLACEMENT


#ifdef JITTER_HAVE_DEFECT_REPLACEMENT
const jitter_uint
uninspired_call_related_specialized_instruction_ids []
= {
    uninspired_specialized_instruction_opcode_procedurecall__fR__retR,
    uninspired_specialized_instruction_opcode_procedurecallr___rrR__retR,
    uninspired_specialized_instruction_opcode_procedurecallr__lR__retR,
    uninspired_specialized_instruction_opcode_procedureprolog,
    uninspired_specialized_instruction_opcode_procedurereturn
  };

const jitter_uint
uninspired_call_related_specialized_instruction_id_no
= sizeof (uninspired_call_related_specialized_instruction_ids) / sizeof (jitter_uint);

const bool
uninspired_specialized_instruction_call_relateds []
= {
    0, /* !INVALID */
    0, /* !BEGINBASICBLOCK */
    0, /* !EXITVM */
    0, /* !DATALOCATIONS */
    0, /* !NOP */
    0, /* !UNREACHABLE0 */
    0, /* !UNREACHABLE1 */
    0, /* !PRETENDTOJUMPANYWHERE */
    0, /* add/%rR/%rR/%rR */
    0, /* add/%rR/n1/%rR */
    0, /* add/%rR/n-1/%rR */
    0, /* add/%rR/nR/%rR */
    0, /* add/n1/%rR/%rR */
    0, /* add/n1/n1/%rR */
    0, /* add/n1/n-1/%rR */
    0, /* add/n1/nR/%rR */
    0, /* add/n-1/%rR/%rR */
    0, /* add/n-1/n1/%rR */
    0, /* add/n-1/n-1/%rR */
    0, /* add/n-1/nR/%rR */
    0, /* add/nR/%rR/%rR */
    0, /* add/nR/n1/%rR */
    0, /* add/nR/n-1/%rR */
    0, /* add/nR/nR/%rR */
    0, /* addo/%rR/%rR/%rR/fR */
    0, /* addo/%rR/n1/%rR/fR */
    0, /* addo/%rR/n-1/%rR/fR */
    0, /* addo/%rR/nR/%rR/fR */
    0, /* addo/nR/%rR/%rR/fR */
    0, /* addo/nR/n1/%rR/fR */
    0, /* addo/nR/n-1/%rR/fR */
    0, /* addo/nR/nR/%rR/fR */
    0, /* b/fR */
    0, /* band/%rR/%rR/fR */
    0, /* band/%rR/n3/fR */
    0, /* band/%rR/n7/fR */
    0, /* band/%rR/nR/fR */
    0, /* band/nR/%rR/fR */
    0, /* band/nR/n3/fR */
    0, /* band/nR/n7/fR */
    0, /* band/nR/nR/fR */
    0, /* beq/%rR/%rR/fR */
    0, /* beq/%rR/nR/fR */
    0, /* beq/nR/%rR/fR */
    0, /* beq/nR/nR/fR */
    0, /* bge/%rR/%rR/fR */
    0, /* bge/%rR/n0/fR */
    0, /* bge/%rR/n1/fR */
    0, /* bge/%rR/nR/fR */
    0, /* bge/n0/%rR/fR */
    0, /* bge/n0/n0/fR */
    0, /* bge/n0/n1/fR */
    0, /* bge/n0/nR/fR */
    0, /* bge/n1/%rR/fR */
    0, /* bge/n1/n0/fR */
    0, /* bge/n1/n1/fR */
    0, /* bge/n1/nR/fR */
    0, /* bge/nR/%rR/fR */
    0, /* bge/nR/n0/fR */
    0, /* bge/nR/n1/fR */
    0, /* bge/nR/nR/fR */
    0, /* bgeu/%rR/%rR/fR */
    0, /* bgeu/%rR/n0/fR */
    0, /* bgeu/%rR/n1/fR */
    0, /* bgeu/%rR/nR/fR */
    0, /* bgeu/n0/%rR/fR */
    0, /* bgeu/n0/n0/fR */
    0, /* bgeu/n0/n1/fR */
    0, /* bgeu/n0/nR/fR */
    0, /* bgeu/n1/%rR/fR */
    0, /* bgeu/n1/n0/fR */
    0, /* bgeu/n1/n1/fR */
    0, /* bgeu/n1/nR/fR */
    0, /* bgeu/nR/%rR/fR */
    0, /* bgeu/nR/n0/fR */
    0, /* bgeu/nR/n1/fR */
    0, /* bgeu/nR/nR/fR */
    0, /* bgt/%rR/%rR/fR */
    0, /* bgt/%rR/n0/fR */
    0, /* bgt/%rR/n1/fR */
    0, /* bgt/%rR/nR/fR */
    0, /* bgt/n0/%rR/fR */
    0, /* bgt/n0/n0/fR */
    0, /* bgt/n0/n1/fR */
    0, /* bgt/n0/nR/fR */
    0, /* bgt/n1/%rR/fR */
    0, /* bgt/n1/n0/fR */
    0, /* bgt/n1/n1/fR */
    0, /* bgt/n1/nR/fR */
    0, /* bgt/nR/%rR/fR */
    0, /* bgt/nR/n0/fR */
    0, /* bgt/nR/n1/fR */
    0, /* bgt/nR/nR/fR */
    0, /* bgtu/%rR/%rR/fR */
    0, /* bgtu/%rR/n0/fR */
    0, /* bgtu/%rR/n1/fR */
    0, /* bgtu/%rR/nR/fR */
    0, /* bgtu/n0/%rR/fR */
    0, /* bgtu/n0/n0/fR */
    0, /* bgtu/n0/n1/fR */
    0, /* bgtu/n0/nR/fR */
    0, /* bgtu/n1/%rR/fR */
    0, /* bgtu/n1/n0/fR */
    0, /* bgtu/n1/n1/fR */
    0, /* bgtu/n1/nR/fR */
    0, /* bgtu/nR/%rR/fR */
    0, /* bgtu/nR/n0/fR */
    0, /* bgtu/nR/n1/fR */
    0, /* bgtu/nR/nR/fR */
    0, /* ble/%rR/%rR/fR */
    0, /* ble/%rR/n0/fR */
    0, /* ble/%rR/n1/fR */
    0, /* ble/%rR/nR/fR */
    0, /* ble/n0/%rR/fR */
    0, /* ble/n0/n0/fR */
    0, /* ble/n0/n1/fR */
    0, /* ble/n0/nR/fR */
    0, /* ble/n1/%rR/fR */
    0, /* ble/n1/n0/fR */
    0, /* ble/n1/n1/fR */
    0, /* ble/n1/nR/fR */
    0, /* ble/nR/%rR/fR */
    0, /* ble/nR/n0/fR */
    0, /* ble/nR/n1/fR */
    0, /* ble/nR/nR/fR */
    0, /* bleu/%rR/%rR/fR */
    0, /* bleu/%rR/n0/fR */
    0, /* bleu/%rR/n1/fR */
    0, /* bleu/%rR/nR/fR */
    0, /* bleu/n0/%rR/fR */
    0, /* bleu/n0/n0/fR */
    0, /* bleu/n0/n1/fR */
    0, /* bleu/n0/nR/fR */
    0, /* bleu/n1/%rR/fR */
    0, /* bleu/n1/n0/fR */
    0, /* bleu/n1/n1/fR */
    0, /* bleu/n1/nR/fR */
    0, /* bleu/nR/%rR/fR */
    0, /* bleu/nR/n0/fR */
    0, /* bleu/nR/n1/fR */
    0, /* bleu/nR/nR/fR */
    0, /* blt/%rR/%rR/fR */
    0, /* blt/%rR/n0/fR */
    0, /* blt/%rR/n1/fR */
    0, /* blt/%rR/nR/fR */
    0, /* blt/n0/%rR/fR */
    0, /* blt/n0/n0/fR */
    0, /* blt/n0/n1/fR */
    0, /* blt/n0/nR/fR */
    0, /* blt/n1/%rR/fR */
    0, /* blt/n1/n0/fR */
    0, /* blt/n1/n1/fR */
    0, /* blt/n1/nR/fR */
    0, /* blt/nR/%rR/fR */
    0, /* blt/nR/n0/fR */
    0, /* blt/nR/n1/fR */
    0, /* blt/nR/nR/fR */
    0, /* bltu/%rR/%rR/fR */
    0, /* bltu/%rR/n0/fR */
    0, /* bltu/%rR/n1/fR */
    0, /* bltu/%rR/nR/fR */
    0, /* bltu/n0/%rR/fR */
    0, /* bltu/n0/n0/fR */
    0, /* bltu/n0/n1/fR */
    0, /* bltu/n0/nR/fR */
    0, /* bltu/n1/%rR/fR */
    0, /* bltu/n1/n0/fR */
    0, /* bltu/n1/n1/fR */
    0, /* bltu/n1/nR/fR */
    0, /* bltu/nR/%rR/fR */
    0, /* bltu/nR/n0/fR */
    0, /* bltu/nR/n1/fR */
    0, /* bltu/nR/nR/fR */
    0, /* bne/%rR/%rR/fR */
    0, /* bne/%rR/n0/fR */
    0, /* bne/%rR/nR/fR */
    0, /* bne/n0/%rR/fR */
    0, /* bne/n0/n0/fR */
    0, /* bne/n0/nR/fR */
    0, /* bne/nR/%rR/fR */
    0, /* bne/nR/n0/fR */
    0, /* bne/nR/nR/fR */
    0, /* bneg/%rR/fR */
    0, /* bneg/nR/fR */
    0, /* bnneg/%rR/fR */
    0, /* bnneg/nR/fR */
    0, /* bnotand/%rR/%rR/fR */
    0, /* bnotand/%rR/n3/fR */
    0, /* bnotand/%rR/n7/fR */
    0, /* bnotand/%rR/nR/fR */
    0, /* bnotand/nR/%rR/fR */
    0, /* bnotand/nR/n3/fR */
    0, /* bnotand/nR/n7/fR */
    0, /* bnotand/nR/nR/fR */
    0, /* bnpos/%rR/fR */
    0, /* bnpos/nR/fR */
    0, /* bnz/%rR/fR */
    0, /* bnz/nR/fR */
    0, /* bpos/%rR/fR */
    0, /* bpos/nR/fR */
    0, /* br/%rR */
    0, /* bulge/n0 */
    0, /* bulge/n1 */
    0, /* bulge/n2 */
    0, /* bulge/n3 */
    0, /* bulge/nR */
    0, /* bulgeforth */
    0, /* bz/%rR/fR */
    0, /* bz/nR/fR */
    0, /* clear-pending/retR */
    0, /* div/%rR/%rR/%rR/retR */
    0, /* div/%rR/n2/%rR/retR */
    0, /* div/%rR/nR/%rR/retR */
    0, /* div/nR/%rR/%rR/retR */
    0, /* div/nR/n2/%rR/retR */
    0, /* div/nR/nR/%rR/retR */
    0, /* divo/%rR/%rR/%rR/fR */
    0, /* divo/%rR/n2/%rR/fR */
    0, /* divo/%rR/nR/%rR/fR */
    0, /* divo/nR/%rR/%rR/fR */
    0, /* divo/nR/n2/%rR/fR */
    0, /* divo/nR/nR/%rR/fR */
    0, /* drop-handler */
    0, /* endvm */
    0, /* exit/%rR/retR */
    0, /* exit/nR/retR */
    0, /* exitvm */
    0, /* fadd/%fR/%fR/%fR */
    0, /* fdiv/%fR/%fR/%fR */
    0, /* fincr/%fR */
    0, /* fmul/%fR/%fR/%fR */
    0, /* fprint/%fR */
    0, /* fset/%rR/%fR */
    0, /* fset/nR/%fR */
    0, /* fsub/%fR/%fR/%fR */
    0, /* hcf/retR */
    0, /* install-signal-handler/retR */
    0, /* loadwithbyteoffset/%rR/%rR/%rR */
    0, /* loadwithbyteoffset/%rR/n0/%rR */
    0, /* loadwithbyteoffset/%rR/n8/%rR */
    0, /* loadwithbyteoffset/%rR/nR/%rR */
    0, /* loadwithwordoffset/%rR/%rR/%rR */
    0, /* loadwithwordoffset/%rR/n0/%rR */
    0, /* loadwithwordoffset/%rR/n1/%rR */
    0, /* loadwithwordoffset/%rR/n2/%rR */
    0, /* loadwithwordoffset/%rR/nR/%rR */
    0, /* mallocwords/%rR/%rR/retR */
    0, /* mallocwords/nR/%rR/retR */
    0, /* mod/%rR/%rR/%rR/retR */
    0, /* mod/%rR/n2/%rR/retR */
    0, /* mod/%rR/nR/%rR/retR */
    0, /* mod/nR/%rR/%rR/retR */
    0, /* mod/nR/n2/%rR/retR */
    0, /* mod/nR/nR/%rR/retR */
    0, /* modo/%rR/%rR/%rR/fR */
    0, /* modo/%rR/n2/%rR/fR */
    0, /* modo/%rR/nR/%rR/fR */
    0, /* modo/nR/%rR/%rR/fR */
    0, /* modo/nR/n2/%rR/fR */
    0, /* modo/nR/nR/%rR/fR */
    0, /* mov/%rR/%rR */
    0, /* mov/n0/%rR */
    0, /* mov/n1/%rR */
    0, /* mov/nR/%rR */
    0, /* mov/lR/%rR */
    0, /* mroll/n0 */
    0, /* mroll/n1 */
    0, /* mroll/n2 */
    0, /* mroll/n3 */
    0, /* mroll/n4 */
    0, /* mroll/n5 */
    0, /* mroll/n6 */
    0, /* mroll/n7 */
    0, /* mroll/n8 */
    0, /* mroll/n9 */
    0, /* mroll/n10 */
    0, /* mroll/n11 */
    0, /* mroll/n12 */
    0, /* mroll/n13 */
    0, /* mroll/n14 */
    0, /* mroll/n15 */
    0, /* mroll/n16 */
    0, /* mroll/n17 */
    0, /* mroll/n18 */
    0, /* mroll/n19 */
    0, /* mroll/n20 */
    0, /* mroll/n21 */
    0, /* mroll/n22 */
    0, /* mroll/n23 */
    0, /* mroll/n24 */
    0, /* mroll/n25 */
    0, /* mroll/n26 */
    0, /* mroll/n27 */
    0, /* mroll/n28 */
    0, /* mroll/n29 */
    0, /* mroll/n30 */
    0, /* mroll/n31 */
    0, /* mroll/n32 */
    0, /* mroll/n33 */
    0, /* mroll/n34 */
    0, /* mroll/n35 */
    0, /* mroll/n36 */
    0, /* mroll/n37 */
    0, /* mroll/n38 */
    0, /* mroll/n39 */
    0, /* mroll/n40 */
    0, /* mroll/n41 */
    0, /* mroll/n42 */
    0, /* mroll/n43 */
    0, /* mroll/n44 */
    0, /* mroll/n45 */
    0, /* mroll/n46 */
    0, /* mroll/n47 */
    0, /* mroll/n48 */
    0, /* mroll/n49 */
    0, /* mroll/n50 */
    0, /* mroll/n51 */
    0, /* mroll/n52 */
    0, /* mroll/n53 */
    0, /* mroll/n54 */
    0, /* mroll/n55 */
    0, /* mroll/n56 */
    0, /* mroll/n57 */
    0, /* mroll/n58 */
    0, /* mroll/n59 */
    0, /* mroll/n60 */
    0, /* mroll/n61 */
    0, /* mroll/n62 */
    0, /* mroll/n63 */
    0, /* mroll/n64 */
    0, /* mroll/n65 */
    0, /* mroll/n66 */
    0, /* mroll/n67 */
    0, /* mroll/n68 */
    0, /* mroll/n69 */
    0, /* mroll/n70 */
    0, /* mroll/nR */
    0, /* mrollforth */
    0, /* mrot */
    0, /* mul/%rR/%rR/%rR */
    0, /* mul/%rR/n2/%rR */
    0, /* mul/%rR/nR/%rR */
    0, /* mul/n2/%rR/%rR */
    0, /* mul/n2/n2/%rR */
    0, /* mul/n2/nR/%rR */
    0, /* mul/nR/%rR/%rR */
    0, /* mul/nR/n2/%rR */
    0, /* mul/nR/nR/%rR */
    0, /* mulo/%rR/%rR/%rR/fR */
    0, /* mulo/%rR/n2/%rR/fR */
    0, /* mulo/%rR/nR/%rR/fR */
    0, /* mulo/nR/%rR/%rR/fR */
    0, /* mulo/nR/n2/%rR/fR */
    0, /* mulo/nR/nR/%rR/fR */
    0, /* nop */
    0, /* print-pending-signals/retR */
    0, /* print-topmost/nR/retR */
    0, /* printfixnum/%rR/retR */
    0, /* printfixnum/nR/retR */
    0, /* printufixnum/%rR/retR */
    0, /* printufixnum/nR/retR */
    1, /* procedurecall/fR/retR */
    1, /* procedurecallr/%rR/retR */
    1, /* procedurecallr/lR/retR */
    1, /* procedureprolog */
    1, /* procedurereturn */
    0, /* push-depths/nR/retR */
    0, /* push-handler/n0/lR */
    0, /* push-handler/n1/lR */
    0, /* push-handler/n2/lR */
    0, /* push-handler/n3/lR */
    0, /* push-handler/n4/lR */
    0, /* push-handler/n5/lR */
    0, /* push-handler/n6/lR */
    0, /* push-handler/n7/lR */
    0, /* push-handler/n8/lR */
    0, /* push-handler/n9/lR */
    0, /* push-handler/n10/lR */
    0, /* push-handler/nR/lR */
    0, /* push-increasing/nR/retR */
    0, /* quake */
    0, /* raise/%rR */
    0, /* raise/n0 */
    0, /* raise/n1 */
    0, /* raise/n2 */
    0, /* raise/n3 */
    0, /* raise/n4 */
    0, /* raise/n5 */
    0, /* raise/n6 */
    0, /* raise/n7 */
    0, /* raise/n8 */
    0, /* raise/n9 */
    0, /* raise/n10 */
    0, /* raise/nR */
    0, /* random/%rR/retR */
    0, /* reverse/n0 */
    0, /* reverse/n1 */
    0, /* reverse/n2 */
    0, /* reverse/n3 */
    0, /* reverse/n4 */
    0, /* reverse/n5 */
    0, /* reverse/n6 */
    0, /* reverse/n7 */
    0, /* reverse/n8 */
    0, /* reverse/n9 */
    0, /* reverse/n10 */
    0, /* reverse/n11 */
    0, /* reverse/n12 */
    0, /* reverse/n13 */
    0, /* reverse/n14 */
    0, /* reverse/n15 */
    0, /* reverse/n16 */
    0, /* reverse/n17 */
    0, /* reverse/n18 */
    0, /* reverse/n19 */
    0, /* reverse/n20 */
    0, /* reverse/n21 */
    0, /* reverse/n22 */
    0, /* reverse/n23 */
    0, /* reverse/n24 */
    0, /* reverse/n25 */
    0, /* reverse/n26 */
    0, /* reverse/n27 */
    0, /* reverse/n28 */
    0, /* reverse/n29 */
    0, /* reverse/n30 */
    0, /* reverse/n31 */
    0, /* reverse/n32 */
    0, /* reverse/n33 */
    0, /* reverse/n34 */
    0, /* reverse/n35 */
    0, /* reverse/n36 */
    0, /* reverse/n37 */
    0, /* reverse/n38 */
    0, /* reverse/n39 */
    0, /* reverse/n40 */
    0, /* reverse/n41 */
    0, /* reverse/n42 */
    0, /* reverse/n43 */
    0, /* reverse/n44 */
    0, /* reverse/n45 */
    0, /* reverse/n46 */
    0, /* reverse/n47 */
    0, /* reverse/n48 */
    0, /* reverse/n49 */
    0, /* reverse/n50 */
    0, /* reverse/n51 */
    0, /* reverse/n52 */
    0, /* reverse/n53 */
    0, /* reverse/n54 */
    0, /* reverse/n55 */
    0, /* reverse/n56 */
    0, /* reverse/n57 */
    0, /* reverse/n58 */
    0, /* reverse/n59 */
    0, /* reverse/n60 */
    0, /* reverse/n61 */
    0, /* reverse/n62 */
    0, /* reverse/n63 */
    0, /* reverse/n64 */
    0, /* reverse/n65 */
    0, /* reverse/n66 */
    0, /* reverse/n67 */
    0, /* reverse/n68 */
    0, /* reverse/n69 */
    0, /* reverse/n70 */
    0, /* reverse/nR */
    0, /* roll/n0 */
    0, /* roll/n1 */
    0, /* roll/n2 */
    0, /* roll/n3 */
    0, /* roll/n4 */
    0, /* roll/n5 */
    0, /* roll/n6 */
    0, /* roll/n7 */
    0, /* roll/n8 */
    0, /* roll/n9 */
    0, /* roll/n10 */
    0, /* roll/n11 */
    0, /* roll/n12 */
    0, /* roll/n13 */
    0, /* roll/n14 */
    0, /* roll/n15 */
    0, /* roll/n16 */
    0, /* roll/n17 */
    0, /* roll/n18 */
    0, /* roll/n19 */
    0, /* roll/n20 */
    0, /* roll/n21 */
    0, /* roll/n22 */
    0, /* roll/n23 */
    0, /* roll/n24 */
    0, /* roll/n25 */
    0, /* roll/n26 */
    0, /* roll/n27 */
    0, /* roll/n28 */
    0, /* roll/n29 */
    0, /* roll/n30 */
    0, /* roll/n31 */
    0, /* roll/n32 */
    0, /* roll/n33 */
    0, /* roll/n34 */
    0, /* roll/n35 */
    0, /* roll/n36 */
    0, /* roll/n37 */
    0, /* roll/n38 */
    0, /* roll/n39 */
    0, /* roll/n40 */
    0, /* roll/n41 */
    0, /* roll/n42 */
    0, /* roll/n43 */
    0, /* roll/n44 */
    0, /* roll/n45 */
    0, /* roll/n46 */
    0, /* roll/n47 */
    0, /* roll/n48 */
    0, /* roll/n49 */
    0, /* roll/n50 */
    0, /* roll/n51 */
    0, /* roll/n52 */
    0, /* roll/n53 */
    0, /* roll/n54 */
    0, /* roll/n55 */
    0, /* roll/n56 */
    0, /* roll/n57 */
    0, /* roll/n58 */
    0, /* roll/n59 */
    0, /* roll/n60 */
    0, /* roll/n61 */
    0, /* roll/n62 */
    0, /* roll/n63 */
    0, /* roll/n64 */
    0, /* roll/n65 */
    0, /* roll/n66 */
    0, /* roll/n67 */
    0, /* roll/n68 */
    0, /* roll/n69 */
    0, /* roll/n70 */
    0, /* roll/nR */
    0, /* rollforth */
    0, /* rot */
    0, /* safe-point/fR */
    0, /* set-pending */
    0, /* slide/n1/n1 */
    0, /* slide/n1/n2 */
    0, /* slide/n1/n3 */
    0, /* slide/n1/n4 */
    0, /* slide/n1/n5 */
    0, /* slide/n1/nR */
    0, /* slide/n2/n1 */
    0, /* slide/n2/n2 */
    0, /* slide/n2/n3 */
    0, /* slide/n2/n4 */
    0, /* slide/n2/n5 */
    0, /* slide/n2/nR */
    0, /* slide/n3/n1 */
    0, /* slide/n3/n2 */
    0, /* slide/n3/n3 */
    0, /* slide/n3/n4 */
    0, /* slide/n3/n5 */
    0, /* slide/n3/nR */
    0, /* slide/nR/n1 */
    0, /* slide/nR/n2 */
    0, /* slide/nR/n3 */
    0, /* slide/nR/n4 */
    0, /* slide/nR/n5 */
    0, /* slide/nR/nR */
    0, /* slideforth */
    0, /* stackdrop */
    0, /* stackdup */
    0, /* stackif/fR */
    0, /* stacknip */
    0, /* stacknondroppingif/fR */
    0, /* stacknot */
    0, /* stackoneminus */
    0, /* stackoneplus */
    0, /* stackover */
    0, /* stackpeek/%rR */
    0, /* stackplus */
    0, /* stackplusr/%rR */
    0, /* stackpop/%rR */
    0, /* stackprint/retR */
    0, /* stackpush/%rR */
    0, /* stackpush/n0 */
    0, /* stackpush/n1 */
    0, /* stackpush/nR */
    0, /* stackpush/lR */
    0, /* stackpushunspecified */
    0, /* stackset/%rR */
    0, /* stackset/n0 */
    0, /* stackset/n1 */
    0, /* stackset/nR */
    0, /* stackset/lR */
    0, /* stackswap */
    0, /* stackswaptop/%rR */
    0, /* stacktimes */
    0, /* storewithbyteoffset/%rR/%rR/%rR */
    0, /* storewithbyteoffset/%rR/%rR/n0 */
    0, /* storewithbyteoffset/%rR/%rR/n8 */
    0, /* storewithbyteoffset/%rR/%rR/nR */
    0, /* storewithbyteoffset/nR/%rR/%rR */
    0, /* storewithbyteoffset/nR/%rR/n0 */
    0, /* storewithbyteoffset/nR/%rR/n8 */
    0, /* storewithbyteoffset/nR/%rR/nR */
    0, /* storewithwordoffset/%rR/%rR/%rR */
    0, /* storewithwordoffset/%rR/%rR/n0 */
    0, /* storewithwordoffset/%rR/%rR/n1 */
    0, /* storewithwordoffset/%rR/%rR/n2 */
    0, /* storewithwordoffset/%rR/%rR/nR */
    0, /* storewithwordoffset/nR/%rR/%rR */
    0, /* storewithwordoffset/nR/%rR/n0 */
    0, /* storewithwordoffset/nR/%rR/n1 */
    0, /* storewithwordoffset/nR/%rR/n2 */
    0, /* storewithwordoffset/nR/%rR/nR */
    0, /* sub/%rR/%rR/%rR */
    0, /* sub/%rR/n1/%rR */
    0, /* sub/%rR/nR/%rR */
    0, /* sub/n0/%rR/%rR */
    0, /* sub/n0/n1/%rR */
    0, /* sub/n0/nR/%rR */
    0, /* sub/nR/%rR/%rR */
    0, /* sub/nR/n1/%rR */
    0, /* sub/nR/nR/%rR */
    0, /* subo/%rR/%rR/%rR/fR */
    0, /* subo/%rR/n1/%rR/fR */
    0, /* subo/%rR/nR/%rR/fR */
    0, /* subo/nR/%rR/%rR/fR */
    0, /* subo/nR/n1/%rR/fR */
    0, /* subo/nR/nR/%rR/fR */
    0, /* tuck */
    0, /* unreachable */
    0, /* whirl/n0 */
    0, /* whirl/n1 */
    0, /* whirl/n2 */
    0, /* whirl/n3 */
    0, /* whirl/nR */
    0, /* whirlforth */
    0, /* !REPLACEMENT-addo/%rR/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-addo/%rR/n1/%rR/fR/retR */
    0, /* !REPLACEMENT-addo/%rR/n-1/%rR/fR/retR */
    0, /* !REPLACEMENT-addo/%rR/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-addo/nR/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-addo/nR/n1/%rR/fR/retR */
    0, /* !REPLACEMENT-addo/nR/n-1/%rR/fR/retR */
    0, /* !REPLACEMENT-addo/nR/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-b/fR/retR */
    0, /* !REPLACEMENT-band/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-band/%rR/n3/fR/retR */
    0, /* !REPLACEMENT-band/%rR/n7/fR/retR */
    0, /* !REPLACEMENT-band/%rR/nR/fR/retR */
    0, /* !REPLACEMENT-band/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-band/nR/n3/fR/retR */
    0, /* !REPLACEMENT-band/nR/n7/fR/retR */
    0, /* !REPLACEMENT-band/nR/nR/fR/retR */
    0, /* !REPLACEMENT-beq/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-beq/%rR/nR/fR/retR */
    0, /* !REPLACEMENT-beq/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-beq/nR/nR/fR/retR */
    0, /* !REPLACEMENT-bge/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-bge/%rR/n0/fR/retR */
    0, /* !REPLACEMENT-bge/%rR/n1/fR/retR */
    0, /* !REPLACEMENT-bge/%rR/nR/fR/retR */
    0, /* !REPLACEMENT-bge/n0/%rR/fR/retR */
    0, /* !REPLACEMENT-bge/n0/n0/fR/retR */
    0, /* !REPLACEMENT-bge/n0/n1/fR/retR */
    0, /* !REPLACEMENT-bge/n0/nR/fR/retR */
    0, /* !REPLACEMENT-bge/n1/%rR/fR/retR */
    0, /* !REPLACEMENT-bge/n1/n0/fR/retR */
    0, /* !REPLACEMENT-bge/n1/n1/fR/retR */
    0, /* !REPLACEMENT-bge/n1/nR/fR/retR */
    0, /* !REPLACEMENT-bge/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-bge/nR/n0/fR/retR */
    0, /* !REPLACEMENT-bge/nR/n1/fR/retR */
    0, /* !REPLACEMENT-bge/nR/nR/fR/retR */
    0, /* !REPLACEMENT-bgeu/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-bgeu/%rR/n0/fR/retR */
    0, /* !REPLACEMENT-bgeu/%rR/n1/fR/retR */
    0, /* !REPLACEMENT-bgeu/%rR/nR/fR/retR */
    0, /* !REPLACEMENT-bgeu/n0/%rR/fR/retR */
    0, /* !REPLACEMENT-bgeu/n0/n0/fR/retR */
    0, /* !REPLACEMENT-bgeu/n0/n1/fR/retR */
    0, /* !REPLACEMENT-bgeu/n0/nR/fR/retR */
    0, /* !REPLACEMENT-bgeu/n1/%rR/fR/retR */
    0, /* !REPLACEMENT-bgeu/n1/n0/fR/retR */
    0, /* !REPLACEMENT-bgeu/n1/n1/fR/retR */
    0, /* !REPLACEMENT-bgeu/n1/nR/fR/retR */
    0, /* !REPLACEMENT-bgeu/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-bgeu/nR/n0/fR/retR */
    0, /* !REPLACEMENT-bgeu/nR/n1/fR/retR */
    0, /* !REPLACEMENT-bgeu/nR/nR/fR/retR */
    0, /* !REPLACEMENT-bgt/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-bgt/%rR/n0/fR/retR */
    0, /* !REPLACEMENT-bgt/%rR/n1/fR/retR */
    0, /* !REPLACEMENT-bgt/%rR/nR/fR/retR */
    0, /* !REPLACEMENT-bgt/n0/%rR/fR/retR */
    0, /* !REPLACEMENT-bgt/n0/n0/fR/retR */
    0, /* !REPLACEMENT-bgt/n0/n1/fR/retR */
    0, /* !REPLACEMENT-bgt/n0/nR/fR/retR */
    0, /* !REPLACEMENT-bgt/n1/%rR/fR/retR */
    0, /* !REPLACEMENT-bgt/n1/n0/fR/retR */
    0, /* !REPLACEMENT-bgt/n1/n1/fR/retR */
    0, /* !REPLACEMENT-bgt/n1/nR/fR/retR */
    0, /* !REPLACEMENT-bgt/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-bgt/nR/n0/fR/retR */
    0, /* !REPLACEMENT-bgt/nR/n1/fR/retR */
    0, /* !REPLACEMENT-bgt/nR/nR/fR/retR */
    0, /* !REPLACEMENT-bgtu/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-bgtu/%rR/n0/fR/retR */
    0, /* !REPLACEMENT-bgtu/%rR/n1/fR/retR */
    0, /* !REPLACEMENT-bgtu/%rR/nR/fR/retR */
    0, /* !REPLACEMENT-bgtu/n0/%rR/fR/retR */
    0, /* !REPLACEMENT-bgtu/n0/n0/fR/retR */
    0, /* !REPLACEMENT-bgtu/n0/n1/fR/retR */
    0, /* !REPLACEMENT-bgtu/n0/nR/fR/retR */
    0, /* !REPLACEMENT-bgtu/n1/%rR/fR/retR */
    0, /* !REPLACEMENT-bgtu/n1/n0/fR/retR */
    0, /* !REPLACEMENT-bgtu/n1/n1/fR/retR */
    0, /* !REPLACEMENT-bgtu/n1/nR/fR/retR */
    0, /* !REPLACEMENT-bgtu/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-bgtu/nR/n0/fR/retR */
    0, /* !REPLACEMENT-bgtu/nR/n1/fR/retR */
    0, /* !REPLACEMENT-bgtu/nR/nR/fR/retR */
    0, /* !REPLACEMENT-ble/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-ble/%rR/n0/fR/retR */
    0, /* !REPLACEMENT-ble/%rR/n1/fR/retR */
    0, /* !REPLACEMENT-ble/%rR/nR/fR/retR */
    0, /* !REPLACEMENT-ble/n0/%rR/fR/retR */
    0, /* !REPLACEMENT-ble/n0/n0/fR/retR */
    0, /* !REPLACEMENT-ble/n0/n1/fR/retR */
    0, /* !REPLACEMENT-ble/n0/nR/fR/retR */
    0, /* !REPLACEMENT-ble/n1/%rR/fR/retR */
    0, /* !REPLACEMENT-ble/n1/n0/fR/retR */
    0, /* !REPLACEMENT-ble/n1/n1/fR/retR */
    0, /* !REPLACEMENT-ble/n1/nR/fR/retR */
    0, /* !REPLACEMENT-ble/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-ble/nR/n0/fR/retR */
    0, /* !REPLACEMENT-ble/nR/n1/fR/retR */
    0, /* !REPLACEMENT-ble/nR/nR/fR/retR */
    0, /* !REPLACEMENT-bleu/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-bleu/%rR/n0/fR/retR */
    0, /* !REPLACEMENT-bleu/%rR/n1/fR/retR */
    0, /* !REPLACEMENT-bleu/%rR/nR/fR/retR */
    0, /* !REPLACEMENT-bleu/n0/%rR/fR/retR */
    0, /* !REPLACEMENT-bleu/n0/n0/fR/retR */
    0, /* !REPLACEMENT-bleu/n0/n1/fR/retR */
    0, /* !REPLACEMENT-bleu/n0/nR/fR/retR */
    0, /* !REPLACEMENT-bleu/n1/%rR/fR/retR */
    0, /* !REPLACEMENT-bleu/n1/n0/fR/retR */
    0, /* !REPLACEMENT-bleu/n1/n1/fR/retR */
    0, /* !REPLACEMENT-bleu/n1/nR/fR/retR */
    0, /* !REPLACEMENT-bleu/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-bleu/nR/n0/fR/retR */
    0, /* !REPLACEMENT-bleu/nR/n1/fR/retR */
    0, /* !REPLACEMENT-bleu/nR/nR/fR/retR */
    0, /* !REPLACEMENT-blt/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-blt/%rR/n0/fR/retR */
    0, /* !REPLACEMENT-blt/%rR/n1/fR/retR */
    0, /* !REPLACEMENT-blt/%rR/nR/fR/retR */
    0, /* !REPLACEMENT-blt/n0/%rR/fR/retR */
    0, /* !REPLACEMENT-blt/n0/n0/fR/retR */
    0, /* !REPLACEMENT-blt/n0/n1/fR/retR */
    0, /* !REPLACEMENT-blt/n0/nR/fR/retR */
    0, /* !REPLACEMENT-blt/n1/%rR/fR/retR */
    0, /* !REPLACEMENT-blt/n1/n0/fR/retR */
    0, /* !REPLACEMENT-blt/n1/n1/fR/retR */
    0, /* !REPLACEMENT-blt/n1/nR/fR/retR */
    0, /* !REPLACEMENT-blt/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-blt/nR/n0/fR/retR */
    0, /* !REPLACEMENT-blt/nR/n1/fR/retR */
    0, /* !REPLACEMENT-blt/nR/nR/fR/retR */
    0, /* !REPLACEMENT-bltu/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-bltu/%rR/n0/fR/retR */
    0, /* !REPLACEMENT-bltu/%rR/n1/fR/retR */
    0, /* !REPLACEMENT-bltu/%rR/nR/fR/retR */
    0, /* !REPLACEMENT-bltu/n0/%rR/fR/retR */
    0, /* !REPLACEMENT-bltu/n0/n0/fR/retR */
    0, /* !REPLACEMENT-bltu/n0/n1/fR/retR */
    0, /* !REPLACEMENT-bltu/n0/nR/fR/retR */
    0, /* !REPLACEMENT-bltu/n1/%rR/fR/retR */
    0, /* !REPLACEMENT-bltu/n1/n0/fR/retR */
    0, /* !REPLACEMENT-bltu/n1/n1/fR/retR */
    0, /* !REPLACEMENT-bltu/n1/nR/fR/retR */
    0, /* !REPLACEMENT-bltu/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-bltu/nR/n0/fR/retR */
    0, /* !REPLACEMENT-bltu/nR/n1/fR/retR */
    0, /* !REPLACEMENT-bltu/nR/nR/fR/retR */
    0, /* !REPLACEMENT-bne/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-bne/%rR/n0/fR/retR */
    0, /* !REPLACEMENT-bne/%rR/nR/fR/retR */
    0, /* !REPLACEMENT-bne/n0/%rR/fR/retR */
    0, /* !REPLACEMENT-bne/n0/n0/fR/retR */
    0, /* !REPLACEMENT-bne/n0/nR/fR/retR */
    0, /* !REPLACEMENT-bne/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-bne/nR/n0/fR/retR */
    0, /* !REPLACEMENT-bne/nR/nR/fR/retR */
    0, /* !REPLACEMENT-bneg/%rR/fR/retR */
    0, /* !REPLACEMENT-bneg/nR/fR/retR */
    0, /* !REPLACEMENT-bnneg/%rR/fR/retR */
    0, /* !REPLACEMENT-bnneg/nR/fR/retR */
    0, /* !REPLACEMENT-bnotand/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-bnotand/%rR/n3/fR/retR */
    0, /* !REPLACEMENT-bnotand/%rR/n7/fR/retR */
    0, /* !REPLACEMENT-bnotand/%rR/nR/fR/retR */
    0, /* !REPLACEMENT-bnotand/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-bnotand/nR/n3/fR/retR */
    0, /* !REPLACEMENT-bnotand/nR/n7/fR/retR */
    0, /* !REPLACEMENT-bnotand/nR/nR/fR/retR */
    0, /* !REPLACEMENT-bnpos/%rR/fR/retR */
    0, /* !REPLACEMENT-bnpos/nR/fR/retR */
    0, /* !REPLACEMENT-bnz/%rR/fR/retR */
    0, /* !REPLACEMENT-bnz/nR/fR/retR */
    0, /* !REPLACEMENT-bpos/%rR/fR/retR */
    0, /* !REPLACEMENT-bpos/nR/fR/retR */
    0, /* !REPLACEMENT-br/%rR/retR */
    0, /* !REPLACEMENT-bz/%rR/fR/retR */
    0, /* !REPLACEMENT-bz/nR/fR/retR */
    0, /* !REPLACEMENT-divo/%rR/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-divo/%rR/n2/%rR/fR/retR */
    0, /* !REPLACEMENT-divo/%rR/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-divo/nR/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-divo/nR/n2/%rR/fR/retR */
    0, /* !REPLACEMENT-divo/nR/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-endvm/retR */
    0, /* !REPLACEMENT-exitvm/retR */
    0, /* !REPLACEMENT-modo/%rR/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-modo/%rR/n2/%rR/fR/retR */
    0, /* !REPLACEMENT-modo/%rR/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-modo/nR/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-modo/nR/n2/%rR/fR/retR */
    0, /* !REPLACEMENT-modo/nR/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-mulo/%rR/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-mulo/%rR/n2/%rR/fR/retR */
    0, /* !REPLACEMENT-mulo/%rR/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-mulo/nR/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-mulo/nR/n2/%rR/fR/retR */
    0, /* !REPLACEMENT-mulo/nR/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-procedurecall/fR/retR */
    0, /* !REPLACEMENT-procedurecallr/%rR/retR */
    0, /* !REPLACEMENT-procedurecallr/lR/retR */
    0, /* !REPLACEMENT-procedureprolog/retR */
    0, /* !REPLACEMENT-procedurereturn/retR */
    0, /* !REPLACEMENT-raise/%rR/retR */
    0, /* !REPLACEMENT-raise/n0/retR */
    0, /* !REPLACEMENT-raise/n1/retR */
    0, /* !REPLACEMENT-raise/n2/retR */
    0, /* !REPLACEMENT-raise/n3/retR */
    0, /* !REPLACEMENT-raise/n4/retR */
    0, /* !REPLACEMENT-raise/n5/retR */
    0, /* !REPLACEMENT-raise/n6/retR */
    0, /* !REPLACEMENT-raise/n7/retR */
    0, /* !REPLACEMENT-raise/n8/retR */
    0, /* !REPLACEMENT-raise/n9/retR */
    0, /* !REPLACEMENT-raise/n10/retR */
    0, /* !REPLACEMENT-raise/nR/retR */
    0, /* !REPLACEMENT-safe-point/fR/retR */
    0, /* !REPLACEMENT-stackif/fR/retR */
    0, /* !REPLACEMENT-stacknondroppingif/fR/retR */
    0, /* !REPLACEMENT-subo/%rR/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-subo/%rR/n1/%rR/fR/retR */
    0, /* !REPLACEMENT-subo/%rR/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-subo/nR/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-subo/nR/n1/%rR/fR/retR */
    0, /* !REPLACEMENT-subo/nR/nR/%rR/fR/retR */
    0 /* !REPLACEMENT-unreachable/retR */
  };

#endif // #ifdef JITTER_HAVE_DEFECT_REPLACEMENT


void
uninspired_rewrite (struct jitter_mutable_routine *jitter_mutable_routine_p)
{
  JITTTER_REWRITE_FUNCTION_PROLOG_;

/* User-specified code, rewriter part: beginning. */

/* User-specified code, rewriter part: end */


//fprintf (stderr, "No more rules to try\n");
}


//#include <jitter/jitter-fatal.h>

//#include <jitter/jitter.h>
//#include <jitter/jitter-instruction.h>
//#include <jitter/jitter-specialize.h>

//#include "uninspired-vm.h"
//#include "uninspired-meta-instructions.h"
//#include "uninspired-specialized-instructions.h"


/* Recognizer function prototypes. */
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add___rrR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add___rrR__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add___rrR__n_m1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n1___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n1__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n1__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n1__n_m1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n1__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n_m1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n_m1___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n_m1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n_m1__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n_m1__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n_m1__n_m1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n_m1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n_m1__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__nR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__nR__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__nR__n_m1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR__n_m1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR__n_m1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR__n_m1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR__n_m1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_b (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_b__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band___rrR__n3 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band___rrR__n3__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band___rrR__n7 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band___rrR__n7__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band__nR__n3 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band__nR__n3__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band__nR__n7 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band__nR__n7__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge___rrR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n0__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n0__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n1__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__nR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu___rrR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n0__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n0__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n1__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__nR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt___rrR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n0__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n0__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n1__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__nR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu___rrR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n0__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n0__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n1__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__nR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble___rrR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n0__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n0__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n1__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__nR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu___rrR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n0__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n0__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n1__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__nR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt___rrR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n0__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n0__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n1__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__nR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu___rrR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__n0__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__n0__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__n1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__n1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__n1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__n1__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__n1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__n1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__nR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bne__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bneg (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bneg___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bneg___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bneg__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bneg__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnneg (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnneg___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnneg___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnneg__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnneg__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnotand (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnotand___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnotand___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnotand___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnotand___rrR__n3 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnotand___rrR__n3__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnotand___rrR__n7 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnotand___rrR__n7__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnotand___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnotand___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnotand__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnotand__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnotand__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnotand__nR__n3 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnotand__nR__n3__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnotand__nR__n7 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnotand__nR__n7__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnotand__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnotand__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnpos (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnpos___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnpos___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnpos__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnpos__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnz (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnz___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnz___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnz__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bnz__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bpos (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bpos___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bpos___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bpos__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bpos__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_br (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_br___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bulge (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bulge__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bulge__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bulge__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bulge__n3 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bulge__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bulgeforth (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bz (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bz___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bz___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bz__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bz__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_clear_mpending (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_div (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_div___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_div___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_div___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_div___rrR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_div___rrR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_div___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_div___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_div__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_div__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_div__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_div__nR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_div__nR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_div__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_div__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo___rrR___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo___rrR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo___rrR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo___rrR__n2___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo___rrR__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo__nR___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo__nR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo__nR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo__nR__n2___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_divo__nR__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_drop_mhandler (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_endvm (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_exit (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_exit___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_exit__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_exitvm (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fadd (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fadd___rfR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fadd___rfR___rfR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fadd___rfR___rfR___rfR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fdiv (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fdiv___rfR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fdiv___rfR___rfR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fdiv___rfR___rfR___rfR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fincr (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fincr___rfR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fmul (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fmul___rfR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fmul___rfR___rfR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fmul___rfR___rfR___rfR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fprint (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fprint___rfR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fset (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fset___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fset___rrR___rfR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fset__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fset__nR___rfR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fsub (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fsub___rfR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fsub___rfR___rfR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_fsub___rfR___rfR___rfR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_hcf (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_install_msignal_mhandler (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithbyteoffset (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithbyteoffset___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithbyteoffset___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithbyteoffset___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithbyteoffset___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithbyteoffset___rrR__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithbyteoffset___rrR__n8 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithbyteoffset___rrR__n8___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithbyteoffset___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithbyteoffset___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithwordoffset (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithwordoffset___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithwordoffset___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithwordoffset___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithwordoffset___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithwordoffset___rrR__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithwordoffset___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithwordoffset___rrR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithwordoffset___rrR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithwordoffset___rrR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithwordoffset___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_loadwithwordoffset___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mallocwords (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mallocwords___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mallocwords___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mallocwords__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mallocwords__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mod (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mod___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mod___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mod___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mod___rrR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mod___rrR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mod___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mod___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mod__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mod__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mod__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mod__nR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mod__nR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mod__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mod__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo___rrR___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo___rrR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo___rrR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo___rrR__n2___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo___rrR__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo__nR___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo__nR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo__nR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo__nR__n2___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_modo__nR__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mov (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mov___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mov___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mov__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mov__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mov__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mov__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mov__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mov__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mov__lR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mov__lR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n3 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n4 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n5 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n6 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n7 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n8 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n9 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n10 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n11 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n12 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n13 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n14 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n15 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n16 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n17 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n18 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n19 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n20 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n21 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n22 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n23 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n24 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n25 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n26 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n27 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n28 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n29 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n30 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n31 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n32 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n33 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n34 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n35 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n36 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n37 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n38 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n39 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n40 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n41 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n42 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n43 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n44 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n45 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n46 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n47 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n48 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n49 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n50 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n51 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n52 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n53 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n54 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n55 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n56 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n57 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n58 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n59 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n60 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n61 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n62 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n63 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n64 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n65 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n66 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n67 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n68 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n69 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__n70 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mroll__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mrollforth (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mrot (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul___rrR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul___rrR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul__n2___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul__n2__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul__n2__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul__n2__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul__n2__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul__nR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul__nR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mul__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo___rrR___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo___rrR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo___rrR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo___rrR__n2___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo___rrR__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo__nR___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo__nR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo__nR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo__nR__n2___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_mulo__nR__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_nop (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_print_mpending_msignals (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_print_mtopmost (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_print_mtopmost__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_printfixnum (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_printfixnum___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_printfixnum__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_printufixnum (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_printufixnum___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_printufixnum__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_procedurecall (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_procedurecall__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_procedurecallr (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_procedurecallr___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_procedurecallr__lR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_procedureprolog (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_procedurereturn (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mdepths (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mdepths__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n0__lR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n1__lR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n2__lR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n3 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n3__lR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n4 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n4__lR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n5 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n5__lR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n6 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n6__lR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n7 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n7__lR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n8 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n8__lR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n9 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n9__lR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n10 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__n10__lR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mhandler__nR__lR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mincreasing (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_push_mincreasing__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_quake (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_raise (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_raise___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_raise__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_raise__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_raise__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_raise__n3 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_raise__n4 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_raise__n5 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_raise__n6 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_raise__n7 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_raise__n8 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_raise__n9 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_raise__n10 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_raise__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_random (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_random___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n3 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n4 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n5 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n6 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n7 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n8 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n9 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n10 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n11 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n12 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n13 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n14 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n15 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n16 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n17 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n18 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n19 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n20 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n21 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n22 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n23 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n24 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n25 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n26 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n27 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n28 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n29 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n30 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n31 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n32 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n33 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n34 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n35 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n36 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n37 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n38 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n39 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n40 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n41 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n42 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n43 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n44 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n45 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n46 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n47 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n48 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n49 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n50 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n51 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n52 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n53 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n54 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n55 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n56 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n57 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n58 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n59 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n60 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n61 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n62 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n63 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n64 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n65 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n66 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n67 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n68 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n69 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__n70 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_reverse__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n3 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n4 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n5 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n6 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n7 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n8 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n9 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n10 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n11 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n12 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n13 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n14 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n15 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n16 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n17 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n18 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n19 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n20 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n21 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n22 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n23 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n24 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n25 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n26 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n27 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n28 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n29 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n30 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n31 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n32 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n33 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n34 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n35 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n36 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n37 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n38 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n39 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n40 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n41 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n42 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n43 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n44 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n45 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n46 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n47 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n48 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n49 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n50 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n51 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n52 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n53 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n54 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n55 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n56 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n57 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n58 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n59 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n60 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n61 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n62 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n63 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n64 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n65 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n66 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n67 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n68 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n69 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__n70 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_roll__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_rollforth (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_rot (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_safe_mpoint (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_safe_mpoint__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_set_mpending (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n1__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n1__n3 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n1__n4 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n1__n5 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n2__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n2__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n2__n3 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n2__n4 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n2__n5 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n2__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n3 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n3__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n3__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n3__n3 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n3__n4 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n3__n5 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__n3__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__nR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__nR__n3 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__nR__n4 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__nR__n5 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slide__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_slideforth (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackdrop (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackdup (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackif (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackif__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stacknip (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stacknondroppingif (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stacknondroppingif__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stacknot (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackoneminus (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackoneplus (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackover (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackpeek (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackpeek___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackplus (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackplusr (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackplusr___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackpop (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackpop___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackprint (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackpush (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackpush___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackpush__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackpush__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackpush__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackpush__lR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackpushunspecified (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackset (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackset___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackset__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackset__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackset__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackset__lR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackswap (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackswaptop (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stackswaptop___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_stacktimes (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithbyteoffset (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithbyteoffset___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithbyteoffset___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithbyteoffset___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithbyteoffset___rrR___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithbyteoffset___rrR___rrR__n8 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithbyteoffset___rrR___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithbyteoffset__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithbyteoffset__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithbyteoffset__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithbyteoffset__nR___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithbyteoffset__nR___rrR__n8 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithbyteoffset__nR___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithwordoffset (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithwordoffset___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithwordoffset___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithwordoffset___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithwordoffset___rrR___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithwordoffset___rrR___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithwordoffset___rrR___rrR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithwordoffset___rrR___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithwordoffset__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithwordoffset__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithwordoffset__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithwordoffset__nR___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithwordoffset__nR___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithwordoffset__nR___rrR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_storewithwordoffset__nR___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub___rrR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub__n0___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub__n0__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub__n0__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub__n0__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub__nR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_sub__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo___rrR___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo___rrR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo___rrR__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo___rrR__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo__nR___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo__nR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo__nR__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_subo__nR__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_tuck (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_unreachable (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_whirl (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_whirl__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_whirl__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_whirl__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_whirl__n3 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_whirl__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_whirlforth (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));


/* Recognizer function definitions. */
inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_add__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == -1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_add__n_m1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_add__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_add___rrR__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == -1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_add___rrR__n_m1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_add___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add___rrR___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_add___rrR___rrR___rrR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add___rrR__n1___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add___rrR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_add___rrR__n1___rrR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add___rrR__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add___rrR__n_m1___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add___rrR__n_m1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_add___rrR__n_m1___rrR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add___rrR__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_add___rrR__nR___rrR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add__n1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_add__n1__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == -1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_add__n1__n_m1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_add__n1__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add__n1___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n1___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_add__n1___rrR___rrR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add__n1__n1___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n1__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_add__n1__n1___rrR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n1__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add__n1__n_m1___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n1__n_m1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_add__n1__n_m1___rrR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add__n1__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n1__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_add__n1__nR___rrR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add__n_m1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_add__n_m1__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == -1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_add__n_m1__n_m1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_add__n_m1__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n_m1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add__n_m1___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n_m1___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_add__n_m1___rrR___rrR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n_m1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add__n_m1__n1___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n_m1__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_add__n_m1__n1___rrR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n_m1__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add__n_m1__n_m1___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n_m1__n_m1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_add__n_m1__n_m1___rrR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n_m1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add__n_m1__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__n_m1__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_add__n_m1__nR___rrR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_add__nR__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == -1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_add__nR__n_m1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_add__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add__nR___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_add__nR___rrR___rrR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add__nR__n1___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__nR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_add__nR__n1___rrR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__nR__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add__nR__n_m1___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__nR__n_m1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_add__nR__n_m1___rrR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_add__nR__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_add__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_add__nR__nR___rrR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_addo___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_addo__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_addo___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_addo___rrR__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == -1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_addo___rrR__n_m1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_addo___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_addo___rrR___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_addo___rrR___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_addo___rrR___rrR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_addo___rrR__n1___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_addo___rrR__n1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_addo___rrR__n1___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_addo___rrR__n_m1___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR__n_m1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_addo___rrR__n_m1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR__n_m1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_addo___rrR__n_m1___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_addo___rrR__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_addo___rrR__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo___rrR__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_addo___rrR__nR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_addo__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_addo__nR__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == -1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_addo__nR__n_m1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_addo__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_addo__nR___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_addo__nR___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_addo__nR___rrR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_addo__nR__n1___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_addo__nR__n1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_addo__nR__n1___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_addo__nR__n_m1___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR__n_m1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_addo__nR__n_m1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR__n_m1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_addo__nR__n_m1___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_addo__nR__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_addo__nR__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_addo__nR__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_addo__nR__nR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_b (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_b__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_b__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_b__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_band___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_band__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_band___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 3 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_band___rrR__n3 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 7 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_band___rrR__n7 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_band___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_band___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_band___rrR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band___rrR__n3 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_band___rrR__n3__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band___rrR__n3__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_band___rrR__n3__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band___rrR__n7 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_band___rrR__n7__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band___rrR__n7__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_band___rrR__n7__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_band___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_band___rrR__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_band__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 3 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_band__nR__n3 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 7 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_band__nR__n7 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_band__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_band__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_band__nR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band__nR__n3 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_band__nR__n3__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band__nR__n3__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_band__nR__n3__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band__nR__n7 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_band__nR__n7__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band__nR__n7__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_band__nR__n7__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_band__nR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_band__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_band__nR__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_beq___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_beq__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_beq___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_beq___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_beq___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_beq___rrR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_beq___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_beq___rrR__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_beq__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_beq__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_beq__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_beq__nR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_beq__nR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_beq__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_beq__nR__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bge___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bge__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bge__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bge__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bge___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bge___rrR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bge___rrR__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bge___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bge___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bge___rrR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bge___rrR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bge___rrR__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bge___rrR__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge___rrR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bge___rrR__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bge___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bge___rrR__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bge__n0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bge__n0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bge__n0__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bge__n0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bge__n0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bge__n0___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bge__n0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bge__n0__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n0__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bge__n0__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n0__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bge__n0__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bge__n0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bge__n0__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bge__n1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bge__n1__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bge__n1__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bge__n1__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bge__n1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bge__n1___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bge__n1__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bge__n1__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bge__n1__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n1__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bge__n1__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bge__n1__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__n1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bge__n1__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bge__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bge__nR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bge__nR__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bge__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bge__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bge__nR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bge__nR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bge__nR__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bge__nR__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__nR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bge__nR__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bge__nR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bge__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bge__nR__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bgeu___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgeu__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgeu__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bgeu__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bgeu___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgeu___rrR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgeu___rrR__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bgeu___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgeu___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgeu___rrR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgeu___rrR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgeu___rrR__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgeu___rrR__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu___rrR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgeu___rrR__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgeu___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgeu___rrR__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bgeu__n0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgeu__n0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgeu__n0__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bgeu__n0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgeu__n0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgeu__n0___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgeu__n0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgeu__n0__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n0__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgeu__n0__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n0__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgeu__n0__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgeu__n0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgeu__n0__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bgeu__n1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgeu__n1__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgeu__n1__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bgeu__n1__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgeu__n1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgeu__n1___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgeu__n1__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgeu__n1__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgeu__n1__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n1__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgeu__n1__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgeu__n1__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__n1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgeu__n1__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bgeu__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgeu__nR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgeu__nR__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bgeu__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgeu__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgeu__nR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgeu__nR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgeu__nR__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgeu__nR__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__nR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgeu__nR__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgeu__nR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgeu__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgeu__nR__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bgt___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgt__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgt__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bgt__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bgt___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgt___rrR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgt___rrR__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bgt___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgt___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgt___rrR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgt___rrR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgt___rrR__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgt___rrR__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt___rrR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgt___rrR__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgt___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgt___rrR__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bgt__n0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgt__n0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgt__n0__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bgt__n0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgt__n0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgt__n0___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgt__n0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgt__n0__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n0__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgt__n0__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n0__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgt__n0__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgt__n0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgt__n0__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bgt__n1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgt__n1__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgt__n1__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bgt__n1__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgt__n1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgt__n1___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgt__n1__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgt__n1__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgt__n1__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n1__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgt__n1__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgt__n1__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__n1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgt__n1__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bgt__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgt__nR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgt__nR__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bgt__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgt__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgt__nR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgt__nR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgt__nR__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgt__nR__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__nR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgt__nR__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgt__nR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgt__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgt__nR__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bgtu___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgtu__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgtu__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bgtu__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bgtu___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgtu___rrR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgtu___rrR__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bgtu___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgtu___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgtu___rrR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgtu___rrR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgtu___rrR__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgtu___rrR__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu___rrR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgtu___rrR__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgtu___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgtu___rrR__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bgtu__n0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgtu__n0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgtu__n0__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bgtu__n0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgtu__n0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgtu__n0___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgtu__n0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgtu__n0__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n0__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgtu__n0__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n0__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgtu__n0__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgtu__n0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgtu__n0__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bgtu__n1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgtu__n1__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgtu__n1__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bgtu__n1__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgtu__n1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgtu__n1___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgtu__n1__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgtu__n1__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgtu__n1__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n1__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgtu__n1__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgtu__n1__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__n1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgtu__n1__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bgtu__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgtu__nR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bgtu__nR__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bgtu__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgtu__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgtu__nR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgtu__nR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgtu__nR__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgtu__nR__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__nR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgtu__nR__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bgtu__nR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bgtu__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bgtu__nR__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_ble___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_ble__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_ble__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_ble__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_ble___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_ble___rrR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_ble___rrR__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_ble___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_ble___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_ble___rrR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_ble___rrR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_ble___rrR__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_ble___rrR__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble___rrR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_ble___rrR__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_ble___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_ble___rrR__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_ble__n0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_ble__n0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_ble__n0__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_ble__n0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_ble__n0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_ble__n0___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_ble__n0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_ble__n0__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n0__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_ble__n0__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n0__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_ble__n0__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_ble__n0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_ble__n0__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_ble__n1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_ble__n1__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_ble__n1__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_ble__n1__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_ble__n1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_ble__n1___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_ble__n1__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_ble__n1__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_ble__n1__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n1__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_ble__n1__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_ble__n1__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__n1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_ble__n1__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_ble__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_ble__nR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_ble__nR__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_ble__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_ble__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_ble__nR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_ble__nR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_ble__nR__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_ble__nR__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__nR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_ble__nR__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_ble__nR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_ble__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_ble__nR__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bleu___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bleu__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bleu__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bleu__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bleu___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bleu___rrR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bleu___rrR__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bleu___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bleu___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bleu___rrR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bleu___rrR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bleu___rrR__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bleu___rrR__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu___rrR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bleu___rrR__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bleu___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bleu___rrR__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bleu__n0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bleu__n0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bleu__n0__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bleu__n0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bleu__n0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bleu__n0___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bleu__n0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bleu__n0__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n0__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bleu__n0__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n0__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bleu__n0__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bleu__n0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bleu__n0__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bleu__n1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bleu__n1__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bleu__n1__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bleu__n1__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bleu__n1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bleu__n1___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bleu__n1__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bleu__n1__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bleu__n1__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n1__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bleu__n1__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bleu__n1__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__n1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bleu__n1__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bleu__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bleu__nR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bleu__nR__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bleu__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bleu__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bleu__nR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bleu__nR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bleu__nR__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bleu__nR__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__nR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bleu__nR__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bleu__nR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bleu__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bleu__nR__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_blt___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_blt__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_blt__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_blt__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_blt___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_blt___rrR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_blt___rrR__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_blt___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_blt___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_blt___rrR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_blt___rrR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_blt___rrR__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_blt___rrR__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt___rrR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_blt___rrR__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_blt___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_blt___rrR__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_blt__n0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_blt__n0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_blt__n0__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_blt__n0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_blt__n0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_blt__n0___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_blt__n0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_blt__n0__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n0__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_blt__n0__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n0__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_blt__n0__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_blt__n0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_blt__n0__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_blt__n1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_blt__n1__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_blt__n1__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_blt__n1__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_blt__n1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_blt__n1___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_blt__n1__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_blt__n1__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_blt__n1__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n1__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_blt__n1__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_blt__n1__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__n1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_blt__n1__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_blt__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_blt__nR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_blt__nR__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_blt__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_blt__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_blt__nR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_blt__nR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_blt__nR__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_blt__nR__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__nR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_blt__nR__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_blt__nR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_blt__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_blt__nR__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bltu___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bltu__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bltu__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bltu__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bltu___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bltu___rrR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_bltu___rrR__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = uninspired_recognize_specialized_instruction_bltu___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bltu___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bltu___rrR___rrR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bltu___rrR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bltu___rrR__n0__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bltu___rrR__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu___rrR__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bltu___rrR__n1__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = uninspired_recognize_specialized_instruction_bltu___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return uninspired_specialized_instruction_opcode_bltu___rrR__nR__fR;
}

inline static enum uninspired_specialized_instruction_opcode
uninspired_recognize_specialized_instruction_bltu__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum uninspired_specialized_instruction_opcode res = uninspired_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = uninspired_recognize_specialized_instruction_bltu__n0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = uninspired_recognize_specialized_instruction_blt