/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PrinterAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: PrinterAttributes::PrinterAttributes
//
// Purpose: 
//   Init utility for the PrinterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void PrinterAttributes::Init()
{
    printProgram = "lpr";
    documentName = "untitled";
    numCopies = 1;
    portrait = true;
    printColor = true;
    outputToFile = false;
    outputToFileName = "untitled";
    pageSize = 2;

    PrinterAttributes::SelectAll();
}

// ****************************************************************************
// Method: PrinterAttributes::PrinterAttributes
//
// Purpose: 
//   Copy utility for the PrinterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void PrinterAttributes::Copy(const PrinterAttributes &obj)
{
    printerName = obj.printerName;
    printProgram = obj.printProgram;
    documentName = obj.documentName;
    creator = obj.creator;
    numCopies = obj.numCopies;
    portrait = obj.portrait;
    printColor = obj.printColor;
    outputToFile = obj.outputToFile;
    outputToFileName = obj.outputToFileName;
    pageSize = obj.pageSize;

    PrinterAttributes::SelectAll();
}

// Type map format string
const char *PrinterAttributes::TypeMapFormatString = PRINTERATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t PrinterAttributes::TmfsStruct = {PRINTERATTRIBUTES_TMFS};


// ****************************************************************************
// Method: PrinterAttributes::PrinterAttributes
//
// Purpose: 
//   Default constructor for the PrinterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PrinterAttributes::PrinterAttributes() : 
    AttributeSubject(PrinterAttributes::TypeMapFormatString)
{
    PrinterAttributes::Init();
}

// ****************************************************************************
// Method: PrinterAttributes::PrinterAttributes
//
// Purpose: 
//   Constructor for the derived classes of PrinterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PrinterAttributes::PrinterAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    PrinterAttributes::Init();
}

// ****************************************************************************
// Method: PrinterAttributes::PrinterAttributes
//
// Purpose: 
//   Copy constructor for the PrinterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PrinterAttributes::PrinterAttributes(const PrinterAttributes &obj) : 
    AttributeSubject(PrinterAttributes::TypeMapFormatString)
{
    PrinterAttributes::Copy(obj);
}

// ****************************************************************************
// Method: PrinterAttributes::PrinterAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the PrinterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PrinterAttributes::PrinterAttributes(const PrinterAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    PrinterAttributes::Copy(obj);
}

// ****************************************************************************
// Method: PrinterAttributes::~PrinterAttributes
//
// Purpose: 
//   Destructor for the PrinterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PrinterAttributes::~PrinterAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: PrinterAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the PrinterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PrinterAttributes& 
PrinterAttributes::operator = (const PrinterAttributes &obj)
{
    if (this == &obj) return *this;

    PrinterAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: PrinterAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the PrinterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PrinterAttributes::operator == (const PrinterAttributes &obj) const
{
    // Create the return value
    return ((printerName == obj.printerName) &&
            (printProgram == obj.printProgram) &&
            (documentName == obj.documentName) &&
            (creator == obj.creator) &&
            (numCopies == obj.numCopies) &&
            (portrait == obj.portrait) &&
            (printColor == obj.printColor) &&
            (outputToFile == obj.outputToFile) &&
            (outputToFileName == obj.outputToFileName) &&
            (pageSize == obj.pageSize));
}

// ****************************************************************************
// Method: PrinterAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the PrinterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PrinterAttributes::operator != (const PrinterAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: PrinterAttributes::TypeName
//
// Purpose: 
//   Type name method for the PrinterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
PrinterAttributes::TypeName() const
{
    return "PrinterAttributes";
}

// ****************************************************************************
// Method: PrinterAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the PrinterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PrinterAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const PrinterAttributes *tmp = (const PrinterAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: PrinterAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the PrinterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PrinterAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new PrinterAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: PrinterAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the PrinterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PrinterAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new PrinterAttributes(*this);
    else
        retval = new PrinterAttributes;

    return retval;
}

// ****************************************************************************
// Method: PrinterAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
PrinterAttributes::SelectAll()
{
    Select(ID_printerName,      (void *)&printerName);
    Select(ID_printProgram,     (void *)&printProgram);
    Select(ID_documentName,     (void *)&documentName);
    Select(ID_creator,          (void *)&creator);
    Select(ID_numCopies,        (void *)&numCopies);
    Select(ID_portrait,         (void *)&portrait);
    Select(ID_printColor,       (void *)&printColor);
    Select(ID_outputToFile,     (void *)&outputToFile);
    Select(ID_outputToFileName, (void *)&outputToFileName);
    Select(ID_pageSize,         (void *)&pageSize);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PrinterAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PrinterAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    PrinterAttributes defaultObject;
    bool addToParent = false;
    // Create a node for PrinterAttributes.
    DataNode *node = new DataNode("PrinterAttributes");

    if(completeSave || !FieldsEqual(ID_printerName, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("printerName", printerName));
    }

    if(completeSave || !FieldsEqual(ID_printProgram, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("printProgram", printProgram));
    }

    if(completeSave || !FieldsEqual(ID_documentName, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("documentName", documentName));
    }

    if(completeSave || !FieldsEqual(ID_creator, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("creator", creator));
    }

    if(completeSave || !FieldsEqual(ID_numCopies, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numCopies", numCopies));
    }

    if(completeSave || !FieldsEqual(ID_portrait, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("portrait", portrait));
    }

    if(completeSave || !FieldsEqual(ID_printColor, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("printColor", printColor));
    }

    if(completeSave || !FieldsEqual(ID_outputToFile, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("outputToFile", outputToFile));
    }

    if(completeSave || !FieldsEqual(ID_outputToFileName, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("outputToFileName", outputToFileName));
    }

    if(completeSave || !FieldsEqual(ID_pageSize, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pageSize", pageSize));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: PrinterAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
PrinterAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("PrinterAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("printerName")) != 0)
        SetPrinterName(node->AsString());
    if((node = searchNode->GetNode("printProgram")) != 0)
        SetPrintProgram(node->AsString());
    if((node = searchNode->GetNode("documentName")) != 0)
        SetDocumentName(node->AsString());
    if((node = searchNode->GetNode("creator")) != 0)
        SetCreator(node->AsString());
    if((node = searchNode->GetNode("numCopies")) != 0)
        SetNumCopies(node->AsInt());
    if((node = searchNode->GetNode("portrait")) != 0)
        SetPortrait(node->AsBool());
    if((node = searchNode->GetNode("printColor")) != 0)
        SetPrintColor(node->AsBool());
    if((node = searchNode->GetNode("outputToFile")) != 0)
        SetOutputToFile(node->AsBool());
    if((node = searchNode->GetNode("outputToFileName")) != 0)
        SetOutputToFileName(node->AsString());
    if((node = searchNode->GetNode("pageSize")) != 0)
        SetPageSize(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
PrinterAttributes::SetPrinterName(const std::string &printerName_)
{
    printerName = printerName_;
    Select(ID_printerName, (void *)&printerName);
}

void
PrinterAttributes::SetPrintProgram(const std::string &printProgram_)
{
    printProgram = printProgram_;
    Select(ID_printProgram, (void *)&printProgram);
}

void
PrinterAttributes::SetDocumentName(const std::string &documentName_)
{
    documentName = documentName_;
    Select(ID_documentName, (void *)&documentName);
}

void
PrinterAttributes::SetCreator(const std::string &creator_)
{
    creator = creator_;
    Select(ID_creator, (void *)&creator);
}

void
PrinterAttributes::SetNumCopies(int numCopies_)
{
    numCopies = numCopies_;
    Select(ID_numCopies, (void *)&numCopies);
}

void
PrinterAttributes::SetPortrait(bool portrait_)
{
    portrait = portrait_;
    Select(ID_portrait, (void *)&portrait);
}

void
PrinterAttributes::SetPrintColor(bool printColor_)
{
    printColor = printColor_;
    Select(ID_printColor, (void *)&printColor);
}

void
PrinterAttributes::SetOutputToFile(bool outputToFile_)
{
    outputToFile = outputToFile_;
    Select(ID_outputToFile, (void *)&outputToFile);
}

void
PrinterAttributes::SetOutputToFileName(const std::string &outputToFileName_)
{
    outputToFileName = outputToFileName_;
    Select(ID_outputToFileName, (void *)&outputToFileName);
}

void
PrinterAttributes::SetPageSize(int pageSize_)
{
    pageSize = pageSize_;
    Select(ID_pageSize, (void *)&pageSize);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
PrinterAttributes::GetPrinterName() const
{
    return printerName;
}

std::string &
PrinterAttributes::GetPrinterName()
{
    return printerName;
}

const std::string &
PrinterAttributes::GetPrintProgram() const
{
    return printProgram;
}

std::string &
PrinterAttributes::GetPrintProgram()
{
    return printProgram;
}

const std::string &
PrinterAttributes::GetDocumentName() const
{
    return documentName;
}

std::string &
PrinterAttributes::GetDocumentName()
{
    return documentName;
}

const std::string &
PrinterAttributes::GetCreator() const
{
    return creator;
}

std::string &
PrinterAttributes::GetCreator()
{
    return creator;
}

int
PrinterAttributes::GetNumCopies() const
{
    return numCopies;
}

bool
PrinterAttributes::GetPortrait() const
{
    return portrait;
}

bool
PrinterAttributes::GetPrintColor() const
{
    return printColor;
}

bool
PrinterAttributes::GetOutputToFile() const
{
    return outputToFile;
}

const std::string &
PrinterAttributes::GetOutputToFileName() const
{
    return outputToFileName;
}

std::string &
PrinterAttributes::GetOutputToFileName()
{
    return outputToFileName;
}

int
PrinterAttributes::GetPageSize() const
{
    return pageSize;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
PrinterAttributes::SelectPrinterName()
{
    Select(ID_printerName, (void *)&printerName);
}

void
PrinterAttributes::SelectPrintProgram()
{
    Select(ID_printProgram, (void *)&printProgram);
}

void
PrinterAttributes::SelectDocumentName()
{
    Select(ID_documentName, (void *)&documentName);
}

void
PrinterAttributes::SelectCreator()
{
    Select(ID_creator, (void *)&creator);
}

void
PrinterAttributes::SelectOutputToFileName()
{
    Select(ID_outputToFileName, (void *)&outputToFileName);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PrinterAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
PrinterAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_printerName:      return "printerName";
    case ID_printProgram:     return "printProgram";
    case ID_documentName:     return "documentName";
    case ID_creator:          return "creator";
    case ID_numCopies:        return "numCopies";
    case ID_portrait:         return "portrait";
    case ID_printColor:       return "printColor";
    case ID_outputToFile:     return "outputToFile";
    case ID_outputToFileName: return "outputToFileName";
    case ID_pageSize:         return "pageSize";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PrinterAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
PrinterAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_printerName:      return FieldType_string;
    case ID_printProgram:     return FieldType_string;
    case ID_documentName:     return FieldType_string;
    case ID_creator:          return FieldType_string;
    case ID_numCopies:        return FieldType_int;
    case ID_portrait:         return FieldType_bool;
    case ID_printColor:       return FieldType_bool;
    case ID_outputToFile:     return FieldType_bool;
    case ID_outputToFileName: return FieldType_string;
    case ID_pageSize:         return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: PrinterAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
PrinterAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_printerName:      return "string";
    case ID_printProgram:     return "string";
    case ID_documentName:     return "string";
    case ID_creator:          return "string";
    case ID_numCopies:        return "int";
    case ID_portrait:         return "bool";
    case ID_printColor:       return "bool";
    case ID_outputToFile:     return "bool";
    case ID_outputToFileName: return "string";
    case ID_pageSize:         return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PrinterAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PrinterAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const PrinterAttributes &obj = *((const PrinterAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_printerName:
        {  // new scope
        retval = (printerName == obj.printerName);
        }
        break;
    case ID_printProgram:
        {  // new scope
        retval = (printProgram == obj.printProgram);
        }
        break;
    case ID_documentName:
        {  // new scope
        retval = (documentName == obj.documentName);
        }
        break;
    case ID_creator:
        {  // new scope
        retval = (creator == obj.creator);
        }
        break;
    case ID_numCopies:
        {  // new scope
        retval = (numCopies == obj.numCopies);
        }
        break;
    case ID_portrait:
        {  // new scope
        retval = (portrait == obj.portrait);
        }
        break;
    case ID_printColor:
        {  // new scope
        retval = (printColor == obj.printColor);
        }
        break;
    case ID_outputToFile:
        {  // new scope
        retval = (outputToFile == obj.outputToFile);
        }
        break;
    case ID_outputToFileName:
        {  // new scope
        retval = (outputToFileName == obj.outputToFileName);
        }
        break;
    case ID_pageSize:
        {  // new scope
        retval = (pageSize == obj.pageSize);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

