// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package timestreaminfluxdb

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateDbInstance = "CreateDbInstance"

// CreateDbInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateDbInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDbInstance for more information on using the CreateDbInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDbInstanceRequest method.
//	req, resp := client.CreateDbInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/CreateDbInstance
func (c *TimestreamInfluxDB) CreateDbInstanceRequest(input *CreateDbInstanceInput) (req *request.Request, output *CreateDbInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateDbInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDbInstanceInput{}
	}

	output = &CreateDbInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDbInstance API operation for Timestream InfluxDB.
//
// Creates a new Timestream for InfluxDB DB instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Timestream InfluxDB's
// API operation CreateDbInstance for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request exceeds the service quota.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Timestream for InfluxDB.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request conflicts with an existing resource in Timestream for InfluxDB.
//
//   - ResourceNotFoundException
//     The requested resource was not found or does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/CreateDbInstance
func (c *TimestreamInfluxDB) CreateDbInstance(input *CreateDbInstanceInput) (*CreateDbInstanceOutput, error) {
	req, out := c.CreateDbInstanceRequest(input)
	return out, req.Send()
}

// CreateDbInstanceWithContext is the same as CreateDbInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDbInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamInfluxDB) CreateDbInstanceWithContext(ctx aws.Context, input *CreateDbInstanceInput, opts ...request.Option) (*CreateDbInstanceOutput, error) {
	req, out := c.CreateDbInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDbParameterGroup = "CreateDbParameterGroup"

// CreateDbParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDbParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDbParameterGroup for more information on using the CreateDbParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDbParameterGroupRequest method.
//	req, resp := client.CreateDbParameterGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/CreateDbParameterGroup
func (c *TimestreamInfluxDB) CreateDbParameterGroupRequest(input *CreateDbParameterGroupInput) (req *request.Request, output *CreateDbParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDbParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDbParameterGroupInput{}
	}

	output = &CreateDbParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDbParameterGroup API operation for Timestream InfluxDB.
//
// Creates a new Timestream for InfluxDB DB parameter group to associate with
// DB instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Timestream InfluxDB's
// API operation CreateDbParameterGroup for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     The request exceeds the service quota.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Timestream for InfluxDB.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request conflicts with an existing resource in Timestream for InfluxDB.
//
//   - ResourceNotFoundException
//     The requested resource was not found or does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/CreateDbParameterGroup
func (c *TimestreamInfluxDB) CreateDbParameterGroup(input *CreateDbParameterGroupInput) (*CreateDbParameterGroupOutput, error) {
	req, out := c.CreateDbParameterGroupRequest(input)
	return out, req.Send()
}

// CreateDbParameterGroupWithContext is the same as CreateDbParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDbParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamInfluxDB) CreateDbParameterGroupWithContext(ctx aws.Context, input *CreateDbParameterGroupInput, opts ...request.Option) (*CreateDbParameterGroupOutput, error) {
	req, out := c.CreateDbParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDbInstance = "DeleteDbInstance"

// DeleteDbInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDbInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDbInstance for more information on using the DeleteDbInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDbInstanceRequest method.
//	req, resp := client.DeleteDbInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/DeleteDbInstance
func (c *TimestreamInfluxDB) DeleteDbInstanceRequest(input *DeleteDbInstanceInput) (req *request.Request, output *DeleteDbInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteDbInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDbInstanceInput{}
	}

	output = &DeleteDbInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDbInstance API operation for Timestream InfluxDB.
//
// Deletes a Timestream for InfluxDB DB instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Timestream InfluxDB's
// API operation DeleteDbInstance for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Timestream for InfluxDB.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request conflicts with an existing resource in Timestream for InfluxDB.
//
//   - ResourceNotFoundException
//     The requested resource was not found or does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/DeleteDbInstance
func (c *TimestreamInfluxDB) DeleteDbInstance(input *DeleteDbInstanceInput) (*DeleteDbInstanceOutput, error) {
	req, out := c.DeleteDbInstanceRequest(input)
	return out, req.Send()
}

// DeleteDbInstanceWithContext is the same as DeleteDbInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDbInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamInfluxDB) DeleteDbInstanceWithContext(ctx aws.Context, input *DeleteDbInstanceInput, opts ...request.Option) (*DeleteDbInstanceOutput, error) {
	req, out := c.DeleteDbInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDbInstance = "GetDbInstance"

// GetDbInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetDbInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDbInstance for more information on using the GetDbInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDbInstanceRequest method.
//	req, resp := client.GetDbInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/GetDbInstance
func (c *TimestreamInfluxDB) GetDbInstanceRequest(input *GetDbInstanceInput) (req *request.Request, output *GetDbInstanceOutput) {
	op := &request.Operation{
		Name:       opGetDbInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDbInstanceInput{}
	}

	output = &GetDbInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDbInstance API operation for Timestream InfluxDB.
//
// Returns a Timestream for InfluxDB DB instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Timestream InfluxDB's
// API operation GetDbInstance for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Timestream for InfluxDB.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The requested resource was not found or does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/GetDbInstance
func (c *TimestreamInfluxDB) GetDbInstance(input *GetDbInstanceInput) (*GetDbInstanceOutput, error) {
	req, out := c.GetDbInstanceRequest(input)
	return out, req.Send()
}

// GetDbInstanceWithContext is the same as GetDbInstance with the addition of
// the ability to pass a context and additional request options.
//
// See GetDbInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamInfluxDB) GetDbInstanceWithContext(ctx aws.Context, input *GetDbInstanceInput, opts ...request.Option) (*GetDbInstanceOutput, error) {
	req, out := c.GetDbInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDbParameterGroup = "GetDbParameterGroup"

// GetDbParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetDbParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDbParameterGroup for more information on using the GetDbParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDbParameterGroupRequest method.
//	req, resp := client.GetDbParameterGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/GetDbParameterGroup
func (c *TimestreamInfluxDB) GetDbParameterGroupRequest(input *GetDbParameterGroupInput) (req *request.Request, output *GetDbParameterGroupOutput) {
	op := &request.Operation{
		Name:       opGetDbParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDbParameterGroupInput{}
	}

	output = &GetDbParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDbParameterGroup API operation for Timestream InfluxDB.
//
// Returns a Timestream for InfluxDB DB parameter group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Timestream InfluxDB's
// API operation GetDbParameterGroup for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Timestream for InfluxDB.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The requested resource was not found or does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/GetDbParameterGroup
func (c *TimestreamInfluxDB) GetDbParameterGroup(input *GetDbParameterGroupInput) (*GetDbParameterGroupOutput, error) {
	req, out := c.GetDbParameterGroupRequest(input)
	return out, req.Send()
}

// GetDbParameterGroupWithContext is the same as GetDbParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetDbParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamInfluxDB) GetDbParameterGroupWithContext(ctx aws.Context, input *GetDbParameterGroupInput, opts ...request.Option) (*GetDbParameterGroupOutput, error) {
	req, out := c.GetDbParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDbInstances = "ListDbInstances"

// ListDbInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListDbInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDbInstances for more information on using the ListDbInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDbInstancesRequest method.
//	req, resp := client.ListDbInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListDbInstances
func (c *TimestreamInfluxDB) ListDbInstancesRequest(input *ListDbInstancesInput) (req *request.Request, output *ListDbInstancesOutput) {
	op := &request.Operation{
		Name:       opListDbInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDbInstancesInput{}
	}

	output = &ListDbInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDbInstances API operation for Timestream InfluxDB.
//
// Returns a list of Timestream for InfluxDB DB instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Timestream InfluxDB's
// API operation ListDbInstances for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Timestream for InfluxDB.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The requested resource was not found or does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListDbInstances
func (c *TimestreamInfluxDB) ListDbInstances(input *ListDbInstancesInput) (*ListDbInstancesOutput, error) {
	req, out := c.ListDbInstancesRequest(input)
	return out, req.Send()
}

// ListDbInstancesWithContext is the same as ListDbInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListDbInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamInfluxDB) ListDbInstancesWithContext(ctx aws.Context, input *ListDbInstancesInput, opts ...request.Option) (*ListDbInstancesOutput, error) {
	req, out := c.ListDbInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDbInstancesPages iterates over the pages of a ListDbInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDbInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDbInstances operation.
//	pageNum := 0
//	err := client.ListDbInstancesPages(params,
//	    func(page *timestreaminfluxdb.ListDbInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *TimestreamInfluxDB) ListDbInstancesPages(input *ListDbInstancesInput, fn func(*ListDbInstancesOutput, bool) bool) error {
	return c.ListDbInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDbInstancesPagesWithContext same as ListDbInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamInfluxDB) ListDbInstancesPagesWithContext(ctx aws.Context, input *ListDbInstancesInput, fn func(*ListDbInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDbInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDbInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDbInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDbParameterGroups = "ListDbParameterGroups"

// ListDbParameterGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListDbParameterGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDbParameterGroups for more information on using the ListDbParameterGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDbParameterGroupsRequest method.
//	req, resp := client.ListDbParameterGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListDbParameterGroups
func (c *TimestreamInfluxDB) ListDbParameterGroupsRequest(input *ListDbParameterGroupsInput) (req *request.Request, output *ListDbParameterGroupsOutput) {
	op := &request.Operation{
		Name:       opListDbParameterGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDbParameterGroupsInput{}
	}

	output = &ListDbParameterGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDbParameterGroups API operation for Timestream InfluxDB.
//
// Returns a list of Timestream for InfluxDB DB parameter groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Timestream InfluxDB's
// API operation ListDbParameterGroups for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Timestream for InfluxDB.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The requested resource was not found or does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListDbParameterGroups
func (c *TimestreamInfluxDB) ListDbParameterGroups(input *ListDbParameterGroupsInput) (*ListDbParameterGroupsOutput, error) {
	req, out := c.ListDbParameterGroupsRequest(input)
	return out, req.Send()
}

// ListDbParameterGroupsWithContext is the same as ListDbParameterGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListDbParameterGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamInfluxDB) ListDbParameterGroupsWithContext(ctx aws.Context, input *ListDbParameterGroupsInput, opts ...request.Option) (*ListDbParameterGroupsOutput, error) {
	req, out := c.ListDbParameterGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDbParameterGroupsPages iterates over the pages of a ListDbParameterGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDbParameterGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDbParameterGroups operation.
//	pageNum := 0
//	err := client.ListDbParameterGroupsPages(params,
//	    func(page *timestreaminfluxdb.ListDbParameterGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *TimestreamInfluxDB) ListDbParameterGroupsPages(input *ListDbParameterGroupsInput, fn func(*ListDbParameterGroupsOutput, bool) bool) error {
	return c.ListDbParameterGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDbParameterGroupsPagesWithContext same as ListDbParameterGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamInfluxDB) ListDbParameterGroupsPagesWithContext(ctx aws.Context, input *ListDbParameterGroupsInput, fn func(*ListDbParameterGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDbParameterGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDbParameterGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDbParameterGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListTagsForResource
func (c *TimestreamInfluxDB) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Timestream InfluxDB.
//
// A list of tags applied to the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Timestream InfluxDB's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundException
//     The requested resource was not found or does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/ListTagsForResource
func (c *TimestreamInfluxDB) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamInfluxDB) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/TagResource
func (c *TimestreamInfluxDB) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Timestream InfluxDB.
//
// Tags are composed of a Key/Value pairs. You can use tags to categorize and
// track your Timestream for InfluxDB resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Timestream InfluxDB's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundException
//     The requested resource was not found or does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/TagResource
func (c *TimestreamInfluxDB) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamInfluxDB) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/UntagResource
func (c *TimestreamInfluxDB) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Timestream InfluxDB.
//
// Removes the tag from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Timestream InfluxDB's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundException
//     The requested resource was not found or does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/UntagResource
func (c *TimestreamInfluxDB) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamInfluxDB) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDbInstance = "UpdateDbInstance"

// UpdateDbInstanceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDbInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDbInstance for more information on using the UpdateDbInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDbInstanceRequest method.
//	req, resp := client.UpdateDbInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/UpdateDbInstance
func (c *TimestreamInfluxDB) UpdateDbInstanceRequest(input *UpdateDbInstanceInput) (req *request.Request, output *UpdateDbInstanceOutput) {
	op := &request.Operation{
		Name:       opUpdateDbInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDbInstanceInput{}
	}

	output = &UpdateDbInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDbInstance API operation for Timestream InfluxDB.
//
// Updates a Timestream for InfluxDB DB instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Timestream InfluxDB's
// API operation UpdateDbInstance for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by Timestream for InfluxDB.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The request conflicts with an existing resource in Timestream for InfluxDB.
//
//   - ResourceNotFoundException
//     The requested resource was not found or does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/timestream-influxdb-2023-01-27/UpdateDbInstance
func (c *TimestreamInfluxDB) UpdateDbInstance(input *UpdateDbInstanceInput) (*UpdateDbInstanceOutput, error) {
	req, out := c.UpdateDbInstanceRequest(input)
	return out, req.Send()
}

// UpdateDbInstanceWithContext is the same as UpdateDbInstance with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDbInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TimestreamInfluxDB) UpdateDbInstanceWithContext(ctx aws.Context, input *UpdateDbInstanceInput, opts ...request.Option) (*UpdateDbInstanceOutput, error) {
	req, out := c.UpdateDbInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request conflicts with an existing resource in Timestream for InfluxDB.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The identifier for the Timestream for InfluxDB resource associated with the
	// request.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of Timestream for InfluxDB resource associated with the request.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateDbInstanceInput struct {
	_ struct{} `type:"structure"`

	// The amount of storage to allocate for your DB storage type in GiB (gibibytes).
	//
	// AllocatedStorage is a required field
	AllocatedStorage *int64 `locationName:"allocatedStorage" min:"20" type:"integer" required:"true"`

	// The name of the initial InfluxDB bucket. All InfluxDB data is stored in a
	// bucket. A bucket combines the concept of a database and a retention period
	// (the duration of time that each data point persists). A bucket belongs to
	// an organization.
	Bucket *string `locationName:"bucket" min:"2" type:"string"`

	// The Timestream for InfluxDB DB instance type to run InfluxDB on.
	//
	// DbInstanceType is a required field
	DbInstanceType *string `locationName:"dbInstanceType" type:"string" required:"true" enum:"DbInstanceType"`

	// The id of the DB parameter group to assign to your DB instance. DB parameter
	// groups specify how the database is configured. For example, DB parameter
	// groups can specify the limit for query concurrency.
	DbParameterGroupIdentifier *string `locationName:"dbParameterGroupIdentifier" min:"3" type:"string"`

	// The Timestream for InfluxDB DB storage type to read and write InfluxDB data.
	//
	// You can choose between 3 different types of provisioned Influx IOPS included
	// storage according to your workloads requirements:
	//
	//    * Influx IO Included 3000 IOPS
	//
	//    * Influx IO Included 12000 IOPS
	//
	//    * Influx IO Included 16000 IOPS
	DbStorageType *string `locationName:"dbStorageType" type:"string" enum:"DbStorageType"`

	// Specifies whether the DB instance will be deployed as a standalone instance
	// or with a Multi-AZ standby for high availability.
	DeploymentType *string `locationName:"deploymentType" type:"string" enum:"DeploymentType"`

	// Configuration for sending InfluxDB engine logs to a specified S3 bucket.
	LogDeliveryConfiguration *LogDeliveryConfiguration `locationName:"logDeliveryConfiguration" type:"structure"`

	// The name that uniquely identifies the DB instance when interacting with the
	// Amazon Timestream for InfluxDB API and CLI commands. This name will also
	// be a prefix included in the endpoint. DB instance names must be unique per
	// customer and per region.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The name of the initial organization for the initial admin user in InfluxDB.
	// An InfluxDB organization is a workspace for a group of users.
	Organization *string `locationName:"organization" min:"1" type:"string"`

	// The password of the initial admin user created in InfluxDB. This password
	// will allow you to access the InfluxDB UI to perform various administrative
	// tasks and also use the InfluxDB CLI to create an operator token. These attributes
	// will be stored in a Secret created in AWS SecretManager in your account.
	//
	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateDbInstanceInput's
	// String and GoString methods.
	//
	// Password is a required field
	Password *string `locationName:"password" min:"8" type:"string" required:"true" sensitive:"true"`

	// Configures the DB instance with a public IP to facilitate access.
	PubliclyAccessible *bool `locationName:"publiclyAccessible" type:"boolean"`

	// A list of key-value pairs to associate with the DB instance.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The username of the initial admin user created in InfluxDB. Must start with
	// a letter and can't end with a hyphen or contain two consecutive hyphens.
	// For example, my-user1. This username will allow you to access the InfluxDB
	// UI to perform various administrative tasks and also use the InfluxDB CLI
	// to create an operator token. These attributes will be stored in a Secret
	// created in Amazon Secrets Manager in your account.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateDbInstanceInput's
	// String and GoString methods.
	Username *string `locationName:"username" min:"1" type:"string" sensitive:"true"`

	// A list of VPC security group IDs to associate with the DB instance.
	//
	// VpcSecurityGroupIds is a required field
	VpcSecurityGroupIds []*string `locationName:"vpcSecurityGroupIds" min:"1" type:"list" required:"true"`

	// A list of VPC subnet IDs to associate with the DB instance. Provide at least
	// two VPC subnet IDs in different availability zones when deploying with a
	// Multi-AZ standby.
	//
	// VpcSubnetIds is a required field
	VpcSubnetIds []*string `locationName:"vpcSubnetIds" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDbInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDbInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDbInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDbInstanceInput"}
	if s.AllocatedStorage == nil {
		invalidParams.Add(request.NewErrParamRequired("AllocatedStorage"))
	}
	if s.AllocatedStorage != nil && *s.AllocatedStorage < 20 {
		invalidParams.Add(request.NewErrParamMinValue("AllocatedStorage", 20))
	}
	if s.Bucket != nil && len(*s.Bucket) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 2))
	}
	if s.DbInstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("DbInstanceType"))
	}
	if s.DbParameterGroupIdentifier != nil && len(*s.DbParameterGroupIdentifier) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DbParameterGroupIdentifier", 3))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Organization != nil && len(*s.Organization) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Organization", 1))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 8))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.VpcSecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcSecurityGroupIds"))
	}
	if s.VpcSecurityGroupIds != nil && len(s.VpcSecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcSecurityGroupIds", 1))
	}
	if s.VpcSubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcSubnetIds"))
	}
	if s.VpcSubnetIds != nil && len(s.VpcSubnetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcSubnetIds", 1))
	}
	if s.LogDeliveryConfiguration != nil {
		if err := s.LogDeliveryConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LogDeliveryConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *CreateDbInstanceInput) SetAllocatedStorage(v int64) *CreateDbInstanceInput {
	s.AllocatedStorage = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CreateDbInstanceInput) SetBucket(v string) *CreateDbInstanceInput {
	s.Bucket = &v
	return s
}

// SetDbInstanceType sets the DbInstanceType field's value.
func (s *CreateDbInstanceInput) SetDbInstanceType(v string) *CreateDbInstanceInput {
	s.DbInstanceType = &v
	return s
}

// SetDbParameterGroupIdentifier sets the DbParameterGroupIdentifier field's value.
func (s *CreateDbInstanceInput) SetDbParameterGroupIdentifier(v string) *CreateDbInstanceInput {
	s.DbParameterGroupIdentifier = &v
	return s
}

// SetDbStorageType sets the DbStorageType field's value.
func (s *CreateDbInstanceInput) SetDbStorageType(v string) *CreateDbInstanceInput {
	s.DbStorageType = &v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *CreateDbInstanceInput) SetDeploymentType(v string) *CreateDbInstanceInput {
	s.DeploymentType = &v
	return s
}

// SetLogDeliveryConfiguration sets the LogDeliveryConfiguration field's value.
func (s *CreateDbInstanceInput) SetLogDeliveryConfiguration(v *LogDeliveryConfiguration) *CreateDbInstanceInput {
	s.LogDeliveryConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDbInstanceInput) SetName(v string) *CreateDbInstanceInput {
	s.Name = &v
	return s
}

// SetOrganization sets the Organization field's value.
func (s *CreateDbInstanceInput) SetOrganization(v string) *CreateDbInstanceInput {
	s.Organization = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *CreateDbInstanceInput) SetPassword(v string) *CreateDbInstanceInput {
	s.Password = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *CreateDbInstanceInput) SetPubliclyAccessible(v bool) *CreateDbInstanceInput {
	s.PubliclyAccessible = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDbInstanceInput) SetTags(v map[string]*string) *CreateDbInstanceInput {
	s.Tags = v
	return s
}

// SetUsername sets the Username field's value.
func (s *CreateDbInstanceInput) SetUsername(v string) *CreateDbInstanceInput {
	s.Username = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *CreateDbInstanceInput) SetVpcSecurityGroupIds(v []*string) *CreateDbInstanceInput {
	s.VpcSecurityGroupIds = v
	return s
}

// SetVpcSubnetIds sets the VpcSubnetIds field's value.
func (s *CreateDbInstanceInput) SetVpcSubnetIds(v []*string) *CreateDbInstanceInput {
	s.VpcSubnetIds = v
	return s
}

type CreateDbInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The amount of storage allocated for your DB storage type (in gibibytes).
	AllocatedStorage *int64 `locationName:"allocatedStorage" min:"20" type:"integer"`

	// The Amazon Resource Name (ARN) of the DB instance.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The Availability Zone in which the DB instance resides.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The Timestream for InfluxDB instance type that InfluxDB runs on.
	DbInstanceType *string `locationName:"dbInstanceType" type:"string" enum:"DbInstanceType"`

	// The id of the DB parameter group assigned to your DB instance.
	DbParameterGroupIdentifier *string `locationName:"dbParameterGroupIdentifier" min:"3" type:"string"`

	// The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
	DbStorageType *string `locationName:"dbStorageType" type:"string" enum:"DbStorageType"`

	// Specifies whether the Timestream for InfluxDB is deployed as Single-AZ or
	// with a MultiAZ Standby for High availability.
	DeploymentType *string `locationName:"deploymentType" type:"string" enum:"DeploymentType"`

	// The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
	Endpoint *string `locationName:"endpoint" type:"string"`

	// A service-generated unique identifier.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"3" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the AWS Secrets Manager secret containing
	// the initial InfluxDB authorization parameters. The secret value is a JSON
	// formatted key-value pair holding InfluxDB authorization values: organization,
	// bucket, username, and password.
	InfluxAuthParametersSecretArn *string `locationName:"influxAuthParametersSecretArn" type:"string"`

	// Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
	LogDeliveryConfiguration *LogDeliveryConfiguration `locationName:"logDeliveryConfiguration" type:"structure"`

	// The customer-supplied name that uniquely identifies the DB instance when
	// interacting with the Amazon Timestream for InfluxDB API and CLI commands.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// Indicates if the DB instance has a public IP to facilitate access.
	PubliclyAccessible *bool `locationName:"publiclyAccessible" type:"boolean"`

	// The Availability Zone in which the standby instance is located when deploying
	// with a MultiAZ standby instance.
	SecondaryAvailabilityZone *string `locationName:"secondaryAvailabilityZone" type:"string"`

	// The status of the DB instance.
	Status *string `locationName:"status" type:"string" enum:"Status"`

	// A list of VPC security group IDs associated with the DB instance.
	VpcSecurityGroupIds []*string `locationName:"vpcSecurityGroupIds" min:"1" type:"list"`

	// A list of VPC subnet IDs associated with the DB instance.
	//
	// VpcSubnetIds is a required field
	VpcSubnetIds []*string `locationName:"vpcSubnetIds" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDbInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDbInstanceOutput) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *CreateDbInstanceOutput) SetAllocatedStorage(v int64) *CreateDbInstanceOutput {
	s.AllocatedStorage = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *CreateDbInstanceOutput) SetArn(v string) *CreateDbInstanceOutput {
	s.Arn = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateDbInstanceOutput) SetAvailabilityZone(v string) *CreateDbInstanceOutput {
	s.AvailabilityZone = &v
	return s
}

// SetDbInstanceType sets the DbInstanceType field's value.
func (s *CreateDbInstanceOutput) SetDbInstanceType(v string) *CreateDbInstanceOutput {
	s.DbInstanceType = &v
	return s
}

// SetDbParameterGroupIdentifier sets the DbParameterGroupIdentifier field's value.
func (s *CreateDbInstanceOutput) SetDbParameterGroupIdentifier(v string) *CreateDbInstanceOutput {
	s.DbParameterGroupIdentifier = &v
	return s
}

// SetDbStorageType sets the DbStorageType field's value.
func (s *CreateDbInstanceOutput) SetDbStorageType(v string) *CreateDbInstanceOutput {
	s.DbStorageType = &v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *CreateDbInstanceOutput) SetDeploymentType(v string) *CreateDbInstanceOutput {
	s.DeploymentType = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *CreateDbInstanceOutput) SetEndpoint(v string) *CreateDbInstanceOutput {
	s.Endpoint = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateDbInstanceOutput) SetId(v string) *CreateDbInstanceOutput {
	s.Id = &v
	return s
}

// SetInfluxAuthParametersSecretArn sets the InfluxAuthParametersSecretArn field's value.
func (s *CreateDbInstanceOutput) SetInfluxAuthParametersSecretArn(v string) *CreateDbInstanceOutput {
	s.InfluxAuthParametersSecretArn = &v
	return s
}

// SetLogDeliveryConfiguration sets the LogDeliveryConfiguration field's value.
func (s *CreateDbInstanceOutput) SetLogDeliveryConfiguration(v *LogDeliveryConfiguration) *CreateDbInstanceOutput {
	s.LogDeliveryConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDbInstanceOutput) SetName(v string) *CreateDbInstanceOutput {
	s.Name = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *CreateDbInstanceOutput) SetPubliclyAccessible(v bool) *CreateDbInstanceOutput {
	s.PubliclyAccessible = &v
	return s
}

// SetSecondaryAvailabilityZone sets the SecondaryAvailabilityZone field's value.
func (s *CreateDbInstanceOutput) SetSecondaryAvailabilityZone(v string) *CreateDbInstanceOutput {
	s.SecondaryAvailabilityZone = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDbInstanceOutput) SetStatus(v string) *CreateDbInstanceOutput {
	s.Status = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *CreateDbInstanceOutput) SetVpcSecurityGroupIds(v []*string) *CreateDbInstanceOutput {
	s.VpcSecurityGroupIds = v
	return s
}

// SetVpcSubnetIds sets the VpcSubnetIds field's value.
func (s *CreateDbInstanceOutput) SetVpcSubnetIds(v []*string) *CreateDbInstanceOutput {
	s.VpcSubnetIds = v
	return s
}

type CreateDbParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// A description of the DB parameter group.
	Description *string `locationName:"description" type:"string"`

	// The name of the DB parameter group. The name must be unique per customer
	// and per region.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// A list of the parameters that comprise the DB parameter group.
	Parameters *Parameters `locationName:"parameters" type:"structure"`

	// A list of key-value pairs to associate with the DB parameter group.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDbParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDbParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDbParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDbParameterGroupInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateDbParameterGroupInput) SetDescription(v string) *CreateDbParameterGroupInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDbParameterGroupInput) SetName(v string) *CreateDbParameterGroupInput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateDbParameterGroupInput) SetParameters(v *Parameters) *CreateDbParameterGroupInput {
	s.Parameters = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDbParameterGroupInput) SetTags(v map[string]*string) *CreateDbParameterGroupInput {
	s.Tags = v
	return s
}

type CreateDbParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARM) of the DB parameter group.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The description of the DB parameter group.
	Description *string `locationName:"description" type:"string"`

	// A service-generated unique identifier.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"3" type:"string" required:"true"`

	// The customer-supplied name that uniquely identifies the DB parameter group
	// when interacting with the Amazon Timestream for InfluxDB API and CLI commands.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// A list of the parameters that comprise the DB parameter group.
	Parameters *Parameters `locationName:"parameters" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDbParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDbParameterGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDbParameterGroupOutput) SetArn(v string) *CreateDbParameterGroupOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDbParameterGroupOutput) SetDescription(v string) *CreateDbParameterGroupOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateDbParameterGroupOutput) SetId(v string) *CreateDbParameterGroupOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDbParameterGroupOutput) SetName(v string) *CreateDbParameterGroupOutput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateDbParameterGroupOutput) SetParameters(v *Parameters) *CreateDbParameterGroupOutput {
	s.Parameters = v
	return s
}

// Contains a summary of a DB instance.
type DbInstanceSummary struct {
	_ struct{} `type:"structure"`

	// The amount of storage to allocate for your DbStorageType in GiB (gibibytes).
	AllocatedStorage *int64 `locationName:"allocatedStorage" min:"20" type:"integer"`

	// The Amazon Resource Name (ARN) of the DB instance.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The Timestream for InfluxDB instance type to run InfluxDB on.
	DbInstanceType *string `locationName:"dbInstanceType" type:"string" enum:"DbInstanceType"`

	// The storage type for your DB instance.
	DbStorageType *string `locationName:"dbStorageType" type:"string" enum:"DbStorageType"`

	// Single-Instance or with a MultiAZ Standby for High availability.
	DeploymentType *string `locationName:"deploymentType" type:"string" enum:"DeploymentType"`

	// The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
	Endpoint *string `locationName:"endpoint" type:"string"`

	// The service-generated unique identifier of the DB instance.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"3" type:"string" required:"true"`

	// This customer-supplied name uniquely identifies the DB instance when interacting
	// with the Amazon Timestream for InfluxDB API and AWS CLI commands.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The status of the DB instance.
	Status *string `locationName:"status" type:"string" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DbInstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DbInstanceSummary) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *DbInstanceSummary) SetAllocatedStorage(v int64) *DbInstanceSummary {
	s.AllocatedStorage = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *DbInstanceSummary) SetArn(v string) *DbInstanceSummary {
	s.Arn = &v
	return s
}

// SetDbInstanceType sets the DbInstanceType field's value.
func (s *DbInstanceSummary) SetDbInstanceType(v string) *DbInstanceSummary {
	s.DbInstanceType = &v
	return s
}

// SetDbStorageType sets the DbStorageType field's value.
func (s *DbInstanceSummary) SetDbStorageType(v string) *DbInstanceSummary {
	s.DbStorageType = &v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *DbInstanceSummary) SetDeploymentType(v string) *DbInstanceSummary {
	s.DeploymentType = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *DbInstanceSummary) SetEndpoint(v string) *DbInstanceSummary {
	s.Endpoint = &v
	return s
}

// SetId sets the Id field's value.
func (s *DbInstanceSummary) SetId(v string) *DbInstanceSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *DbInstanceSummary) SetName(v string) *DbInstanceSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DbInstanceSummary) SetStatus(v string) *DbInstanceSummary {
	s.Status = &v
	return s
}

// Contains a summary of a DB parameter group.
type DbParameterGroupSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the DB parameter group.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// A description of the DB parameter group.
	Description *string `locationName:"description" type:"string"`

	// A service-generated unique identifier.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"3" type:"string" required:"true"`

	// This customer-supplied name uniquely identifies the parameter group.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DbParameterGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DbParameterGroupSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DbParameterGroupSummary) SetArn(v string) *DbParameterGroupSummary {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DbParameterGroupSummary) SetDescription(v string) *DbParameterGroupSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *DbParameterGroupSummary) SetId(v string) *DbParameterGroupSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *DbParameterGroupSummary) SetName(v string) *DbParameterGroupSummary {
	s.Name = &v
	return s
}

type DeleteDbInstanceInput struct {
	_ struct{} `type:"structure"`

	// The id of the DB instance.
	//
	// Identifier is a required field
	Identifier *string `locationName:"identifier" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDbInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDbInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDbInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDbInstanceInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteDbInstanceInput) SetIdentifier(v string) *DeleteDbInstanceInput {
	s.Identifier = &v
	return s
}

type DeleteDbInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The amount of storage allocated for your DB storage type (in gibibytes).
	AllocatedStorage *int64 `locationName:"allocatedStorage" min:"20" type:"integer"`

	// The Amazon Resource Name (ARN) of the DB instance.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The Availability Zone in which the DB instance resides.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The Timestream for InfluxDB instance type that InfluxDB runs on.
	DbInstanceType *string `locationName:"dbInstanceType" type:"string" enum:"DbInstanceType"`

	// The id of the DB parameter group assigned to your DB instance.
	DbParameterGroupIdentifier *string `locationName:"dbParameterGroupIdentifier" min:"3" type:"string"`

	// The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
	DbStorageType *string `locationName:"dbStorageType" type:"string" enum:"DbStorageType"`

	// Specifies whether the Timestream for InfluxDB is deployed as Single-AZ or
	// with a MultiAZ Standby for High availability.
	DeploymentType *string `locationName:"deploymentType" type:"string" enum:"DeploymentType"`

	// The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
	Endpoint *string `locationName:"endpoint" type:"string"`

	// A service-generated unique identifier.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"3" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the AWS Secrets Manager secret containing
	// the initial InfluxDB authorization parameters. The secret value is a JSON
	// formatted key-value pair holding InfluxDB authorization values: organization,
	// bucket, username, and password.
	InfluxAuthParametersSecretArn *string `locationName:"influxAuthParametersSecretArn" type:"string"`

	// Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
	LogDeliveryConfiguration *LogDeliveryConfiguration `locationName:"logDeliveryConfiguration" type:"structure"`

	// The customer-supplied name that uniquely identifies the DB instance when
	// interacting with the Amazon Timestream for InfluxDB API and CLI commands.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// Indicates if the DB instance has a public IP to facilitate access.
	PubliclyAccessible *bool `locationName:"publiclyAccessible" type:"boolean"`

	// The Availability Zone in which the standby instance is located when deploying
	// with a MultiAZ standby instance.
	SecondaryAvailabilityZone *string `locationName:"secondaryAvailabilityZone" type:"string"`

	// The status of the DB instance.
	Status *string `locationName:"status" type:"string" enum:"Status"`

	// A list of VPC security group IDs associated with the DB instance.
	VpcSecurityGroupIds []*string `locationName:"vpcSecurityGroupIds" min:"1" type:"list"`

	// A list of VPC subnet IDs associated with the DB instance.
	//
	// VpcSubnetIds is a required field
	VpcSubnetIds []*string `locationName:"vpcSubnetIds" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDbInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDbInstanceOutput) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *DeleteDbInstanceOutput) SetAllocatedStorage(v int64) *DeleteDbInstanceOutput {
	s.AllocatedStorage = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *DeleteDbInstanceOutput) SetArn(v string) *DeleteDbInstanceOutput {
	s.Arn = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *DeleteDbInstanceOutput) SetAvailabilityZone(v string) *DeleteDbInstanceOutput {
	s.AvailabilityZone = &v
	return s
}

// SetDbInstanceType sets the DbInstanceType field's value.
func (s *DeleteDbInstanceOutput) SetDbInstanceType(v string) *DeleteDbInstanceOutput {
	s.DbInstanceType = &v
	return s
}

// SetDbParameterGroupIdentifier sets the DbParameterGroupIdentifier field's value.
func (s *DeleteDbInstanceOutput) SetDbParameterGroupIdentifier(v string) *DeleteDbInstanceOutput {
	s.DbParameterGroupIdentifier = &v
	return s
}

// SetDbStorageType sets the DbStorageType field's value.
func (s *DeleteDbInstanceOutput) SetDbStorageType(v string) *DeleteDbInstanceOutput {
	s.DbStorageType = &v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *DeleteDbInstanceOutput) SetDeploymentType(v string) *DeleteDbInstanceOutput {
	s.DeploymentType = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *DeleteDbInstanceOutput) SetEndpoint(v string) *DeleteDbInstanceOutput {
	s.Endpoint = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteDbInstanceOutput) SetId(v string) *DeleteDbInstanceOutput {
	s.Id = &v
	return s
}

// SetInfluxAuthParametersSecretArn sets the InfluxAuthParametersSecretArn field's value.
func (s *DeleteDbInstanceOutput) SetInfluxAuthParametersSecretArn(v string) *DeleteDbInstanceOutput {
	s.InfluxAuthParametersSecretArn = &v
	return s
}

// SetLogDeliveryConfiguration sets the LogDeliveryConfiguration field's value.
func (s *DeleteDbInstanceOutput) SetLogDeliveryConfiguration(v *LogDeliveryConfiguration) *DeleteDbInstanceOutput {
	s.LogDeliveryConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteDbInstanceOutput) SetName(v string) *DeleteDbInstanceOutput {
	s.Name = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *DeleteDbInstanceOutput) SetPubliclyAccessible(v bool) *DeleteDbInstanceOutput {
	s.PubliclyAccessible = &v
	return s
}

// SetSecondaryAvailabilityZone sets the SecondaryAvailabilityZone field's value.
func (s *DeleteDbInstanceOutput) SetSecondaryAvailabilityZone(v string) *DeleteDbInstanceOutput {
	s.SecondaryAvailabilityZone = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteDbInstanceOutput) SetStatus(v string) *DeleteDbInstanceOutput {
	s.Status = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *DeleteDbInstanceOutput) SetVpcSecurityGroupIds(v []*string) *DeleteDbInstanceOutput {
	s.VpcSecurityGroupIds = v
	return s
}

// SetVpcSubnetIds sets the VpcSubnetIds field's value.
func (s *DeleteDbInstanceOutput) SetVpcSubnetIds(v []*string) *DeleteDbInstanceOutput {
	s.VpcSubnetIds = v
	return s
}

type GetDbInstanceInput struct {
	_ struct{} `type:"structure"`

	// The id of the DB instance.
	//
	// Identifier is a required field
	Identifier *string `locationName:"identifier" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDbInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDbInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDbInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDbInstanceInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetDbInstanceInput) SetIdentifier(v string) *GetDbInstanceInput {
	s.Identifier = &v
	return s
}

type GetDbInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The amount of storage allocated for your DB storage type (in gibibytes).
	AllocatedStorage *int64 `locationName:"allocatedStorage" min:"20" type:"integer"`

	// The Amazon Resource Name (ARN) of the DB instance.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The Availability Zone in which the DB instance resides.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The Timestream for InfluxDB instance type that InfluxDB runs on.
	DbInstanceType *string `locationName:"dbInstanceType" type:"string" enum:"DbInstanceType"`

	// The id of the DB parameter group assigned to your DB instance.
	DbParameterGroupIdentifier *string `locationName:"dbParameterGroupIdentifier" min:"3" type:"string"`

	// The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
	DbStorageType *string `locationName:"dbStorageType" type:"string" enum:"DbStorageType"`

	// Specifies whether the Timestream for InfluxDB is deployed as Single-AZ or
	// with a MultiAZ Standby for High availability.
	DeploymentType *string `locationName:"deploymentType" type:"string" enum:"DeploymentType"`

	// The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
	Endpoint *string `locationName:"endpoint" type:"string"`

	// A service-generated unique identifier.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"3" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the AWS Secrets Manager secret containing
	// the initial InfluxDB authorization parameters. The secret value is a JSON
	// formatted key-value pair holding InfluxDB authorization values: organization,
	// bucket, username, and password.
	InfluxAuthParametersSecretArn *string `locationName:"influxAuthParametersSecretArn" type:"string"`

	// Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
	LogDeliveryConfiguration *LogDeliveryConfiguration `locationName:"logDeliveryConfiguration" type:"structure"`

	// The customer-supplied name that uniquely identifies the DB instance when
	// interacting with the Amazon Timestream for InfluxDB API and CLI commands.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// Indicates if the DB instance has a public IP to facilitate access.
	PubliclyAccessible *bool `locationName:"publiclyAccessible" type:"boolean"`

	// The Availability Zone in which the standby instance is located when deploying
	// with a MultiAZ standby instance.
	SecondaryAvailabilityZone *string `locationName:"secondaryAvailabilityZone" type:"string"`

	// The status of the DB instance.
	Status *string `locationName:"status" type:"string" enum:"Status"`

	// A list of VPC security group IDs associated with the DB instance.
	VpcSecurityGroupIds []*string `locationName:"vpcSecurityGroupIds" min:"1" type:"list"`

	// A list of VPC subnet IDs associated with the DB instance.
	//
	// VpcSubnetIds is a required field
	VpcSubnetIds []*string `locationName:"vpcSubnetIds" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDbInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDbInstanceOutput) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *GetDbInstanceOutput) SetAllocatedStorage(v int64) *GetDbInstanceOutput {
	s.AllocatedStorage = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *GetDbInstanceOutput) SetArn(v string) *GetDbInstanceOutput {
	s.Arn = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *GetDbInstanceOutput) SetAvailabilityZone(v string) *GetDbInstanceOutput {
	s.AvailabilityZone = &v
	return s
}

// SetDbInstanceType sets the DbInstanceType field's value.
func (s *GetDbInstanceOutput) SetDbInstanceType(v string) *GetDbInstanceOutput {
	s.DbInstanceType = &v
	return s
}

// SetDbParameterGroupIdentifier sets the DbParameterGroupIdentifier field's value.
func (s *GetDbInstanceOutput) SetDbParameterGroupIdentifier(v string) *GetDbInstanceOutput {
	s.DbParameterGroupIdentifier = &v
	return s
}

// SetDbStorageType sets the DbStorageType field's value.
func (s *GetDbInstanceOutput) SetDbStorageType(v string) *GetDbInstanceOutput {
	s.DbStorageType = &v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *GetDbInstanceOutput) SetDeploymentType(v string) *GetDbInstanceOutput {
	s.DeploymentType = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *GetDbInstanceOutput) SetEndpoint(v string) *GetDbInstanceOutput {
	s.Endpoint = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetDbInstanceOutput) SetId(v string) *GetDbInstanceOutput {
	s.Id = &v
	return s
}

// SetInfluxAuthParametersSecretArn sets the InfluxAuthParametersSecretArn field's value.
func (s *GetDbInstanceOutput) SetInfluxAuthParametersSecretArn(v string) *GetDbInstanceOutput {
	s.InfluxAuthParametersSecretArn = &v
	return s
}

// SetLogDeliveryConfiguration sets the LogDeliveryConfiguration field's value.
func (s *GetDbInstanceOutput) SetLogDeliveryConfiguration(v *LogDeliveryConfiguration) *GetDbInstanceOutput {
	s.LogDeliveryConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *GetDbInstanceOutput) SetName(v string) *GetDbInstanceOutput {
	s.Name = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *GetDbInstanceOutput) SetPubliclyAccessible(v bool) *GetDbInstanceOutput {
	s.PubliclyAccessible = &v
	return s
}

// SetSecondaryAvailabilityZone sets the SecondaryAvailabilityZone field's value.
func (s *GetDbInstanceOutput) SetSecondaryAvailabilityZone(v string) *GetDbInstanceOutput {
	s.SecondaryAvailabilityZone = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDbInstanceOutput) SetStatus(v string) *GetDbInstanceOutput {
	s.Status = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *GetDbInstanceOutput) SetVpcSecurityGroupIds(v []*string) *GetDbInstanceOutput {
	s.VpcSecurityGroupIds = v
	return s
}

// SetVpcSubnetIds sets the VpcSubnetIds field's value.
func (s *GetDbInstanceOutput) SetVpcSubnetIds(v []*string) *GetDbInstanceOutput {
	s.VpcSubnetIds = v
	return s
}

type GetDbParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The id of the DB parameter group.
	//
	// Identifier is a required field
	Identifier *string `locationName:"identifier" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDbParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDbParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDbParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDbParameterGroupInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetDbParameterGroupInput) SetIdentifier(v string) *GetDbParameterGroupInput {
	s.Identifier = &v
	return s
}

type GetDbParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the DB parameter group.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// A description of the DB parameter group.
	Description *string `locationName:"description" type:"string"`

	// A service-generated unique identifier.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"3" type:"string" required:"true"`

	// The customer-supplied name that uniquely identifies the DB parameter group
	// when interacting with the Amazon Timestream for InfluxDB API and CLI commands.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The parameters that comprise the DB parameter group.
	Parameters *Parameters `locationName:"parameters" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDbParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDbParameterGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetDbParameterGroupOutput) SetArn(v string) *GetDbParameterGroupOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetDbParameterGroupOutput) SetDescription(v string) *GetDbParameterGroupOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetDbParameterGroupOutput) SetId(v string) *GetDbParameterGroupOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDbParameterGroupOutput) SetName(v string) *GetDbParameterGroupOutput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *GetDbParameterGroupOutput) SetParameters(v *Parameters) *GetDbParameterGroupOutput {
	s.Parameters = v
	return s
}

// All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
type InfluxDBv2Parameters struct {
	_ struct{} `type:"structure"`

	// Include option to show detailed logs for Flux queries.
	//
	// Default: false
	FluxLogEnabled *bool `locationName:"fluxLogEnabled" type:"boolean"`

	// Log output level. InfluxDB outputs log entries with severity levels greater
	// than or equal to the level specified.
	//
	// Default: info
	LogLevel *string `locationName:"logLevel" type:"string" enum:"LogLevel"`

	// Disable the HTTP /metrics endpoint which exposes internal InfluxDB metrics
	// (https://docs.influxdata.com/influxdb/v2/reference/internals/metrics/).
	//
	// Default: false
	MetricsDisabled *bool `locationName:"metricsDisabled" type:"boolean"`

	// Disable the task scheduler. If problematic tasks prevent InfluxDB from starting,
	// use this option to start InfluxDB without scheduling or executing tasks.
	//
	// Default: false
	NoTasks *bool `locationName:"noTasks" type:"boolean"`

	// Number of queries allowed to execute concurrently. Setting to 0 allows an
	// unlimited number of concurrent queries.
	//
	// Default: 0
	QueryConcurrency *int64 `locationName:"queryConcurrency" type:"integer"`

	// Maximum number of queries allowed in execution queue. When queue limit is
	// reached, new queries are rejected. Setting to 0 allows an unlimited number
	// of queries in the queue.
	//
	// Default: 0
	QueryQueueSize *int64 `locationName:"queryQueueSize" type:"integer"`

	// Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled
	// by default.
	TracingType *string `locationName:"tracingType" type:"string" enum:"TracingType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InfluxDBv2Parameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InfluxDBv2Parameters) GoString() string {
	return s.String()
}

// SetFluxLogEnabled sets the FluxLogEnabled field's value.
func (s *InfluxDBv2Parameters) SetFluxLogEnabled(v bool) *InfluxDBv2Parameters {
	s.FluxLogEnabled = &v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *InfluxDBv2Parameters) SetLogLevel(v string) *InfluxDBv2Parameters {
	s.LogLevel = &v
	return s
}

// SetMetricsDisabled sets the MetricsDisabled field's value.
func (s *InfluxDBv2Parameters) SetMetricsDisabled(v bool) *InfluxDBv2Parameters {
	s.MetricsDisabled = &v
	return s
}

// SetNoTasks sets the NoTasks field's value.
func (s *InfluxDBv2Parameters) SetNoTasks(v bool) *InfluxDBv2Parameters {
	s.NoTasks = &v
	return s
}

// SetQueryConcurrency sets the QueryConcurrency field's value.
func (s *InfluxDBv2Parameters) SetQueryConcurrency(v int64) *InfluxDBv2Parameters {
	s.QueryConcurrency = &v
	return s
}

// SetQueryQueueSize sets the QueryQueueSize field's value.
func (s *InfluxDBv2Parameters) SetQueryQueueSize(v int64) *InfluxDBv2Parameters {
	s.QueryQueueSize = &v
	return s
}

// SetTracingType sets the TracingType field's value.
func (s *InfluxDBv2Parameters) SetTracingType(v string) *InfluxDBv2Parameters {
	s.TracingType = &v
	return s
}

// The request processing has failed because of an unknown error, exception
// or failure.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDbInstancesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return in the output. If the total number
	// of items available is more than the value specified, a NextToken is provided
	// in the output. To resume pagination, provide the NextToken value as argument
	// of a subsequent API invocation.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token. To resume pagination, provide the NextToken value as
	// argument of a subsequent API invocation.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDbInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDbInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDbInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDbInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDbInstancesInput) SetMaxResults(v int64) *ListDbInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDbInstancesInput) SetNextToken(v string) *ListDbInstancesInput {
	s.NextToken = &v
	return s
}

type ListDbInstancesOutput struct {
	_ struct{} `type:"structure"`

	// A list of Timestream for InfluxDB DB instance summaries.
	//
	// Items is a required field
	Items []*DbInstanceSummary `locationName:"items" type:"list" required:"true"`

	// Token from a previous call of the operation. When this value is provided,
	// the service returns results from where the previous response left off.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDbInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDbInstancesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListDbInstancesOutput) SetItems(v []*DbInstanceSummary) *ListDbInstancesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDbInstancesOutput) SetNextToken(v string) *ListDbInstancesOutput {
	s.NextToken = &v
	return s
}

type ListDbParameterGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return in the output. If the total number
	// of items available is more than the value specified, a NextToken is provided
	// in the output. To resume pagination, provide the NextToken value as argument
	// of a subsequent API invocation.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token. To resume pagination, provide the NextToken value as
	// argument of a subsequent API invocation.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDbParameterGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDbParameterGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDbParameterGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDbParameterGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDbParameterGroupsInput) SetMaxResults(v int64) *ListDbParameterGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDbParameterGroupsInput) SetNextToken(v string) *ListDbParameterGroupsInput {
	s.NextToken = &v
	return s
}

type ListDbParameterGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of Timestream for InfluxDB DB parameter group summaries.
	//
	// Items is a required field
	Items []*DbParameterGroupSummary `locationName:"items" type:"list" required:"true"`

	// Token from a previous call of the operation. When this value is provided,
	// the service returns results from where the previous response left off.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDbParameterGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDbParameterGroupsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListDbParameterGroupsOutput) SetItems(v []*DbParameterGroupSummary) *ListDbParameterGroupsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDbParameterGroupsOutput) SetNextToken(v string) *ListDbParameterGroupsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the tagged resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags used to categorize and track resources.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
type LogDeliveryConfiguration struct {
	_ struct{} `type:"structure"`

	// Configuration for S3 bucket log delivery.
	//
	// S3Configuration is a required field
	S3Configuration *S3Configuration `locationName:"s3Configuration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogDeliveryConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogDeliveryConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogDeliveryConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LogDeliveryConfiguration"}
	if s.S3Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Configuration"))
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *LogDeliveryConfiguration) SetS3Configuration(v *S3Configuration) *LogDeliveryConfiguration {
	s.S3Configuration = v
	return s
}

// The parameters that comprise the parameter group.
type Parameters struct {
	_ struct{} `type:"structure"`

	// All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
	InfluxDBv2 *InfluxDBv2Parameters `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Parameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Parameters) GoString() string {
	return s.String()
}

// SetInfluxDBv2 sets the InfluxDBv2 field's value.
func (s *Parameters) SetInfluxDBv2(v *InfluxDBv2Parameters) *Parameters {
	s.InfluxDBv2 = v
	return s
}

// The requested resource was not found or does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The identifier for the Timestream for InfluxDB resource associated with the
	// request.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of Timestream for InfluxDB resource associated with the request.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Configuration for S3 bucket log delivery.
type S3Configuration struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket to deliver logs to.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"3" type:"string" required:"true"`

	// Indicates whether log delivery to the S3 bucket is enabled.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Configuration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Configuration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Configuration"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3Configuration) SetBucketName(v string) *S3Configuration {
	s.BucketName = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *S3Configuration) SetEnabled(v bool) *S3Configuration {
	s.Enabled = &v
	return s
}

// The request exceeds the service quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the tagged resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A list of tags used to categorize and track resources.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The number of seconds the caller should wait before retrying.
	RetryAfterSeconds *int64 `locationName:"retryAfterSeconds" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the tagged resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The keys used to identify the tags.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDbInstanceInput struct {
	_ struct{} `type:"structure"`

	// The id of the DB parameter group to assign to your DB instance. DB parameter
	// groups specify how the database is configured. For example, DB parameter
	// groups can specify the limit for query concurrency.
	DbParameterGroupIdentifier *string `locationName:"dbParameterGroupIdentifier" min:"3" type:"string"`

	// The id of the DB instance.
	//
	// Identifier is a required field
	Identifier *string `locationName:"identifier" min:"3" type:"string" required:"true"`

	// Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
	LogDeliveryConfiguration *LogDeliveryConfiguration `locationName:"logDeliveryConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDbInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDbInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDbInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDbInstanceInput"}
	if s.DbParameterGroupIdentifier != nil && len(*s.DbParameterGroupIdentifier) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DbParameterGroupIdentifier", 3))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 3))
	}
	if s.LogDeliveryConfiguration != nil {
		if err := s.LogDeliveryConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LogDeliveryConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDbParameterGroupIdentifier sets the DbParameterGroupIdentifier field's value.
func (s *UpdateDbInstanceInput) SetDbParameterGroupIdentifier(v string) *UpdateDbInstanceInput {
	s.DbParameterGroupIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *UpdateDbInstanceInput) SetIdentifier(v string) *UpdateDbInstanceInput {
	s.Identifier = &v
	return s
}

// SetLogDeliveryConfiguration sets the LogDeliveryConfiguration field's value.
func (s *UpdateDbInstanceInput) SetLogDeliveryConfiguration(v *LogDeliveryConfiguration) *UpdateDbInstanceInput {
	s.LogDeliveryConfiguration = v
	return s
}

type UpdateDbInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The amount of storage allocated for your DB storage type (in gibibytes).
	AllocatedStorage *int64 `locationName:"allocatedStorage" min:"20" type:"integer"`

	// The Amazon Resource Name (ARN) of the DB instance.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The Availability Zone in which the DB instance resides.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The Timestream for InfluxDB instance type that InfluxDB runs on.
	DbInstanceType *string `locationName:"dbInstanceType" type:"string" enum:"DbInstanceType"`

	// The id of the DB parameter group assigned to your DB instance.
	DbParameterGroupIdentifier *string `locationName:"dbParameterGroupIdentifier" min:"3" type:"string"`

	// The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
	DbStorageType *string `locationName:"dbStorageType" type:"string" enum:"DbStorageType"`

	// Specifies whether the Timestream for InfluxDB is deployed as Single-AZ or
	// with a MultiAZ Standby for High availability.
	DeploymentType *string `locationName:"deploymentType" type:"string" enum:"DeploymentType"`

	// The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
	Endpoint *string `locationName:"endpoint" type:"string"`

	// A service-generated unique identifier.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"3" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the AWS Secrets Manager secret containing
	// the initial InfluxDB authorization parameters. The secret value is a JSON
	// formatted key-value pair holding InfluxDB authorization values: organization,
	// bucket, username, and password.
	InfluxAuthParametersSecretArn *string `locationName:"influxAuthParametersSecretArn" type:"string"`

	// Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
	LogDeliveryConfiguration *LogDeliveryConfiguration `locationName:"logDeliveryConfiguration" type:"structure"`

	// This customer-supplied name uniquely identifies the DB instance when interacting
	// with the Amazon Timestream for InfluxDB API and AWS CLI commands.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// Indicates if the DB instance has a public IP to facilitate access.
	PubliclyAccessible *bool `locationName:"publiclyAccessible" type:"boolean"`

	// The Availability Zone in which the standby instance is located when deploying
	// with a MultiAZ standby instance.
	SecondaryAvailabilityZone *string `locationName:"secondaryAvailabilityZone" type:"string"`

	// The status of the DB instance.
	Status *string `locationName:"status" type:"string" enum:"Status"`

	// A list of VPC security group IDs associated with the DB instance.
	VpcSecurityGroupIds []*string `locationName:"vpcSecurityGroupIds" min:"1" type:"list"`

	// A list of VPC subnet IDs associated with the DB instance.
	//
	// VpcSubnetIds is a required field
	VpcSubnetIds []*string `locationName:"vpcSubnetIds" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDbInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDbInstanceOutput) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *UpdateDbInstanceOutput) SetAllocatedStorage(v int64) *UpdateDbInstanceOutput {
	s.AllocatedStorage = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *UpdateDbInstanceOutput) SetArn(v string) *UpdateDbInstanceOutput {
	s.Arn = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *UpdateDbInstanceOutput) SetAvailabilityZone(v string) *UpdateDbInstanceOutput {
	s.AvailabilityZone = &v
	return s
}

// SetDbInstanceType sets the DbInstanceType field's value.
func (s *UpdateDbInstanceOutput) SetDbInstanceType(v string) *UpdateDbInstanceOutput {
	s.DbInstanceType = &v
	return s
}

// SetDbParameterGroupIdentifier sets the DbParameterGroupIdentifier field's value.
func (s *UpdateDbInstanceOutput) SetDbParameterGroupIdentifier(v string) *UpdateDbInstanceOutput {
	s.DbParameterGroupIdentifier = &v
	return s
}

// SetDbStorageType sets the DbStorageType field's value.
func (s *UpdateDbInstanceOutput) SetDbStorageType(v string) *UpdateDbInstanceOutput {
	s.DbStorageType = &v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *UpdateDbInstanceOutput) SetDeploymentType(v string) *UpdateDbInstanceOutput {
	s.DeploymentType = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *UpdateDbInstanceOutput) SetEndpoint(v string) *UpdateDbInstanceOutput {
	s.Endpoint = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateDbInstanceOutput) SetId(v string) *UpdateDbInstanceOutput {
	s.Id = &v
	return s
}

// SetInfluxAuthParametersSecretArn sets the InfluxAuthParametersSecretArn field's value.
func (s *UpdateDbInstanceOutput) SetInfluxAuthParametersSecretArn(v string) *UpdateDbInstanceOutput {
	s.InfluxAuthParametersSecretArn = &v
	return s
}

// SetLogDeliveryConfiguration sets the LogDeliveryConfiguration field's value.
func (s *UpdateDbInstanceOutput) SetLogDeliveryConfiguration(v *LogDeliveryConfiguration) *UpdateDbInstanceOutput {
	s.LogDeliveryConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDbInstanceOutput) SetName(v string) *UpdateDbInstanceOutput {
	s.Name = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *UpdateDbInstanceOutput) SetPubliclyAccessible(v bool) *UpdateDbInstanceOutput {
	s.PubliclyAccessible = &v
	return s
}

// SetSecondaryAvailabilityZone sets the SecondaryAvailabilityZone field's value.
func (s *UpdateDbInstanceOutput) SetSecondaryAvailabilityZone(v string) *UpdateDbInstanceOutput {
	s.SecondaryAvailabilityZone = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateDbInstanceOutput) SetStatus(v string) *UpdateDbInstanceOutput {
	s.Status = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *UpdateDbInstanceOutput) SetVpcSecurityGroupIds(v []*string) *UpdateDbInstanceOutput {
	s.VpcSecurityGroupIds = v
	return s
}

// SetVpcSubnetIds sets the VpcSubnetIds field's value.
func (s *UpdateDbInstanceOutput) SetVpcSubnetIds(v []*string) *UpdateDbInstanceOutput {
	s.VpcSubnetIds = v
	return s
}

// The input fails to satisfy the constraints specified by Timestream for InfluxDB.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The reason that validation failed.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// DbInstanceTypeDbInfluxMedium is a DbInstanceType enum value
	DbInstanceTypeDbInfluxMedium = "db.influx.medium"

	// DbInstanceTypeDbInfluxLarge is a DbInstanceType enum value
	DbInstanceTypeDbInfluxLarge = "db.influx.large"

	// DbInstanceTypeDbInfluxXlarge is a DbInstanceType enum value
	DbInstanceTypeDbInfluxXlarge = "db.influx.xlarge"

	// DbInstanceTypeDbInflux2xlarge is a DbInstanceType enum value
	DbInstanceTypeDbInflux2xlarge = "db.influx.2xlarge"

	// DbInstanceTypeDbInflux4xlarge is a DbInstanceType enum value
	DbInstanceTypeDbInflux4xlarge = "db.influx.4xlarge"

	// DbInstanceTypeDbInflux8xlarge is a DbInstanceType enum value
	DbInstanceTypeDbInflux8xlarge = "db.influx.8xlarge"

	// DbInstanceTypeDbInflux12xlarge is a DbInstanceType enum value
	DbInstanceTypeDbInflux12xlarge = "db.influx.12xlarge"

	// DbInstanceTypeDbInflux16xlarge is a DbInstanceType enum value
	DbInstanceTypeDbInflux16xlarge = "db.influx.16xlarge"
)

// DbInstanceType_Values returns all elements of the DbInstanceType enum
func DbInstanceType_Values() []string {
	return []string{
		DbInstanceTypeDbInfluxMedium,
		DbInstanceTypeDbInfluxLarge,
		DbInstanceTypeDbInfluxXlarge,
		DbInstanceTypeDbInflux2xlarge,
		DbInstanceTypeDbInflux4xlarge,
		DbInstanceTypeDbInflux8xlarge,
		DbInstanceTypeDbInflux12xlarge,
		DbInstanceTypeDbInflux16xlarge,
	}
}

const (
	// DbStorageTypeInfluxIoincludedT1 is a DbStorageType enum value
	DbStorageTypeInfluxIoincludedT1 = "InfluxIOIncludedT1"

	// DbStorageTypeInfluxIoincludedT2 is a DbStorageType enum value
	DbStorageTypeInfluxIoincludedT2 = "InfluxIOIncludedT2"

	// DbStorageTypeInfluxIoincludedT3 is a DbStorageType enum value
	DbStorageTypeInfluxIoincludedT3 = "InfluxIOIncludedT3"
)

// DbStorageType_Values returns all elements of the DbStorageType enum
func DbStorageType_Values() []string {
	return []string{
		DbStorageTypeInfluxIoincludedT1,
		DbStorageTypeInfluxIoincludedT2,
		DbStorageTypeInfluxIoincludedT3,
	}
}

const (
	// DeploymentTypeSingleAz is a DeploymentType enum value
	DeploymentTypeSingleAz = "SINGLE_AZ"

	// DeploymentTypeWithMultiazStandby is a DeploymentType enum value
	DeploymentTypeWithMultiazStandby = "WITH_MULTIAZ_STANDBY"
)

// DeploymentType_Values returns all elements of the DeploymentType enum
func DeploymentType_Values() []string {
	return []string{
		DeploymentTypeSingleAz,
		DeploymentTypeWithMultiazStandby,
	}
}

const (
	// LogLevelDebug is a LogLevel enum value
	LogLevelDebug = "debug"

	// LogLevelInfo is a LogLevel enum value
	LogLevelInfo = "info"

	// LogLevelError is a LogLevel enum value
	LogLevelError = "error"
)

// LogLevel_Values returns all elements of the LogLevel enum
func LogLevel_Values() []string {
	return []string{
		LogLevelDebug,
		LogLevelInfo,
		LogLevelError,
	}
}

const (
	// StatusCreating is a Status enum value
	StatusCreating = "CREATING"

	// StatusAvailable is a Status enum value
	StatusAvailable = "AVAILABLE"

	// StatusDeleting is a Status enum value
	StatusDeleting = "DELETING"

	// StatusModifying is a Status enum value
	StatusModifying = "MODIFYING"

	// StatusUpdating is a Status enum value
	StatusUpdating = "UPDATING"

	// StatusDeleted is a Status enum value
	StatusDeleted = "DELETED"

	// StatusFailed is a Status enum value
	StatusFailed = "FAILED"
)

// Status_Values returns all elements of the Status enum
func Status_Values() []string {
	return []string{
		StatusCreating,
		StatusAvailable,
		StatusDeleting,
		StatusModifying,
		StatusUpdating,
		StatusDeleted,
		StatusFailed,
	}
}

const (
	// TracingTypeLog is a TracingType enum value
	TracingTypeLog = "log"

	// TracingTypeJaeger is a TracingType enum value
	TracingTypeJaeger = "jaeger"
)

// TracingType_Values returns all elements of the TracingType enum
func TracingType_Values() []string {
	return []string{
		TracingTypeLog,
		TracingTypeJaeger,
	}
}

const (
	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
